IF object_id('PosixGetPartial') IS NOT NULL
	DROP PROCEDURE PosixGetPartial
GO

IF object_id('PosixFullNegSync') IS NOT NULL
	DROP PROCEDURE PosixFullNegSync
GO

IF object_id('PosixAccountServers') IS NULL
BEGIN
CREATE TABLE dbo.PosixAccountServers (
	PosixAccountServerID int IDENTITY (1, 1) NOT NULL,
	LDAPServer varchar (50) NOT NULL,
	AccountTypeID varchar (20) NOT NULL,
	gidNumber int NOT NULL,
	loginShell varchar (100) NOT NULL,
	homeDirectory varchar (100) NOT NULL,
	CONSTRAINT PK_PAS_LDAPServer_AccountType PRIMARY KEY CLUSTERED 
	(LDAPServer,AccountTypeID)
)
CREATE INDEX i_PosixAccountServers_ID ON dbo.PosixAccountServers(PosixAccountServerID)
END
go

IF object_id('PosixAccountUIDs') IS NULL
BEGIN
CREATE TABLE dbo.PosixAccountUIDs (
	uidNumber int NOT NULL,
	PosixAccountUserID int NULL,
	LDAPServer VARCHAR(50) NOT NULL,
	CONSTRAINT PK_PAI_uidNumber_LDAPServer PRIMARY KEY CLUSTERED
	(uidNumber,LDAPServer)
)
CREATE INDEX i_PosixAccountUIDs_PAUID ON dbo.PosixAccountUIDs(PosixAccountUserID)
CREATE  INDEX i_PAU_uidNumber ON dbo.PosixAccountUIDs(uidNumber)
END
go

IF object_id('PosixAccountUsers') IS NULL
BEGIN
CREATE TABLE dbo.PosixAccountUsers (
	PosixAccountUserID int IDENTITY (1, 1) NOT NULL,
	PosixAccountServerID int NOT NULL,
	AccountID int NOT NULL,
	gidNumber int NULL,
	loginShell varchar (100) NULL,
	homeDirectory varchar (100) NULL,
	userPassword varchar (50) NULL,
	CONSTRAINT PK_PAU_AccountID PRIMARY KEY CLUSTERED 
	(AccountID)
)
CREATE INDEX i_PosixAccountUsers_ID ON dbo.PosixAccountUsers(PosixAccountUserID)
CREATE INDEX i_PosixAccountUsers_SrvrID ON dbo.PosixAccountUsers(PosixAccountServerID)
END
go

CREATE PROCEDURE PosixGetPartial @id VARCHAR(50) AS
/* Read & Set Last Retreive Date */
DECLARE @lmdate DATETIME, @calls INT, @pasid INT, @pasuid INT, @accountid INT, @uid INT
EXEC LDAPSetLastModifyDate 'read', @id
SELECT @lmdate = LastSyncWrite, @calls = Calls
FROM LDAPServers
	WHERE LDAPServer = @id

/* Find the lowest avaliable uidNumber and assign it. */

/* Starting UID */
SELECT @uid = 1000
IF NOT EXISTS (SELECT * FROM PosixAccountUIDs WHERE LDAPServer = @id)
BEGIN
WHILE(@uid < 65535)
	BEGIN
	INSERT INTO PosixAccountUIDs (uidNumber,PosixAccountUserID,LDAPServer)
	VALUES(@uid,NULL,@id)
	SELECT @uid = @uid + 1
	END
END

DECLARE onebyone CURSOR FOR
SELECT sa.AccountID
FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1, PosixAccountServers pas
	WHERE sa.CustomerID = ma.CustomerID
	AND NOT EXISTS (SELECT 1 FROM PosixAccountUsers pau2, PosixAccountUIDs pai2 (INDEX = i_PosixAccountUIDs_PAUID) WHERE AccountID = sa.AccountID AND pau2.PosixAccountUserID = pai2.PosixAccountUserID AND pai2.LDAPServer = @id)
	AND sa.AccountTypeID = at1.AccountTypeID
	AND sa.AccountTypeID = pas.AccountTypeID
	AND pas.LDAPServer = @id
	AND sa.Password <> ''
	AND (sa.LastModifyDate > @lmdate OR ma.LastModifyDate > @lmdate)

OPEN onebyone
FETCH NEXT FROM onebyone INTO @accountid
WHILE(@@FETCH_STATUS <> -1)
BEGIN
SELECT @uid = NULL, @pasuid = NULL, @pasid = NULL

SELECT @uid = MIN(uidNumber) FROM PosixAccountUIDs
	WHERE PosixAccountUserID IS NULL
	AND LDAPServer = @id

SELECT @pasid = PosixAccountServerID
FROM PosixAccountServers pas, SubAccounts sa
	WHERE sa.AccountID = @accountid
	AND pas.AccountTypeID = sa.AccountTypeID

INSERT INTO PosixAccountUsers (PosixAccountServerID,AccountID)
	VALUES(@pasid,@accountid)

SELECT @pasuid = PosixAccountUserID FROM PosixAccountUsers
	WHERE AccountID = @accountid

IF (@pasuid IS NOT NULL)
SELECT @uid = uidNumber FROM PosixAccountUIDs
	WHERE PosixAccountUserID = @pasuid
	AND LDAPServer = @id

UPDATE PosixAccountUIDs
	SET PosixAccountUserID = @pasuid
		WHERE uidNumber = @uid
		AND LDAPServer = @id

IF NOT EXISTS (SELECT 1 FROM PosixAccountUsers pau, PosixAccountUIDs pai
		WHERE pai.PosixAccountUserID = pau.PosixAccountUserID)
BEGIN
RAISERROR('UID Assignment Failed. Make sure all 65535 UIDs are not in use',10,1,50000)
END

FETCH NEXT FROM onebyone INTO @accountid
END
CLOSE onebyone
DEALLOCATE onebyone

/* Periodically remove deleted entries to free up uids. */
IF @calls % 50 = 0
BEGIN
DELETE FROM pau
FROM PosixAccountUsers pau
WHERE NOT EXISTS (SELECT 1 FROM SubAccounts WHERE AccountID = pau.AccountID)

UPDATE pai SET PosixAccountUserID = NULL
FROM PosixAccountUIDs pai
	WHERE NOT EXISTS (SELECT 1 FROM PosixAccountUsers WHERE PosixAccountUserID = pai.PosixAccountUserID)
	AND PosixAccountUserID IS NOT NULL
	AND LDAPServer = @id
END

/* Output Query Result */
SELECT DISTINCT sa.AccountID as accountid, pai.uidNumber AS uidnumber,
shadowexpire = CASE
	WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 1
	WHEN ma.CancelDate < getdate() THEN 1
	WHEN ma.OverLimit > 0 THEN NULL
	WHEN sa.ExpireDate IS NULL THEN
		DATEDIFF(dd,'Jan 1 1970',DATEADD(dd,ma.OverDue+sa.Extension+1,sa.ExpireDate))
	ELSE 
		DATEDIFF(dd,'Jan 1 1970',DATEADD(dd,ma.OverDue+sa.Extension+1,sa.ExpireDate))
END,
rfc822mailbox = CASE WHEN al.Alias IS NOT NULL THEN NULL ELSE COALESCE(sa.Email,sa.Login + '@' + d.MailDomain) END,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
COALESCE(sa.FirstName,'') + ' ' + COALESCE(sa.LastName,'') AS cn,
COALESCE(sa.LastName,'N/A') as sn,
COALESCE(sa.FirstName,'N/A') as gn,
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE NULL END AS uid,
CASE WHEN pau.userPassword <> '' THEN pau.UserPassword ELSE sa.Password END AS userpassword,
CASE WHEN pau.loginShell <> '' THEN pau.loginShell ELSE pas.loginShell END AS loginshell,
CASE WHEN pau.gidNumber IS NOT NULL THEN pau.gidNumber ELSE pas.gidNumber END AS gidNumber,
CASE WHEN pau.homeDirectory <> '' THEN pau.homeDirectory ELSE pas.homeDirectory + '/' + CASE WHEN sa.Login IS NOT NULL OR sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE NULL END END AS homedirectory

FROM SubAccounts sa, MasterAccounts ma, Domains d, AccountTypes at1, Forwards fw, Aliases al, PosixAccountUsers pau, PosixAccountServers pas, PosixAccountUIDs pai (INDEX = i_PosixAccountUIDs_PAUID)
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.DomainID = d.DomainID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND sa.Password <> ''
	AND (sa.LastModifyDate > @lmdate OR ma.LastModifyDate > @lmdate)
	AND sa.AccountID *= fw.AccountID
	AND sa.AccountID *= al.AccountID
	AND pas.AccountTypeID = sa.AccountTypeID
	AND pas.PosixAccountServerID = pau.PosixAccountServerID
	AND pau.PosixAccountUserID = pai.PosixAccountUserID
	AND pau.AccountID = sa.AccountID
	AND pas.LDAPServer = @id
go

CREATE PROCEDURE PosixFullNegSync @id VARCHAR(50) AS
SELECT uidNumber 
FROM PosixAccountUIDs 
	WHERE PosixAccountUserID IS NOT NULL
	AND LDAPServer = @id
go

GRANT EXECUTE ON PosixGetPartial TO EmeraldApps
GRANT EXECUTE ON PosixFullNegSync TO EmeraldApps
go

