IF object_id('MDFullNegSync') IS NOT NULL
	DROP PROCEDURE MDFullNegSync
GO

IF object_id('MDGetPartial') IS NOT NULL
	DROP PROCEDURE MDGetPartial
GO

CREATE PROCEDURE MDGetPartial @id VARCHAR(50) AS
EXEC LDAPSetLastModifyDate 'read', @id
SELECT DISTINCT
sa.AccountID AS x121Address,
sa.AccountID AS accountid,
sa.FirstName + ' ' + sa.LastName AS cn,
sa.FirstName + ' ' + sa.LastName AS mdFullName,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mdForwardAddress,
'N' AS mdKeepForwardedMail,
CASE WHEN fw.Forward IS NULL THEN 'N' ELSE 'Y' END AS mdIsForwarding,
es.MailHost AS mailHost,
sa.Password AS mdPassword,

CASE WHEN sa.Active = 0 OR ma.Active = 0 THEN 'N' ELSE
	CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 'N'
	WHEN ma.OverLimit > 0 THEN 'Y'
	WHEN sa.ExpireDate IS NULL AND ma.CancelDate < getdate() THEN 'N'
	WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,ma.OverDue+sa.Extension+1,sa.ExpireDate) < getdate() THEN 'N'
	ELSE 'Y' END
END AS mdAllowAccess,

CASE WHEN sa.Email LIKE '%@%' THEN
sa.Email ELSE CASE WHEN sa.Email <> '' THEN sa.Email ELSE sa.Login END + '@' + d.MailDomain
END AS mail,
es.LogFile + '/' + CONVERT(VARCHAR(10),sa.AccountID) + '/' AS mdMailDir, 
ma.Address1 AS mdHomeAddress,
ma.City AS mdHomeCity,
ma.State AS mdHomeState,
ma.Zip AS mdHomeZipcode,
ma.Country AS mdHomeCountry,
ma.PhoneHome AS mdHomePhone,
ma.PhoneFax AS mdHomeFax,
ma.Company AS mdBusCompany,
ma.PhoneWork AS mdBusPhone

FROM MasterAccounts ma, SubAccounts sa, Domains d, AccountTypes at1, Forwards fw, Aliases al, LDAPServers ls, ExternalSystems es
	WHERE ma.CustomerID = sa.CustomerID
	AND d.DomainID = sa.DomainID
	AND (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND ls.LDAPServer = @id
	AND sa.AccountID *= fw.AccountID
	AND sa.AccountID *= al.AccountID
	AND sa.Password <> ''
	AND (sa.Email <> '' OR sa.Login <> '')
	AND es.Name = @id
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = es.ExternalSystemID
go

CREATE PROCEDURE MDFullNegSync @id VARCHAR(50) AS
SELECT CASE WHEN sa.Email LIKE '%@%' THEN sa.Email ELSE CASE WHEN sa.Email <> '' THEN sa.Email ELSE sa.Login END + '@' + d.MailDomain END

FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1, Domains d, ExternalSystems es
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.DomainID = d.DomainID
	AND (sa.Login <> '' OR sa.Email <> '')
	AND sa.Password <> ''
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = es.ExternalSystemID
	AND es.Name = @id
go

/* Permissions */
GRANT EXECUTE ON MDFullNegSync TO Emerald
GRANT EXECUTE ON MDGetPartial TO Emerald
go
