IF object_id('FTSEnabled') IS NOT NULL
	DROP PROCEDURE FTSEnabled
GO

CREATE PROCEDURE dbo.FTSEnabled AS
Select CASE WHEN (Select fulltextserviceproperty('IsFulltextInstalled')) = 1 AND 
		(Select DATABASEPROPERTY(db_name(), 'IsFulltextEnabled' ) ) = 1
		THEN 1 ELSE 0 END AS Enabled
GO

GRANT EXECUTE ON FTSEnabled TO Emerald
GO

IF object_id('FTSIndex') IS NOT NULL
	DROP PROCEDURE FTSIndex
GO

CREATE PROCEDURE dbo.FTSIndex AS
IF ((Select fulltextserviceproperty('IsFulltextInstalled')) = 1 AND (Select DATABASEPROPERTY(db_name(), 'IsFulltextEnabled' ) ) = 1)
	EXEC sp_fulltext_catalog 'EmeraldCatalog', 'start_incremental'
GO

GRANT EXECUTE ON FTSEnabled TO Emerald
GO

IF (SELECT COUNT(*) FROM Schedules WHERE Parameter = '{CALL FTSIndex}' AND TaskName = 'query') = 0
	INSERT INTO Schedules (Parameter,LastStart,Status,Description,Interval,MaxConcurrent,StartDate,Operator,LockServerID,ScheduleServerID,TaskName,MaxSecs,Aligned,TargetSecs,Server,LastUpdate,LastStatus,LastModifyDate,LastModifyUser,Active) VALUES('{CALL FTSIndex}',NULL,0,'Incidents incremental FTS reindex',21600,1,'20000101','admin',NULL,NULL,'query',NULL,1,NULL,NULL,NULL,NULL,'20000101','admin',0)
GO

IF object_id('UpdateStatementAging') IS NOT NULL
	DROP PROCEDURE UpdateStatementAging
GO

CREATE PROCEDURE dbo.UpdateStatementAging(@sid int, @custid int, @endbal numeric(18,4)) AS

SET NOCOUNT ON

DECLARE @bal numeric(18,4), @a0 numeric(18,4), @a1 numeric(18,4), @a2 numeric(18,4), @a3 numeric(18,4), @a4 numeric(18,4)
DECLARE @idays int, @amount numeric(18,4), @done int

Select @a0=0, @a1=0, @a2=0, @a3=0, @a4=0, @done=0, @bal=@endbal

if @bal <> 0
BEGIN
DECLARE ud_cursor CURSOR FOR 
Select DateDiff(Day, i.CreateDate, ISNULL(AgedDate, GetDate())), Amount=(ii.Amount*Quantity)
From Invoices i, InvoiceItems ii, MasterAccounts ma
Where i.InvoiceID = ii.InvoiceID
	and i.CustomerID = ma.CustomerID
	and i.CustomerID = @custid
	and i.InvoiceTypeID <> 0
Order By i.CreateDate DESC

OPEN ud_cursor

FETCH NEXT FROM ud_cursor INTO @idays, @amount
WHILE (@@fetch_status <> -1 and @done = 0 )
	BEGIN

	if @amount > @bal (select @amount = @bal, @done = 1)
	if @bal <= 0 (select @amount = @bal, @done = 1, @idays = 0)

	if @idays <= 29 (select @a0=@a0+@amount)
	else if @idays <= 59 (select @a1=@a1+@amount)
	else if @idays <= 89 (select @a2=@a2+@amount)
	else if @idays <= 119 (select @a3=@a3+@amount)
	else (select @a4=@a4+@amount)

	select @bal = @bal - @amount
	
	FETCH NEXT FROM ud_cursor INTO @idays, @amount
	END

CLOSE ud_cursor
DEALLOCATE ud_cursor
END

Update Statements
Set EndBal = @endbal, End0Bal = @a0, End30Bal = @a1, End60Bal = @a2, End90Bal = @a3, End120Bal = @a4
Where StatementID = @sid

GO

GRANT EXECUTE ON UpdateStatementAging TO Emerald
GO


-- IMail web access, 'MaxSize' vs 'Max Mailbox Size' and overlimit pending updates
IF object_id('IMailUsers') IS NOT NULL
	DROP PROCEDURE IMailUsers
GO

CREATE PROCEDURE dbo.IMailUsers @esid INT, @username varchar(40), @domain varchar(64) AS
DECLARE @DomainID INT, @AccountID INT
SET NOCOUNT ON

SELECT @DomainID = DomainID FROM Domains WHERE MailDomain = @domain

IF (@username IS NULL) /* List all users in domain */
BEGIN

SELECT sa.AccountID, 
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE @username END AS Login,
sa.Password, sa.FirstName + ' ' + sa.LastName AS Name,
CASE WHEN sa.Email IS NULL OR sa.Email = '' THEN sa.Login + '@' + @domain WHEN sa.Email <> '' THEN sa.Email ELSE NULL END AS MailAddress,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'UserDir') AS UserDir,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'NumTries') AS NumTries,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'AttemptTime') AS AttemptTime,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'NumTimesSuspended') AS NumTimesSuspended,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'LastLogin') AS LastLogin,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'SuspendUserAccount') AS SuspendUserAccount,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'ICalEnable') AS ICalEnable,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'SpellEnable') AS SpellEnable,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'NoOfSuggestions') AS NoOfSuggestions,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'Depth') AS Depth,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'Options') AS Options,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'SpellChecking') AS SpellChecking,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'PreviewSize') AS PreviewSize,

(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'ConfirmOnDelete') AS ConfirmOnDelete,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'DisplayCompletedTasks') AS DisplayCompletedTasks,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'EntryGranularity') AS EntryGranularity,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'StartTime') AS StartTime,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'EndTime') AS EndTime,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'MaxEventsToDisplay') AS MaxEventsToDisplay,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'MaxTasksToDisplay') AS MaxTasksToDisplay,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'MaxNotesToDisplay') AS MaxNotesToDisplay,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'MaxDailyRecurCount') AS MaxDailyRecurCount,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'MaxWeeklyRecurCount') AS MaxWeeklyRecurCount,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'MaxMonthlyRecurCount') AS MaxMonthlyRecurCount,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'MaxYearlyRecurCount') AS MaxYearlyRecurCount,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'HoursClock') AS HoursClock,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'MaxNoOfSearchResultsPerPage') AS MaxNoOfSearchResultsPerPage,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'MaxEventTitleLength') AS MaxEventTitleLength,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'MaxTaskTitleLength') AS MaxTaskTitleLength,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'StartDay') AS StartDay,

(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'Max Mailbox Size') AS MaxSize,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'MaxMessages') AS MaxMessages,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'Type') AS Type,
COALESCE((SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'Flags'),'128') AS Flags,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'DefaultView') AS DefaultView,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'DefCalName') AS DefCalName,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'TimeZone') AS TimeZone,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'NumNotify') AS NumNotify,
(SELECT Data FROM SubAccountDataTypes sadt, SubAccountData sad WHERE sad.DataTypeID = sadt.DataTypeID AND sadt.ExternalSystemType = -2 AND sad.AccountID = sa.AccountID AND sadt.Description = 'LastNotify') AS LastNotify

FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1
	WHERE sa.CustomerID = ma.CustomerID 
	AND sa.Password <> ''
	AND ((sa.Login <> '' AND sa.DomainID = @DomainID) 
		OR (sa.Email LIKE '%_@' + @domain))
	AND at1.AccountTypeID = sa.AccountTypeID
	AND at1.ExternalSystemID = @esid
	AND sa.Active = 1
	AND ma.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > GETDATE())
	AND ma.StartDate < GETDATE()

END ELSE BEGIN /* Lookup user */

SELECT @AccountID = sa.AccountID
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1 (NOLOCK)
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.Active = 1 
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > getdate())
	AND ((sa.Login = @username AND sa.DomainID = @DomainID) 
		OR (@username + '@' + @domain = sa.Email)
		OR (@username + '@' + @domain IN (SELECT Alias FROM Aliases WHERE AccountID = sa.AccountID)))
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.ExternalSystemID = @esid

SELECT sadt.Description, sad.Data INTO #settings
FROM SubAccountData sad (NOLOCK), SubAccountDataTypes sadt (NOLOCK) 
	WHERE sad.DataTypeID = sadt.DataTypeID 
	AND sadt.ExternalSystemType = -2
	AND sad.AccountID = @AccountID
	AND sad.Data IS NOT NULL

CREATE INDEX i_settings_Description ON #settings (Description)

SELECT sa.AccountID, 
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> '' THEN sa.Login WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE @username END AS Login,
sa.Password, sa.FirstName + ' ' + sa.LastName AS Name, 
CASE WHEN sa.Email IS NULL OR sa.Email = '' THEN sa.Login + '@' + @domain WHEN sa.Email <> '' THEN sa.Email ELSE NULL END AS MailAddress,
(SELECT Data FROM #settings WHERE Description = 'UserDir') AS UserDir,
(SELECT Data FROM #settings WHERE Description = 'NumTries') AS NumTries,
(SELECT Data FROM #settings WHERE Description = 'AttemptTime') AS AttemptTime,
(SELECT Data FROM #settings WHERE Description = 'NumTimesSuspended') AS NumTimesSuspended,
(SELECT Data FROM #settings WHERE Description = 'LastLogin') AS LastLogin,
(SELECT Data FROM #settings WHERE Description = 'SuspendUserAccount') AS SuspendUserAccount,
(SELECT Data FROM #settings WHERE Description = 'ICalEnable') AS ICalEnable,
(SELECT Data FROM #settings WHERE Description = 'SpellEnable') AS SpellEnable,
(SELECT Data FROM #settings WHERE Description = 'NoOfSuggestions') AS NoOfSuggestions,
(SELECT Data FROM #settings WHERE Description = 'Depth') AS Depth,
(SELECT Data FROM #settings WHERE Description = 'Options') AS Options,
(SELECT Data FROM #settings WHERE Description = 'SpellChecking') AS SpellChecking,
(SELECT Data FROM #settings WHERE Description = 'PreviewSize') AS PreviewSize,
(SELECT Data FROM #settings WHERE Description = 'ConfirmOnDelete') AS ConfirmOnDelete,
(SELECT Data FROM #settings WHERE Description = 'DisplayCompletedTasks') AS DisplayCompletedTasks,
(SELECT Data FROM #settings WHERE Description = 'EntryGranularity') AS EntryGranularity,
(SELECT Data FROM #settings WHERE Description = 'StartTime') AS StartTime,
(SELECT Data FROM #settings WHERE Description = 'EndTime') AS EndTime,
(SELECT Data FROM #settings WHERE Description = 'MaxEventsToDisplay') AS MaxEventsToDisplay,
(SELECT Data FROM #settings WHERE Description = 'MaxTasksToDisplay') AS MaxTasksToDisplay,
(SELECT Data FROM #settings WHERE Description = 'MaxNotesToDisplay') AS MaxNotesToDisplay,
(SELECT Data FROM #settings WHERE Description = 'MaxDailyRecurCount') AS MaxDailyRecurCount,
(SELECT Data FROM #settings WHERE Description = 'MaxWeeklyRecurCount') AS MaxWeeklyRecurCount,
(SELECT Data FROM #settings WHERE Description = 'MaxMonthlyRecurCount') AS MaxMonthlyRecurCount,
(SELECT Data FROM #settings WHERE Description = 'MaxYearlyRecurCount') AS MaxYearlyRecurCount,
(SELECT Data FROM #settings WHERE Description = 'HoursClock') AS HoursClock,
(SELECT Data FROM #settings WHERE Description = 'MaxNoOfSearchResultsPerPage') AS MaxNoOfSearchResultsPerPage,
(SELECT Data FROM #settings WHERE Description = 'MaxEventTitleLength') AS MaxEventTitleLength,
(SELECT Data FROM #settings WHERE Description = 'MaxTaskTitleLength') AS MaxTaskTitleLength,
(SELECT Data FROM #settings WHERE Description = 'StartDay') AS StartDay,
(SELECT Data FROM #settings WHERE Description = 'Max Mailbox Size') AS MaxSize,
(SELECT Data FROM #settings WHERE Description = 'MaxMessages') AS MaxMessages,
COALESCE((SELECT Data FROM #settings WHERE Description = 'Flags'),'128') AS Flags,
(SELECT Data FROM #settings WHERE Description = 'Type') AS Type,
(SELECT Data FROM #settings WHERE Description = 'DefaultView') AS DefaultView,
(SELECT Data FROM #settings WHERE Description = 'DefCalName') AS DefCalName,
(SELECT Data FROM #settings WHERE Description = 'TimeZone') AS TimeZone
FROM SubAccounts sa
	WHERE sa.AccountID = @AccountID

DROP TABLE #settings
END
GO
GRANT EXECUTE ON IMailUsers TO Emerald
GO

IF object_id('MetaAddObjectTable') IS NOT NULL
	DROP PROCEDURE MetaAddObjectTable
GO

CREATE PROCEDURE dbo.MetaAddObjectTable @objectgroup varchar(32), @table VARCHAR(32), @addcols int AS
DECLARE @mtid int, @ogid int

Select @mtid = ISNULL(MetaTableID,0) 
From MetaTables
Where TableName = @table

Select @ogid = ISNULL(ObjectGroupID,0) 
From ObjectGroups
Where ObjectGroup = @objectgroup

if (@mtid > 0 and @ogid > 0)
BEGIN
	INSERT INTO Objects (ObjectGroupID, Value, ObjectTypeID)
	SELECT @ogid, @mtid, 2 
	WHERE NOT EXISTS (SELECT * FROM Objects WHERE ObjectGroupID = @ogid AND @mtid = Value AND ObjectTypeID = 2)
	
	if @addcols = 1
	BEGIN
		INSERT INTO Objects (ObjectGroupID,Value,ObjectTypeID)
		SELECT @ogid, mc.MetaColumnID, 3 
		FROM MetaColumns mc
			WHERE mc.MetaTableID = @mtid
			AND mc.MetaColumnID NOT IN 
				(SELECT o.Value FROM Objects o 
				WHERE o.ObjectGroupID = @ogid AND o.ObjectTypeID = 3)

	END
END
ELSE
	RAISERROR('Could not find Table or Object',11,1)
GO
GRANT EXECUTE ON MetaAddObjectTable TO Emerald
GO

IF object_id('DeleteMasterAccount') IS NOT NULL
	DROP PROCEDURE DeleteMasterAccount
GO

CREATE PROCEDURE dbo.DeleteMasterAccount @customerid INT AS
DECLARE @aid int

IF @customerid IS NULL RETURN

CREATE TABLE #summary (Description VARCHAR(100) NOT NULL)

IF ((SELECT COUNT(*) FROM SubAccounts WHERE CustomerID = @customerid) > 0)
	BEGIN
	
	DECLARE s_cursor CURSOR
	FOR Select AccountID From SubAccounts Where CustomerID = @customerid
	
	OPEN s_cursor
	
	FETCH NEXT FROM s_cursor INTO @aid
	WHILE (@@fetch_status <> -1)
		BEGIN
		Exec DeleteSubAccount @aid, 1
	
		FETCH NEXT FROM s_cursor INTO @aid
		END
	
	CLOSE s_cursor
	DEALLOCATE s_cursor
	
	END

Update MasterAccounts Set LastStatementID = NULL Where CustomerID = @customerid

DELETE FROM Charges WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Charges')

/* DELETE FROM GroupAccess WHERE CustomerID = @customerid */
/* INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from GroupAccess') */

DELETE FROM InvoiceItems WHERE InvoiceID IN (SELECT InvoiceID FROM Invoices WHERE CustomerID = @customerid)
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Invoice Items')

DELETE FROM ExternalTrans WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from External Transactions')

DELETE FROM Payments WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Payments')

DELETE FROM BankTrans WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Bank Transactions')

DELETE FROM Invoices WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Invoices')

DELETE FROM MailLogs WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Mail Logs')

DELETE FROM StatementNotes WHERE StatementID IN (Select StatementID From Statements Where CustomerID = @customerid)
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from StatementNotes')

DELETE FROM Statements 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Statements')

DELETE FROM LateNotices WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from LateNotices')

DELETE FROM CreditCards WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from CreditCards')

DELETE FROM BankTrans 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from BankTrans')

DELETE FROM Addresses 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Addresses')

DELETE FROM MasterAccountData 	WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Custom Data')

DELETE FROM MasterAccounts WHERE CustomerID = @customerid
INSERT INTO #summary (Description) VALUES(CONVERT(VARCHAR(10),@@rowcount) + ' record(s) removed from Master Accounts')

INSERT INTO #summary (Description) VALUES('Master Account #' + CONVERT(VARCHAR(15),@customerid) + ' Deleted successfully')

SELECT * FROM #summary
DROP TABLE #summary
GO
GRANT EXECUTE ON DeleteMasterAccount TO Emerald
GO


IF object_id('AddMetaTable') IS NOT NULL
	DROP PROCEDURE AddMetaTable
GO

CREATE PROCEDURE dbo.AddMetaTable (@tabname varchar(64)) AS
Declare @t varchar(72), @cname varchar(64), @mcid int

Insert Into MetaTables(TableName,Description, GroupMetaTableID)
Select TableName=Convert(varchar,name), 'N/A' AS Description, NULL
From sysobjects
Where type = 'U'
	and name = @tabname
	AND @tabname NOT IN (SELECT TableName FROM MetaTables)

INSERT INTO MetaColumns(DepTable,Required,MaxSize,Quoted,Description,IsKey,DepGroup,DepColumn,MetaRuleID,MetaTableID,MinSize,Nullable,ColumnName)
Select NULL as DepTable, CASE When (sc.status & 128) = 128 or cdefault <> 0 or st.name = 'timestamp' then 0 else ( 
		Case isnullable when 0 then 1 else 0 END ) END as Required, 
	CASE WHEN st.name in ('varchar', 'char') THEN sc.length ELSE 0 END as MaxSize,
	CASE WHEN st.name in ('varchar', 'char', 'text', 'datetime', 'smalldatetime' ) THEN 1 ELSE 0 END as Quoted,
	'N/A' AS Description,
	CASE (sc.status & 128) When 128 then 1 else 0 END  as IsKey, NULL as DepGroup, NULL as DepColumn, 	
	CASE WHEN st.name in ('datetime') THEN 7 ELSE NULL END as MetaRuleID, mt.MetaTableID, 
	0 as MinSize, isnullable as Nullable, Convert(varchar, sc.name) as ColumnName
From syscolumns sc, sysobjects so, MetaTables mt, systypes st
where sc.id = so.id
	and so.name = mt.TableName
	and sc.xtype = st.xtype
	and so.name = @tabname
	AND CONVERT(VARCHAR,sc.name) NOT IN (SELECT ColumnName FROM MetaColumns WHERE MetaTableID = mt.MetaTableID)

Update mc
Set DepTable=rt.name, DepColumn=rc.name
From sysreferences sr, syscolumns fc, sysobjects ft, syscolumns rc, sysobjects rt, MetaColumns mc, MetaTables mt
Where ft.id = fkeyid
	and fc.id = fkeyid	
	and fc.colid = fkey1

	and rt.id = rkeyid
	and rc.id = rkeyid	
	and rc.colid = rkey1

	and ft.name = mt.TableName
	and fc.name = mc.ColumnName
	and mc.MetaTableID = mt.MetaTableID

	and ft.name = @tabname
	AND mc.DepTable IS NULL
	AND mc.DepColumn IS NULL

Update mc Set Required=0
From syscolumns sc, sysobjects so, MetaColumns mc, MetaTables mt
Where so.name = mt.TableName
	and sc.name = mc.ColumnName
	and mc.MetaTableID = mt.MetaTableID
	and so.id = sc.id
	and so.type = 'U'
	and sc.cdefault > 0
	and mt.TableName = @tabname

Update mc Set IsKey = 1
From sysindexes i, syscolumns c, sysobjects o, MetaTables mt, MetaColumns mc
Where o.id = c.id
	and o.id = i.id
	and (i.status & 2048) = 2048
	and (c.name = index_col (o.name, i.indid,  1) or
	     c.name = index_col (o.name, i.indid,  2) or
	     c.name = index_col (o.name, i.indid,  3) or
	     c.name = index_col (o.name, i.indid,  4) or
	     c.name = index_col (o.name, i.indid,  5) or
	     c.name = index_col (o.name, i.indid,  6)
	    )
	and mc.MetaTableID = mt.MetaTableID
	and mc.ColumnName = c.name
	and mt.TableName = o.name
	and mt.TableName = @tabname

EXEC TabName2Description @tabname, @t OUTPUT
Update MetaTables Set Description = @t Where TableName = @tabname AND Description = 'N/A'

DECLARE clist CURSOR FOR
SELECT MetaColumnID, ColumnName
FROM MetaColumns mc, MetaTables mt
Where mc.MetaTableID = mt.MetaTableID
	AND mt.TableName = @tabname

OPEN clist
FETCH NEXT FROM clist INTO @mcid, @cname
WHILE(@@FETCH_STATUS <> -1)
	BEGIN
	EXEC TabName2Description @cname, @t OUTPUT

	Update MetaColumns Set Description = @t Where MetaColumnID = @mcid AND Description = 'N/A'

	FETCH NEXT FROM clist INTO @mcid, @cname
	END

close clist
deallocate clist
GO
GRANT EXECUTE ON AddMetaTable TO Emerald
GO

IF object_id('MetaAddObjectFile') IS NOT NULL
	DROP PROCEDURE MetaAddObjectFile
GO

CREATE PROCEDURE dbo.MetaAddObjectFile @ObjectGroup VARCHAR(32), @filename VARCHAR(128) AS
DECLARE @ObjectGroupID INT
SELECT @ObjectGroupID = ObjectGroupID FROM ObjectGroups WHERE ObjectGroup = @ObjectGroup

IF @ObjectGroupID IS NOT NULL
BEGIN
	IF (SELECT COUNT(*) FROM Objects WHERE ObjectGroupID = @ObjectGroupID AND Data = @filename AND ObjectTypeID = 1) = 0
		INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,@ObjectGroupID,@filename)
END ELSE BEGIN
	RAISERROR('Could not find Object Group',11,1)
END
GO
GRANT EXECUTE ON MetaAddObjectFile TO Emerald
GO

-- Update MetaAddObjectColumn Proc.
IF object_id('MetaAddObjectColumn') IS NOT NULL
	DROP PROCEDURE MetaAddObjectColumn
GO

CREATE PROCEDURE dbo.MetaAddObjectColumn @objectgroup varchar(32), @table VARCHAR(32), @column varchar(32) AS
DECLARE @mtid INT, @ogid INT, @colid INT

Select @mtid = ISNULL(mt.MetaTableID,0), @colid = ISNULL(mc.MetaColumnID,0)
FROM MetaTables mt, MetaColumns mc
	WHERE mt.TableName = @table
	AND mt.MetaTableID *= mc.MetaTableID
	AND mc.ColumnName = @column

Select @ogid = ISNULL(ObjectGroupID,0) 
From ObjectGroups
Where ObjectGroup = @objectgroup

if (@mtid > 0 and @ogid > 0 AND @colid > 0)
	BEGIN
	INSERT INTO Objects (ObjectGroupID,Value,ObjectTypeID)
	SELECT @ogid, mc.MetaColumnID, 3 
	FROM MetaColumns mc
		WHERE mc.MetaTableID = @mtid
		AND mc.MetaColumnID = @colid
		AND mc.MetaColumnID NOT IN 
			(SELECT o.Value FROM Objects o 
			WHERE o.ObjectGroupID = @ogid AND o.ObjectTypeID = 3)
	END ELSE
	BEGIN
	RAISERROR('Object Group/Table/Column not found',11,1)
	END
GO

GRANT EXECUTE ON MetaAddObjectColumn TO Emerald
GO

IF ((SELECT COUNT(*) FROM sysobjects so, syscolumns sc WHERE so.id = sc.id AND so.name = 'Reports' AND sc.name = 'ReportType') = 0)
	ALTER TABLE Reports ADD ReportType INT NOT NULL DEFAULT 1
GO

EXEC AddMetaTable 'Reports'
GO


IF object_id('UpdateCalls_AccountID') IS NOT NULL
	DROP PROCEDURE UpdateCalls_AccountID
GO

CREATE PROCEDURE dbo.UpdateCalls_AccountID @rtid INT AS
DECLARE @username varchar(40), @acctid int, @lastprocdate DATETIME
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT @lastprocdate = LastProcDate FROM RateTables WHERE RateTableID = @rtid
SELECT @lastprocdate = COALESCE(@lastprocdate,'Jan 1 2000')

Select Login, AccountID
Into #temp_accountlist
From SubAccounts

CREATE INDEX iTA_Login ON #temp_accountlist(Login)

Select Username, AccountID=0
Into #temp_accountupdate
From Calls
Where AccountID IS NULL
	and Username in (Select Login From #temp_accountlist)
	AND AcctStatusType = 2
	AND CallDate >= @lastprocdate
Group by Username

CREATE INDEX iTA_Username ON #temp_accountupdate(Username)

Update #temp_accountupdate
Set AccountID = (Select Min(AccountID) From #temp_accountlist
	 Where Username = Login)

DECLARE cu_cursor CURSOR
FOR Select Username, AccountID From #temp_accountupdate

OPEN cu_cursor

FETCH NEXT FROM cu_cursor INTO @username, @acctid
WHILE (@@fetch_status <> -1)
	BEGIN
	Update Calls
	Set AccountID = @acctid
		WHERE AccountID is NULL
		AND Username = @username
		AND AcctStatusType = 2
		AND CallDate >= @lastprocdate
	FETCH NEXT FROM cu_cursor INTO @username, @acctid
	END

CLOSE cu_cursor
DEALLOCATE cu_cursor

DROP TABLE #temp_accountlist
DROP TABLE #temp_accountupdate
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
GO
