-- Emerald 4.0 Upgrade script to update an Emerald v4 database with changes made since it's initial release.

-- StartDate and CancelDate should not include time of day
UPDATE MasterAccounts SET StartDate = DATEADD(ss,-((DATEPART(hh,StartDate) * 3600) + (DatePart(mi,StartDate) * 60) + DatePart(ss,StartDate)),StartDate) 
	FROM MasterAccounts
	WHERE DATEPART(hh,StartDate) + DATEPART(mi,StartDate) + DATEPART(ss,StartDate) > 0

UPDATE MasterAccounts SET CancelDate = DATEADD(ss,-((DATEPART(hh,CancelDate) * 3600) + (DatePart(mi,CancelDate) * 60) + DatePart(ss,CancelDate)),CancelDate) 
	FROM MasterAccounts
	WHERE DATEPART(hh,CancelDate) + DATEPART(mi,CancelDate) + DATEPART(ss,CancelDate) > 0

-- Security update for missing alias and forward permissions
IF ((SELECT COUNT(*) FROM OperatorGroupAccess WHERE GroupID = 1 AND OperatorGroupID = 2 AND ObjectGroupID = 102 AND AccessType = 7) > 0 
AND (SELECT COUNT(*) FROM OperatorGroupAccess WHERE GroupID = 1 AND OperatorGroupID = 2 AND ObjectGroupID = 108) = 0)
	INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(2, 1, 108, 15)

IF ((SELECT COUNT(*) FROM OperatorGroupAccess WHERE GroupID = 1 AND OperatorGroupID = 3 AND ObjectGroupID = 102 AND AccessType = 7) > 0 
AND (SELECT COUNT(*) FROM OperatorGroupAccess WHERE GroupID = 1 AND OperatorGroupID = 3 AND ObjectGroupID = 108) = 0)
	INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1, 108, 15)

-- Setup missing GroupID MetaTable references
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'Statements'
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'SubAccounts')  WHERE TableName = 'Incidents' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'Incidents')  WHERE TableName = 'Actions' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'Addresses' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'SubAccounts')  WHERE TableName = 'Aliases' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'Invoices')  WHERE TableName = 'InvoiceItems' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'SubAccounts')  WHERE TableName = 'SubAccountData' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'SubAccounts')  WHERE TableName = 'RadConfigs'
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'Invoices'
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'SubAccounts' 
GO

UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'BankTrans' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'LateNotices' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'SubAccounts')  WHERE TableName = 'RadTriggers'
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'MasterAccountData' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'CreditCards' 
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'SubAccounts')  WHERE TableName = 'Forwards'
UPDATE MetaTables SET GroupMetaTableID = (SELECT MetaTableID FROM MetaTables WHERE TableName = 'MasterAccounts')  WHERE TableName = 'Payments'
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 55) <> 0
	BEGIN 
	Delete From ConfigValues Where ConfigID = 55
	Delete From Configs Where ConfigID = 55
	END
GO

IF ((SELECT COUNT(*) FROM ConfigValues WHERE ConfigID IN (1,14,18,20,27,29,59,60,74,84,92,90,97,98,360,363,364)) < 35)
BEGIN
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 18) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Default Print Format',18,18,5,2,0,NULL)
DELETE FROM ConfigValues WHERE ConfigID IN (1,14,18,20,27,29,59,60,74,84,92,90,97,98,360,363,364)
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(1,0,'Show Passwords')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(1,1,'Hide Passwords')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(14,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(14,1,'Yes')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(18,1,'HTML')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(18,2,'PDF')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(18,3,'RTF')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(18,4,'MS Word')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(20,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(20,1,'Yes')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(27,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(27,1,'Yes')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(29,0,'HTML 3.0 Base Only')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(29,1,'HTML 3.2 Tags + BG Colors')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(29,2,'HTML 3.2 Tags')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(59,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(59,1,'Yes')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(60,0,'No Sub-Directories')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(60,1,'Allow Sub-Directories')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(74,0,'None')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(84,0,'None')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(92,0,'Leave import file after Import')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(92,1,'Delete import file after Import')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(90,1,'Append to current export file')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(90,2,'Overwrite current export file')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(97,0,'Leave import file after Import')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(97,1,'Delete import file after Import')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(98,1,'Append to current export file')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(98,2,'Overwrite current export file')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(360,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(360,1,'Yes')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(363,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(363,1,'Yes')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(364,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(364,1,'Yes')
END
GO
-- End Populate configvalues


-- Add Unique Logins Option
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 20) = 0
BEGIN
INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Unique Logins Per Domain',20,20,1,0,0,NULL)
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(20,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(20,1,'Yes')
END

-- Add Server Print Receipt
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 45) = 0
BEGIN
INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Print Receipts on Server',45,45,6,0,0,NULL)
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(45,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(45,1,'Yes')
END


-- Add MapGetAttributes
IF object_id('MapGetAttributes') IS NOT NULL
	DROP PROCEDURE MapGetAttributes
GO

CREATE PROCEDURE dbo.MapGetAttributes AS
SELECT MapAttribute,CASE WHEN RadVendorID = 0 THEN RadAttributeID ELSE RadVendorType END AS RadAttributeID,RadVendorID,MapType
FROM MapAttributes
GO

-- Add MapGetValues
IF object_id('MapGetValues') IS NOT NULL
	DROP PROCEDURE MapGetValues
GO

CREATE PROCEDURE dbo.MapGetValues AS
SELECT MapAttribute,Value,RadValue,MapType
FROM MapValues
ORDER BY MapAttribute,MapType
GO

-- Add RadServerAccessCache
IF object_id('RadServerAccessCache') IS NOT NULL
	DROP PROCEDURE RadServerAccessCache
GO

CREATE PROCEDURE dbo.RadServerAccessCache AS
Select MaxSessionLength, StartTime, StopTime, s.IPAddress, sa.Port, at1.AccountType
From Servers s, ServerAccess sa, AccountTypes at1
	WHERE s.ServerID = sa.ServerID
	AND sa.AccountTypeID = at1.AccountTypeID
UNION
Select NULL, NULL, NULL, s.IPAddress, NULL, NULL
From Servers s
WHERE s.CheckAccess = 0

GO

GRANT EXECUTE ON RadServerAccessCache TO Emerald
GO


IF object_id('CreateServerPorts') IS NOT NULL
	DROP PROCEDURE CreateServerPorts
GO

CREATE PROCEDURE dbo.CreateServerPorts (@serverid int) AS

SET NOCOUNT ON

DECLARE @i int, @j int, @ports int, @servertype int, @maxports int, @p1 int, @p2 int
DECLARE @snmptype int, @snmpbaseuser varchar(128), @snmpuser varchar(148)

if @serverid > 0 
BEGIN

Select @servertype = s.ServerType, @ports = Ports, @snmptype = SNMPType, @snmpbaseuser = SNMPUser
From Servers s, ServerTypes st
Where s.ServerID = @serverid
	and s.ServerType = st.ServerType

if @ports > 0
	BEGIN

	Delete From ServerPorts Where ServerID = @serverid

	Select @i = 0
	While @i < @ports
		BEGIN
		Select @maxports = 1
	
		if @servertype in (0, 2, 3, 4, 10)  -- Starts at 0, PMx
	                Select @p1 = @i

	        else if @servertype = 5		-- Max 4xxx T1
			BEGIN
			SELECT @p1 = 10000 + (((@i/24)+1) * 100) + ROUND(@i%24,0)+1
			SELECT @p2 = 20000 + (((@i/24)+1) * 100) + ROUND(@i%24,0)+1, @maxports = 2
			END

	        else if @servertype = 6		-- Max 4xxx E1
			BEGIN
			SELECT @p1 = 10000 + (((@i/30)+1) * 100) + ROUND(@i%30,0)+1
			SELECT @p2 = 20000 + (((@i/30)+1) * 100) + ROUND(@i%30,0)+1, @maxports = 2
			END

	        else if @servertype = 7		-- Max 1800
			BEGIN
			SELECT @p1 = 10000 + (((@i/2)+1) * 100) + ROUND(@i%2,0)+1
			SELECT @p2 = 20000 + (((@i/2)+1) * 100) + ROUND(@i%2,0)+1, @maxports = 2
			END

	        else if @servertype = 12	-- Microcom 6000
			BEGIN
			SELECT @p1 = 10000 + @i
			SELECT @p2 = 60000 + ((@i+1) * 100), @maxports = 2 -- Starts at 60100
			END

	        else if @servertype = 13	-- USR TC HyperARC: Slot#-1*256+Port
			BEGIN
			SELECT @p1 = (1256 - (((@i % 256) / 31) * 7)) + @i
			END

	        else 				-- Starts at 1, CompuTone, TNT, AS5200
	                Select @p1 = @i + 1
	
		Select @snmpuser = @snmpbaseuser + CASE WHEN @snmptype = 0 and DATALENGTH(@snmpbaseuser) > 2 then convert(varchar(10), @p1) ELSE '' END 
		INSERT INTO ServerPorts(ServerID, NASIdentifier, Port, SNMPUser)
		SELECT @serverid, s.IPAddress, CONVERT(VARCHAR(10),@p1), @snmpuser
		FROM Servers s
			WHERE s.ServerID = @serverid
	
		if @maxports = 2
			BEGIN
			Select @snmpuser = @snmpbaseuser + CASE WHEN @snmptype = 0 and DATALENGTH(@snmpbaseuser) > 2 then convert(varchar(10), @p2) ELSE '' END 
			INSERT INTO ServerPorts(ServerID, NASIdentifier, Port, SNMPUser) 
			SELECT @serverid, s.IPAddress, CONVERT(VARCHAR(10),@p2), @snmpuser
			FROM Servers s
				WHERE s.ServerID = @serverid
			END
	
		Select @i = @i + 1
		END
	
	Select 'Ports Created: ' + convert(varchar, @ports) as Results, @servertype as ServerType
	END
ELSE
	Select 'Server Has no ports defined for it' as Results, @servertype as ServerType

END
ELSE
	Select 'Invalid ServerID Parameter' as Results, @servertype as ServerType
GO

GRANT EXECUTE ON CreateServerPorts TO Emerald
GO


-- Radius IP Pooling. Fixes join error
IF object_id('RadGetPoolConfigs') IS NOT NULL
	DROP PROCEDURE RadGetPoolConfigs
GO

CREATE PROCEDURE dbo.RadGetPoolConfigs (@AccountTypeID int, @ServerID int, @NASIdentifier varchar(16), @NASPort VARCHAR(10), @accountid INT, @callerid VARCHAR(20), @dnis VARCHAR(20)) AS
SET ROWCOUNT 1
SET NOCOUNT ON
DECLARE @ip VARCHAR(16)

UPDATE RadIPAddresses SET State = 0
	WHERE NASIdentifier = @NASIdentifier
	AND NASPort = @NASPort
	AND (State = 2
		OR (State = 1 AND LastUsed < DATEADD(mi,-2,getdate())))

-- Specific Account Type, Specific IP Group
SELECT @ip=ria.IPAddress
From ServerGroups sg, RadIPGroups rig, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
Where s.ServerGroupID = sg.ServerGroupID
	and riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID = rig.RadIPGroupID
	AND ria.RadIPGroupID = rig.RadIPGroupID
	and riat.AccountTypeID = @AccountTypeID
	and s.ServerID = @ServerID
	and State = 0
Order By riat.Priority, ria.LastUsed ASC

-- All Account Types, Specific IP Group
IF @ip IS NULL
Select @ip=ria.IPAddress
From ServerGroups sg, RadIPGroups rig, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
Where s.ServerGroupID = sg.ServerGroupID
	AND riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID = rig.RadIPGroupID
	AND ria.RadIPGroupID = rig.RadIPGroupID
	AND riat.AccountTypeID IS NULL
	AND s.ServerID = @ServerID
	AND State = 0
Order By riat.Priority, ria.LastUsed ASC

-- Specific Account Type, All IP Groups
IF @ip IS NULL
SELECT @ip=ria.IPAddress
From ServerGroups sg, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
Where s.ServerGroupID = sg.ServerGroupID
	AND riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID IS NULL
	and riat.AccountTypeID = @AccountTypeID
	and s.ServerID = @ServerID
	and State = 0
Order By riat.Priority, ria.LastUsed ASC

-- All Account Types, All IP Groups
IF @ip IS NULL
SELECT @ip=ria.IPAddress
From ServerGroups sg, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
Where s.ServerGroupID = sg.ServerGroupID
	AND riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID IS NULL
	AND riat.AccountTypeID IS NULL
	and s.ServerID = @ServerID
	and State = 0
Order By riat.Priority, ria.LastUsed ASC

IF @ip IS NOT NULL
	BEGIN
	Update RadIPAddresses
		Set LastUsed = getdate(), State = 1, NASIdentifier = @NASIdentifier, NASPort = @NASPort
		Where IPAddress = @ip

	Select 8 as AttributeID,0 as VendorID, 0 as Value, @ip as Data
	END
GO

GRANT EXECUTE ON RadGetPoolConfigs TO Emerald
GO

-- Servu FTP Global limit is ConfigID 61 not 60 and Overlimit should include pendings.
IF object_id('VerifyFTPUser') IS NOT NULL
	DROP PROCEDURE VerifyFTPUser
GO

CREATE PROCEDURE dbo.VerifyFTPUser @username varchar(40) AS
DECLARE @globallimit INT
SELECT @globallimit = Value FROM Configs WHERE ConfigID = 61
Select AccountID, Login, Login AS Shell,sa.Password, HomeDir, 
CASE WHEN HomeDirLimit IS NULL THEN @globallimit ELSE HomeDirLimit END AS HomeDirLimit
	From MasterAccounts ma, SubAccounts sa
	Where ma.CustomerID = sa.CustomerID
		AND sa.CustomerID=ma.CustomerID
		AND ma.Active=1 AND sa.Active=1
		AND (ma.CancelDate IS NULL OR ma.CancelDate >= getdate())
		AND ((ma.OverLimit > 0 AND ma.OverLimit > (ma.Balance + ma.PendingDebit - ma.PendingCredit)) 
			OR (DATEADD(Day,(sa.Extension+COALESCE(ma.OverDue,0)+1),ExpireDate) > GETDATE())
			OR ((ma.OverLimit IS NULL OR ma.OverLimit = 0) AND ExpireDate IS NULL))
		AND (Login = @username or Email = @username)
		AND ma.StartDate < GETDATE()
GO
GRANT EXECUTE ON VerifyFTPUser TO Emerald
GO

-- OnlineSignups remove 'unique' index
IF (SELECT COUNT(*) FROM sysindexes WHERE name = 'XIE2OnlineSignups') = 0
BEGIN
	DROP INDEX OnlineSignups.XAK1OnlineSignups
	CREATE INDEX XIE2OnlineSignups ON OnlineSignups
	(
	       Region,
	       CallDate
	)
END
GO

-- InvoiceID is unknown for most entries
UPDATE ExportColumns SET FieldName = 'TransID' WHERE FieldName = 'InvoiceID' AND ExportID IN (14,18,202)
GO

IF object_id('RU_AT') IS NOT NULL
	DROP PROCEDURE RU_AT
GO

CREATE PROCEDURE dbo.RU_AT AS
SELECT AccountType, rc.AccountTypeID, ra.RadAttributeID, ra.RadAttributeType, rc.Data, rc.Value, rc.RadCheck, ra.Name
    From RadATConfigs rc, RadAttributes ra, AccountTypes at1
    Where rc.RadAttributeID = ra.RadAttributeID
	AND rc.RadVendorID = ra.RadVendorID
	AND rc.RadVendorType = ra.RadVendorType
      AND rc.AccountTypeID = at1.AccountTypeID 
    Order by rc.AccountTypeID, rc.RadCheck DESC
GO
GRANT EXECUTE ON RU_AT TO Emerald
GO

IF object_id('RU_RATC') IS NOT NULL
	DROP PROCEDURE RU_RATC
GO

CREATE PROCEDURE dbo.RU_RATC AS
SELECT sa.Login, sa.Password, att.AccountType, 
SubExpire=DateAdd(Day, (Extension+COALESCE(ma.OverDue,0)+1), ExpireDate)
   From MasterAccounts ma, SubAccounts sa, AccountTypes att
    Where ma.CustomerID = sa.CustomerID
 	AND (DateAdd(Day,(Extension+COALESCE(ma.OverDue,0)+1),ExpireDate) >= GetDate() or ExpireDate is NULL)
 	AND sa.Login is not NULL and sa.Password is not NULL
        AND ma.Active = 1 AND sa.Active = 1 AND
        sa.AccountTypeID = att.AccountTypeID
AND NOT EXISTS (
Select * From RadConfigs rc where sa.AccountID = rc.AccountID
)
AND EXISTS (
Select * From RadATConfigs rat where sa.AccountTypeID = rat.AccountTypeID
)
GO
GRANT EXECUTE ON RU_RATC TO Emerald
GO

IF object_id('RU_RC') IS NOT NULL
	DROP PROCEDURE RU_RC
GO

CREATE PROCEDURE dbo.RU_RC AS
SELECT sa.Login, sa.Password, ra.Name, ra.RadAttributeType, rc.Data, rc.Value, rc.RadCheck,
DateAdd(Day, (Extension+COALESCE(ma.OverDue,0)+1), ExpireDate)
    From MasterAccounts ma, SubAccounts sa, RadConfigs rc, RadAttributes ra
    Where ma.CustomerID = sa.CustomerID
AND rc.AccountID = sa.AccountID
AND ra.RadAttributeID = rc.RadAttributeID
 	AND sa.Login is not null and sa.Password is not null
 	AND (DateAdd(Day, (Extension+COALESCE(ma.OverDue,0)+1), ExpireDate) >= GetDate() or ExpireDate is NULL)
        AND ma.Active = 1 AND sa.Active = 1
   Order BY sa.Login, rc.RadCheck DESC
GO
GRANT EXECUTE ON RU_RC TO Emerald
GO

-- Add missing external system sync proc
IF object_id('TaskESUpdate') IS NOT NULL
	DROP PROCEDURE TaskESUpdate
GO

CREATE PROCEDURE dbo.TaskESUpdate @esid INT, @date DATETIME AS 
UPDATE ExternalSystems SET LastSyncDate = @date 
	WHERE ExternalSystemID = @esid
GO
GRANT EXECUTE ON TaskESUpdate TO Emerald
GO

IF ((SELECT COUNT(*) FROM ExportColumns WHERE ExportID = 100) = 0)
BEGIN
	INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,1,NULL,1,'ID',NULL,2,0,0,NULL,100)
	INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,2,NULL,1,'Status',NULL,1,0,0,NULL,100)
	INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,3,NULL,1,'Login',NULL,1,0,0,NULL,100)
	INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,4,NULL,1,'Email',NULL,1,0,0,NULL,100)
	INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,5,NULL,1,'Password',NULL,1,0,0,NULL,100)
	INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,6,NULL,1,'FirstName',NULL,1,0,0,NULL,100)
	INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,7,NULL,1,'LastName',NULL,1,0,0,NULL,100)
	INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,8,NULL,1,'MailHost',NULL,1,0,0,NULL,100)
	INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,9,NULL,1,'HomeDir',NULL,1,0,0,NULL,100)
	INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,10,NULL,1,'HomeDirLimit',NULL,2,0,0,NULL,100)
	INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,11,NULL,1,'ExpireDay',NULL,2,0,0,NULL,100)
END

-- 'New' CC Authorize.net format
DELETE FROM CCImportColumns WHERE ExportID = 18
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,8,'Trans ID',0,1,NULL,1,NULL,18,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,2,'Approve Code',0,7,NULL,1,NULL,18,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,1,'Sink',0,0,NULL,1,NULL,18,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('Declined $approvecode',0,3,'Response Code',0,8,NULL,1,'Authorized $approvecode $this $sink',18,0)
GO

-- Mirror IC Verify and set quoted
IF ((SELECT COUNT(*) FROM CCImportColumns WHERE ExportID = 10) = 0)
INSERT INTO CCImportColumns (ExportID,FieldType,SortOrder,Position,Description,Quoted,FieldSize,ApproveValue,DeclineValue,ErrorValue,Line)
SELECT 10,FieldType,SortOrder,Position,Description,Quoted,FieldSize,ApproveValue,DeclineValue,ErrorValue,Line
	FROM CCImportColumns WHERE ExportID = 8

UPDATE CCImportColumns SET Quoted = 1 WHERE ExportID IN (8,10) AND Quoted = 0
UPDATE Exports SET ApproveString='A TIME', ApproveMatch=2, Lines=2 WHERE ExportID = 10
UPDATE ExportColumns SET ExportValue = '$expyy$expmm' WHERE ExportValue = '$expmm$expyy' AND ExportID = 8 AND FieldName = 'CreditCardExpire'

UPDATE Exports SET ApproveString='.APP', ApproveMatch=3 WHERE ExportID = 7 and ApproveString IS NULL
UPDATE Exports SET DeclineString='.BAD', DeclineMatch=3 WHERE ExportID = 7 and DeclineString IS NULL
UPDATE Exports SET Separator=' ' WHERE ExportID = 7 and Separator <> ' '

DELETE FROM ExportColumns WHERE ExportID = 18
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,1,NULL,1,'TransID',NULL,2,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,2,NULL,1,'TransID',NULL,2,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,3,NULL,1,'Amount',NULL,3,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,4,NULL,1,'PayMethod',NULL,0,0,0,'CC',18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,5,NULL,1,'BankTransType',NULL,0,0,0,'AUTH_CAPTURE',18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,6,NULL,1,'AuthCode',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,7,NULL,1,'TransactionID',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,8,NULL,1,'CardNumber',NULL,1,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,9,NULL,1,'CardExpire',NULL,0,0,0,'$expmm$expyy',18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,10,NULL,1,'AccountNumber',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,11,NULL,1,'BankNumber',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,12,NULL,1,'BankName',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,13,NULL,1,'CustomerID',NULL,2,0,0,NULL,18)
GO

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,14,NULL,1,'CardHolder',NULL,1,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,15,NULL,1,'LastName',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,16,NULL,1,'Company',NULL,1,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,17,NULL,1,'Address',NULL,7,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,18,NULL,1,'City',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,19,NULL,1,'State',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,20,NULL,1,'Zip',NULL,1,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,21,NULL,1,'Phone',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,22,NULL,1,'Fax',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,23,NULL,1,'Email',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,0,NULL,18)
GO

-- Missing select list for hide password option
IF ((SELECT COUNT(*) FROM ConfigValues WHERE ConfigID = 1) = 0)
BEGIN
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(1,0,'Show Passwords')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(1,1,'Hide Passwords')
END
GO

EXEC MetaAddObjectFile 'MBR Basic','mbr_aging2_f.ews'
EXEC MetaAddObjectFile 'MBR Acct','mbr_adjustment_edit.ews'
EXEC MetaAddObjectFile 'MBR Acct','mbr_adjustment_delete.ews'
EXEC MetaAddObjectFile 'All','email_error.ews'
EXEC MetaAddObjectFile 'Batch','batch_payments_f.ews'
EXEC MetaAddObjectFile 'Batch','batch_summarycharges_f.ews'
GO

UPDATE Strings SET Version = 4 WHERE Version = 3
GO

-- Unused Report fields
DELETE FROM Configs WHERE ConfigID IN (48,49)
GO

-- Email before login
IF object_id('LDAPrfc822mailbox') IS NOT NULL
	DROP PROCEDURE LDAPrfc822mailbox
GO

CREATE PROCEDURE dbo.LDAPrfc822mailbox @accountid INT AS
SELECT CASE WHEN sa.Email LIKE '%_@_%' THEN sa.Email ELSE sa.Login + '@' + d.MailDomain END AS mail
FROM SubAccounts sa, Domains d
	WHERE sa.DomainID = d.DomainID
	AND sa.AccountID = @accountid
UNION
SELECT Alias as mail FROM Aliases WHERE AccountID = @accountid
GO
GRANT EXECUTE ON LDAPrfc822mailbox TO Emerald
GO

-- Overlimit should include pendings
IF object_id('VerifyMailUser') IS NOT NULL
	DROP PROCEDURE VerifyMailUser
GO

CREATE PROCEDURE dbo.VerifyMailUser @username varchar(40), @domain varchar(40), @esid integer AS
CREATE TABLE #AccountIDs (AccountID INT)
INSERT INTO #AccountIDs
SELECT AccountID FROM SubAccounts WHERE Email = @username + '@' + @domain
UNION
SELECT AccountID FROM SubAccounts sa, Domains d WHERE sa.Login = @username AND sa.DomainID = d.DomainID AND d.MailDomain = @domain

DELETE #AccountIDs
FROM #AccountIDs ai, SubAccounts sa, MasterAccounts ma
	WHERE ai.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND (sa.Active <> 1 OR ma.Active <> 1 OR ma.CancelDate < DATEADD(dd,-1,getdate()))

IF (SELECT COUNT(AccountID) FROM #AccountIDs) = 0
INSERT INTO #AccountIDs
SELECT AccountID FROM Aliases WHERE Alias = @username + '@' + @domain

SELECT Login, Login AS Shell, Email,@domain AS MailDomain,
CASE WHEN (ma.OverLimit > 0 AND ma.OverLimit > (ma.Balance + ma.PendingDebit - ma.PendingCredit)) 
		OR (sa.ExpireDate IS NOT NULL AND DateAdd(Day, (sa.Extension+COALESCE(ma.OverDue,0)+1), sa.ExpireDate) < GetDate())
THEN RIGHT(CONVERT(VARCHAR(20),RAND()),4) + RIGHT(CONVERT(VARCHAR(20),RAND()),4)
ELSE sa.Password END AS Password, HomeDir
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1, #AccountIDs ai
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountID = ai.AccountID
	AND at1.AccountTypeID = sa.AccountTypeID
	AND at1.ExternalSystemID = @esid
	AND ma.StartDate < GETDATE()
ORDER BY Email DESC

DROP TABLE #AccountIDs
GO
GRANT EXECUTE ON VerifyMailUser TO Emerald
GO


-- Set generic import format as quoted
UPDATE CCImportColumns SET Quoted = 1 WHERE Quoted = 0 AND ExportID = 99
GO

UPDATE ExportColumns SET Format = 1 WHERE FieldName = 'Merchant' AND Format = 2 AND ExportID IN (17,19)
GO

-- AllowedHosts should not have IP validation to allow wildcard masks
EXEC SetMetaColumnRule 'AllowedHosts', 'IPAddress', 0
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 38) = 0 
	BEGIN
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Print 0 Balance or Credit Statements',38,38,5,1,0,NULL)
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(38,0,'No')
	INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(38,1,'Yes')
	END
GO

-- PC Authorize response
UPDATE CCImportColumns SET SortOrder = 3, Quoted = 1, ApproveValue = 'Authorized $approvecode'
	WHERE ExportID = 14
	AND FieldType = 8
	AND SortOrder = 4
GO

-- Generic CC expire date should be MMYY, not YYMM.
UPDATE ExportColumns SET ExportValue = '$expmm$expyy'
        WHERE ExportValue = '$expyy$expmm'
        AND ExportID = 99
        AND FieldName = 'CreditCardExpire'
GO

-- Generic ACH import support
IF (SELECT COUNT(*) FROM CCImportColumns WHERE ExportID = 299) = 0
BEGIN
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,1,'TransID',0,1,NULL,1,NULL,299,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,2,'Status',0,2,NULL,1,NULL,299,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('Declined $approvecode',1,3,'Response Code',0,8,NULL,1,'Authorized $approvecode $this',299,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,4,'ApproveCode',0,7,NULL,1,NULL,299,0)
UPDATE Exports SET ApproveString = 'A', ApproveMatch = 1, DeclineString = 'D', DeclineMatch = 1 WHERE ExportID = 299
END
GO

-- PTC (ACH) import support
UPDATE Exports SET ApproveString = 'AUTH/TKT', ApproveMatch = 1 WHERE ExportID IN (5,6) AND ApproveString IS NULL
GO

IF (SELECT COUNT(*) FROM CCImportColumns WHERE ExportID = 5) = 0
BEGIN
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,5,'TransID',0,1,NULL,1,NULL,5,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,4,'Status',0,2,NULL,1,NULL,5,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,4,'ApproveCode',10,7,NULL,1,NULL,5,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('$status',1,3,'Response Code',0,8,NULL,1,'Authorized $this / $approvecode',5,0)
END
GO

IF (SELECT COUNT(*) FROM CCImportColumns WHERE ExportID = 6) = 0
BEGIN
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,5,'TransID',0,1,NULL,1,NULL,6,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,4,'Status',0,2,NULL,1,NULL,6,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,4,'ApproveCode',10,7,NULL,1,NULL,6,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('$status',1,3,'Response Code',0,8,NULL,1,'Authorized $this / $approvecode',6,0)
END
GO

IF object_id('pkcols') IS NOT NULL
	DROP PROCEDURE pkcols
GO
CREATE PROCEDURE dbo.pkcols @table VARCHAR(32), @cols INT OUTPUT AS
SELECT @cols=COUNT(*) 
From sysindexes i, syscolumns c, sysobjects o
Where o.id = c.id
	and o.id = i.id
	and (i.status & 2048) = 2048
	and (c.name = index_col (o.name, i.indid,  1) or
	     c.name = index_col (o.name, i.indid,  2) or
	     c.name = index_col (o.name, i.indid,  3) or
	     c.name = index_col (o.name, i.indid,  4) or
	     c.name = index_col (o.name, i.indid,  5) or
	     c.name = index_col (o.name, i.indid,  6)
	    )
	and o.name = @table
GO
GRANT EXECUTE ON pkcols TO Emerald
GO

-- Tunnel attribute types
UPDATE RadAttributes SET RadAttributeType = 11 WHERE RadAttributeID IN (64,65,83) AND RadVendorID = 0 AND RadAttributeType <> 11
UPDATE RadAttributes SET RadAttributeType = 10 WHERE RadAttributeID IN (66,67,69,81,82) AND RadVendorID = 0 AND RadAttributeType <> 10
GO

IF object_id('TrimLogs') IS NOT NULL
	DROP PROCEDURE TrimLogs
GO
CREATE PROCEDURE dbo.TrimLogs AS
DECLARE @radlogs INT, @auditlogs INT, @syslogs INT, @logs INT, @schedlogs INT, @serverports INT

SELECT @radlogs = Value FROM Configs WHERE ConfigID = 200
SELECT @schedlogs = Value FROM Configs WHERE ConfigID = 201
SELECT @auditlogs = Value FROM Configs WHERE ConfigID = 202
SELECT @syslogs = Value FROM Configs WHERE ConfigID = 203
SELECT @logs = Value FROM Configs WHERE ConfigID = 204
SELECT @serverports = Value FROM Configs WHERE ConfigID = 207

IF (@radlogs IS NOT NULL AND @radlogs <> 0)
	DELETE FROM RadLogs WHERE LogDate < DATEADD(dd,-(@radlogs),getdate())

IF (@auditlogs IS NOT NULL AND @auditlogs <> 0)
	DELETE FROM AuditLogs WHERE LogDate < DATEADD(dd,-(@auditlogs),getdate()) 

IF (@syslogs IS NOT NULL AND @syslogs <> 0)
	DELETE FROM SysLogs WHERE LogDate < DATEADD(dd,-(@syslogs),getdate()) 

IF (@logs IS NOT NULL AND @logs <> 0)
	DELETE FROM Logs WHERE LogDate < DATEADD(dd,-(@logs),getdate()) 

IF (@schedlogs IS NOT NULL AND @schedlogs <> 0)
	DELETE FROM ScheduleLogs WHERE EndDate < DATEADD(dd,-(@schedlogs),getdate())

IF (@serverports IS NOT NULL AND @serverports <> 0)
	DELETE FROM ServerPorts
	FROM ServerPorts sp, Servers s
		WHERE sp.ServerID = s.ServerID
		AND sp.CallDate < DATEADD(dd,-(@serverports),getdate())
		AND sp.SNMPUser IS NULL
		AND sp.NASIdentifier <> s.IPAddress

DELETE FROM OperatorCookies WHERE LastUsed < DATEADD(dd,-3,GETDATE())
GO
GRANT EXECUTE ON TrimLogs TO Emerald
GO

UPDATE ExportColumns SET Quoted = 1
	WHERE ExportID = 9
	AND SortOrder IN (1, 3, 4)
	AND Quoted = 0

UPDATE ExportColumns SET ExportValue = '$expmm$expyy'
	WHERE ExportValue = '$expyy$expmm'
	AND ExportID = 9
	AND SortOrder = 4

-- Add missing Ascend attributes
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 529 AND RadVendorType = 13)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 13, 'Ascend-NAS-Port-Format', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 529 AND RadVendorType = 20)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 20, 'Ascend-Global-Call-Id', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 529 AND RadVendorType = 66)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 66, 'Ascend-Calling-Id-Type-Of-Num', 1, 0)

IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 529 AND Value = 6 AND RadVendorType = 66)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 66, 6, 'Abbreviated-Number')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 529 AND Value = 1 AND RadVendorType = 66)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 66, 1, 'International-Number')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 529 AND Value = 2 AND RadVendorType = 66)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 66, 2, 'National-Number')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 529 AND Value = 3 AND RadVendorType = 66)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 66, 3, 'Network-Specific')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 529 AND Value = 4 AND RadVendorType = 66)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 66, 4, 'Subscriber-Number')

IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 529 AND RadVendorType = 67)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 67, 'Ascend-Calling-Id-Number-Plan', 1, 0)

IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 529 AND Value = 3 AND RadVendorType = 67)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 67, 3, 'Data')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 529 AND Value = 1 AND RadVendorType = 67)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 67, 1, 'ISDN-Telephony')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 529 AND Value = 8 AND RadVendorType = 67)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 67, 8, 'National')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 529 AND Value = 9 AND RadVendorType = 67)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 67, 9, 'Private')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 529 AND Value = 4 AND RadVendorType = 67)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 67, 4, 'Telex')

IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 529 AND RadVendorType = 86)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 86, 'Ascend-Owner-IP-Addr', 2, 0)

IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 529 AND RadVendorType = 109)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 109, 'Ascend-Endpoint-Disc', 0, 0)

-- Add missing CISCO attributes
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 1)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 1, 'Cisco-AVPair', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 2)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 2, 'Cisco-NAS-Port', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 23)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 23, 'h323-remote-address', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 24)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 24, 'h323-conf-id', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 25)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 25, 'h323-setup-time', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 26)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 26, 'h323-call-origin', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 27)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 27, 'h323-call-type', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 28)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 28, 'h323-connect-time', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 29)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 29, 'h323-disconnect-time', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 30)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 30, 'h323-disconnect-cause', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 31)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 31, 'h323-voice-quality', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 33)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 33, 'h323-gw-id', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 35)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 35, 'h323-incoming-conf-id', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 101)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 101, 'h323-credit-amount', 0, 0)
GO

IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 102)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 102, 'h323-credit-time', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 103)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 103, 'h323-return-code', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 104)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 104, 'h323-prompt-id', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 105)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 105, 'h323-time-and-day', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 106)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 106, 'h323-redirect-number', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 107)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 107, 'h323-preferred-lang', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 108)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 108, 'h323-redirect-ip-address', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 109)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 109, 'h323-billing-model', 0, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 187)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 187, 'Cisco-Multilink-ID', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 188)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 188, 'Cisco-Num-In-Multilink', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 190)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 190, 'Cisco-Pre-Input-Octets', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 191)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 191, 'Cisco-Pre-Output-Octets', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 192)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 192, 'Cisco-Pre-Input-Packets', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 193)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 193, 'Cisco-Pre-Output-Packets', 1, 0)
GO

IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 194)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 194, 'Cisco-Maximum-Time', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 195)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 195, 'Cisco-Disconnect-Cause', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 197)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 197, 'Cisco-Data-Rate', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 198)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 198, 'Cisco-PreSession-Time', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 208)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 208, 'Cisco-PW-Lifetime', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 209)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 209, 'Cisco-IP-Direct', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 210)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 210, 'Cisco-PPP-VJ-Slot-Comp', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 212)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 212, 'Cisco-PPP-Async-Map', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 217)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 217, 'Cisco-IP-Pool-Definition', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 218)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 218, 'Cisco-Asing-IP-Pool', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 228)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 228, 'Cisco-Route-IP', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 233)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 233, 'Cisco-Link-Compression', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 234)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 234, 'Cisco-Target-Util', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 235)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 235, 'Cisco-Maximum-Channels', 1, 0)
GO

IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 242)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 242, 'Cisco-Data-Filter', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 243)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 243, 'Cisco-Call-Filter', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 244)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 244, 'Cisco-Idle-Limit', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 9 AND RadVendorType = 255)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 255, 'Cisco-Xmit-Rate', 1, 0)
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 2 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 2, 'Unknown')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 4 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 4, 'CLID-Auth-Failure')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 10 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 10, 'No-Carrier')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 11 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 11, 'Lost-Carrier')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 12 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 12, 'No-Detected-Result-Codes')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 20 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 20, 'User-Ends-Session')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 21 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 21, 'Idle-Timeout')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 22 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 22, 'Exit-Telnet-Session')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 23 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 23, 'No-Remote-IP-Addr')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 24 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 24, 'Exit-Raw-TCP')
GO

IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 25 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 25, 'Password-Fail')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 26 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 26, 'Raw-TCP-Disabled')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 27 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 27, 'Control-C-Detected')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 28 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 28, 'EXEC-Program-Destroyed')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 40 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 40, 'Timeout-PPP-LCP')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 41 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 41, 'Failed-PPP-LCP-Negotiate')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 42 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 42, 'Failed-PPP-PAP-Auth-Fail')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 43 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 43, 'Failed-PPP-CHAP-Auth')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 44 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 44, 'Failed-PPP-Remote-Auth')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 45 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 45, 'PPP-Remote-Terminate')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 46 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 46, 'PPP-Closed-Event')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 100 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 100, 'Session-Timeout')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 101 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 101, 'Session-Failed-Security')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 102 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 102, 'Session-End-Callback')
GO

IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 9 AND Value = 120 AND RadVendorType = 195)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 9, 195, 120, 'Invalid-Protocol')
GO

-- Colubris Networks
IF (SELECT COUNT(*) FROM RadVendors WHERE RadVendorID = 8744) = 0
	INSERT INTO RadVendors (RadVendorID,Name) VALUES(8744,'Colubris')

IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 8744 AND RadVendorType = 0)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 8744, 0, 'Colubris-AV-Pair', 0, 0)
GO

-- Nortel + Bay-Networks
IF NOT EXISTS (SELECT * FROM RadVendors WHERE RadVendorID = 562)
	INSERT INTO RadVendors (RadVendorID,Name) VALUES(562,'Nortel')

IF NOT EXISTS (SELECT * FROM RadVendors WHERE RadVendorID = 1584)
	INSERT INTO RadVendors (RadVendorID,Name) VALUES(1584,'Bay-Networks')
GO

IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 1584 AND RadVendorType = 192)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 192, 'Access-Priority', 1, 0)
IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 1584 AND RadVendorType = 193)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 193, 'Cli-Command', 0, 0)
GO

IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 1584 AND Value = 1 AND RadVendorType = 192)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 1584, 192, 1, 'Read-Only-Access')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 1584 AND Value = 2 AND RadVendorType = 192)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 1584, 192, 2, 'L1-Read-Write-Access')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 1584 AND Value = 3 AND RadVendorType = 192)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 1584, 192, 3, 'L2-Read-Write-Access')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 1584 AND Value = 4 AND RadVendorType = 192)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 1584, 192, 4, 'L3-Read-Write-Access')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 1584 AND Value = 5 AND RadVendorType = 192)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 1584, 192, 5, 'Read-Write-Access')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 1584 AND Value = 6 AND RadVendorType = 192)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 1584, 192, 6, 'Read-Write-All-Access')
GO

IF NOT EXISTS (SELECT * FROM RadAttributes WHERE RadVendorID = 562 AND RadVendorType = 1)
	INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 562, 1, 'DX-UPC', 1, 0)
GO

IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 562 AND Value = 5 AND RadVendorType = 1)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 562, 1, 5, 'UPC5')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 562 AND Value = 4 AND RadVendorType = 1)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 562, 1, 4, 'UPC4')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 562 AND Value = 3 AND RadVendorType = 1)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 562, 1, 3, 'UPC3')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 562 AND Value = 2 AND RadVendorType = 1)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 562, 1, 2, 'UPC2')
IF NOT EXISTS (SELECT * FROM RadValues WHERE RadVendorID = 562 AND Value = 1 AND RadVendorType = 1)
	INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 562, 1, 1, 'UPC1')
GO


if not exists (Select * From ObjectGroups Where ObjectGroupID = 113)
	BEGIN
	DECLARE @ogid int
	Insert Into ObjectGroups(ObjectGroupID, ReportID, ObjectGroup) VALUES(113, NULL, 'MBR Payment')

	EXEC MetaAddObjectFile 'MBR Payment', 'mbr_payment.ews'
	EXEC MetaAddObjectFile 'MBR Payment', 'mbr_payment_add.ews'
	EXEC MetaAddObjectFile 'MBR Payment', 'mbr_payment_cc.ews'
	EXEC MetaAddObjectFile 'MBR Payment', 'mbr_payment_delete.ews'
	EXEC MetaAddObjectFile 'MBR Payment', 'mbr_payment_edit.ews'
	EXEC MetaAddObjectFile 'MBR Payment', 'mbr_payment_edit_save.ews'
	EXEC MetaAddObjectFile 'MBR Payment', 'mbr_payment_eft.ews'
	EXEC MetaAddObjectFile 'MBR Payment', 'mbr_payment_save.ews'
	END

GO

EXEC MetaAddObjectFile 'MBR Acct', 'invoice_mail.ews'
EXEC MetaAddObjectFile 'MBR Acct', 'statement_mail.ews'
EXEC MetaAddObjectFile 'MBR Acct', 'email_report_send.ews'
GO

-- PC-Charge Import format
UPDATE Exports 
SET ApproveString = '.APP', DeclineString = '.BAD', ApproveMatch = 3, DeclineMatch = 3, Separator = ' '
WHERE ExportID = 7
	AND ApproveString IS NULL
	AND DeclineString IS NULL
GO

DELETE FROM CCImportColumns WHERE ExportID = 7
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,5,'TransID',0,1,NULL,1,NULL,7,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('$filename',1,0,'Status',0,2,NULL,1,'$filename',7,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,8,'Approve Code',0,7,NULL,1,NULL,7,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('Declined $this',1,4,'Response Code',0,8,NULL,1,'Authorized $approvecode',7,0)
GO

-- Add VerifyNewsUser
IF object_id('VerifyNewsUser') IS NOT NULL
	DROP PROCEDURE VerifyNewsUser
GO

CREATE PROCEDURE dbo.VerifyNewsUser @username varchar(40) AS
SELECT Login, Login AS Shell, sa.Password, at1.AccountType
	FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1
	WHERE ma.CustomerID = sa.CustomerID
		AND sa.AccountTypeID = at1.AccountTypeID
		AND ma.Active=1 AND sa.Active=1
		AND (ma.CancelDate IS NULL OR ma.CancelDate >= getdate())
		AND ( (ma.OverLimit > 0 AND ma.OverLimit > (ma.Balance + ma.PendingDebit - ma.PendingCredit)) 
			OR (DATEADD(dd,(sa.Extension+COALESCE(ma.OverDue,0)+1),ExpireDate) < GETDATE())
			OR ((ma.OverLimit IS NULL OR ma.OverLimit = 0) AND ExpireDate IS NULL))
		AND ma.StartDate < GETDATE()
		AND Login=@username
GO

GRANT EXECUTE ON VerifyNewsUser TO Emerald
GO

-- Tech group security updates
EXEC MetaAddObjectFile 'Reports', 'tsgraph_server_list.ews'
EXEC MetaAddObjectFile 'Reports', 'tsgraph_list.ews'
EXEC MetaAddObjectFile 'Reports', 'graph.ews'
GO

UPDATE OperatorGroupAccess SET AccessType = 7 WHERE AccessType = 3 AND ObjectGroupID = 103 AND GroupID = 1
GO

DELETE FROM Objects WHERE ObjectGroupID = 103 AND ObjectTypeID = 3 AND Value IN (SELECT MetaColumnID FROM MetaColumns WHERE ColumnName IN ('LMD_TS','Description','CreateDate') AND MetaTableID IN (SELECT MetaTableID FROM MetaTables WHERE TableName = 'Incidents'))
GO

-- Update ScheduleStaleLocks
IF object_id('ScheduleStaleLocks') IS NOT NULL
	DROP PROCEDURE ScheduleStaleLocks
GO

CREATE PROCEDURE dbo.ScheduleStaleLocks AS
UPDATE Schedules SET LockServerID = NULL
	WHERE ScheduleServerID IS NULL
	AND LockServerID IS NOT NULL
	AND ((Interval = 0 AND Status = 0 AND DATEADD(hh,1,StartDate) < getdate()) /* One time hasn't started within an hour of being scheduled */
		OR (Status = 1 AND DATEADD(hh,1,LastUpdate) < getdate()) /* Recurring or One time, no updates within an hour of last start */
		OR (Interval > 0 AND Status <> 1 AND LastUpdate < DATEADD(hh,-1,DATEADD(ss,-(Interval),getdate()))) /* Recurring non aligned */
	)
UPDATE Schedules SET LockServerID = NULL WHERE ScheduleServerID IS NOT NULL AND LockServerID IS NOT NULL
GO

GRANT EXECUTE ON ScheduleStaleLocks TO Emerald
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 16) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Send Manual Payment Receipts',16,100,6,0,0,NULL)
GO

UPDATE WebConfigs SET Value = 'emerald.gif' WHERE Value = 'emerald.jpg' AND Name IN ('LogoSmall','LogoLarge','LogoMedium')
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 390) = 0 
BEGIN
INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Edition)  VALUES('Default date format',390,390,8,1,0,NULL,0)
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(390,1,'MMDDYY')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(390,2,'DDMMYY')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(390,3,'YYMMDD')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(390,4,'YYDDMM')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(390,5,'MMDDCCYY')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(390,6,'DDMMCCYY')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(390,7,'CCYYMMDD')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(390,8,'CCYYDDMM')
END
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 391) = 0 
	INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Edition)  VALUES('Default date separator',391,391,8,0,1,'/',0)
GO

IF object_id('CustomerAgingDetail') IS NOT NULL
	DROP PROCEDURE CustomerAgingDetail
GO

CREATE PROCEDURE dbo.CustomerAgingDetail @custid INT AS
SELECT i.InvoiceID, DATEDIFF(dd,i.CreateDate,getdate()) AS Days, SUM((ii.Amount * ii.Quantity) - ii.PaidAmount) AS Amount, i.CreateDate
FROM Invoices i, InvoiceItems ii, MasterAccounts ma
	WHERE i.InvoiceID = ii.InvoiceID
	AND i.InvoiceTypeID <> 0
	AND ii.Amount > 0
	AND i.StatementID IS NOT NULL
	AND ma.CustomerID = i.CustomerID
	AND (ma.Balance - ma.PendingCredit + ma.PendingDebit) NOT BETWEEN -.0099 AND .0099
	AND ma.CustomerID = @custid
GROUP BY i.InvoiceID, i.CreateDate
HAVING SUM((ii.Amount * ii.Quantity) - ii.PaidAmount) > 0
GO

GRANT EXECUTE ON CustomerAgingDetail TO Emerald
GO

IF NOT EXISTS (Select * From SendMethods Where SendMethodID = 12)
	BEGIN
	INSERT INTO SendMethods (SendMethodID, Description, Amount, AmountType, SortOrder) VALUES(12, 'Email PDF',  0, 1, 4)

	Update SendMethods Set SortOrder = 5 Where SendMethodID = 3
	END
GO

---- Please do not add update queries below this line
DELETE FROM ConfigValues WHERE ConfigID IN(74,84) AND Value <> 0
GO

INSERT INTO ConfigValues(ConfigID,Value,ValueName)
SELECT 74 AS ConfigID,ExportID,Description
FROM Exports 
	WHERE ExportType IN (1,2)
GO

INSERT INTO ConfigValues(ConfigID,Value,ValueName)
SELECT 84 AS ConfigID,ExportID,Description
FROM Exports 
	WHERE ExportType = 4
GO
