CREATE TRIGGER calls_insert ON dbo.Calls 
FOR INSERT
AS
DECLARE @rows INT
UPDATE RadIPAddresses SET State = CASE WHEN i.AcctStatusType IN (1,3) THEN 2 WHEN i.AcctStatusType = 2 THEN 0 ELSE State END
FROM RadIPAddresses ri, inserted i
	WHERE ri.NASPort = i.NASPort
	AND ri.NASIdentifier = i.NASIdentifier

SELECT @rows = 0
SELECT @rows = @rows + 1 
FROM inserted
GROUP BY NASIdentifier, NASPort, ServerID

UPDATE ServerPorts
        Set Username = i.Username, 
		AccountID = i.AccountID,
                AcctStatusType = CASE WHEN i.AcctStatusType in (1,3) THEN 1 ELSE i.AcctStatusType END,
		CallDate = i.CallDate,
		FramedAddress = i.FramedAddress,
		CallerID = i.CallerID,
		ConnectInfo = i.ConnectInfo,
		AcctSessionID = i.AcctSessionID
        FROM ServerPorts sp, inserted i
        WHERE sp.NASIdentifier = i.NASIdentifier
	AND sp.Port = i.NASPort
	AND (i.CallDate >= sp.CallDate OR sp.CallDate IS NULL)

IF (@@rowcount <> @rows)
	BEGIN
	/* SNMPUser should add the port for all except 10 (ascend) */

	INSERT INTO ServerPorts (ServerID,Port,NASIdentifier,IPAddress,MaxSessionTime,CostPerMinute,Username,AccountID,AcctSessionID,
	AcctStatusType,CallDate,FramedAddress,CallerID,ConnectInfo,SNMPUser)

	SELECT i.ServerID,i.NASPort,i.NASIdentifier,NULL,0,0,MIN(i.Username),MIN(i.AccountID),MIN(i.AcctSessionID),CASE WHEN MAX(i.AcctStatusType) in (1,3) THEN 1 ELSE MAX(i.AcctStatusType) END,
	MAX(i.CallDate),MIN(i.FramedAddress),MIN(i.CallerID),MIN(i.ConnectInfo),
	Case when MIN(st.SNMPType)=1 then MIN(st.SNMPUser) else MIN(st.SNMPUser) + convert(varchar(9), i.NASPort) END
	FROM inserted i, Servers s, ServerTypes st
		WHERE s.ServerType = st.ServerType
		AND s.ServerID = COALESCE(i.ServerID,(SELECT MAX(s.ServerID) FROM Servers s, inserted ii WHERE s.IPAddress = ii.NASIdentifier))
		AND NOT EXISTS (SELECT * FROM ServerPorts sp, inserted ii WHERE sp.NASIdentifier = ii.NASIdentifier AND sp.Port = ii.NASPort)
	GROUP BY i.NASIdentifier, i.NASPort, i.ServerID
	END

/* Stuff we only do on stop records */
UPDATE SubAccounts
Set TimeLeft = sa.TimeLeft - (i.AcctSessionTime/60 + 1)
FROM SubAccounts sa, inserted i
        WHERE i.AccountID IS NULL
        AND sa.Login = i.Username
        and sa.TimeLeft IS NOT NULL
        and i.AcctStatusType = 2

UPDATE SubAccounts
Set TimeLeft = sa.TimeLeft - (i.AcctSessionTime/60 + 1)
FROM SubAccounts sa, inserted i
        WHERE i.AccountID IS NOT NULL
        AND sa.AccountID = i.AccountID
        and sa.TimeLeft IS NOT NULL
        and i.AcctStatusType = 2
GO
