
CREATE TABLE dbo.AccountTypes (
       AccountTypeID        int IDENTITY,
       AccountType          varchar(30) NOT NULL,
       Cost                 numeric(18,4) NOT NULL,
       Description          varchar(64) NOT NULL,
       ApplyDiscount        smallint NOT NULL,
       TaxID                int NULL,
       RateID               int NULL,
       ChargeTypeID         int NULL,
       ExternalSystemID     int NULL,
       GroupID              int NULL,
       DNISGroupID          int NULL,
       SortOrder            smallint NOT NULL DEFAULT (1),
       OverDue              smallint NULL DEFAULT (0),
       GLCodeID             int NULL,
       LoginLimit           int NULL,
       TimeLeft             int NULL,
       HomeDirSize          int NULL,
       SendBill             smallint NULL,
       RemoteAccess         smallint NULL,
       CommissionType       int NULL,
       CommissionValue      int NULL DEFAULT NULL,
       PayPeriodID          int NULL
)
go

CREATE UNIQUE INDEX XAK1AccountTypes ON AccountTypes
(
       AccountType
)
go


ALTER TABLE AccountTypes
       ADD PRIMARY KEY (AccountTypeID)
go


CREATE TABLE dbo.Actions (
       ActionID             int IDENTITY,
       IncidentID           int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT (GetDate()),
       Operator             varchar(15) NOT NULL DEFAULT suser_name(),
       Description          text NULL,
       Hide                 int NOT NULL DEFAULT (1),
       LastModifyDate       datetime NOT NULL DEFAULT (GetDate()),
       LastModifyUser       varchar(32) NOT NULL DEFAULT suser_name(),
       LMD_TS               timestamp NOT NULL
)
go

CREATE INDEX i_Actions_IncidentID ON Actions
(
       IncidentID
)
go


ALTER TABLE Actions
       ADD PRIMARY KEY (ActionID)
go


CREATE TABLE dbo.Addresses (
       AddressID            int IDENTITY,
       CustomerID           int NULL,
       AddressTypeID        int NOT NULL,
       Address1             varchar(50) NOT NULL,
       Address2             varchar(50) NULL,
       City                 varchar(40) NULL,
       State                varchar(40) NULL,
       Zip                  varchar(15) NULL,
       Province             varchar(40) NULL,
       Country              varchar(40) NULL,
       FirstName            varchar(25) NULL,
       LastName             varchar(25) NULL,
       Phone                varchar(20) NULL
)
go


ALTER TABLE Addresses
       ADD PRIMARY KEY (AddressID)
go


CREATE TABLE dbo.AddressTypes (
       AddressTypeID        int IDENTITY,
       AddressType          varchar(25) NOT NULL,
       SortOrder            int NOT NULL DEFAULT (1)
)
go


ALTER TABLE AddressTypes
       ADD PRIMARY KEY (AddressTypeID)
go


CREATE TABLE dbo.Aliases (
       AliasID              int IDENTITY,
       Alias                varchar(64) NOT NULL,
       AccountID            int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT (GetDate()),
       LastModifyDate       datetime NOT NULL DEFAULT (GetDate()),
       LastModifyUser       varchar(32) NOT NULL DEFAULT suser_name()
)
go

CREATE INDEX i_Aliases_AccountID ON Aliases
(
       AccountID
)
go


ALTER TABLE Aliases
       ADD PRIMARY KEY (AliasID)
go


CREATE TABLE dbo.AllowedHosts (
       AllowedHostID        int IDENTITY,
       OperatorGroupID      int NULL,
       IPAddress            varchar(16) NULL,
       Description          varchar(100) NOT NULL
)
go


ALTER TABLE AllowedHosts
       ADD PRIMARY KEY (AllowedHostID)
go


CREATE TABLE dbo.Applications (
       ApplicationID        int NOT NULL,
       AppName              varchar(32) NOT NULL
)
go

CREATE INDEX XIE1Applications ON Applications
(
       AppName
)
go


ALTER TABLE Applications
       ADD PRIMARY KEY (ApplicationID)
go


CREATE TABLE dbo.AuditLogs (
       LogMsgID             int NOT NULL,
       LogDate              datetime NOT NULL DEFAULT (GetDate()),
       LogMsg               varchar(63) NOT NULL,
       Operator             varchar(32) NULL,
       CustomerID           int NULL,
       AccountID            int NULL
)
go

CREATE INDEX i_Logs_LogDate ON AuditLogs
(
       LogDate
)
go


CREATE TABLE dbo.BankTrans (
       CustomerID           int NOT NULL,
       AuthName             varchar(50) NOT NULL,
       BankName             varchar(32) NOT NULL,
       ABANumber            varchar(16) NOT NULL,
       AccountNumber        varchar(16) NOT NULL,
       TransType            varchar(16) NULL,
       LastModifyDate       datetime NOT NULL DEFAULT (GetDate()),
       LastModifyUser       varchar(32) NOT NULL DEFAULT suser_name()
)
go


ALTER TABLE BankTrans
       ADD PRIMARY KEY (CustomerID)
go


CREATE TABLE dbo.BannedCustomers (
       BannedCustomerID     int IDENTITY,
       CallerID             varchar(30) NULL,
       IPAddress            varchar(30) NULL,
       Description          varchar(100) NOT NULL,
       Reason               varchar(255) NULL
)
go


ALTER TABLE BannedCustomers
       ADD PRIMARY KEY (BannedCustomerID)
go


CREATE TABLE dbo.BillingCycles (
       BillingCycleID       int IDENTITY,
       Description          varchar(45) NOT NULL,
       CycleType            smallint NOT NULL DEFAULT 0,
       AutoBill             smallint NOT NULL DEFAULT 0,
       BillDay              int NULL,
       IBillDays            int NOT NULL DEFAULT 15,
       EBillDays            int NOT NULL DEFAULT 5,
       SortOrder            smallint NOT NULL DEFAULT (1),
       GroupID              int NULL
)
go


ALTER TABLE BillingCycles
       ADD PRIMARY KEY (BillingCycleID)
go


CREATE TABLE dbo.Calls (
       NASIdentifier        varchar(16) NOT NULL,
       AcctSessionID        varchar(32) NOT NULL,
       AcctStatusType       tinyint NOT NULL,
       NASPort              varchar(10) NOT NULL DEFAULT (-1),
       Username             varchar(40) NOT NULL,
       CallDate             smalldatetime NOT NULL DEFAULT (GetDate()),
       AcctDelayTime        int NULL DEFAULT (0),
       AcctSessionTime      int NULL DEFAULT (0),
       FramedAddress        varchar(16) NULL,
       AcctInputOctets      numeric(10,0) NULL,
       AcctOutputOctets     numeric(10,0) NULL,
       AcctTerminateCause   smallint NULL,
       NASPortType          tinyint NULL,
       NASPortDNIS          varchar(20) NULL,
       CallerID             varchar(20) NULL,
       ConnectInfo          varchar(32) NULL,
       ServerID             int NULL,
       AccountID            int NULL
)
go

CREATE INDEX iCallDate ON Calls
(
       CallDate
)
go

CREATE INDEX iUsername ON Calls
(
       Username
)
go

CREATE INDEX iCalls_AccountID ON Calls
(
       AccountID
)
go

CREATE INDEX iCalls_ServerID ON Calls
(
       ServerID
)
go


ALTER TABLE Calls
       ADD PRIMARY KEY (NASIdentifier, AcctSessionID, AcctStatusType, 
              NASPort, Username)
go


CREATE TABLE dbo.CancelReasons (
       CancelReasonID       int IDENTITY,
       CancelDescription    varchar(100) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go


ALTER TABLE CancelReasons
       ADD PRIMARY KEY (CancelReasonID)
go


CREATE TABLE dbo.CCImportColumns (
       CCImportColumnID     int IDENTITY,
       ExportID             int NOT NULL,
       FieldType            smallint NOT NULL DEFAULT (0),
       SortOrder            smallint NOT NULL DEFAULT (1),
       Position             smallint NOT NULL,
       Description          varchar(64) NULL,
       Quoted               smallint NOT NULL DEFAULT (0),
       FieldSize            smallint NOT NULL,
       ApproveValue         varchar(50) NULL,
       DeclineValue         varchar(50) NULL,
       ErrorValue           varchar(50) NULL,
       Line                 int NOT NULL DEFAULT (1)
)
go


ALTER TABLE CCImportColumns
       ADD PRIMARY KEY (CCImportColumnID)
go


CREATE TABLE dbo.Charges (
       ChargeID             int IDENTITY,
       CustomerID           int NOT NULL,
       Description          varchar(50) NOT NULL,
       StartDate            datetime NOT NULL,
       EndDate              datetime NOT NULL,
       AccountID            int NULL,
       Login                varchar(40) NULL,
       AccountTypeID        int NULL,
       Amount               numeric(18,4) NOT NULL,
       Quantity             int NOT NULL,
       TaxID                int NULL,
       ChargeTypeID         int NULL,
       ItemID               int NULL,
       Operator             varchar(16) NULL DEFAULT suser_name(),
       LastModifyDate       datetime NOT NULL DEFAULT (GetDate()),
       LastModifyUser       varchar(32) NOT NULL DEFAULT suser_name()
)
go

CREATE INDEX iCustomerID ON Charges
(
       CustomerID
)
go

CREATE INDEX iItemID ON Charges
(
       ItemID
)
go


ALTER TABLE Charges
       ADD PRIMARY KEY (ChargeID)
go


CREATE TABLE dbo.ChargeTypes (
       ChargeTypeID         int IDENTITY,
       Description          varchar(45) NOT NULL,
       Amount               numeric(18,4) NOT NULL,
       TaxID                int NULL,
       GroupID              int NULL,
       GLCodeID             int NULL,
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go


ALTER TABLE ChargeTypes
       ADD PRIMARY KEY (ChargeTypeID)
go


CREATE TABLE dbo.ConfigGroups (
       ConfigGroupID        int IDENTITY,
       Name                 varchar(32) NOT NULL,
       SortOrder            int NOT NULL DEFAULT (1)
)
go


ALTER TABLE ConfigGroups
       ADD PRIMARY KEY (ConfigGroupID)
go


CREATE TABLE dbo.Configs (
       ConfigID             int NOT NULL,
       ConfigGroupID        int NOT NULL,
       ConfigType           smallint NOT NULL DEFAULT (1),
       Value                int NULL,
       Data                 varchar(100) NULL,
       Description          varchar(64) NOT NULL,
       Template             varchar(16) NULL DEFAULT NULL,
       SortOrder            smallint NOT NULL DEFAULT (1),
       Edition              int NULL,
       Feature              int NULL
)
go


ALTER TABLE Configs
       ADD PRIMARY KEY (ConfigID)
go


CREATE TABLE dbo.ConfigValues (
       ConfigID             int NOT NULL,
       Value                int NOT NULL,
       ValueName            varchar(64) NOT NULL
)
go


ALTER TABLE ConfigValues
       ADD PRIMARY KEY (ConfigID, Value)
go


CREATE TABLE dbo.CreditCards (
       CustomerID           int NOT NULL,
       CardHolder           varchar(50) NULL,
       CardNumber           varchar(20) NULL,
       ExpirationDate       datetime NOT NULL,
       BillToAddress1       varchar(50) NULL,
       BillToAddress2       varchar(50) NULL,
       BillToCity           varchar(40) NULL,
       BillToState          varchar(40) NULL,
       BillToProvince       varchar(40) NULL,
       BillToCountry        varchar(40) NULL,
       BillToZip            varchar(15) NULL,
       SecurityCode         varchar(16) NULL,
       Bank                 varchar(50) NULL,
       BankPhone            varchar(16) NULL,
       LastModifyUser       varchar(32) NOT NULL DEFAULT suser_name(),
       LastModifyDate       datetime NOT NULL DEFAULT (GetDate())
)
go


ALTER TABLE CreditCards
       ADD PRIMARY KEY (CustomerID)
go


CREATE TABLE dbo.Discounts (
       DiscountID           int IDENTITY,
       Discount             varchar(20) NOT NULL,
       Amount               numeric(18,4) NOT NULL DEFAULT (0),
       AmountType           smallint NOT NULL DEFAULT (1),
       GroupID              int NULL,
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go

CREATE INDEX i_Discounts_GroupID ON Discounts
(
       GroupID
)
go


ALTER TABLE Discounts
       ADD PRIMARY KEY (DiscountID)
go


CREATE TABLE dbo.DNISGroups (
       DNISGroupID          int IDENTITY,
       DNISGroup            varchar(25) NOT NULL,
       Description          varchar(45) NOT NULL
)
go

CREATE INDEX i_DNISGroups_DNISGroup ON DNISGroups
(
       DNISGroup
)
go


ALTER TABLE DNISGroups
       ADD PRIMARY KEY (DNISGroupID)
go


CREATE TABLE dbo.DNISNumbers (
       DNISGroupID          int NOT NULL,
       DNISNumber           varchar(10) NOT NULL
)
go


ALTER TABLE DNISNumbers
       ADD PRIMARY KEY (DNISGroupID, DNISNumber)
go


CREATE TABLE dbo.DomainData (
       DomainDataID         int IDENTITY,
       DomainID             int NULL,
       DataTypeID           int NOT NULL,
       Data                 varchar(255) NULL
)
go


ALTER TABLE DomainData
       ADD PRIMARY KEY (DomainDataID)
go


CREATE TABLE dbo.DomainDataTypes (
       DataTypeID           int IDENTITY,
       Description          varchar(64) NOT NULL
)
go

CREATE INDEX i_DDT_Description ON DomainDataTypes
(
       Description
)
go


ALTER TABLE DomainDataTypes
       ADD PRIMARY KEY (DataTypeID)
go


CREATE TABLE dbo.Domains (
       DomainID             int IDENTITY,
       Domain               varchar(40) NOT NULL,
       MailDomain           varchar(40) NOT NULL,
       GroupID              int NULL,
       Description          varchar(45) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go

CREATE INDEX i_Domains_Domain ON Domains
(
       Domain
)
go

CREATE INDEX i_Domains_MailDomain ON Domains
(
       MailDomain
)
go


ALTER TABLE Domains
       ADD PRIMARY KEY (DomainID)
go


CREATE TABLE dbo.ExportColumns (
       ExportColumnID       int IDENTITY,
       ExportID             int NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT (1),
       FieldName            varchar(32) NOT NULL,
       Description          varchar(64) NULL,
       Quoted               smallint NOT NULL,
       MinSize              smallint NOT NULL,
       MaxSize              smallint NOT NULL,
       Align                smallint NOT NULL,
       Format               smallint NOT NULL,
       Padding              char(1) NULL,
       ExportValue          varchar(100) NULL,
       Include              smallint NOT NULL
)
go


ALTER TABLE ExportColumns
       ADD PRIMARY KEY (ExportColumnID)
go


CREATE TABLE dbo.Exports (
       ExportID             int NOT NULL,
       Description          varchar(64) NOT NULL,
       Separator            varchar(6) NULL,
       QuoteString          varchar(6) NULL,
       SQLString            varchar(255) NOT NULL,
       HeaderRow            smallint NOT NULL,
       ApproveString        varchar(100) NULL,
       ApproveMatch         smallint NULL,
       DeclineString        varchar(100) NULL,
       DeclineMatch         smallint NULL,
       ExportType           smallint NOT NULL,
       Filter               varchar(16) NULL,
       Lines                smallint NOT NULL
)
go


ALTER TABLE Exports
       ADD PRIMARY KEY (ExportID)
go


CREATE TABLE dbo.ExternalConfigs (
       ExternalConfigID     int IDENTITY,
       Application          varchar(64) NOT NULL,
       Service              varchar(64) NOT NULL,
       Attribute            varchar(64) NOT NULL,
       Description          varchar(255) NULL,
       Type                 int NULL,
       Value                int NULL,
       Data                 varchar(255) NULL
)
go


ALTER TABLE ExternalConfigs
       ADD PRIMARY KEY (ExternalConfigID)
go


CREATE TABLE dbo.ExternalSystems (
       ExternalSystemID     int IDENTITY,
       Name                 varchar(25) NOT NULL,
       ExternalSystemType   int NOT NULL,
       ExportID             int NULL,
       Description          varchar(50) NULL,
       MailHost             varchar(40) NULL,
       Login                varchar(40) NULL,
       Password             varchar(16) NULL,
       LogFile              varchar(100) NULL,
       LastSyncDate         datetime NULL,
       FileMode             smallint NOT NULL,
       FormID               varchar(40) NULL,
       Accounts             varchar(40) NULL
)
go


ALTER TABLE ExternalSystems
       ADD PRIMARY KEY (ExternalSystemID)
go


CREATE TABLE dbo.ExternalTrans (
       ExternalTransID      int IDENTITY,
       CustomerID           int NOT NULL,
       InvoiceID            int NULL,
       TransType            int NOT NULL DEFAULT (0),
       ReqDate              datetime NOT NULL DEFAULT (GetDate()),
       ProcDate             datetime NULL,
       Amount               numeric(18,4) NOT NULL,
       PaymentID            int NULL,
       ApproveCode          varchar(12) NULL,
       Response             varchar(50) NULL,
       LastModifyDate       datetime NOT NULL DEFAULT (GetDate()),
       LastModifyUser       varchar(32) NOT NULL DEFAULT suser_name(),
       AccountNumber        varchar(16) NULL,
       AccountExpire        datetime NULL,
       AuthName             varchar(50) NULL,
       AuthAddress          varchar(50) NULL,
       AuthZip              varchar(12) NULL,
       AuthSecurityCode     varchar(10) NULL,
       BankName             varchar(32) NULL,
       BankNumber           varchar(16) NULL,
       BankTransType        varchar(16) NULL,
       RebatchTries         smallint NULL,
       LastRebatchTry       datetime NOT NULL
)
go


ALTER TABLE ExternalTrans
       ADD PRIMARY KEY (ExternalTransID)
go


CREATE TABLE dbo.FileTransfers (
       TransferDate         datetime NOT NULL,
       AccountID            int NOT NULL,
       FileName             varchar(100) NULL,
       NumBytes             int NOT NULL,
       Direction            smallint NOT NULL DEFAULT (0),
       Processed            smallint NULL
)
go

CREATE INDEX XIE1FileTransfers ON FileTransfers
(
       TransferDate,
       AccountID,
       FileName
)
go


CREATE TABLE dbo.FilterTypes (
       FilterTypeID         int IDENTITY,
       FilterType           varchar(30) NOT NULL,
       Description          varchar(64) NOT NULL,
       Checked              int NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go


ALTER TABLE FilterTypes
       ADD PRIMARY KEY (FilterTypeID)
go


CREATE TABLE dbo.FlowFilterGroups (
       FlowFilterGroupID    int IDENTITY,
       FlowFilterGroup      varchar(32) NULL,
       Description          varchar(64) NULL,
       SortOrder            int NOT NULL DEFAULT (1),
       AccountID            int NULL,
       SummaryMode          int NULL,
       CacheExpire          int NULL
)
go


ALTER TABLE FlowFilterGroups
       ADD PRIMARY KEY (FlowFilterGroupID)
go


CREATE TABLE dbo.FlowFilters (
       FlowFilterID         int IDENTITY,
       FlowFilterGroupID    int NOT NULL,
       FilterType           int NOT NULL DEFAULT (1),
       SortOrder            int NOT NULL,
       SrcIP                varchar(16) NULL,
       SrcMask              varchar(16) NULL,
       SrcPort              int NULL,
       DestIP               varchar(16) NULL,
       DestMask             varchar(16) NULL,
       DestPort             int NULL,
       Prot                 int NULL,
       CacheExpire          int NULL,
       SummaryMode          int NULL
)
go


ALTER TABLE FlowFilters
       ADD PRIMARY KEY (FlowFilterID)
go


CREATE TABLE dbo.Flows (
       FlowDate             datetime NOT NULL,
       SrcIP                int NOT NULL,
       DestIP               int NOT NULL,
       SrcPort              int NOT NULL,
       DestPort             int NOT NULL,
       Prot                 int NOT NULL,
       Packets              int NOT NULL,
       Octets               int NOT NULL,
       AccountID            int NULL,
       FlowFilterID         int NULL
)
go

CREATE INDEX iFlowDate ON Flows
(
       FlowDate
)
go


CREATE TABLE dbo.Forwards (
       ForwardID            int IDENTITY,
       Forward              varchar(64) NOT NULL,
       AccountID            int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT (GetDate()),
       LastModifyDate       datetime NOT NULL DEFAULT (GetDate()),
       LastModifyUser       varchar(32) NOT NULL DEFAULT suser_name()
)
go

CREATE INDEX i_Forwards_AccountID ON Forwards
(
       AccountID
)
go


ALTER TABLE Forwards
       ADD PRIMARY KEY (ForwardID)
go


CREATE TABLE dbo.GLCodes (
       GLCodeID             int IDENTITY,
       GLCode               varchar(32) NULL,
       Description          varchar(32) NOT NULL,
       DetailFlag           smallint NULL
)
go


ALTER TABLE GLCodes
       ADD PRIMARY KEY (GLCodeID)
go


CREATE TABLE dbo.Groups (
       GroupID              int IDENTITY,
       DomainID             int NOT NULL,
       GroupName            varchar(25) NOT NULL,
       Description          varchar(45) NOT NULL,
       InvoiceReport        varchar(45) NULL,
       InvoiceTextReport    varchar(45) NULL,
       InvoiceHTMLReport    varchar(45) NULL,
       StatementReport      varchar(45) NULL,
       StatementTextReport  varchar(45) NULL,
       StatementHTMLReport  varchar(45) NULL,
       UniqueLogins         smallint NOT NULL DEFAULT (0),
       GlobalOptions        smallint NOT NULL DEFAULT (1),
       SortOrder            smallint NOT NULL DEFAULT (1),
       FTPDir               varchar(64) NULL,
       BillingOption        smallint NULL,
       StatementRunDay      smallint NULL,
       SendCredits          smallint NULL DEFAULT (0),
       PartialPmtExtOption  smallint NULL DEFAULT (1),
       PartialPmtExtDays    smallint NULL DEFAULT (0),
       OverLimit            numeric(18,4) NULL,
       BillName             varchar(50) NOT NULL,
       BillAddress1         varchar(50) NOT NULL,
       BillAddress2         varchar(50) NULL,
       BillCity             varchar(50) NOT NULL,
       BillState            varchar(50) NOT NULL,
       BillProvince         varchar(50) NULL,
       BillZip              varchar(32) NULL,
       BillCountry          varchar(50) NULL,
       EmailAccounts        varchar(64) NOT NULL,
       EmailSubject         varchar(64) NOT NULL
)
go

CREATE INDEX i_Groups_DomainID ON Groups
(
       DomainID
)
go


ALTER TABLE Groups
       ADD PRIMARY KEY (GroupID)
go


CREATE TABLE dbo.Incidents (
       IncidentID           int IDENTITY,
       AccountID            int NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT (GetDate()),
       IncidentStateID      smallint NOT NULL,
       Operator             varchar(15) NOT NULL DEFAULT suser_name(),
       Description          text NULL,
       Hide                 int NOT NULL DEFAULT (1),
       LastModifyDate       datetime NOT NULL DEFAULT (GetDate()),
       LastModifyUser       varchar(32) NOT NULL DEFAULT suser_name(),
       IncidentTypeID       int NOT NULL,
       LMD_TS               timestamp NOT NULL
)
go

CREATE INDEX i_Incidents_AccountID ON Incidents
(
       AccountID
)
go

CREATE INDEX i_Incidents_Date ON Incidents
(
       CreateDate
)
go

CREATE INDEX i_Incidents_Operator ON Incidents
(
       Operator
)
go


ALTER TABLE Incidents
       ADD PRIMARY KEY (IncidentID)
go


CREATE TABLE dbo.IncidentStates (
       IncidentStateID      smallint NOT NULL,
       IncidentState        varchar(20) NOT NULL,
       Description          varchar(64) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go


ALTER TABLE IncidentStates
       ADD PRIMARY KEY (IncidentStateID)
go


CREATE TABLE dbo.IncidentTypes (
       IncidentTypeID       int IDENTITY,
       IncidentType         varchar(20) NOT NULL,
       Description          varchar(64) NOT NULL DEFAULT null,
       Email                varchar(40) NULL DEFAULT null,
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go


ALTER TABLE IncidentTypes
       ADD PRIMARY KEY (IncidentTypeID)
go


CREATE TABLE dbo.InvoiceItems (
       ItemID               int IDENTITY,
       InvoiceID            int NOT NULL,
       ItemType             int NOT NULL DEFAULT (1),
       Login                varchar(40) NULL,
       Description          varchar(50) NULL,
       StartDate            datetime NOT NULL,
       EndDate              datetime NOT NULL,
       AccountID            int NULL,
       Amount               numeric(18,4) NOT NULL,
       Quantity             int NOT NULL,
       TaxID                int NULL,
       PaidAmount           numeric(18,4) NOT NULL DEFAULT (0),
       AccountTypeID        int NULL,
       ChargeTypeID         int NULL,
       GLState              smallint NULL
)
go

CREATE INDEX iInvoiceID ON InvoiceItems
(
       InvoiceID
)
go


ALTER TABLE InvoiceItems
       ADD PRIMARY KEY (ItemID)
go


CREATE TABLE dbo.InvoiceNotes (
       InvoiceID            int NOT NULL,
       NoteID               int NOT NULL
)
go

CREATE INDEX XIE1InvoiceNotes ON InvoiceNotes
(
       InvoiceID
)
go


ALTER TABLE InvoiceNotes
       ADD PRIMARY KEY (InvoiceID, NoteID)
go


CREATE TABLE dbo.Invoices (
       InvoiceID            int IDENTITY,
       CustomerID           int NOT NULL,
       InvoiceTypeID        int NOT NULL,
       Amount               numeric(18,4) NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT (GetDate()),
       LastModifyDate       datetime NOT NULL DEFAULT (GetDate()),
       LastModifyUser       varchar(32) NOT NULL DEFAULT suser_name(),
       SentDate             datetime NULL DEFAULT null,
       Tax                  numeric(18,4) NOT NULL DEFAULT (0),
       StatementID          int NULL,
       Comments             varchar(100) NULL
)
go

CREATE INDEX iCustomerID ON Invoices
(
       CustomerID
)
go


ALTER TABLE Invoices
       ADD PRIMARY KEY (InvoiceID)
go


CREATE TABLE dbo.InvoiceTypes (
       InvoiceTypeID        int NOT NULL,
       InvoiceType          varchar(15) NOT NULL,
       GroupID              int NULL
)
go


ALTER TABLE InvoiceTypes
       ADD PRIMARY KEY (InvoiceTypeID)
go


CREATE TABLE dbo.IPClasses (
       IPClassID            int NOT NULL,
       IPClass              varchar(32) NOT NULL,
       Description          varchar(64) NULL,
       LastModifyDate       datetime NOT NULL,
       LastModifyUser       varchar(32) NOT NULL
)
go


ALTER TABLE IPClasses
       ADD PRIMARY KEY (IPClassID)
go


CREATE TABLE dbo.IPs (
       IPID                 int NOT NULL,
       IP                   varchar(16) NOT NULL,
       IPClassID            int NOT NULL,
       LastModifyDate       datetime NOT NULL,
       LastModifyUser       varchar(32) NOT NULL
)
go


ALTER TABLE IPs
       ADD PRIMARY KEY (IPID)
go


CREATE TABLE dbo.Languages (
       LanguageID           int NOT NULL,
       Description          varchar(30) NULL,
       Active               smallint NOT NULL DEFAULT (1),
       CurrentInUse         smallint NOT NULL,
       BaseURL              varchar(128) NULL,
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go


ALTER TABLE Languages
       ADD PRIMARY KEY (LanguageID)
go


CREATE TABLE dbo.LateNoticeNotes (
       LateNoticeID         int NOT NULL,
       NoteID               int NOT NULL
)
go

CREATE INDEX XIE1LateNoticeNotes ON LateNoticeNotes
(
       LateNoticeID
)
go


ALTER TABLE LateNoticeNotes
       ADD PRIMARY KEY (LateNoticeID, NoteID)
go


CREATE TABLE dbo.LateNotices (
       LateNoticeID         int IDENTITY,
       CustomerID           int NOT NULL,
       LateNoticeTypeID     int NOT NULL,
       NoticeDate           datetime NOT NULL DEFAULT (GetDate()),
       SentDate             datetime NOT NULL,
       Balance              numeric(18,4) NOT NULL
)
go


ALTER TABLE LateNotices
       ADD PRIMARY KEY (LateNoticeID)
go


CREATE TABLE dbo.LateNoticeTypes (
       LateNoticeTypeID     int IDENTITY,
       Description          varchar(50) NOT NULL,
       GroupID              int NULL,
       MinAmount            numeric(18,4) NOT NULL DEFAULT (0),
       MinDays              int NOT NULL DEFAULT (0),
       Amount               numeric(18,4) NOT NULL,
       AmountType           smallint NOT NULL,
       TaxID                int NULL,
       Active               smallint NOT NULL DEFAULT (1),
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go


ALTER TABLE LateNoticeTypes
       ADD PRIMARY KEY (LateNoticeTypeID)
go


CREATE TABLE dbo.LDAPServers (
       LDAPServer           varchar(50) NOT NULL,
       LastModifyDate       datetime NOT NULL,
       LastSyncRead         datetime NOT NULL,
       LastSyncWrite        datetime NOT NULL,
       Calls                int NULL
)
go


ALTER TABLE LDAPServers
       ADD PRIMARY KEY (LDAPServer)
go


CREATE TABLE dbo.Licenses (
       LicenseID            varchar(50) NOT NULL,
       Company              varchar(80) NOT NULL
)
go


ALTER TABLE Licenses
       ADD PRIMARY KEY (LicenseID)
go


CREATE TABLE dbo.LogMsgs (
       LogMsgID             int NOT NULL,
       Description          varchar(50) NOT NULL DEFAULT 'Undefined',
       Severity             int NOT NULL DEFAULT 0
)
go


ALTER TABLE LogMsgs
       ADD PRIMARY KEY (LogMsgID)
go


CREATE TABLE dbo.Logs (
       LogMsgID             int NOT NULL,
       LogDate              smalldatetime NOT NULL DEFAULT getdate(),
       LogMsg               varchar(63) NOT NULL,
       Operator             varchar(32) NULL,
       CustomerID           int NULL,
       AccountID            int NULL
)
go

CREATE INDEX i_Logs_LogDate ON Logs
(
       LogDate
)
go


CREATE TABLE dbo.MailItems (
       MailItem             varchar(15) NOT NULL,
       GroupID              int NULL
)
go


ALTER TABLE MailItems
       ADD PRIMARY KEY (MailItem)
go


CREATE TABLE dbo.MailLogs (
       LogMsgID             int NOT NULL,
       LogDate              datetime NOT NULL,
       CustomerID           int NOT NULL,
       LogDescription       varchar(100) NULL
)
go


CREATE TABLE dbo.MapAttributes (
       MapAttribute         varchar(16) NOT NULL,
       MapType              int NOT NULL,
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       RadVendorType        int NOT NULL
)
go


ALTER TABLE MapAttributes
       ADD PRIMARY KEY (MapAttribute, MapType)
go


CREATE TABLE dbo.MapValues (
       MapAttribute         varchar(16) NOT NULL,
       MapType              int NOT NULL,
       Value                varchar(32) NOT NULL,
       RadValue             int NOT NULL,
       Description          varchar(255) NULL
)
go


ALTER TABLE MapValues
       ADD PRIMARY KEY (MapAttribute, MapType, Value, RadValue)
go


CREATE TABLE dbo.MasterAccountData (
       CustomerID           int NOT NULL,
       DataTypeID           int NOT NULL,
       Data                 varchar(64) NOT NULL
)
go


ALTER TABLE MasterAccountData
       ADD PRIMARY KEY (CustomerID, DataTypeID)
go


CREATE TABLE dbo.MasterAccountDataTypes (
       DataTypeID           int IDENTITY,
       Description          varchar(64) NOT NULL,
       GroupID              int NULL
)
go

CREATE INDEX i_MAD_Description ON MasterAccountDataTypes
(
       Description
)
go


ALTER TABLE MasterAccountDataTypes
       ADD PRIMARY KEY (DataTypeID)
go


CREATE TABLE dbo.MasterAccounts (
       CustomerID           int IDENTITY,
       LastStatementID      int NULL,
       FirstName            varchar(25) NOT NULL,
       MiddleName           varchar(25) NULL,
       LastName             varchar(25) NOT NULL,
       Company              varchar(60) NULL,
       Address1             varchar(50) NULL,
       Address2             varchar(50) NULL,
       City                 varchar(40) NULL,
       State                varchar(40) NULL,
       Zip                  varchar(15) NULL,
       Province             varchar(16) NULL,
       Country              varchar(40) NULL,
       PhoneHome            varchar(20) NULL,
       PhoneWork            varchar(20) NULL,
       Gender               varchar(1) NULL
                                   CHECK (Gender IN ('M', 'F')),
       Salutation           varchar(4) NULL,
       PhoneFax             varchar(20) NULL,
       RegionID             int NOT NULL,
       ReferredBy           varchar(25) NULL,
       SalesPersonID        int NULL,
       CreateDate           datetime NOT NULL DEFAULT (GetDate()),
       StartDate            datetime NOT NULL DEFAULT (GetDate()),
       Active               smallint NOT NULL DEFAULT (1),
       PayPeriodID          int NOT NULL,
       PayMethodID          int NOT NULL,
       LastReceived         datetime NOT NULL DEFAULT (GetDate()),
       Comments             text NULL,
       Status               smallint NOT NULL DEFAULT (1),
       GroupID              int NOT NULL,
       OverDue              smallint NULL,
       SendMethodID         smallint NOT NULL,
       OverLimit            numeric(18,4) NULL,
       Taxable              smallint NOT NULL DEFAULT (1),
       BillingCycleID       int NOT NULL,
       BillDay              smallint NOT NULL DEFAULT (1),
       CancelDate           datetime NULL,
       CancelReasonID       int NULL,
       Balance              numeric(18,4) NOT NULL DEFAULT (0),
       Over30Count          smallint NOT NULL DEFAULT (0),
       Over60Count          smallint NOT NULL DEFAULT (0),
       Over90Count          smallint NOT NULL DEFAULT (0),
       Over120Count         smallint NOT NULL DEFAULT (0),
       AgedDate             datetime NULL,
       PendingCredit        numeric(18,4) NOT NULL DEFAULT (0),
       PendingDebit         numeric(18,4) NOT NULL DEFAULT (0),
       NoticeDate           datetime NULL,
       PayInfo              varchar(50) NULL,
       Operator             varchar(32) NULL DEFAULT suser_name(),
       LastModifyDate       datetime NOT NULL DEFAULT (GetDate()),
       LastModifyUser       varchar(32) NOT NULL DEFAULT suser_name(),
       LMD_TS               timestamp NOT NULL
)
go

CREATE INDEX iCompany ON MasterAccounts
(
       Company
)
go

CREATE INDEX iLastName ON MasterAccounts
(
       LastName
)
go

CREATE INDEX iBillingCycleID ON MasterAccounts
(
       BillingCycleID
)
go

CREATE INDEX i_MasterAccounts_GroupID ON MasterAccounts
(
       GroupID
)
go

CREATE INDEX i_MasterAccounts_LastMDate ON MasterAccounts
(
       LastModifyDate
)
go


ALTER TABLE MasterAccounts
       ADD PRIMARY KEY (CustomerID)
go


CREATE TABLE dbo.MetaColumns (
       MetaColumnID         int IDENTITY,
       MetaTableID          int NULL,
       ColumnName           varchar(32) NOT NULL,
       Description          varchar(255) NOT NULL,
       DepTable             varchar(32) NULL,
       DepColumn            varchar(32) NULL,
       DepGroup             int NULL,
       MetaRuleID           int NULL,
       Required             smallint NULL,
       Nullable             smallint NULL,
       Quoted               smallint NULL,
       MinSize              int NULL,
       MaxSize              int NULL,
       IsKey                smallint NULL,
       ColumnType           int NULL
)
go


ALTER TABLE MetaColumns
       ADD PRIMARY KEY (MetaColumnID)
go


CREATE TABLE dbo.MetaRules (
       MetaRuleID           int NOT NULL,
       Description          varchar(255) NULL
)
go


ALTER TABLE MetaRules
       ADD PRIMARY KEY (MetaRuleID)
go


CREATE TABLE dbo.MetaTableGroups (
       MetaTableGroupID     int NOT NULL,
       GroupName            varchar(32) NOT NULL,
       Description          varchar(255) NOT NULL
)
go


ALTER TABLE MetaTableGroups
       ADD PRIMARY KEY (MetaTableGroupID)
go


CREATE TABLE dbo.MetaTables (
       MetaTableID          int IDENTITY,
       TableName            varchar(32) NOT NULL,
       Description          varchar(255) NOT NULL,
       GroupMetaTableID     int NULL,
       MetaTableGroupID     int NULL,
       SortOrder            int NULL,
       Edition              int NULL,
       Feature              int NULL
)
go

CREATE UNIQUE INDEX XAK1MetaTables ON MetaTables
(
       TableName
)
go


ALTER TABLE MetaTables
       ADD PRIMARY KEY (MetaTableID)
go


CREATE TABLE dbo.ModemSpeeds (
       ModemSpeedID         int IDENTITY,
       ModemSpeed           varchar(5) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go


ALTER TABLE ModemSpeeds
       ADD PRIMARY KEY (ModemSpeedID)
go


CREATE TABLE dbo.NetSoftwares (
       NetSoftwareID        int IDENTITY,
       NetSoftware          varchar(15) NOT NULL,
       Map                  smallint NOT NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go


ALTER TABLE NetSoftwares
       ADD PRIMARY KEY (NetSoftwareID)
go


CREATE TABLE dbo.Notes (
       NoteID               int IDENTITY,
       NoteType             smallint NOT NULL,
       Active               smallint NOT NULL DEFAULT (1),
       StartDate            datetime NOT NULL,
       EndDate              datetime NOT NULL,
       GroupID              int NULL,
       BalanceCriteria      varchar(15) NULL,
       AcctTypeCriteria     varchar(15) NULL,
       PayDateCriteria      smallint NULL,
       Priority             smallint NULL,
       Note                 varchar(255) NULL,
       RegionID             int NULL
)
go


ALTER TABLE Notes
       ADD PRIMARY KEY (NoteID)
go


CREATE TABLE dbo.ObjectGroups (
       ObjectGroupID        int NOT NULL,
       ReportID             int NULL,
       ObjectGroup          varchar(32) NOT NULL
)
go


ALTER TABLE ObjectGroups
       ADD PRIMARY KEY (ObjectGroupID)
go


CREATE TABLE dbo.Objects (
       ObjectID             int IDENTITY,
       ObjectGroupID        int NOT NULL,
       ObjectTypeID         int NOT NULL,
       Value                int NULL,
       Data                 varchar(80) NULL,
       Description          varchar(16) NULL
)
go


ALTER TABLE Objects
       ADD PRIMARY KEY (ObjectID)
go


CREATE TABLE dbo.OnlineSignups (
       OnlineSignupID       int IDENTITY,
       FirstName            varchar(30) NULL,
       LastName             varchar(30) NULL,
       Address1             varchar(100) NULL,
       Address2             varchar(100) NULL,
       City                 varchar(50) NULL,
       State                varchar(50) NULL,
       Province             varchar(50) NULL,
       Zip                  varchar(16) NULL,
       Country              varchar(50) NULL,
       ReferredBy           varchar(25) NULL,
       Region               varchar(15) NULL,
       AccountTypeID        int NOT NULL,
       Login                varchar(40) NULL,
       Password             varchar(32) NULL,
       MaidenName           varchar(25) NULL,
       NetSoftware          varchar(15) NULL,
       SystemType           varchar(15) NULL,
       ModemSpeed           varchar(15) NULL,
       CallerID             varchar(20) NULL,
       FramedAddress        varchar(16) NULL,
       CallDate             datetime NOT NULL,
       SignUpDate           datetime NOT NULL,
       Status               varchar(16) NULL,
       PaymentOption        varchar(15) NULL,
       CardNumber           varchar(16) NULL,
       CardExpiration       varchar(20) NULL,
       SignUpComment        varchar(255) NULL
)
go

CREATE INDEX XIE1OnlineSignups ON OnlineSignups
(
       LastName,
       FirstName
)
go

CREATE INDEX XIE2OnlineSignups ON OnlineSignups
(
       Region,
       CallDate
)
go


ALTER TABLE OnlineSignups
       ADD PRIMARY KEY (OnlineSignupID)
go


CREATE TABLE dbo.OperatorCookies (
       Operator             varchar(16) NOT NULL,
       Cookie               varchar(64) NOT NULL,
       LastUsed             datetime NOT NULL DEFAULT GetDate()
)
go


CREATE TABLE dbo.OperatorGroupAccess (
       OperatorGroupID      int NOT NULL,
       GroupID              int NOT NULL,
       ObjectGroupID        int NOT NULL,
       AccessType           smallint NOT NULL DEFAULT (1)
)
go


ALTER TABLE OperatorGroupAccess
       ADD PRIMARY KEY (OperatorGroupID, GroupID, ObjectGroupID)
go


CREATE TABLE dbo.OperatorGroups (
       OperatorGroupID      int IDENTITY,
       OperatorGroup        varchar(32) NOT NULL,
       Description          varchar(64) NULL
)
go


ALTER TABLE OperatorGroups
       ADD PRIMARY KEY (OperatorGroupID)
go


CREATE TABLE dbo.Operators (
       OperatorID           int IDENTITY,
       PrintTypeID          int NULL,
       OperatorGroupID      int NOT NULL,
       Operator             varchar(15) NOT NULL,
       Password             varchar(32) NULL,
       Email                varchar(32) NULL,
       WebObjectAccess      int NULL DEFAULT (1),
       LanguageID           int NULL,
       Active               smallint NOT NULL DEFAULT (1)
)
go

CREATE UNIQUE INDEX uc_Operator ON Operators
(
       Operator
)
go

CREATE INDEX i_Operators_OperatorGroupID ON Operators
(
       OperatorGroupID
)
go


ALTER TABLE Operators
       ADD PRIMARY KEY (OperatorID)
go


CREATE TABLE dbo.Payments (
       PaymentID            int IDENTITY,
       CustomerID           int NOT NULL,
       Amount               numeric(18,4) NOT NULL,
       CreateDate           datetime NOT NULL DEFAULT (GetDate()),
       PaymentTypeID        int NOT NULL,
       CheckNumber          varchar(16) NULL,
       PayInfo              varchar(15) NULL,
       StatementID          int NULL,
       LastModifyDate       datetime NOT NULL DEFAULT (GetDate()),
       LastModifyUser       varchar(32) NOT NULL DEFAULT suser_name(),
       GLState              smallint NULL
)
go

CREATE INDEX iCustomerID ON Payments
(
       CustomerID
)
go

CREATE INDEX iDate ON Payments
(
       CreateDate
)
go


ALTER TABLE Payments
       ADD PRIMARY KEY (PaymentID)
go


CREATE TABLE dbo.PaymentTypes (
       PaymentTypeID        int IDENTITY,
       PaymentType          varchar(16) NOT NULL,
       GroupID              int NULL,
       SortOrder            smallint NOT NULL DEFAULT (1),
       GLCodeID             int NULL,
       Amount               numeric(18,4) NOT NULL DEFAULT (0),
       AmountType           smallint NOT NULL DEFAULT (1)
)
go


ALTER TABLE PaymentTypes
       ADD PRIMARY KEY (PaymentTypeID)
go


CREATE TABLE dbo.PayMethods (
       PayMethodID          int IDENTITY,
       PayMethod            varchar(15) NOT NULL,
       GroupID              int NULL,
       SortOrder            smallint NOT NULL DEFAULT (1),
       Amount               numeric(18,4) NOT NULL DEFAULT (0),
       AmountType           smallint NOT NULL DEFAULT (1)
)
go

CREATE INDEX i_PayMethods_GroupID ON PayMethods
(
       GroupID
)
go


ALTER TABLE PayMethods
       ADD PRIMARY KEY (PayMethodID)
go


CREATE TABLE dbo.PayPeriods (
       PayPeriodID          int IDENTITY,
       AccountTypeID        int NULL,
       PayPeriod            varchar(12) NOT NULL,
       Period               smallint NOT NULL,
       Amount               numeric(18,4) NOT NULL DEFAULT (0),
       AmountType           smallint NOT NULL DEFAULT (1),
       SetupCharge          smallint NOT NULL DEFAULT 0,
       GroupID              int NULL,
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go

CREATE INDEX i_PayPeriods_GroupID ON PayPeriods
(
       GroupID
)
go


ALTER TABLE PayPeriods
       ADD PRIMARY KEY (PayPeriodID)
go


CREATE TABLE dbo.PrintTypes (
       PrintTypeID          int IDENTITY,
       PrintType            varchar(32) NOT NULL,
       Data                 varchar(128) NULL,
       CRData               varchar(128) NULL
)
go

CREATE UNIQUE INDEX pk_PrintTypes ON PrintTypes
(
       PrintType
)
go


ALTER TABLE PrintTypes
       ADD PRIMARY KEY (PrintTypeID)
go


CREATE TABLE dbo.RadATConfigs (
       RadATConfigID        int IDENTITY,
       AccountTypeID        int NOT NULL,
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       RadVendorType        int NOT NULL,
       Data                 varchar(100) NOT NULL,
       Value                int NULL,
       RadCheck             smallint NOT NULL DEFAULT (0),
       Tag                  smallint NULL
)
go


ALTER TABLE RadATConfigs
       ADD PRIMARY KEY (RadATConfigID)
go


CREATE TABLE dbo.RadAttributes (
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       RadVendorType        int NOT NULL,
       Name                 varchar(32) NOT NULL,
       RadAttributeType     int NOT NULL,
       ReplyType            smallint NOT NULL,
       AliasAttributeID     int NULL,
       AliasVendorID        int NULL
)
go


ALTER TABLE RadAttributes
       ADD PRIMARY KEY (RadAttributeID, RadVendorID, RadVendorType)
go


CREATE TABLE dbo.RadConfigs (
       RadConfigID          int IDENTITY,
       AccountID            int NOT NULL,
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       RadVendorType        int NOT NULL,
       Data                 varchar(100) NOT NULL,
       Value                int NULL,
       RadCheck             smallint NOT NULL DEFAULT (0),
       Tag                  smallint NULL
)
go

CREATE INDEX i_RadConfigs_AccountID ON RadConfigs
(
       AccountID
)
go


ALTER TABLE RadConfigs
       ADD PRIMARY KEY (RadConfigID)
go


CREATE TABLE dbo.RadIPAccountTypes (
       RadIPAccountTypeID   int IDENTITY,
       ServerGroupID        int NOT NULL,
       AccountTypeID        int NULL,
       RadIPGroupID         int NULL,
       Priority             int NOT NULL DEFAULT (0)
)
go


ALTER TABLE RadIPAccountTypes
       ADD PRIMARY KEY (RadIPAccountTypeID)
go


CREATE TABLE dbo.RadIPAddresses (
       IPAddress            varchar(16) NOT NULL,
       RadIPGroupID         int NOT NULL,
       NASIdentifier        varchar(16) NULL,
       NASPort              VARCHAR(10) NULL,
       State                INT NOT NULL DEFAULT (0),
       LastUsed             datetime NULL DEFAULT (GetDate())
)
go


ALTER TABLE RadIPAddresses
       ADD PRIMARY KEY (IPAddress)
go


CREATE TABLE dbo.RadIPGroups (
       RadIPGroupID         int IDENTITY,
       RadIPGroup           varchar(32) NOT NULL
)
go


ALTER TABLE RadIPGroups
       ADD PRIMARY KEY (RadIPGroupID)
go


CREATE TABLE dbo.RadLogMsgs (
       RadLogMsgID          int NOT NULL,
       Description          varchar(50) NOT NULL,
       Severity             int NOT NULL DEFAULT (0)
)
go


ALTER TABLE RadLogMsgs
       ADD PRIMARY KEY (RadLogMsgID)
go


CREATE TABLE dbo.RadLogs (
       RadLogMsgID          int NOT NULL,
       LogDate              smalldatetime NOT NULL DEFAULT (GetDate()),
       Username             varchar(40) NOT NULL,
       Data                 varchar(50) NULL,
       NASIdentifier        varchar(16) NULL,
       NASPort              varchar(10) NULL,
       CallerID             varchar(20) NULL
)
go


ALTER TABLE RadLogs
       ADD PRIMARY KEY (RadLogMsgID, LogDate, Username)
go


CREATE TABLE dbo.RadProxyAttributeGroups (
       RadProxyAttributeGroupID int IDENTITY,
       RadRoamServerID      int NOT NULL,
       Priority             int NULL,
       Description          varchar(255) NULL
)
go


ALTER TABLE RadProxyAttributeGroups
       ADD PRIMARY KEY (RadProxyAttributeGroupID)
go


CREATE TABLE dbo.RadProxyAttributes (
       RadProxyAttributeGroupID int NOT NULL,
       SearchType           tinyint NOT NULL,
       String               varchar(253) NOT NULL,
       RadAttributeID       int NOT NULL,
       RadVendorType        int NOT NULL,
       RadVendorID          int NOT NULL,
       RadProxyAttributeID  int IDENTITY
)
go


ALTER TABLE RadProxyAttributes
       ADD PRIMARY KEY (RadProxyAttributeGroupID, SearchType, String, 
              RadAttributeID, RadVendorType, RadVendorID)
go


CREATE TABLE dbo.RadRejects (
       RadRejectID          int IDENTITY,
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       RadVendorType        int NOT NULL,
       Data                 varchar(100) NOT NULL,
       Value                int NULL
)
go


ALTER TABLE RadRejects
       ADD PRIMARY KEY (RadRejectID)
go


CREATE TABLE dbo.RadRoamDomains (
       RadRoamDomainID      int IDENTITY,
       RadRoamServerID      int NOT NULL,
       Domain               varchar(32) NOT NULL,
       Priority             int NOT NULL DEFAULT (0),
       CostPerMinute        int NOT NULL DEFAULT (0),
       AccountTypeID        int NULL
)
go

CREATE INDEX i_RadRoamDomains_Domain ON RadRoamDomains
(
       Domain
)
go


ALTER TABLE RadRoamDomains
       ADD PRIMARY KEY (RadRoamDomainID)
go


CREATE TABLE dbo.RadRoamPorts (
       NASIdentifier        varchar(16) NULL,
       Port                 varchar(10) NULL,
       AcctSessionID        varchar(16) NULL,
       Username             varchar(40) NULL,
       AcctStatusType       smallint NULL,
       CallDate             datetime NOT NULL,
       FramedAddress        varchar(16) NULL,
       CallerID             varchar(15) NULL,
       ConnectInfo          varchar(32) NULL
)
go


CREATE TABLE dbo.RadRoamServers (
       RadRoamServerID      int IDENTITY,
       IPAddress            varchar(16) NOT NULL,
       Server               varchar(32) NOT NULL,
       Secret               varchar(16) NOT NULL,
       Timeout              int NOT NULL DEFAULT (0),
       Retries              int NOT NULL DEFAULT (0),
       TreatAsLocal         smallint NOT NULL DEFAULT (0),
       StripDomain          smallint NOT NULL DEFAULT (0),
       AuthPort             int NULL,
       AcctPort             int NULL,
       RateTarget           int NULL,
       RateMax              int NULL
)
go


ALTER TABLE RadRoamServers
       ADD PRIMARY KEY (RadRoamServerID)
go


CREATE TABLE dbo.RadTriggers (
       RadTriggerID         int IDENTITY,
       AccountID            int NOT NULL,
       TriggerType          int NOT NULL DEFAULT (0),
       FileName             varchar(64) NOT NULL,
       Parameters           varchar(64) NULL,
       Directory            varchar(128) NULL
)
go


ALTER TABLE RadTriggers
       ADD PRIMARY KEY (RadTriggerID)
go


CREATE TABLE dbo.RadValues (
       RadAttributeID       int NOT NULL,
       RadVendorID          int NOT NULL,
       RadVendorType        int NOT NULL,
       Value                int NOT NULL,
       Name                 varchar(25) NOT NULL
)
go


ALTER TABLE RadValues
       ADD PRIMARY KEY (RadAttributeID, RadVendorID, RadVendorType, 
              Value)
go


CREATE TABLE dbo.RadVendors (
       RadVendorID          int NOT NULL,
       Name                 varchar(32) NOT NULL
)
go


ALTER TABLE RadVendors
       ADD PRIMARY KEY (RadVendorID)
go


CREATE TABLE dbo.RateHistory (
       AccountID            int NOT NULL,
       StartDate            datetime NOT NULL,
       HistoryType          smallint NOT NULL,
       RateID               int NULL,
       TotalCount           int NOT NULL,
       TotalTime            int NOT NULL,
       TotalData            int NOT NULL,
       ChargeID             int NULL
)
go


ALTER TABLE RateHistory
       ADD PRIMARY KEY (AccountID, StartDate, HistoryType)
go


CREATE TABLE dbo.Rates (
       RateID               int IDENTITY,
       Description          varchar(30) NOT NULL,
       MinCharge            numeric(18,4) NULL,
       MaxCharge            numeric(18,4) NULL,
       DefaultType          int NOT NULL,
       DefaultInterval      int NULL,
       DefaultCharge        numeric(18,4) NULL,
       TaxID                int NULL,
       PrimaryStart         int NULL,
       PrimaryStop          int NULL,
       PrimaryType          int NULL,
       PrimaryInterval      int NULL,
       PrimaryCharge        numeric(18,4) NULL
)
go


ALTER TABLE Rates
       ADD PRIMARY KEY (RateID)
go


CREATE TABLE dbo.RateSchedules (
       RateScheduleID       int IDENTITY,
       RateID               int NOT NULL,
       HistoryType          smallint NOT NULL DEFAULT (0),
       ScheduleType         smallint NOT NULL DEFAULT (0),
       Offset               int NOT NULL DEFAULT (0),
       Interval             int NOT NULL,
       Charge               numeric(18,4) NOT NULL DEFAULT (0),
       SortOrder            int NOT NULL
)
go


ALTER TABLE RateSchedules
       ADD PRIMARY KEY (RateScheduleID)
go


CREATE TABLE dbo.RateTables (
       RateTableID          int IDENTITY,
       RateTable            varchar(32) NOT NULL,
       Description          varchar(50) NOT NULL,
       TableName            varchar(64) NOT NULL,
       AccountIDColumn      varchar(64) NOT NULL,
       DateColumn           varchar(64) NOT NULL,
       DataColumn           varchar(64) NULL,
       TimeColumn           varchar(64) NULL,
       FilterString         varchar(200) NULL,
       PreProcess           varchar(64) NULL,
       LastProcDate         datetime NULL
)
go


ALTER TABLE RateTables
       ADD PRIMARY KEY (RateTableID)
go


CREATE TABLE dbo.ReferredBys (
       ReferredBy           varchar(25) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go


ALTER TABLE ReferredBys
       ADD PRIMARY KEY (ReferredBy)
go


CREATE TABLE dbo.Regions (
       RegionID             int IDENTITY,
       Region               varchar(15) NOT NULL,
       GroupID              int NULL,
       Taxable              smallint NULL DEFAULT 0,
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go


ALTER TABLE Regions
       ADD PRIMARY KEY (RegionID)
go


CREATE TABLE dbo.Reports (
       ReportID             int IDENTITY,
       Report               varchar(35) NOT NULL,
       FileName             varchar(15) NOT NULL,
       OperatorGroupID      int NULL,
       GroupID              int NULL
)
go


ALTER TABLE Reports
       ADD PRIMARY KEY (ReportID)
go


CREATE TABLE dbo.SalesPersons (
       SalesPersonID        int IDENTITY,
       SalesPerson          varchar(25) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT (1),
       Active               smallint NOT NULL DEFAULT (1),
       CommissionType       int NULL,
       CommissionValue      int NULL
)
go

CREATE UNIQUE INDEX iSalesPersons_SalesPerson ON SalesPersons
(
       SalesPerson
)
go


ALTER TABLE SalesPersons
       ADD PRIMARY KEY (SalesPersonID)
go


CREATE TABLE dbo.ScheduleIntervals (
       Interval             varchar(32) NOT NULL,
       Seconds              int NOT NULL
)
go


ALTER TABLE ScheduleIntervals
       ADD PRIMARY KEY (Interval)
go


CREATE TABLE dbo.ScheduleLogs (
       ScheduleID           int NOT NULL,
       Status               tinyint NOT NULL,
       Description          varchar(255) NULL,
       StartDate            datetime NOT NULL,
       EndDate              datetime NOT NULL
)
go

CREATE INDEX i_ScheduleLogs_StartDate ON ScheduleLogs
(
       StartDate
)
go


CREATE TABLE dbo.Schedules (
       ScheduleID           int IDENTITY,
       Server               varchar(32) NULL,
       ScheduleServerID     int NULL,
       TaskName             varchar(32) NOT NULL,
       Parameter            varchar(255) NULL,
       TargetSecs           int NULL,
       MaxSecs              int NULL,
       Status               smallint NOT NULL DEFAULT (0),
       LastStatus           varchar(255) NULL,
       LastStart            datetime NULL,
       LastUpdate           datetime NULL,
       Interval             int NOT NULL DEFAULT (0),
       StartDate            datetime NULL,
       Aligned              smallint NOT NULL DEFAULT (0),
       Description          varchar(100) NULL,
       LockServerID         int NULL,
       Active               smallint NOT NULL DEFAULT (1),
       MaxConcurrent        int NOT NULL DEFAULT (1),
       LastModifyDate       datetime NOT NULL DEFAULT (getdate()),
       LastModifyUser       varchar(32) NOT NULL DEFAULT (suser_name()),
       Operator             varchar(15) NULL DEFAULT (suser_name())
)
go


ALTER TABLE Schedules
       ADD PRIMARY KEY (ScheduleID)
go


CREATE TABLE dbo.ScheduleServers (
       Server               varchar(32) NOT NULL,
       ScheduleServerID     int IDENTITY,
       IPAddress            varchar(32) NULL,
       Port                 int NOT NULL,
       Description          varchar(100) NULL
)
go


ALTER TABLE ScheduleServers
       ADD PRIMARY KEY (Server)
go


CREATE TABLE dbo.ScheduleTasks (
       TaskName             varchar(32) NOT NULL,
       TaskType             varchar(32) NULL,
       Description          varchar(255) NULL
)
go


ALTER TABLE ScheduleTasks
       ADD PRIMARY KEY (TaskName)
go


CREATE TABLE dbo.SendMethods (
       SendMethodID         smallint NOT NULL,
       Description          varchar(16) NOT NULL,
       Amount               numeric(18,4) NOT NULL DEFAULT (0),
       AmountType           smallint NOT NULL DEFAULT (1),
       SortOrder            smallint NOT NULL,
       TaxID                int NULL
)
go


ALTER TABLE SendMethods
       ADD PRIMARY KEY (SendMethodID)
go


CREATE TABLE dbo.ServerAccess (
       ServerID             int NOT NULL,
       Port                 varchar(10) NULL,
       AccountTypeID        int NOT NULL,
       StartTime            int NULL,
       StopTime             int NULL,
       MaxSessionLength     int NULL DEFAULT 0
)
go


CREATE TABLE dbo.ServerGroups (
       ServerGroupID        int IDENTITY,
       ServerGroup          varchar(32) NOT NULL
)
go


ALTER TABLE ServerGroups
       ADD PRIMARY KEY (ServerGroupID)
go


CREATE TABLE dbo.ServerHistory (
       ServerID             int NOT NULL,
       HistoryDate          datetime NOT NULL DEFAULT (GetDate()),
       Calls                int NOT NULL DEFAULT (0),
       Minutes              int NOT NULL DEFAULT (0),
       Bytes                int NOT NULL DEFAULT (0)
)
go


ALTER TABLE ServerHistory
       ADD PRIMARY KEY (ServerID, HistoryDate)
go


CREATE TABLE dbo.ServerPorts (
       NASIdentifier        varchar(16) NOT NULL,
       Port                 varchar(10) NOT NULL,
       ServerID             int NOT NULL,
       IPAddress            varchar(16) NULL DEFAULT null,
       MaxSessionTime       int NULL DEFAULT 0,
       CostPerMinute        int NULL DEFAULT 0,
       Username             varchar(40) NULL DEFAULT null,
       AccountID            int NULL,
       AcctSessionID        varchar(32) NULL DEFAULT null,
       AcctStatusType       smallint NULL DEFAULT null,
       CallDate             smalldatetime NULL DEFAULT null,
       FramedAddress        varchar(16) NULL DEFAULT null,
       CallerID             varchar(20) NULL DEFAULT null,
       ConnectInfo          varchar(32) NULL DEFAULT null,
       SNMPUser             varchar(64) NULL DEFAULT null
)
go

CREATE INDEX i_ServerPorts_UserName ON ServerPorts
(
       Username
)
go


ALTER TABLE ServerPorts
       ADD PRIMARY KEY (NASIdentifier, Port, ServerID)
go


CREATE TABLE dbo.Servers (
       ServerID             int IDENTITY,
       ServerGroupID        int NOT NULL,
       Server               varchar(25) NOT NULL,
       ServerType           int NOT NULL,
       IPAddress            varchar(16) NOT NULL,
       Location             varchar(15) NOT NULL,
       Ports                smallint NOT NULL DEFAULT (0),
       Modems               smallint NOT NULL DEFAULT (0),
       PhoneNumber          varchar(12) NOT NULL,
       ContactName          varchar(25) NULL,
       ContactPhone         varchar(12) NULL,
       ContactPage          varchar(12) NULL,
       Comments             varchar(64) NULL,
       DynamicStart         varchar(16) NULL,
       DynamicEnd           varchar(16) NULL,
       Secret               varchar(16) NULL DEFAULT null,
       Community            varchar(16) NULL DEFAULT null,
       RadRoamServerID      int NULL,
       CheckAccess          int NULL DEFAULT null
)
go

CREATE UNIQUE INDEX iIPAddress ON Servers
(
       IPAddress
)
go


ALTER TABLE Servers
       ADD PRIMARY KEY (ServerID)
go


CREATE TABLE dbo.ServerTypes (
       ServerType           int NOT NULL,
       Vendor               varchar(32) NULL,
       Model                varchar(32) NULL,
       SNMPType             int NULL,
       SNMPUser             varchar(64) NULL
)
go


ALTER TABLE ServerTypes
       ADD PRIMARY KEY (ServerType)
go


CREATE TABLE dbo.StatementNotes (
       StatementID          int NOT NULL,
       NoteID               int NOT NULL
)
go

CREATE INDEX XIE1StatementNotes ON StatementNotes
(
       StatementID
)
go


CREATE TABLE dbo.Statements (
       StatementID          int IDENTITY,
       CustomerID           int NOT NULL,
       StatementDate        datetime NOT NULL DEFAULT (GetDate()),
       SentDate             datetime NULL,
       PrevBal              numeric(18,4) NOT NULL DEFAULT (0),
       NewCharges           numeric(18,4) NOT NULL,
       NewCredits           numeric(18,4) NOT NULL,
       EndBal               numeric(18,4) NOT NULL DEFAULT (0),
       End0Bal              numeric(18,4) NOT NULL DEFAULT (0),
       End30Bal             numeric(18,4) NOT NULL DEFAULT (0),
       End60Bal             numeric(18,4) NOT NULL DEFAULT (0),
       End90Bal             numeric(18,4) NOT NULL DEFAULT (0),
       End120Bal            numeric(18,4) NOT NULL DEFAULT (0)
)
go

CREATE INDEX XIE1Statements ON Statements
(
       StatementDate
)
go


ALTER TABLE Statements
       ADD PRIMARY KEY (StatementID)
go


CREATE TABLE dbo.Strings (
       StringID             int NOT NULL,
       LanguageID           int NOT NULL,
       Version              int NOT NULL,
       ApplicationID        int NOT NULL,
       Data                 varchar(255) NULL,
       URL                  varchar(60) NULL
)
go

CREATE INDEX XIE1Strings ON Strings
(
       Version
)
go


ALTER TABLE Strings
       ADD PRIMARY KEY (StringID, LanguageID, Version, ApplicationID)
go


CREATE TABLE dbo.SubAccountCredits (
       SubAccountCreditID   int IDENTITY,
       AccountID            int NOT NULL,
       RefAccountID         int NULL,
       CreditType           smallint NOT NULL DEFAULT (0),
       Amount               numeric(18,4) NOT NULL DEFAULT (0),
       AmountType           smallint NOT NULL DEFAULT (1),
       StartDate            datetime NOT NULL,
       EndDate              datetime NOT NULL
)
go


ALTER TABLE SubAccountCredits
       ADD PRIMARY KEY (SubAccountCreditID)
go


CREATE TABLE dbo.SubAccountData (
       AccountID            int NOT NULL,
       DataTypeID           int NOT NULL,
       Data                 varchar(64) NOT NULL
)
go


ALTER TABLE SubAccountData
       ADD PRIMARY KEY (AccountID, DataTypeID)
go


CREATE TABLE dbo.SubAccountDataTypes (
       DataTypeID           int IDENTITY,
       Description          varchar(64) NOT NULL,
       AccountTypeID        int NULL,
       ExternalSystemType   int NULL,
       Hidden               int NOT NULL DEFAULT (0)
)
go

CREATE INDEX i_SAD_Description ON SubAccountDataTypes
(
       Description
)
go


ALTER TABLE SubAccountDataTypes
       ADD PRIMARY KEY (DataTypeID)
go


CREATE TABLE dbo.SubAccounts (
       AccountID            int IDENTITY,
       CustomerID           int NOT NULL,
       Login                varchar(40) NULL,
       Email                varchar(40) NULL,
       FirstName            varchar(25) NULL,
       MiddleName           varchar(25) NULL,
       LastName             varchar(25) NULL,
       PhoneHome            varchar(20) NULL,
       PhoneWork            varchar(20) NULL,
       DiffCost             smallint NOT NULL DEFAULT (0),
       AccountTypeID        int NOT NULL,
       PayPeriodID          int NOT NULL,
       Cost                 numeric(18,4) NULL DEFAULT (0),
       DiscountID           int NOT NULL,
       Comments             text NULL,
       Password             varchar(32) NULL,
       MaidenName           varchar(25) NULL,
       CreateDate           datetime NOT NULL DEFAULT (GetDate()),
       StartDate            datetime NOT NULL DEFAULT (GetDate()),
       BilledThru           datetime NOT NULL DEFAULT (NULL),
       ExpireDate           datetime NULL DEFAULT (NULL),
       Extension            int NOT NULL DEFAULT (0),
       Active               smallint NOT NULL DEFAULT (1),
       SystemTypeID         int NOT NULL,
       ModemSpeedID         int NOT NULL,
       NetSoftwareID        int NOT NULL,
       SalesPersonID        int NULL,
       Operator             varchar(32) NOT NULL DEFAULT suser_name(),
       LastModifyDate       datetime NOT NULL DEFAULT (GetDate()),
       LastModifyUser       varchar(32) NOT NULL DEFAULT suser_name(),
       Preferred            smallint NOT NULL DEFAULT (0),
       Status               smallint NOT NULL DEFAULT (1),
       TimeLeft             int NULL DEFAULT (NULL),
       HomeDir              varchar(100) NULL DEFAULT (NULL),
       HomeDirLimit         int NULL DEFAULT (NULL),
       SendBill             smallint NOT NULL DEFAULT (1),
       RemoteAccess         smallint NULL DEFAULT (1),
       LoginLimit           smallint NULL DEFAULT (1),
       LastUsed             datetime NULL DEFAULT (NULL),
       DomainID             int NOT NULL,
       Gender               varchar(1) NULL
                                   CHECK (Gender IN ('M', 'F')),
       Salutation           char(4) NULL,
       LMD_TS               timestamp NOT NULL
)
go

CREATE INDEX iLastName ON SubAccounts
(
       LastName
)
go

CREATE INDEX iLogin ON SubAccounts
(
       Login
)
go

CREATE INDEX iExpireDate ON SubAccounts
(
       ExpireDate
)
go

CREATE INDEX i_SubAccounts_Email ON SubAccounts
(
       Email
)
go

CREATE INDEX i_SubAccounts_Password ON SubAccounts
(
       Password
)
go

CREATE INDEX i_SubAccounts_LastUsed ON SubAccounts
(
       LastUsed
)
go


ALTER TABLE SubAccounts
       ADD PRIMARY KEY (AccountID)
go


CREATE TABLE dbo.SysLogDefs (
       DefID                smallint NOT NULL,
       Version              smallint NOT NULL,
       Data                 varchar(255) NULL
)
go


ALTER TABLE SysLogDefs
       ADD PRIMARY KEY (DefID, Version)
go


CREATE TABLE dbo.SysLogFilters (
       SysLogFilterID       int IDENTITY,
       IPAddress            varchar(16) NULL,
       Severity             smallint NOT NULL DEFAULT (0),
       SubString            varchar(255) NULL
)
go


ALTER TABLE SysLogFilters
       ADD PRIMARY KEY (SysLogFilterID)
go


CREATE TABLE dbo.SysLogs (
       DefID                smallint NOT NULL,
       Version              smallint NOT NULL,
       LogDate              datetime NOT NULL DEFAULT (GetDate()),
       Severity             smallint NOT NULL DEFAULT (0),
       Facility             smallint NOT NULL DEFAULT (0),
       IPAddress            int NOT NULL
)
go


CREATE TABLE dbo.SystemTypes (
       SystemTypeID         int IDENTITY,
       SystemType           varchar(15) NOT NULL,
       SortOrder            smallint NOT NULL DEFAULT (1)
)
go


ALTER TABLE SystemTypes
       ADD PRIMARY KEY (SystemTypeID)
go


CREATE TABLE dbo.Taxes (
       TaxID                int IDENTITY,
       Description          varchar(32) NOT NULL,
       Description2         varchar(32) NULL,
       Tax                  numeric(18,4) NOT NULL DEFAULT 0,
       Tax2                 numeric(18,4) NOT NULL DEFAULT 0,
       TaxType              smallint NOT NULL DEFAULT 0,
       Limit                numeric(18,4) NULL,
       Limit2               numeric(18,4) NULL,
       LimitType            smallint NULL,
       CumulativeType       smallint NULL,
       GLCodeID             int NULL
)
go

CREATE INDEX i_Taxes_TaxType ON Taxes
(
       TaxType
)
go


ALTER TABLE Taxes
       ADD PRIMARY KEY (TaxID)
go


CREATE TABLE dbo.WebAccess (
       WebAccess            int NOT NULL,
       Name                 varchar(32) NOT NULL
)
go


CREATE TABLE dbo.WebConfigs (
       WebConfigID          int IDENTITY,
       Name                 varchar(32) NOT NULL,
       Value                varchar(64) NOT NULL,
       Cache                int NOT NULL
)
go


CREATE TABLE dbo.WebLinks (
       WebLinkID            int IDENTITY,
       LinkType             int NOT NULL DEFAULT (1),
       SortOrder            int NOT NULL DEFAULT (1),
       Title                varchar(24) NOT NULL,
       URL                  varchar(128) NOT NULL
)
go

CREATE VIEW CallsOnline (NASIdentifier, NASPort, Username, AcctStatusType, CallDate, FramedAddress, ConnectInfo, CallerID)  AS
       SELECT s.IPAddress, sp.Port, sp.Username, sp.AcctStatusType, sp.CallDate, sp.FramedAddress, sp.ConnectInfo, sp.CallerID
       FROM ServerPorts sp, Servers s
       WHERE s.ServerID =  sp.ServerID
go


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES GLCodes
go


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (RateID)
                             REFERENCES Rates
go


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (ExternalSystemID)
                             REFERENCES ExternalSystems
go


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (DNISGroupID)
                             REFERENCES DNISGroups
go


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (TaxID)
                             REFERENCES Taxes
go


ALTER TABLE AccountTypes
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES ChargeTypes
go


ALTER TABLE Actions
       ADD FOREIGN KEY (IncidentID)
                             REFERENCES Incidents
go


ALTER TABLE Addresses
       ADD FOREIGN KEY (AddressTypeID)
                             REFERENCES AddressTypes
go


ALTER TABLE Addresses
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
go


ALTER TABLE Aliases
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
go


ALTER TABLE AuditLogs
       ADD FOREIGN KEY (LogMsgID)
                             REFERENCES LogMsgs
go


ALTER TABLE BankTrans
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
go


ALTER TABLE BillingCycles
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE CCImportColumns
       ADD FOREIGN KEY (ExportID)
                             REFERENCES Exports
go


ALTER TABLE Charges
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES ChargeTypes
go


ALTER TABLE Charges
       ADD FOREIGN KEY (TaxID)
                             REFERENCES Taxes
go


ALTER TABLE Charges
       ADD FOREIGN KEY (ItemID)
                             REFERENCES InvoiceItems
go


ALTER TABLE Charges
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
go


ALTER TABLE ChargeTypes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES GLCodes
go


ALTER TABLE ChargeTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE ChargeTypes
       ADD FOREIGN KEY (TaxID)
                             REFERENCES Taxes
go


ALTER TABLE Configs
       ADD FOREIGN KEY (ConfigGroupID)
                             REFERENCES ConfigGroups
go


ALTER TABLE ConfigValues
       ADD FOREIGN KEY (ConfigID)
                             REFERENCES Configs
go


ALTER TABLE CreditCards
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
go


ALTER TABLE Discounts
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE DNISNumbers
       ADD FOREIGN KEY (DNISGroupID)
                             REFERENCES DNISGroups
go


ALTER TABLE DomainData
       ADD FOREIGN KEY (DomainID)
                             REFERENCES Domains
go


ALTER TABLE DomainData
       ADD FOREIGN KEY (DataTypeID)
                             REFERENCES DomainDataTypes
go


ALTER TABLE Domains
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE ExportColumns
       ADD FOREIGN KEY (ExportID)
                             REFERENCES Exports
go


ALTER TABLE ExternalSystems
       ADD FOREIGN KEY (ExportID)
                             REFERENCES Exports
go


ALTER TABLE ExternalTrans
       ADD FOREIGN KEY (InvoiceID)
                             REFERENCES Invoices
go


ALTER TABLE ExternalTrans
       ADD FOREIGN KEY (PaymentID)
                             REFERENCES Payments
go


ALTER TABLE FileTransfers
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
go


ALTER TABLE FlowFilters
       ADD FOREIGN KEY (FlowFilterGroupID)
                             REFERENCES FlowFilterGroups
go


ALTER TABLE Forwards
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
go


ALTER TABLE Groups
       ADD FOREIGN KEY (DomainID)
                             REFERENCES Domains
go


ALTER TABLE Incidents
       ADD FOREIGN KEY (IncidentStateID)
                             REFERENCES IncidentStates
go


ALTER TABLE Incidents
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
go


ALTER TABLE Incidents
       ADD FOREIGN KEY (IncidentTypeID)
                             REFERENCES IncidentTypes
go


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (ChargeTypeID)
                             REFERENCES ChargeTypes
go


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
go


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
go


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (InvoiceID)
                             REFERENCES Invoices
go


ALTER TABLE InvoiceItems
       ADD FOREIGN KEY (TaxID)
                             REFERENCES Taxes
go


ALTER TABLE InvoiceNotes
       ADD FOREIGN KEY (InvoiceID)
                             REFERENCES Invoices
go


ALTER TABLE InvoiceNotes
       ADD FOREIGN KEY (NoteID)
                             REFERENCES Notes
go


ALTER TABLE Invoices
       ADD FOREIGN KEY (StatementID)
                             REFERENCES Statements
go


ALTER TABLE Invoices
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
go


ALTER TABLE Invoices
       ADD FOREIGN KEY (InvoiceTypeID)
                             REFERENCES InvoiceTypes
go


ALTER TABLE InvoiceTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE IPs
       ADD FOREIGN KEY (IPClassID)
                             REFERENCES IPClasses
go


ALTER TABLE LateNoticeNotes
       ADD FOREIGN KEY (NoteID)
                             REFERENCES Notes
go


ALTER TABLE LateNoticeNotes
       ADD FOREIGN KEY (LateNoticeID)
                             REFERENCES LateNotices
go


ALTER TABLE LateNotices
       ADD FOREIGN KEY (LateNoticeTypeID)
                             REFERENCES LateNoticeTypes
go


ALTER TABLE LateNotices
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
go


ALTER TABLE LateNoticeTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE Logs
       ADD FOREIGN KEY (LogMsgID)
                             REFERENCES LogMsgs
go


ALTER TABLE MailItems
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE MailLogs
       ADD FOREIGN KEY (LogMsgID)
                             REFERENCES LogMsgs
go


ALTER TABLE MailLogs
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
go


ALTER TABLE MapAttributes
       ADD FOREIGN KEY (RadAttributeID, RadVendorID, RadVendorType)
                             REFERENCES RadAttributes
go


ALTER TABLE MapValues
       ADD FOREIGN KEY (MapAttribute, MapType)
                             REFERENCES MapAttributes
go


ALTER TABLE MasterAccountData
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
go


ALTER TABLE MasterAccountData
       ADD FOREIGN KEY (DataTypeID)
                             REFERENCES MasterAccountDataTypes
go


ALTER TABLE MasterAccountDataTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (LastStatementID)
                             REFERENCES Statements
go


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES SalesPersons
go


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (SendMethodID)
                             REFERENCES SendMethods
go


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (CancelReasonID)
                             REFERENCES CancelReasons
go


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (BillingCycleID)
                             REFERENCES BillingCycles
go


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (RegionID)
                             REFERENCES Regions
go


ALTER TABLE MasterAccounts
       ADD FOREIGN KEY (PayMethodID)
                             REFERENCES PayMethods
go


ALTER TABLE MetaColumns
       ADD FOREIGN KEY (MetaRuleID)
                             REFERENCES MetaRules
go


ALTER TABLE MetaColumns
       ADD FOREIGN KEY (MetaTableID)
                             REFERENCES MetaTables
go


ALTER TABLE MetaTables
       ADD FOREIGN KEY (MetaTableGroupID)
                             REFERENCES MetaTableGroups
go


ALTER TABLE Notes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE Notes
       ADD FOREIGN KEY (RegionID)
                             REFERENCES Regions
go


ALTER TABLE ObjectGroups
       ADD FOREIGN KEY (ReportID)
                             REFERENCES Reports
go


ALTER TABLE Objects
       ADD FOREIGN KEY (ObjectGroupID)
                             REFERENCES ObjectGroups
go


ALTER TABLE OperatorGroupAccess
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE OperatorGroupAccess
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES OperatorGroups
go


ALTER TABLE OperatorGroupAccess
       ADD FOREIGN KEY (ObjectGroupID)
                             REFERENCES ObjectGroups
go


ALTER TABLE Operators
       ADD FOREIGN KEY (PrintTypeID)
                             REFERENCES PrintTypes
go


ALTER TABLE Operators
       ADD FOREIGN KEY (LanguageID)
                             REFERENCES Languages
go


ALTER TABLE Operators
       ADD FOREIGN KEY (OperatorGroupID)
                             REFERENCES OperatorGroups
go


ALTER TABLE Payments
       ADD FOREIGN KEY (StatementID)
                             REFERENCES Statements
go


ALTER TABLE Payments
       ADD FOREIGN KEY (PaymentTypeID)
                             REFERENCES PaymentTypes
go


ALTER TABLE Payments
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
go


ALTER TABLE PaymentTypes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES GLCodes
go


ALTER TABLE PaymentTypes
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE PayMethods
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE PayPeriods
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE RadATConfigs
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
go


ALTER TABLE RadATConfigs
       ADD FOREIGN KEY (RadAttributeID, RadVendorID, RadVendorType)
                             REFERENCES RadAttributes
go


ALTER TABLE RadAttributes
       ADD FOREIGN KEY (RadVendorID)
                             REFERENCES RadVendors
go


ALTER TABLE RadConfigs
       ADD FOREIGN KEY (RadAttributeID, RadVendorID, RadVendorType)
                             REFERENCES RadAttributes
go


ALTER TABLE RadConfigs
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
go


ALTER TABLE RadIPAccountTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
go


ALTER TABLE RadIPAccountTypes
       ADD FOREIGN KEY (RadIPGroupID)
                             REFERENCES RadIPGroups
go


ALTER TABLE RadIPAccountTypes
       ADD FOREIGN KEY (ServerGroupID)
                             REFERENCES ServerGroups
go


ALTER TABLE RadIPAddresses
       ADD FOREIGN KEY (RadIPGroupID)
                             REFERENCES RadIPGroups
go


ALTER TABLE RadLogs
       ADD FOREIGN KEY (RadLogMsgID)
                             REFERENCES RadLogMsgs
go


ALTER TABLE RadProxyAttributes
       ADD FOREIGN KEY (RadProxyAttributeGroupID)
                             REFERENCES RadProxyAttributeGroups
go


ALTER TABLE RadRejects
       ADD FOREIGN KEY (RadAttributeID, RadVendorID, RadVendorType)
                             REFERENCES RadAttributes
go


ALTER TABLE RadRoamDomains
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
go


ALTER TABLE RadRoamDomains
       ADD FOREIGN KEY (RadRoamServerID)
                             REFERENCES RadRoamServers
go


ALTER TABLE RadTriggers
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
go


ALTER TABLE RadValues
       ADD FOREIGN KEY (RadAttributeID, RadVendorID, RadVendorType)
                             REFERENCES RadAttributes
go


ALTER TABLE RateHistory
       ADD FOREIGN KEY (ChargeID)
                             REFERENCES Charges
go


ALTER TABLE RateHistory
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
go


ALTER TABLE Rates
       ADD FOREIGN KEY (TaxID)
                             REFERENCES Taxes
go


ALTER TABLE RateSchedules
       ADD FOREIGN KEY (RateID)
                             REFERENCES Rates
go


ALTER TABLE Regions
       ADD FOREIGN KEY (GroupID)
                             REFERENCES Groups
go


ALTER TABLE Schedules
       ADD FOREIGN KEY (Server)
                             REFERENCES ScheduleServers
go


ALTER TABLE ServerAccess
       ADD FOREIGN KEY (ServerID)
                             REFERENCES Servers
go


ALTER TABLE ServerAccess
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
go


ALTER TABLE ServerHistory
       ADD FOREIGN KEY (ServerID)
                             REFERENCES Servers
go


ALTER TABLE ServerPorts
       ADD FOREIGN KEY (ServerID)
                             REFERENCES Servers
go


ALTER TABLE Servers
       ADD FOREIGN KEY (ServerGroupID)
                             REFERENCES ServerGroups
go


ALTER TABLE Servers
       ADD FOREIGN KEY (ServerType)
                             REFERENCES ServerTypes
go


ALTER TABLE Servers
       ADD FOREIGN KEY (RadRoamServerID)
                             REFERENCES RadRoamServers
go


ALTER TABLE StatementNotes
       ADD FOREIGN KEY (NoteID)
                             REFERENCES Notes
go


ALTER TABLE StatementNotes
       ADD FOREIGN KEY (StatementID)
                             REFERENCES Statements
go


ALTER TABLE Statements
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
go


ALTER TABLE Strings
       ADD FOREIGN KEY (ApplicationID)
                             REFERENCES Applications
go


ALTER TABLE Strings
       ADD FOREIGN KEY (LanguageID)
                             REFERENCES Languages
go


ALTER TABLE SubAccountCredits
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
go


ALTER TABLE SubAccountData
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
go


ALTER TABLE SubAccountData
       ADD FOREIGN KEY (DataTypeID)
                             REFERENCES SubAccountDataTypes
go


ALTER TABLE SubAccountDataTypes
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
go


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (SalesPersonID)
                             REFERENCES SalesPersons
go


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (PayPeriodID)
                             REFERENCES PayPeriods
go


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (DomainID)
                             REFERENCES Domains
go


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (AccountTypeID)
                             REFERENCES AccountTypes
go


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (CustomerID)
                             REFERENCES MasterAccounts
go


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (SystemTypeID)
                             REFERENCES SystemTypes
go


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (DiscountID)
                             REFERENCES Discounts
go


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (ModemSpeedID)
                             REFERENCES ModemSpeeds
go


ALTER TABLE SubAccounts
       ADD FOREIGN KEY (NetSoftwareID)
                             REFERENCES NetSoftwares
go


ALTER TABLE SysLogs
       ADD FOREIGN KEY (DefID, Version)
                             REFERENCES SysLogDefs
go


ALTER TABLE Taxes
       ADD FOREIGN KEY (GLCodeID)
                             REFERENCES GLCodes
go

