/* This script MUST be run before the conversion process and/or the codetabs script.  */
/*   It pre-fills new and updated tables. */

SET NOCOUNT ON
GO

-- SubAccountDataTypes
INSERT INTO SubAccountDataTypes (Description,AccountTypeID,ExternalSystemType,Hidden) VALUES('Max Message Size',NULL,-1,0)
INSERT INTO SubAccountDataTypes (Description,AccountTypeID,ExternalSystemType,Hidden) VALUES('Max Mailbox Size',NULL,-1,0)
INSERT INTO SubAccountDataTypes (Description,AccountTypeID,ExternalSystemType,Hidden) VALUES('Max Mailbox Size',NULL,-2,0)
INSERT INTO SubAccountDataTypes (Description,AccountTypeID,ExternalSystemType,Hidden) VALUES('MaxMsgs',NULL,-2,1)
INSERT INTO SubAccountDataTypes (Description,AccountTypeID,ExternalSystemType,Hidden) VALUES('Type',NULL,-2,1)
INSERT INTO SubAccountDataTypes (Description,AccountTypeID,ExternalSystemType,Hidden) VALUES('Flags',NULL,-2,1)
INSERT INTO SubAccountDataTypes (Description,AccountTypeID,ExternalSystemType,Hidden) VALUES('UserDir',NULL,-2,1)

/* ServerTypes */
/* ServerType, Vendor, Model */
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES( 0, 'Generic',    'Start at 0', 	0, NULL)
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES( 1, 'Generic',    'Start at 1',	0, NULL)
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES( 2, 'Livingston', 'Portmaster 2',	0, '.1.3.6.1.4.1.307.3.2.1.1.1.4.')
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES( 3, 'Livingston', 'Portmaster 3',	0, '.1.3.6.1.4.1.307.3.2.1.1.1.4.')
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES( 4, 'Livingston', 'Portmaster 4',	0, '.1.3.6.1.4.1.307.3.2.1.1.1.4.')
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES( 5, 'Ascend',     'Max 4000 T1',	1, '.1.3.6.1.4.1.529.12.3.1.4.')
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES( 6, 'Ascend',     'Max 4000 E1',	1, '.1.3.6.1.4.1.529.12.3.1.4.')
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES( 7, 'Ascend',     'MAX 1800 BRI',	1, '.1.3.6.1.4.1.529.12.3.1.4.')
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES( 8, 'Ascend',     'MAX TNT',	1, '.1.3.6.1.4.1.529.12.3.1.4.')
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES( 9, 'Cisco',      'AS5200',	0, '.1.3.6.1.4.1.9.2.9.2.1.18.')
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES(10, 'USR',        'Total Control',0, NULL)
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES(11, 'CompuTone',  'PowerRack',	0, NULL)
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES(12, 'Microcom',   '6000',		0, NULL)
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES(13, 'USR',	'HyperARC',	0, '.1.3.6.1.4.1.429.4.10.1.1.18.')
INSERT INTO ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) VALUES(14, 'Nortel',	'Nortel 5399',	0, '.1.3.6.1.4.1.15.2.16.1.2.1.3.1.')
GO

/* Populate SendMethods */

IF (SELECT COUNT(*) FROM SendMethods) = 0
BEGIN
INSERT INTO SendMethods (SendMethodID, Description, Amount, AmountType, SortOrder) VALUES(0, 'Postal Mail', 0, 1, 1)
INSERT INTO SendMethods (SendMethodID, Description, Amount, AmountType, SortOrder) VALUES(1, 'Email Text',  0, 1, 2)
INSERT INTO SendMethods (SendMethodID, Description, Amount, AmountType, SortOrder) VALUES(2, 'Email HTML',  0, 1, 3)
INSERT INTO SendMethods (SendMethodID, Description, Amount, AmountType, SortOrder) VALUES(3, 'None', 	    0, 1, 4)
END
GO

/* IncidentStates */

IF (SELECT COUNT(*) FROM IncidentStates) = 0
BEGIN
INSERT INTO IncidentStates(IncidentStateID,IncidentState,Description,SortOrder) VALUES (0, 'Closed',	  'Closed',	    6)
INSERT INTO IncidentStates(IncidentStateID,IncidentState,Description,SortOrder) VALUES (1, 'Open', 	  'Open',		1)
INSERT INTO IncidentStates(IncidentStateID,IncidentState,Description,SortOrder) VALUES (2, 'Assigned', 'Assigned', 	2)
INSERT INTO IncidentStates(IncidentStateID,IncidentState,Description,SortOrder) VALUES (3, 'Escalated','Escalated', 	3)
INSERT INTO IncidentStates(IncidentStateID,IncidentState,Description,SortOrder) VALUES (4, 'WIP', 	  'WIP',		4)
INSERT INTO IncidentStates(IncidentStateID,IncidentState,Description,SortOrder) VALUES (5, 'Resolved', 'Resolved', 	5)
INSERT INTO IncidentStates(IncidentStateID,IncidentState,Description,SortOrder) VALUES (9, 'Other', 	  'Other',	    9)
END
GO

/* InvoiceTypes */

IF (SELECT COUNT(*) FROM InvoiceTypes) = 0
BEGIN
INSERT INTO InvoiceTypes(InvoiceTypeID, InvoiceType, GroupID) VALUES(0, 'VOID',    		NULL)
INSERT INTO InvoiceTypes(InvoiceTypeID, InvoiceType, GroupID) VALUES(1, 'Renewal', 		NULL)
INSERT INTO InvoiceTypes(InvoiceTypeID, InvoiceType, GroupID) VALUES(2, 'Credit Card', 	NULL)
INSERT INTO InvoiceTypes(InvoiceTypeID, InvoiceType, GroupID) VALUES(3, 'EFT',   		NULL)
INSERT INTO InvoiceTypes(InvoiceTypeID, InvoiceType, GroupID) VALUES(4, 'Manual', 		NULL)
INSERT INTO InvoiceTypes(InvoiceTypeID, InvoiceType, GroupID) VALUES(5, 'Interim',  		NULL)
INSERT INTO InvoiceTypes(InvoiceTypeID, InvoiceType, GroupID) VALUES(9, 'Service Add',  	NULL)
INSERT INTO InvoiceTypes(InvoiceTypeID, InvoiceType, GroupID) VALUES(90, 'Late Fee',  	NULL)
INSERT INTO InvoiceTypes(InvoiceTypeID, InvoiceType, GroupID) VALUES(99, 'Unknown',  	NULL)
END
GO

/* PayMethods */
/* PayMethodID, PayMethod, GroupID, SortOrder, Amount, AmountType */

IF (SELECT COUNT(*) FROM PayMethods) = 0
BEGIN
--INSERT INTO PayMethods(PayMethod, GroupID, SortOrder, Amount, AmountType) VALUES('Invoice',			NULL, 1, 0, 1)
INSERT INTO PayMethods(PayMethod, GroupID, SortOrder, Amount, AmountType) VALUES('Renewal',			NULL, 2, 0, 1)
--INSERT INTO PayMethods(PayMethod, GroupID, SortOrder, Amount, AmountType) VALUES('Purchase Order', 		NULL, 3, 0, 1)
INSERT INTO PayMethods(PayMethod, GroupID, SortOrder, Amount, AmountType) VALUES('Credit Card', 		NULL, 4, 0, 1)
INSERT INTO PayMethods(PayMethod, GroupID, SortOrder, Amount, AmountType) VALUES('Bank Transfer',		NULL, 5, 0, 1)
INSERT INTO PayMethods(PayMethod, GroupID, SortOrder, Amount, AmountType) VALUES('Custom',			NULL, 6, 0, 1)
INSERT INTO PayMethods(PayMethod, GroupID, SortOrder, Amount, AmountType) VALUES('Other',			NULL, 7, 0, 1)
END
GO

/* PaymentTypes */
/* PaymentTypeID, PaymentType, GroupID, SortOrder */

IF (SELECT COUNT(*) FROM PaymentTypes) = 0
BEGIN
INSERT INTO PaymentTypes(PaymentType, GroupID, SortOrder) VALUES('Cash',		NULL, 1)
INSERT INTO PaymentTypes(PaymentType, GroupID, SortOrder) VALUES('Check',		NULL, 2)
INSERT INTO PaymentTypes(PaymentType, GroupID, SortOrder) VALUES('Credit Card', 	NULL, 3)
INSERT INTO PaymentTypes(PaymentType, GroupID, SortOrder) VALUES('Bank Transfer',	NULL, 4)
INSERT INTO PaymentTypes(PaymentType, GroupID, SortOrder) VALUES('Other',		NULL, 5)
END
GO

/* Populate Languages */

IF (SELECT COUNT(*) FROM Languages) = 0
BEGIN
INSERT INTO Languages (LanguageID, Description, Active, CurrentInUse, SortOrder) VALUES(1, 'Global',  1, 1, 0)
INSERT INTO Languages (LanguageID, Description, Active, CurrentInUse, SortOrder) VALUES(2, 'English', 1, 1, 0)
INSERT INTO Languages (LanguageID, Description, Active, CurrentInUse, SortOrder) VALUES(3, 'Spanish', 0, 0, 1)
INSERT INTO Languages (LanguageID, Description, Active, CurrentInUse, SortOrder) VALUES(4, 'French',  0, 0, 2)
INSERT INTO Languages (LanguageID, Description, Active, CurrentInUse, SortOrder) VALUES(5, 'German',  0, 0, 3)
END
GO

/* Populate SendMethods */

IF (SELECT COUNT(*) FROM RateTables) = 0
BEGIN
INSERT INTO RateTables (RateTable, Description, TableName, AccountIDColumn, DateColumn, DataColumn, TimeColumn, FilterString, LastProcDate, PreProcess) 
	VALUES('RADIUS Calls', 'RADIUS Calls', 'Calls', 'AccountID', 'CallDate', 'AcctOutputOctets', 'AcctSessionTime', ' AND AcctStatusType = 2', NULL, 'UpdateCalls_AccountID')
INSERT INTO RateTables (RateTable, Description, TableName, AccountIDColumn, DateColumn, DataColumn, TimeColumn, FilterString, LastProcDate, PreProcess) 
	VALUES('NetFlow', 'Network Packet Flows', 'Flows', 'AccountID', 'FlowDate', 'Octets', NULL, NULL, NULL, NULL)
END
GO



/* OperatorGroups */
IF (SELECT COUNT(*) FROM OperatorGroups Where OperatorGroupID = 1) = 0
BEGIN
SET IDENTITY_INSERT OperatorGroups ON
INSERT INTO OperatorGroups(OperatorGroupID, OperatorGroup, Description) VALUES(1, 'Admin', 'No Security Checking')
SET IDENTITY_INSERT OperatorGroups OFF
END
GO

IF (SELECT COUNT(*) FROM OperatorGroups Where OperatorGroupID > 1) = 0
BEGIN
SET IDENTITY_INSERT OperatorGroups ON
INSERT INTO OperatorGroups(OperatorGroupID, OperatorGroup, Description) VALUES(2, 'Tech',       'Tech Support Operators')
INSERT INTO OperatorGroups(OperatorGroupID, OperatorGroup, Description) VALUES(3, 'Accounting', 'Accounting Operators')
INSERT INTO OperatorGroups(OperatorGroupID, OperatorGroup, Description) VALUES(4, 'CustomerAccess', 'Customer Access')
SET IDENTITY_INSERT OperatorGroups OFF
END
GO

/* Operators -- default language to English */
/* OperatorID, OperatorGroupID,Operator,Password,Email,WebObjectAccess, LanguageID  */
IF (SELECT COUNT(*) FROM Operators) = 0
BEGIN
INSERT Operators (OperatorGroupID,Operator,Password,Email,WebObjectAccess,Active)
VALUES(1, 'admin', 'pass1', 'admin', 1,1)
END
GO

/* Populate ObjectGroups */

IF (SELECT COUNT(*) FROM ObjectGroups) = 0
BEGIN

/* General */
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES ( -1, 'All')

/* Admin */
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (000, 'Admin')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (001, 'General')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (002, 'Accounting')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (003, 'Global')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (004, 'RADIUS')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (005, 'Security')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (006, 'Web')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (007, 'System')

/* User */
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (100, 'Client')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (101, 'MBR')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (102, 'Services')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (103, 'Incidents')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (104, 'Invoices')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (105, 'Reports')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (106, 'Batch')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (107, 'System Logs')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (108, 'Service Mail')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (109, 'Service RADIUS')

INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (110, 'MBR Basic')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (111, 'MBR Acct')

INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (150, 'Preferences')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (200, 'Customer Access')
INSERT INTO ObjectGroups(ObjectGroupID, ObjectGroup) VALUES (999, 'Other')
END
GO

/* Populate Objects */


/* Populate Objects */
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,-1,'cookie.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,-1,'license_warning.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,-1,'nofound.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,-1,'error_query.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,-1,'error.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,-1,'email_error.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,-1,'fts_incremental.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,0,'group_header.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,0,'group.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,0,'admin.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,0,'admin_error.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,0,'admin_header.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'general.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'Domains-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'domains-delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'domains-edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'domains-list.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'domains-update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'ExternalSystems-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'externalsystems-delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'externalsystems-edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'externalsystems-list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'externalsystems-update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'ExternalSystems-Schedule.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'Groups-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'Groups-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'groups-edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'groups-list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'groups-edit-default.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'Groups-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'IncidentTypes-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'IncidentTypes-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'IncidentTypes-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'IncidentTypes-List.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'IncidentTypes-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'ModemSpeeds-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'ModemSpeeds-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'ModemSpeeds-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'ModemSpeeds-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'ModemSpeeds-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'NetSoftwares-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'NetSoftwares-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'NetSoftwares-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'NetSoftwares-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'NetSoftwares-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'ReferredBys-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'ReferredBys-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'referredbys-edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'referredbys-list.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'ReferredBys-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'Regions-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'regions-delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'regions-edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'regions-list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'regions-update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'Reports-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'Reports-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'reports-edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'reports-list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'Reports-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SalesPersons-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SalesPersons-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'salespersons-edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'salespersons-list.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SalesPersons-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SystemTypes-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SystemTypes-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'systemtypes-edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'systemtypes-list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SystemTypes-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'CompanyData-edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'CancelReasons-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'MasterAccountDataTypes-edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'MasterAccountDataTypes-list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'CancelReasons-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'CompanyData-delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'CompanyData-add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'CancelReasons-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SendMethods-Update.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SubAccountDataTypes-list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SendMethods-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'MasterAccountDataTypes-update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'MasterAccountDataTypes-add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SubAccountDataTypes-update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'CancelReasons-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SubAccountDataTypes-add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'IncidentStates-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'IncidentStates-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SubAccountDataTypes-edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'MasterAccountDataTypes-delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'CompanyData-update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SendMethods-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'Groups-Edit_global.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SubAccountDataTypes-delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'IncidentStates-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'CompanyData-list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'IncidentStates-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SendMethods-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'SendMethods-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'CancelReasons-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,1,'IncidentStates-Edit.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'accounting.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'GLCodes-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'RateSchedules-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PayMethods-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Rates-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PayMethods-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PayMethods-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'RateSchedules-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PayMethods-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PayMethods-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Rates-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PaymentTypes-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'LateNoticeTypes-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'LateNoticeTypes-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'RateSchedules-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Rates-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PaymentTypes-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Rates-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'GLCodes-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'GLCodes-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'GLCodes-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PaymentTypes-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PaymentTypes-Update.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'LateNoticeTypes-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Rates-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'LateNoticeTypes-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'RateSchedules-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PaymentTypes-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'LateNoticeTypes-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'RateSchedules-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'GLCodes-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Taxes-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Taxes-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Taxes-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Taxes-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Taxes-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'TimeRates-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'TimeRates-Delete.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'TimeRates-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'TimeRates-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'TimeRates-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PayPeriods-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PayPeriods-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PayPeriods-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PayPeriods-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'PayPeriods-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Discounts-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'BillingCycles-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'BillingCycles-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'ChargeTypes-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'ChargeTypes-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'ChargeTypes-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'ChargeTypes-List.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'ChargeTypes-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'DataRates-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'DataRates-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'DataRates-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'DataRates-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'DataRates-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Discounts-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Discounts-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Discounts-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'Discounts-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'BillingCycles-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'BillingCycles-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'BillingCycles-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'accounttypes-list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'AccountTypes-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'AccountTypes-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'AccountTypes-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,2,'accounttypes-edit.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,3,'client.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,3,'Licenses-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,3,'Licenses-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,3,'Licenses-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,3,'Licenses-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,3,'client_header.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,3,'client-edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,3,'client-update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,3,'client-values.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,3,'client_f.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'radius.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadIPGroups-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadIPAddresses-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerTypes-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'DNISNumbers-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadIPGroups-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'DNISNumbers-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerTypes-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerGroups-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadIPGroups-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadIPAddresses-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerGroups-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadIPGroups-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadIPAddresses-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'DNISGroups-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerTypes-Update.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'DNISNumbers-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'DNISGroups-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadIPAddresses-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'DNISGroups-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'DNISGroups-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerTypes-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'DNISNumbers-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'DNISGroups-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerGroups-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadIPAddresses-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'DNISNumbers-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerTypes-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerGroups-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadIPGroups-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerGroups-Delete.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadATConfigs-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadATConfigs-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'radatconfigs-edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'radatconfigs-list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadATConfigs-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadAttributes-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadAttributes-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadAttributes-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadAttributes-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadAttributes-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadLogMsgs-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadLogMsgs-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadLogMsgs-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadLogMsgs-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadLogMsgs-Update.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRejects-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRejects-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRejects-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRejects-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRejects-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamDomains-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamDomains-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamDomains-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamDomains-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamDomains-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamPorts-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamPorts-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamPorts-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamPorts-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamPorts-Update.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamServers-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamServers-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamServers-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamServers-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadRoamServers-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'Servers-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'Servers-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'servers-list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerPorts-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerPorts-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerPorts-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerPorts-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerPorts-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'Servers-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'Servers-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerAccess-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerAccess-Port.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerAccess-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerAccess-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerAccess-List-Sub.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerAccess-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'ServerAccess-Update-Delete.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadVendors-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadVendors-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadValues-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadValues-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadValues-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadValues-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadValues-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadVendors-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadVendors-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,4,'RadVendors-Edit.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'security.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opgr_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'oper_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opga_delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opga_detail_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opgr_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opgr_detail.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opga_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'security.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'security_header.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'security_reload.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'ipsec_op_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'meta_column_delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'ipsec_op_delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'ipsec_op_edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'ipsec_op_edit_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'ipsec_op_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'ipsec_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'ipsec_op_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'ipsec_op_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opgr_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'oper_edit_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opga_edit_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'oper_edit_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opga_copy_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opga_add.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opga_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'oper_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opgr_edit_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'oper_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'oper_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opga_update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opga_detail.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opga_edit_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opga_copy_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opgr_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'oper_detail.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,5,'opgr_edit_f.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'meta.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_file_edit_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'meta_column_edit_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'meta_column_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_table_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'wc_add_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'WebLinks-delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'meta_column_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'WebLinks-edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_column_add.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_table_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_column_delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'wc_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'wc_detail.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'wc_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_column_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_file_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_edit_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'WebLinks-list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_file_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_column_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'color_test.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'wc_edit_f.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_column_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_table_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'WebLinks-add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'meta_table_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_file_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_table_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'meta_table_edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'meta_table_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'meta_table_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_table_delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_column_add_all.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'meta_column_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'meta_table_add.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_file_delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'wc_edit_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'wc_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'meta_column_edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'meta_table_edit_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_file_edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'meta_header.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'meta_column_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'wc_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'WebLinks-update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'og_file_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'cache_reset.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'table2script-details.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,6,'table2script-list.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'SysLogFilters-Delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_logs_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_cfg_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'SysLogFilters-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_logs_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'syslogs_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_tasks_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_cfg_delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'SysLogFilters-List.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_tasks_delete.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_tasks_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_tasks_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_header.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_cfg_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'SysLogFilters-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_status.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_cfg_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_cfg_edit_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'syslogs_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'SysLogFilters-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_cfg_edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_tasks.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'syslogs.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_cfg.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_tasks_edit.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_logs.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,7,'sched_tasks_edit_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'body.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'error.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'cookie.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'license_warning.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'nofound.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'prompt.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'validation.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'datepicker.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'datevalidate.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'form.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'print.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'print_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'html_header.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'html_footer.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'email_error.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'checknumb.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'denied_ip.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'opgr_error.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'email_error.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'oper_error.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'error_query.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'main.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'missing_file.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'denied_file.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'meta_error.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'main_header.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'main_header_pics.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'main_header_menu.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'HM_Loader.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,100,'denied_table.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'accounts_advanced.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'accounts_mbr-search.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'accounts_mbr.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'accounts.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_detail.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_addr.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_addr_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_addr-Add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_addr-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_addr-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_addr-Delete.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_edit_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_error.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_header.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'accounts_header.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'states.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'accounts_nofound.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_detail_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_history_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'query_regions.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'query_groups.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_lock.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'accounts_advanced-search.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'accounts.rpt')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_add_save2.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_header2.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,101,'mbr_detail2_f.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_data-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_add_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_data.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'radius_edit_values_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_duplicate_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_form.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_header.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_forward_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_mail.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_mail_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_alias_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_Aliases.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_lock.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_data_f.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_data-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'radius_add_defs.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_add_setup_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_info.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_detail_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_edit_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'Accounts_Service-Search.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'accounts_service.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_detail.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_timeon.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'timeon_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'timeon_view.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_email_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'accounts_simple-search.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,102,'sa_delete.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'incidents_search2.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'incident_edit_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'incident_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'incident_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'sa_incidents.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'action_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'incident_edit_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'incident_detail.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'action_add_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'action_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'incident_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'incident_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'incidents_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'incidents_search_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'incidents.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'incidents_search.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'incident_detail_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,103,'incidents_report_f.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'mbr_statements_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'invoice_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'invoice_detail_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'statement_detail.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'statement_detail_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'invoice_header.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'mbr_statements.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'mbr_statements_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'mbr_invoices_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'statements_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'invoice_void.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'MBR_Invoices.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'MBR_History.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'invoice_detail.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'invoice_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'invoices.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'invoices_search.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'statements_search.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'invoice_void_form.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,104,'statements.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,105,'radlogs_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,105,'callinfo.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,105,'tsgraph.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,105,'tsgraph_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,105,'reports.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,105,'online_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,105,'report_header.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,105,'aging.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'batch_bill.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'batch_summary.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'batch_process.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'batch_invoice_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'batch_summary_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'batch_external_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'batch_summary_f.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'batch_summarycharges.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'batch_header.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'batch_print.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'batch.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'group_print.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'group_print_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'batch_mail.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'batch_process.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,106,'batch_taskwatch.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,107,'auditlogs_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,107,'radlogs.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,107,'emerlogs.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,107,'emerlogs_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,107,'emerlogs_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,107,'ftplogs.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,107,'ftplogs_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,107,'ftplogs_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,107,'auditlogs.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,107,'auditlogs_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,107,'radlogs_list.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,107,'online.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,108,'sa_alias_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,108,'sa_forward_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,108,'sa_forward_add_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,108,'sa_forward_delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,108,'sa_forward_list_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,108,'sa_alias_delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,108,'sa_mail.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,108,'sa_mail_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,108,'sa_alias_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,108,'sa_alias_add_save.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,109,'radius_edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,109,'sa_radius_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,109,'sa_radius.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,109,'radius_delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,109,'radius_edit_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,109,'radius_edit_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,109,'radius_add_save.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,110,'mbr_data.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,110,'mbr_data-Edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,110,'mbr_aging.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,110,'mbr_aging2_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,110,'mbr_aging_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,110,'mbr_data_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,110,'mbr_data-Update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_eft_save.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_adjustment_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_invoice_next.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_payment_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_invoice_preview.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_payinfo_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_cc_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_eft_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_eft_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_payment.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_close_form.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_cc_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_adjustment_add.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_adjustment_edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_adjustment_delete.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_statements.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_cc_edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_cc_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'creditcardinfo.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_payment_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_eft_edit.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_close.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,111,'mbr_close_check.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,150,'prefs_passwd_update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,150,'prefs.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,150,'prefs_update.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_banktrans.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_banktrans_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_billing.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_billing_update.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_billing_update_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_creditcard.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'creditcardinfo.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_creditcard_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_error.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_header.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_history.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_main.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_maint.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_mbraccess.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_online.ews')
go

INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_passwd.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_status.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_payment.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_payment_save.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cookie.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_net.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'cust_invoice.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'sched_taskwatch_f.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'body.ews')
INSERT INTO Objects (Description,Value,ObjectTypeID,ObjectGroupID,Data) VALUES(NULL,NULL,1,200,'prompt.ews')
go


/* RadVendors */
/* RadVendorID, Name  */

IF (SELECT COUNT(*) FROM RadVendors) = 0
BEGIN
INSERT INTO RadVendors(RadVendorID, Name) VALUES(   0, 'RADIUS Standard')
INSERT INTO RadVendors(RadVendorID, Name) VALUES(   5, 'ACC')
INSERT INTO RadVendors(RadVendorID, Name) VALUES(   9, 'Cisco')
INSERT INTO RadVendors(RadVendorID, Name) VALUES(  15, 'Xylogics')
INSERT INTO RadVendors(RadVendorID, Name) VALUES(  18, 'Wellfleet')
INSERT INTO RadVendors(RadVendorID, Name) VALUES(  36, 'Digital-Equipment')
INSERT INTO RadVendors(RadVendorID, Name) VALUES(  43, '3Com')
INSERT INTO RadVendors(RadVendorID, Name) VALUES(  61, 'Merit')
INSERT INTO RadVendors(RadVendorID, Name) VALUES( 166, 'Shiva')
INSERT INTO RadVendors(RadVendorID, Name) VALUES( 307, 'Livingston')
INSERT INTO RadVendors(RadVendorID, Name) VALUES( 311, 'Microsoft')
INSERT INTO RadVendors(RadVendorID, Name) VALUES( 429, 'USR')
INSERT INTO RadVendors(RadVendorID, Name) VALUES( 529, 'Ascend')
INSERT INTO RadVendors(RadVendorID, Name) VALUES(1584, 'Bay-Networks')
INSERT INTO RadVendors(RadVendorID, Name) VALUES(2352, 'RedBack Networks')
END
GO

/* RadAttributes */
/* AttributeID, Name, RadVendorType, Default, ReplyType, AliasAttribute, AliasVendor */

INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(01, 0, 0, 'User-Name', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(02, 0, 0, 'Password', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(03, 0, 0, 'Challenge-Response',	0, 0)
/* INSERT INTO RadAttributes VALUES(04, 0, 0, 'NAS-IP-Address', 	2) */
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(04, 0, 0, 'NAS-Identifier', 		2, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(05, 0, 0, 'NAS-Port', 		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(06, 0, 0, 'User-Service', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(07, 0, 0, 'Framed-Protocol', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(08, 0, 0, 'Framed-Address', 		2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(09, 0, 0, 'Framed-Netmask', 		2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(10, 0, 0, 'Framed-Routing', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(11, 0, 0, 'Framed-Filter', 		0, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(12, 0, 0, 'Framed-MTU', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(13, 0, 0, 'Framed-Compression', 	1, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(14, 0, 0, 'Login-Host', 		2, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(15, 0, 0, 'Login-Service', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(16, 0, 0, 'Login-TCP-Port', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(17, 0, 0, 'Change-Password', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(18, 0, 0, 'Reply-Message', 		0, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(19, 0, 0, 'Callback-Number', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(20, 0, 0, 'Callback-Name', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(21, 0, 0, 'Expiration', 		3, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(22, 0, 0, 'Framed-Route', 		0, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(23, 0, 0, 'Framed-IPX-Network', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(24, 0, 0, 'State', 			0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(25, 0, 0, 'Class', 			0, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 0, 0, 'Vendor-Specific', 	0, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(27,	0, 0, 'Session-Timeout', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(28,	0, 0, 'Idle-Timeout', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(29, 0, 0, 'Termination-Action', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(30, 0, 0, 'NAS-Port-DNIS', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(31, 0, 0, 'Caller-Id', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(32, 0, 0, 'NAS-Identifier', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(33, 0, 0, 'Proxy-State',		0, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(34, 0, 0, 'Login-LAT-Service', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(35, 0, 0, 'Login-LAT-Node', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(36, 0, 0, 'Login-LAT-Group', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(37, 0, 0, 'Framed-AppleTalk-Link',	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(38, 0, 0, 'Framed-AppleTalk-Network', 	1, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(39, 0, 0, 'Framed-AppleTalk-Zone', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(40, 0, 0, 'Acct-Status-Type', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(41, 0, 0, 'Acct-Delay-Time', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(42, 0, 0, 'Acct-Input-Octets', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(43, 0, 0, 'Acct-Output-Octets', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(44, 0, 0, 'Acct-Session-Id', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(45, 0, 0, 'Acct-Authentic', 		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(46, 0, 0, 'Acct-Session-Time', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(47, 0, 0, 'Acct-Input-Packets', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(48, 0, 0, 'Acct-Output-Packets', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(49, 0, 0, 'Acct-Terminate-Cause',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(50, 0, 0, 'Acct-Multi-Session-ID',  	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(51, 0, 0, 'Acct-Link-Count',		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(52, 0, 0, 'Acct-Input-Gigawords',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(53, 0, 0, 'Acct-Output-Gigawords',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(55, 0, 0, 'Event-Time',		3, 0)
GO

INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(60, 0, 0, 'CHAP-Challenge', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(61, 0, 0, 'NAS-Port-Type', 		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(62, 0, 0, 'Port-Limit', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(63, 0, 0, 'Login-LAT-Port',		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(64, 0, 0, 'Tunnel-Type', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(65, 0, 0, 'Tunnel-Medium-Type',	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(66, 0, 0, 'Tunnel-Client-Endpoint', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(67, 0, 0, 'Tunnel-Server-Endpoirt', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(68, 0, 0, 'Tunnel-Connection', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(69, 0, 0, 'Tunnel-Password', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(70, 0, 0, 'ARAP-Password', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(71, 0, 0, 'ARAP-Features', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(72, 0, 0, 'ARAP-Zone-Access', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(73, 0, 0, 'ARAP-Security', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(74, 0, 0, 'ARAP-Security-Data', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(75, 0, 0, 'Password-Retry', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(76, 0, 0, 'Prompt', 			1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(77, 0, 0, 'Connect-Info', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(78, 0, 0, 'Configuration-Token', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(79, 0, 0, 'EAP-Message', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(80, 0, 0, 'Signature', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(81, 0, 0, 'Tunnel-Private-Group-ID',	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(82, 0, 0, 'Tunnel-Assignment-ID',  	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(83, 0, 0, 'Tunnel-Preference', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(84, 0, 0, 'ARAP-Challenge-Response',	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(85, 0, 0, 'Acct-Interim-Interval',  	0, 1)

INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(90, 0, 0, 'Ascend-Filter', 			0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(91, 0, 0, 'Ascend-Telnet-Profile',		0, 1)
GO

INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(120, 0, 0, 'Ascend-Modem-PortNo', 		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(121, 0, 0, 'Ascend-Modem-SlotNo', 		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(122, 0, 0, 'Ascend-Modem-ShelfNo', 		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(128, 0, 0, 'Ascend-Shared-Profile-Enable', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(133, 0, 0, 'Ascend-BACP-Enable',	 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(172, 0, 0, 'Ascend-Base-Channel-Count', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(176, 0, 0, 'Ascend-Backup',	 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(187, 0, 0, 'Ascend-Multilink-ID',		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(188, 0, 0, 'Ascend-Num-In-Multilink',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(189, 0, 0, 'Ascend-First-Dest',		2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(190, 0, 0, 'Ascend-Pre-Input-Octets',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(191, 0, 0, 'Ascend-Pre-Output-Octets',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(192, 0, 0, 'Ascend-Pre-Input-Packets',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(193, 0, 0, 'Ascend-Pre-Output-Packets',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(194, 0, 0, 'Ascend-Maximum-Time',		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(195, 0, 0, 'Ascend-Disconnect-Cause',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(196, 0, 0, 'Ascend-Connect-Progress',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(197, 0, 0, 'Ascend-Data-Rate',		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(198, 0, 0, 'Ascend-PreSession-Time',		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(199, 0, 0, 'Ascend-Token-Idle', 		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(200, 0, 0, 'Ascend-Token-Immediate', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(201, 0, 0, 'Ascend-Require-Auth', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(202, 0, 0, 'Ascend-Number-Sessions', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(203, 0, 0, 'Ascend-Authen-Alias', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(204, 0, 0, 'Ascend-Token-Expiry', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(205, 0, 0, 'Ascend-Menu-Selector', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(206, 0, 0, 'Ascend-Menu-Item', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(207, 0, 0, 'Ascend-PW-Warntime', 		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(208, 0, 0, 'Ascend-PW-Lifetime', 		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(209, 0, 0, 'Ascend-IP-Direct', 		2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(210, 0, 0, 'Ascend-PPP-VJ-Slot-Comp', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(211, 0, 0, 'Ascend-PPP-VJ-1172', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(212, 0, 0, 'Ascend-PPP-Async-Map', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(213, 0, 0, 'Ascend-Third-Prompt', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(214, 0, 0, 'Ascend-Send-Secret', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(215, 0, 0, 'Ascend-Receive-Secret', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(216, 0, 0, 'Ascend-IPX-Peer-Mode', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(217, 0, 0, 'Ascend-IP-Pool-Definition', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(218, 0, 0, 'Ascend-Assign-IP-Pool', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(219, 0, 0, 'Ascend-FR-Direct', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(220, 0, 0, 'Ascend-FR-Direct-Profile', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(221, 0, 0, 'Ascend-FR-Direct-DLCI', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(222, 0, 0, 'Ascend-Handle-IPX', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(223, 0, 0, 'Ascend-Netware-timeout', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(224, 0, 0, 'Ascend-IPX-Alias', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(225, 0, 0, 'Ascend-Metric', 			1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(226, 0, 0, 'Ascend-PRI-Number-Type', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(227, 0, 0, 'Ascend-Dial-Number', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(228, 0, 0, 'Ascend-Route-IP', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(229, 0, 0, 'Ascend-Route-IPX', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(230, 0, 0, 'Ascend-Bridge', 			1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(231, 0, 0, 'Ascend-Send-Auth', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(232, 0, 0, 'Ascend-Send-Passwd', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(233, 0, 0, 'Ascend-Link-Compression', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(234, 0, 0, 'Ascend-Target-Util', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(235, 0, 0, 'Ascend-Maximum-Channels', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(236, 0, 0, 'Ascend-Inc-Channel-Count', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(237, 0, 0, 'Ascend-Dec-Channel-Count', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(238, 0, 0, 'Ascend-Seconds-Of-History', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(239, 0, 0, 'Ascend-History-Weigh-Type', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(240, 0, 0, 'Ascend-Add-Seconds', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(241, 0, 0, 'Ascend-Remove-Seconds', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(242, 0, 0, 'Ascend-Data-Filter', 		4, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(243, 0, 0, 'Ascend-Call-Filter', 		4, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(244, 0, 0, 'Ascend-Idle-Limit', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(245, 0, 0, 'Ascend-Preempt-Limit', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(246, 0, 0, 'Ascend-Callback', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(247, 0, 0, 'Ascend-Data-Svc', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(248, 0, 0, 'Ascend-Force-56', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(249, 0, 0, 'Ascend-Billing-Number', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(250, 0, 0, 'Ascend-Call-By-Call', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(251, 0, 0, 'Ascend-Transit-Number', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(252, 0, 0, 'Ascend-Host-Info', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(253, 0, 0, 'Ascend-PPP-Address', 		2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(254, 0, 0, 'Ascend-MPP-Idle-Percent', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(255, 0, 0, 'Ascend-Xmit-Rate', 		1, 0)
GO

IF (SELECT COUNT(*) FROM RadAttributes Where RadVendorID = 5) = 0
BEGIN
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 1, 'Acc-Reason-Code', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 2, 'Acc-CCP-Option', 			1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 3, 'Acc-Input-Errors', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 4, 'Acc-Output-Errors', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 5, 'Acc-Access-Partition', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 6, 'Acc-Customer-Id', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 7, 'Acc-Ip-Gateway-Pri', 		2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 8, 'Acc-Ip-Gateway-Sec', 		2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 9, 'Acc-Route-Policy', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 10, 'Acc-ML-MLX-Admin-State',		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 11, 'Acc-ML-Call-Threshold', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 12, 'Acc-ML-Clear-Threshold', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 13, 'Acc-ML-Damping-Factor', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 14, 'Acc-Tunnel-Secret', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 15, 'Acc-Clearing-Cause', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 16, 'Acc-Clearing-Location', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 17, 'Acc-Service-Profile', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 18, 'Acc-Request-Type', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 19, 'Acc-Bridging-Support', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 20, 'Acc-VPSM-Oversubscribed', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 21, 'Acc-Acct-On-Off-Reason', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 22, 'Acc-Tunnel-Port',	 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 23, 'Acc-Dns-Server-Pri', 		2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 24, 'Acc-Dns-Server-Sec', 		2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 25, 'Acc-Nbns-Server-Pri', 		2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 5, 26, 'Acc-Nbns-Server-Sec', 		2, 1)
END
GO

IF (SELECT COUNT(*) FROM RadAttributes Where RadVendorID = 9) = 0
BEGIN
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9,   1, 'Cisco-AVPair', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9,   2, 'Cisco-NAS-Port',		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 187, 'Multilink-ID', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 188, 'Num-In-Multilink', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 190, 'Pre-Input-Octets', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 191, 'Pre-Output-Octets', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 192, 'Pre-Input-Packets', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 193, 'Pre-Output-Packets', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 195, 'Disconnect-Cause', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 197, 'Data-Rate',	 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 198, 'PreSession-Time', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 250, 'Account-Info', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 251, 'Service-Info', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 252, 'Command-Code', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 9, 253, 'Control-Info', 		0, 1)
END
GO

IF (SELECT COUNT(*) FROM RadAttributes Where RadVendorID = 61) = 0
BEGIN
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 61, 144, 'Reply-If-Ack-Message', 0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 61, 145, 'LAS-Start-Time', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 61, 146, 'LAS-Code', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 61, 147, 'LAS-Duration', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 61, 148, 'Local-Duration', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 61, 149, 'Huntgroup-Service', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 61, 150, 'Port-Entry', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 61, 211, 'Proxy-Action', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 61, 213, 'Token', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 61, 219, 'Ownership', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 61, 220, 'Subgroup', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 61, 221, 'Huntgroup-Name', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 61, 222, 'User-Id', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 61, 223, 'User-Realm', 		0, 0)
END
GO

IF (SELECT COUNT(*) FROM RadAttributes Where RadVendorID = 307) = 0
BEGIN
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 307,  2, 'LE-Terminate-Detail', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 307,  3, 'LE-Advice-of-Change', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 307,  4, 'LE-Connect-Detail', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 307,  5, 'LE-SA-ID',	 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 307,  9, 'LE-IPSec-Log-Options', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 307, 10, 'LE-IPSec-Policy-Deny', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 307, 11, 'LE-IPSec-Active-Profile', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 307, 12, 'LE-IPSec-Outsource-Profile', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 307, 13, 'LE-IPSec-Passive-Profile', 	0, 1)
END
GO

IF (SELECT COUNT(*) FROM RadAttributes Where RadVendorID = 311) = 0
BEGIN
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  1, 'MS-CHAP-Response', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  2, 'MS-CHAP-Error', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  3, 'MS-CHAP-CPW-1', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  4, 'MS-CHAP-CPW-2', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  5, 'MS-CHAP-LM-Enc-PW', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  6, 'MS-CHAP-NT-Enc-PW', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  7, 'MS-MPPE-Encryption-Policy',0, 0)
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 7, 1, 'Encryption-Allowed')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 7, 2, 'Encryption-Required')
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  8, 'MS-MPPE-Encryption-Type', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  9, 'MS-RAS-Vendor', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  10, 'MS-CHAP-Domain', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  11, 'MS-CHAP-Challenge', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  12, 'MS-CHAP-MPPE-Keys', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  13, 'MS-BAP-Usage', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  14, 'MS-Link-Utilization-Threshold', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  15, 'MS-Link-Drop-Time-Limit', 0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  16, 'MS-MPPE-Send-Key', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  17, 'MS-MPPE-Recv-Key', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  18, 'MS-RAS-Version', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  19, 'MS-Old-ARAP-Password', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  20, 'MS-New-ARAP-Password', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  21, 'MS-ARAP-PW-Change-Reason',0, 0)
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 21, 1, 'Just-Change-Password')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 21, 2, 'Expired-Password')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 21, 3, 'Admin-Req-Pass-Change')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 21, 4, 'Password-Too-Short')
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  22, 'MS-Filter', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  23, 'MS-Acct-Auth-Type', 	0, 0)
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 23, 1, 'PAP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 23, 2, 'CHAP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 23, 3, 'MS-CHAP-1')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 23, 4, 'MS-CHAP-2')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 23, 5, 'EAP')
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  24, 'MS-Acct-EAP-Type', 	0, 0)
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 24, 4, 'MD5')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 24, 5, 'OTP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 24, 6, 'Generic Token Card')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 311, 24, 13, 'TLS')
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  25, 'MS-CHAP2-Response', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  26, 'MS-CHAP2-Success', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  27, 'MS-CHAP2-CPW', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  28, 'MS-Primary-DNS-Server', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  29, 'MS-Secondary-DNS-Server', 0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  30, 'MS-Primary-NBNS-Server', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  31, 'MS-Secondary-NBNS-Server',0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 311,  33, 'MS-ARAP-Challenge', 	0, 0)
END
GO

IF (SELECT COUNT(*) FROM RadAttributes Where RadVendorID = 429) = 0
BEGIN
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429,   108, 'Modulation_Type',		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429,   153, 'Simplified_MNP_Levels',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429,   199, 'Simplified_V42bis_Usage',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36864, 'IP-Input-Filter', 		0, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36867, 'IP-Output-Filter', 		0, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36872, 'IES-Next-Hop-Gateway', 	2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36879, 'Primary-DNS-Server', 	2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36880, 'Secondary-DNS-Server',	2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36881, 'Primary-NBNS-Server', 	2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36882, 'Secondary-NBNS-Server',	2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36889, 'Chasis-Call-Slot',		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36890, 'Chasis-Call-Span',		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36891, 'Chasis-Call-Channel',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36893, 'Unauthenticated_Time',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36899, 'Connect-Speed',		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36900, 'Framed-IP-Address-Pool-Name',	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36901, 'MP-EDO',			0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 36902, 'Local-Framed-IP-Addr',	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38913, 'Speed-Of-Connection', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38914, 'Max-Channels', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38918, 'Compression-Algorithm',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38931, 'Send-Name', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38932, 'Send-Password', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38933, 'Start-Time', 		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38934, 'End-Time', 			1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38949, 'Local-IP-Address', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38950, 'Routing-Protocol', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38951, 'Modem-Group',	 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38959, 'MP_MRRU',			1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38977, 'MP-EDO-HIPER',		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38978, 'Modem-Training-Time',	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38979, 'Interface_Index',		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 38998, 'VTS-Session-Key',		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 39000, 'Call-Arrival-Time',	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 39001, 'Call-End-Time',		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 48733, 'Channel-Connected-To', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 48734, 'Slot-Connected-To', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 429, 48735, 'Device-Connected-To', 	1, 0)
END
GO

IF (SELECT COUNT(*) FROM RadAttributes Where RadVendorID = 529) = 0
BEGIN
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 90, 'Filter', 		0, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 91, 'Telnet-Profile',	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 120, 'Modem-PortNo', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 121, 'Modem-SlotNo', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 122, 'Modem-ShelfNo', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 128, 'Shared-Profile-Enable',1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 133, 'BACP-Enable',	 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 187, 'Multilink-ID',		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 188, 'Num-In-Multilink',	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 189, 'First-Dest',		2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 190, 'Pre-Input-Octets',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 191, 'Pre-Output-Octets',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 192, 'Pre-Input-Packets',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 193, 'Pre-Output-Packets',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 194, 'Maximum-Time',		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 195, 'Disconnect-Cause',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 196, 'Connect-Progress',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 197, 'Data-Rate',		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 198, 'PreSession-Time',	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 199, 'Token-Idle', 		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 200, 'Token-Immediate', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 201, 'Require-Auth', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 202, 'Number-Sessions', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 203, 'Authen-Alias', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 204, 'Token-Expiry', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 205, 'Menu-Selector', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 206, 'Menu-Item', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 207, 'PW-Warntime', 		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 208, 'PW-Lifetime', 		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 209, 'IP-Direct', 		2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 210, 'PPP-VJ-Slot-Comp', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 211, 'PPP-VJ-1172', 		1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 212, 'PPP-Async-Map', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 213, 'Third-Prompt', 	0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 214, 'Send-Secret', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 215, 'Receive-Secret', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 216, 'IPX-Peer-Mode', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 217, 'IP-Pool-Definition', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 218, 'Assign-IP-Pool', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 219, 'FR-Direct', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 220, 'FR-Direct-Profile', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 221, 'FR-Direct-DLCI', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 222, 'Handle-IPX', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 223, 'Netware-timeout', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 224, 'IPX-Alias', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 225, 'Metric', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 226, 'PRI-Number-Type', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 227, 'Dial-Number', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 228, 'Route-IP', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 229, 'Route-IPX', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 230, 'Bridge', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 231, 'Send-Auth', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 232, 'Send-Passwd', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 233, 'Link-Compression', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 234, 'Target-Util', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 235, 'Maximum-Channels', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 236, 'Inc-Channel-Count', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 237, 'Dec-Channel-Count', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 238, 'Seconds-Of-History', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 239, 'History-Weigh-Type', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 240, 'Add-Seconds', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 241, 'Remove-Seconds', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 242, 'Data-Filter', 		4, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 243, 'Call-Filter', 		4, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 244, 'Idle-Limit', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 245, 'Preempt-Limit', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 246, 'Callback', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 247, 'Data-Svc', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 248, 'Force-56', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 249, 'Billing-Number', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 250, 'Call-By-Call', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 251, 'Transit-Number', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 252, 'Host-Info', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 253, 'PPP-Address', 		2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 254, 'MPP-Idle-Percent', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 529, 255, 'Xmit-Rate', 		1, 0)
END
GO

IF (SELECT COUNT(*) FROM RadAttributes Where RadVendorID = 1584) = 0
BEGIN
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 28, 'Annex-Filter', 		0, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 29, 'Annex-CLI-Command', 		0, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 30, 'Annex-CLI-Filter', 		0, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 31, 'Annex-Host-Restrict', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 32, 'Annex-Host-Allow', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 33, 'Annex-Product-Name', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 34, 'Annex-SW-Version', 		0, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 35, 'Annex-Local-IP-Address', 	2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 36, 'Annex-Callback-Portlist', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 37, 'Annex-Sec-Profile-Index', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 38, 'Annex-Tunnel-Authen-Type', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 39, 'Annex-Tunnel-Authen-Mode', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 40, 'Annex-Authen-Servers', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 41, 'Annex-Acct-Servers', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 42, 'Annex-User-Server-Location', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 43, 'Annex-Local-Username', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 44, 'Annex-System-Disc-Reason', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 45, 'Annex-Modem-Disc-Reason', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 46, 'Annex-Disconnect-Reason', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 47, 'Annex-Addr-Resolution-Protocol', 1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 48, 'Annex-Addr-Resolution-Servers', 0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 49, 'Annex-Domain-Name', 		0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 50, 'Annex-Transmit-Speed', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 51, 'Annex-Receive-Speed', 	1, 0)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 52, 'Annex-Input-Filter', 		0, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 53, 'Annex-Output-Filter', 	0, 2)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 54, 'Annex-Primary-DNS-Server', 	2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 55, 'Annex-Secondary-DNS-Server', 	2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 56, 'Annex-Primary-NBNS-Server', 	2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 57, 'Annex-Secondary-NBNS-Server', 2, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 59, 'Annex-Keypress-Timeout', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 60, 'Annex-Unauthenticated-Time', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 61, 'Annex-Re-CHAP-Timeout', 	1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 62, 'Annex-MRRU', 			1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 63, 'Annex-EDO', 			0, 1)

INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 65, 'Tunnel-Medium-Type', 		1, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 66, 'Acct-Tunnel-Endpoint', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 67, 'Tunnel-Server-Endpoint', 	0, 1)
INSERT INTO RadAttributes (RadAttributeID,RadVendorID,RadVendorType,Name,RadAttributeType,ReplyType) VALUES(26, 1584, 68, 'Acct-Tunnel-Connect-ID', 	0, 1)
END
GO


/* RadValues */

/* 'AttributeID','Name', 'Value' */
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(6, 0, 0, 1, 'Login-User')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(6, 0, 0, 2, 'Framed-User')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(6, 0, 0, 3, 'Callback-Login')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(6, 0, 0, 4, 'Callback-Framed')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(6, 0, 0, 5, 'Outbound')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(6, 0, 0, 6, 'Administrative')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(6, 0, 0, 7, 'NAS-Prompt')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(6, 0, 0, 8, 'Authenicate-Only')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(6, 0, 0, 9, 'Callback-NAS-Prompt')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(6, 0, 0, 129, 'Call-Check-User')
GO

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(7, 0, 0, 1, 'PPP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(7, 0, 0, 2, 'SLIP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(7, 0, 0, 3, 'ARA')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(7, 0, 0, 4, 'Gandalf')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(7, 0, 0, 5, 'Xylogics')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(7, 0, 0, 256, 'MPP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(7, 0, 0, 257, 'EURAW')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(7, 0, 0, 258, 'EUUI')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(7, 0, 0, 259, 'X25')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(7, 0, 0, 260, 'COMB')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(7, 0, 0, 261, 'FR')
GO

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(10, 0, 0, 0, 'None')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(10, 0, 0, 1, 'Broadcast')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(10, 0, 0, 2, 'Listen')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(10, 0, 0, 3, 'Broadcast-Listen')
GO

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(13, 0, 0, 0, 'None')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(13, 0, 0, 1, 'Van-Jacobsen-TCP-IP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(13, 0, 0, 2, 'IPX-Header-Compression')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(15, 0, 0, 0, 'Telnet')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(15, 0, 0, 1, 'Rlogin')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(15, 0, 0, 2, 'TCP-Clear')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(15, 0, 0, 3, 'PortMaster')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(15, 0, 0, 4, 'LAT')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(15, 0, 0, 5, 'X25-PAD')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(15, 0, 0, 6, 'X25-T3POS')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(29, 0, 0, 0, 'Default')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(29, 0, 0, 1, 'RADIUS-Request')
GO

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(40, 0, 0, 1, 'Start')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(40, 0, 0, 2, 'Stop')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(40, 0, 0, 3, 'Alive')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(40, 0, 0, 4, 'Modem-Start')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(40, 0, 0, 5, 'Modem-Stop')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(40, 0, 0, 6, 'Cancel')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(40, 0, 0, 7, 'Accounting-On')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(40, 0, 0, 8, 'Accounting-Off')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(45, 0, 0, 0, 'None')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(45, 0, 0, 1, 'RADIUS')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(45, 0, 0, 2, 'Local')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 1, 'User-Request')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 2, 'Lost-Carrier')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 3, 'Lost-Service')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 4, 'Idle-Timeout')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 5, 'Session-Timeout')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 6, 'Admin-Reset')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 7, 'Admin-Reboot')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 8, 'Port-Error')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 9, 'NAS-Error')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 10, 'NAS-Request')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 11, 'NAS-Reboot')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 12, 'Port-Unneeded')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 13, 'Port-Preempted')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 14, 'Port-Suspended')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 15, 'Service-Unavailable')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 16, 'Callback')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 17, 'User-Error')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(49, 0, 0, 18, 'Host-Request')
GO

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(61,  0, 0, 0, 'Async')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(61,  0, 0, 1, 'Sync')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(61,  0, 0, 2, 'ISDN')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(61,  0, 0, 3, 'ISDN-V120')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(61,  0, 0, 4, 'ISDN-V110')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(61,  0, 0, 5, 'Virtual')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(61,  0, 0, 6, 'PAIFS')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(61,  0, 0, 7, 'HDLC-Clear-Channel')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(61,  0, 0, 8, 'X25')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(61,  0, 0, 9, 'X75')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(64,  0, 0, 1, 'PPTP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(64,  0, 0, 2, 'L2F')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(64,  0, 0, 3, 'L2TP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(64,  0, 0, 4, 'ATMP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(64,  0, 0, 5, 'VTP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(64,  0, 0, 6, 'AH')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(64,  0, 0, 7, 'IP-IP-Encap')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(64,  0, 0, 8, 'MIN-IP-IP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(64,  0, 0, 9, 'ESP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(64,  0, 0, 10, 'PPTP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(64,  0, 0, 11, 'DVS')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(64,  0, 0, 12, 'IP-IP')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 1, 'IP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 2, 'IP6')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 3, 'NSAP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 4, 'HDLC')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 5, 'BBN')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 6, 'IEEE-802')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 7, 'E-163')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 8, 'E-164')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 9, 'F-69')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 10, 'X-121')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 11, 'IPX')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 12, 'Appletalk')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 13, 'Decnet4')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 14, 'Vines')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(65,  0, 0, 15, 'E-164-NSAP')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(72,  0, 0, 1, 'Default-Zone')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(72,  0, 0, 2, 'Inclusive-Filter')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(72,  0, 0, 3, 'Exclusive-Filter')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(76,  0, 0, 1, 'No-Echo')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(76,  0, 0, 2, 'Echo')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(128, 0, 0, 0, 'Shared-Profile-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(128, 0, 0, 1, 'Shared-Profile-Yes')
GO

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(133, 0, 0, 0, 'BACP-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(133, 0, 0, 1, 'BACP-Yes')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(200, 0, 0, 0, 'Tok-Imm-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(200, 0, 0, 1, 'Tok-Imm-Yes')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(201, 0, 0, 0, 'Not-Require-Auth')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(201, 0, 0, 1, 'Require-Auth')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(207, 0, 0, 0, 'Days-Of-Warning')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(208, 0, 0, 0, 'Lifetime-In-Days')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(210, 0, 0, 1, 'VJ-Slot-Comp-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(211, 0, 0, 1, 'PPP-VJ-1172')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(219, 0, 0, 0, 'FR-Direct-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(219, 0, 0, 1, 'FR-Direct-Yes')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(222, 0, 0, 0, 'Handle-IPX-None')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(222, 0, 0, 1, 'Handle-IPX-Client')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(222, 0, 0, 2, 'Handle-IPX-Server')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(216, 0, 0, 0, 'IPX-Peer-Router')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(216, 0, 0, 1, 'IPX-Peer-Dialin')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(226, 0, 0, 0, 'Unknown-Number')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(226, 0, 0, 1, 'Intl-Number')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(226, 0, 0, 2, 'National-Number')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(226, 0, 0, 4, 'Local-Number')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(226, 0, 0, 5, 'Abbrev-Number')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(228, 0, 0, 0, 'Route-IP-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(228, 0, 0, 1, 'Route-IP-Yes')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(229, 0, 0, 0, 'Route-IPX-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(229, 0, 0, 1, 'Route-IPX-Yes')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(230, 0, 0, 0, 'Bridge-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(230, 0, 0, 1, 'Bridge-Yes')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(231, 0, 0, 0, 'Send-Auth-None')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(231, 0, 0, 1, 'Send-Auth-PAP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(231, 0, 0, 2, 'Send-Auth-CHAP')
GO

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(233, 0, 0, 0, 'Link-Comp-None')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(233, 0, 0, 1, 'Link-Comp-Stac')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(239, 0, 0, 0, 'History-Constant')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(239, 0, 0, 1, 'History-Linear')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(239, 0, 0, 2, 'History-Quadratic')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(246, 0, 0, 0, 'Callback-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(246, 0, 0, 1, 'Callback-Yes')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 0, 'Switched-Voice-Bearer')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 1, 'Switched-56KR')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 2, 'Switched-64K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 3, 'Switched-64KR')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 4, 'Switched-56K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 5, 'Switched-384KR')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 6, 'Switched-384K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 7, 'Switched-1536K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 8, 'Switched-1536KR')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 9, 'Switched-128K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 10, 'Switched-192K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 11, 'Switched-256K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 12, 'Switched-320K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 13, 'Switched-384K-MR')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 14, 'Switched-448K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 15, 'Switched-512K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 16, 'Switched-576K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 17, 'Switched-640K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 18, 'Switched-704K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 19, 'Switched-768K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 20, 'Switched-832K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 21, 'Switched-896K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 22, 'Switched-960K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 23, 'Switched-1024K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 24, 'Switched-1088K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 25, 'Switched-1152K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 26, 'Switched-1216K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 27, 'Switched-1280K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 28, 'Switched-1344K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 29, 'Switched-1408K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 30, 'Switched-1472K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 31, 'Switched-1600K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 32, 'Switched-1664K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 33, 'Switched-1728K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 34, 'Switched-1792K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 35, 'Switched-1856K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(247, 0, 0, 36, 'Switched-1920K')
GO

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(248, 0, 0, 0, 'Force-56-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(248, 0, 0, 1, 'Force-56-Yes')
GO

IF (SELECT COUNT(*) FROM RadValues Where RadVendorID = 307) = 0
BEGIN
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 307, 9, 1, 'SA-Success-On')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 307, 9, 2, 'SA-Failure-On')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 307, 9, 3, 'Console-On')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 307, 9, 4, 'Syslog-On')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 307, 9, 5, 'SA-Success-Off')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 307, 9, 6, 'SA-Failure-Off')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 307, 9, 7, 'Console-Off')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 307, 9, 8, 'Syslog-Off')

INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 307, 10, 1, 'Drop')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 307, 10, 2, 'ICMP-Reject')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 307, 10, 3, 'Pass-Through')
END
GO

IF (SELECT COUNT(*) FROM RadValues Where RadVendorID = 529) = 0
BEGIN
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 128, 0, 'Shared-Profile-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 128, 1, 'Shared-Profile-Yes')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 133, 0, 'BACP-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 133, 1, 'BACP-Yes')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 200, 0, 'Tok-Imm-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 200, 1, 'Tok-Imm-Yes')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 201, 0, 'Not-Require-Auth')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 201, 1, 'Require-Auth')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 207, 0, 'Days-Of-Warning')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 208, 0, 'Lifetime-In-Days')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 210, 1, 'VJ-Slot-Comp-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 211, 1, 'PPP-VJ-1172')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 219, 0, 'FR-Direct-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 219, 1, 'FR-Direct-Yes')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 222, 0, 'Handle-IPX-None')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 222, 1, 'Handle-IPX-Client')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 222, 2, 'Handle-IPX-Server')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 216, 0, 'IPX-Peer-Router')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 216, 1, 'IPX-Peer-Dialin')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 226, 0, 'Unknown-Number')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 226, 1, 'Intl-Number')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 226, 2, 'National-Number')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 226, 4, 'Local-Number')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 226, 5, 'Abbrev-Number')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 228, 0, 'Route-IP-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 228, 1, 'Route-IP-Yes')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 229, 0, 'Route-IPX-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 229, 1, 'Route-IPX-Yes')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 230, 0, 'Bridge-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 230, 1, 'Bridge-Yes')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 231, 0, 'Send-Auth-None')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 231, 1, 'Send-Auth-PAP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 231, 2, 'Send-Auth-CHAP')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 233, 0, 'Link-Comp-None')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 233, 1, 'Link-Comp-Stac')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 239, 0, 'History-Constant')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 239, 1, 'History-Linear')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 239, 2, 'History-Quadratic')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 246, 0, 'Callback-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 246, 1, 'Callback-Yes')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 0, 'Switched-Voice-Bearer')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 1, 'Switched-56KR')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 2, 'Switched-64K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 3, 'Switched-64KR')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 4, 'Switched-56K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 5, 'Switched-384KR')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 6, 'Switched-384K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 7, 'Switched-1536K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 8, 'Switched-1536KR')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 9, 'Switched-128K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 10, 'Switched-192K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 11, 'Switched-256K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 12, 'Switched-320K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 13, 'Switched-384K-MR')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 14, 'Switched-448K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 15, 'Switched-512K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 16, 'Switched-576K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 17, 'Switched-640K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 18, 'Switched-704K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 19, 'Switched-768K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 20, 'Switched-832K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 21, 'Switched-896K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 22, 'Switched-960K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 23, 'Switched-1024K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 24, 'Switched-1088K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 25, 'Switched-1152K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 26, 'Switched-1216K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 27, 'Switched-1280K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 28, 'Switched-1344K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 29, 'Switched-1408K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 30, 'Switched-1472K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 31, 'Switched-1600K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 32, 'Switched-1664K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 33, 'Switched-1728K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 34, 'Switched-1792K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 35, 'Switched-1856K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 247, 36, 'Switched-1920K')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 248, 0, 'Force-56-No')
INSERT INTO RadValues (RadAttributeID,RadVendorID,RadVendorType,Value,Name) VALUES(26, 529, 248, 1, 'Force-56-Yes')
END
GO

/* This is the RadLogMsg Lookup Table */
IF (SELECT COUNT(*) FROM RadLogMsgs) = 0
BEGIN
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(0, 'Generic Message', 0)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(1, 'Generic Error', 5)

INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(10, 'User Not Found', 3)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(11, 'Bad Password', 3)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(12, 'User Expired', 2)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(13, 'User OverDue', 2)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(14, 'Over Login Limit', 1)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(15, 'No Time Left', 1)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(16, 'Port Not Allowed', 2)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(17, 'Reject Attribute', 2)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(18, 'Check Attribute', 2)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(19, 'No Attributes', 3)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(20, 'User Inactive', 2)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(21, 'Start Date not reached',2)

INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(40, 'SNMP Check Failed', 1)

INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(50, 'Bad Request', 4)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(51, 'No Username', 4)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(52, 'No Password', 4)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(53, 'Bad Digest', 6)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(54, 'Bad username', 3)

INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(60, 'Parse Error', 5)
INSERT INTO RadLogMsgs(RadLogMsgID, Description, Severity) VALUES(100, 'Chap Not Allowed', 5)
END
GO

SET IDENTITY_INSERT ConfigGroups ON
INSERT INTO ConfigGroups (SortOrder,ConfigGroupID,Name) VALUES(10,1,'Client')
-- INSERT INTO ConfigGroups (SortOrder,ConfigGroupID,Name) VALUES(20,2,'External Systems')
INSERT INTO ConfigGroups (SortOrder,ConfigGroupID,Name) VALUES(30,3,'FTP')
INSERT INTO ConfigGroups (SortOrder,ConfigGroupID,Name) VALUES(40,4,'SMTP')
INSERT INTO ConfigGroups (SortOrder,ConfigGroupID,Name) VALUES(50,5,'Reports')
INSERT INTO ConfigGroups (SortOrder,ConfigGroupID,Name) VALUES(60,6,'Accounting')
-- INSERT INTO ConfigGroups (SortOrder,ConfigGroupID,Name) VALUES(70,7,'RADIUS')
INSERT INTO ConfigGroups (SortOrder,ConfigGroupID,Name) VALUES(80,8,'Web')
INSERT INTO ConfigGroups (SortOrder,ConfigGroupID,Name) VALUES(65,9,'CC Batch')
INSERT INTO ConfigGroups (SortOrder,ConfigGroupID,Name) VALUES(68,10,'ACH Batch')
INSERT INTO ConfigGroups (SortOrder,ConfigGroupID,Name) VALUES(90,11,'Logs')
INSERT INTO ConfigGroups (SortOrder,ConfigGroupID,Name) VALUES(100,12,'Signup Server')
SET IDENTITY_INSERT ConfigGroups OFF
GO

IF (SELECT COUNT(*) FROM ServerGroups) = 0
BEGIN
SET IDENTITY_INSERT ServerGroups ON
INSERT INTO ServerGroups (ServerGroupID, ServerGroup) VALUES(1, 'Other')
SET IDENTITY_INSERT ServerGroups OFF
END
GO

IF (SELECT COUNT(*) FROM LateNoticeTypes) = 0
BEGIN
SET IDENTITY_INSERT LateNoticeTypes ON
INSERT INTO LateNoticeTypes (LateNoticeTypeID,Description,GroupID,MinAmount,MinDays,Amount,AmountType,TaxID,Active,SortOrder) VALUES(1, '60 Days', NULL, 5.00, 60, 1.00, 1, NULL, 0, 1)
INSERT INTO LateNoticeTypes (LateNoticeTypeID,Description,GroupID,MinAmount,MinDays,Amount,AmountType,TaxID,Active,SortOrder) VALUES(2, '90 Days', NULL, 0, 90, 2.00, 1, NULL, 0, 1)
INSERT INTO LateNoticeTypes (LateNoticeTypeID,Description,GroupID,MinAmount,MinDays,Amount,AmountType,TaxID,Active,SortOrder) VALUES(3, '2%', NULL, 0.00, 60, 2.00, 0, NULL, 0, 1)
SET IDENTITY_INSERT LateNoticeTypes OFF
END
GO

IF (SELECT COUNT(*) FROM LateNoticeTypes) = 0
BEGIN
SET IDENTITY_INSERT LateNoticeTypes ON
INSERT INTO LateNoticeTypes (LateNoticeTypeID,Description,GroupID,MinAmount,MinDays,Amount,AmountType,TaxID,Active,SortOrder) VALUES(1, '60 Days', NULL, 5.00, 60, 1.00, 1, NULL, 0, 1)
INSERT INTO LateNoticeTypes (LateNoticeTypeID,Description,GroupID,MinAmount,MinDays,Amount,AmountType,TaxID,Active,SortOrder) VALUES(2, '90 Days', NULL, 0, 90, 2.00, 1, NULL, 0, 1)
INSERT INTO LateNoticeTypes (LateNoticeTypeID,Description,GroupID,MinAmount,MinDays,Amount,AmountType,TaxID,Active,SortOrder) VALUES(3, '2%', NULL, 0.00, 60, 2.00, 0, NULL, 0, 1)
SET IDENTITY_INSERT LateNoticeTypes OFF
END
GO

/* Data */
INSERT INTO ScheduleTasks (TaskName,TaskType,Description) VALUES('shell','Scheduler','Run External Programs')
INSERT INTO ScheduleTasks (TaskName,TaskType,Description) VALUES('query','Scheduler','Run database query')
INSERT INTO ScheduleTasks (TaskName,TaskType,Description) VALUES('tasksummary','Usage Summary','Create Usage Summary Records')
INSERT INTO ScheduleTasks (TaskName,TaskType,Description) VALUES('taskcharges','Usage Charges','Create Usage Charges')
INSERT INTO ScheduleTasks (TaskName,TaskType,Description) VALUES('taskinvoice','Invoices','Create Invoices')
INSERT INTO ScheduleTasks (TaskName,TaskType,Description) VALUES('taskstatement','Statements','Create Statements')
INSERT INTO ScheduleTasks (TaskName,TaskType,Description) VALUES('userexport','Exports','Account export (Enter ESID as parameter)')
INSERT INTO ScheduleTasks (TaskName,TaskType,Description) VALUES('ccexport','Exports','Credit Card export')
INSERT INTO ScheduleTasks (TaskName,TaskType,Description) VALUES('achexport','Exports','ACH export')
INSERT INTO ScheduleTasks (TaskName,TaskType,Description) VALUES('ccimport','Exports','Credit Card import')
INSERT INTO ScheduleTasks (TaskName,TaskType,Description) VALUES('achimport','Exports','ACH import')
GO

INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('Run Once',0)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('5 Minutes',300)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('10 Minutes',600)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('15 Minutes',900)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('30 Minutes',1800)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('1 Hour',3600)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('2 Hours',7200)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('3 Hours',10800)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('1/4 Day',21600)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('1/2 Day',43200)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('Daily',86400)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('2 Days',173274)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('Weekly',606461)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('2 Weeks',1314000)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('Monthly',2628000)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('2 Months',5256000)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('Quarterly',7884000)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('Six Months',15768000)
INSERT INTO ScheduleIntervals (Interval,Seconds) VALUES('Annually',31536000)
GO

-- Schedules
INSERT INTO Schedules (Description,TaskName,MaxSecs,Active,Server,Aligned,Parameter,TargetSecs,Status,LastModifyDate,Operator,Interval,LockServerID,ScheduleServerID,MaxConcurrent,LastUpdate,LastModifyUser,LastStatus,LastStart,StartDate) VALUES('Update account timebank','query',NULL,1,NULL,1,'{CALL Update_TimeLeft}',NULL,0,'2001-04-09 10:56:56.977','admin',86400,NULL,NULL,1,NULL,'admin',NULL,NULL,'2000-01-01 00:01:00')
INSERT INTO Schedules (Description,TaskName,MaxSecs,Active,Server,Aligned,Parameter,TargetSecs,Status,LastModifyDate,Operator,Interval,LockServerID,ScheduleServerID,MaxConcurrent,LastUpdate,LastModifyUser,LastStatus,LastStart,StartDate) VALUES('Database check','query',NULL,1,NULL,1,'DBCC CheckDB',NULL,0,'2001-04-09 10:56:56.977','admin',606461,NULL,NULL,1,NULL,'admin',NULL,NULL,'2000-01-01 04:00:00')
INSERT INTO Schedules (Description,TaskName,MaxSecs,Active,Server,Aligned,Parameter,TargetSecs,Status,LastModifyDate,Operator,Interval,LockServerID,ScheduleServerID,MaxConcurrent,LastUpdate,LastModifyUser,LastStatus,LastStart,StartDate) VALUES('Trim calls','query',NULL,1,NULL,1,'{CALL TrimCalls}',NULL,0,'2001-04-09 10:56:56.977','admin',21600,NULL,NULL,1,NULL,'admin',NULL,NULL,'2000-01-01 02:20:00')
INSERT INTO Schedules (Description,TaskName,MaxSecs,Active,Server,Aligned,Parameter,TargetSecs,Status,LastModifyDate,Operator,Interval,LockServerID,ScheduleServerID,MaxConcurrent,LastUpdate,LastModifyUser,LastStatus,LastStart,StartDate) VALUES('Trim database logs','query',NULL,1,NULL,1,'{CALL TrimLogs}',NULL,0,'2001-04-09 10:56:56.977','admin',86400,NULL,NULL,1,NULL,'admin',NULL,NULL,'2000-01-01 02:40:00')

INSERT INTO Schedules (Description,TaskName,MaxSecs,Active,Server,Aligned,Parameter,TargetSecs,Status,LastModifyDate,Operator,Interval,LockServerID,ScheduleServerID,MaxConcurrent,LastUpdate,LastModifyUser,LastStatus,LastStart,StartDate) VALUES('Calls Table Nightly Processing','tasksummary',NULL,1,NULL,1,'1',NULL,0,'2001-04-09 10:47:14.127','admin',86400,NULL,NULL,1,NULL,'admin',NULL,NULL,'2000-01-01 01:30:00')
INSERT INTO Schedules (Description,TaskName,MaxSecs,Active,Server,Aligned,Parameter,TargetSecs,Status,LastModifyDate,Operator,Interval,LockServerID,ScheduleServerID,MaxConcurrent,LastUpdate,LastModifyUser,LastStatus,LastStart,StartDate) VALUES('Netflow Nightly Processing','tasksummary',NULL,0,NULL,1,'2',NULL,0,'2001-04-09 11:01:45.350','admin',86400,NULL,NULL,1,NULL,'admin',NULL,NULL,'2000-01-01 03:00:00')
INSERT INTO Schedules (Description,TaskName,MaxSecs,Active,Server,Aligned,Parameter,TargetSecs,Status,LastModifyDate,Operator,Interval,LockServerID,ScheduleServerID,MaxConcurrent,LastUpdate,LastModifyUser,LastStatus,LastStart,StartDate) VALUES('Create Usage Charges','taskcharges',NULL,1,NULL,1,NULL,NULL,0,'2001-04-09 10:56:56.977','admin',2628000,NULL,NULL,1,NULL,'admin',NULL,NULL,'2000-01-01 05:00:00')
INSERT INTO Schedules (Description,TaskName,MaxSecs,Active,Server,Aligned,Parameter,TargetSecs,Status,LastModifyDate,Operator,Interval,LockServerID,ScheduleServerID,MaxConcurrent,LastUpdate,LastModifyUser,LastStatus,LastStart,StartDate) VALUES('Create Invoices','taskinvoice',NULL,0,NULL,1,NULL,NULL,0,'2001-04-09 10:59:52.467','admin',86400,NULL,NULL,1,NULL,'admin',NULL,NULL,'2000-01-01 06:00:00')
INSERT INTO Schedules (Description,TaskName,MaxSecs,Active,Server,Aligned,Parameter,TargetSecs,Status,LastModifyDate,Operator,Interval,LockServerID,ScheduleServerID,MaxConcurrent,LastUpdate,LastModifyUser,LastStatus,LastStart,StartDate) VALUES('Create Statements','taskstatement',NULL,0,NULL,1,NULL,NULL,0,'2001-04-09 10:57:28.620','admin',0,NULL,NULL,1,NULL,'admin',NULL,NULL,'2000-01-01 07:00:00')
GO

/* Applications */

INSERT INTO Applications(ApplicationID, AppName) VALUES(1, 'Global')		-- Below 1000
INSERT INTO Applications(ApplicationID, AppName) VALUES(2, 'EmerWeb')		-- 1000 App, 10000 Scripts
INSERT INTO Applications(ApplicationID, AppName) VALUES(3, 'EmerClock')		-- 2000 
INSERT INTO Applications(ApplicationID, AppName) VALUES(4, 'EmerLog')		-- 3000
INSERT INTO Applications(ApplicationID, AppName) VALUES(5, 'EmerDAP')		-- 4000
INSERT INTO Applications(ApplicationID, AppName) VALUES(6, 'RADIUS')		-- 5000
INSERT INTO Applications(ApplicationID, AppName) VALUES(7, 'EmerAuth')		-- 6000
INSERT INTO Applications(ApplicationID, AppName) VALUES(8, 'EmerExport')	-- 7000
GO

/* Populate Strings */

DECLARE @appid int
Select @appid = ApplicationID From Applications Where AppName = 'EmerWeb'
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10101, '<IMG src="/images/accounts.jpg" BORDER=0 ALT="Accounts">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10102, '<IMG src="/images/invoices.jpg" BORDER=0 ALT="Invoices">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10103, '<IMG src="/images/statements.jpg" BORDER=0 ALT="Statements">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10104, '<IMG src="/images/batch.jpg" BORDER=0 ALT="Batch">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10105, '<IMG src="/images/reports.jpg" BORDER=0 ALT="Reports">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10106, '<IMG src="/images/home.jpg" BORDER=0 ALT="Home">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10107, '<IMG src="/images/options.jpg" BORDER=0 ALT="Options">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10108, '<IMG src="/images/admin.jpg" BORDER=0 ALT="Admin">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10109, '<IMG src="/images/logoff.jpg" BORDER=0 ALT="Logoff">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10110, '<IMG src="/images/incidents.jpg" BORDER=0 ALT="Incidents">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10125, '<IMG src="/images/add.jpg" BORDER=0 ALT="Add">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10126, '<IMG src="/images/simplesearch.jpg" BORDER=0 ALT="Simple">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10127, '<IMG src="/images/mbrsearch.jpg" BORDER=0 ALT="MBR">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10128, '<IMG src="/images/servicesearch.jpg" BORDER=0 ALT="Service">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10300, '<IMG src="/images/showmbr.jpg" BORDER=0 ALT="MBR">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10301, '<IMG src="/images/editmbr.jpg" BORDER=0 ALT="Edit">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10302, '<IMG src="/images/newservice.jpg" BORDER=0 ALT="New Service">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10303, '<IMG src="/images/print.jpg" BORDER=0 ALT="Print MBR">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10304, '<IMG src="/images/payment.jpg" BORDER=0 ALT="Payment">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10305, '<IMG src="/images/adjustment.jpg" BORDER=0 ALT="Adjustment">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10306, '<IMG src="/images/mbr_data.jpg" BORDER=0 ALT="Custom Data">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10307, '<IMG src="/images/mbr_invoices.jpg" BORDER=0 ALT="Invoices">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10308, '<IMG src="/images/mbr_statements.jpg" BORDER=0 ALT="Statements">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10309, '<IMG src="/images/history.jpg" BORDER=0 ALT="Service History">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10310, '<IMG src="/images/aging.jpg" BORDER=0 ALT="Aging">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10311, '<IMG src="/images/mbr_close.jpg" BORDER=0 ALT="Close MBR">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10312, '<IMG src="/images/deletembr.jpg" BORDER=0 ALT="Delete MBR">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10313, '<IMG src="/images/newincident.jpg" BORDER=0 ALT="New Incident">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10314, '<IMG src="/images/mbr_addresses.jpg" BORDER=0 ALT="Addresses">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10350, '<IMG src="/images/showmbr.jpg" BORDER=0 ALT="Show MBR">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10351, '<IMG src="/images/showservice.jpg" BORDER=0 ALT="Show Service">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10352, '<IMG src="/images/newservice.jpg" BORDER=0 ALT="New Service">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10353, '<IMG src="/images/editservice.jpg" BORDER=0 ALT="Edit Service">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10354, '<IMG src="/images/deleteservice.jpg" BORDER=0 ALT="Delete Service">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10355, '<IMG src="/images/callhistory.jpg" BORDER=0 ALT="Call History">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10356, '<IMG src="/images/emailsettings.jpg" BORDER=0 ALT="Email Settings">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10401, '<IMG src="/images/general.jpg" BORDER=0 ALT="General">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10402, '<IMG src="/images/accounting.jpg" BORDER=0 ALT="Accounting">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10403, '<IMG src="/images/system.jpg" BORDER=0 ALT="System">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10404, '<IMG src="/images/global.jpg" BORDER=0 ALT="Global">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10405, '<IMG src="/images/radius.jpg" BORDER=0 ALT="RADIUS">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10406, '<IMG src="/images/scheduler.jpg" BORDER=0 ALT="Scheduler">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10407, '<IMG src="/images/security.jpg" BORDER=0 ALT="Security">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10408, '<IMG src="/images/webconfig.jpg" BORDER=0 ALT="Web Configuration">', NULL)
INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL) VALUES(@appid, 4, 1, 10409, '<IMG src="/images/client.jpg" BORDER=0 ALT="Client">', NULL)
GO

/* This is the RadLogMsg Lookup Table */
IF (SELECT COUNT(*) FROM LogMsgs) = 0
BEGIN
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(0, 'Generic Message', 0)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(1, 'Generic Error', 5)

-- 10 SQL
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(10, 'SQL Generic', 5)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(11, 'SQL Error', 5)

-- 20 Report
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(20, 'Report Generic', 5)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(21, 'Report Error', 5)

-- 50 Batch
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(50, 'Batch Generic', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(51, 'Batch Invoice', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(52, 'Batch Statements', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(53, 'Batch Summary', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(54, 'Batch Charges', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(55, 'Batch Export', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(56, 'Batch Import', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(57, 'Batch Print', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(58, 'Batch Email', 1)

-- 100 MBR 
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(100, 'MBR Generic', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(101, 'MBR Add', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(102, 'MBR Edit', 2)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(103, 'MBR Delete', 3)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(104, 'MBR Payment', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(105, 'MBR Credit', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(106, 'MBR Invoice Add', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(107, 'MBR Invoice Void', 3)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(108, 'MBR Custom', 1)

-- 200 SA
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(200, 'Service Generic', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(201, 'Service Add', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(202, 'Service Edit', 2)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(203, 'Service Delete', 3)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(204, 'Service Incident', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(205, 'Service Action', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(206, 'Service Alias', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(207, 'Service Forward', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(208, 'Service RADIUS', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(209, 'Service Custom', 1)

-- 1000 Mail
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(1000, 'Mail Generic', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(1001, 'Mail Invoice', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(1002, 'Mail Statement', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(1003, 'Mail Receipt', 1)
INSERT INTO LogMsgs(LogMsgID, Description, Severity) VALUES(1004, 'Mail Notice', 1)

END
GO

IF (SELECT COUNT(*) FROM PrintTypes) = 0
BEGIN
SET IDENTITY_INSERT PrintTypes ON

--INSERT INTO PrintTypes(PrintTypeID, PrintType, Data, CRData) VALUES(1, 'HTML', 'text/html', 		'init=html_page')
INSERT INTO PrintTypes(PrintTypeID, PrintType, Data, CRData) VALUES(2, 'PDF',  'application/pdf', 	'cmd=EXPORT&EXPORT_FMT=U2FPDF%3A0')
INSERT INTO PrintTypes(PrintTypeID, PrintType, Data, CRData) VALUES(3, 'RTF',  'application/rtf', 	'cmd=EXPORT&EXPORT_FMT=U2FRTF%3A0')
--INSERT INTO PrintTypes(PrintTypeID, PrintType, Data, CRData) VALUES(4, 'Word', 'application/msword', 	'cmd=EXPORT&EXPORT_FMT=U2FWORDW%3A0')

SET IDENTITY_INSERT PrintTypes OFF

END
GO

-- This is a sample on how to setup a different language
-- Here we setup the Engligh-Test language which replaces
-- a lot of the picture toolbar with text items

INSERT INTO Languages(LanguageID, Description, Active, CurrentInUse, BaseURL, SortOrder)
VALUES(101, 'English - Text', 1, 1, NULL, 101)
GO

INSERT INTO Strings (ApplicationID, Version, LanguageID, StringID, Data, URL)
Select 2, Version, 101, StringID, Data, URL
From Strings
Where ApplicationID = 2	and StringID Between 10000 and 15000
GO

UPDATE Strings
set Data = '[' + SUBSTRING(Data,19,CHARINDEX('.',Data)-19) + ']'
Where LanguageID = 101
	and StringID Between 10000 and 15000
	AND Data LIKE '<IMG src="/images%'
GO

/* Populate WebAccess */
INSERT INTO WebAccess (WebAccess,Name) VALUES(0,'None')
INSERT INTO WebAccess (WebAccess,Name) VALUES(1,'Read')
INSERT INTO WebAccess (WebAccess,Name) VALUES(3,'Read/Add')
INSERT INTO WebAccess (WebAccess,Name) VALUES(5,'Read/Change')
INSERT INTO WebAccess (WebAccess,Name) VALUES(7,'Read/Add/Change')
INSERT INTO WebAccess (WebAccess,Name) VALUES(2,'Add')
INSERT INTO WebAccess (WebAccess,Name) VALUES(4,'Change')
INSERT INTO WebAccess (WebAccess,Name) VALUES(6,'Add/Change')
INSERT INTO WebAccess (WebAccess,Name) VALUES(8,'Delete')
INSERT INTO WebAccess (WebAccess,Name) VALUES(15,'ALL')
GO


/* Populate WebConfigs */
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('cacaff',	'BGColor',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('Black',	'Text',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('Blue',	'Link',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('Purple',	'VLink',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('Red',		'ALink',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('emerald.gif',	'LogoSmall',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('emerald.gif',	'LogoMedium',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('emerald.gif',	'LogoLarge',1)

INSERT INTO WebConfigs (Value,Name,Cache) VALUES('eeeeee',	'Table_BG',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('5555a1',	'Table_HDR',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('White',	'Table_HDR_TEXT',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('ffcc66',	'Table_HDR_HR',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('LightBlue',	'Table_CELL',1)

INSERT INTO WebConfigs (Value,Name,Cache) VALUES('LightBlue',	'Field_BG',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('ffff00',	'Field_HighLight',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('eedddd',	'Field_Warn',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('cc5555',	'Field_Error',1)

INSERT INTO WebConfigs (Value,Name,Cache) VALUES('bbbbbb',	'InActive',1)
INSERT INTO WebConfigs (Value,Name,Cache) VALUES('LightYellow',	'Edit_BG',1)
GO

/* Populate FilterTypes */

INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('ALCO', 	'Alcohol', 0, 1)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('ALTER', 	'Alternate', 0, 2)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('ANAR', 	'Anarchy', 0, 3)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('AUTO', 	'Auto', 0, 4)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('CHAT', 	'Chat', 0, 5)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('CRIMI', 	'Criminal', 0, 6)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('CULTS', 	'Cults', 0, 7)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('DRUGS', 	'Drugs', 0, 8)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('EMPL', 	'Empl', 0, 9)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('ENTER', 	'Entertainment', 0, 10)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('FINAN', 	'Financial', 0, 11)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('GAMB', 	'Gambling', 0, 12)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('GAMES', 	'Games', 0, 13)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('HATE', 	'Hate', 0, 14)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('HUMOR', 	'Humor', 0, 15)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('AGAZIN', 	'Agazin', 0, 16)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('NEWS', 	'News', 0, 17)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('OBSC', 	'Obsc', 0, 18)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('OPIN', 	'Opin', 0, 19)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('DATE', 	'Date', 0, 20)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('PORN', 	'Porn', 1, 21)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('PROXY', 	'Proxy', 0, 22)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('SELF', 	'Self', 0, 23)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('SHOP', 	'Shopping', 0, 24)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('SPORTS', 	'Sports', 0, 25)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('TICKET', 	'Ticket', 0, 26)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('TRAVEL', 	'Travel', 0, 27)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('WEMAIL', 	'Web Email', 0, 28)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('WNEWS', 	'Web News', 0, 29)
INSERT INTO FilterTypes(FilterType, Description, Checked, SortOrder) VALUES('KIDS', 	'Kids', 0, 30)
GO

-- Populate Exports
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES('|',0,NULL,'MAPP-PC Global Retail PC',NULL,1,NULL,NULL,'{CALL CreditCardExport($transtime)}',NULL,NULL,1,2)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,NULL,'Card Soft',NULL,1,'"',NULL,'{CALL CreditCardExport($transtime)}',NULL,NULL,1,3)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,NULL,'TelePC',NULL,1,NULL,NULL,'{CALL CreditCardExport($transtime)}',NULL,NULL,1,4)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,NULL,'PTC',NULL,1,'"',NULL,'{CALL CreditCardExport($transtime)}',NULL,NULL,1,5)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,NULL,'PTC Non-AVS',NULL,1,'"',NULL,'{CALL CreditCardExport($transtime)}',NULL,NULL,1,6)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES('\t',0,NULL,'PC-Charge',NULL,1,'"',NULL,'{CALL CreditCardExport($transtime)}',NULL,NULL,1,7)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,NULL,'IC Verify','A TIME',1,'"',NULL,'{CALL CreditCardExport($transtime)}',2,NULL,2,8)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,NULL,'CyberCash','1',1,'"',NULL,'{CALL CreditCardExport($transtime)}',7,NULL,1,9)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,NULL,'IC Verify w/AVS','A TIME',1,'"',NULL,'{CALL CreditCardExport($transtime)}',2,NULL,2,10)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,NULL,'Domain POS (Card Services)',NULL,1,NULL,NULL,'{CALL CreditCardExport($transtime)}',NULL,NULL,1,11)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(NULL,0,0,'PC-Transact IT',NULL,1,NULL,NULL,'{CALL CreditCardExport($transtime)}',NULL,NULL,1,12)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES('|',0,NULL,'MAPP-PC Global Retail PC',NULL,1,NULL,NULL,'{CALL CreditCardExport($transtime)}',NULL,NULL,1,13)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,NULL,'PC Authorize','A',1,'"',NULL,'{CALL CreditCardExport($transtime)}',1,NULL,1,14)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES('|',0,NULL,'Global Retail PC AVS','APPR CAPTURE',1,NULL,NULL,'{CALL CreditCardExport($transtime)}',NULL,NULL,1,15)
go

INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES('|',0,NULL,'Global Retail PC non-AVS','APPR CAPTURE',1,NULL,NULL,'{CALL CreditCardExport($transtime)}',NULL,NULL,1,16)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,NULL,'Visanet POS-Partner',NULL,1,NULL,NULL,'{CALL CreditCardExport($transtime)}',NULL,NULL,1,17)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,7,'Authorize.net','1',1,'"',NULL,'{CALL CreditCardExport($transtime)}',7,'2',1,18)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,NULL,'CCard (UK)','00',1,'"',NULL,'{CALL CreditCardExport($transtime)}',1,NULL,1,19)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,NULL,'PC-Transact IT v1.2',NULL,1,NULL,NULL,'{CALL CreditCardExport($transtime)}',0,NULL,1,20)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,3,'PC-Transact IT configured batch format','.APP',1,NULL,NULL,'{CALL CreditCardExport($transtime)}',3,'.BAD',1,21)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,NULL,'Generic','A',1,'"',NULL,'{CALL CreditCardExport($transtime)}',1,NULL,1,99)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES('\t',0,NULL,'Account Export',NULL,3,NULL,NULL,'{CALL UserExport($esid,$FileMode)}',NULL,NULL,1,100)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(NULL,0,NULL,'Telecheck',NULL,4,NULL,'telecheck','{CALL ACHExport($transtime)}',NULL,NULL,1,201)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,1,'Authorize.net','1',4,'"',NULL,'{CALL ACHExport($transtime)}',1,'2',1,202)
INSERT INTO Exports (Separator,HeaderRow,DeclineMatch,Description,ApproveString,ExportType,QuoteString,Filter,SQLString,ApproveMatch,DeclineString,Lines,ExportID) VALUES(',',0,1,'Generic','A',4,'"',NULL,'{CALL ACHExport($transtime)}',1,'D',1,299)
go

-- Populate ExportColumns
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,NULL,1,'Const1',NULL,0,0,2,0,'10$000000S0')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,NULL,1,'CardNumber',NULL,1,0,2,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,NULL,1,'CreditCardExpire',NULL,0,0,2,0,'$expmm$expyy')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,NULL,1,'CardHolder',NULL,1,0,2,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,5,NULL,1,'Address',NULL,1,0,2,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,NULL,1,'Zip',NULL,1,0,2,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,NULL,1,'Amount',NULL,3,0,2,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,8,NULL,1,'Const2',NULL,0,0,2,0,'|||||')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,9,NULL,1,'TransID',NULL,2,0,2,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,NULL,1,'CardNumber',NULL,1,0,4,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,NULL,1,'CreditCardExpire',NULL,0,0,4,0,'$expmm$expyy')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,NULL,1,'Amount',NULL,3,0,4,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,NULL,1,'Zip',NULL,1,0,4,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,5,NULL,1,'Address',NULL,7,0,4,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,1,NULL,1,'Const1',NULL,0,0,3,0,'C1')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,2,NULL,1,'LastModifyUser',NULL,1,0,3,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,3,NULL,1,'TransID',NULL,2,0,3,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,4,NULL,1,'CardNumber',NULL,1,0,3,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,5,NULL,1,'CreditCardExpire',NULL,0,0,3,0,'$expmm$expyy')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,1,NULL,1,'Const1',NULL,0,0,5,0,'S')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,NULL,1,'CardNumber',NULL,1,0,5,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,3,NULL,1,'CreditCardExpire',NULL,0,0,5,0,'$expmm$expyy')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,4,NULL,1,'CardHolder',NULL,1,0,5,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,5,NULL,1,'Address',NULL,7,0,5,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,6,NULL,1,'Zip',NULL,1,0,5,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,7,NULL,1,'TransID',NULL,2,0,5,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,8,NULL,1,'Const2',NULL,0,0,5,0,'0')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,9,NULL,1,'Const3',NULL,0,0,5,0,'"1","","","2","","",0.00,')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,10,NULL,1,'Amount',NULL,3,0,5,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,1,NULL,1,'Const1',NULL,0,0,6,0,'S')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,NULL,1,'CardNumber',NULL,1,0,6,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,3,NULL,1,'CreditCardExpire',NULL,0,0,6,0,'$expmm$expyy')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,4,NULL,1,'CardHolder',NULL,1,0,6,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,5,NULL,1,'TransID',NULL,2,0,6,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,NULL,1,'Amount',NULL,3,0,6,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,1,NULL,1,'Const1',NULL,0,0,7,0,'1')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,2,NULL,1,'CardNumber',NULL,1,0,7,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,3,NULL,1,'CreditCardExpire',NULL,0,0,7,0,'$expmm$expyy')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,4,NULL,1,'Amount',NULL,3,0,7,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,5,NULL,1,'TransID',NULL,2,0,7,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,6,NULL,1,'Zip',NULL,1,0,7,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,7,NULL,1,'Address',NULL,1,0,7,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,1,NULL,1,'Const1',NULL,0,0,8,0,'C1')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,2,NULL,1,'TransID',NULL,2,0,8,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,3,NULL,1,'CardHolder',NULL,1,0,8,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,4,NULL,1,'CardNumber',NULL,1,0,8,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,5,NULL,1,'CreditCardExpire',NULL,0,0,8,0,'$expyy$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,6,NULL,1,'Amount',NULL,3,0,8,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,NULL,1,'TransID',NULL,2,0,9,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,2,NULL,1,'CardHolder',NULL,1,0,9,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,3,NULL,1,'CardNumber',NULL,1,0,9,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,4,NULL,1,'CreditCardExpire',NULL,0,0,9,0,'$expyy$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,5,NULL,1,'Address',NULL,7,0,9,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,NULL,1,'Zip',NULL,1,0,9,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,NULL,1,'Amount',NULL,3,0,9,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,1,NULL,1,'Const1',NULL,0,0,10,0,'C1')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,2,NULL,1,'TransID',NULL,2,0,10,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,3,NULL,1,'CardHolder',NULL,1,0,10,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,4,NULL,1,'CardNumber',NULL,1,0,10,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,5,NULL,1,'CreditCardExpire',NULL,0,0,10,0,'$expyy$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,6,NULL,1,'Amount',NULL,3,0,10,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,7,NULL,1,'Const2',NULL,0,0,10,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,8,NULL,1,'Zip',NULL,1,0,10,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,9,NULL,1,'Address',NULL,1,0,10,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,NULL,1,'CardNumber',NULL,1,0,11,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,NULL,1,'CreditCardExpire',NULL,0,0,11,0,'$expyy$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,NULL,1,'Amount',NULL,3,0,11,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,NULL,1,'Address',NULL,7,0,11,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,5,NULL,1,'Zip',NULL,1,0,11,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,NULL,1,'CardHolder',NULL,1,0,11,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,NULL,1,'TransID',NULL,2,0,11,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,8,NULL,1,'Const1',NULL,0,0,11,0,'.00')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(4,0,1,NULL,1,'Const1','0',0,1,12,4,'$records')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(3,0,2,NULL,1,'Const2',NULL,0,1,12,3,'N S')
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(16,0,3,NULL,1,'CardNumber',NULL,1,1,12,16,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(4,0,4,NULL,1,'CreditCardExpire',NULL,0,1,12,4,'$expyy$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(12,0,5,NULL,1,'Amount','0',3,1,12,12,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(7,0,6,NULL,1,'Const3',NULL,0,1,12,7,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(8,0,7,NULL,1,'Const4',NULL,0,1,12,8,'$HH$MM$DD')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(53,0,8,NULL,1,'Const5',NULL,0,1,12,53,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(70,0,9,NULL,1,'TransID',NULL,2,1,12,70,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(81,0,10,NULL,1,'Const6',NULL,0,1,12,81,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(12,0,11,NULL,1,'Amount',NULL,3,1,12,12,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(3,0,12,NULL,1,'Const7',NULL,0,1,12,3,'  0')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(20,0,13,NULL,1,'Address',NULL,1,1,12,20,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(1,0,14,NULL,1,'Const8',NULL,0,1,12,1,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(9,0,15,NULL,1,'Zip',NULL,1,1,12,9,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,1,NULL,1,'TransID',NULL,2,0,14,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,NULL,1,'CardNumber',NULL,1,0,14,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,3,NULL,1,'CreditCardExpire',NULL,0,0,14,0,'$expyy$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,4,NULL,1,'CardHolder',NULL,1,0,14,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,5,NULL,1,'Address',NULL,7,0,14,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,NULL,1,'Zip',NULL,1,0,14,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,NULL,1,'Amount',NULL,3,0,14,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,8,NULL,1,'CustomerID',NULL,2,0,14,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,9,NULL,1,'TransID',NULL,2,0,14,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,NULL,1,'Const1',NULL,0,0,15,0,'10$000000S0')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,NULL,1,'Const2',NULL,0,0,15,0,'$MM-$DD-$YYYY $HH:$MI:$SS||')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,NULL,1,'CardNumber',NULL,1,0,15,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,NULL,1,'CreditCardExpire',NULL,0,0,15,0,'$expyy$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,5,NULL,1,'CardHolder',NULL,1,0,15,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,NULL,1,'Address',NULL,7,0,15,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,NULL,1,'Zip',NULL,1,0,15,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,8,NULL,1,'Amount',NULL,3,0,15,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,9,NULL,1,'Const3',NULL,0,0,15,0,'|||||')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,10,NULL,1,'TransID',NULL,2,0,15,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,NULL,1,'Const1',NULL,0,0,16,0,'10$000000S0')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,NULL,1,'Const2',NULL,0,0,16,0,'$MM-$DD-$YYYY $HH:$MI:$SS||')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,NULL,1,'CardNumber',NULL,1,0,16,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,NULL,1,'CreditCardExpire',NULL,0,0,16,0,'$expyy$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,5,NULL,1,'CardHolder',NULL,1,0,16,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,NULL,1,'Address',NULL,1,0,16,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,NULL,1,'Zip',NULL,1,0,16,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,8,NULL,1,'Amount',NULL,3,0,16,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,9,NULL,1,'Const3',NULL,0,0,16,0,'|||||')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,10,NULL,1,'TransID',NULL,2,0,16,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,NULL,1,'CardNumber',NULL,1,0,17,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,NULL,1,'CreditCardExpire',NULL,0,0,17,0,'$expyy$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,NULL,1,'Merchant',NULL,1,0,17,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,NULL,1,'Amount',NULL,3,0,17,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,5,NULL,0,'Zip',NULL,1,0,17,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,NULL,0,'Address',NULL,7,0,17,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,NULL,1,'Const1',NULL,0,0,17,0,'$Address$Zip')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,8,NULL,1,'Const2',NULL,0,0,17,0,'N,,1,,')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,9,NULL,1,'TransID',NULL,2,0,17,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,10,NULL,1,'Const3',NULL,0,0,17,0,'0')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,11,NULL,0,'startdd',NULL,1,0,17,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,12,NULL,0,'startmm',NULL,1,0,17,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,13,NULL,1,'Const4',NULL,0,0,17,0,'$startmm$startdd')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,1,NULL,1,'TransID',NULL,2,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,2,NULL,1,'TransID',NULL,2,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,3,NULL,1,'Amount',NULL,3,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,4,NULL,1,'PayMethod',NULL,0,0,0,'CC',18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,5,NULL,1,'BankTransType',NULL,0,0,0,'AUTH_CAPTURE',18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,6,NULL,1,'AuthCode',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,7,NULL,1,'TransactionID',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,8,NULL,1,'CardNumber',NULL,1,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,9,NULL,1,'CardExpire',NULL,0,0,0,'$expmm$expyy',18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,10,NULL,1,'AccountNumber',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,11,NULL,1,'BankNumber',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,12,NULL,1,'BankName',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,13,NULL,1,'CustomerID',NULL,2,0,0,NULL,18)
GO

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,14,NULL,1,'CardHolder',NULL,1,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,15,NULL,1,'LastName',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,16,NULL,1,'Company',NULL,1,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,17,NULL,1,'Address',NULL,7,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,18,NULL,1,'City',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,19,NULL,1,'State',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,20,NULL,1,'Zip',NULL,1,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,21,NULL,1,'Phone',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,22,NULL,1,'Fax',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,1,23,NULL,1,'Email',NULL,0,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,0,NULL,18)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,MinSize,ExportValue,ExportID) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,0,NULL,18)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,1,NULL,1,'Const1',NULL,0,0,19,0,'09')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,2,NULL,1,'CardNumber',NULL,1,0,19,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,3,NULL,1,'CreditCardExpire',NULL,0,0,19,0,'$expyy$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,4,NULL,1,'Const2',NULL,0,0,19,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,5,NULL,1,'Amount',NULL,3,0,19,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,6,NULL,1,'TransID',NULL,2,0,19,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,7,NULL,1,'Merchant',NULL,1,0,19,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,NULL,1,'Const1',NULL,0,0,20,0,'$records')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,NULL,1,'Const2',NULL,0,0,20,0,'N, ,S')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,NULL,1,'CardNumber',NULL,1,0,20,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,NULL,1,'CreditCardExpire',NULL,0,0,20,0,'$expyy$expmm')
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,5,NULL,1,'Amount',NULL,3,0,20,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,NULL,1,'Const3',NULL,0,0,20,0,'      ,')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,NULL,1,'Const4',NULL,0,0,20,0,'$HH$MI')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,8,NULL,1,'Const5',NULL,0,0,20,0,'$MM$DD')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,9,NULL,1,'Const6',NULL,0,0,20,0,',,')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,10,NULL,1,'TransID',NULL,2,0,20,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,11,NULL,1,'Const7',NULL,0,0,20,0,',')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,12,NULL,1,'Amount',NULL,3,0,20,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,13,NULL,1,'Const8',NULL,0,0,20,0,',0')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,14,NULL,1,'Address',NULL,1,0,20,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,16,NULL,1,'Zip',NULL,1,0,20,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,15,NULL,1,'Const9',NULL,0,0,20,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,NULL,1,'Const1',NULL,0,0,21,0,'$records')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,NULL,1,'TransID',NULL,2,0,21,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,NULL,1,'CardNumber',NULL,1,0,21,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,NULL,1,'CreditCardExpire',NULL,0,0,21,0,'$expyy$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,5,NULL,1,'Amount',NULL,3,0,21,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,NULL,1,'Address',NULL,1,0,21,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,NULL,1,'Zip',NULL,1,0,21,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,1,NULL,1,'TransID',NULL,2,0,99,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,2,NULL,1,'CardNumber',NULL,1,0,99,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,3,NULL,1,'CreditCardExpire',NULL,0,0,99,0,'$expmm$expyy')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,4,NULL,1,'Amount',NULL,3,0,99,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,5,NULL,1,'Zip',NULL,1,0,99,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,6,NULL,1,'Address',NULL,1,0,99,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,NULL,1,'Const1',NULL,0,0,13,0,'10$000000S0')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,NULL,1,'CardNumber',NULL,1,0,13,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,NULL,1,'CreditCardExpire',NULL,0,0,13,0,'$expmm$expyy')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,NULL,1,'CardHolder',NULL,1,0,13,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,5,NULL,1,'Address',NULL,1,0,13,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,NULL,1,'Zip',NULL,1,0,13,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,NULL,1,'Amount',NULL,3,0,13,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,8,NULL,1,'Const2',NULL,0,0,13,0,'|||||')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,9,NULL,1,'TransID',NULL,2,0,13,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,1,NULL,1,'Const1',NULL,0,0,15,0,'10$000000S0')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,2,NULL,1,'CardNumber',NULL,1,0,15,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,3,NULL,1,'CreditCardExpire',NULL,0,0,15,0,'$expmm$expyy')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,4,NULL,1,'CardHolder',NULL,1,0,15,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,5,NULL,1,'Address',NULL,1,0,15,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,6,NULL,1,'Zip',NULL,1,0,15,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,7,NULL,1,'Amount',NULL,3,0,15,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,8,NULL,1,'Const2',NULL,0,0,15,0,'|||||')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,9,NULL,1,'TransID',NULL,2,0,15,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,99,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,99,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,2,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,2,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,3,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,3,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,4,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,4,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,5,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,5,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,6,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,6,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,7,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,7,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,8,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,8,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,9,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,9,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,10,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,10,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,11,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,11,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,12,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,12,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,13,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,13,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,14,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,14,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,15,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,15,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,16,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,16,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,17,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,17,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,18,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,18,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,19,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,19,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,20,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,20,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,21,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,21,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,99,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,99,0,NULL)

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(16,0,1,NULL,1,'CustomerID',NULL,2,0,201,16,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(30,0,2,NULL,1,'AccountHolder',NULL,1,0,201,30,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(20,0,3,NULL,1,'AccountNumber',NULL,1,0,201,20,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(9,0,4,NULL,1,'Amount',NULL,3,0,201,9,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(1,0,5,NULL,1,'TransType',NULL,1,0,201,1,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(9,0,6,NULL,1,'BankNumber',NULL,1,0,201,9,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expyy',NULL,1,0,201,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,0,0,NULL,0,'expmm',NULL,1,0,201,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(4,0,7,NULL,1,'CreditCardExpire',NULL,0,0,201,4,'$expyy$expmm')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(20,0,8,NULL,1,'TransID',NULL,2,0,201,20,'$this\n!2!')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(16,0,9,NULL,1,'CustomerID',NULL,2,0,201,16,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(30,0,10,NULL,1,'Address',NULL,1,0,201,30,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(20,0,11,NULL,1,'City',NULL,1,0,201,20,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(2,0,12,NULL,1,'State',NULL,1,0,201,2,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(9,0,13,NULL,1,'Zip',NULL,1,0,201,9,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(6,0,14,NULL,1,'PaymentStopDate',NULL,0,0,201,6,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,1,NULL,1,'TransID',NULL,2,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,2,NULL,1,'TransID',NULL,2,0,202,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,3,NULL,1,'Amount',NULL,3,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,4,NULL,1,'PayMethod',NULL,0,0,202,0,'ECHECK')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,5,NULL,1,'BankTransType',NULL,0,0,202,0,'AUTH_CAPTURE')
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,6,NULL,1,'AuthCode',NULL,0,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,7,NULL,1,'TransactionID',NULL,0,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,8,NULL,1,'CCNumber',NULL,0,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,9,NULL,1,'CCExpire',NULL,0,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,10,NULL,1,'AccountNumber',NULL,1,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,11,NULL,1,'BankNumber',NULL,1,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,12,NULL,1,'BankName',NULL,1,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,13,NULL,1,'CustomerID',NULL,2,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,14,NULL,1,'AccountHolder',NULL,1,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,15,NULL,1,'LastName',NULL,0,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,16,NULL,1,'Company',NULL,1,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,17,NULL,1,'Address',NULL,1,0,202,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,18,NULL,1,'City',NULL,1,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,19,NULL,1,'State',NULL,1,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,20,NULL,1,'Zip',NULL,1,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,21,NULL,1,'Phone',NULL,0,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,22,NULL,1,'Fax',NULL,0,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,23,NULL,1,'Email',NULL,0,0,202,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,2,NULL,1,'Amount',NULL,3,0,299,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,3,NULL,1,'AccountHolder',NULL,1,0,299,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,4,NULL,1,'BankName',NULL,1,0,299,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,5,NULL,1,'BankNumber',NULL,1,0,299,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,6,NULL,1,'AccountNumber',NULL,1,0,299,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,7,NULL,1,'BankTransType',NULL,1,0,299,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,8,NULL,1,'City',NULL,1,0,299,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,9,NULL,1,'State',NULL,1,0,299,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,10,NULL,1,'Zip',NULL,1,0,299,0,NULL)
go

INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,11,NULL,1,'Address',NULL,1,0,299,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,12,NULL,1,'Address2',NULL,0,0,299,0,NULL)
INSERT INTO ExportColumns (MaxSize,Quoted,SortOrder,Description,Include,FieldName,Padding,Format,Align,ExportID,MinSize,ExportValue) VALUES(0,1,1,NULL,1,'TransID',NULL,2,0,299,0,NULL)
go



-- Populate CCImportColumns
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,1,'C1',0,9,NULL,1,'C1',8,2)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,2,'Trans ID',0,1,NULL,1,NULL,8,20)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,4,'Approve Code',0,7,NULL,2,NULL,8,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,3,'Response',0,8,NULL,2,'Authorized $this',8,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,4,'Status',0,2,NULL,2,NULL,8,0)

INSERT INTO CCImportColumns (ExportID,FieldType,SortOrder,Position,Description,Quoted,FieldSize,ApproveValue,DeclineValue,ErrorValue,Line)
SELECT 10,FieldType,SortOrder,Position,Description,Quoted,FieldSize,ApproveValue,DeclineValue,ErrorValue,Line
	FROM CCImportColumns WHERE ExportID = 8

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,1,'Trans ID',0,1,NULL,1,NULL,9,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,2,'Status',0,2,NULL,1,NULL,9,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,3,'Approve Code',0,7,NULL,1,NULL,9,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,3,'Response',0,8,NULL,1,NULL,9,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,0,'Trans ID',115,1,NULL,1,NULL,12,10)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,1,'Response',67,8,NULL,1,'Authorized $this',12,35)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,2,'Approve Code',47,7,NULL,1,NULL,12,6)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,3,'Status',47,2,NULL,1,NULL,12,6)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,0,'Trans ID',115,1,NULL,1,NULL,19,10)
go

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,1,'Response',67,8,NULL,1,'Authorized $this',19,35)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,2,'Approve Code',47,7,NULL,1,NULL,19,6)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,3,'Status',47,2,NULL,1,NULL,19,6)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,1,'Trans ID',0,1,NULL,1,NULL,14,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,4,'Status',0,2,NULL,1,NULL,14,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,4,'Approve Code',10,7,NULL,1,NULL,14,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,3,'Response',0,8,NULL,1,'Authorized $approvecode',14,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,16,'Trans ID',0,1,NULL,1,NULL,15,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,17,'Approve Code',9,7,NULL,1,NULL,15,8)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,18,'Response',0,8,NULL,1,'Authorized $this $sink',15,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,19,'Sink',0,0,NULL,1,NULL,15,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,4,'Status',0,2,NULL,1,NULL,15,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,16,'Trans ID',0,1,NULL,1,NULL,16,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,15,'Approve Code',9,7,NULL,1,NULL,16,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,18,'Response',0,8,NULL,1,NULL,16,0)
go

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,19,'Sink',0,0,NULL,1,NULL,16,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,4,'Status',0,2,NULL,1,NULL,16,0)

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,8,'Trans ID',0,1,NULL,1,NULL,18,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,2,'Approve Code',0,7,NULL,1,NULL,18,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,1,'Sink',0,0,NULL,1,NULL,18,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('Declined $approvecode',0,3,'Response Code',0,8,NULL,1,'Authorized $approvecode $this $sink',18,0)
go

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,1,'Trans ID',0,1,NULL,1,NULL,19,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,4,'Approve Code',0,7,NULL,1,NULL,19,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,3,'Response',0,8,NULL,1,'Authorized $this',19,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,2,'Status',0,2,NULL,1,NULL,19,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,15,'TransID',0,1,NULL,1,NULL,20,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,8,'Approve Code',0,7,NULL,1,NULL,20,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,13,'Response',0,8,NULL,1,NULL,20,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('$filename',0,0,'Status',0,2,NULL,1,'$filename',21,0)
go

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,1,'Trans ID',119,1,NULL,1,NULL,21,8)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('$sink',0,2,'Response',47,8,NULL,1,'Authorized $approvecode',21,6)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,3,'Approve Code',47,7,NULL,1,NULL,21,6)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,4,'Sink',70,0,NULL,1,NULL,21,25)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,1,'Trans ID',0,1,NULL,1,NULL,99,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,3,'Response',0,8,NULL,1,NULL,99,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,4,'Approve Code',0,7,NULL,1,NULL,99,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,4,'Status',0,2,NULL,1,NULL,99,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,8,'Trans ID',0,1,NULL,1,NULL,202,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,2,'Approve Code',0,7,NULL,1,NULL,202,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,0,1,'Sink',0,0,NULL,1,NULL,202,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('Declined $approvecode',0,3,'Response Code',0,8,NULL,1,'Authorized $approvecode $this $sink',202,0)
go

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,1,'TransID',0,1,NULL,1,NULL,299,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,2,'Status',0,2,NULL,1,NULL,299,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('Declined $approvecode',1,3,'Response Code',0,8,NULL,1,'Authorized $approvecode $this',299,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,4,'ApproveCode',0,7,NULL,1,NULL,299,0)
go

INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,5,'TransID',0,1,NULL,1,NULL,5,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,4,'Status',0,2,NULL,1,NULL,5,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,4,'ApproveCode',10,7,NULL,1,NULL,5,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('$status',1,3,'Response Code',0,8,NULL,1,'Authorized $this / $approvecode',5,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,5,'TransID',0,1,NULL,1,NULL,6,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,4,'Status',0,2,NULL,1,NULL,6,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES(NULL,1,4,'ApproveCode',10,7,NULL,1,NULL,6,0)
INSERT INTO CCImportColumns (DeclineValue,Quoted,SortOrder,Description,Position,FieldType,ErrorValue,Line,ApproveValue,ExportID,FieldSize) VALUES('$status',1,3,'Response Code',0,8,NULL,1,'Authorized $this / $approvecode',6,0)
go
