set nocount on
go

/* codetabs.sql */
/* This file creates the data for all the code tables. */
/* YOU MUST execute instabs.sql BEFORE executing this. */

/* Rates */
/* RateID, Description, StandardInterval, StandardHours, StandardCharge, OverRefuse, OverInterval, */
/* OverCharge, PrimaryPay, PrimaryStart, PrimaryStop, PrimaryCharge, PrimaryOverCharge */

IF (SELECT COUNT(*) FROM Rates) = 0
BEGIN
INSERT INTO Rates(Description, DefaultType, DefaultInterval, DefaultCharge, PrimaryStart, PrimaryStop)
	VALUES('Unlimited',   0, 	3600, 	0.0, 	0,   0)
INSERT INTO Rates(Description, DefaultType, DefaultInterval, DefaultCharge, PrimaryStart, PrimaryStop)
	VALUES('Per Minute',   0, 	60, 	0.05, 	0,   0)
INSERT INTO Rates(Description, DefaultType, DefaultInterval, DefaultCharge, PrimaryStart, PrimaryStop)
	VALUES('25 Hours',   0, 	3600, 	0.0, 	0,   0)
   INSERT Into RateSchedules(RateID,HistoryType,ScheduleType,Offset,Interval,Charge,SortOrder) 
	VALUES(@@IDENTITY, 0, 0, 25, 3600, 1.00,1)
INSERT INTO Rates(Description, DefaultType, DefaultInterval, DefaultCharge, PrimaryStart, PrimaryStop)
	VALUES('None',   0, 	3600, 	0.0, 	0,   0)
INSERT INTO Rates(Description, DefaultType, DefaultInterval, DefaultCharge, PrimaryStart, PrimaryStop)
	VALUES('$1/hr $2/hr',   0, 	3600, 	1.0, 	480,   1080)
   INSERT Into RateSchedules(RateID,HistoryType,ScheduleType,Offset,Interval,Charge,SortOrder) 
	VALUES(@@IDENTITY, 1, 0, 0, 3600, 2.00,1)
END
GO

/* Charge Types */
IF (SELECT COUNT(*) FROM ChargeTypes) = 0
BEGIN
INSERT INTO ChargeTypes (Description,Amount,TaxID,GroupID, SortOrder) VALUES('DNS Registration', 35.00, NULL, NULL, 5)
INSERT INTO ChargeTypes (Description,Amount,TaxID,GroupID, SortOrder) VALUES('Reactivation Fee', 10.00, NULL, NULL, 6)

INSERT INTO ChargeTypes (Description,Amount,TaxID,GroupID, SortOrder) VALUES('PPP Setup',        20.00, NULL, NULL, 255)
INSERT INTO ChargeTypes (Description,Amount,TaxID,GroupID, SortOrder) VALUES('DSL Setup',        20.00, NULL, NULL, 255)
INSERT INTO ChargeTypes (Description,Amount,TaxID,GroupID, SortOrder) VALUES('Colocation Setup', 20.00, NULL, NULL, 255)
END
GO

/* AccountTypes */
/* AccountTypeID, AccountType, Cost, Description, ApplyDiscount, OverDue, OverLimit, TaxID, RateType, RateID,  */
/* TimeRateID, DataRateID, ChargeTypeID, ExternalSystemID, GroupID, DNISGroupID, SortOrder */

IF (SELECT COUNT(*) FROM AccountTypes) = 0
BEGIN
INSERT INTO AccountTypes (AccountType,Cost,Description,ApplyDiscount,TaxID,RateID,ChargeTypeID,ExternalSystemID,GroupID,DNISGroupID,SortOrder,SendBill,RemoteAccess)
	VALUES('PPP',   	19.95, 'Dialup Internet Access',1, NULL, 1, NULL, NULL, NULL, NULL, 1, 1, 1)
INSERT INTO AccountTypes (AccountType,Cost,Description,ApplyDiscount,TaxID,RateID,ChargeTypeID,ExternalSystemID,GroupID,DNISGroupID,SortOrder,SendBill,RemoteAccess)
	VALUES('DSL',   	17.95, 'DSL Internet Access',   1, NULL, 1, NULL, NULL, NULL, NULL, 2, 1, 1)
INSERT INTO AccountTypes (AccountType,Cost,Description,ApplyDiscount,TaxID,RateID,ChargeTypeID,ExternalSystemID,GroupID,DNISGroupID,SortOrder,SendBill,RemoteAccess)
	VALUES('ISDN',  	24.95, 'ISDN Internet Access',  1, NULL, 1, NULL, NULL, NULL, NULL, 3, 1, 1)
INSERT INTO AccountTypes (AccountType,Cost,Description,ApplyDiscount,TaxID,RateID,ChargeTypeID,ExternalSystemID,GroupID,DNISGroupID,SortOrder,SendBill,RemoteAccess)
	VALUES('EMail', 	5.00,  'Email Account',    	0, NULL, 1, NULL, NULL, NULL, NULL, 4, 1, 1)
INSERT INTO AccountTypes (AccountType,Cost,Description,ApplyDiscount,TaxID,RateID,ChargeTypeID,ExternalSystemID,GroupID,DNISGroupID,SortOrder,SendBill,RemoteAccess)
	VALUES('Wireless', 	24.95, 'Wireless Internet',	1, NULL, 1, NULL, NULL, NULL, NULL, 5, 1, 1)
INSERT INTO AccountTypes (AccountType,Cost,Description,ApplyDiscount,TaxID,RateID,ChargeTypeID,ExternalSystemID,GroupID,DNISGroupID,SortOrder,SendBill,RemoteAccess)
	VALUES('Web - Virtual', 9.95,  'Virtual Web Hosting',	0, NULL, 1, NULL, NULL, NULL, NULL, 6, 1, 1)
INSERT INTO AccountTypes (AccountType,Cost,Description,ApplyDiscount,TaxID,RateID,ChargeTypeID,ExternalSystemID,GroupID,DNISGroupID,SortOrder,SendBill,RemoteAccess)
	VALUES('Web - Full',    19.95, 'Web Hosting',		0, NULL, 1, NULL, NULL, NULL, NULL, 7, 1, 1)
INSERT INTO AccountTypes (AccountType,Cost,Description,ApplyDiscount,TaxID,RateID,ChargeTypeID,ExternalSystemID,GroupID,DNISGroupID,SortOrder,SendBill,RemoteAccess)
	VALUES('Colocation',    49.95, 'Colocation Service',	0, NULL, 1, NULL, NULL, NULL, NULL, 8, 1, 1)
INSERT INTO AccountTypes (AccountType,Cost,Description,ApplyDiscount,TaxID,RateID,ChargeTypeID,ExternalSystemID,GroupID,DNISGroupID,SortOrder,SendBill,RemoteAccess)
	VALUES('DNS Hosting',    4.95, 'DNS Hosting Service',	0, NULL, 1, NULL, NULL, NULL, NULL, 9, 1, 1)
END
GO

/* Populate Service Data Types */

IF (SELECT COUNT(*) FROM SubAccountDataTypes) = 0
BEGIN
DECLARE @dslid int, @isdnid int

Select @dslid = AccountTypeID From AccountTypes Where AccountType = 'DSL'
Select @isdnid = AccountTypeID From AccountTypes Where AccountType = 'DSL'

if (@dslid IS NOT NULL)
	BEGIN
	INSERT INTO SubAccountDataTypes (Description, AccountTypeID ) VALUES('Provider',@dslid)
	INSERT INTO SubAccountDataTypes (Description, AccountTypeID ) VALUES('Circuit', @dslid)
	INSERT INTO SubAccountDataTypes (Description, AccountTypeID ) VALUES('Path', 	@dslid)
	END

if (@isdnid IS NOT NULL)
	BEGIN
	INSERT INTO SubAccountDataTypes (Description, AccountTypeID ) VALUES('SPID1', @dslid)
	INSERT INTO SubAccountDataTypes (Description, AccountTypeID ) VALUES('SPID2', 	@dslid)
	END
END
GO

/* Discounts */

IF (SELECT COUNT(*) FROM Discounts) = 0
BEGIN
INSERT INTO Discounts(Discount, Amount, AmountType, GroupID, SortOrder) VALUES('Normal',  100, 0, NULL, 1)
INSERT INTO Discounts(Discount, Amount, AmountType, GroupID, SortOrder) VALUES('School',   80, 0, NULL, 3)
INSERT INTO Discounts(Discount, Amount, AmountType, GroupID, SortOrder) VALUES('Business', 90, 0, NULL, 2)
INSERT INTO Discounts(Discount, Amount, AmountType, GroupID, SortOrder) VALUES('Tradeout',  0, 0, NULL, 4)
END
GO

/* MailItems */

/*'MailItem', GroupID*/

IF (SELECT COUNT(*) FROM MailItems) = 0
BEGIN
INSERT INTO MailItems(MailItem, GroupID) VALUES('User Guide', 		NULL)
INSERT INTO MailItems(MailItem, GroupID) VALUES('Class Schedule', 	NULL)
END
GO

/* ModemSpeeds */

/* ModemSpeedID, ModemSpeed, SortOrder */

IF (SELECT COUNT(*) FROM ModemSpeeds) = 0
BEGIN
INSERT INTO ModemSpeeds(ModemSpeed, SortOrder) VALUES('56k',   0)
INSERT INTO ModemSpeeds(ModemSpeed, SortOrder) VALUES('28800', 1)
INSERT INTO ModemSpeeds(ModemSpeed, SortOrder) VALUES('14400', 2)
INSERT INTO ModemSpeeds(ModemSpeed, SortOrder) VALUES('9600',  3)
INSERT INTO ModemSpeeds(ModemSpeed, SortOrder) VALUES('2400',  4)
INSERT INTO ModemSpeeds(ModemSpeed, SortOrder) VALUES('ISDN',  5)
INSERT INTO ModemSpeeds(ModemSpeed, SortOrder) VALUES('DSL',   6)
INSERT INTO ModemSpeeds(ModemSpeed, SortOrder) VALUES('WLAN', 7)
INSERT INTO ModemSpeeds(ModemSpeed, SortOrder) VALUES('Other', 8)
END
GO

/* NetSoftwares */

/* NetSoftwareID, NetSoftware, Map, SortOrder */
IF (SELECT COUNT(*) FROM NetSoftwares) = 0
BEGIN
INSERT INTO NetSoftwares(NetSoftware, Map, SortOrder) VALUES('Windows DUN',	6, 1)
INSERT INTO NetSoftwares(NetSoftware, Map, SortOrder) VALUES('MacTCP',		7, 5)
INSERT INTO NetSoftwares(NetSoftware, Map, SortOrder) VALUES('Open Transport',	8, 6)
INSERT INTO NetSoftwares(NetSoftware, Map, SortOrder) VALUES('Inet in a Box',	3, 7)
INSERT INTO NetSoftwares(NetSoftware, Map, SortOrder) VALUES('Linux',		0, 10)
INSERT INTO NetSoftwares(NetSoftware, Map, SortOrder) VALUES('Other',		0, 12)
INSERT INTO NetSoftwares(NetSoftware, Map, SortOrder) VALUES('Signup Server',	0, 13)
END
GO

/* Domains -- DomainID, Domain, MailDomain, GroupID, Description */
IF (SELECT COUNT(*) FROM Domains) = 0
BEGIN
INSERT INTO Domains(Domain,MailDomain,GroupID,Description,SortOrder) VALUES('ISP', 'isp.isp', NULL, 'A New ISP', 1)
END
GO

/* Groups */
IF (SELECT COUNT(*) FROM Groups WHERE GroupID = 1) = 0
BEGIN
SET IDENTITY_INSERT Groups ON
INSERT INTO 
Groups(GroupID,DomainID,GroupName,Description,SortOrder,GlobalOptions,BillName, BillAddress1, BillCity, BillState, BillZip, EmailAccounts,EmailSubject)
VALUES(1, 1, 'Global', 'All Groups',0, 1,'ISP Inc', '1234 Someplace Ave', 'SomeWhere', 'AW', '99999','billing', 'ISP Billing Account')
SET IDENTITY_INSERT Groups OFF
END
GO

IF (SELECT COUNT(*) FROM Groups Where GroupID > 1) = 0
BEGIN
INSERT INTO 
Groups(DomainID,GroupName,Description,UniqueLogins,GlobalOptions,SortOrder,FTPDir,BillName, BillAddress1, BillCity, BillState, BillZip, EmailAccounts,EmailSubject)
VALUES(1, 'ISP', 'ISP', 0, 1, 1, NULL,'ISP Inc', '1234 Someplace Ave', 'SomeWhere', 'AW', '99999','billing', 'ISP Billing Account')
END
GO


/* OperatorGroupAccess */
IF (SELECT COUNT(*) FROM OperatorGroupAccess) = 0
BEGIN
/* GroupID=2 Tech */
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(2, 1,   1, 1)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(2, 1, 100, 1)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(2, 1, 101, 7)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(2, 1, 102, 7)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(2, 1, 103, 3)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(2, 1, 104, 3)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(2, 1, 105, 1)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(2, 1, 107, 1)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(2, 1, 108, 15)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(2, 1, 110, 1)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(2, 1, 150, 7)

/* GroupID=3 Accounting */
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1,   0, 1)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1,   1, 15)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1,   2, 15)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1, 100, 1)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1, 101, 7)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1, 102, 7)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1, 103, 7)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1, 104, 7)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1, 105, 7)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1, 106, 7)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1, 107, 7)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1, 108, 15)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1, 110, 7)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1, 111, 7)
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(3, 1, 150, 7)
/* GroupID=4 Customer Access */
INSERT INTO OperatorGroupAccess(OperatorGroupID, GroupID, ObjectGroupID, AccessType) VALUES(4, 1, 200, 7)
END
GO


/* PayPeriods */

IF (SELECT COUNT(*) FROM PayPeriods) = 0
BEGIN
INSERT INTO PayPeriods(PayPeriod, Period, Amount, AmountType, SetupCharge, GroupID, SortOrder) VALUES('Monthly',     1,  100, 0, 1, NULL, 1)
INSERT INTO PayPeriods(PayPeriod, Period, Amount, AmountType, SetupCharge, GroupID, SortOrder) VALUES('Quarterly',   3,  80,  0, 1, NULL, 3)
INSERT INTO PayPeriods(PayPeriod, Period, Amount, AmountType, SetupCharge, GroupID, SortOrder) VALUES('Six Months',  6,  70,  0, 1, NULL, 6)
INSERT INTO PayPeriods(PayPeriod, Period, Amount, AmountType, SetupCharge, GroupID, SortOrder) VALUES('Yearly',     12,  60,  0, 1, NULL, 12)
END
GO

/* Billing Cycles */

IF (SELECT COUNT(*) FROM BillingCycles) = 0
BEGIN
INSERT INTO BillingCycles(Description, CycleType, AutoBill, IBillDays, EBillDays, SortOrder, GroupID) 
	VALUES('Anniversary', 0, 1, 20, 5, 1, NULL)
INSERT INTO BillingCycles(Description, CycleType, AutoBill, IBillDays, EBillDays, SortOrder, GroupID) 
	VALUES('Monthly', 	   1, 1, 20, 5, 2, NULL)
INSERT INTO BillingCycles(Description, CycleType, AutoBill, IBillDays, EBillDays, SortOrder, GroupID) 
	VALUES('Calendar', 	   2, 1, 20, 5, 2, NULL)
END
GO

/* Reports */

/* 'ReportID','Report','FileName' */
IF (SELECT COUNT(*) FROM Reports) = 0
BEGIN
INSERT INTO Reports(Report, FileName) VALUES('Expired Accounts',        'expaccts.rpt')
INSERT INTO Reports(Report, FileName) VALUES('Revenue By Service Type', 'serv_rev.rpt')
INSERT INTO Reports(Report, FileName) VALUES('Monthly Call Summary',    'call_sum.rpt')
INSERT INTO Reports(Report, FileName) VALUES('Bad CC Transactions',     'ccbad.rpt')
INSERT INTO Reports(Report, FileName) VALUES('Daily Payments',          'payments.rpt')
INSERT INTO Reports(Report, FileName) VALUES('Daily New Users',         'newusers.rpt')
END
GO

/* Regions */

/* RegionID, Region, GroupID, Taxable, SortOrder */
IF (SELECT COUNT(*) FROM Regions) = 0
BEGIN
INSERT INTO Regions(Region, GroupID, Taxable, SortOrder) VALUES('MyTown',  NULL, 0, 1)
INSERT INTO Regions(Region, GroupID, Taxable, SortOrder) VALUES('UnKnown', NULL, 0, 2)
END
GO

/* SystemTypes */
/* SystemTypeID, SystemType, GroupID */

IF (SELECT COUNT(*) FROM SystemTypes) = 0
BEGIN
INSERT INTO SystemTypes(SystemType, SortOrder) VALUES('Windows 95', 	1)
INSERT INTO SystemTypes(SystemType, SortOrder) VALUES('Windows 98', 	2)
INSERT INTO SystemTypes(SystemType, SortOrder) VALUES('Windows Me', 	3)
INSERT INTO SystemTypes(SystemType, SortOrder) VALUES('Windows NT', 	4)
INSERT INTO SystemTypes(SystemType, SortOrder) VALUES('Windows 2000', 	5)
INSERT INTO SystemTypes(SystemType, SortOrder) VALUES('Windows XP', 	6)
INSERT INTO SystemTypes(SystemType, SortOrder) VALUES('Linux', 	7)
INSERT INTO SystemTypes(SystemType, SortOrder) VALUES('Mac', 	8)
INSERT INTO SystemTypes(SystemType, SortOrder) VALUES('IBM', 	9)
INSERT INTO SystemTypes(SystemType, SortOrder) VALUES('Other', 	10)
END
GO

/* IncidentTypes */
/* IncidentTypeID, IncidentType,Description,SortOrder */

IF (SELECT COUNT(*) FROM IncidentTypes) = 0
BEGIN
INSERT INTO IncidentTypes(IncidentType,Description,Email,SortOrder)VALUES ('Unknown',	       'Unknown', 		     NULL, 30)
INSERT INTO IncidentTypes(IncidentType,Description,Email,SortOrder)VALUES ('Login Error',      'Login Information error',    NULL, 1)
INSERT INTO IncidentTypes(IncidentType,Description,Email,SortOrder)VALUES ('Dialup Software',  'Dialup Software problem',    NULL, 2)
INSERT INTO IncidentTypes(IncidentType,Description,Email,SortOrder)VALUES ('Modem',            'Modem Configuration Problem',NULL, 3)
INSERT INTO IncidentTypes(IncidentType,Description,Email,SortOrder)VALUES ('Computer Hardware','Computer Hardware',          NULL, 10)
INSERT INTO IncidentTypes(IncidentType,Description,Email,SortOrder)VALUES ('Password Change',  'Password Change',            NULL, 20)
END
GO

/* ReferredBys */

IF (SELECT COUNT(*) FROM ReferredBys) = 0
BEGIN
INSERT INTO ReferredBys(ReferredBy, SortOrder) VALUES('Friend', 	1)
INSERT INTO ReferredBys(ReferredBy, SortOrder) VALUES('Family', 	2)
INSERT INTO ReferredBys(ReferredBy, SortOrder) VALUES('Advertising',	3)
INSERT INTO ReferredBys(ReferredBy, SortOrder) VALUES('Website',	4)
INSERT INTO ReferredBys(ReferredBy, SortOrder) VALUES('Other', 		99)
END
GO

/* SalesPersons */
/* SalesPersonID, SalesPerson, SortOrder  */

IF (SELECT COUNT(*) FROM SalesPersons) = 0
BEGIN
INSERT INTO SalesPersons(SalesPerson, SortOrder) VALUES('Sales', 		1)
INSERT INTO SalesPersons(SalesPerson, SortOrder) VALUES('Signup Server', 	2)
INSERT INTO SalesPersons(SalesPerson, SortOrder) VALUES('Other',	 	3)
END
GO


/* RadATConfigs */
/* 1:PPP, 2:DSL, 3:ISDN, 4:EMail */

IF (SELECT COUNT(*) FROM RadATConfigs) = 0
BEGIN
INSERT INTO RadATConfigs (AccountTypeID,RadAttributeID,RadVendorID,RadVendorType,Data,Value,RadCheck) VALUES(1, 6, 0, 0, '2', 2, 0)	
INSERT INTO RadATConfigs (AccountTypeID,RadAttributeID,RadVendorID,RadVendorType,Data,Value,RadCheck) VALUES(1, 7, 0, 0, '1', 1, 0)

INSERT INTO RadATConfigs (AccountTypeID,RadAttributeID,RadVendorID,RadVendorType,Data,Value,RadCheck) VALUES(2, 6, 0, 0, '2', 2, 0)	
INSERT INTO RadATConfigs (AccountTypeID,RadAttributeID,RadVendorID,RadVendorType,Data,Value,RadCheck) VALUES(2, 7, 0, 0, '1', 1, 0)	

INSERT INTO RadATConfigs (AccountTypeID,RadAttributeID,RadVendorID,RadVendorType,Data,Value,RadCheck) VALUES(3, 6,  0, 0, '2', 1, 0)
INSERT INTO RadATConfigs (AccountTypeID,RadAttributeID,RadVendorID,RadVendorType,Data,Value,RadCheck) VALUES(3, 7,  0, 0, '1', 1, 0)

INSERT INTO RadATConfigs (AccountTypeID,RadAttributeID,RadVendorID,RadVendorType,Data,Value,RadCheck) VALUES(4, 6, 0, 0, '2', 2, 0)	
INSERT INTO RadATConfigs (AccountTypeID,RadAttributeID,RadVendorID,RadVendorType,Data,Value,RadCheck) VALUES(4, 7, 0, 0, '1', 1, 0)	
INSERT INTO RadATConfigs (AccountTypeID,RadAttributeID,RadVendorID,RadVendorType,Data,Value,RadCheck) VALUES(4, 11, 0, 0, 'mailonly', 0, 0)

END
GO


/* ServerGroups */

IF (SELECT COUNT(*) FROM ServerGroups) = 0
BEGIN
INSERT INTO ServerGroups (ServerGroup)
	VALUES('default')
END
GO

/* Servers */

IF (SELECT COUNT(*) FROM Servers) = 0
BEGIN
INSERT INTO Servers (Server,ServerGroupID,ServerType,IPAddress,Location,Ports,Modems,PhoneNumber,ContactName,ContactPhone,ContactPage,Comments,DynamicStart,DynamicEnd,Secret,Community,RadRoamServerID)
	VALUES('localhost',1, 0, '127.0.0.1', 'local', 1, 0, '', '', '', '', 'Radlogin', '', '', 'localhost', 'public', NULL)
END
GO

/* ServerPorts */
/* ServerID, Port, IPAddress, MaxSessionTime, CostPerMinute, UserName, AcctSessionID, AcctStatusType, CallDate, */
/* FramedAddress, CallerID, ConnectInfo, SNMPUser */
IF (SELECT COUNT(*) FROM ServerPorts) = 0
BEGIN
INSERT INTO ServerPorts 
(ServerID,Port,NASIdentifier,IPAddress,MaxSessionTime,CostPerMinute,Username,AcctSessionID,AcctStatusType,CallDate,FramedAddress,CallerID,ConnectInfo,SNMPUser)
	VALUES(1, '0', '127.0.0.1', NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL )
END
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 1) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Hide Passwords',1,1,1,0,0,NULL)
--INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Encrypt Passwords',2,2,1,0,0,NULL)
--INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Restrict Expire',3,3,1,0,0,NULL)
--INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Restrict Acct Delete',4,4,1,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 5) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Default Expire Grace Period (Days)',5,5,6,7,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 6) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Min Password Length',6,6,1,3,0,NULL)
--INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Random Password Length',7,7,1,5,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 8) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Setup Free Period Before Billing (Days)',8,8,6,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 9) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Setup Expire Grace Period (Days)',9,9,6,7,0,NULL)
--INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Incremental Batch',10,10,6,1,0,NULL)
--INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('No SubCost Rounding',12,12,6,1,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 13) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Batch Time Min',13,13,6,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 14) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Send Receipts',14,99,6,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 18) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Default Print Format',18,18,5,2,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 20) = 0
BEGIN
INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Unique Logins Per Domain',20,20,1,0,0,NULL)

END
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 27) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('MBR Requires Address',27,7,1,1,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 28) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Idle timeout (Seconds)',28,30,8,3600,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 29) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('HTML Export Format',29,29,5,0,0,NULL)

-- IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 30) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('External File',30,30,2,0,1,'Extends')
-- IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 31) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('External Log',31,31,2,0,1,'Extends.Log')
-- IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 32) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('External Radius',32,32,2,0,1,'Users')
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 37) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Invoice Next Term Max Days',37,37,6,90,1,NULL)

-- IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 40) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Report Account',40,40,5,0,1,'Account.rpt')
-- IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 41) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Report Invoice',41,41,5,0,1,'Invoice.rpt')
-- IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 42) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Report InvoiceCC',42,42,5,0,1,'InvCC.Rpt')
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 47) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Reports Directory',47,47,5,0,1,'')
-- IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 48) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Report Server URL',48,48,5,0,1,'')
-- IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 49) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('EmerWeb Server URL',49,49,5,0,1,'')
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 50) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Email Smart Host',50,50,4,0,1,'mail')
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 51) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Email Domain',51,51,4,0,1,'localhost')
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 52) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Email Admin',52,52,4,0,1,'admin')
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 53) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Email Accounts',53,53,4,0,1,'accounts')
-- 55 removed
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 59) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Email AutoSync',59,59,4,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 60) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('FTP Allow Directories',60,60,3,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 61) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('FTP Max Dir Size',61,61,3,4096,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 62) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('FTP Default DIR UNC',62,62,3,0,1,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 70) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('CC Batch Out',70,70,9,0,1,'BatchIn.dat')
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 71) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('CC Batch In',71,71,9,0,1,'BatchOut.dat')
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 72) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('CC Batch Limit',72,72,9,500,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 74) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('CC Batch Type',74,74,9,0,0,NULL)
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 75) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('CC Batch Merchant-ID',75,75,9,0,1,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 76) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('CC Batch Store',76,76,9,0,1,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 77) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('CC Batch Terminal',77,77,9,0,1,NULL)

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 80) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('ACH Batch Out',80,80,10,0,1,'ACHBatchIn.dat')
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 81) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('ACH Batch In',81,81,10,0,1,'ACHBatchOut.dat')
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 82) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('ACH Batch Limit',82,82,10,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 84) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('ACH Batch Type',84,84,10,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 85) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('ACH Merchant-ID',85,83,10,0,1,NULL)
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 90) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('CC Export Type',90,80,9,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 92) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('CC Import Type',92,79,9,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 93) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Rebatch Tries',93,90,9,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 94) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Rebatch Interval (days)',94,90,9,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 97) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('ACH Import Type',97,85,10,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 98) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('ACH Export Type',98,86,10,0,0,NULL)



--IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 100) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Radius Debug Level',100,100,7,0,0,NULL)
--IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 101) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Radius Log Level',101,101,7,0,0,NULL)
--IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 102) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Radius Auth Port',102,102,7,1645,0,NULL)
--IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 103) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Radius Acct Port',103,103,7,1646,0,NULL)
--IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 110) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Radius Concurrency',110,110,7,0,0,NULL)
--IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 111) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Radius Case Sense',111,111,7,0,0,NULL)
--IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 112) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Radius Acct Authentic',112,112,7,0,0,NULL)
--IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 113) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Radius Encrypt Passwd',113,113,7,0,0,NULL)
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 200) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Trim days for RadLogs',200,200,11,14,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 201) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Trim days for Scheduler Logs',201,201,11,183,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 202) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Trim days for Audit Logs',202,202,11,183,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 203) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Trim days for Syslogs',203,203,11,183,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 204) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Trim days for Logs',204,204,11,183,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 205) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Trim days for Calls (Stop records only)',205,205,11,730,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 206) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Trim days for Calls (Non-Stop records)',206,206,11,45,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 207) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Trim days for Server Ports',207,207,11,7,0,NULL)

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 300) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Search Results Max',300,300,8,100,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 301) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Preview Results Max',301,301,8,100,0,NULL)

--IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 305) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Menu Types',305,305,8,0,0,NULL)

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 350) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Home URL',350,350,12,0,1,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 351) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Group',351,351,12,0,0,'ISP')
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 352) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('PPP prefix',352,352,12,0,1,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 353) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Service type',353,353,12,1,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 354) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('POP3 server',354,354,12,0,1,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 355) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('SMTP server',355,355,12,0,1,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 356) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('NNTP server',356,356,12,0,1,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 357) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Primary DNS server',357,357,12,0,1,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 358) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Secondary DNS server',358,358,12,0,1,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 359) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Billing Cycle',359,359,12,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 360) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('CallerID limiting',360,360,12,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 362) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('CallerID signup limit',362,362,12,0,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 363) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Log signups',363,363,12,1,0,NULL)
IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 364) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data) VALUES('Setup charge',364,364,12,1,0,NULL)
GO

IF (SELECT COUNT(*) FROM Configs WHERE ConfigID = 505) = 0 INSERT INTO Configs (Description,ConfigID,SortOrder,ConfigGroupID,Value,ConfigType,Data,Feature,Edition) VALUES('Minimum new statement interval (Days)',505,505,6,15,0,NULL,0,1)
GO


/* Populate configvalues */
DELETE FROM ConfigValues WHERE ConfigID IN (1,14,18,20,27,29,55,59,60,92,90,97,98,360,363,364)
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(1,0,'Show Passwords')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(1,1,'Hide Passwords')
--INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(2,0,'Plain Passwords')
--INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(2,1,'Encrypted Passwords')
--INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(3,0,'No Expire Security')
--INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(3,1,'Restrict Expire Changes')
--INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(4,0,'Anyone can Delete data')
--INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(4,1,'Only Admins can delete da')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(14,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(14,1,'Yes')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(18,1,'HTML')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(18,2,'PDF')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(18,3,'RTF')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(18,4,'MS Word')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(20,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(20,1,'Yes')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(27,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(27,1,'Yes')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(29,0,'HTML 3.0 Base Only')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(29,1,'HTML 3.2 Tags + BG Colors')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(29,2,'HTML 3.2 Tags')
-- INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(55,0,'None')
-- INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(55,1,'Comment')
-- INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(55,2,'Quoted')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(59,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(59,1,'Yes')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(60,0,'No Sub-Directories')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(60,1,'Allow Sub-Directories')

DELETE FROM ConfigValues WHERE ConfigID IN (74,84) AND Value = 0
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(74,0,'None')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(84,0,'None')

INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(92,0,'Leave import file after Import')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(92,1,'Delete import file after Import')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(90,1,'Append to current export file')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(90,2,'Overwrite current export file')

INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(97,0,'Leave import file after Import')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(97,1,'Delete import file after Import')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(98,1,'Append to current export file')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(98,2,'Overwrite current export file')

--INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(305,0,'Graphics')
--INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(305,1,'Pull Down')

INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(360,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(360,1,'Yes')

INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(363,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(363,1,'Yes')

INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(364,0,'No')
INSERT INTO ConfigValues (ConfigID,Value,ValueName) VALUES(364,1,'Yes')
-- End Populate configvalues
GO

-- CC Types
INSERT INTO ConfigValues(ConfigID,Value,ValueName)
SELECT 74 AS ConfigID,ExportID,Description
FROM Exports 
	WHERE ExportType IN (1,2,5)
GO

-- ACH Types
INSERT INTO ConfigValues(ConfigID,Value,ValueName)
SELECT 84 AS ConfigID,ExportID,Description
FROM Exports 
	WHERE ExportType = 4
GO

-- Groups
INSERT INTO ConfigValues(ConfigID,Value,ValueName)
SELECT 351 AS ConfigID,GroupID,GroupName
FROM Groups
GO

-- Service Types
INSERT INTO ConfigValues(ConfigID,Value,ValueName)
SELECT 353 AS ConfigID,AccountTypeID,AccountType FROM AccountTypes
GO

-- Billing Cycles
INSERT INTO ConfigValues(ConfigID,Value,ValueName)
SELECT 359 AS ConfigID,BillingCycleID,Description
FROM BillingCycles
GO

/* Populate AllowedHosts */
/* AllowedHostID, IPAddress, Description */
INSERT INTO AllowedHosts (IPAddress, OperatorGroupID, Description) VALUES('*',NULL,'Allow everyone in every group')
go

/* Populate CancelReasons */
/* CancelReasonID, CancelDescription, SortOrder */

IF (SELECT COUNT(*) FROM CancelReasons) = 0
BEGIN
SET IDENTITY_INSERT CancelReasons ON
INSERT INTO CancelReasons (CancelReasonID, CancelDescription, SortOrder) 
	VALUES(1, 'Terminated - Bad account standing' , 1)
INSERT INTO CancelReasons (CancelReasonID, CancelDescription, SortOrder) 
	VALUES(2, 'Terminated - Late Payments' , 2)
INSERT INTO CancelReasons (CancelReasonID, CancelDescription, SortOrder) 
	VALUES(3, 'Terminated - Customer Request' , 3)
INSERT INTO CancelReasons (CancelReasonID, CancelDescription, SortOrder) 
	VALUES(4, 'Temporary - Customer Request' , 4)
INSERT INTO CancelReasons (CancelReasonID, CancelDescription, SortOrder) 
	VALUES(5, 'Temporary - ISP Request' , 5)
SET IDENTITY_INSERT CancelReasons OFF
END
GO

