CREATE TABLE RadRejectAttributes (
       RadRejectAttributeID INTEGER ,
       IEAID                INTEGER NULL,
       ServerID             INTEGER NULL,
       RadLogMsgID          INTEGER NOT NULL,
       RadVendorID          INTEGER NOT NULL,
       RadAttributeID       INTEGER NOT NULL,
       Data                 VARCHAR2(255) NOT NULL
)
/
ALTER TABLE RadRejectAttributes
       ADD PRIMARY KEY (RadRejectAttributeID)
/
ALTER TABLE RadRejectAttributes
       ADD FOREIGN KEY (ServerID)
                             REFERENCES Servers
/
ALTER TABLE RadRejectAttributes
       ADD FOREIGN KEY (RadAttributeID, RadVendorID)
                             REFERENCES RadAttributes
/
ALTER TABLE RadRejectAttributes
       ADD FOREIGN KEY (RadLogMsgID)
                             REFERENCES RadLogMsgs
/
CREATE SEQUENCE RadRejectAttributes_seq
/
CREATE OR REPLACE TRIGGER RadRejectAttributes_itrig
BEFORE INSERT ON RadRejectAttributes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.RadRejectAttributeID IS NULL THEN
	SELECT RadRejectAttributes_seq.nextval INTO seq_val FROM DUAL;
	:new.RadRejectAttributeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE TABLE SubAccountUsages (
       SubAccountUsageID    INTEGER ,
       AccountID            INTEGER NOT NULL,
       ExpireDate           DATE NOT NULL,
       TimeLeft             INTEGER NULL,
       DataLeft             NUMBER(38) NULL,
       ItemID               INTEGER NULL,
       StartTimeLeft        INTEGER NULL,
       StartDataLeft        NUMBER(38) NULL
)
/
CREATE INDEX IX_SAU_AIDEXPTLDL ON SubAccountUsages
(
       AccountID,
       ExpireDate,
       TimeLeft,
       DataLeft
)
/
CREATE INDEX IX_SAU_ItemID ON SubAccountUsages
(
       ItemID
)
/
ALTER TABLE SubAccountUsages
       ADD PRIMARY KEY (SubAccountUsageID)
/
ALTER TABLE SubAccountUsages
       ADD FOREIGN KEY (ItemID)
                             REFERENCES InvoiceItems
/
ALTER TABLE SubAccountUsages
       ADD FOREIGN KEY (AccountID)
                             REFERENCES SubAccounts
/
CREATE SEQUENCE SubAccountUsages_seq
/
CREATE OR REPLACE TRIGGER SubAccountUsages_itrig
BEFORE INSERT ON SubAccountUsages
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.SubAccountUsageID IS NULL THEN
	SELECT SubAccountUsages_seq.nextval INTO seq_val FROM DUAL;
	:new.SubAccountUsageID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

ALTER TABLE Taxes ADD TaxTypeID INTEGER
/

CREATE TABLE TaxTypes (
       TaxTypeID            INTEGER ,
       TaxType              VARCHAR2(64) NOT NULL
)
/
ALTER TABLE TaxTypes
       ADD PRIMARY KEY (TaxTypeID)
/
ALTER TABLE Taxes
       ADD FOREIGN KEY (TaxTypeID)
                             REFERENCES TaxTypes
/
CREATE SEQUENCE TaxTypes_seq
/
CREATE OR REPLACE TRIGGER TaxTypes_itrig
BEFORE INSERT ON TaxTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.TaxTypeID IS NULL THEN
	SELECT TaxTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.TaxTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE TABLE ResellerPkgUsage (
       StartYear            smallint NOT NULL,
       StartMonth           smallint NOT NULL,
       PackageID            INTEGER NOT NULL,
       PackageTypeID        INTEGER NOT NULL,
       Days                 NUMBER DEFAULT (0)  NOT NULL,
       LastUpdate           DATE DEFAULT (SYSDATE)  NOT NULL,
       ItemID               INTEGER NULL
)
/
CREATE INDEX i_ResellerPkgUsage_PackageID ON ResellerPkgUsage
(
       PackageID,
       StartYear,
       StartMonth
)
/
ALTER TABLE ResellerPkgUsage
       ADD PRIMARY KEY (StartYear, StartMonth, PackageID, 
              PackageTypeID)
/
ALTER TABLE ResellerPkgUsage
       ADD FOREIGN KEY (ItemID)
                             REFERENCES InvoiceItems
/
ALTER TABLE ResellerPkgUsage
       ADD FOREIGN KEY (PackageID)
                             REFERENCES Packages
/
ALTER TABLE ResellerPkgUsage
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES PackageTypes
/

CREATE TABLE OrgPackageTypes (
       OrganizationID       INTEGER NOT NULL,
       PackageTypeID        INTEGER NOT NULL,
       ResellerCost         numeric(18,4) NULL,
       CustomerCost         numeric(18,4) NULL,
       Comments             VARCHAR2(128) NULL
)
/
ALTER TABLE OrgPackageTypes
       ADD PRIMARY KEY (OrganizationID, PackageTypeID)
/
ALTER TABLE OrgPackageTypes
       ADD FOREIGN KEY (OrganizationID)
                             REFERENCES Organizations
/
ALTER TABLE OrgPackageTypes
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES PackageTypes
/

CREATE TABLE VoiceCalls (
       VoiceCallID          NUMBER(38) ,
       AccountID            INTEGER NULL,
       CallDate             DATE NOT NULL,
       Login                VARCHAR2(64) NOT NULL,
       Duration             INTEGER NOT NULL,
       SessionRef           VARCHAR2(64) NULL,
       CalledNumber         VARCHAR2(64) NULL,
       CallingPort          VARCHAR2(32) NULL,
       CalledPort           VARCHAR2(32) NULL,
       Bytes                NUMBER(38) NULL,
       CallType             VARCHAR2(64) NULL,
       AcctTerminateCause   smallint NULL,
       CountryID            INTEGER NULL,
       StateID              INTEGER NULL,
       Location             VARCHAR2(64) NULL,
       ChargeID             INTEGER NULL,
       ProcDate             DATE NULL,
       ErrorCode            smallint NULL,
       Cost                 numeric(18,4) NULL
)
/
CREATE UNIQUE INDEX i_VoiceCalls_Unique ON VoiceCalls
(
       CallDate,
       Login,
       Duration,
       SessionRef,
       CalledNumber
)
/
CREATE INDEX i_VoiceCalls_AID_CD ON VoiceCalls
(
       AccountID,
       CallDate
)
/
CREATE INDEX i_VoiceCalls_C_PD ON VoiceCalls
(
       ChargeID,
       ProcDate
)
/
ALTER TABLE VoiceCalls
       ADD PRIMARY KEY (VoiceCallID)
/
CREATE SEQUENCE VoiceCalls_seq
/
CREATE OR REPLACE TRIGGER VoiceCalls_itrig
BEFORE INSERT ON VoiceCalls
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.VoiceCallID IS NULL THEN
	SELECT VoiceCalls_seq.nextval INTO seq_val FROM DUAL;
	:new.VoiceCallID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/

CREATE INDEX i_MBR_PhoneHome ON MasterAccounts (PhoneHome)
/
CREATE INDEX i_MBR_PhoneWork ON MasterAccounts (PhoneWork)
/
CREATE INDEX i_PMT_StatementID ON Payments (StatementID)
/
CREATE INDEX i_PMT_FinalStatementID ON Payments (FinalStatementID)
/


ALTER TABLE PackageTypes ADD InvoiceDescription VARCHAR2(64)
/
ALTER TABLE PackageTypes ADD CustomerStringID INTEGER
/
ALTER TABLE ExternalSystemAccountTypes ADD ExternalRef VARCHAR2(64) 
/
ALTER TABLE Exports ADD StageCount INTEGER
/
ALTER TABLE TaxGroupTaxes ADD City VARCHAR2(45)
/
ALTER TABLE TaxGroupTaxes ADD Zip VARCHAR2(15)
/
ALTER TABLE InvoiceItems ADD ParentItemID INTEGER
/
ALTER TABLE RateDataSources ADD ClearQuery CLOB
/
ALTER TABLE Charges ADD PrevChargeID INTEGER
/
ALTER TABLE SignupServers ADD AddressTypeID INTEGER
/
ALTER TABLE SignupServers ADD AddressDescription VARCHAR2(128)
/

ALTER TABLE MasterAccountDataTypes ADD Required SMALLINT
/
ALTER TABLE SubAccountDataTypes ADD Required SMALLINT
/
ALTER TABLE IncidentDataTypes ADD Required SMALLINT
/
ALTER TABLE IncidentDataTypes ADD RegExp VARCHAR2(255)
/
ALTER TABLE IncidentDataTypes ADD SQLQuery CLOB
/
ALTER TABLE AccountDataTypes ADD RegExp VARCHAR2(255)
/
ALTER TABLE ExternalSystemDataTypes ADD Required SMALLINT
/
ALTER TABLE IncidentStates ADD ActionOnly SMALLINT
/
ALTER TABLE SignupServers ADD Title VARCHAR2(128)
/
ALTER TABLE MasterAccountDataTypes ADD ServiceGroupID INTEGER
/
ALTER TABLE AccountTypes ADD SecChargeTypeID INTEGER
/
ALTER TABLE PackageTypes ADD SecChargeTypeID INTEGER
/
ALTER TABLE Domains ADD CustomerID INTEGER
/
CREATE INDEX i_Domains_CustomerID ON Domains (CustomerID)
/
ALTER TABLE Domains ADD CustomerAccess SMALLINT
/
ALTER TABLE PackageAccountTypes ADD AllowCustSetDomain SMALLINT
/
CREATE INDEX i_SA_PhoneHome ON SubAccounts (PhoneHome)
/
CREATE INDEX i_SA_PhoneWork ON SubAccounts (PhoneWork)
/
CREATE INDEX i_MBR_PhoneFax ON MasterAccounts (PhoneFax)
/
CREATE INDEX i_Packages_LMD ON Packages (LastModifyDate)
/
CREATE INDEX i_SubAccounts_LMD ON SubAccounts (LastModifyDate)
/
ALTER TABLE RadIPAccountTypes ADD AssignType SMALLINT
/
ALTER TABLE RadIPAddresses ADD AccountID INTEGER
/
CREATE INDEX I_RadIPAddress_AID ON RadIPAddresses (AccountID)
/
ALTER TABLE AccountTypes ADD AccountTemplateID INTEGER
/

CREATE TABLE AccountTemplates (
       AccountTemplateID    INTEGER NOT NULL,
       AccountTemplate      VARCHAR2(128) NOT NULL,
       LoginLabel           VARCHAR2(128) NULL,
       LoginStringID        INTEGER NULL,
       SANew                VARCHAR2(64) NULL,
       SAEdit               VARCHAR2(64) NULL,
       SASave               VARCHAR2(64) NULL,
       SADetail             VARCHAR2(64) NULL,
       CustNew              VARCHAR2(64) NULL,
       CustEdit             VARCHAR2(64) NULL,
       CustEditLabel        VARCHAR2(128) NULL,
       CustEditStringID     INTEGER NULL,
       CustSave             VARCHAR2(64) NULL,
       SignupPage           VARCHAR2(64) NULL,
       SignupForm           VARCHAR2(64) NULL,
       SignupValidate       VARCHAR2(64) NULL,
       SignupSave           VARCHAR2(64) NULL,
       SortOrder            smallint DEFAULT (0)  NOT NULL
)
/
ALTER TABLE AccountTemplates
       ADD PRIMARY KEY (AccountTemplateID)
/
ALTER TABLE AccountTypes
       ADD FOREIGN KEY (AccountTemplateID)
                             REFERENCES AccountTemplates
/
ALTER TABLE Domains ADD ExpireDate DATE
/
ALTER TABLE Domains ADD ExternalDNSRef VARCHAR2(64)
/
ALTER TABLE Domains ADD ErrorCount INTEGER
/
ALTER TABLE Domains ADD ErrorMessage VARCHAR2(128)
/
CREATE INDEX i_MetaColumns_MTID_MC ON MetaColumns (MetaTableID,ColumnName)
/

ALTER TABLE IncidentDataTypes ADD IncidentTemplateID INT
/
CREATE TABLE IncidentTemplates (
       IncidentTemplateID   INTEGER NOT NULL,
       IncidentTemplate     VARCHAR2(128) NOT NULL,
       IncidentEdit         VARCHAR2(64) NULL,
       IncidentSave         VARCHAR2(64) NULL,
       CustIncidentEdit     VARCHAR2(64) NULL,
       CustIncidentSave     VARCHAR2(64) NULL,
       SortOrder            smallint DEFAULT (0)  NOT NULL
)
/
ALTER TABLE IncidentTemplates
	ADD PRIMARY KEY (IncidentTemplateID)
/
ALTER TABLE IncidentDataTypes
       ADD FOREIGN KEY (IncidentTemplateID)
                             REFERENCES IncidentTemplates
/

ALTER TABLE ExternalSyncs ADD Aux4 VARCHAR2(128)
/
ALTER TABLE ExternalSyncs ADD Aux5 VARCHAR2(128)
/
ALTER TABLE ExternalSyncs ADD Aux6 VARCHAR2(128)
/
ALTER TABLE ExternalSyncs ADD Aux7 VARCHAR2(128)
/
ALTER TABLE ExternalSyncs ADD Aux8 VARCHAR2(768)
/
ALTER TABLE Operators ADD DaySumIncident SMALLINT
/

CREATE TABLE SignupPackageTypes (
       SignupPackageTypeID  INTEGER ,
       SignupServerID       INTEGER NOT NULL,
       PackageTypeID        INTEGER NOT NULL
)
/

CREATE UNIQUE INDEX i_SPT_Signup_Package ON SignupPackageTypes
(
       SignupServerID,
       PackageTypeID
)
/

ALTER TABLE SignupPackageTypes
       ADD PRIMARY KEY (SignupPackageTypeID)
/

ALTER TABLE SignupPackageTypes
       ADD FOREIGN KEY (PackageTypeID)
                             REFERENCES PackageTypes
/

ALTER TABLE SignupPackageTypes
       ADD FOREIGN KEY (SignupServerID)
                             REFERENCES SignupServers
/

CREATE SEQUENCE SignupPackageTypes_seq
/
CREATE OR REPLACE TRIGGER SignupPackageTypes_itrig
BEFORE INSERT ON SignupPackageTypes
FOR EACH ROW
DECLARE
seq_val number;
BEGIN
IF :new.SignupPackageTypeID IS NULL THEN
	SELECT SignupPackageTypes_seq.nextval INTO seq_val FROM DUAL;
	:new.SignupPackageTypeID := seq_val;
	Last.ID := seq_val;
END IF;
END;
/
ALTER CLUSTER iCalls_CallID SIZE 64
/
ALTER CLUSTER IX_PaymentItems SIZE 16
/
ALTER CLUSTER i_RC_GroupAccountID SIZE 64
/
ALTER CLUSTER IX_RadIPAddresses SIZE 64
/


ALTER TABLE SignupServers ADD ShowLogin SMALLINT
/
ALTER TABLE Roles ADD AssignStrategyID INTEGER
/
ALTER TABLE Operators ADD MeasureUnitID SMALLINT
/
ALTER TABLE Batches ADD Rebatch SMALLINT
/
ALTER TABLE AccountTypes ADD DataLeftRenewal SMALLINT
/
ALTER TABLE AccountTypes ADD TimeLeftRenewal SMALLINT
/
ALTER TABLE SubAccounts ADD LastDataLeftDate DATE
/
ALTER TABLE AccountTemplates ADD SignupBillSave VARCHAR2(64)
/
ALTER TABLE MasterAccounts ADD TransHoldDate DATE
/
ALTER TABLE BillingCycles ADD TBillDays INTEGER
/
ALTER TABLE SignupServers ADD PrepaidTransfer SMALLINT
/
CREATE INDEX i_Operators_Email ON Operators (Email)
/
ALTER TABLE AccountTypes ADD InactCanceledDays SMALLINT
/
ALTER TABLE OperatorCookies ADD OperatorID INTEGER
/
ALTER TABLE OperatorCookies ADD AccountID INTEGER
/
ALTER TABLE CardBatches ADD ActiveExpireMins INTEGER
/
ALTER TABLE CardBatchTypes ADD ActiveExpireMins INTEGER
/
ALTER TABLE IncidentTypes ADD EnableOperatorRole SMALLINT
/
ALTER TABLE SendMethods ADD CustomerAccess SMALLINT
/
ALTER TABLE Invoices ADD ExtInvoiceNum VARCHAR2(20)
/
CREATE INDEX i_Invoices_ExtInvoiceNum ON Invoices (ExtInvoiceNum)
/
ALTER TABLE MetaColumns ADD RegExp VARCHAR2(255)
/
ALTER TABLE MetaColumns ADD CheckQuery VARCHAR2(255)
/
CREATE INDEX i_Statements_CustomerID ON Statements (CustomerID)
/
ALTER TABLE ServerPorts MODIFY ServerID INTEGER NULL
/
CREATE INDEX i_InvoiceItems_AID ON InvoiceItems (AccountID,InvoiceID)
/


UPDATE RadAttributes SET RadAttributeType = 6 WHERE RadAttributeID = 80 AND RadVendorID = 0 AND RadAttributeType <> 6
/
UPDATE RadValues SET Name = 'GRE' WHERE Value = 10 AND RadAttributeID = 64 AND RadVendorID = 0 AND Name <> 'GRE'
/
UPDATE RadAttributes SET RadAttributeType = 1, Name = 'Motorola-Canopy-VLAGETO' WHERE RadAttributeID = 20 AND RadVendorID = 161 AND RadAttributeType = 6
/
UPDATE RadAttributes SET RadAttributeType = 20 WHERE RadAttributeID IN (1,28,29,35,37,38) AND RadVendorID = 24757 AND RadAttributeType = 6
/
UPDATE RadAttributes SET RadAttributeType = 21, Name = 'Extended-Type-1' WHERE RadVendorID = 0 AND RadAttributeID = 241 AND RadAttributeType = 1
/
UPDATE RadAttributes SET RadAttributeType = 21, Name = 'Extended-Type-2' WHERE RadVendorID = 0 AND RadAttributeID = 242 AND RadAttributeType = 4
/
UPDATE RadAttributes SET RadAttributeType = 21, Name = 'Extended-Type-3' WHERE RadVendorID = 0 AND RadAttributeID = 243 AND RadAttributeType = 4
/
UPDATE RadAttributes SET RadAttributeType = 21, Name = 'Extended-Type-4' WHERE RadVendorID = 0 AND RadAttributeID = 244 AND RadAttributeType = 1
/
UPDATE RadAttributes SET RadAttributeType = 22, Name = 'Extended-Type-Flagged-1' WHERE RadVendorID = 0 AND RadAttributeID = 245 AND RadAttributeType = 1
/
UPDATE RadAttributes SET RadAttributeType = 22, Name = 'Extended-Type-Flagged-2' WHERE RadVendorID = 0 AND RadAttributeID = 246 AND RadAttributeType = 1
/

UPDATE RadAttributes SET RadAttributeType = 10, Name = 'Tunnel-Client-Auth-ID' WHERE RadVendorID = 0 AND RadAttributeID = 90 AND RadAttributeType = 0
/
UPDATE RadAttributes SET RadAttributeType = 10, Name = 'Tunnel-Server-Auth-ID' WHERE RadVendorID = 0 AND RadAttributeID = 91 AND RadAttributeType = 0
/
UPDATE RadAttributes SET RadAttributeType = 9, Name = 'Delegated-IPv6-Prefix' WHERE RadVendorID = 0 AND RadAttributeID = 123 AND RadAttributeType = 1
/
UPDATE RadAttributes SET RadAttributeType = 5, Name = 'Framed-IPv6-Address' WHERE RadVendorID = 0 AND RadAttributeID = 168 AND RadAttributeType = 0
/
UPDATE RadAttributes SET RadAttributeType = 0, Name = 'Stateful-IPv6-Address-Pool' WHERE RadVendorID = 0 AND RadAttributeID = 172 AND RadAttributeType = 1
/
UPDATE RadAttributes SET RadAttributeType = 20, Name = 'IPv6-6rd-Configuration' WHERE RadVendorID = 0 AND RadAttributeID = 173 AND RadAttributeType = 1
/

UPDATE RadAttributes SET RadAttributeType = 0 WHERE RadAttributeType <> 0 AND RadVendorID = 0 AND RadAttributeID BETWEEN 103 AND 122
/
UPDATE RadAttributes SET RadAttributeType = 1 WHERE RadVendorID = 161 AND RadAttributeID IN (5,14,15,21,22,23,50)
/

DELETE FROM RadVendors WHERE RadVendorID NOT IN (SELECT RadVendorID FROM RadAttributes)
/

