-- This file contains all SQL code to import all Emerald 4.5 database into a
-- new Emerald 5.0 database. Do not make changes to this file unless directed
-- by IEA Software support.

-- First we need to clear out existing data

IF ((SELECT COUNT(*) FROM MasterAccounts) > 0)
BEGIN
RAISERROR('Database upgrade cannot run against an existing database with MBR records, remove all MBRs and try again',11,1)
END

DELETE FROM RadLogs
GO
DELETE FROM MailLogs
GO
DELETE FROM NoticeLogs
GO
DELETE FROM MailLogs
GO
DELETE FROM AuditLogs
GO
DELETE FROM Aliases 
GO
DELETE FROM Forwards 
GO
DELETE FROM Actions 
GO
DELETE FROM IncidentData
GO
Delete From Incidents 
GO
DELETE FROM RadConfigs 
GO
DELETE FROM RadTriggers 
GO
DELETE FROM RateHistory 
GO
DELETE FROM SubAccountData
GO
Delete From Charges 
GO
Delete From InvoiceItems
GO
DELETE FROM FileTransfers
GO
DELETE FROM ResellerUsage
GO
Delete From SubAccounts
GO

Delete From Charges 
GO
Delete From InvoiceItems 
GO
DELETE FROM ExternalTrans
GO
Delete From Payments
GO
DELETE FROM BankTrans 
GO
Delete From Invoices
GO
DELETE FROM MailLogs
GO
Update MasterAccounts Set LastStatementID = NULL
GO
Delete From Statements
GO
DELETE FROM CreditCards
GO
DELETE FROM BankTrans
GO
DELETE FROM Addresses
GO
Delete From AddressTypes
GO
DELETE FROM MasterAccountData
GO
DELETE FROM Packages
GO
DELETE FROM OrgAccountTypes
GO

Delete From CardAccounts
GO
Delete From CardBatches
GO
Delete From CardBatchTypes
GO
Delete From ServerAccess
GO
Delete From PackageAccountTypes
GO
Delete From PackageTypes
GO
Delete From RadATConfigs
GO
Delete From RadConcurrency
GO
Delete From RadRoamDomains
GO
Delete From RadRoamServers
GO
Delete From ServerPorts
GO
Delete From ServerHistory
GO
Delete From Servers
GO
Delete From RadIPAccountTypes
GO
Delete From ServerGroups
GO
Delete From RadFilters
GO
Delete From RadFilterGroups
GO
Delete From RadIPAccountTypes
GO
Delete From RadIPAddresses
GO

Delete From RadIPGroups
GO
Delete From RadProxyAttributes
GO
Delete From RadProxyAttributeGroups
GO
Delete From TimeCharges
GO
Delete From LateFees
GO
Update AccountTypes Set ChargeTypeID = NULL
GO
Delete From RateItems
GO
Delete From Rates
GO
Delete From ChargeTypes
GO
Delete From SubAccountDataTypes
GO
Delete From ExternalSystemAccountTypes
GO
Delete From AccountTypes
GO
Delete From SignupServers
GO
Delete From ConfigGroupData
GO
Update Domains Set GroupID = NULL
GO
Delete From Groups
GO
Delete From BatchProcessors
GO
Delete From Organizations
GO
Delete From Domains
GO
Delete From MasterAccounts
GO

Delete From DNISNumbers
GO
Delete From DNISGroups
GO
Delete From TaxGroupTaxes
GO
Delete From Taxes
GO
Delete From TaxGroups

Delete From ExternalSystems
GO
Delete From BillingCycles
GO
Delete From ReferredBys
GO
Delete From SalesPersons
GO
Delete From Regions
GO
Delete From PayPeriods
GO
Delete From CancelReasons
GO
Delete From Discounts
GO

Delete From AccountDataValues
GO
Delete From MasterAccountDataTypes
GO
Delete From SubAccountDataTypes
GO
Delete From IncidentTypes
GO
Delete From IncidentStates
GO
Delete From IncidentStateGroups
GO
Delete From OperatorGroupAccess
GO
Delete From Operators
GO
Delete From OperatorGroups
GO
Delete From AllowedHosts
GO
Delete From ScheduleLogs
GO
Delete From ScheduleServers
GO
Delete From WebLinks
GO
Delete From FlowFilters
GO
Delete From FlowFilterGroups
GO
Delete From GLCodes
GO
Delete From LDAPServers
GO
Delete From RateClasses
GO
Delete From Rates
GO

SET IDENTITY_INSERT Organizations ON
Insert Into Organizations(OrganizationID, ResellerCustomerID,Organization,InvoiceDetailed,InvoiceFractional,MaxAccounts)
	VALUES(1,NULL,'Default',1,1,NULL)
SET IDENTITY_INSERT Organizations OFF
GO

/* Domains  */
SET IDENTITY_INSERT Domains ON
Insert Into Domains(DomainID, Domain, MailDomain, GroupID, Description, SortOrder) 
	 Select DomainID, Domain, MailDomain, NULL, Description, SortOrder 
	 From Emerald..Domains
SET IDENTITY_INSERT Domains OFF
GO

IF ((SELECT COUNT(*) FROM Emerald..AccountTypes WHERE Cost < 0) > 0)
BEGIN
RAISERROR('Service Types having an amount less than 0 are not allowed in Emerald 5.  Choose Ignore to continue with the conversion however you MUST fix this before running billing in Emerald 5.',11,1)
END
GO

/*  Groups  */
SET IDENTITY_INSERT Groups ON
Insert Into Groups(GroupID,OrganizationID,DomainID,GroupName,Description,InvoiceReport,InvoiceTextReport,InvoiceHTMLReport,StatementReport,StatementTextReport,StatementHTMLReport,GlobalAccountTypes,GlobalBillingCycles,GlobalRegions,GlobalPayPeriods,GlobalDiscounts,GlobalChargeTypes,GlobalPackageTypes,GlobalDomains,GlobalSalesPersons,GlobalSendMethods,SortOrder,FTPDir,BillingOption,SendCredits,BillName,BillAddress1,BillAddress2,BillCity,BillState,BillZip,BillCountryID,EmailAccounts,EmailSubject,AutoEmailInvoices,AutoEmailStatements,ThemeID,ThemeScore,StartDate,EndDate,Active,MBRFields,PaymentTypes)
	        Select GroupID,1,             DomainID,GroupName,Description,InvoiceReport,InvoiceTextReport,InvoiceHTMLReport,StatementReport,StatementTextReport,StatementHTMLReport,1,1,1,1,1,1,1,1,1,1,SortOrder,FTPDir,BillingOption,SendCredits,BillName,BillAddress1,BillAddress2,BillCity,BillState,BillZip,840,EmailAccounts,EmailSubject,0,1,NULL,NULL,NULL,NULL,1,65535,65535
	 From Emerald..Groups g
SET IDENTITY_INSERT Groups OFF
GO

Update d Set d.GroupID = d2.GroupID
From Domains d, Emerald..Domains d2
Where d.DomainID = d2.DomainID
	and d2.GroupID IS NOT NULL
GO

/*  DNISGroups  */
SET IDENTITY_INSERT DNISGroups ON
Insert Into DNISGroups(DNISGroupID, DNISGroup, Description) 
	Select DNISGroupID, DNISGroup, Description
	From Emerald..DNISGroups
SET IDENTITY_INSERT DNISGroups OFF
GO

/*  DNISNumbers  */
Insert Into DNISNumbers(DNISGroupID, DNISNumber) 
	Select DNISGroupID, DNISNumber 
	From Emerald..DNISNumbers 
GO

/*
-- Create a rate class for each existing rate. Alternate rates will have to have separate time and rule sets created
-- For time based alternates: Add to RateTimeGroups, RateTimes (to define the alternate time period) and a RateRule (to define cost) .. 
-- then for the rate itself add a RateItem to tie the two)
-- For Over use RateStdGroups/Items on the 'default' RateRule for your rate... Use the TotalCount attribute to set the change point.
-- Fix: (Alternates)
*/

SET IDENTITY_INSERT RateClasses ON
Insert Into RateClasses(RateClassID,RateClass) 
	Select RateID, Description
	From Emerald..Rates 
SET IDENTITY_INSERT RateClasses OFF
GO

INSERT INTO RateIntervals (RateIntervalID,RateRuleTypeID,NameSingular,NamePlural,NameShort)
SELECT DefaultInterval AS RateIntervalID,CASE WHEN MIN(DefaultType) = 0 THEN 1 WHEN MIN(DefaultType) = 1 THEN 2 ELSE 1 END AS RateRuleTypeID,CAST(DefaultInterval AS VARCHAR(32)) AS NameSingular,CAST(DefaultInterval AS VARCHAR(32)) AS NamePlural, 'FIXME' AS NameShort
FROM Emerald..Rates
	WHERE DefaultInterval NOT IN (SELECT RateIntervalID FROM RateIntervals)
GROUP BY DefaultInterval
GO

SET IDENTITY_INSERT RateRules ON
Insert Into RateRules(RateRuleID,RateRule,StringID,RateSourceID,RateRoundTypeID,RateTypeID,RateRuleTypeID,
	Interval,ClassRequired,ClassTTL,ClassQuery,RuleQuery,DefaultCost,Description) 
Select RateID+100,Description,NULL as StringID,1 as RateSourceID,1 as RateRoundTypeID,rt.RateTypeID,
CASE WHEN DefaultType = 0 THEN 1 WHEN DefaultType = 1 THEN 2 ELSE 1 END AS RateRuleTypeID,
	DefaultInterval,0 as ClassRequired,NULL as ClassTTL,NULL as ClassQuery,rt.RuleQuery,DefaultCharge,NULL
From Emerald..Rates r, RateTypes rt
	WHERE rt.RateTypeID = 1
SET IDENTITY_INSERT RateRules OFF
GO

/* GLCodes */
SET IDENTITY_INSERT GLCodes ON
INSERT INTO GLCodes(GLCodeID,GLCode,Description,DetailFlag)
Select GLCodeID,GLCode,Description,DetailFlag
	From Emerald..GLCodes 
SET IDENTITY_INSERT GLCodes OFF
GO

/*  Taxes  */
SET IDENTITY_INSERT TaxGroups ON
INSERT INTO TaxGroups(TaxGroupID,TaxGroup)
Select TaxID,Description 
	From Emerald..Taxes 
SET IDENTITY_INSERT TaxGroups OFF
GO

-- TaxPiggyBacks for PiggyBacks
IF (Select Count(*) From Emerald..Taxes Where TaxType = 3) > 0
	BEGIN
	SET IDENTITY_INSERT TaxPiggyBacks ON
	INSERT INTO TaxPiggyBacks(TaxPiggyBackID,TaxPiggyBack)
	Select TaxID,Description 
		From Emerald..Taxes 
		Where TaxType = 3
	SET IDENTITY_INSERT TaxPiggyBacks OFF
	END

SET IDENTITY_INSERT Taxes ON
-- Insert all base taxes
INSERT INTO Taxes(TaxID,Description,StringID,Tax,AmountType,CumulativeType,FloorLimit,CeilingLimit,TaxPiggyBackID,TaxPigOrder,GLCodeID,TaxExemptions,TaxCredits,SortOrder)
Select TaxID, Description,NULL,Tax, 1 as AmountType , CASE WHEN CumulativeType = 1 THEN 2 ELSE 0 END CumulativeType, 
		CASE WHEN LimitType=1 THEN Limit ELSE NULL END as FloorLimit,NULL as CeilingLimit,
		CASE WHEN TaxType = 3 THEN TaxID ELSE NULL END as TaxPiggyBackID,
		1 as TaxPigOrder,GLCodeID,1 AS TaxExemptions,0 AS TaxCredits, 1 as SortOrder
	From Emerald..Taxes
SET IDENTITY_INSERT Taxes OFF

INSERT INTO TaxGroupTaxes(TaxGroupID, TaxID)
Select TaxID, TaxID
From Emerald..Taxes
GO

IF (Select Count(*) From Emerald..Taxes Where TaxType = 2) > 0
	BEGIN
	INSERT INTO Taxes(Description,StringID,Tax,AmountType,CumulativeType,FloorLimit,CeilingLimit,TaxPiggyBackID,TaxPigOrder,GLCodeID,TaxExemptions,TaxCredits,SortOrder)
	Select COALESCE(Description2,'Unknown'),TaxID,Tax2, 1 as AmountType, CASE WHEN CumulativeType = 1 THEN 2 ELSE 0 END CumulativeType, 
			CASE WHEN LimitType=1 THEN Limit ELSE NULL END as FloorLimit,NULL as CeilingLimit,NULL as TaxPiggyBackID,
			1 as TaxPigOrder,GLCodeID,0 as TaxExemptions,0 as TaxCredits, 1 as SortOrder
		From Emerald..Taxes 
		Where TaxType = 2 -- Double second tax

	INSERT INTO TaxGroupTaxes(TaxGroupID, TaxID)
	Select StringID, TaxID
	From Taxes Where StringID IS NOT NULL

	Update Taxes Set StringID = NULL Where StringID IS NOT NULL

	END
GO

IF (Select Count(*) From Emerald..Taxes Where TaxType = 3) > 0
	BEGIN
	INSERT INTO Taxes(Description,StringID,Tax,AmountType,CumulativeType,FloorLimit,CeilingLimit,TaxPiggyBackID,TaxPigOrder,GLCodeID,TaxExemptions,TaxCredits,SortOrder)
	Select Description2,NULL,Tax2, 1 as AmountType , CASE WHEN CumulativeType = 1 THEN 2 ELSE 0 END CumulativeType, 
			CASE WHEN LimitType=1 THEN Limit ELSE NULL END as FloorLimit,NULL as CeilingLimit,TaxID as TaxPiggyBackID,
			1 as TaxPigOrder,GLCodeID,0 as TaxExemptions,0 as TaxCredits, 1 as SortOrder
		From Emerald..Taxes 
		Where TaxType = 3 -- PiggBack Second Tax
	END

GO

/*  ChargeTypes  */
SET IDENTITY_INSERT ChargeTypes ON
Insert Into ChargeTypes(ChargeTypeID,Description,StringID,Amount,TaxGroupID,TaxExemptions,GroupID,ServiceGroupID,GLCodeID,SortOrder,ChargeUses) 
	Select ChargeTypeID,Description,NULL AS StringID,Amount,TaxID,0 AS TaxExemptions,GroupID,NULL AS ServiceGroupID,GLCodeID,SortOrder,65535 AS ChargeUses
	From Emerald..ChargeTypes
SET IDENTITY_INSERT ChargeTypes OFF
GO

Insert Into ChargeTypes(Description,StringID,Amount,TaxGroupID,TaxExemptions,GroupID,ServiceGroupID,GLCodeID,SortOrder,ChargeUses) 
VALUES('Default Rate Charge',NULL,0,NULL,0,NULL,NULL,NULL,99,0)
GO

DECLARE @drcid int
Select @drcid=ChargeTypeID From ChargeTypes Where Description = 'Default Rate Charge'

SET IDENTITY_INSERT Rates ON
Insert Into Rates(RateID,RateSourceID,Description,MinCharge,MaxCharge,ChargeTypeID,RateClassID,DataRateRuleID,
	ClassifierRateRuleID,AuthMaxTime,AuthRate,AuthRateTime)
Select RateID,1 as RateSourceID,Description,MinCharge,MaxCharge,@drcid as ChargeTypeID,RateID AS RateClassID,
CASE WHEN DefaultType = 1 THEN RateID+100 ELSE NULL END AS DataRateRuleID,
	7 AS ClassifierRateRuleID,NULL as AuthMaxTime,NULL as AuthRate,NULL as AuthRateTime
From Emerald..Rates 
SET IDENTITY_INSERT Rates OFF
GO

INSERT INTO RateItems (RateID,RateRuleID,RateTimeGroupID)
SELECT r.RateID,r.RateID + 100, rtg.RateTimeGroupID
FROM Emerald..Rates r, RateTimeGroups rtg
	WHERE rtg.RateTimeGroup = 'Complete Year'
	AND r.DefaultType = 0
GO

/*  Operator Groups */
SET IDENTITY_INSERT OperatorGroups ON
Insert Into OperatorGroups(OperatorGroupID,OperatorGroup,Description,InternalUse) 
	Select OperatorGroupID,OperatorGroup,Description,0 as InternalUse
	From Emerald..OperatorGroups WHERE OperatorGroup NOT IN ('CustomerAccess','CustomerSignup')
SET IDENTITY_INSERT OperatorGroups OFF
GO

SET IDENTITY_INSERT Operators ON
Insert Into Operators(OperatorID,PrintTypeID,OperatorGroupID,Operator,Password,Email,WebObjectAccess,LanguageID,
		Active,DateFormatID,DateSeperator,ThemeID,CountryID) 
	Select OperatorID,CASE WHEN PrintTypeID NOT IN (1,2,4,8) THEN 2 ELSE PrintTypeID END,OperatorGroupID,Operator,Password,Email,WebObjectAccess,NULL AS LanguageID,
		Active,DateFormatID,DateSeperator,NULL As ThemeID,840 AS CountryID
	From Emerald..Operators 
SET IDENTITY_INSERT Operators OFF
GO

INSERT INTO OperatorGroups (OperatorGroup,Description,InternalUse) 
	VALUES('CustomerSignup','Customer Signup Server',0)

INSERT INTO OperatorGroupAccess (AccessType,OperatorGroupID,GroupID,ObjectGroupID) 
	VALUES(15,@@IDENTITY,1,300)
GO

INSERT INTO OperatorGroups (OperatorGroup,Description,InternalUse) 
	VALUES('CustomerAccess','Customer Account Center',0)

INSERT INTO OperatorGroupAccess (AccessType,OperatorGroupID,GroupID,ObjectGroupID) 
	VALUES(15,@@IDENTITY,1,200)
GO

/*  OperatorGroupAccess */
Insert Into OperatorGroupAccess(ObjectGroupID,OperatorGroupID,GroupID,AccessType) 
	Select ObjectGroupID,OperatorGroupID,GroupID,AccessType
	From Emerald..OperatorGroupAccess 
	Where ObjectGroupID IN (Select ObjectGroupID From ObjectGroups)
GO

-- Give Operators with MBR Acct access MBR Acct Admin (new) access
Insert Into OperatorGroupAccess(ObjectGroupID,OperatorGroupID,GroupID,AccessType) 
	Select 112,OperatorGroupID,GroupID,AccessType
	From Emerald..OperatorGroupAccess WHERE ObjectGroupID = 111
GO

/*  ExternalSystems  */
SET IDENTITY_INSERT ExternalSystems ON
Insert Into ExternalSystems(ExternalSystemID,Name,ExternalSystemTypeID,ExportID,Description,MailHost,Login,Password,LogFile,LastSyncDate,FileMode)
	Select ExternalSystemID,Name,CASE WHEN ExternalSystemType IN (Select ExternalSystemTypeID From ExternalSystemTypes) THEN ExternalSystemType ELSE 10 END as ExternalSystemTypeID,
		CASE WHEN ExportID IN (Select ExportID From Exports) then ExportID ELSE 100 END AS ExportID,
		Description,MailHost,Login,Password,LogFile,LastSyncDate,FileMode
	From Emerald..ExternalSystems 
SET IDENTITY_INSERT ExternalSystems OFF
GO

/*  PayPeriods  */
SET IDENTITY_INSERT PayPeriods ON
Insert Into PayPeriods(PayPeriodID,AccountTypeID,PayPeriod,StringID,PeriodTypeID,Period,Amount,AmountType,
		SetupCharge,GroupID,ServiceGroupID,SortOrder,ConfirmTrans) 
	Select PayPeriodID,NULL,PayPeriod,NULL as StringID,1 as PeriodTypeID,Period,
		CASE WHEN AmountType = 0 THEN (100-Amount) ELSE Amount END AS Amount,AmountType,
		SetupCharge,GroupID,NULL as ServiceGroupID,SortOrder,ConfirmTrans
	From Emerald..PayPeriods 
SET IDENTITY_INSERT PayPeriods OFF
GO

/*  AccountTypes */
SET IDENTITY_INSERT AccountTypes ON
Insert Into AccountTypes(AccountTypeID,AccountType,Cost,Description,StringID,ApplyDiscount,TaxGroupID,TaxExemptions,
		RateClassID,ChargeTypeID,GroupID,ServiceGroupID,DNISGroupID,SortOrder,OverDue,GLCodeID,LoginLimit,TimeLeft,HomeDirSize,
		SendBill,RemoteAccess,PayPeriodID,RadFailAccountTypeID,RadFailReason,StartDate,EndDate,
		NextID,NextCount,RequireUserPass,ChangeOpen,ChangeTo,ChangeClose,ChangeFrom)
Select AccountTypeID,AccountType,Cost,Description,NULL as StringID,ApplyDiscount,TaxID as TaxGroupID,0 as TaxExemptions,
		RateID as RateClassID,ChargeTypeID,CASE WHEN GroupID=1 THEN NULL ELSE GroupID END,NULL as ServiceGroupID,DNISGroupID,SortOrder,OverDue,GLCodeID,LoginLimit,TimeLeft,HomeDirSize,
		SendBill,CASE WHEN SendBill = 1 AND RemoteAccess = 1 THEN 2 ELSE RemoteAccess END,PayPeriodID,RadFailAccountTypeID,RadFailReason,NULL as StartDate,NULL as EndDate,
		NULL as NextID,NULL as NextCount,1 as RequireUserPass,1 as ChangeOpen,1 as ChangeTo,1 as ChangeClose,1 as ChangeFrom
FROM Emerald..AccountTypes
SET IDENTITY_INSERT AccountTypes OFF
GO

INSERT INTO ExternalSystemAccountTypes(AccountTypeID,ExternalSystemID)
SELECT AccountTypeID,ExternalSystemID
FROM Emerald..AccountTypes 
	WHERE ExternalSystemID IS NOT NULL
GO

/* PayPeriods */
UPDATE PayPeriods SET AccountTypeID = opp.AccountTypeID
FROM PayPeriods npp, Emerald..PayPeriods opp, AccountTypes at1
	WHERE opp.PayPeriodID = npp.PayPeriodID
	AND opp.AccountTypeID IS NOT NULL
	AND opp.AccountTypeID = at1.AccountTypeID
GO

/*  Billing Cycles  */
SET IDENTITY_INSERT BillingCycles ON
Insert Into BillingCycles(BillingCycleID,Description,StringID,CycleType,AutoBill,BillDay,IBillDays,EBillDays,RenewDays,
		RenewPeriods,GroupID,ServiceGroupID,LateFeeID,SortOrder) 
	Select BillingCycleID,Description,NULL as StringID,CycleType,AutoBill,BillDay,IBillDays,EBillDays,0 as RenewDays,
		0 as RenewPeriods,CASE WHEN GroupID=1 THEN NULL ELSE GroupID END,NULL as ServiceGroupID,NULL as LateFeeID,SortOrder
	From Emerald..BillingCycles
SET IDENTITY_INSERT BillingCycles OFF
GO

/*  ReferredBys  */
Insert Into ReferredBys(ReferredBy,StringID,GroupID,SortOrder)
	 Select ReferredBy,NULL as StringID,NULL AS GroupID,SortOrder
	 From Emerald..ReferredBys
GO

IF NOT EXISTS (Select ReferredByID From ReferredBys Where ReferredBy = 'Other')
	INSERT INTO ReferredBys(ReferredBy,StringID,GroupID,SortOrder)
		VALUES('Other', NULL, NULL, 99)
GO

/* Commissions */
SET IDENTITY_INSERT CommissionGroups ON
INSERT INTO CommissionGroups (CommissionGroupID,CommissionGroup,CommissionType,SortOrder,Active) VALUES(1,'Default',1,0,1)
SET IDENTITY_INSERT CommissionGroups OFF
GO

INSERT INTO CommissionItems (CommissionGroupID,AccountTypeID,CommissionValue,Comments)
SELECT 1,AccountTypeID,CommissionValue,NULL
FROM Emerald..AccountTypes WHERE CommissionValue IS NOT NULL
GO

/*  SalesPersons  */
SET IDENTITY_INSERT SalesPersons ON
Insert Into SalesPersons(SalesPersonID,SalesPerson,SortOrder,Active,CommissionValue,
		OperatorID,GroupID,ServiceGroupID,CommissionGroupID)
	Select SalesPersonID,SalesPerson,SortOrder,Active,CommissionValue,
		NULL as OperatorID, NULL as GroupID,NULL AS ServiceGroupID,CASE WHEN CommissionValue IS NOT NULL THEN 1 ELSE NULL END AS CommissionGroupID
	From Emerald..SalesPersons
SET IDENTITY_INSERT SalesPersons OFF
GO

/*  Regions  */
SET IDENTITY_INSERT Regions ON
Insert Into Regions(RegionID,Region,GroupID,ServiceGroupID,SortOrder)
	 Select RegionID,Region,CASE WHEN GroupID=1 THEN NULL ELSE GroupID END,NULL as ServiceGroupID,SortOrder
	 From Emerald..Regions
SET IDENTITY_INSERT Regions OFF
GO

SET IDENTITY_INSERT CancelReasons ON
INSERT INTO CancelReasons (CancelReasonID,CancelReason,StringID,Returning,SortOrder)
	Select CancelReasonID,CancelDescription,NULL AS StringID,0 AS Returning,SortOrder
	From Emerald..CancelReasons
SET IDENTITY_INSERT CancelReasons OFF
GO

/*  MasterAccounts  */
SET IDENTITY_INSERT MasterAccounts ON
DECLARE @rbid int
Select @rbid = ReferredByID From ReferredBys Where ReferredBy = 'Other'

Insert Into MasterAccounts(CustomerID,LastStatementID,FirstName,MiddleName,LastName,Company,CountryID,StateID,Address1,Address2,City,
		Zip,PhoneHome,PhoneWork,Gender,BirthDate,Salutation,PhoneFax,Email,TaxExemptions,RegionID,ReferredByID,
		SalesPersonID,CreateDate,StartDate,Active,LanguageID,PayPeriodID,PaymentTypeID,LastReceived,LastLateFee,
		Comments,Status,GroupID,OverDue,SendMethodID,OverLimit,BillingCycleID,BillDay,CancelDate,CancelReasonID,
		Balance,Over30Count,Over60Count,Over90Count,Over120Count,MaxAgedDays,AgedDate,PendingBalance,NoticeDate,
		PayInfo,Operator,LastModifyDate,LastModifyUser) 

	 Select CustomerID,NULL,FirstName,MiddleName,LastName,Company,NULL AS CountryID,NULL AS StateID,Address1,Address2,City,
		Zip,PhoneHome,PhoneWork,Gender,NULL AS BirthDate,Salutation,PhoneFax,NULL AS Email,CASE WHEN Taxable = 1 THEN 0 ELSE 1 END AS TaxExemptions,RegionID,
		COALESCE(ReferredByID,@rbid) as ReferredByID, SalesPersonID,CreateDate,StartDate,Active,NULL AS LanguageID,PayPeriodID,
		CASE PayMethodID WHEN 2 THEN 8 WHEN 3 THEN 16 WHEN 4 THEN 64 WHEN 5 THEN 64 ELSE 1 END as PaymentTypeID,
		LastReceived,NULL as LastLateFee,
		Comments,Status,ma.GroupID,OverDue,CASE WHEN SendMethodID = 0 THEN 10 WHEN SendMethodID NOT IN (0,1,2,3,12) THEN 3 ELSE SendMethodID END,COALESCE(OverLimit,0) as OverLimit,BillingCycleID,BillDay,CancelDate,CancelReasonID,
		Balance,Over30Count,Over60Count,Over90Count,Over120Count,0 as MaxAgedDays,AgedDate,0 as PendingBalance,NoticeDate,
		PayInfo,Operator,LastModifyDate,LastModifyUser
	From Emerald..MasterAccounts ma Left Join ReferredBys rb on ma.ReferredBy = rb.ReferredBy
SET IDENTITY_INSERT MasterAccounts OFF
GO

IF ((SELECT COUNT(*) FROM Emerald..MasterAccounts) <> (SELECT COUNT(*) FROM MasterAccounts))
	RAISERROR('Not all MBR records have been converted',11,1)
GO

IF ((SELECT COUNT(*) FROM Emerald..MasterAccounts WHERE State LIKE '%[a-z]%' AND State NOT IN (SELECT State FROM States) AND State NOT IN (SELECT Abbreviation FROM States WHERE Abbreviation IS NOT NULL)) > 0)
BEGIN
INSERT INTO Countries (CountryID,Country,ContinentID,SortOrder) VALUES(0,'Unknown Country',4,1000)

INSERT INTO States (CountryID,State,SortOrder)
SELECT DISTINCT 0,State,1000
FROM Emerald..MasterAccounts
	WHERE State NOT IN (SELECT State FROM States)
	AND State NOT IN (SELECT Abbreviation FROM States WHERE Abbreviation IS NOT NULL)
END

Update MasterAccounts SET StateID = s.StateID, CountryID = s.CountryID
From MasterAccounts ma, Emerald..MasterAccounts ma2, States s
Where ma.CustomerID = ma2.CustomerID
	and (ma2.State = s.State or ma2.State = s.Abbreviation)
	and ma.StateID IS NULL
GO

/* CreditCards */
INSERT INTO CreditCards (CustomerID,CardHolder,CardNumber,ExpirationDate,BillToAddress1,BillToAddress2,BillToCity,
		BillToZip,BillToCountryID,BillToStateID,SecurityCode,Bank,BankPhone,Misc1,Misc2,LastModifyUser,LastModifyDate,CardLength,CardTypeID)
SELECT CustomerID,CardHolder,CardNumber,ExpirationDate,BillToAddress1,BillToAddress2,BillToCity,BillToZip,
		NULL AS BillToCountryID,NULL as BillToStateID,SecurityCode,Bank,BankPhone,NULL AS Misc1, NULL AS Misc2,LastModifyUser,LastModifyDate,LEN(CardNumber),
(SELECT MAX(ctp.CardTypeID) FROM CardTypePrefixes ctp WHERE ctp.Prefix IN (SUBSTRING(cc.CardNumber,1,1),SUBSTRING(cc.CardNumber,1,2),SUBSTRING(cc.CardNumber,1,3),SUBSTRING(cc.CardNumber,1,4)))
FROM Emerald..CreditCards cc
GO

Update CreditCards Set BillToStateID = s.StateID, BillToCountryID = s.CountryID
From CreditCards cc, Emerald..CreditCards cc2, States s
Where cc.CustomerID = cc2.CustomerID
	and (cc2.BillToState = s.State or cc2.BillToState = s.Abbreviation)
	and cc.BillToStateID IS NULL
GO

UPDATE CreditCards SET BillToStateID = ma.StateID, BillToCountryID = ma.CountryID
FROM CreditCards cc, MasterAccounts ma
	WHERE cc.CustomerID = ma.CustomerID
	AND cc.BillToStateID IS NULL
	AND ma.StateID IS NOT NULL
GO

/*  BankTrans  */
Insert Into BankTrans(CustomerID,AuthName,BankName,BankPhone,ABANumber,AccountNumber,TransType,LastModifyDate,LastModifyUser,SSN,DLNumber,DLState,BirthDate) 
	Select CustomerID,AuthName,BankName,NULL AS BankPhone,ABANumber,AccountNumber,TransType,LastModifyDate,LastModifyUser,SSN,DLNumber,DLState,BirthDate
	From Emerald..BankTrans 
GO

/*  Discounts  */
SET IDENTITY_INSERT Discounts ON
Insert Into Discounts(DiscountID,Discount,StringID,Amount,AmountType,GroupID,ServiceGroupID,SortOrder) 
	 Select DiscountID,Discount,NULL AS StringID,CASE WHEN AmountType = 0 THEN (100-Amount) ELSE Amount END AS Amount,AmountType,GroupID,NULL AS ServiceGroupID,SortOrder 
	 From Emerald..Discounts 
SET IDENTITY_INSERT Discounts OFF
GO

INSERT INTO AccountDataTypes(AccountDataTypeID,AccountDataType,DataTypeID,AllowMBR,AllowSA,StringID,SQLQuery)
	Select 10000 + DataTypeID,Description,1,1,0,NULL,NULL
	From Emerald..MasterAccountDataTypes mad 
		WHERE mad.Description NOT IN (SELECT adt.AccountDataType FROM AccountDataTypes adt WHERE adt.AllowMBR = 1)
UNION ALL
	Select 20000 + DataTypeID,Description,1,0,1,NULL,NULL
	From Emerald..SubAccountDataTypes sad
		WHERE sad.Description NOT IN (SELECT adt.AccountDataType FROM AccountDataTypes adt WHERE adt.AllowSA = 1)
GO

INSERT INTO MasterAccountDataTypes(GroupID,AccountDataTypeID,SortOrder)
SELECT mad.GroupID,adt.AccountDataTypeID,COALESCE(MIN(SortOrder),99) AS SortOrder
FROM Emerald..MasterAccountDataTypes mad, AccountDataTypes adt
	WHERE mad.Description = adt.AccountDataType
	AND adt.AllowMBR = 1
GROUP BY mad.GroupID,adt.AccountDataTypeID
GO

INSERT INTO SubAccountDataTypes(AccountTypeID,AccountDataTypeID,SortOrder)
SELECT sad.AccountTypeID,adt.AccountDataTypeID,COALESCE(MIN(SortOrder),99) AS SortOrder
FROM Emerald..SubAccountDataTypes sad, AccountDataTypes adt
	WHERE sad.Description = adt.AccountDataType
	AND adt.AllowSA = 1
	AND sad.ExternalSystemType IS NULL
GROUP BY sad.AccountTypeID,adt.AccountDataTypeID
GO

/*  SubAccounts  */
SET IDENTITY_INSERT SubAccounts ON
Insert Into SubAccounts(AccountID,CustomerID,Login,Email,FirstName,MiddleName,LastName,PhoneHome,PhoneWork,
		DiffCost,AccountTypeID,PayPeriodID,Cost,DiscountID,Comments,Password,MaidenName,CreateDate,StartDate,
		BilledThru,ExpireDate,Extension,Active,SalesPersonID,Operator,LastModifyDate,LastModifyUser,Preferred,
		Status,TimeLeft,SendBill,RemoteAccess,LoginLimit,BillStatus,LastUsed,DomainID,Gender,
		Salutation,LastTimeLeftDate,CycleMonths,PackageID,CancelDate,CancelReasonID,LastInvoiceID) 
	 Select AccountID,CustomerID,Login,Email,FirstName,MiddleName,LastName,PhoneHome,PhoneWork,
		DiffCost,AccountTypeID,PayPeriodID,Cost,DiscountID,Comments,Password,MaidenName,CreateDate,StartDate,
		BilledThru,ExpireDate,Extension,Active,SalesPersonID,Operator,LastModifyDate,LastModifyUser,Preferred,
		Status,TimeLeft,SendBill,CASE WHEN SendBill = 1 AND RemoteAccess = 1 THEN 2 ELSE RemoteAccess END,LoginLimit,NULL AS BillStatus,LastUsed,DomainID,Gender,
		Salutation,LastTimeLeftDate,0 as CycleMonths,NULL AS PackageID,NULL AS CancelDate,NULL AS CancelReasonID,NULL AS LastInvoiceID 
	From Emerald..SubAccounts
SET IDENTITY_INSERT SubAccounts OFF
GO

IF ((SELECT COUNT(*) FROM Emerald..SubAccounts) <> (SELECT COUNT(*) FROM SubAccounts))
	RAISERROR('Not all service records have been converted',11,1)
GO


/*  ModemSpeeds  */
INSERT INTO AccountDataValues(AccountDataTypeID,KeyData,ValueData)
	 Select DISTINCT 21, ModemSpeed, ModemSpeed 
	 From Emerald..ModemSpeeds
GO

INSERT INTO SubAccountData(AccountID,AccountDataTypeID,Data)
SELECT sa.AccountID,21,ms.ModemSpeed
FROM Emerald..ModemSpeeds ms, Emerald..SubAccounts sa
	WHERE ms.ModemSpeedID = sa.ModemSpeedID
GO

/*  NetSoftware  */
INSERT INTO AccountDataValues(AccountDataTypeID,KeyData,ValueData)
	 Select DISTINCT 19, NetSoftware, NetSoftware 
	 From Emerald..NetSoftwares 
GO

INSERT INTO SubAccountData(AccountID,AccountDataTypeID,Data)
SELECT sa.AccountID,19,ns.NetSoftware
FROM Emerald..NetSoftwares ns, Emerald..SubAccounts sa
	WHERE ns.NetSoftwareID = sa.NetSoftwareID
GO

/*  SystemTypes  */
INSERT INTO AccountDataValues(AccountDataTypeID,KeyData,ValueData)
	 Select DISTINCT 20, SystemType, SystemType 
	 From Emerald..SystemTypes
GO

INSERT INTO SubAccountData(AccountID,AccountDataTypeID,Data)
SELECT sa.AccountID,20,st.SystemType
FROM Emerald..SystemTypes st, Emerald..SubAccounts sa
	WHERE st.SystemTypeID = sa.SystemTypeID
GO

/* Home Directory */
INSERT INTO SubAccountData(AccountID,AccountDataTypeID,Data)
SELECT DISTINCT AccountID,2,HomeDir
FROM Emerald..SubAccounts WHERE HomeDir IS NOT NULL
GO

/* SA Custom Data */
INSERT INTO SubAccountData(AccountID,AccountDataTypeID,Data)
SELECT sad.AccountID, adt.AccountDataTypeID, MAX(sad.Data)
FROM Emerald..SubAccountData sad, Emerald..SubAccountDataTypes sadt, AccountDataTypes adt
	WHERE sad.DataTypeID = sadt.DataTypeID
	AND sadt.Description = adt.AccountDataType
	AND adt.AllowSA = 1
GROUP BY sad.AccountID, adt.AccountDataTypeID
GO

/* MBR Custom Data */
INSERT INTO MasterAccountData(CustomerID,AccountDataTypeID,Data)
SELECT mad.CustomerID, adt.AccountDataTypeID, MAX(mad.Data)
FROM Emerald..MasterAccountData mad, Emerald..MasterAccountDataTypes madt, AccountDataTypes adt
	WHERE mad.DataTypeID = madt.DataTypeID
	AND madt.Description = adt.AccountDataType
	AND adt.AllowMBR = 1
GROUP BY mad.CustomerID, adt.AccountDataTypeID
GO

SET IDENTITY_INSERT IncidentStateGroups ON
INSERT INTO IncidentStateGroups(IncidentStateGroupID,IncidentStateGroup)
	VALUES(1,'Default')
SET IDENTITY_INSERT IncidentStateGroups OFF
GO

SET IDENTITY_INSERT IncidentStates ON
INSERT INTO IncidentStates(IncidentStateID,IncidentStateGroupID,StatOpen,StatWait,StatEscalate,StatBlock,StatArchive,IncidentState,Description,SortOrder,Style,Priority)
	Select IncidentStateID,1, CASE WHEN IncidentState LIKE '%closed%' OR IncidentState LIKE '%resolved%' then 0 ELSE 1 END as StatOpen,
		0 as StatWait,0 as StatEscalate,0 as StatBlock,0 as StatArchive,IncidentState,Description,SortOrder,
		NULL as Style,0 as Priority
	From Emerald..IncidentStates
SET IDENTITY_INSERT IncidentStates OFF
GO

/*  Incident Types  */
SET IDENTITY_INSERT IncidentTypes ON
 Insert Into IncidentTypes(IncidentTypeID,IncidentStateGroupID,IncidentType,Description,Email,SortOrder,OverDays,EscalateDays,
		WarnDays,RoleID,CustomerAccess,ShowPriority,ShowEmail,ShowDuration,ShowDueDate,ShowCustomerAccess,ShowSummary,ShowCustDueDate) 
	 Select IncidentTypeID,1 as IncidentStateGroupID,IncidentType,Description,Email,SortOrder,3 as OverDays,3 as EscalateDays,
		3 as WarnDays,NULL as RoleID,0 as CustomerAccess,1 as ShowPriority,1 as ShowEmail,1 as ShowDuration,1 as ShowDueDate,
		1 as ShowCustomerAccess,0 as ShowSummary,0 as ShowCustDueDate
	 From Emerald..IncidentTypes
SET IDENTITY_INSERT IncidentTypes OFF
GO

/*  Incidents  */
SET IDENTITY_INSERT Incidents ON
Insert Into Incidents(IncidentID,AccountID,CreateDate,IncidentTypeID,IncidentStateID,CreateOperatorID,CreateAccountID,
		Summary,Description,CustomerAccess,LastModifyDate,LastModifyUser,Duration,Email,AssignRoleID,AssignOperatorID,
		DueDate,PriorityID) 
	 Select IncidentID,AccountID,CreateDate,IncidentTypeID,IncidentStateID,o.OperatorID as CreateOperatorID,
		NULL AS CreateAccountID,NULL as Summary,Description,0 as CustomerAccess,LastModifyDate,LastModifyUser,
		0 as Duration,Email,NULL as AssignRoleID,o.OperatorID as AssignOperatorID,NULL as DueDate,10 as PriorityID
	 From Emerald..Incidents i LEFT JOIN Operators o ON (i.Operator = o.Operator)
SET IDENTITY_INSERT Incidents OFF
GO

/*  Actions  */
SET IDENTITY_INSERT Actions ON
Insert Into Actions(ActionID,IncidentID,CreateOperatorID,CreateAccountID,CreateDate,Description,LastModifyDate,
		LastModifyUser,CustomerAccess,Duration,IncidentTypeID,IncidentStateID,AssignRoleID,AssignOperatorID) 
	Select ActionID,a.IncidentID,o.OperatorID as CreateOperatorID,NULL AS CreateAccountID,a.CreateDate,a.Description,a.LastModifyDate,
		a.LastModifyUser,0 as CustomerAccess,0 as Duration,IncidentTypeID,IncidentStateID,AssignRoleID,o.OperatorID as AssignOperatorID
	From Emerald..Actions a LEFT JOIN Operators o ON (a.Operator = o.Operator)
		JOIN Incidents i ON (i.IncidentID = a.IncidentID)
SET IDENTITY_INSERT Actions OFF
GO

/*  Aliases  */
Insert Into Aliases(Alias, AccountID, CreateDate, LastModifyDate, LastModifyUser) 
	Select Alias, AccountID, CreateDate, LastModifyDate, LastModifyUser 
	From Emerald..Aliases
GO

/*  Forwards  */
Insert Into Forwards(Forward, AccountID, CreateDate, LastModifyDate, LastModifyUser) 
	Select Forward, AccountID, CreateDate, LastModifyDate, LastModifyUser 
	From Emerald..Forwards

GO

/*  RadTriggers  */
Insert Into RadTriggers(AccountID, TriggerType, FileName, Parameters, Directory) 
	Select AccountID, TriggerType, FileName, Parameters, Directory 
	 From Emerald..RadTriggers
GO

/* Statements */
SET IDENTITY_INSERT Statements ON
Insert Into Statements(StatementID,BatchID,CustomerID,StatementDate,SentDate,DueDate,PrevBal,NewCharges,NewCredits,
	EndBal,End0Bal,End30Bal,End60Bal,End90Bal,End120Bal,PrintDate,EmailDate,PrintBatchID) 
Select StatementID,NULL as BatchID,CustomerID,StatementDate,SentDate,NULL as DueDate,PrevBal,NewCharges,NewCredits,
	EndBal,End0Bal,End30Bal,End60Bal,End90Bal,End120Bal,SentDate as PrintDate,SentDate as EmailDate, 
	NULL AS PrintBatchID
From Emerald..Statements s
SET IDENTITY_INSERT Statements OFF
GO

-- Set MBR LastStatement
UPDATE MasterAccounts SET LastStatementID = ma2.LastStatementID
FROM MasterAccounts ma, Emerald..MasterAccounts ma2
WHERE ma.CustomerID = ma2.CustomerID
	AND ma2.LastStatementID IS NOT NULL
GO

/*  Invoices  */
SET IDENTITY_INSERT Invoices ON
Insert Into Invoices(InvoiceID,BatchID,CustomerID,InvoiceTypeID,Amount,ChargeAmount,PaidAmount,CreateDate,
	LastModifyDate,LastModifyUser,SentDate,Tax,StatementID,VoidDate,VoidStatementID,PO,Comments,PrintDate,
	EmailDate,PrintBatchID,Estimate,Processed) 
Select InvoiceID,NULL AS BatchID,CustomerID,
	CASE InvoiceTypeID WHEN 0 THEN 1 ELSE InvoiceTypeID END AS InvoiceTypeID,Amount,0 AS ChargeAmount,
	0 AS PaidAmount,CreateDate,
	LastModifyDate,LastModifyUser,SentDate,Tax,StatementID,CASE WHEN InvoiceTypeID = 0 THEN LastModifyDate ELSE NULL END AS VoidDate,
	CASE WHEN InvoiceTypeID = 0 THEN i.StatementID ELSE NULL END AS VoidStatementID, NULL As PO,Comments,SentDate as PrintDate,
	SentDate as EmailDate,NULL as PrintBatchID,0 as Estimate, 1 AS Processed
From Emerald..Invoices i WHERE InvoiceTypeID <> 7
SET IDENTITY_INSERT Invoices OFF
GO

UPDATE Invoices SET VoidDate = ir.CreateDate, VoidStatementID = ir.StatementID
FROM Invoices ni, Emerald..Invoices i, Emerald..Invoices ir
	WHERE ni.InvoiceID = i.InvoiceID
	AND ir.InvoiceTypeID = 7
	AND i.InvoiceTypeID = 0
	AND i.CustomerID = ir.CustomerID
	AND i.Amount = -(ir.Amount)
	AND i.InvoiceID < ir.InvoiceID
	AND i.StatementID IS NOT NULL
	AND ir.StatementID IS NOT NULL
GO

DECLARE @Amount NUMERIC(18,4), @CustomerID INT, @MaxInvoiceID INT, @CreateDate DATETIME
DECLARE inv_cursor CURSOR LOCAL STATIC READ_ONLY FOR 
SELECT -(Amount), CustomerID, CreateDate
FROM Emerald..Invoices
	WHERE InvoiceTypeID = 7
	AND StatementID IS NULL

OPEN inv_cursor
FETCH NEXT FROM inv_cursor INTO @Amount, @CustomerID, @CreateDate
WHILE(@@fetch_status <> -1)
BEGIN

SELECT @MaxInvoiceID = MAX(i.InvoiceID)
FROM Invoices i, Emerald..Invoices i4
	WHERE i.InvoiceID = i4.InvoiceID
	AND i4.InvoiceTypeID = 0
	AND i.CustomerID = @CustomerID
	AND i.Amount = @Amount
	AND i.VoidStatementID IS NOT NULL

UPDATE Invoices SET VoidDate = @CreateDate, VoidStatementID = NULL WHERE InvoiceID = @MaxInvoiceID

FETCH NEXT FROM inv_cursor INTO @Amount, @CustomerID, @CreateDate
END

CLOSE inv_cursor
DEALLOCATE inv_cursor
GO

/*  Payments  */
SET IDENTITY_INSERT Payments ON
Insert Into Payments(PaymentID,CustomerID,Amount,CreateDate,BatchID,PaymentTypeID,CheckNumber,PayInfo,ProcTransID,
	DistFlag,Confirmed,StatementID,FinalAmount,FinalStatementID,FinalCreateDate,LastModifyDate,LastModifyUser,GLState)
Select PaymentID,CustomerID,CASE WHEN Amount < 0 THEN -(Amount) ELSE Amount END,CreateDate,NULL AS BatchID,
	CASE PaymentTypeID  WHEN 1 THEN 2 WHEN 2 THEN 4 WHEN 3 THEN 8 WHEN 4 THEN 16 ELSE 64 END as PaymentTypeID,
	CheckNumber,PayInfo,NULL AS ProcTransID,
	1 AS DistFlag,NULL as Confirmed,StatementID,CASE WHEN Amount < 0 THEN 0 ELSE NULL END AS FinalAmount,CASE WHEN Amount < 0 THEN StatementID ELSE NULL END AS FinalStatementID,CASE WHEN Amount < 0 THEN LastModifyDate ELSE NULL END AS FinalCreateDate,
	LastModifyDate,LastModifyUser,GLState
From Emerald..Payments p
SET IDENTITY_INSERT Payments OFF
GO

/*  InvoiceItems  */
SET IDENTITY_INSERT InvoiceItems ON
INSERT INTO InvoiceItems(ItemID,InvoiceID,ItemType,Login,Days,Description,StartDate,EndDate,AccountID,PackageID,
	Amount,Quantity,TaxID,TaxGroupID,PaidAmount,AccountTypeID,ChargeID,ChargeTypeID,PackageTypeID,
	GLState,Canceled,CycleMonths,BillStatus) 
Select ii.ItemID,ii.InvoiceID,CASE WHEN ii.ItemType = 255 THEN 254 ELSE ii.ItemType END AS ItemType,ii.Login,0 as Days,
	ii.Description,ii.StartDate,ii.EndDate,ii.AccountID,NULL as PackageID,
	ii.Amount,ii.Quantity, CASE ii.ItemType WHEN 254 THEN ii.TaxID WHEN 255 THEN ii.TaxID ELSE NULL END as TaxID, ii.TaxID AS TaxGroupID,ii.PaidAmount,ii.AccountTypeID,
	NULL AS ChargeID, ii.ChargeTypeID,NULL as PackageTypeID,ii.GLState,0 as Canceled,NULL as CycleMonths,NULL as BillStatus
FROM Emerald..InvoiceItems ii, Emerald..Invoices i WHERE i.InvoiceID = ii.InvoiceID AND i.InvoiceTypeID <> 7
SET IDENTITY_INSERT InvoiceItems OFF
GO

/*  Charges  */
SET IDENTITY_INSERT Charges ON
Insert Into Charges(ChargeID,CustomerID,Description,StartDate,EndDate,AccountID,PackageID,Login,AccountTypeID,PackageTypeID,DistFlag,
	AllowInterim,Prorated,Amount,Quantity,TaxGroupID,TaxExemptions,ChargeTypeID,ItemID,Operator,LastModifyDate,LastModifyUser) 
Select ChargeID,CustomerID,Description,StartDate,EndDate,
CASE WHEN AccountID NOT IN (SELECT AccountID FROM SubAccounts) THEN NULL ELSE AccountID END,
NULL as PackageID,Login,
CASE WHEN AccountTypeID NOT IN (SELECT AccountTypeID FROM AccountTypes) THEN NULL ELSE AccountTypeID END,
NULL as PackageTypeID,0 as DistFlag,
	1 as AllowInterim,0 as Prorated,Amount,Quantity,TaxID as TaxGroupID,0 as TaxExemptions,ChargeTypeID,ItemID,Operator,LastModifyDate,LastModifyUser 
From Emerald..Charges 
SET IDENTITY_INSERT Charges OFF
GO

/* AddressTypes */
SET IDENTITY_INSERT AddressTypes ON
Insert Into AddressTypes(AddressTypeID,AddressType,SortOrder,RequiredFields,ShowFields) 
Select AddressTypeID,AddressType,SortOrder,NULL as RequiredFields,65535 as ShowFields
From Emerald..AddressTypes 
SET IDENTITY_INSERT AddressTypes OFF
GO

/* Addresses */
SET IDENTITY_INSERT Addresses ON
Insert Into Addresses(AddressID,CustomerID,AddressTypeID,CountryID,StateID,Company,Address1,Address2,City,Zip,
	Province,FirstName,LastName,Phone,Fax,Email,WWW,Comments) 
Select AddressID,CustomerID,AddressTypeID,NULL as CountryID,NULL as StateID,NULL as Company,Address1,Address2,City,Zip,
	Province,FirstName,LastName,Phone,NULL as Fax,NULL as Email,NULL as WWW,NULL as Comments
From Emerald..Addresses 
SET IDENTITY_INSERT Addresses OFF
GO

UPDATE Addresses SET StateID = s.StateID, CountryID = s.CountryID
FROM Addresses a, Emerald..Addresses a2, States s
Where a.AddressID = a2.AddressID
	and (a2.State = s.State or a2.State = s.Abbreviation)
	and a.StateID IS NULL
GO

/*  RateHistory  */
INSERT INTO RateHistory(StartDate,AccountID,CustomerID,RateRuleID,RateID,TotalTime,ChargeID,TotalCount,TotalData,TotalCost) 
SELECT rh.StartDate,rh.AccountID,sa.CustomerID,RateID+100 AS RateRuleID,RateID AS RateID,MAX(TotalTime) AS TotalTime,MAX(rh.ChargeID) AS ChargeID,MAX(TotalCount) AS TotalCount,MAX(TotalData) AS TotalData,MAX(c.Amount) AS TotalCost
FROM Emerald..RateHistory rh, SubAccounts sa, Charges c
	WHERE rh.AccountID = sa.AccountID
	AND rh.ChargeID = c.ChargeID
	AND rh.RateID IS NOT NULL
GROUP BY rh.StartDate, rh.AccountID,sa.CustomerID,rh.RateID
GO

/* BatchProcessors */
-- First CC
DECLARE @ccid int
Select @ccid = CASE WHEN [Value] IS NULL OR Value = 0 THEN 37 ELSE [Value] END FROM Emerald..Configs Where ConfigID = 74

IF @ccid > 0 
	BEGIN
	if not exists (Select ExportID From Exports Where ExportID = @ccid)
		BEGIN
		Select @ccid = 99 -- Generic CC
		END

	SET IDENTITY_INSERT BatchProcessors ON
	INSERT INTO BatchProcessors(BatchProcessorID,OrganizationID,GroupID,ExportID,BatchProcessor,BatchIn,BatchOut,
			BatchLimit,Merchant,Store,Terminal,ImportOptions,ExportOptions,RebatchTries,RebatchInterval,ProcessorURL,
			Login,Password,CardTypes,SortOrder)
	Select 1,1 as OrganizationID,NULL as GroupID,@ccid as ExportID,'EmeraldV4 Default CC' as BatchProcessor,
			(SELECT Data From Emerald..Configs Where ConfigID = 71) as BatchIn,
			(SELECT Data From Emerald..Configs Where ConfigID = 70) as BatchOut,
			(SELECT [Value] From Emerald..Configs Where ConfigID = 72) as BatchLimit,
			(SELECT Data From Emerald..Configs Where ConfigID = 75) as Merchant,
			(SELECT Data From Emerald..Configs Where ConfigID = 76) as Store,
			(SELECT Data From Emerald..Configs Where ConfigID = 77) as Terminal,
			NULL as ImportOptions,NULL as ExportOptions,
			(SELECT [Value] From Emerald..Configs Where ConfigID = 93) as RebatchTries,
			(SELECT [Value] From Emerald..Configs Where ConfigID = 94) as RebatchInterval,
			(SELECT Data From Emerald..Configs Where ConfigID = 79) as ProcessorURL,
			(SELECT Data From Emerald..Configs Where ConfigID = 400) as Login,
			(SELECT Data From Emerald..Configs Where ConfigID = 401) as Password,
			47 as CardTypes,1 as SortOrder
	SET IDENTITY_INSERT BatchProcessors OFF
	END
GO

-- Next ACH
DECLARE @achid int
SELECT @achid = CASE WHEN [Value] IS NULL OR Value = 0 THEN 204 ELSE [Value] END FROM Emerald..Configs Where ConfigID = 84
IF @achid > 0 
	BEGIN
	if not exists (Select ExportID From Exports Where ExportID = @achid)
		BEGIN
		Select @achid = 299 -- Generic ACH
		END

	SET IDENTITY_INSERT BatchProcessors ON
	INSERT INTO BatchProcessors(BatchProcessorID,OrganizationID,GroupID,ExportID,BatchProcessor,BatchIn,BatchOut,
			BatchLimit,Merchant,Store,Terminal,ImportOptions,ExportOptions,RebatchTries,RebatchInterval,ProcessorURL,
			Login,Password,CardTypes,SortOrder)
	Select 2,1 as OrganizationID,NULL as GroupID,@achid as ExportID,'EmeraldV4 Default ACH' as BatchProcessor,
			(SELECT Data From Emerald..Configs Where ConfigID = 81) as BatchIn,
			(SELECT Data From Emerald..Configs Where ConfigID = 80) as BatchOut,
			(SELECT [Value] From Emerald..Configs Where ConfigID = 82) as BatchLimit,
			NULL as Merchant, NULL as Store, NULL as Terminal, NULL as ImportOptions,NULL as ExportOptions,
			0 as RebatchTries, 0 as RebatchInterval,
			(SELECT Data From Emerald..Configs Where ConfigID = 99) as ProcessorURL,
			(SELECT Data From Emerald..Configs Where ConfigID = 410) as Login,
			(SELECT Data From Emerald..Configs Where ConfigID = 411) as Password,
			0 as CardTypes,1 as SortOrder
	SET IDENTITY_INSERT BatchProcessors OFF
	END
GO

/*  ExternalTrans  */
SET IDENTITY_INSERT ExternalTrans ON
Insert Into ExternalTrans(ExternalTransID,BatchID,BatchOutID,BatchInID,CustomerID,InvoiceID,BatchProcessorID,TransStateID,
	TransTypeID,ReqDate,ExportDate,ProcDate,Amount,PaymentID,ApproveCode,Response,LastModifyDate,LastModifyUser,
	AccountNumber,AccountExpire,AuthName,AuthAddress,AuthZip,AuthSecurityCode,ProcTransID,BankName,BankNumber,
	BankPhone,BankTransType,RebatchTries,LastRebatchTry,SSN,DLNumber,DLState,BirthDate,StatementID) 
Select ExternalTransID,NULL as BatchID,NULL as BatchOutID,NULL as BatchInID,CustomerID,InvoiceID,
	CASE WHEN TransType > 99 then 2 ELSE 1 END as BatchProcessorID,
	CASE WHEN TransType > 99 Then TransType-100 ELSE TransType END as TransStateID,
	64 as TransTypeID,ReqDate,ReqDate as ExportDate,ProcDate,Amount,PaymentID,ApproveCode,Response,LastModifyDate,LastModifyUser,
	AccountNumber,AccountExpire,AuthName,AuthAddress,AuthZip,AuthSecurityCode,NULL as ProcTransID,BankName,BankNumber,
	NULL As BankPhone,BankTransType,RebatchTries,LastRebatchTry,SSN,DLNumber,DLState,BirthDate,StatementID
From Emerald..ExternalTrans e WHERE CustomerID IN (SELECT CustomerID FROM MasterAccounts)
SET IDENTITY_INSERT ExternalTrans OFF
GO

/*  Configs  */
UPDATE Configs SET NumValue = oc.Value, Data = oc.Data
FROM Configs c, Emerald..Configs oc
	WHERE c.ConfigID = oc.ConfigID
GO

UPDATE Configs SET Data = 'Customer Account Center' WHERE ConfigID = 502 AND Data IS NULL
GO

UPDATE Configs SET NumValue = 0 WHERE ConfigID IN (221,222)
GO

UPDATE Configs SET Data = NULL WHERE ConfigID = 220
GO

/*  RadRoamServers  */
SET IDENTITY_INSERT RadRoamServers ON
Insert Into RadRoamServers(RadRoamServerID,IPAddress,Server,Secret,Timeout,Retries,TreatAsLocal,
	StripDomain,AuthPort,AcctPort,RateTarget,RateMax) 
Select RadRoamServerID,IPAddress,Server,Secret,Timeout,Retries,TreatAsLocal,
	StripDomain,AuthPort,AcctPort,RateTarget,RateMax 
From Emerald..RadRoamServers 
SET IDENTITY_INSERT RadRoamServers OFF
GO

/*  ServerTypes  */
Insert Into ServerTypes(ServerType, Vendor, Model, SNMPType, SNMPUser) 
	Select ServerType, Vendor, Model, SNMPType, SNMPUser  
	From Emerald..ServerTypes WHERE ServerType NOT IN (SELECT ServerType FROM ServerTypes)
GO

/* ServerGroups */
SET IDENTITY_INSERT ServerGroups ON
Insert Into ServerGroups(ServerGroupID,ServerGroup) 
SELECT ServerGroupID,ServerGroup
	From Emerald..ServerGroups 
SET IDENTITY_INSERT ServerGroups OFF
GO

/*  Servers  */
SET IDENTITY_INSERT Servers ON
Insert Into Servers(ServerID,ServerGroupID,Server,ServerType,IPAddress,Location,Ports,Modems,PhoneNumber,
		ContactName,ContactPhone,ContactPage,Comments,DynamicStart,DynamicEnd,Secret,Community,
		RadRoamServerID,CheckAccess,Concurrency,AuthPort,AcctPort,DisconnectPort) 
SELECT ServerID,ServerGroupID,Server,CASE WHEN IPAddress = '127.0.0.1' THEN -1 ELSE ServerType END,IPAddress,Location,Ports,Modems,PhoneNumber,
		ContactName,ContactPhone,ContactPage,Comments,DynamicStart,DynamicEnd,Secret,Community,
		RadRoamServerID,CheckAccess,Concurrency,NULL as AuthPort,NULL as AcctPort,NULL as DisconnectPort
	From Emerald..Servers 
SET IDENTITY_INSERT Servers OFF
GO

/*  ServerPorts  */
Insert Into ServerPorts(NASIdentifier,Port,ServerID,Username,AccountID,AcctSessionID,AcctSessionTime,AcctInputOctets,
	AcctOutputOctets,AcctStatusType,CallDate,FramedAddress,CallerID,ConnectInfo,SNMPUser) 
SELECT NASIdentifier,Port,ServerID,Username,AccountID,AcctSessionID,NULL as AcctSessionTime,NULL as AcctInputOctets,
	NULL as AcctOutputOctets,2 AS AcctStatusType,COALESCE(CallDate,GetDate()),FramedAddress,CallerID,ConnectInfo,SNMPUser
FROM Emerald..ServerPorts sp
GO

/*  ServerAccess  */
Insert Into ServerAccess(ServerID,Port,AccountTypeID,StartTime,StopTime,MaxSessionLength) 
	Select ServerID,Port,AccountTypeID,StartTime,StopTime,MaxSessionLength 
	From Emerald..ServerAccess sa
GO

/*  RadVendors  */
Insert Into RadVendors(RadVendorID,Name,VendorURL,Description,Comments) 
	Select RadVendorID,Name,NULL as VendorURL,NULL as Description,NULL as Comments 
	From Emerald..RadVendors 
	Where RadVendorID NOT IN (Select RadVendorID From RadVendors) 
GO

INSERT INTO RadVendors(RadVendorID,Name)
SELECT DISTINCT RadVendorID, CAST(RadVendorID AS VARCHAR(10)) AS Name
FROM Emerald..RadAttributes 
	WHERE RadVendorID NOT IN (SELECT RadVendorID FROM RadVendors)
GO

/*  RadAttributes  */
Insert Into RadAttributes(RadAttributeID, RadVendorID, Name, RadAttributeType, 
	ReplyType, AliasAttributeID, AliasVendorID) 
Select CASE WHEN RadVendorID > 0 THEN RadVendorType ELSE RadAttributeID END as RadAttributeID, 
	RadVendorID, Name, RadAttributeType, ReplyType, AliasAttributeID, AliasVendorID
From Emerald..RadAttributes ra1 
Where NOT EXISTS (Select RadAttributeID From RadAttributes ra2 
		Where ra2.RadAttributeID = CASE WHEN ra1.RadVendorID > 0 THEN ra1.RadVendorType ELSE ra1.RadAttributeID END 
			and ra2.RadVendorID = ra1.RadVendorID)
GO

/*  RadValues  */
Insert Into RadValues(RadAttributeID, RadVendorID, Value, Name) 
Select CASE WHEN RadVendorID > 0 THEN RadVendorType ELSE RadAttributeID END as RadAttributeID, RadVendorID, Value, Name 
From Emerald..RadValues rv1 
Where NOT EXISTS (Select RadAttributeID From RadValues rv2 
		Where rv2.RadAttributeID = CASE WHEN rv1.RadVendorID > 0 THEN rv1.RadVendorType ELSE rv1.RadAttributeID END
			and rv2.RadVendorID = rv1.RadVendorID
			and rv2.Value = rv1.Value) 
GO

/*  RadRoamDomains  */
SET IDENTITY_INSERT RadRoamDomains ON
Insert Into RadRoamDomains(RadRoamDomainID, RadRoamServerID, Domain, Priority, AccountTypeID) 
Select RadRoamDomainID, RadRoamServerID, Domain, Priority, AccountTypeID 
From Emerald..RadRoamDomains 
SET IDENTITY_INSERT RadRoamDomains OFF
GO

/*  RadConfigs  */
SET IDENTITY_INSERT RadConfigs ON
Insert Into RadConfigs(RadConfigID, AccountID, RadAttributeID, RadVendorID, Data, Value, RadCheck, Tag) 
Select RadConfigID, AccountID, CASE WHEN RadVendorID > 0 THEN RadVendorType ELSE RadAttributeID END as RadAttributeID,
		RadVendorID,  Data, Value, RadCheck, Tag
From Emerald..RadConfigs 
SET IDENTITY_INSERT RadConfigs OFF
GO

/*  RadATConfigs  */
SET IDENTITY_INSERT RadATConfigs ON
Insert Into RadATConfigs(RadATConfigID, AccountTypeID, RadAttributeID, RadVendorID, Data, Value, RadCheck, Tag) 
Select RadATConfigID, AccountTypeID, CASE WHEN RadVendorID > 0 THEN RadVendorType ELSE RadAttributeID END as RadAttributeID,
		RadVendorID,  Data, Value, RadCheck, Tag
From Emerald..RadATConfigs 
SET IDENTITY_INSERT RadATConfigs OFF
GO

/*  RadLogs  */ 
Insert Into RadLogs(RadLogMsgID, LogDate, Username, Data, NASIdentifier, NASPort, CallerID) 
Select RadLogMsgID, LogDate, Username, Data, NASIdentifier, NASPort, CallerID
	From Emerald..RadLogs 
GO

/*  RadRejects  */
SET IDENTITY_INSERT RadRejects ON
Insert Into RadRejects(RadRejectID, RadAttributeID, RadVendorID, Data, Value) 
Select RadRejectID, CASE WHEN RadVendorID > 0 THEN RadVendorType ELSE RadAttributeID END as RadAttributeID, RadVendorID, Data, Value 
From Emerald..RadRejects 
SET IDENTITY_INSERT RadRejects OFF
GO

/*  RadMapAttributes  */
Insert Into RadMapAttributes(MapAttribute,RadMapTypeID,RadAttributeID,RadVendorID) 
Select MapAttribute,MapType,CASE WHEN RadVendorID > 0 THEN RadVendorType ELSE RadAttributeID END as RadAttributeID,RadVendorID
From Emerald..MapAttributes 
GO

/*  RadMapValues  */
Insert Into RadMapValues(MapAttribute,RadMapTypeID,MapValue,RadValue,Description) 
Select MapAttribute,MapType,Value,RadValue,Description
From Emerald..MapValues 
GO

/*  RadConcurrency  */
SET IDENTITY_INSERT RadConcurrency ON
Insert Into RadConcurrency(RadConcurrencyID,GroupID,AccountTypeID,LastSyncDate,ConnectionsMax,Connections,Description) 
Select RadConcurrencyID,GroupID,AccountTypeID,LastSyncDate,ConnectionsMax,Connections,Description
From Emerald..RadConcurrency 
SET IDENTITY_INSERT RadConcurrency OFF
GO

/*  RadFilterGroups  */
SET IDENTITY_INSERT RadFilterGroups ON
Insert Into RadFilterGroups(RadFilterGroupID,RadFilterGroup,RadSourceTypeID,Description,DestRadFilterGroupID,DestData,RadDestTypeID,Active,SortOrder) 
Select RadFilterGroupID,RadFilterGroup,CASE WHEN RadSourceTypeID = 21 THEN 1 ELSE RadSourceTypeID END,Description,DestRadFilterGroupID,DestData,RadDestTypeID,1 as Active,SortOrder
From Emerald..RadFilterGroups 
SET IDENTITY_INSERT RadFilterGroups OFF
GO

/*  RadFilters  */
SET IDENTITY_INSERT RadFilters ON
Insert Into RadFilters(RadFilterID,RadMergeTypeID,RadFilterTypeID,RadVendorID,RadSearchTypeID,RadAttributeID,RadFilterGroupID,Location,Data) 
Select RadFilterID,RadMergeTypeID,RadFilterTypeID,RadVendorID,RadSearchTypeID,RadAttributeID,RadFilterGroupID,NULL as Location,Data
From Emerald..RadFilters 
SET IDENTITY_INSERT RadFilters OFF
GO

/*  RadIPGroups  */
SET IDENTITY_INSERT RadIPGroups ON
Insert Into RadIPGroups(RadIPGroupID,RadIPGroup) 
Select RadIPGroupID,RadIPGroup
From Emerald..RadIPGroups 
SET IDENTITY_INSERT RadIPGroups OFF
GO

/*  RadIPAddresses */
Insert Into RadIPAddresses(NASIdentifier,NASPort,IPAddress,RadIPGroupID,State,LastUsed,LastCallDate) 
Select NASIdentifier,NASPort,IPAddress,RadIPGroupID,State,LastUsed,LastUsed as LastCallDate
From Emerald..RadIPAddresses 
GO

/*  RadIPAccountTypes  */
SET IDENTITY_INSERT RadIPAccountTypes ON
Insert Into RadIPAccountTypes(RadIPAccountTypeID,ServerGroupID,AccountTypeID,RadIPGroupID,Priority) 
Select RadIPAccountTypeID,ServerGroupID,AccountTypeID,RadIPGroupID,Priority
From Emerald..RadIPAccountTypes 
SET IDENTITY_INSERT RadIPAccountTypes OFF
GO

/*  RadProxyAttributeGroups  */
SET IDENTITY_INSERT RadProxyAttributeGroups ON
Insert Into RadProxyAttributeGroups(RadProxyAttributeGroupID,RadRoamServerID,Priority,Description) 
Select RadProxyAttributeGroupID,RadRoamServerID,Priority,Description
From Emerald..RadProxyAttributeGroups 
SET IDENTITY_INSERT RadProxyAttributeGroups OFF
GO

/*  RadProxyAttributes  */
SET IDENTITY_INSERT RadProxyAttributes ON
Insert Into RadProxyAttributes(RadProxyAttributeGroupID,SearchType,String,RadAttributeID,RadVendorID,RadProxyAttributeID) 
Select RadProxyAttributeGroupID,SearchType,String,CASE WHEN RadVendorID > 0 THEN RadVendorType ELSE RadAttributeID END as RadAttributeID,RadVendorID,RadProxyAttributeID
From Emerald..RadProxyAttributes 
SET IDENTITY_INSERT RadProxyAttributes OFF
GO

/*  AllowedHosts  */
SET IDENTITY_INSERT AllowedHosts ON
Insert Into AllowedHosts(AllowedHostID,OperatorGroupID,IPAddress,Description) 
Select AllowedHostID,OperatorGroupID,IPAddress,Description
From Emerald..AllowedHosts 
SET IDENTITY_INSERT AllowedHosts OFF
GO

/*  FileTransfers  */
Insert Into FileTransfers(TransferDate,AccountID,FileName,NumBytes,Direction) 
Select DISTINCT TransferDate,AccountID,FileName,NumBytes,Direction
From Emerald..FileTransfers 
GO

UPDATE FileTransfers SET Processed = eft.Processed
FROM Emerald..FileTransfers eft, FileTransfers ft
	WHERE eft.TransferDate = ft.TransferDate
	AND eft.AccountID = ft.AccountID
	AND eft.FileName = ft.FileName
	AND eft.NumBytes = ft.NumBytes
	AND eft.Direction = ft.Direction
GO

/*  FlowFilterGroups  */
SET IDENTITY_INSERT FlowFilterGroups ON
Insert Into FlowFilterGroups(FlowFilterGroupID,FlowFilterGroup,Description,SortOrder,AccountID,SummaryMode,CacheExpire) 
Select FlowFilterGroupID,FlowFilterGroup,Description,SortOrder,AccountID,SummaryMode,CacheExpire
From Emerald..FlowFilterGroups 
SET IDENTITY_INSERT FlowFilterGroups OFF
GO

/*  FlowFilters  */
SET IDENTITY_INSERT FlowFilters ON
Insert Into FlowFilters(FlowFilterID,FlowFilterGroupID,FilterType,SortOrder,SrcIP,SrcMask,SrcPort,DestIP,DestMask,DestPort,Prot,CacheExpire,SummaryMode) 
Select FlowFilterID,FlowFilterGroupID,FilterType,SortOrder,SrcIP,SrcMask,SrcPort,DestIP,DestMask,DestPort,Prot,CacheExpire,SummaryMode
From Emerald..FlowFilters 
SET IDENTITY_INSERT FlowFilters OFF
GO

/*  Flows  */
Insert Into Flows(FlowDate,SrcIP,DestIP,SrcPort,DestPort,Prot,Packets,Octets,AccountID,FlowFilterID) 
Select FlowDate,SrcIP,DestIP,SrcPort,DestPort,Prot,Packets,Octets,AccountID,FlowFilterID
From Emerald..Flows 
GO

/*  IPClasses  */
Insert Into IPClasses(IPClassID,IPClass,Description,LastModifyDate,LastModifyUser) 
Select IPClassID,IPClass,Description,LastModifyDate,LastModifyUser
From Emerald..IPClasses 
GO

/*  IPS  */
Insert Into IPS(IPID,IP,IPClassID,LastModifyDate,LastModifyUser) 
Select IPID,IP,IPClassID,LastModifyDate,LastModifyUser
From Emerald..IPS 
GO

/*  LDAPServers  */
Insert Into LDAPServers(LDAPServer,LastModifyDate,LastSyncRead,LastSyncWrite,Calls) 
Select LDAPServer,LastModifyDate,LastSyncRead,LastSyncWrite,Calls
From Emerald..LDAPServers 
GO



/*  Logs  */ 
Insert Into Logs(LogMsgID,LogDate,LogMsg,Operator,CustomerID,AccountID,BatchID) 
Select LogMsgID,LogDate,LogMsg,Operator,CustomerID,AccountID,NULL as BatchID
	From Emerald..Logs 
GO

/*  MailLogs  */ 
Insert Into MailLogs(LogDate,LogMsgID,CustomerID,LogDescription) 
Select LogDate,LogMsgID,CustomerID,LogDescription
	From Emerald..MailLogs 
GO

/*  AuditLogs  */ 
Insert Into AuditLogs(LogMsgID,LogDate,LogMsg,Operator,CustomerID,AccountID,PackageID) 
Select LogMsgID,LogDate,LogMsg,Operator,CustomerID,AccountID,NULL as PackageID
	From Emerald..AuditLogs 
GO

/*  SysLogs  */ 
Insert Into SysLogs(LogDate,Severity,Facility,IPAddress,Data) 
Select sl.LogDate,sl.Severity,sl.Facility,'127.0.0.2',sld.Data
FROM Emerald..SysLogs sl, Emerald..SysLogDefs sld
	WHERE sl.DefID = sld.DefID
	AND sl.Version = sld.Version
GO

/*  SysLogFilters  */ 
Insert Into SysLogFilters(IPAddress,Severity,SubString) 
Select IPAddress,Severity,SubString
	From Emerald..SysLogFilters 
GO

If exists (Select id from Emerald..sysobjects so where name = 'NoticeLogs') 
	BEGIN
	/*  NoticeLogs  */ 
	SET IDENTITY_INSERT NoticeLogs ON
	Insert Into NoticeLogs(CreateDate,NoticeLogID,CustomerID,AccountID,NoticeID) 
	Select CreateDate,NoticeLogID,CustomerID,AccountID,NoticeID
		From Emerald..NoticeLogs 
	SET IDENTITY_INSERT NoticeLogs OFF
	END
GO

/*  OnlineSignups  */ 
SET IDENTITY_INSERT OnlineSignups ON
Insert Into OnlineSignups(OnlineSignupID,FirstName,LastName,Address1,Address2,City,State,Province,Zip,Country,ReferredBy,Region,AccountTypeID,Login,Password,MaidenName,NetSoftware,SystemType,ModemSpeed,CallerID,FramedAddress,CallDate,SignUpDate,Status,PaymentOption,CardNumber,CardExpiration,SignUpComment) 
Select OnlineSignupID,FirstName,LastName,Address1,Address2,City,State,Province,Zip,Country,ReferredBy,Region,AccountTypeID,Login,Password,MaidenName,NetSoftware,SystemType,ModemSpeed,CallerID,FramedAddress,CallDate,SignUpDate,Status,PaymentOption,CardNumber,CardExpiration,SignUpComment
	From Emerald..OnlineSignups 
SET IDENTITY_INSERT OnlineSignups OFF
GO

/*  WebLinks  */ 
SET IDENTITY_INSERT WebLinks ON
Insert Into WebLinks(WebLinkID,LinkType,SortOrder,Title,URL) 
Select WebLinkID,LinkType,SortOrder,Title,URL
	From Emerald..WebLinks 
SET IDENTITY_INSERT WebLinks OFF
GO

CREATE TABLE #tmp (CustomerID INT, BillDay INT)

INSERT INTO #tmp (CustomerID,BillDay)
SELECT ma.CustomerID, CASE WHEN DATEPART(mm,MAX(sa.BilledThru)) <> DATEPART(mm,DATEADD(dd,1,MAX(sa.BilledThru))) THEN 1 ELSE DATEPART(dd,MAX(sa.BilledThru)) + 1 END AS BillDay
FROM MasterAccounts ma, SubAccounts sa, BillingCycles bc
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND ma.Active = 1
	AND sa.Active = 1
	AND bc.CycleType IN (0,3)
GROUP BY ma.CustomerID
UNION ALL
SELECT ma.CustomerID, COALESCE(bc.BillDay,1) AS BillDay
FROM MasterAccounts ma, BillingCycles bc
	WHERE ma.BillingCycleID = bc.BillingCycleID
	AND ma.Active = 1
	AND bc.CycleType NOT IN (0,3)

UPDATE MasterAccounts SET BillDay = t.BillDay
FROM MasterAccounts ma, #tmp t
	WHERE ma.CustomerID = t.CustomerID

DROP TABLE #tmp
GO

UPDATE Configs SET Data = 'upgrade_f.ews' WHERE ConfigID = 2
GO

