DROP TABLE tempaging
/
CREATE GLOBAL TEMPORARY TABLE tempaging (CustomerID INTEGER, Age0 NUMERIC(18,4), Age30 NUMERIC(18,4), Age60 NUMERIC(18,4), Age90 NUMERIC(18,4), Age120 NUMERIC(18,4), PendingCharge NUMERIC(18,4), PendingPOS NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE tma
/
CREATE GLOBAL TEMPORARY TABLE tma (CustomerID INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE ti
/
CREATE GLOBAL TEMPORARY TABLE ti (CustomerID INTEGER, NewCharge NUMERIC(18,4), NewCredit NUMERIC(18,4), LastInvoiceID INTEGER, InvoiceCount INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE tp
/
CREATE GLOBAL TEMPORARY TABLE tp (CustomerID INTEGER, Amount NUMERIC(18,4), LastPaymentID INTEGER, PayCount INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE bgstmp
/
CREATE GLOBAL TEMPORARY TABLE bgstmp (GroupID INTEGER, ActiveCount INTEGER, InactiveCount INTEGER, TransCount INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE canaaxe
/
CREATE GLOBAL TEMPORARY TABLE canaaxe (CustomerID INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE caltmp
/
CREATE GLOBAL TEMPORARY TABLE caltmp (PackageID INTEGER, AccountTypeID INTEGER, Cnt INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE cactmp
/
CREATE GLOBAL TEMPORARY TABLE cactmp (PackageID INTEGER, AccountTypeID INTEGER, Cnt INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE diu
/
CREATE GLOBAL TEMPORARY TABLE diu (AccountID INT PRIMARY KEY, ExpireDate DATE, StartDate DATE, EndDate DATE) ON COMMIT PRESERVE ROWS
/

DROP TABLE diup
/
CREATE GLOBAL TEMPORARY TABLE diup (PackageID INT PRIMARY KEY, ExpireDate DATE, StartDate DATE, EndDate DATE) ON COMMIT PRESERVE ROWS
/

DROP TABLE etisum
/
CREATE GLOBAL TEMPORARY TABLE etisum (CustomerID INT PRIMARY KEY, Amount NUMERIC(18,4), BatchProcessorID INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE inatmp
/
CREATE GLOBAL TEMPORARY TABLE inatmp (OperatorRoleID INTEGER, Cnt INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE ictd
/
CREATE GLOBAL TEMPORARY TABLE ictd (SrcIncidentDataTypeID INTEGER, DstIncidentDataTypeID INTEGER, DstData VARCHAR2(255)) ON COMMIT PRESERVE ROWS
/

DROP TABLE iglc
/
CREATE GLOBAL TEMPORARY TABLE iglc (CustomerID INT PRIMARY KEY) ON COMMIT PRESERVE ROWS
/

DROP TABLE ivsau
/
CREATE GLOBAL TEMPORARY TABLE ivsau (PackageID INTEGER, AutoBill INTEGER, ExpireDate DATE, BilledThru DATE, PackageTypeID INTEGER, CycleMonths INTEGER, BillStatus INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE phostmp
/
CREATE GLOBAL TEMPORARY TABLE phostmp (CustomerID INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE psltmp
/
CREATE GLOBAL TEMPORARY TABLE psltmp (AccountTypeID INTEGER, Cnt INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcssync
/
CREATE GLOBAL TEMPORARY TABLE rcssync (RadConcurrencyID INTEGER, Connections INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE rpcctmp
/
CREATE GLOBAL TEMPORARY TABLE rpcctmp (Realm VARCHAR2(64), Username VARCHAR2(64), InBytes NUMBER(38), OutBytes NUMBER(38), SessionTime  INTEGER, SessionCount INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcrctmp2
/
CREATE GLOBAL TEMPORARY TABLE rcrctmp2 (GroupID INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcrctmp
/
CREATE GLOBAL TEMPORARY TABLE rcrctmp (GroupID INTEGER, CustomerID INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcgv
/
CREATE GLOBAL TEMPORARY TABLE rcgv (AccountID INTEGER, MaxCallDate DATE, Cost NUMERIC(18,4), Cnt INTEGER, RateID INTEGER, Interim INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE rnrctmp
/
CREATE GLOBAL TEMPORARY TABLE rnrctmp (AccountID INTEGER, CustomerID INTEGER, RateClassID INTEGER, BillDay SMALLINT, IPAddress VARCHAR2(64), CollectIP VARCHAR2(64)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rnuctmp
/
CREATE GLOBAL TEMPORARY TABLE rnuctmp (AccountID INTEGER, RateClassID INTEGER, BillDay SMALLINT, IPAddress VARCHAR2(64), CollectIP VARCHAR2(64)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rpuctmp
/
CREATE GLOBAL TEMPORARY TABLE rpuctmp (AccountID INTEGER, RateClassID INTEGER, Data VARCHAR2(255)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcsadiff
/
CREATE GLOBAL TEMPORARY TABLE rcsadiff (CustomerID INTEGER, AccountID INTEGER, PackageID INTEGER, SA INTEGER, SAPrev INTEGER, InvoicedAmount NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcmbrdiff
/
CREATE GLOBAL TEMPORARY TABLE rcmbrdiff (CustomerID INTEGER, MBRTotal INTEGER, MBRNew INTEGER, MBRLost INTEGER, SATotal INTEGER, SANew INTEGER, SALost INTEGER, InvoicedAmount NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcdiff
/
CREATE GLOBAL TEMPORARY TABLE rcdiff (StartDate DATE, MBRTotal INTEGER, MBRNew INTEGER, MBRLost INTEGER, SATotal INTEGER, SANew INTEGER, SALost INTEGER, InvoicedAmount NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcatsadiff
/
CREATE GLOBAL TEMPORARY TABLE rcatsadiff (CustomerID INTEGER, AccountID INTEGER, PackageID INTEGER, AccountTypeID INTEGER, PackageTypeID INTEGER, SA INTEGER, SAPrev INTEGER, InvoicedAmount NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcatmbrdiff
/
CREATE GLOBAL TEMPORARY TABLE rcatmbrdiff (CustomerID INTEGER, AccountTypeID INTEGER, PackageTypeID INTEGER, MBRTotal INTEGER, MBRNew INTEGER, MBRLost INTEGER, SATotal INTEGER, SANew INTEGER, SALost INTEGER, InvoicedAmount NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcatdiff
/
CREATE GLOBAL TEMPORARY TABLE rcatdiff (StartDate DATE, AccountTypeID INTEGER, PackageTypeID INTEGER, MBRTotal INTEGER, MBRNew INTEGER, MBRLost INTEGER, SATotal INTEGER, SANew INTEGER, SALost INTEGER, InvoicedAmount NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcatdsadiff
/
CREATE GLOBAL TEMPORARY TABLE rcatdsadiff (CustomerID INTEGER, AccountID INTEGER, PackageID INTEGER, AccountTypeID INTEGER, PackageTypeID INTEGER, SA INTEGER, SAPrev INTEGER, InvoicedAmount NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcatdmbrdiff
/
CREATE GLOBAL TEMPORARY TABLE rcatdmbrdiff (CustomerID INTEGER, AccountTypeID INTEGER, PackageTypeID INTEGER, MBRNew INTEGER, MBRLost INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcatddiff
/
CREATE GLOBAL TEMPORARY TABLE rcatddiff (StartDate DATE, CustomerID INTEGER, AccountID INTEGER, PackageID INTEGER, AccountTypeID INTEGER, PackageTypeID INTEGER, MBRNew INTEGER, MBRLost INTEGER, SANew INTEGER, SALost INTEGER, InvoicedAmount NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcpayp
/
CREATE GLOBAL TEMPORARY TABLE rcpayp (SalesPersonID INTEGER, AccountTypeID INTEGER, PackageTypeID INTEGER, ChargeTypeID INTEGER, PaidAmount NUMERIC(18,4), PaidPoints NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcpaym
/
CREATE GLOBAL TEMPORARY TABLE rcpaym (SalesPersonID INTEGER, AccountTypeID INTEGER, PackageTypeID INTEGER, ChargeTypeID INTEGER, PaidAmount NUMERIC(18,4), PaidPoints NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcinv
/
CREATE GLOBAL TEMPORARY TABLE rcinv (SalesPersonID INTEGER, AccountTypeID INTEGER, PackageTypeID INTEGER, ChargeTypeID INTEGER, ItemCount INTEGER, InvoicedAmount NUMERIC(18,4), InvoicedPoints NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcommtmp
/
CREATE GLOBAL TEMPORARY TABLE rcommtmp (Type INTEGER, SalesPerson VARCHAR2(128), Item VARCHAR2(128), StringID INTEGER, ItemCount INTEGER, InvoicedAmount NUMERIC(18,4), InvoicedPoints NUMERIC(18,4), PaidAmount NUMERIC(18,4), PaidPoints NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcdpayp
/
CREATE GLOBAL TEMPORARY TABLE rcdpayp (SalesPersonID INTEGER, AccountTypeID INTEGER, PackageTypeID INTEGER, ChargeTypeID INTEGER, PaidAmount NUMERIC(18,4), PaidPoints NUMERIC(18,4), CustomerID INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcdpaym
/
CREATE GLOBAL TEMPORARY TABLE rcdpaym (SalesPersonID INTEGER, AccountTypeID INTEGER, PackageTypeID INTEGER, ChargeTypeID INTEGER, PaidAmount NUMERIC(18,4), PaidPoints NUMERIC(18,4), CustomerID INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcdinv
/
CREATE GLOBAL TEMPORARY TABLE rcdinv (SalesPersonID INTEGER, AccountTypeID INTEGER, PackageTypeID INTEGER, ChargeTypeID INTEGER, ItemCount INTEGER, InvoicedAmount NUMERIC(18,4), InvoicedPoints NUMERIC(18,4), CustomerID INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE rcdommtmp
/
CREATE GLOBAL TEMPORARY TABLE rcdommtmp (Type INTEGER, SalesPerson VARCHAR2(128), Item VARCHAR2(128), StringID INTEGER, ItemCount INTEGER, InvoicedAmount NUMERIC(18,4), InvoicedPoints NUMERIC(18,4), PaidAmount NUMERIC(18,4), PaidPoints NUMERIC(18,4), CustomerID INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE fcast
/
CREATE GLOBAL TEMPORARY TABLE fcast (Type INTEGER, Description VARCHAR2(128), StringID INTEGER, Services INTEGER, Cost NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE fcastd
/
CREATE GLOBAL TEMPORARY TABLE fcastd (Day INTEGER, Type INTEGER, Description VARCHAR2(128), StringID INTEGER, Services INTEGER, Cost NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rglpplus
/
CREATE GLOBAL TEMPORARY TABLE rglpplus (Type INTEGER, ID INTEGER, GLCode VARCHAR2(64), Description VARCHAR2(128), Amount NUMERIC(18,4), Cnt INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE rglpminus
/
CREATE GLOBAL TEMPORARY TABLE rglpminus (Type INTEGER, ID INTEGER, GLCode VARCHAR2(64), Description VARCHAR2(128), Amount NUMERIC(18,4), Cnt INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE irglpplus
/
CREATE GLOBAL TEMPORARY TABLE irglpplus (Type INTEGER, ID INTEGER, GLCode VARCHAR2(64), Description VARCHAR2(128), Amount NUMERIC(18,4), Cnt INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE irglpminus
/
CREATE GLOBAL TEMPORARY TABLE irglpminus (Type INTEGER, ID INTEGER, GLCode VARCHAR2(64), Description VARCHAR2(128), Amount NUMERIC(18,4), Cnt INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE defrrptgl
/
CREATE GLOBAL TEMPORARY TABLE defrrptgl (DefRatio NUMBER, InvAmount NUMERIC(18,4), PaidBefore NUMERIC(18,4), PaidAfter NUMERIC(18,4), GLCodeID INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE defrrpt
/
CREATE GLOBAL TEMPORARY TABLE defrrpt (CustomerID INTEGER, InvoiceID INTEGER, Active INTEGER, DefDays INTEGER, DefRatio NUMBER, InvAmount NUMERIC(18,4), PaidBefore NUMERIC(18,4), PaidAfter NUMERIC(18,4), AccountTypeID INTEGER, PackageTypeID INTEGER, AccountID INTEGER, PackageID INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE rtpplus
/
CREATE GLOBAL TEMPORARY TABLE rtpplus (TaxID INTEGER, ItemCount INTEGER, Amount NUMERIC(18,4), InvAmount NUMERIC(18,4), TaxableAmount NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rtpminus
/
CREATE GLOBAL TEMPORARY TABLE rtpminus (TaxID INTEGER, Amount NUMERIC(18,4), InvAmount NUMERIC(18,4), TaxableAmount NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rtpplusta
/
CREATE GLOBAL TEMPORARY TABLE rtpplusta (TaxID INTEGER, ItemCount INTEGER, TaxableAmount NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE rtpminusta
/
CREATE GLOBAL TEMPORARY TABLE rtpminusta (TaxID INTEGER, TaxableAmount NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE sacstmp
/
CREATE GLOBAL TEMPORARY TABLE sacstmp (Calls INTEGER, CallStart DATE, Mins NUMERIC(18,4), InMB NUMERIC(18,4), OutMB NUMERIC(18,4), Username VARCHAR2(64), Server VARCHAR2(64), NASPort VARCHAR2(64), ConnectInfo VARCHAR2(64), CallerID VARCHAR2(64), NASPortDNIS VARCHAR2(64), NASIdentifier VARCHAR2(64), AcctTerminateCause INTEGER, Cost NUMERIC(18,4), State VARCHAR2(64), Country VARCHAR2(64), Location VARCHAR2(64)) ON COMMIT PRESERVE ROWS
/

DROP TABLE sbstmp
/
CREATE GLOBAL TEMPORARY TABLE sbstmp (GroupID INT NULL, Type INT NULL, PrintCount INT NULL, EmailCount INT NULL, PrintAmount NUMERIC(18,4) NULL, EmailAmount NUMERIC(18,4) NULL, AutoSend INT NULL) ON COMMIT PRESERVE ROWS
/

DROP TABLE trimaxelist
/
CREATE GLOBAL TEMPORARY TABLE trimaxelist (CallID NUMBER(38)) ON COMMIT PRESERVE ROWS
/

DROP TABLE utsa
/
CREATE GLOBAL TEMPORARY TABLE utsa (AccountID INTEGER, TimeLeft INTEGER, DataLeft NUMBER(38)) ON COMMIT PRESERVE ROWS
/

DROP TABLE vmuAccountIDs
/
CREATE GLOBAL TEMPORARY TABLE vmuAccountIDs (AccountID INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE rvrtmp
/
CREATE GLOBAL TEMPORARY TABLE rvrtmp (RuleCounter INTEGER, RateVCondGroupID INTEGER, DNIS VARCHAR2(64), Attribute VARCHAR2(64), RateMatchTypeID INTEGER, IntervalCost NUMERIC(18,4), InitialCost NUMERIC(18,4), StaticCost NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

DROP TABLE chkitmp
/
CREATE GLOBAL TEMPORARY TABLE chkitmp (InvoiceID INTEGER, CustomerID INTEGER, Name VARCHAR2(80), CreateDate DATE, InvoiceAmount NUMERIC(18,4), CalcInvoiceAmount NUMERIC(18,4), Condition INTEGER) ON COMMIT PRESERVE ROWS
/

DROP TABLE rad
/
CREATE GLOBAL TEMPORARY TABLE rad (CustomerID INTEGER, Days INTEGER, Amount NUMERIC(18,4)) ON COMMIT PRESERVE ROWS
/

CREATE OR REPLACE PROCEDURE ACHExport (crACHExport1 IN OUT ieatypes.CursorType,BatchProcessorID_ IN INTEGER,CustomerID_ IN INTEGER) AS
BEGIN

IF (CustomerID_ IS NULL) THEN
OPEN crACHExport1 FOR SELECT COALESCE(ma.Email,(SELECT MIN(sa2.Email) FROM SubAccounts sa2 WHERE sa2.Active = 1 AND sa2.SendBill = 1 AND sa2.CustomerID = ma.CustomerID)) AS Email,
DATEPART(mm,et.AccountExpire) AS expmm, DATEPART(yy,et.AccountExpire) AS expyy, et.AccountNumber, et.AuthName AS AccountHolder, 
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,1,CHARINDEX(' ',et.AuthName)-1) ELSE et.AuthName END AS FirstName, 
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,CHARINDEX(' ',et.AuthName)+1,255) ELSE NULL END AS LastName,
COALESCE(et.AuthAddress,ma.Address1) AS Address, ma.City, (SELECT Abbreviation FROM States WHERE StateID=COALESCE(et.AuthStateID,ma.StateID)) AS State2, (SELECT s.State FROM States s WHERE s.StateID=COALESCE(et.AuthStateID,ma.StateID)) AS State, COALESCE(et.AuthZip,ma.Zip) AS Zip, et.AuthSecurityCode AS SecurityCode, 
CASE WHEN et.TransTypeID = 256 THEN (SELECT MAX(et2.ExternalTransID) FROM ExternalTrans et2 WHERE et2.ExternalTransID <> et.ExternalTransID AND et2.ProcTransID = et.ProcTransID AND et2.PaymentID = et.PaymentID) ELSE NULL END AS PrevTransID,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,1,CHARINDEX(':',et.ProcTransID)-1) ELSE NULL END AS ProcTrans1,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,CHARINDEX(':',et.ProcTransID)+1,100) ELSE NULL END AS ProcTrans2,
et.ApproveCode, et.ProcTransID, et.ExternalTransID, et.TransTypeID, et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, bp.Merchant, bp.Store,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(dd,et.ReqDate) AS VARCHAR(2)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(mm,et.ReqDate) AS VARCHAR(2)) AS startmm, 
CASE WHEN MOD(DATEPART(yy,et.ReqDate),100) < 10 THEN '0' ELSE '' END || CAST(MOD(DATEPART(yy,et.ReqDate),100) AS VARCHAR(2)) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(hh,et.ReqDate) AS VARCHAR(2)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(mi,et.ReqDate) AS VARCHAR(2)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(ss,et.ReqDate) AS VARCHAR(2)) AS startss,
et.Amount, et.BankTransType, UPPER(et.BankTransType) AS BankTransTypeUC, CASE WHEN et.BankTransType = 'savings' THEN 'S' ELSE 'C' END AS BankTransTypeFC, et.BankNumber, et.BankName, ma.Company, bp.Login, bp.Password, et.SSN, et.DLNumber, et.DLState, DATEPART(yy,et.BirthDate) AS birthyyyy,
CASE WHEN et.BankTransType = 'businesschecking' THEN 1 ELSE 0 END AS BusinessAccount,
CASE WHEN DATEPART(mm,et.BirthDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(mm,et.BirthDate) AS VARCHAR(2)) AS birthmm, 
CASE WHEN DATEPART(dd,et.BirthDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(dd,et.BirthDate) AS VARCHAR(2)) AS birthdd,
CASE WHEN et.SSN IS NOT NULL THEN 'SS' WHEN et.DLNumber IS NOT NULL THEN 'DL' ELSE '' END AS idtype,
(SELECT c.Country FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS Country,
(SELECT c.Abbr2 FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS Country2,
(SELECT c.Abbr3 FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS Country3,
(SELECT s.CountryID FROM States s WHERE s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS CountryCode,
COALESCE(ma.PhoneHome,ma.PhoneWork) AS Phone, c.Code AS CurrencyCode, bp.ProcessorURL AS baseurl

FROM ExternalTrans et, MasterAccounts ma, Groups g, BatchProcessors bp, Organizations o, Currencies c
	WHERE ma.CustomerID = et.CustomerID
	AND g.GroupID = ma.GroupID
	AND g.OrganizationID = o.OrganizationID
	AND o.CurrencyID = c.CurrencyID
	AND et.BatchProcessorID = bp.BatchProcessorID
	AND et.TransStateID = 0
	AND et.AccountNumber IS NOT NULL
	AND ma.Active = 1
	AND bp.BatchProcessorID =BatchProcessorID_;
ELSE
OPEN crACHExport1 FOR SELECT COALESCE(ma.Email,(SELECT MIN(sa2.Email) FROM SubAccounts sa2 WHERE sa2.Active = 1 AND sa2.SendBill = 1 AND sa2.CustomerID = ma.CustomerID)) AS Email,
DATEPART(mm,et.AccountExpire) AS expmm, DATEPART(yy,et.AccountExpire) AS expyy, et.AccountNumber,
et.AuthName AS AccountHolder, SUBSTRING(et.AuthName,1,CHARINDEX(' ',et.AuthName)-1) AS FirstName, SUBSTRING(et.AuthName,CHARINDEX(' ',et.AuthName)+1,100) AS LastName,
COALESCE(et.AuthAddress,ma.Address1) AS Address, ma.City, (SELECT Abbreviation FROM States WHERE StateID=COALESCE(et.AuthStateID,ma.StateID)) AS State2, (SELECT s.State FROM States s WHERE s.StateID=COALESCE(et.AuthStateID,ma.StateID)) AS State, COALESCE(et.AuthZip,ma.Zip) AS Zip, et.AuthSecurityCode AS SecurityCode, 
CASE WHEN et.TransTypeID = 256 THEN (SELECT MAX(et2.ExternalTransID) FROM ExternalTrans et2 WHERE et2.ExternalTransID <> et.ExternalTransID AND et2.ProcTransID = et.ProcTransID AND et2.PaymentID = et.PaymentID) ELSE NULL END AS PrevTransID,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,1,CHARINDEX(':',et.ProcTransID)-1) ELSE NULL END AS ProcTrans1,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,CHARINDEX(':',et.ProcTransID)+1,100) ELSE NULL END AS ProcTrans2,
et.ApproveCode, et.ProcTransID, et.ExternalTransID, et.TransTypeID, et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, bp.Merchant, bp.Store,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(dd,et.ReqDate) AS VARCHAR(2)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(mm,et.ReqDate) AS VARCHAR(2)) AS startmm, 
CASE WHEN MOD(DATEPART(yy,et.ReqDate),100) < 10 THEN '0' ELSE '' END || CAST(MOD(DATEPART(yy,et.ReqDate),100) AS VARCHAR(2)) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(hh,et.ReqDate) AS VARCHAR(2)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(mi,et.ReqDate) AS VARCHAR(2)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(ss,et.ReqDate) AS VARCHAR(2)) AS startss,
et.Amount, et.BankTransType, UPPER(et.BankTransType) AS BankTransTypeUC, CASE WHEN et.BankTransType = 'savings' THEN 'S' ELSE 'C' END AS BankTransTypeFC, et.BankNumber, et.BankName, ma.Company, bp.Login, bp.Password, et.SSN, et.DLNumber, et.DLState, DATEPART(yy,et.BirthDate) AS birthyyyy,
CASE WHEN et.BankTransType = 'businesschecking' THEN 1 ELSE 0 END AS BusinessAccount,
CASE WHEN DATEPART(mm,et.BirthDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(mm,et.BirthDate) AS VARCHAR(2)) AS birthmm, 
CASE WHEN DATEPART(dd,et.BirthDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(dd,et.BirthDate) AS VARCHAR(2)) AS birthdd,
CASE WHEN et.SSN IS NOT NULL THEN 'SS' WHEN et.DLNumber IS NOT NULL THEN 'DL' ELSE '' END AS idtype,
(SELECT c.Country FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS Country,
(SELECT c.Abbr2 FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS Country2,
(SELECT c.Abbr3 FROM Countries c, States s WHERE c.CountryID = s.CountryID AND s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS Country3,
(SELECT s.CountryID FROM States s WHERE s.StateID = COALESCE(et.AuthStateID,ma.StateID)) AS CountryCode,
COALESCE(ma.PhoneHome,ma.PhoneWork) AS Phone, c.Code AS CurrencyCode, bp.ProcessorURL AS baseurl

FROM ExternalTrans et, MasterAccounts ma, Groups g, BatchProcessors bp, Organizations o, Currencies c
	WHERE ma.CustomerID = et.CustomerID
	AND g.GroupID = ma.GroupID
	AND g.OrganizationID = o.OrganizationID
	AND o.CurrencyID = c.CurrencyID
	AND et.BatchProcessorID = bp.BatchProcessorID
	AND et.TransStateID = 0
	AND et.AccountNumber IS NOT NULL
	AND ma.Active = 1
	AND ma.CustomerID =CustomerID_
	AND bp.BatchProcessorID =BatchProcessorID_;
END IF;
END;
/

CREATE OR REPLACE PROCEDURE RBCExport (crRBCExport1 IN OUT ieatypes.CursorType,BatchProcessorID_ IN INTEGER,CustomerID_ IN INTEGER) AS
BEGIN
OPEN crRBCExport1 FOR SELECT 'Oracle Not Supported' AS ErrorMsg
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE AddrSearchZip (crAddrSearchZip1 IN OUT ieatypes.CursorType,CountryID_ IN INTEGER,Zip_ IN VARCHAR2) AS
BEGIN
DECLARE
City_ VARCHAR2(64);
StateID_ INTEGER;
BEGIN

SELECT MIN(lzc.City),MIN(lzc.StateID) INTO City_,StateID_ 

FROM LocZipCodes lzc, States s
	WHERE lzc.StateID = s.StateID
	AND s.CountryID =CountryID_ 
	AND lzc.ZipCode =Zip_;
IF (StateID_ IS NULL) THEN
OPEN crAddrSearchZip1 FOR SELECT City, StateID, COUNT(*) AS Cnt
FROM MasterAccounts
	WHERE CountryID =CountryID_
	AND Zip =Zip_
GROUP BY City, StateID
HAVING COUNT(*) > 2
ORDER BY 3 DESC;
ELSE
OPEN crAddrSearchZip1 FOR SELECT City_ AS City,StateID_ AS StateID
 FROM DUAL;
END IF;

END;
END;
/

CREATE OR REPLACE PROCEDURE Aging (crAging1 IN OUT ieatypes.CursorType,update_ IN INTEGER,operatorgroupid_ IN INTEGER) AS
BEGIN

INSERT INTO tempaging (CustomerID,Age0,Age30,Age60,Age90,Age120,PendingCharge,PendingPOS)
SELECT ma.CustomerID,
SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-30,sysdate) AND sysdate THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END) AS Age0,
SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-60,sysdate) AND DATEADD(dd,-30,sysdate) THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END) AS Age30,
SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-90,sysdate) AND DATEADD(dd,-60,sysdate) THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END) AS Age60,
SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-120,sysdate) AND DATEADD(dd,-90,sysdate) THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END) AS Age90,
SUM(CASE WHEN i.CreateDate < DATEADD(dd,-120,sysdate)THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END) AS Age120,
COALESCE((SELECT SUM(c.Amount) From Charges c WHERE c.CustomerID = ma.CustomerID AND c.ItemID IS NULL),0) AS PendingCharge,
COALESCE((SELECT SUM(i2.Amount) From Invoices i2 WHERE i2.CustomerID = ma.CustomerID AND i2.InvoiceTypeID = 91 AND i2.StatementID IS NULL),0) AS PendingPOS
FROM Invoices i, MasterAccounts ma, InvoiceItems ii
	WHERE ma.CustomerID = i.CustomerID
	AND i.VoidDate IS NULL
	AND i.InvoiceID = ii.InvoiceID
	AND ii.Amount > 0
	AND i.Processed = 1
	AND i.Estimate = 0
	AND ma.Active = 1
	AND i.StatementID IS NOT NULL
GROUP BY ma.CustomerID;
IF (update_ <> 1) THEN
OPEN crAging1 FOR SELECT ma.CustomerID, CASE WHEN ((ma.PendingBalance < 0) OR (a.Age30 = 0 AND a.Age60 = 0 AND a.Age90 = 0 AND a.Age120 = 0)) THEN ma.PendingBalance ELSE a.Age0 + a.PendingCharge END AS Age0, a.Age30, a.Age60, a.Age90, a.Age120, ma.FirstName, ma.LastName, ma.Company, ma.PhoneWork, ma.PhoneHome, ma.Active, ma.GroupID
FROM MasterAccounts ma,tempaging a
	WHERE ma.CustomerID = a.CustomerID
	AND ma.PendingBalance NOT BETWEEN -.0099 AND .0099
	AND (operatorgroupid_ = 1 OR EXISTS (SELECT * FROM OperatorGroupAccess WHERE ObjectGroupID = 101 AND OperatorGroupID =operatorgroupid_ AND (GroupID = ma.GroupID OR GroupID = 1)))
ORDER BY 6 DESC, 5 DESC, 4 DESC, 3 DESC, 2 DESC;
END IF;
DELETE FROM tempaging;
END;
/

CREATE OR REPLACE PROCEDURE BatchGetTrans (crBatchGetTrans1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
IF (CustomerID_ IS NULL) THEN
OPEN crBatchGetTrans1 FOR SELECT et.ExternalTransID AS TransID, et.BatchProcessorID, et.InvoiceID, et.Amount, et.TransTypeID, et.TransStateID, et.CustomerID
FROM ExternalTrans et 
	WHERE TransStateID IN (0,1,2);
ELSE
OPEN crBatchGetTrans1 FOR SELECT et.ExternalTransID AS TransID, et.BatchProcessorID, et.InvoiceID, et.Amount, et.TransTypeID, et.TransStateID, et.CustomerID
FROM ExternalTrans et 
	WHERE CustomerID =CustomerID_
	AND TransStateID IN (0,1,2);
END IF;
END;
/

CREATE OR REPLACE PROCEDURE BatchStatements (crBatchStatements1 IN OUT ieatypes.CursorType,custid_ IN INTEGER,GroupID_ IN INTEGER,operatorgroupid_ IN INTEGER) AS
BEGIN
DECLARE
newinterval_ INTEGER;
tmpcnt_ INTEGER;
newpayments_ INTEGER;
BEGIN
SELECT MAX(NumValue) INTO newinterval_  FROM Configs WHERE ConfigID = 505;
SELECT COALESCE(newinterval_,0) INTO newinterval_ 

 FROM DUAL;
SELECT MAX(NumValue) INTO newpayments_  FROM Configs WHERE ConfigID = 377;

IF (custid_ IS NULL) THEN

IF (GroupID_ IS NULL) THEN
	INSERT INTO tma (CustomerID)
	SELECT i.CustomerID
	FROM Invoices i, MasterAccounts ma
		WHERE i.StatementID IS NULL
		AND i.InvoiceTypeID IN (1,2,3,5,50)
		AND ma.CustomerID = i.CustomerID
		AND ma.Active = 1
	UNION
	SELECT p.CustomerID
	FROM Payments p, MasterAccounts ma
		WHERE p.StatementID IS NULL 
		AND p.Amount > 0
		AND ma.CustomerID = p.CustomerID
		AND ma.Active = 1
	UNION
	SELECT p.CustomerID
	FROM Payments p, MasterAccounts ma
		WHERE p.StatementID IS NOT NULL
		AND p.FinalStatementID IS NULL
		AND p.FinalAmount IS NOT NULL
		AND ma.CustomerID = p.CustomerID
		AND ma.Active = 1
		AND newpayments_ = 1
	UNION
	SELECT  ma.CustomerID
	FROM MasterAccounts ma
		WHERE ma.Balance > 0
		AND NOT EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DateAdd(mm,-1,sysdate))
		AND ma.Active = 1
	UNION
	SELECT ma.CustomerID
	FROM MasterAccounts ma
		WHERE Balance <= 0 AND EXISTS (SELECT * FROM Invoices i WHERE i.Estimate = 0 AND i.Processed = 1 AND i.StatementID IS NULL AND i.VoidDate IS NULL AND i.CustomerID = ma.CustomerID)
		AND NOT EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DateAdd(mm,-1,sysdate))
		AND ma.Active = 1;
ELSE
	INSERT INTO tma (CustomerID)
	SELECT i.CustomerID
	FROM Invoices i, MasterAccounts ma
		WHERE i.StatementID IS NULL
		AND i.InvoiceTypeID IN (1,2,3,5,50)
		AND ma.CustomerID = i.CustomerID
		AND ma.Active = 1
		AND ma.GroupID =GroupID_
	UNION
	SELECT p.CustomerID
	FROM Payments p, MasterAccounts ma
		WHERE p.StatementID IS NULL 
		AND p.Amount > 0
		AND ma.CustomerID = p.CustomerID
		AND ma.Active = 1
		AND ma.GroupID =GroupID_
	UNION
	SELECT p.CustomerID
	FROM Payments p, MasterAccounts ma
		WHERE p.StatementID IS NOT NULL
		AND p.FinalStatementID IS NULL
		AND p.FinalAmount IS NOT NULL
		AND ma.CustomerID = p.CustomerID
		AND ma.Active = 1
		AND ma.GroupID =GroupID_
		AND newpayments_ = 1
	UNION
	SELECT  ma.CustomerID
	FROM MasterAccounts ma
		WHERE ma.Balance > 0
		AND NOT EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DateAdd(mm,-1,sysdate))
		AND ma.Active = 1
		AND ma.GroupID =GroupID_
	UNION
	SELECT ma.CustomerID
	FROM MasterAccounts ma
		WHERE Balance <= 0 AND EXISTS (SELECT * FROM Invoices i WHERE i.Estimate = 0 AND i.Processed = 1 AND i.StatementID IS NULL AND i.VoidDate IS NULL AND i.CustomerID = ma.CustomerID)
		AND NOT EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DateAdd(mm,-1,sysdate))
		AND ma.Active = 1
		AND ma.GroupID =GroupID_;
END IF;

	DELETE FROM tma WHERE CustomerID IN (SELECT et.CustomerID FROM ExternalTrans et,tma t WHERE et.CustomerID = t.CustomerID AND et.TransStateID IN (0,2));
	DELETE FROM tma WHERE CustomerID IN (SELECT ma.CustomerID
	FROM tma t JOIN MasterAccounts ma ON (t.CustomerID = ma.CustomerID)
		JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
		JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
		LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
		WHERE sa.Active = 1
		AND (COALESCE(p.CancelDate,sa.CancelDate) IS NULL OR (COALESCE(p.CancelDate,sa.CancelDate) > sysdate AND COALESCE(p.CancelDate,sa.CancelDate) > sa.BilledThru))
		AND NOT EXISTS (SELECT * FROM Invoices i WHERE i.Estimate = 0 AND i.Processed = 1 AND i.CustomerID = t.CustomerID AND i.Amount <> 0 AND i.StatementID IS NULL AND i.InvoiceTypeID IN (1,2,3,4,5,50))
		AND sa.BilledThru <= DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END + 15, sysdate)
		AND (ma.CancelDate IS NULL OR (ma.CancelDate > sysdate AND ma.CancelDate > sa.BilledThru)));
	DELETE FROM tma WHERE CustomerID IN (SELECT ma.CustomerID
	FROM tma t JOIN MasterAccounts ma ON (t.CustomerID = ma.CustomerID)
		JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
		JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
		LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
		WHERE sa.Active = 1
		AND (COALESCE(p.CancelDate,sa.CancelDate) IS NULL OR (COALESCE(p.CancelDate,sa.CancelDate) > sysdate AND COALESCE(p.CancelDate,sa.CancelDate) > sa.BilledThru))
		AND sa.BilledThru <= DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END + 2, sysdate)
		AND EXISTS (SELECT * FROM Statements s WHERE ma.CustomerID = s.CustomerID AND s.StatementDate > DateAdd(dd,-33,sysdate))
		AND (ma.CancelDate IS NULL OR (ma.CancelDate > sysdate AND ma.CancelDate > sa.BilledThru)));
	DELETE FROM tma WHERE CustomerID IN (SELECT ma.CustomerID
	FROM tma t JOIN MasterAccounts ma ON (t.CustomerID = ma.CustomerID)
		JOIN Statements s ON (ma.LastStatementID = s.StatementID)
		LEFT JOIN ConfigGroupData cg ON (ma.GroupID = cg.GroupID AND cg.ConfigID = 505)
		WHERE s.StatementDate > DATEADD(dd,-(COALESCE(cg.NumValue,newinterval_ )),sysdate));
IF (operatorgroupid_ IS NOT NULL) THEN
SELECT COUNT(*) INTO tmpcnt_  FROM OperatorGroupAccess WHERE ObjectGroupID = 104 AND OperatorGroupID = operatorgroupid_ AND GroupID = 1;
IF (tmpcnt_ = 0) THEN
			DELETE FROM tma WHERE CustomerID IN (SELECT ma.CustomerID
			FROM tma t, MasterAccounts ma
				WHERE t.CustomerID = ma.CustomerID
				AND ma.GroupID NOT IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 104 AND OperatorGroupID =operatorgroupid_));
END IF;
END IF;

	INSERT INTO ti (CustomerID,LastInvoiceID,InvoiceCount,NewCharge,NewCredit)
	SELECT i.CustomerID, MAX(i.InvoiceID) AS LastInvoiceID, COUNT(*) AS InvoiceCount,
	SUM(CASE WHEN i.StatementID IS NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN 0 WHEN i.StatementID IS NULL THEN CASE WHEN i.Amount > 0 THEN i.Amount ELSE 0 END WHEN i.StatementID IS NOT NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN CASE WHEN -(i.Amount) > 0 THEN -(i.Amount) ELSE 0 END END) AS NewCharge,
	SUM(CASE WHEN i.StatementID IS NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN 0 WHEN i.StatementID IS NULL THEN CASE WHEN i.Amount < 0 THEN i.Amount ELSE 0 END WHEN i.StatementID IS NOT NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN CASE WHEN -(i.Amount) < 0 THEN -(i.Amount) ELSE 0 END END) AS NewCredit
	FROM tma t, Invoices i
		WHERE t.CustomerID = i.CustomerID
		AND i.Estimate = 0
		AND i.Processed = 1
		AND (i.StatementID IS NULL OR (i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL))
	GROUP BY i.CustomerID;
	INSERT INTO tp (CustomerID,LastPaymentID,PayCount,Amount)
	SELECT p.CustomerID, MAX(p.PaymentID) AS LastPaymentID, COUNT(*) AS PayCount,
	SUM(CASE WHEN p.StatementID IS NULL AND p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL THEN p.FinalAmount WHEN p.StatementID IS NULL THEN p.Amount WHEN p.StatementID IS NOT NULL AND p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL THEN p.FinalAmount-p.Amount END) AS Amount
	FROM tma t, Payments p
	WHERE t.CustomerID = p.CustomerID
		AND (p.StatementID IS NULL OR (p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL))
		AND p.PaymentTypeID <> 0
	GROUP BY p.CustomerID;
ELSE
INSERT INTO tma (CustomerID) VALUES(custid_);
DELETE FROM tma WHERE CustomerID IN (SELECT et.CustomerID
FROM ExternalTrans et,tma t
	WHERE et.CustomerID = t.CustomerID
	AND et.TransStateID IN (0,2));
INSERT INTO ti (CustomerID,LastInvoiceID,InvoiceCount,NewCharge,NewCredit)
SELECT i.CustomerID, MAX(i.InvoiceID) AS LastInvoiceID, COUNT(*) AS InvoiceCount,
SUM(CASE WHEN i.StatementID IS NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN 0 WHEN i.StatementID IS NULL THEN CASE WHEN i.Amount > 0 THEN i.Amount ELSE 0 END WHEN i.StatementID IS NOT NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN CASE WHEN -(i.Amount) > 0 THEN -(i.Amount) ELSE 0 END END) AS NewCharge,
SUM(CASE WHEN i.StatementID IS NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN 0 WHEN i.StatementID IS NULL THEN CASE WHEN i.Amount < 0 THEN i.Amount ELSE 0 END WHEN i.StatementID IS NOT NULL AND i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL THEN CASE WHEN -(i.Amount) < 0 THEN -(i.Amount) ELSE 0 END END) AS NewCredit
FROM Invoices i
	WHERE i.CustomerID =custid_
	AND (i.StatementID IS NULL OR (i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL))
	AND i.Estimate = 0
	AND i.Processed = 1
GROUP BY i.CustomerID;
INSERT INTO tp (CustomerID,LastPaymentID,PayCount,Amount)
SELECT p.CustomerID, MAX(p.PaymentID) AS LastPaymentID, COUNT(*) AS PayCount,
SUM(CASE WHEN p.StatementID IS NULL AND p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL THEN p.FinalAmount WHEN p.StatementID IS NULL THEN p.Amount WHEN p.StatementID IS NOT NULL AND p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL THEN p.FinalAmount-p.Amount END) AS Amount
FROM Payments p
	WHERE p.CustomerID =custid_
	AND (p.StatementID IS NULL OR (p.FinalAmount IS NOT NULL AND p.FinalStatementID IS NULL))
GROUP BY p.CustomerID;
END IF;

IF (GroupID_ IS NULL) THEN
OPEN crBatchStatements1 FOR SELECT ma.GroupID, ma.CustomerID, ma.Balance, i.NewCharge AS NewCharges, i.LastInvoiceID, COALESCE(-(i.NewCredit),0) + COALESCE(p.Amount,0) AS NewCredits, p.LastPaymentID,i.InvoiceCount,p.PayCount, ma.FirstName, ma.LastName, ma.Company, ma.LastStatementID, CASE WHEN s.StatementID IS NOT NULL AND s.SentDate IS NULL THEN 0 ELSE 1 END AS SendMethodCharge
FROM MasterAccounts ma JOIN tma t ON (ma.CustomerID = t.CustomerID)
	LEFT JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	LEFT JOIN ti i ON (ma.CustomerID = i.CustomerID)
	LEFT JOIN tp p ON (ma.CustomerID = p.CustomerID)
	LEFT JOIN Statements s ON (ma.LastStatementID = s.StatementID)
	WHERE ma.Active = 1;
ELSE
OPEN crBatchStatements1 FOR SELECT ma.GroupID, ma.CustomerID, ma.Balance, i.NewCharge AS NewCharges, i.LastInvoiceID, COALESCE(-(i.NewCredit),0) + COALESCE(p.Amount,0) AS NewCredits, p.LastPaymentID,i.InvoiceCount,p.PayCount, ma.FirstName, ma.LastName, ma.Company, ma.LastStatementID, CASE WHEN s.StatementID IS NOT NULL AND s.SentDate IS NULL THEN 0 ELSE 1 END AS SendMethodCharge
FROM MasterAccounts ma JOIN tma t ON (ma.CustomerID = t.CustomerID)
	LEFT JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	LEFT JOIN ti i ON (ma.CustomerID = i.CustomerID)
	LEFT JOIN tp p ON (ma.CustomerID = p.CustomerID)
	LEFT JOIN Statements s ON (ma.LastStatementID = s.StatementID)
	WHERE ma.Active = 1
	AND ma.GroupID =GroupID_;
END IF;

DELETE FROM tma;
DELETE FROM ti;
DELETE FROM tp;
END;
END;
/

CREATE OR REPLACE PROCEDURE BillingGroupSummary (crBillingGroupSummary1 IN OUT ieatypes.CursorType,MBRGlobal_ IN INTEGER,OperatorGroupID_ IN INTEGER) AS
BEGIN

INSERT INTO bgstmp (GroupID,ActiveCount,InactiveCount,TransCount)
SELECT g.GroupID, SUM(CASE WHEN ma.Active = 1 THEN 1 ELSE 0 END) AS ActiveCount, SUM(CASE WHEN ma.Active = 0 THEN 1 ELSE 0 END) AS InactiveCount, (SELECT COUNT(*) FROM ExternalTrans et, MasterAccounts ma2 WHERE ma2.CustomerID=et.CustomerID AND ma2.Active = 1 AND ma2.GroupID = g.GroupID AND et.TransStateID IN (0,2)) AS TransCount
FROM Groups g, MasterAccounts ma
	WHERE ma.GroupID = g.GroupID
	AND ma.Active >= 0
	AND (MBRGlobal_ = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 106 AND OperatorGroupID =OperatorGroupID_))
GROUP BY g.GroupID;
OPEN crBillingGroupSummary1 FOR SELECT NULL AS GroupID, NULL AS Organization, NULL AS GroupName, SUM(ActiveCount) AS ActiveCount, SUM(InactiveCount) AS InactiveCount, SUM(TransCount) AS TransCount
FROM bgstmp
UNION ALL
SELECT t.GroupID, o.Organization, g.GroupName, t.ActiveCount, t.InactiveCount, t.TransCount
FROM bgstmp t, Groups g, Organizations o
	WHERE t.GroupID = g.GroupID
	AND g.OrganizationID = o.OrganizationID;
DELETE FROM bgstmp;
END;
/

CREATE OR REPLACE PROCEDURE BulkEmail (crBulkEmail1 IN OUT ieatypes.CursorType,GroupID_ IN INTEGER,AccountTypeID_ IN INTEGER,RegionID_ IN INTEGER) AS
BEGIN
IF (AccountTypeID_ IS NULL) THEN
OPEN crBulkEmail1 FOR SELECT ma.FirstName, ma.LastName, ma.CustomerID, ma.Company
FROM MasterAccounts ma, Groups g
	WHERE ma.GroupID = g.GroupID
	AND ma.Active = 1
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (RegionID_ IS NULL OR ma.RegionID =RegionID_);
ELSE
OPEN crBulkEmail1 FOR SELECT COALESCE(sa.FirstName,ma.FirstName) AS FirstName, COALESCE(sa.LastName,ma.LastName) AS LastName, ma.CustomerID, ma.Company
FROM MasterAccounts ma, Groups g, SubAccounts sa
	WHERE ma.GroupID = g.GroupID
	AND ma.CustomerID = sa.CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (RegionID_ IS NULL OR ma.RegionID =RegionID_)
	AND sa.AccountTypeID =AccountTypeID_;
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CallSummary (crCallSummary1 IN OUT ieatypes.CursorType,startdate_ IN DATE,enddate_ IN DATE) AS
BEGIN
DECLARE
istartdate_ DATE;
ienddate_ DATE;
BEGIN
IF (startdate_ IS NULL) THEN
SELECT DATEADD(ss,-((DATEPART(hh,sysdate)*3600)+(DATEPART(mi,sysdate)*60) + DATEPART(ss,sysdate)),DATEADD(dd,-DATEPART(dd,sysdate)+1,sysdate)) INTO istartdate_ 

 FROM DUAL;
END IF;
IF (enddate_ IS NULL) THEN
SELECT sysdate INTO ienddate_ 

 FROM DUAL;
END IF;
OPEN crCallSummary1 FOR SELECT sa.AccountID, MIN(sa.CustomerID) AS CustomerID, MIN(sa.FirstName) AS FirstName, MIN(sa.LastName) AS LastName, MIN(sa.Login) AS Login, COUNT(*) AS Calls, SUM(c.AcctSessionTime)/60 AS Mins, SUM(c.AcctInputOctets) AS InBytes, SUM(c.AcctOutputOctets) AS OutBytes, MIN(c.CallDate) AS StartDate, MAX(c.CallDate) AS EndDate
FROM Calls c, MasterAccounts ma, SubAccounts sa
	WHERE c.AccountID = sa.AccountID
	AND ma.CustomerID = sa.CustomerID
	AND c.CallDate BETWEEN istartdate_ AND ienddate_
	AND c.AcctStatusType = 2
GROUP BY sa.AccountID
ORDER BY 6;
END;
END;
/

CREATE OR REPLACE PROCEDURE CanceledAccounts AS
BEGIN

DECLARE
yn_ INTEGER;
autovoid_ INTEGER;
BEGIN
SELECT MAX(NumValue) INTO yn_  FROM Configs WHERE ConfigID=34;
SELECT MAX(NumValue) INTO autovoid_  FROM Configs WHERE ConfigID=651;

INSERT INTO canaaxe (CustomerID)
SELECT ma.CustomerID
FROM MasterAccounts ma LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 34)
	LEFT JOIN CancelReasons cr ON (ma.CancelReasonID = cr.CancelReasonID)
	WHERE ma.Active = 1
	AND ( (ma.PendingBalance = 0 AND ma.Balance = 0) OR (cgd.NumValue = 1) OR (cgd.NumValue IS NULL AND yn_ = 1) )
	AND ma.CancelDate < sysdate
	AND (cr.CancelReasonID IS NULL OR cr.Returning = 0);
UPDATE MasterAccounts SET Active = 0 WHERE CustomerID IN (SELECT CustomerID FROM canaaxe);
INSERT INTO AuditLogs(LogDate, LogMsgID, LogMsg, Operator, CustomerID, AccountID)
SELECT sysdate, 111, 'CID:' || CAST(ma.CustomerID AS VARCHAR(10)) || ' - Balance:' || CAST(ma.Balance AS VARCHAR(15)), 'Scheduler', ma.CustomerID, NULL
FROM MasterAccounts ma,canaaxe a
	WHERE ma.CustomerID = a.CustomerID;
UPDATE ExternalTrans SET TransStateID = 9 WHERE ExternalTransID IN 
(SELECT et.ExternalTransID
FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 651)
	WHERE ma.PendingBalance <= 0
	AND ma.Active = 1
	AND et.TransStateID = 3
	AND et.TransTypeID IN (16,64)
	AND et.ReqDate < DATEADD(hh,-3,sysdate)
	AND (cgd.NumValue = 1 OR (cgd.NumValue IS NULL AND autovoid_ = 1)));
DELETE FROM canaaxe;
UPDATE SubAccounts SET Active = 0
	WHERE AccountID IN (SELECT sa.AccountID FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1
		WHERE ma.CustomerID = sa.CustomerID
		AND sa.AccountTypeID = at1.AccountTypeID
		AND at1.InactCanceledDays > 0
		AND ma.Active = 1
		AND sa.Active = 1
		AND sa.CancelDate < DATEADD(dd,-(at1.InactCanceledDays),sysdate));
END;
END;
/

CREATE OR REPLACE PROCEDURE ChangeMailUserPassword (login_ IN VARCHAR2,domain_ IN VARCHAR2,password_ IN VARCHAR2,esid_ IN INTEGER) AS
BEGIN
UPDATE SubAccounts SET Password =password_
	WHERE AccountID IN (SELECT sa.AccountID	
	From SubAccounts sa, Domains d, AccountTypes at1, ExternalSystemAccountTypes esat
	WHERE sa.DomainID = d.DomainID
	 AND at1.AccountTypeID = esat.AccountTypeID
	 AND esat.ExternalSystemID =esid_
	 AND (
		(sa.Login =login_ AND d.MailDomain =domain_)
		OR
		(sa.Email =login_ || '@' || domain_) 
	     ));
END;
/

CREATE OR REPLACE PROCEDURE ChargeRateAdd (crChargeRateAdd1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,AccountID_ IN INTEGER,ChargeTypeID_ IN INTEGER,TaxGroupID_ IN INTEGER,TaxExemptions_ IN INTEGER,StartDate_ IN DATE,Amount_ IN NUMERIC,Description_ IN VARCHAR2,Login_ IN VARCHAR2) AS
BEGIN
INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,AccountID,Login,DistFlag,AllowInterim,Amount,Quantity,TaxGroupID,TaxExemptions,ChargeTypeID,LastModifyDate,LastModifyUser)
VALUES(CustomerID_,Description_ ,
CASE WHEN DATEADD(mm,1,StartDate_ ) > sysdate THEN sysdate ELSE StartDate_ END,
CASE WHEN DATEADD(mm,1,StartDate_ ) > sysdate THEN sysdate ELSE DATEADD(dd,-1,DATEADD(mm,1,StartDate_ )) END,AccountID_ ,Login_ ,1,1,Amount_ ,1,TaxGroupID_ ,TaxExemptions_ ,ChargeTypeID_ ,sysdate,'Emerald Auto Bill');
OPEN crChargeRateAdd1 FOR SELECT LAST.IDENT AS ChargeID
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE ChargeSetupAdd (AccountID_ IN INTEGER,PackageID_ IN INTEGER,StartDate_ IN DATE,Operator_ IN VARCHAR2) AS
BEGIN

IF (AccountID_ IS NOT NULL) THEN
INSERT INTO Charges (CustomerID, StartDate, EndDate, AccountID, Login, AccountTypeID, Amount, Quantity, TaxGroupID, TaxExemptions, ChargeTypeID, LastModifyDate, LastModifyUser,Operator, AllowInterim)
SELECT DISTINCT sa.CustomerID,StartDate_ ,StartDate_ , sa.AccountID, COALESCE(sa.Login,sa.Email), sa.AccountTypeID,  ct.Amount, 1, ct.TaxGroupID, ct.TaxExemptions, ct.ChargeTypeID, sysdate,Operator_ ,Operator_ , 0
FROM SubAccounts sa, AccountTypes at1, ChargeTypes ct
	WHERE sa.AccountTypeID = at1.AccountTypeID
	AND (at1.ChargeTypeID = ct.ChargeTypeID OR at1.SecChargeTypeID = ct.ChargeTypeID)
	AND at1.ChargeTypeID IS NOT NULL
	AND sa.PackageID IS NULL
	AND sa.Active = 1
	AND sa.AccountID =AccountID_;
END IF;

IF (PackageID_ IS NOT NULL) THEN
INSERT INTO Charges (CustomerID, StartDate, EndDate, PackageID, PackageTypeID, Amount, Quantity, TaxGroupID, TaxExemptions, ChargeTypeID, LastModifyDate, LastModifyUser, Operator, AllowInterim)
SELECT DISTINCT p.CustomerID,StartDate_ ,StartDate_ , p.PackageID, p.PackageTypeID, ct.Amount, 1, ct.TaxGroupID, ct.TaxExemptions, ct.ChargeTypeID, sysdate,Operator_ ,Operator_ , 0
FROM Packages p, PackageTypes pt, ChargeTypes ct
	WHERE p.PackageTypeID = pt.PackageTypeID
	AND (pt.ChargeTypeID = ct.ChargeTypeID OR pt.SecChargeTypeID = ct.ChargeTypeID)
	AND pt.ChargeTypeID IS NOT NULL
	AND p.Active = 1
	AND p.PackageID =PackageID_;
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CheckDatabase AS
BEGIN
EXECUTE IMMEDIATE 'ANALYZE TABLE MasterAccounts VALIDATE STRUCTURE CASCADE';
EXECUTE IMMEDIATE 'ANALYZE TABLE SubAccounts VALIDATE STRUCTURE CASCADE';
EXECUTE IMMEDIATE 'ANALYZE TABLE Invoices VALIDATE STRUCTURE CASCADE';
EXECUTE IMMEDIATE 'ANALYZE TABLE InvoiceItems VALIDATE STRUCTURE CASCADE';
EXECUTE IMMEDIATE 'ANALYZE TABLE Charges VALIDATE STRUCTURE CASCADE';
EXECUTE IMMEDIATE 'ANALYZE TABLE Payments VALIDATE STRUCTURE CASCADE';
EXECUTE IMMEDIATE 'ANALYZE TABLE Statements VALIDATE STRUCTURE CASCADE';
EXECUTE IMMEDIATE 'ANALYZE TABLE Calls VALIDATE STRUCTURE CASCADE';
EXECUTE IMMEDIATE 'ANALYZE TABLE Incidents VALIDATE STRUCTURE CASCADE';
EXECUTE IMMEDIATE 'ANALYZE TABLE ExternalTrans VALIDATE STRUCTURE CASCADE';
END;
/

CREATE OR REPLACE PROCEDURE CheckGroupGlobal (crCheckGroupGlobal1 IN OUT ieatypes.CursorType,groupid_ IN INTEGER) AS
BEGIN
OPEN crCheckGroupGlobal1 FOR SELECT (SELECT COUNT(*) FROM AccountTypes at1, ServiceGroupItems sgi WHERE at1.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=groupid_ AND SortOrder >= 0) + (SELECT COUNT(*) FROM AccountTypes WHERE GroupID =groupid_ AND SortOrder >= 0) AS AccountTypes,
	(SELECT COUNT(*) FROM PackageTypes pt, ServiceGroupItems sgi WHERE pt.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=groupid_ AND SortOrder >= 0) + (SELECT COUNT(*) FROM PackageTypes WHERE GroupID =groupid_ AND SortOrder >= 0) AS PackageTypes,
	(SELECT COUNT(*) FROM BillingCycles bc, ServiceGroupItems sgi WHERE bc.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=groupid_ AND SortOrder >= 0) + (SELECT COUNT(*) FROM BillingCycles WHERE GroupID =groupid_ AND SortOrder >= 0) AS BillingCycles,
	(SELECT COUNT(*) FROM Regions r, ServiceGroupItems sgi WHERE r.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=groupid_ AND SortOrder >= 0) + (SELECT COUNT(*) FROM Regions WHERE GroupID =groupid_ AND SortOrder >= 0) AS Regions,
	(SELECT COUNT(*) FROM Domains d, ServiceGroupItems sgi WHERE d.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=groupid_ AND SortOrder >= 0) + (SELECT COUNT(*) FROM Domains WHERE GroupID =groupid_ AND SortOrder >= 0) AS Domains,
	(SELECT COUNT(*) FROM PayPeriods pp, ServiceGroupItems sgi WHERE pp.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=groupid_ AND SortOrder >= 0) + (SELECT COUNT(*) FROM PayPeriods WHERE GroupID =groupid_ AND SortOrder >= 0) AS PayPeriods,
	(SELECT COUNT(*) FROM ChargeTypes ct, ServiceGroupItems sgi WHERE ct.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=groupid_ AND SortOrder >= 0) + (SELECT COUNT(*) FROM ChargeTypes WHERE GroupID =groupid_ AND SortOrder >= 0) AS ChargeTypes,
	(SELECT COUNT(*) FROM SalesPersons sp, ServiceGroupItems sgi WHERE sp.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=groupid_ AND SortOrder >= 0) + (SELECT COUNT(*) FROM SalesPersons WHERE GroupID =groupid_ AND SortOrder >= 0) AS SalesPersons,
	(SELECT COUNT(*) FROM SendMethods sm, ServiceGroupItems sgi WHERE sm.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=groupid_ AND SortOrder >= 0) + (SELECT COUNT(*) FROM SendMethods WHERE GroupID =groupid_ AND SortOrder >= 0) AS SendMethods,
	(SELECT COUNT(*) FROM IncidentTypes it, ServiceGroupItems sgi WHERE it.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=groupid_ AND SortOrder >= 0) + (SELECT COUNT(*) FROM IncidentTypes WHERE GroupID =groupid_ AND SortOrder >= 0) AS IncidentTypes,
	(SELECT COUNT(*) FROM Discounts d, ServiceGroupItems sgi WHERE d.ServiceGroupID=sgi.ServiceGroupID AND sgi.GroupID=groupid_ AND SortOrder >= 0) + (SELECT COUNT(*) FROM Discounts WHERE GroupID =groupid_ AND SortOrder >= 0) AS Discounts
FROM Configs 
	WHERE ConfigID = 0;
END;
/

CREATE OR REPLACE PROCEDURE ClearOnline (mins_ IN INTEGER) AS
BEGIN
UPDATE ServerPorts SET AcctStatusType = 2
	WHERE DATEDIFF(mi,CallDate,sysdate) >=mins_
	AND AcctStatusType IN (1,3);
END;
/

CREATE OR REPLACE PROCEDURE ConfigsGet (crConfigsGet1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crConfigsGet1 FOR SELECT c.ConfigID, cd.GroupID, CASE WHEN c.DataTypeID IN (0,2,3,4) THEN 0 ELSE 1 END AS DataTypeID, cd.NumValue, cd.Data
FROM Configs c, ConfigGroupData cd
	WHERE c.ConfigID = cd.ConfigID
UNION ALL
SELECT c.ConfigID, cd.OperatorGroupID AS GroupID, CASE WHEN c.DataTypeID IN (0,2,3,4) THEN 0 ELSE 1 END AS DataTypeID, cd.NumValue, cd.Data
FROM Configs c, ConfigOperatorGroupData cd
	WHERE c.ConfigID = cd.ConfigID
UNION ALL
SELECT c.ConfigID, NULL AS GroupID, CASE WHEN c.DataTypeID IN (0,2,3,4) THEN 0 ELSE 1 END AS DataTypeID, c.NumValue, c.Data
FROM Configs c
UNION ALL
SELECT 325 AS ConfigID, o.OrganizationID AS GroupID, 1 AS DataTypeID, NULL AS Value, CASE WHEN c.NumValue = 0 THEN NULL ELSE '(' || cu.Code || ')' END AS Data
FROM Configs c, Organizations o, Currencies cu
	WHERE c.ConfigID = 323
	AND o.CurrencyID = cu.CurrencyID
UNION ALL
SELECT 326 AS ConfigID, o.OrganizationID AS GroupID, 1 AS DataTypeID, NULL AS Value, CASE WHEN c.NumValue = 0 THEN NULL ELSE '(' || cu.Code || ')' END AS Data
FROM Configs c, Organizations o, Currencies cu
	WHERE c.ConfigID = 324
	AND o.CurrencyID = cu.CurrencyID
UNION ALL
SELECT 328 AS ConfigID, o.OrganizationID AS GroupID, 1 AS DataTypeID, NULL AS Value, CASE WHEN c.NumValue = 0 THEN NULL ELSE '(' || cu.Code || ')' END AS Data
FROM Configs c, Organizations o, Currencies cu
	WHERE c.ConfigID = 327
	AND o.CurrencyID = cu.CurrencyID
UNION ALL
SELECT 512 AS ConfigID, GroupID, 0 AS DataTypeID, OrganizationID AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 550 AS ConfigID, GroupID, 0 AS DataTypeID, DomainID AS Value, NULL AS Data FROM Groups WHERE DomainID IS NOT NULL
UNION ALL
SELECT 551 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, GroupName AS Data FROM Groups WHERE GroupName IS NOT NULL
UNION ALL
SELECT 552 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, Description AS Data FROM Groups WHERE Description IS NOT NULL
UNION ALL
SELECT 553 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, InvoiceReport AS Data FROM Groups WHERE InvoiceReport IS NOT NULL
UNION ALL
SELECT 554 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, InvoiceTextReport AS Data FROM Groups WHERE InvoiceTextReport IS NOT NULL
UNION ALL
SELECT 555 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, InvoiceHTMLReport AS Data FROM Groups WHERE InvoiceHTMLReport IS NOT NULL
UNION ALL
SELECT 556 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, StatementReport AS Data FROM Groups WHERE StatementReport IS NOT NULL
UNION ALL
SELECT 557 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, StatementTextReport AS Data FROM Groups WHERE StatementTextReport IS NOT NULL
UNION ALL
SELECT 558 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, StatementHTMLReport AS Data FROM Groups WHERE StatementHTMLReport IS NOT NULL
UNION ALL
SELECT 62 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, FTPDir AS Data FROM Groups WHERE FTPDir IS NOT NULL
UNION ALL
SELECT 560 AS ConfigID, OrganizationID, 1 AS DataTypeID, NULL AS Value, ReportLogoURL AS Data FROM Groups WHERE ReportLogoURL IS NOT NULL
UNION ALL
SELECT 562 AS ConfigID, GroupID, 0 AS DataTypeID, BillingOption AS Value, NULL AS Data FROM Groups WHERE BillingOption IS NOT NULL
UNION ALL
SELECT 563 AS ConfigID, GroupID, 0 AS DataTypeID, SendCredits AS Value, NULL AS Data FROM Groups WHERE SendCredits IS NOT NULL
UNION ALL
SELECT 567 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, BillName AS Data FROM Groups WHERE BillName IS NOT NULL
UNION ALL
SELECT 568 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, BillAddress1 AS Data FROM Groups WHERE BillAddress1 IS NOT NULL
UNION ALL
SELECT 569 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, BillAddress2 AS Data FROM Groups WHERE BillAddress2 IS NOT NULL
UNION ALL
SELECT 570 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, BillCity AS Data FROM Groups WHERE BillCity IS NOT NULL
UNION ALL
SELECT 571 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, BillState AS Data FROM Groups WHERE BillState IS NOT NULL
UNION ALL
SELECT 573 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, BillZip AS Data FROM Groups WHERE BillZip IS NOT NULL
UNION ALL
SELECT 574 AS ConfigID, GroupID, 0 AS DataTypeID, BillCountryID AS Value, NULL AS Data FROM Groups WHERE BillCountryID IS NOT NULL
UNION ALL
SELECT 575 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, EmailAccounts AS Data FROM Groups WHERE EmailAccounts IS NOT NULL
UNION ALL
SELECT 576 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, EmailSubject AS Data FROM Groups WHERE EmailSubject IS NOT NULL
UNION ALL
SELECT 579 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalIncidentTypes AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 580 AS ConfigID, GroupID, 1 AS DataTypeID, NULL AS Value, ReportLogoURL AS Data FROM Groups
UNION ALL
SELECT 565 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalSendMethods AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 590 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalAccountTypes AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 591 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalBillingCycles AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 592 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalRegions AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 593 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalPayPeriods AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 594 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalDiscounts AS Value, NULL  AS Data FROM Groups
UNION ALL
SELECT 595 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalChargeTypes AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 596 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalPackageTypes AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 597 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalDomains AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 598 AS ConfigID, GroupID, 0 AS DataTypeID, GlobalSalesPersons AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 599 AS ConfigID, GroupID, 0 AS DataTypeID, MBRFields AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 583 AS ConfigID, GroupID, 0 AS DataTypeID, PaymentTypes AS Value, NULL AS Data FROM Groups
UNION ALL
SELECT 577 AS ConfigID, g.GroupID, 0 AS DataTypeID, MAX(CASE WHEN e.ExportType IN (1,2,5) THEN 1 ELSE 0 END) AS Value, NULL AS Data
FROM Groups g, BatchProcessors bp, Exports e
	WHERE (g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL)
	AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
GROUP BY g.GroupID
UNION ALL
SELECT 578 AS ConfigID, g.GroupID, 0 AS DataTypeID, MAX(CASE WHEN e.ExportType IN (4,6) THEN 1 ELSE 0 END) AS Value, NULL AS Data
FROM Groups g, BatchProcessors bp, Exports e
	WHERE (g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL)
	AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
GROUP BY g.GroupID
UNION ALL
SELECT 581 AS ConfigID, g.GroupID, 0 AS DataTypeID, MAX(CASE WHEN e.ExportType = 5 THEN 1 ELSE 0 END) AS Value, NULL AS Data
FROM Groups g, BatchProcessors bp, Exports e
	WHERE (g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL)
	AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
GROUP BY g.GroupID
UNION ALL
SELECT 582 AS ConfigID, g.GroupID, 0 AS DataTypeID, MAX(CASE WHEN e.ExportType = 6 THEN 1 ELSE 0 END) AS Value, NULL AS Data
FROM Groups g, BatchProcessors bp, Exports e
	WHERE (g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL)
	AND (bp.GroupID IS NULL OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
GROUP BY g.GroupID;
END;
/

CREATE OR REPLACE PROCEDURE CreateServerPorts (crCreateServerPorts1 IN OUT ieatypes.CursorType,serverid_ IN INTEGER) AS
BEGIN
OPEN crCreateServerPorts1 FOR SELECT 'Not supported with Oracle' AS Results, NULL AS ServerType
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE CreditAdd (CustomerID_ IN INTEGER,AccountID_ IN INTEGER,AccountTypeID_ IN INTEGER,PackageID_ IN INTEGER,PackageTypeID_ IN INTEGER,Amount_ IN NUMERIC,LastModifyUser_ IN VARCHAR2,StartDate_ IN DATE,EndDate_ IN DATE,Description_ IN VARCHAR2) AS
BEGIN
DECLARE
Login_ VARCHAR2(64);
BEGIN

IF (AccountID_ IS NOT NULL) THEN
SELECT COALESCE(Login,Email) INTO Login_  FROM SubAccounts WHERE AccountID = AccountID_;
END IF;

INSERT INTO Charges (CustomerID,AccountID,Login,AccountTypeID,PackageID,PackageTypeID,Amount,Quantity,Description,StartDate,EndDate,LastModifyDate,LastModifyUser,DistFlag)
VALUES(CustomerID_,AccountID_ ,Login_ ,AccountTypeID_ ,PackageID_ ,PackageTypeID_ ,-(Amount_),1,Description_ ,COALESCE(StartDate_,sysdate),COALESCE(EndDate_,sysdate),sysdate,LastModifyUser_ ,1);
END;
END;
/

CREATE OR REPLACE PROCEDURE CreditCardExport (crCreditCardExport1 IN OUT ieatypes.CursorType,BatchProcessorID_ IN INTEGER,CustomerID_ IN INTEGER) AS
BEGIN
IF (CustomerID_ IS NULL) THEN
OPEN crCreditCardExport1 FOR SELECT COALESCE(ma.Email,(SELECT MIN(sa2.Email) FROM SubAccounts sa2 WHERE sa2.Active = 1 AND sa2.SendBill = 1 AND sa2.CustomerID = ma.CustomerID)) AS Email,
CASE WHEN DATEPART(mm,et.AccountExpire) < 10 THEN '0' ELSE '' END || CAST(DATEPART(mm,et.AccountExpire) AS VARCHAR(2)) AS expmm,
CASE WHEN MOD(DATEPART(yy,et.AccountExpire),100) < 10 THEN '0' ELSE '' END || CAST(MOD(DATEPART(yy,et.AccountExpire),100) AS VARCHAR(2)) AS expyy, 
DATEPART(yy,et.AccountExpire) AS expyyyy, COALESCE(ma.PhoneHome,ma.PhoneWork) AS Phone,
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,1,CHARINDEX(' ',et.AuthName)-1) ELSE et.AuthName END AS FirstName,
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,CHARINDEX(' ',et.AuthName)+1,255) ELSE NULL END AS LastName,
(SELECT State FROM States WHERE StateID=COALESCE(et.AuthStateID,cc.BillToStateID,ma.StateID)) AS State,
(SELECT Abbreviation FROM States WHERE StateID=COALESCE(et.AuthStateID,cc.BillToStateID,ma.StateID)) AS State2,
COALESCE(cc.BillToCity,ma.City) AS City,
(SELECT Country FROM Countries WHERE CountryID=COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840)) AS Country,
(SELECT Abbr2 FROM Countries WHERE CountryID=COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840)) AS Country2,
(SELECT Abbr3 FROM Countries WHERE CountryID=COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840)) AS Country3,
COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840) AS CountryCode,
CASE WHEN et.TransTypeID = 256 THEN (SELECT MAX(et2.ExternalTransID) FROM ExternalTrans et2 WHERE et2.ExternalTransID <> et.ExternalTransID AND et2.ProcTransID = et.ProcTransID AND et2.PaymentID = et.PaymentID) ELSE NULL END AS PrevTransID,
et.AccountNumber AS CardNumber, et.ProcTransID,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,1,CHARINDEX(':',et.ProcTransID)-1) ELSE NULL END AS ProcTrans1,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,CHARINDEX(':',et.ProcTransID)+1,100) ELSE NULL END AS ProcTrans2,
et.ApproveCode, et.AuthName AS CardHolder, et.AuthAddress AS Address, et.AuthZip AS Zip, et.AuthSecurityCode AS SecurityCode, 
CASE WHEN et.AuthSecurityCode IS NULL THEN 0 ELSE 1 END AS SecurityCodeInd,et.ExternalTransID, et.TransTypeID,
et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, bp.Merchant, bp.Store, bp.Terminal,
CASE ct.CardTypeID WHEN 1 THEN 'ECMC-SSL' WHEN 2 THEN 'VISA-SSL' WHEN 4 THEN 'AMEX-SSL' WHEN 8 THEN 'DINERS-SSL' WHEN 32 THEN 'DISCOVER-SSL' WHEN 128 THEN 'JCB-SSL' ELSE 'VISA-SSL' END AS WorldPayType,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(dd,et.ReqDate) AS VARCHAR(2)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(mm,et.ReqDate) AS VARCHAR(2)) AS startmm, 
CASE WHEN MOD(DATEPART(yy,et.ReqDate),100) < 10 THEN '0' ELSE '' END || CAST(MOD(DATEPART(yy,et.ReqDate),100) AS VARCHAR(2)) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(hh,et.ReqDate) AS VARCHAR(2)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(mi,et.ReqDate) AS VARCHAR(2)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(ss,et.ReqDate) AS VARCHAR(2)) AS startss,
et.Amount, COALESCE(ct.CardType,'NA') AS CardType, 
CASE ct.CardTypeID WHEN 1 THEN 'MC' WHEN 2 THEN 'VISA' WHEN 4 THEN 'AMEX' WHEN 8 THEN 'DC' ELSE COALESCE(ct.CardType,'NA') END AS CardTypeAbbr,
CASE WHEN et.AuthSecurityCode IS NULL OR et.AuthSecurityCode = ' ' THEN 0 ELSE 1 END AS SecurityCodePresent, bp.Login, bp.Password, ma.Company,
c.Code AS CurrencyCode, ma.PayInfo, bp.ProcessorURL AS baseurl
FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Currencies c ON (o.CurrencyID = c.CurrencyID)
	JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	LEFT JOIN CardTypes ct ON (cc.CardTypeID = ct.CardTypeID)
	LEFT JOIN Payments p ON (et.PaymentID = p.PaymentID)
	WHERE et.BatchProcessorID =BatchProcessorID_
	AND ma.Active = 1
	AND et.TransStateID = 0
	AND et.AccountNumber IS NOT NULL
	AND et.AccountExpire IS NOT NULL
	AND p.FinalAmount IS NULL;
ELSE
OPEN crCreditCardExport1 FOR SELECT COALESCE(ma.Email,(SELECT MIN(sa2.Email) FROM SubAccounts sa2 WHERE sa2.Active = 1 AND sa2.SendBill = 1 AND sa2.CustomerID = ma.CustomerID)) AS Email,
CASE WHEN DATEPART(mm,et.AccountExpire) < 10 THEN '0' ELSE '' END || CAST(DATEPART(mm,et.AccountExpire) AS VARCHAR(2)) AS expmm,
CASE WHEN MOD(DATEPART(yy,et.AccountExpire),100) < 10 THEN '0' ELSE '' END || CAST(MOD(DATEPART(yy,et.AccountExpire),100) AS VARCHAR(2)) AS expyy, 
DATEPART(yy,et.AccountExpire) AS expyyyy, COALESCE(ma.PhoneHome,ma.PhoneWork) AS Phone,
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,1,CHARINDEX(' ',et.AuthName)-1) ELSE et.AuthName END AS FirstName,
CASE WHEN CHARINDEX(' ',et.AuthName) > 0 THEN SUBSTRING(et.AuthName,CHARINDEX(' ',et.AuthName)+1,255) ELSE NULL END AS LastName,
(SELECT State FROM States WHERE StateID=COALESCE(et.AuthStateID,cc.BillToStateID,ma.StateID)) AS State,
(SELECT Abbreviation FROM States WHERE StateID=COALESCE(et.AuthStateID,cc.BillToStateID,ma.StateID)) AS State2,
COALESCE(cc.BillToCity,ma.City) AS City,
(SELECT Country FROM Countries WHERE CountryID=COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840)) AS Country,
(SELECT Abbr2 FROM Countries WHERE CountryID=COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840)) AS Country2,
(SELECT Abbr3 FROM Countries WHERE CountryID=COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840)) AS Country3,
COALESCE(cc.BillToCountryID,ma.CountryID,g.BillCountryID,840) AS CountryCode,
CASE WHEN et.TransTypeID = 256 THEN (SELECT MAX(et2.ExternalTransID) FROM ExternalTrans et2 WHERE et2.ExternalTransID <> et.ExternalTransID AND et2.ProcTransID = et.ProcTransID AND et2.PaymentID = et.PaymentID) ELSE NULL END AS PrevTransID,
et.AccountNumber AS CardNumber, et.ProcTransID,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,1,CHARINDEX(':',et.ProcTransID)-1) ELSE NULL END AS ProcTrans1,
CASE WHEN CHARINDEX(':',et.ProcTransID) > 0 THEN SUBSTRING(et.ProcTransID,CHARINDEX(':',et.ProcTransID)+1,100) ELSE NULL END AS ProcTrans2,
et.ApproveCode, et.AuthName AS CardHolder, et.AuthAddress AS Address, et.AuthZip AS Zip, et.AuthSecurityCode AS SecurityCode,
CASE WHEN et.AuthSecurityCode IS NULL THEN 0 ELSE 1 END AS SecurityCodeInd,et.ExternalTransID, et.TransTypeID,
et.ExternalTransID AS TransID,et.CustomerID, et.LastModifyUser, NULL AS InvoiceID, bp.Merchant, bp.Store, bp.Terminal,
CASE ct.CardTypeID WHEN 1 THEN 'ECMC-SSL' WHEN 2 THEN 'VISA-SSL' WHEN 4 THEN 'AMEX-SSL' WHEN 8 THEN 'DINERS-SSL' WHEN 32 THEN 'DISCOVER-SSL' WHEN 128 THEN 'JCB-SSL' ELSE 'VISA-SSL' END AS WorldPayType,
CASE WHEN DATEPART(dd,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(dd,et.ReqDate) AS VARCHAR(2)) AS startdd, 
CASE WHEN DATEPART(mm,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(mm,et.ReqDate) AS VARCHAR(2)) AS startmm, 
CASE WHEN MOD(DATEPART(yy,et.ReqDate),100) < 10 THEN '0' ELSE '' END || CAST(MOD(DATEPART(yy,et.ReqDate),100) AS VARCHAR(2)) AS startyy,
CASE WHEN DATEPART(hh,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(hh,et.ReqDate) AS VARCHAR(2)) AS starthh, 
CASE WHEN DATEPART(mi,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(mi,et.ReqDate) AS VARCHAR(2)) AS startmi, 
CASE WHEN DATEPART(ss,et.ReqDate) < 10 THEN '0' ELSE '' END || CAST(DATEPART(ss,et.ReqDate) AS VARCHAR(2)) AS startss,
et.Amount, COALESCE(ct.CardType,'NA') AS CardType, 
CASE ct.CardTypeID WHEN 1 THEN 'MC' WHEN 2 THEN 'VISA' WHEN 4 THEN 'AMEX' WHEN 8 THEN 'DC' ELSE COALESCE(ct.CardType,'NA') END AS CardTypeAbbr,
CASE WHEN et.AuthSecurityCode IS NULL OR et.AuthSecurityCode = ' ' THEN 0 ELSE 1 END AS SecurityCodePresent, bp.Login, bp.Password, ma.Company,
c.Code AS CurrencyCode, ma.PayInfo, bp.ProcessorURL AS baseurl
FROM ExternalTrans et JOIN MasterAccounts ma ON (et.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Currencies c ON (o.CurrencyID = c.CurrencyID)
	JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	LEFT JOIN CardTypes ct ON (cc.CardTypeID = ct.CardTypeID)
	LEFT JOIN Payments p ON (et.PaymentID = p.PaymentID)
	WHERE et.BatchProcessorID =BatchProcessorID_
	AND ma.Active = 1
	AND et.TransStateID = 0
	AND ma.CustomerID =CustomerID_
	AND et.AccountNumber IS NOT NULL
	AND et.AccountExpire IS NOT NULL
	AND p.FinalAmount IS NULL;
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CreditCardImport (TransID_ IN INTEGER,TransStateID_ IN INTEGER,ApproveCode_ IN VARCHAR2,Response_ IN VARCHAR2,etransid_ IN VARCHAR2) AS
BEGIN
UPDATE ExternalTrans
	SET TransStateID =TransStateID_, AuthSecurityCode = NULL,
	ApproveCode =ApproveCode_,
	Response = CAST(Response_ AS VARCHAR(50)),
	ProcTransID =etransid_,
	ProcDate = sysdate
WHERE ExternalTransID =TransID_ 
	AND TransStateID IN (0,2);
UPDATE CreditCards SET SecurityCode = NULL 
	WHERE CustomerID IN (SELECT cc.CustomerID
	FROM CreditCards cc, ExternalTrans et
		WHERE cc.CustomerID = et.CustomerID
		AND et.ExternalTransID =TransID_
		AND cc.SecurityCode IS NOT NULL);
END;
/

CREATE OR REPLACE PROCEDURE CreditCardAuthOnlyVoid AS
BEGIN
UPDATE ExternalTrans SET TransStateID = 9
	WHERE TransTypeID = 16 
	AND TransStateID = 4 
	AND ProcDate < DATEADD(dd,-10,sysdate);
END;
/

CREATE OR REPLACE PROCEDURE CustomerAcctList (crCustomerAcctList1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN


INSERT INTO caltmp (PackageID, AccountTypeID, Cnt)
SELECT p.PackageID, sa.AccountTypeID, COUNT(*) AS Cnt
FROM Packages p, SubAccounts sa
	WHERE p.PackageID = sa.PackageID
	AND p.CustomerID =CustomerID_
	AND sa.CustomerID = p.CustomerID
	AND p.Active = 1
	AND sa.Active = 1
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
GROUP BY p.PackageID, sa.AccountTypeID;
INSERT INTO caltmp (PackageID, AccountTypeID, Cnt)
SELECT NULL, sa.AccountTypeID, COUNT(*) AS Cnt
FROM SubAccounts sa
	WHERE sa.CustomerID =CustomerID_
	AND sa.PackageID IS NULL
	AND sa.Active = 1
	AND (sa.CancelDate IS NULL OR DATEADD(dd,1,sa.CancelDate) > sysdate)
GROUP BY sa.AccountTypeID;
OPEN crCustomerAcctList1 FOR SELECT 4 AS GroupingID, p.PackageID, NULL AS AccountID, p.PackageTypeID, COALESCE(pt.InvoiceDescription,pt.PackageType) AS PackageType, pt.StringID AS PackageTypeStringID,
NULL AS Login, NULL AS AccountTypeID, NULL AS AccountType, NULL AS AccountTypeStringID, (SELECT MAX(AllowCustCancel) FROM PackageAccountTypes pat WHERE pat.PackageTypeID=p.PackageTypeID) AS AllowEdit, 
CASE WHEN p.CancelDate IS NOT NULL THEN 2 WHEN DATEADD(dd,CASE WHEN bc.AutoBill <> 2 THEN 1 ELSE 0 END + COALESCE(p.Extension,0) + COALESCE(ma.OverDue,0),p.ExpireDate) < sysdate THEN 3 ELSE 1 END AS Status, 
p.CancelDate, p.ExpireDate, COALESCE(p.Extension,0) + COALESCE(ma.OverDue,0) AS Extension,
NULL AS AvailCnt, NULL AS MaxCnt,
pp.Period * CASE WHEN bc.AutoBill = 2 THEN NULL WHEN p.DiffCost = 1 THEN p.Cost WHEN d.DiscountID IS NULL THEN 
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(opt.CustomerCost,pt.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(opt.CustomerCost,pt.Cost) ELSE COALESCE(opt.CustomerCost,pt.Cost) - pp.Amount END
WHEN d.AmountType = 0 THEN CAST((100 - d.Amount) AS NUMERIC(18,4)) / 100 *
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(opt.CustomerCost,pt.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(opt.CustomerCost,pt.Cost) ELSE COALESCE(opt.CustomerCost,pt.Cost) - pp.Amount END
ELSE
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(opt.CustomerCost,pt.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(opt.CustomerCost,pt.Cost) ELSE COALESCE(opt.CustomerCost,pt.Cost) - pp.Amount END
- d.Amount END AS Cost, pp.PayPeriod AS PayPeriod, pp.StringID AS PayPeriodStringID, NULL AS LeftType, NULL AS TimeLeft, NULL AS DataLeft, NULL AS HoursLeft, NULL AS FirstName, NULL AS LastName
FROM Packages p JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN MasterAccounts ma ON (ma.CustomerID = p.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN PayPeriods pp ON (p.PayPeriodID = pp.PayPeriodID)
	JOIN Discounts d ON (p.DiscountID = d.DiscountID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN OrgPackageTypes opt ON (pt.PackageTypeID = opt.PackageTypeID AND o.OrganizationID = opt.OrganizationID AND o.ResellerCustomerID IS NOT NULL)
	WHERE p.CustomerID =CustomerID_
	AND pt.CustomerAccess = 1
	AND p.Active = 1
	AND EXISTS (SELECT * FROM PackageAccountTypes pat WHERE pat.PackageTypeID = p.PackageTypeID AND pat.MaxQty > 0)

UNION ALL

SELECT 3 AS GroupingID, p.PackageID, sa.AccountID, pat.PackageTypeID, NULL AS PackageType, NULL AS PackageTypeStringID,
COALESCE(sa.Login || CASE WHEN pat.AllowCustSetDomain = 1 THEN '@' || d.MailDomain ELSE '' END,sa.Email) AS Login, pat.AccountTypeID, at1.AccountType, at1.StringID AS AccountTypeStringID,
CASE WHEN pat.AllowCustCancel = 1 AND sa.CancelDate IS NULL AND sa.Active = 1 THEN 1 WHEN pat.AllowCustChangeLogin = 1 THEN 1 WHEN pat.AllowCustChangePass = 1 THEN 1 ELSE 0 END AS AllowEdit, CASE WHEN sa.Active = 0 THEN 0 WHEN sa.CancelDate IS NOT NULL THEN 2 ELSE 1 END AS Status, sa.CancelDate, NULL AS ExpireDate, NULL AS Extension,
NULL AS AvailCnt, NULL AS MaxCnt,
NULL AS Cost, NULL AS PayPeriod, NULL AS PayPeriodStringID,
2 AS LeftType, sa.TimeLeft, (sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > sysdate AND sau.DataLeft > 0),0)) / 1000000.0 AS DataLeft, CAST (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > sysdate AND sau.TimeLeft > 0),0) AS NUMERIC(18,4)) / 60 AS HoursLeft, sa.FirstName, sa.LastName
FROM Packages p JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID)
	JOIN AccountTypes at1 ON (pat.AccountTypeID = at1.AccountTypeID)
	JOIN SubAccounts sa ON (sa.PackageID = p.PackageID AND sa.AccountTypeID = pat.AccountTypeID AND sa.CustomerID = p.CustomerID AND sa.Active IN (1,0))
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	WHERE p.CustomerID =CustomerID_
	AND pt.CustomerAccess = 1
	AND p.Active = 1
	AND pat.MaxQty > 0

UNION ALL

SELECT 2 AS GroupingID, p.PackageID, NULL AS AccountID, pat.PackageTypeID, NULL AS PackageType, NULL AS PackageTypeStringID,
NULL AS Login, pat.AccountTypeID, at1.AccountType, at1.StringID AS AccountTypeStringID, NULL AS AllowEdit, NULL AS Status, NULL AS CancelDate, NULL AS ExpireDate, NULL AS Extension,
CASE WHEN pat.CustomerMax < pat.MaxQty THEN pat.CustomerMax ELSE pat.MaxQty END - COALESCE(t.Cnt,0) AS AvailCnt,
CASE WHEN pat.CustomerMax < pat.MaxQty THEN pat.CustomerMax ELSE pat.MaxQty END AS MaxCnt,
NULL AS Cost, NULL AS PayPeriod, NULL AS PayPeriodStringID, NULL AS LeftType, NULL AS TimeLeft, NULL AS DataLeft, NULL AS HoursLeft, NULL AS FirstName, NULL AS LastName
FROM Packages p JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID)
	JOIN AccountTypes at1 ON (pat.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN caltmp t ON (p.PackageID = t.PackageID AND at1.AccountTypeID = t.AccountTypeID)
	WHERE p.CustomerID =CustomerID_
	AND pt.CustomerAccess = 1
	AND p.Active = 1
	AND pat.CustomerMax > 0
	AND pat.AllowCustAdd = 1
	AND ((t.Cnt IS NULL AND pat.CustomerMax > 0 AND pat.MaxQty > 0) OR (t.Cnt < pat.CustomerMax AND t.Cnt < pat.MaxQty))

UNION ALL

SELECT DISTINCT 1 AS GroupingID, NULL AS PackageID, sa.AccountID, NULL AS PackageTypeID, NULL AS PackageType, NULL AS PackageTypeStringID,
COALESCE(sa.Login || CASE WHEN pat.AllowCustSetDomain = 1 THEN '@' || dom.MailDomain ELSE '' END,sa.Email) AS Login, sa.AccountTypeID, at1.AccountType, at1.StringID AS AccountTypeStringID,
CASE WHEN pat.AllowCustCancel = 1 AND sa.CancelDate IS NULL AND sa.Active = 1 THEN 1 WHEN pat.AllowCustChangeLogin = 1 THEN 1 WHEN pat.AllowCustChangePass = 1 THEN 1 ELSE 0 END AS AllowEdit,
CASE WHEN sa.Active = 0 THEN 0 WHEN sa.CancelDate IS NOT NULL THEN 2 WHEN DATEADD(dd,CASE WHEN bc.AutoBill <> 2 THEN 1 ELSE 0 END + COALESCE(sa.Extension,0) + COALESCE(ma.OverDue,0),sa.ExpireDate) < sysdate THEN 3 ELSE 1 END AS Status, sa.CancelDate,
sa.ExpireDate, COALESCE(sa.Extension,0) + COALESCE(ma.OverDue,0) AS Extension, NULL AS AvailCnt, NULL AS MaxCnt,
pp.Period * CASE WHEN bc.AutoBill = 2 THEN NULL WHEN d.DiscountID IS NULL THEN 
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(oat.CustomerCost,at1.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(oat.CustomerCost,at1.Cost) ELSE COALESCE(oat.CustomerCost,at1.Cost) - pp.Amount END
WHEN d.AmountType = 0 THEN CAST((100 - d.Amount) AS NUMERIC(18,4)) / 100 *
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(oat.CustomerCost,at1.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(oat.CustomerCost,at1.Cost) ELSE COALESCE(oat.CustomerCost,at1.Cost) - pp.Amount END
ELSE
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(oat.CustomerCost,at1.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(oat.CustomerCost,at1.Cost) ELSE COALESCE(oat.CustomerCost,at1.Cost) - pp.Amount END
- d.Amount END AS Cost,
CASE WHEN bc.AutoBill = 2 THEN NULL ELSE pp.PayPeriod END AS PayPeriod, CASE WHEN bc.AutoBill = 2 THEN NULL ELSE pp.StringID END  AS PayPeriodStringID, 
2 AS LeftType, sa.TimeLeft, (sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > sysdate AND sau.DataLeft > 0),0)) / 1000000.0 AS DataLeft, CAST (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > sysdate AND sau.TimeLeft > 0),0) AS NUMERIC(18,4)) / 60 AS HoursLeft, sa.FirstName, sa.LastName
FROM Packages p JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID)
	JOIN AccountTypes at1 ON (pat.AccountTypeID = at1.AccountTypeID)
	JOIN SubAccounts sa ON (sa.PackageID IS NULL AND sa.AccountTypeID = pat.AccountTypeID AND sa.CustomerID = p.CustomerID AND sa.Active IN (1,0))
	JOIN Domains dom ON (sa.DomainID = dom.DomainID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN MasterAccounts ma ON (ma.CustomerID = p.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Discounts d ON (sa.DiscountID = d.DiscountID)
	LEFT JOIN OrgAccountTypes oat ON (at1.AccountTypeID = oat.AccountTypeID AND o.OrganizationID = oat.OrganizationID AND o.ResellerCustomerID IS NOT NULL)
	WHERE p.CustomerID =CustomerID_
	AND pt.CustomerAccess = 1
	AND p.Active = 1

UNION ALL

SELECT 0 AS GroupingID, NULL AS PackageID, NULL AS AccountID, NULL AS PackageTypeID, NULL AS PackageType, NULL AS PackageTypeStringID,
NULL AS Login, at1.AccountTypeID, MIN(at1.AccountType), MIN(at1.StringID) AS AccountTypeStringID, NULL AS AllowEdit, NULL AS Status, NULL AS CancelDate, NULL AS ExpireDate, NULL AS Extension,
MAX(pat.CustomerMax) - (MAX(COALESCE(t.Cnt,0)) + MAX(COALESCE(t2.Cnt,0))) AS AvailCnt, MAX(pat.CustomerMax) AS MaxCnt,
MIN(pp.Period * CASE WHEN bc.AutoBill = 2 THEN NULL WHEN d.DiscountID IS NULL THEN 
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(oat.CustomerCost,at1.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(oat.CustomerCost,at1.Cost) ELSE COALESCE(oat.CustomerCost,at1.Cost) - pp.Amount END
WHEN d.AmountType = 0 THEN CAST((100 - d.Amount) AS NUMERIC(18,4)) / 100 *
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(oat.CustomerCost,at1.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(oat.CustomerCost,at1.Cost) ELSE COALESCE(oat.CustomerCost,at1.Cost) - pp.Amount END
ELSE
CASE WHEN pt.ApplyDiscount = 0 THEN COALESCE(oat.CustomerCost,at1.Cost) WHEN pp.AmountType = 0 THEN CAST((100 - pp.Amount) AS NUMERIC(18,4)) / 100 * COALESCE(oat.CustomerCost,at1.Cost) ELSE COALESCE(oat.CustomerCost,at1.Cost) - pp.Amount END
- d.Amount END) AS Cost,MIN(pp.PayPeriod) AS PayPeriod, MIN(pp.StringID) AS PayPeriodStringID, NULL AS LeftType, NULL AS TimeLeft, NULL AS DataLeft, NULL AS HoursLeft, NULL AS FirstName, NULL AS LastName
FROM Packages p JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID)
	JOIN AccountTypes at1 ON (pat.AccountTypeID = at1.AccountTypeID)
	JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN PayPeriods pp ON (ma.PayPeriodID = pp.PayPeriodID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Discounts d ON (pat.NonPkgDiscountID = d.DiscountID)
	LEFT JOIN OrgAccountTypes oat ON (at1.AccountTypeID = oat.AccountTypeID AND o.OrganizationID = oat.OrganizationID AND o.ResellerCustomerID IS NOT NULL)
	LEFT JOIN caltmp t ON (p.PackageID = t.PackageID AND at1.AccountTypeID = t.AccountTypeID)
	LEFT JOIN caltmp t2 ON (t2.PackageID IS NULL AND t2.AccountTypeID = at1.AccountTypeID)
	WHERE p.CustomerID =CustomerID_
	AND pt.CustomerAccess = 1
	AND p.Active = 1
	AND pat.CustomerMax > 0
	AND pat.AllowCustAdd = 1
	AND ((t.Cnt IS NULL AND pat.MaxQty <= 0) OR (t.Cnt >= pat.MaxQty))
	AND pat.CustomerMax > COALESCE(t.Cnt,0) + COALESCE(t2.Cnt,0)
GROUP BY at1.AccountTypeID
ORDER BY 2 DESC,1 DESC, 7 ASC;
DELETE FROM caltmp;
END;
/

CREATE OR REPLACE PROCEDURE CustomerAddCheck (crCustomerAddCheck1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,AccountTypeID_ IN INTEGER,PackageID_ IN INTEGER) AS
BEGIN
IF (PackageID_ IS NULL) THEN

INSERT INTO cactmp (PackageID, AccountTypeID, Cnt)
SELECT p.PackageID, sa.AccountTypeID, COUNT(*) AS Cnt
FROM Packages p, SubAccounts sa
	WHERE p.PackageID = sa.PackageID
	AND p.CustomerID =CustomerID_
	AND sa.CustomerID = p.CustomerID
	AND p.Active = 1
	AND sa.Active = 1
	AND (sa.CancelDate IS NULL OR DATEADD(dd,1,sa.CancelDate) > sysdate)
GROUP BY p.PackageID, sa.AccountTypeID;
INSERT INTO cactmp (PackageID, AccountTypeID, Cnt)
SELECT NULL, sa.AccountTypeID, COUNT(*) AS Cnt
FROM SubAccounts sa
	WHERE sa.CustomerID =CustomerID_
	AND sa.PackageID IS NULL
	AND sa.Active = 1
	AND (sa.CancelDate IS NULL OR DATEADD(dd,1,sa.CancelDate) > sysdate)
GROUP BY sa.AccountTypeID;
OPEN crCustomerAddCheck1 FOR SELECT CASE WHEN MAX(pat.CustomerMax) - (MAX(COALESCE(t.Cnt,0)) + MAX(COALESCE(t2.Cnt,0))) >= 0 THEN 1 ELSE 0 END AS Status
FROM Packages p JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID)
	JOIN AccountTypes at1 ON (pat.AccountTypeID = at1.AccountTypeID)
	JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN PayPeriods pp ON (ma.PayPeriodID = pp.PayPeriodID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Discounts d ON (pat.NonPkgDiscountID = d.DiscountID)
	LEFT JOIN OrgAccountTypes oat ON (at1.AccountTypeID = oat.AccountTypeID AND o.OrganizationID = oat.OrganizationID AND o.ResellerCustomerID IS NOT NULL)
	LEFT JOIN cactmp t ON (p.PackageID = t.PackageID AND at1.AccountTypeID = t.AccountTypeID)
	LEFT JOIN cactmp t2 ON (t2.PackageID IS NULL AND t2.AccountTypeID = at1.AccountTypeID)
	WHERE p.CustomerID =CustomerID_
	AND pt.CustomerAccess = 1
	AND p.Active = 1
	AND pat.CustomerMax > 0
	AND pat.AllowCustAdd = 1
	AND at1.AccountTypeID=AccountTypeID_
	AND ((t.Cnt IS NULL AND pat.MaxQty <= 0) OR (t.Cnt >= pat.MaxQty))
	AND pat.CustomerMax >= COALESCE(t.Cnt,0) + COALESCE(t2.Cnt,0)
GROUP BY at1.AccountTypeID;
DELETE FROM cactmp;
ELSE
OPEN crCustomerAddCheck1 FOR SELECT CASE WHEN MAX(MaxQty) - COUNT(*) >= 0 THEN 1 ELSE 0 END AS Status
FROM MasterAccounts ma JOIN Packages p ON (ma.CustomerID = p.CustomerID)
	JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID AND pat.AccountTypeID=AccountTypeID_)
	LEFT JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID AND sa.PackageID = p.PackageID AND sa.AccountTypeID = pat.AccountTypeID AND sa.Active = 1 AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate))
	WHERE ma.CustomerID =CustomerID_
	AND ma.Active = 1
	AND p.Active = 1
	AND p.PackageID =PackageID_
	AND pt.CustomerAccess = 1;
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CustomerAgingDetail (crCustomerAgingDetail1 IN OUT ieatypes.CursorType,custid_ IN INTEGER) AS
BEGIN
OPEN crCustomerAgingDetail1 FOR SELECT i.InvoiceID, DATEDIFF(dd,i.CreateDate,sysdate) AS Days, SUM((ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount) AS Amount, i.CreateDate
FROM MasterAccounts ma, Invoices i, InvoiceItems ii
	WHERE i.InvoiceID = ii.InvoiceID
	AND ii.Amount > 0
	AND i.Estimate = 0
	AND i.VoidDate IS NULL
	AND ma.CustomerID = i.CustomerID
	AND ma.PendingBalance NOT BETWEEN -.0099 AND .0099
	AND ma.CustomerID =custid_
GROUP BY i.InvoiceID, i.CreateDate
HAVING SUM((ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount) > 0;
END;
/

CREATE OR REPLACE PROCEDURE CustomerAllowSA (crCustomerAllowSA1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,AccountID_ IN INTEGER) AS
BEGIN
OPEN crCustomerAllowSA1 FOR SELECT DISTINCT 
CASE WHEN sa.CancelDate IS NULL THEN pat.AllowCustCancel ELSE 0 END AS AllowCustCancel, 
CASE WHEN sa.CancelDate IS NULL THEN pat.AllowCustChangeLogin ELSE 0 END AS AllowCustChangeLogin, 
CASE WHEN sa.CancelDate IS NULL THEN pat.AllowCustChangePass ELSE 0 END AS AllowCustChangePass,
sa.FirstName, sa.LastName, COALESCE(sa.Login,sa.Email) AS Account, at1.StringID AS AccountTypeStringID, at1.AccountType, at1.AccountTypeID
FROM Packages p JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN SubAccounts sa ON (sa.CustomerID = p.CustomerID AND sa.AccountID =AccountID_ AND (sa.PackageID IS NULL OR sa.PackageID = p.PackageID))
	JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID AND pat.AccountTypeID = sa.AccountTypeID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	WHERE p.CustomerID =CustomerID_
	AND sa.CustomerID =CustomerID_;
END;
/

CREATE OR REPLACE PROCEDURE CustomerBillingInfo (crCustomerBillingInfo1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
DECLARE
RTPending_ NUMERIC(18,4);
BEGIN
SELECT SUM(TotalCost) INTO RTPending_ 

FROM RateHistory 
	WHERE ChargeID IS NULL 
	AND CustomerID =CustomerID_;
OPEN crCustomerBillingInfo1 FOR SELECT CASE WHEN ma.PendingBalance + COALESCE(RTPending_,0) < 0 THEN 1 ELSE 0 END AS CreditBalance, CASE WHEN ma.OverLimit - ma.PendingBalance - COALESCE(RTPending_,0) > 0 THEN 1 ELSE 0 END AS HaveCredit, ma.OverLimit - ma.PendingBalance - COALESCE(RTPending_,0) AS CreditAmount, ma.PendingBalance + COALESCE(RTPending_,0) AS CurrentBalance, ma.PendingBalance, COALESCE(RTPending_,0) AS RealtimeAmount,
CASE WHEN bc.AutoBill = 2 THEN NULL ELSE pt.PaymentType END AS PaymentType, CASE WHEN bc.AutoBill = 2 THEN NULL ELSE pt.StringID END AS PaymentTypeStringID
FROM MasterAccounts ma, BillingCycles bc, PaymentTypes pt
	WHERE ma.CustomerID =CustomerID_ 
	AND ma.BillingCycleID = bc.BillingCycleID
	AND ma.PaymentTypeID = pt.PaymentTypeID
	AND ma.Active = 1;
END;
END;
/

CREATE OR REPLACE PROCEDURE CustomerBuyTime (crCustomerBuyTime1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,AccountID_ IN INTEGER) AS
BEGIN

OPEN crCustomerBuyTime1 FOR SELECT 0 AS Package, 2 AS LeftType, sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > sysdate AND sau.TimeLeft > 0),0) AS TimeLeft, (sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > sysdate AND sau.DataLeft > 0),0)) / 1000000.0 AS DataLeft, CAST (sa.TimeLeft AS NUMERIC(18,4)) / 60 AS HoursLeft, COALESCE(p.ExpireDate,sa.ExpireDate) AS ExpireDate, at1.AccountType, at1.StringID AS AccountTypeStringID, NULL AS PackageType, NULL AS PackageTypeStringID, ct.Amount, tc.TimeCharge, tc.StringID AS TimeChargeStringID, tc.Description, COALESCE(sa.Login,sa.Email) AS Login, sa.AccountID, NULL AS PackageID, ct.ChargeTypeID
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN TimeCharges tc ON (sa.AccountTypeID = tc.AccountTypeID)
	JOIN ChargeTypes ct ON (tc.ChargeTypeID = ct.ChargeTypeID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN ServiceGroups sgc ON (ct.ServiceGroupID = sgc.ServiceGroupID)
	LEFT JOIN ServiceGroupItems sgic ON (ct.ServiceGroupID = sgic.ServiceGroupID AND sgic.GroupID = ma.GroupID)
	WHERE ma.CustomerID =CustomerID_
	AND sa.Active = 1
	AND sa.CancelDate IS NULL
	AND ma.Active = 1
	AND tc.CustomerAccess = 1
	AND tc.SortOrder >= 0
	AND ((ct.GroupID IS NULL AND g.GlobalChargeTypes=1) OR (ct.GroupID = ma.GroupID) OR (sgic.GroupID = ma.GroupID))
	AND ((bc.AutoBill = 2 AND sa.ExpireDate IS NOT NULL AND (tc.Months IS NOT NULL OR tc.Days IS NOT NULL OR tc.Minutes IS NOT NULL)) OR (tc.TimeLeft IS NOT NULL AND sa.TimeLeft IS NOT NULL) OR (tc.DataLeft IS NOT NULL AND sa.DataLeft IS NOT NULL))
	AND (sa.PackageID IS NULL OR (sa.PackageID IS NOT NULL AND ((tc.TimeLeft IS NOT NULL AND sa.TimeLeft IS NOT NULL) OR (tc.DataLeft IS NOT NULL AND sa.DataLeft IS NOT NULL))))
	AND (AccountID_ IS NULL OR sa.AccountID =AccountID_)

UNION ALL

SELECT 1 AS Package, NULL AS LeftType, NULL AS TimeLeft, NULL AS DataLeft, NULL AS HoursLeft, p.ExpireDate, NULL AS AccountType, NULL AS AccountTypeStringID, COALESCE(pt.InvoiceDescription,pt.PackageType) AS PackageType, pt.StringID AS PackageTypeStringID, ct.Amount, tc.TimeCharge, tc.StringID AS TimeChargeStringID, tc.Description, NULL AS Login, NULL AS AccountID, p.PackageID, ct.ChargeTypeID
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Packages p ON (ma.CustomerID = p.CustomerID)
	JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN TimeCharges tc ON (p.PackageTypeID = tc.PackageTypeID)
	JOIN ChargeTypes ct ON (tc.ChargeTypeID = ct.ChargeTypeID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN ServiceGroups sgc ON (ct.ServiceGroupID = sgc.ServiceGroupID)
	LEFT JOIN ServiceGroupItems sgic ON (ct.ServiceGroupID = sgic.ServiceGroupID AND sgic.GroupID = ma.GroupID)
	WHERE ma.CustomerID =CustomerID_
	AND p.Active = 1
	AND p.CancelDate IS NULL
	AND ma.Active = 1
	AND tc.CustomerAccess = 1
	AND bc.AutoBill = 2
	AND tc.TimeLeft IS NULL
	AND tc.DataLeft IS NULL
	AND p.ExpireDate IS NOT NULL
	AND tc.SortOrder >= 0
	AND ((ct.GroupID IS NULL AND g.GlobalChargeTypes=1) OR (ct.GroupID = ma.GroupID) OR (sgic.GroupID = ma.GroupID))
	AND ((tc.Months IS NOT NULL OR tc.Days IS NOT NULL OR tc.Minutes IS NOT NULL))
	AND (AccountID_ IS NULL OR p.PackageID IN (SELECT PackageID FROM SubAccounts WHERE AccountID=AccountID_))
	AND EXISTS (SELECT * FROM SubAccounts sa WHERE sa.Active = 1 AND sa.PackageID = p.PackageID)

ORDER BY 1 DESC, 12 ASC, 10 ASC;
END;
/

CREATE OR REPLACE PROCEDURE CustomerHistory (crCustomerHistory1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
DECLARE
sd_ DATE;
BEGIN
SELECT DATEADD(dd, -120, sysdate) INTO sd_ 


 FROM DUAL;
OPEN crCustomerHistory1 FOR SELECT 0 AS SortOrder, i.CreateDate, i.InvoiceID AS HistoryID, CASE WHEN i.VoidDate IS NOT NULL THEN 0 ELSE 1 END AS HistoryType, CASE WHEN Amount < 0 THEN Amount END AS Credit, CASE WHEN Amount >= 0 THEN Amount END AS Debit,  it.InvoiceType AS Description, it.StringID, NULL AS Info, NULL AS NumInfo
FROM Invoices i, InvoiceTypes it
	WHERE CustomerID =CustomerID_
		And i.InvoiceTypeID = it.InvoiceTypeID
		And i.CreateDate > sd_
		AND i.Processed = 1
UNION ALL
SELECT 0 AS SortOrder, s.StatementDate AS CreateDate, s.StatementID AS HistoryID, 7 AS HistoryType, NULL AS Credit, NULL AS Debit, NULL AS Description, NULL AS StringID, NULL AS Info, NULL AS NumInfo
FROM Statements s
	WHERE s.CustomerID =CustomerID_
	AND s.StatementDate > sd_
UNION ALL
SELECT 0 AS SortOrder, LastModifyDate, ChargeID AS HistoryID, 3 AS HistoryType, CASE WHEN Amount < 0 THEN Amount END AS Credit, CASE WHEN Amount >= 0 THEN Amount END AS Debit, COALESCE(Login,'') || ' ' || Description AS Description, NULL AS StringID, NULL AS Info, NULL AS NumInfo
FROM Charges
	WHERE  CustomerID =CustomerID_
	AND ItemID IS NULL
	AND LastModifyDate > sd_
UNION ALL
SELECT 0 AS SortOrder, nl.CreateDate, nl.NoticeLogID, 8 AS HistoryType, NULL AS Credit, NULL AS Debit, n.Notice AS Description, NULL AS StringID, NULL AS Info, NULL AS NumInfo
FROM NoticeLogs nl LEFT JOIN Notices n ON (nl.NoticeID = n.NoticeID)
	WHERE nl.CustomerID =CustomerID_
	AND nl.AccountID IS NULL
	AND nl.CreateDate > sd_
UNION ALL
SELECT 0 AS SortOrder, p.CreateDate, p.PaymentID AS HistoryID, 4 AS HistoryType, CASE WHEN et.TransTypeID = 256 THEN NULL WHEN p.Amount >= 0 THEN p.Amount END AS Credit, CASE WHEN et.TransTypeID = 256 THEN p.Amount - p.FinalAmount WHEN p.Amount < 0 THEN p.Amount END AS Debit,
pt.PaymentType, pt.StringID, CASE WHEN p.PaymentTypeID = 4 THEN 'Check #' || p.CheckNumber ELSE et.Response END AS Info, NULL AS NumInfo
FROM Payments p JOIN PaymentTypes pt ON (p.PaymentTypeID = pt.PaymentTypeID)
	LEFT JOIN ExternalTrans et ON (p.PaymentID = et.PaymentID)
	WHERE p.CustomerID =CustomerID_
	AND p.CreateDate > sd_
UNION ALL
SELECT 0 AS SortOrder, ReqDate as CreateDate, et.ExternalTransID AS HistoryID, 5 AS HistoryType, Amount AS Credit, NULL AS Debit, CASE WHEN ts.TransStateID = 3 THEN Response ELSE ts.TransState END AS Response, NULL AS StringID, NULL AS Info, NULL AS NumInfo
FROM ExternalTrans et, TransStates ts
	WHERE et.CustomerID =CustomerID_
	AND et.TransStateID = ts.TransStateID
	AND et.ReqDate > sd_
	AND et.TransStateID IN (0,1,2,3,7)
UNION ALL
SELECT 1 AS SortOrder, rh.StartDate AS CreateDate, r.RateID AS HistoryID, 6 AS HistoryType, NULL AS Credit, SUM(TotalCost) AS Debit, MIN(r.Description) AS Description, NULL AS StringID, MIN(ri.NameShort) AS Info, CASE WHEN MIN(rr.RateRuleTypeID) = 1 THEN SUM(rh.TotalTime) ELSE SUM(rh.TotalData) END / CAST(MIN(rr.Interval) AS NUMERIC(18,4)) AS NumInfo
FROM RateHistory rh, Rates r, RateRules rr, RateIntervals ri
	WHERE rh.ChargeID IS NULL
	AND rh.RateRuleID = rr.RateRuleID
	AND rr.Interval = ri.RateIntervalID
	AND rh.RateID = r.RateID
	AND rh.CustomerID =CustomerID_
	AND (rh.TotalCost > 0 OR rh.StartDate > DATEADD(dd,-32,sysdate))
GROUP BY rh.StartDate, r.RateID, rh.RateRuleID

ORDER BY 1 DESC,2 DESC;
END;
END;
/

CREATE OR REPLACE PROCEDURE CustomerPOSItem (CustomerID_ IN INTEGER,InvoiceID_ IN INTEGER,AccountID_ IN INTEGER,PackageID_ IN INTEGER,ChargeTypeID_ IN INTEGER,Quantity_ IN INTEGER) AS
BEGIN
INSERT INTO InvoiceItems (InvoiceID,ItemType,Login,Days,Description,StartDate,EndDate,AccountID,PackageID,Amount,Quantity,TaxGroupID,AccountTypeID,ChargeTypeID,PackageTypeID)
SELECT InvoiceID_, 0, COALESCE(sa.Login,sa.Email),0,ct.Description,sysdate,sysdate,sa.AccountID,p.PackageID,ct.Amount,Quantity_ ,ct.TaxGroupID,sa.AccountTypeID,ct.ChargeTypeID,p.PackageTypeID
FROM MasterAccounts ma JOIN ChargeTypes ct ON (ChargeTypeID_ = ct.ChargeTypeID)
	LEFT JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID AND sa.AccountID =AccountID_)
	LEFT JOIN Packages p ON (ma.CustomerID = p.CustomerID AND p.PackageID =PackageID_)
	WHERE ma.Active = 1
	AND ma.CustomerID =CustomerID_
	AND Quantity_ >= 1;
END;
/

CREATE OR REPLACE PROCEDURE CustomerStatus (crCustomerStatus1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER) AS
BEGIN
DECLARE
timeused_ INTEGER;
dataused_ NUMBER(38);
timeu_ INTEGER;
datau_ NUMBER(38);
BEGIN
SELECT COALESCE(SUM(DATEDIFF(ss,CallDate,sysdate)) / 60,0),COALESCE(SUM(AcctOutputOctets),0) INTO timeused_,dataused_  FROM ServerPorts WHERE AcctStatusType = 1 AND AccountID = AccountID_;
SELECT SUM(sau.TimeLeft)  INTO timeu_ 

FROM SubAccountUsages sau 
	WHERE sau.AccountID =AccountID_
	AND sau.ExpireDate > sysdate 
	AND sau.TimeLeft > 0;
SELECT SUM(sau.DataLeft)  INTO datau_ 

FROM SubAccountUsages sau 
	WHERE sau.AccountID =AccountID_
	AND sau.ExpireDate > sysdate 
	AND sau.DataLeft > 0;
OPEN crCustomerStatus1 FOR SELECT sa.ExpireDate AS ExpireDate, 
ma.PendingBalance AS Balance, 
(SELECT et2.ExternalTransID FROM ExternalTrans et2 WHERE et2.TransStateID = 3 AND et2.ExternalTransID IN (SELECT MAX(et1.ExternalTransID) FROM ExternalTrans et1 WHERE et1.CustomerID = ma.CustomerID AND ma.PendingBalance > 0 AND et1.ReqDate > DATEADD(dd,-30,sysdate))) AS CCFail,
(SELECT SUM(et.Amount) FROM ExternalTrans et WHERE et.CustomerID = ma.CustomerID AND et.TransStateID IN (0,1,2) AND et.TransTypeID IN (32,64)) AS CCPending,
ma.PendingBalance + COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS RealtimeBalance,
ma.OverLimit, CASE WHEN bc.AutoBill = 2 THEN 0 ELSE COALESCE(ma.OverDue,0) + COALESCE(sa.Extension,0) END AS Extension,
sa.FirstName, sa.LastName, sa.LoginLimit,
CASE WHEN (sa.TimeLeft + COALESCE(timeu_,0)) - timeused_ < 60 THEN 1 ELSE 2 END AS LeftType, (sa.TimeLeft + COALESCE(timeu_,0)) - timeused_ AS TimeLeft, ((sa.DataLeft + COALESCE(datau_,0)) - dataused_)  / 1000000.0 AS DataLeft, CAST (((sa.TimeLeft + COALESCE(timeu_,0)) - timeused_)  AS NUMERIC(18,4)) / 60 AS HoursLeft, 
ma.OverLimit, 
CASE WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate
	WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate
	ELSE COALESCE(ma.CancelDate,sa.CancelDate) END AS CancelDate,
CASE WHEN ma.Active = 0 OR sa.Active = 0 THEN 0 WHEN DATEADD(dd,CASE WHEN bc.AutoBill = 2 THEN 0 ELSE COALESCE(ma.OverDue,0) + COALESCE(sa.Extension,0) END, sa.ExpireDate) < sysdate THEN 2 WHEN (sa.TimeLeft + COALESCE(timeu_,0)) - timeused_ <= 0 THEN 3 WHEN (sa.DataLeft + COALESCE(datau_,0)) - dataused_ <= 0 THEN 4 ELSE 1 END AS Status
FROM SubAccounts sa,MasterAccounts ma,BillingCycles bc
	WHERE sa.AccountID=AccountID_
	AND ma.CustomerID=sa.CustomerID
	AND ma.BillingCycleID=bc.BillingCycleID;
END;
END;
/

CREATE OR REPLACE PROCEDURE CustomerCCFailInfo (crCustomerCCFailInfo1 IN OUT ieatypes.CursorType,ExternalTransID_ IN INTEGER) AS
BEGIN
OPEN crCustomerCCFailInfo1 FOR SELECT et.ExternalTransID, et.ProcDate, et.Amount, et.Response, CASE WHEN ma.PaymentTypeID = 1 OR bc.AutoBill = 2 THEN 0 ELSE 1 END AS AutoPay
FROM ExternalTrans et, MasterAccounts ma, BillingCycles bc
	WHERE et.ExternalTransID =ExternalTransID_
	AND et.CustomerID = ma.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND et.TransStateID = 3	;
END;
/

CREATE OR REPLACE PROCEDURE CustomerCCVoid (CustomerID_ IN INTEGER) AS
BEGIN
UPDATE ExternalTrans SET TransStateID = 9 
	WHERE TransStateID = 3 
	AND ExternalTransID IN (SELECT MAX(et.ExternalTransID) FROM ExternalTrans et WHERE et.CustomerID =CustomerID_ AND et.ReqDate > DATEADD(dd,-30,sysdate));
END;
/

CREATE OR REPLACE PROCEDURE DeleteStartRecords AS
BEGIN
DELETE FROM Calls WHERE AcctStatusType = 1;
END;
/

CREATE OR REPLACE PROCEDURE DistInvoiceGet (crDistInvoiceGet1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,InvoiceID_ IN INTEGER,upgrade_ IN INTEGER) AS
BEGIN
IF (CustomerID_ IS NOT NULL) THEN
OPEN crDistInvoiceGet1 FOR SELECT CASE WHEN MIN(i.InvoiceID) =InvoiceID_ THEN 2 WHEN MIN(i.InvoiceTypeID) = 91 AND MIN(ma.PaymentTypeID) IN (8,16) AND upgrade_ = 0 THEN 0 ELSE 1 END AS Sorter, ii.ItemID, MIN(i.InvoiceID) AS InvoiceID, MIN(ItemType) AS ItemType,  MAX(ii.Amount * ii.Quantity) AS Amount, ROUND(MAX(ii.Amount * ii.Quantity),2) - COALESCE(SUM(CASE WHEN pi1.InactiveDate IS NULL THEN pi1.Amount ELSE 0 END),0) AS AmountLeft, MIN(ii.PaidAmount) AS CurrentPaidAmount, MIN(i.CreateDate) AS CreateDate
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	LEFT JOIN PaymentItems pi1 ON (pi1.ItemID = ii.ItemID)
	WHERE i.VoidDate IS NULL
	AND i.Estimate = 0
	AND i.Processed = 1
	AND (i.ChargeAmount <> i.PaidAmount OR (i.ChargeAmount = 0 AND i.InvoiceID =InvoiceID_))
	AND i.CustomerID =CustomerID_
	AND (InvoiceID_ IS NULL OR i.InvoiceID =InvoiceID_)
GROUP BY ii.ItemID
UNION ALL
SELECT CASE WHEN MIN(i.InvoiceID) =InvoiceID_ THEN 2 WHEN MIN(i.InvoiceTypeID) = 91 AND MIN(ma.PaymentTypeID) IN (8,16) AND upgrade_ = 0 THEN 0 ELSE 1 END AS Sorter, ii.ItemID, MIN(i.InvoiceID) AS InvoiceID, MIN(ItemType) AS ItemType, 0 AS Amount, 0 - COALESCE(SUM(CASE WHEN pi1.InactiveDate IS NULL THEN pi1.Amount ELSE 0 END),0) AS AmountLeft, MIN(ii.PaidAmount) AS CurrentPaidAmount, MIN(i.CreateDate) AS CreateDate
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	LEFT JOIN PaymentItems pi1 ON (pi1.ItemID = ii.ItemID)
	WHERE i.VoidDate IS NOT NULL
	AND i.Estimate = 0
	AND i.Processed = 1
	AND (i.PaidAmount <> 0 OR (i.ChargeAmount = 0 AND i.InvoiceID =InvoiceID_))
	AND i.CustomerID =CustomerID_
	AND (InvoiceID_ IS NULL OR i.InvoiceID =InvoiceID_)
GROUP BY ii.ItemID
ORDER BY 1 ASC, 8 DESC, 3 DESC, 2 DESC;
ELSE
OPEN crDistInvoiceGet1 FOR SELECT ii.ItemID, MIN(i.InvoiceID) AS InvoiceID, MIN(ItemType) AS ItemType, CASE WHEN MIN(i.VoidDate) IS NULL THEN MIN(ii.Amount * ii.Quantity) ELSE 0 END AS Amount, CASE WHEN MIN(i.VoidDate) IS NULL THEN ROUND(MIN(ii.Amount * ii.Quantity),2) ELSE 0 END - COALESCE(SUM(CASE WHEN pi1.InactiveDate IS NULL THEN pi1.Amount ELSE 0 END),0) AS AmountLeft, MIN(ii.PaidAmount) AS CurrentPaidAmount
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	LEFT JOIN PaymentItems pi1 ON (pi1.ItemID = ii.ItemID)
	WHERE i.InvoiceID =InvoiceID_
	AND i.Estimate = 0
GROUP BY ii.ItemID
ORDER BY 2 DESC, 1 DESC;
END IF;
END;
/

CREATE OR REPLACE PROCEDURE DistInvoiceUpdate (InvoiceID_ IN INTEGER) AS
BEGIN
DECLARE
CustomerID_ INTEGER;
GroupID_ INTEGER;
PaidAmount_ NUMERIC(18,4);
AutoBill_ INTEGER;
PartialMode_ INTEGER;
PartialAmount_ NUMERIC(18,4);
PartialPercent_ NUMERIC(18,4);
BEGIN

SELECT ma.CustomerID,ma.GroupID,bc.AutoBill INTO CustomerID_,GroupID_,AutoBill_ 

FROM Invoices i, MasterAccounts ma, BillingCycles bc
	WHERE i.InvoiceID =InvoiceID_
	AND i.CustomerID = ma.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID;
SELECT MAX(NumValue) INTO PartialMode_  FROM ConfigGroupData WHERE ConfigID = 603 AND GroupID = GroupID_;
SELECT MAX(NumValue) INTO PartialAmount_  FROM ConfigGroupData WHERE ConfigID = 604 AND GroupID = GroupID_;
IF (PartialMode_ IS NULL) THEN
SELECT MAX(NumValue) INTO PartialMode_  FROM Configs WHERE ConfigID = 603;
END IF;

IF (PartialAmount_ IS NULL) THEN
SELECT MAX(NumValue) INTO PartialAmount_  FROM Configs WHERE ConfigID = 604;
END IF;

IF (PartialMode_ IS NULL OR PartialMode_ = 0) THEN
SELECT 0,COALESCE(PartialAmount_,0.01) INTO PartialMode_,PartialAmount_ 

 FROM DUAL;
END IF;

IF (PartialMode_ = 1) THEN
SELECT CASE WHEN PartialAmount_ IS NULL THEN .01 WHEN PartialAmount_ BETWEEN 1 AND 100 THEN PartialAmount_/100 WHEN PartialAmount_ BETWEEN .01 AND .99 THEN PartialAmount_ END INTO PartialPercent_ 

 FROM DUAL;
END IF;

SELECT SUM(ii.PaidAmount) INTO PaidAmount_ 

FROM Invoices i, InvoiceItems ii
	WHERE i.InvoiceID = ii.InvoiceID
	AND i.InvoiceID =InvoiceID_
	AND (ii.Quantity * ii.Amount) > 0;
UPDATE Invoices SET PaidAmount = COALESCE(PaidAmount_,0) 
	WHERE InvoiceID =InvoiceID_ 
	AND PaidAmount <> COALESCE(PaidAmount_,0);
INSERT INTO diu (AccountID, ExpireDate, StartDate, EndDate)
SELECT sa.AccountID,
MAX(CASE		WHEN AutoBill_ = 1 THEN NULL 
			WHEN (ROUND(ii.Amount * ii.Quantity,2)) <= ii.PaidAmount THEN  ii.EndDate
			WHEN PartialMode_ = 0 AND ii.PaidAmount >=PartialAmount_ THEN ii.EndDate
			WHEN PartialMode_ = 1 AND ((ROUND(ii.Amount * ii.Quantity,2)) * PartialPercent_)  <= ii.PaidAmount  THEN ii.EndDate
			WHEN PartialMode_ = 2 AND ii.PaidAmount > 0 THEN  DATEADD(dd,DATEDIFF(dd,ii.StartDate,ii.EndDate) / (((ii.Amount * ii.Quantity) / (ii.PaidAmount + 0.00001)) + 0.00001),ii.StartDate)
			WHEN AutoBill_ = 0 AND sa.ExpireDate IS NULL THEN ii.StartDate
END) AS ExpireDate, MIN(ii.StartDate) AS StartDate, MAX(ii.EndDate) AS EndDate
FROM SubAccounts sa, MasterAccounts ma, Invoices i, InvoiceItems ii
	WHERE ma.CustomerID = sa.CustomerID
	AND i.CustomerID = ma.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND ii.AccountID = sa.AccountID
	AND ii.ItemType IN (2,3)
	AND ii.Canceled = 0
	AND AutoBill_ IN (0,1)
	AND i.VoidDate IS NULL
	AND ma.CustomerID =CustomerID_
	AND i.InvoiceID >=InvoiceID_
	AND i.Estimate = 0
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.PackageID IS NULL
GROUP BY sa.AccountID;
INSERT INTO diup (PackageID, ExpireDate, StartDate, EndDate)
SELECT p.PackageID,
MAX(CASE		WHEN AutoBill_ = 1 THEN NULL 
			WHEN (ROUND(ii.Amount * ii.Quantity,2)) <= ii.PaidAmount THEN  ii.EndDate
			WHEN PartialMode_ = 0 AND ii.PaidAmount >=PartialAmount_ THEN ii.EndDate
			WHEN PartialMode_ = 1 AND ((ROUND(ii.Amount * ii.Quantity,2)) * PartialPercent_)  <= ii.PaidAmount  THEN ii.EndDate
			WHEN PartialMode_ = 2 AND ii.PaidAmount > 0 THEN  DATEADD(dd,DATEDIFF(dd,ii.StartDate,ii.EndDate) / (((ii.Amount * ii.Quantity) / (ii.PaidAmount + 0.00001)) + 0.00001),ii.StartDate)
			WHEN AutoBill_ = 0 AND p.ExpireDate IS NULL THEN ii.StartDate
END) AS ExpireDate, MIN(ii.StartDate) AS StartDate, MAX(ii.EndDate) AS EndDate
FROM Packages p, SubAccounts sa, MasterAccounts ma, Invoices i, InvoiceItems ii
	WHERE ma.CustomerID = sa.CustomerID
	AND i.CustomerID = ma.CustomerID
	AND ma.CustomerID = p.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND ii.PackageID = sa.PackageID
	AND ii.ItemType IN (2,3)
	AND ii.Canceled = 0
	AND AutoBill_ IN (0,1)
	AND i.VoidDate IS NULL
	AND ma.CustomerID =CustomerID_
	AND i.InvoiceID >=InvoiceID_
	AND i.Estimate = 0
	AND ma.Active = 1
	AND sa.Active = 1
	AND p.Active = 1
	AND p.PackageID = sa.PackageID
GROUP BY p.PackageID;
MERGE INTO SubAccounts msa
USING (SELECT sa.AccountID, CASE WHEN diu.ExpireDate IS NOT NULL THEN diu.ExpireDate WHEN sa.ExpireDate >= diu.StartDate THEN DATEADD(dd,-1,diu.StartDate) WHEN AutoBill_ = 1 THEN NULL ELSE sa.ExpireDate END AS ExpireDate, CASE WHEN sa.BilledThru < diu.EndDate THEN diu.EndDate ELSE sa.BilledThru END AS BilledThru
FROM SubAccounts sa JOIN diu diu ON (sa.AccountID = diu.AccountID)) sa
ON (msa.AccountID = sa.AccountID)
WHEN MATCHED THEN UPDATE SET msa.BilledThru = sa.BilledThru, msa.ExpireDate = sa.ExpireDate;


MERGE INTO Packages mp
USING (SELECT p.PackageID, CASE WHEN diup.ExpireDate IS NOT NULL THEN diup.ExpireDate WHEN p.ExpireDate >= diup.StartDate THEN DATEADD(dd,-1,diup.StartDate) ELSE p.ExpireDate END AS ExpireDate, CASE WHEN p.BilledThru < diup.EndDate THEN diup.EndDate ELSE p.BilledThru END AS BilledThru
FROM Packages p JOIN diup diup ON (p.PackageID = diup.PackageID)) p
ON (mp.PackageID = p.PackageID)
WHEN MATCHED THEN UPDATE SET mp.BilledThru = p.BilledThru, mp.ExpireDate = p.ExpireDate;


MERGE INTO SubAccounts msa
USING (SELECT sa.AccountID, CASE WHEN diup.ExpireDate IS NOT NULL THEN diup.ExpireDate WHEN sa.ExpireDate >= diup.StartDate THEN DATEADD(dd,-1,diup.StartDate) WHEN AutoBill_ = 1 THEN NULL ELSE sa.ExpireDate END AS ExpireDate, CASE WHEN sa.BilledThru < diup.EndDate THEN diup.EndDate ELSE sa.BilledThru END AS BilledThru
FROM SubAccounts sa JOIN diup diup ON (sa.PackageID = diup.PackageID)
	WHERE sa.Active = 1) sa
ON (msa.AccountID = sa.AccountID)
WHEN MATCHED THEN UPDATE SET msa.BilledThru = sa.BilledThru, msa.ExpireDate = sa.ExpireDate;


DELETE FROM diu;
DELETE FROM diup;
END;
END;
/

CREATE OR REPLACE PROCEDURE DistPayGet (crDistPayGet1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,PaymentID_ IN INTEGER) AS
BEGIN
OPEN crDistPayGet1 FOR SELECT 1 AS IDType, p.PaymentID AS PID, MIN(COALESCE(p.FinalAmount,p.Amount)) AS Amount, COALESCE(SUM(CASE WHEN pi1.InactiveDate IS NULL THEN pi1.Amount ELSE 0 END),0) AS AmountCommit, MIN(p.DistFlag) AS DistFlag
FROM Payments p LEFT JOIN PaymentItems pi1 ON (p.PaymentID = pi1.PaymentID)
	WHERE p.CustomerID =CustomerID_
	AND (p.DistFlag = 1 OR p.PaymentID =PaymentID_)
GROUP BY p.PaymentID
UNION ALL
SELECT 2 AS IDType, c.ChargeID AS PID, CASE WHEN MIN(i2.VoidDate) IS NULL AND (MAX(i2.Estimate) IS NULL OR MAX(i2.Estimate) = 0) THEN CASE WHEN  -(MIN(c.Amount * c.Quantity))  < 0 THEN 0 ELSE -(MIN(c.Amount * c.Quantity))  END ELSE 0 END AS Amount, COALESCE(SUM(CASE WHEN pi1.InactiveDate IS NULL THEN pi1.Amount ELSE 0 END),0) AS AmountCommit, MIN(c.DistFlag) AS DistFlag
FROM Charges c LEFT JOIN PaymentItems pi1 ON (pi1.PaymentID IS NULL AND c.ChargeID = pi1.ChargeID)
	LEFT JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	LEFT JOIN InvoiceItems ii2 ON (c.ItemID = ii2.ItemID)
	LEFT JOIN Invoices i2 ON (ii2.InvoiceID = i2.InvoiceID)
	LEFT JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	WHERE c.CustomerID =CustomerID_
	AND c.DistFlag = 1
	AND c.Quantity > 0
	AND (i.Estimate IS NULL OR i.Estimate = 0)
	AND (c.Amount < 0 OR pi1.ChargeID IS NOT NULL)
GROUP BY c.ChargeID
ORDER BY 1 ASC, 2 DESC;
END;
/

CREATE OR REPLACE PROCEDURE DistPayItemAdd (PaymentID_ IN INTEGER,ChargeID_ IN INTEGER,ItemID_ IN INTEGER,Amount_ IN NUMERIC) AS
BEGIN
INSERT INTO PaymentItems (PaymentID,ChargeID,ItemID,Amount,ActiveDate) 
VALUES(PaymentID_,ChargeID_ ,ItemID_ ,Amount_ ,sysdate);
END;
/

CREATE OR REPLACE PROCEDURE ErrorHistory (crErrorHistory1 IN OUT ieatypes.CursorType,start_ IN DATE,stop_ IN DATE) AS
BEGIN

DECLARE
istart_ DATE;
istop_ DATE;
BEGIN
SELECT COALESCE(stop_,sysdate),COALESCE(start_,DATEADD(hh,-6,DATEADD(ss,-(  (DATEPART(hh,sysdate) * 3600) + (DATEPART(mi,sysdate) * 60) + DATEPART(ss,sysdate) ),sysdate))) INTO istop_,istart_ 


 FROM DUAL;
OPEN crErrorHistory1 FOR SELECT 'Scheduled task failure - ' || COALESCE(s.TaskName,'') AS Description, sl.Description AS Message, COUNT(*) AS ErrCount
FROM Schedules s Left Join ScheduleLogs sl ON sl.ScheduleID = s.ScheduleID
WHERE sl.StartDate BETWEEN istart_ AND istop_ 
	AND sl.Status = 2
GROUP BY sl.Description,  s.TaskName
UNION ALL
SELECT 'Card processing' AS Description, et.Response AS Message, COUNT(*) AS ErrCount
FROM ExternalTrans et
	WHERE TransStateID = 3
	AND ProcDate BETWEEN istart_ AND istop_
GROUP BY et.Response
UNION ALL
SELECT 'Card trans' AS Description, MIN(bp.BatchProcessor) || ' awaiting ' || CASE WHEN TransStateID = 0 THEN 'export' WHEN TransStateID =  2 THEN 'response' ELSE 'internal error' END || ' for more than 15 days' AS Message, COUNT(*) AS ErrCount
FROM ExternalTrans et, BatchProcessors bp, MasterAccounts ma
	WHERE et.TransStateID IN (0,2)
	AND et.CustomerID = ma.CustomerID
	AND ma.Active = 1
	AND et.ReqDate <= DATEADD(dd,-15,sysdate)
	AND et.BatchProcessorID = bp.BatchProcessorID
GROUP BY bp.BatchProcessorID, TransStateID
UNION ALL
SELECT 'rating charges' AS Description, MIN(r.Description) || ' is over ' || CAST(MIN(DATEDIFF(mm,rh.StartDate,sysdate)) AS VARCHAR(10)) || ' month(s) behind schedule' AS Message, COUNT(*) AS ErrCount
FROM RateHistory rh, Rates r, MasterAccounts ma, SubAccounts sa
	WHERE rh.RateID = r.RateID
	AND rh.StartDate < DATEADD(dd,-60,sysdate)
	AND rh.ChargeID IS NULL
	AND rh.TotalCost > 0
	AND rh.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
GROUP BY  r.RateID, DATEDIFF(mm,rh.StartDate,sysdate)
UNION ALL
SELECT 'CC/EFT pending against finalized payment', 'ExternalTransID ' || CAST(et.ExternalTransID AS VARCHAR(15)) || ', CustomerID ' || CAST(ma.CustomerID AS VARCHAR(15)), 1
FROM MasterAccounts ma, ExternalTrans et, Payments p
	WHERE ma.CustomerID = et.CustomerID
	AND et.PaymentID = p.PaymentID
	AND p.FinalAmount IS NOT NULL
	AND et.TransStateID = 0
	AND ma.Active = 1
UNION ALL
SELECT 'No task history for last 2 days','Is the Emerald Task Scheduler running?',1
FROM Configs
	WHERE ConfigID = 0
	AND DATEDIFF(dd,COALESCE((SELECT MAX(StartDate) FROM ScheduleLogs),sysdate),sysdate) > 2
UNION ALL
SELECT 'CC Auto Pay /w no CC number on file', 'CustomerID ' || CAST(ma.CustomerID AS VARCHAR(15)) || ' ' || ma.FirstName || ' ' || ma.LastName, 1
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN CreditCards cc ON (ma.CustomerID = cc.CustomerID)
	WHERE ma.Active = 1
	AND bc.AutoBill IN (0,1)
	AND ma.CancelDate IS NULL
	AND ma.PaymentTypeID = 8
	AND cc.CardNumber IS NULL
UNION ALL
SELECT 'EFT Auto Pay /w no bank numbers on file', 'CustomerID ' || CAST(ma.CustomerID AS VARCHAR(15)) || ' ' || ma.FirstName || ' ' || ma.LastName, 1
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN BankTrans bt ON (ma.CustomerID = bt.CustomerID)
	WHERE ma.Active = 1
	AND bc.AutoBill IN (0,1)
	AND ma.CancelDate IS NULL
	AND ma.PaymentTypeID = 16
	AND bt.ABANumber IS NULL
	AND bt.AccountNumber IS NULL
UNION ALL
SELECT 'MBR /w Email send method has no Email', 'CustomerID ' || CAST(ma.CustomerID AS VARCHAR(15)) || ' ' || ma.FirstName || ' ' || ma.LastName, 1
FROM MasterAccounts ma, SendMethods sm, PaymentTypes pt, BillingCycles bc
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.PaymentTypeID = pt.PaymentTypeID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND ma.Active = 1
	AND sm.EmailTypeID IS NOT NULL
	AND ((ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 1) OR (ma.PaymentTypeID NOT IN (8,16)))
	AND ma.Email IS NULL
	AND bc.AutoBill IN (0,1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > DATEADD(dd,-90,sysdate))
	AND NOT EXISTS (SELECT * FROM SubAccounts sa2 WHERE sa2.CustomerID = ma.CustomerID AND sa2.Active = 1 AND sa2.CancelDate IS NULL AND sa2.SendBill = 1 AND (sa2.Login IS NOT NULL OR sa2.Email IS NOT NULL))
UNION ALL
SELECT 'ES Sync ' || es.Name, ' CustomerID ' || CAST(ma.CustomerID AS VARCHAR(15)) || ' Login: ' || COALESCE(sa.Login,'N/A') || ' ' || ess.Message, ess.ErrorCount
FROM ExternalSyncs ess, SubAccounts sa, MasterAccounts ma, ExternalSystems es
	WHERE ess.ExternalSystemID = es.ExternalSystemID
	AND ess.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND ess.ErrorCount > 0
	AND ess.Message IS NOT NULL
	AND ess.LastModifyDate > DATEADD(dd,-15,sysdate)
UNION ALL
SELECT 'Syslog message' AS Description, Data AS Message, COUNT(*) AS ErrCount
FROM SysLogs
	WHERE Severity <= 3
	AND LogDate BETWEEN istart_ AND istop_
GROUP BY Data
UNION ALL
SELECT 'Emerald - ' || lm.Description AS Description, l.LogMsg AS Message, COUNT(*) AS ErrCount
FROM Logs l, LogMsgs lm
	WHERE l.LogMsgID = lm.LogMsgID
	AND lm.Severity > 3
	AND LogDate BETWEEN istart_ AND istop_
GROUP BY lm.Description, l.LogMsg
UNION ALL
SELECT 'Authentication failure - ' || rlm.Description AS Description, 'User: ' || rl.Username AS Message,  COUNT(*) AS ErrCount
FROM RadLogs rl, RadLogMsgs rlm
	WHERE rl.RadLogMsgID = rlm.RadLogMsgID
	AND LogDate BETWEEN istart_ AND istop_
	AND rlm.Severity > 0
GROUP BY rl.Username, rlm.Description
UNION ALL
SELECT 'Mail error - ' || lm.Description AS Description, l.LogDescription AS Message, COUNT(*) AS ErrCount
FROM MailLogs l, LogMsgs lm
	WHERE l.LogMsgID = lm.LogMsgID
	AND lm.Severity > 3
	AND l.LogDate BETWEEN istart_ AND istop_
GROUP BY lm.Description, l.LogDescription;
END;
END;
/

CREATE OR REPLACE PROCEDURE ExportCopy (SrcExportID_ IN INTEGER,DstExportID_ IN INTEGER) AS
BEGIN
INSERT INTO Exports (ExportID,Description,Separator,ImportKeySeparator,ImportKeyValueSeparator,QuoteString,SQLString,HeaderRow,ApproveString,AuthString,VoidString,CreditString,DeclineString,ApproveMatch,AuthMatch,VoidMatch,CreditMatch,DeclineMatch,ExportType,Filter,Lines,FormatDefault,DefaultProcessorURL,Features,Template,StageCount)
SELECT DstExportID_,Description,Separator,ImportKeySeparator,ImportKeyValueSeparator,QuoteString,SQLString,HeaderRow,ApproveString,AuthString,VoidString,CreditString,DeclineString,ApproveMatch,AuthMatch,VoidMatch,CreditMatch,DeclineMatch,ExportType,Filter,Lines,FormatDefault,DefaultProcessorURL,Features,Template,StageCount
FROM Exports
	WHERE ExportID =SrcExportID_;
INSERT INTO ExportColumns (ExportID,SortOrder,FieldName,Description,Quoted,MinSize,MaxSize,Align,Format,Padding,ExportValue,Include,TransType)
SELECT DstExportID_,SortOrder,FieldName,Description,Quoted,MinSize,MaxSize,Align,Format,Padding,ExportValue,Include,TransType
FROM ExportColumns
	WHERE ExportID =SrcExportID_;
INSERT INTO CCImportColumns (ExportID,FieldType,SortOrder,Position,Description,Quoted,FieldSize,ApproveValue,DeclineValue,ErrorValue,Line,TransType)
SELECT DstExportID_,FieldType,SortOrder,Position,Description,Quoted,FieldSize,ApproveValue,DeclineValue,ErrorValue,Line,TransType
FROM CCImportColumns
	WHERE ExportID =SrcExportID_;
END;
/

CREATE OR REPLACE PROCEDURE ExternalTransCCAdd (CustomerID_ IN INTEGER,BatchProcessorID_ IN INTEGER,BatchID_ IN INTEGER,InvoiceID_ IN INTEGER,AuthOnly_ IN INTEGER,Amount_ IN NUMERIC,LastModifyUser_ IN VARCHAR2,AccountNumber_ IN VARCHAR2,AccountExpire_ IN DATE,AuthName_ IN VARCHAR2,AuthAddress_ IN VARCHAR2,AuthStateID_ IN INTEGER,AuthZip_ IN VARCHAR2,AuthSecurityCode_ IN VARCHAR2) AS
BEGIN
INSERT INTO ExternalTrans (CustomerID,BatchProcessorID,BatchID,InvoiceID,TransStateID,TransTypeID,ReqDate,Amount,LastModifyDate,LastModifyUser,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthStateID,AuthZip,AuthSecurityCode,LastRebatchTry)
VALUES(CustomerID_,BatchProcessorID_ ,BatchID_ ,InvoiceID_ ,0,CASE WHEN AuthOnly_ = 1 THEN 16 ELSE 64 END,sysdate,Amount_ ,sysdate,LastModifyUser_ ,AccountNumber_ ,AccountExpire_ ,AuthName_ ,AuthAddress_ ,AuthStateID_ ,AuthZip_ ,AuthSecurityCode_ ,sysdate);
UPDATE ExternalTrans SET TransStateID = 9 
	WHERE CustomerID =CustomerID_
	AND TransStateID = 3
	AND TransTypeID IN (16,32,64)
	AND AutoBill = 1;
END;
/

CREATE OR REPLACE PROCEDURE ExternalTransEFTAdd (CustomerID_ IN INTEGER,BatchProcessorID_ IN INTEGER,BatchID_ IN INTEGER,InvoiceID_ IN INTEGER,AuthOnly_ IN INTEGER,Amount_ IN NUMERIC,LastModifyUser_ IN VARCHAR2,AccountNumber_ IN VARCHAR2,BankNumber_ IN VARCHAR2,AuthName_ IN VARCHAR2,BankName_ IN VARCHAR2,BankPhone_ IN VARCHAR2,BankTransType_ IN VARCHAR2,SSN_ IN VARCHAR2,DLNumber_ IN VARCHAR2,DLState_ IN VARCHAR2,BirthDate_ IN DATE) AS
BEGIN
INSERT INTO ExternalTrans (CustomerID,BatchProcessorID,BatchID,InvoiceID,TransStateID,TransTypeID,ReqDate,Amount,LastModifyDate,LastModifyUser,AccountNumber,BankNumber,AuthName,BankName,BankPhone,BankTransType,SSN,DLNumber,DLState,BirthDate,LastRebatchTry)
VALUES(CustomerID_,BatchProcessorID_ ,BatchID_ ,InvoiceID_ ,0,CASE WHEN AuthOnly_ = 1 THEN 16 ELSE 64 END,sysdate,Amount_ ,sysdate,LastModifyUser_ ,AccountNumber_ ,BankNumber_ ,AuthName_ ,BankName_ ,BankPhone_ ,BankTransType_ ,SSN_ ,DLNumber_ ,DLState_ ,BirthDate_ ,sysdate);
UPDATE ExternalTrans SET TransStateID = 9
	WHERE CustomerID =CustomerID_
	AND TransStateID = 3
	AND TransTypeID IN (16,32,64)
	AND AutoBill = 1;
END;
/

CREATE OR REPLACE PROCEDURE ExternalTransImport (CustomerID_ IN INTEGER) AS
BEGIN
UPDATE IEALocks SET RefCount = RefCount + 1 WHERE IEALockID = 1;

IF (CustomerID_ IS NOT NULL) THEN
UPDATE ExternalTrans SET TransStateID = 9
	WHERE ExternalTransID IN (SELECT ExternalTransID FROM ExternalTrans et, CreditCards cc
		WHERE et.CustomerID = cc.CustomerID
		AND et.AutoBill = 1
		AND et.TransTypeID IN (16,32,64)
		AND et.TransStateID = 3
		AND et.ProcDate < cc.LastModifyDate
		AND et.CustomerID =CustomerID_
		UNION ALL
		SELECT ExternalTransID FROM ExternalTrans et, BankTrans bt
			WHERE et.CustomerID = bt.CustomerID
			AND et.AutoBill = 1
			AND et.TransTypeID IN (16,32,64)
			AND et.TransStateID = 3
			AND et.ProcDate < bt.LastModifyDate
			AND et.CustomerID =CustomerID_);
UPDATE ExternalTrans SET TransStateID = 0, LastRebatchTry = sysdate, RebatchTries = COALESCE(RebatchTries,0) + 1
	WHERE ExternalTransID IN (SELECT et.ExternalTransID 
		FROM ExternalTrans et, BatchProcessors bp
		WHERE et.BatchProcessorID = bp.BatchProcessorID
		AND et.LastModifyDate <= sysdate
		AND et.TransStateID = 3
		AND et.AutoBill = 1
		AND DATEADD(dd,bp.RebatchInterval,LastRebatchTry) <= sysdate
		AND (et.RebatchTries IS NULL OR et.RebatchTries < bp.RebatchTries)
		AND bp.RebatchTries IS NOT NULL 
		AND bp.RebatchTries > 0
		AND bp.RebatchInterval IS NOT NULL 
		AND bp.RebatchInterval > 0
		AND et.CustomerID =CustomerID_);
INSERT INTO etisum (CustomerID,Amount)
SELECT ma.CustomerID, CASE WHEN MIN(ma.PendingBalance) < SUM(i.ChargeAmount - i.PaidAmount) THEN MIN(ma.PendingBalance) ELSE SUM(i.ChargeAmount - i.PaidAmount) END - COALESCE((SELECT SUM(Amount) FROM ExternalTrans et WHERE et.CustomerID=ma.CustomerID AND (NOT(et.TransTypeID IN (16,32,64) AND et.TransStateID = 3 AND et.AutoBill = 0)) AND ((et.TransTypeID IN (16,32,64) AND et.TransStateID IN (0,1,2,3,7)) OR (et.TransTypeID = 16 AND et.TransStateID = 4)) ) ,0)
FROM MasterAccounts ma, Invoices i, BillingCycles bc
	WHERE ma.CustomerID = i.CustomerID
	AND ma.Active = 1
	AND ma.PaymentTypeID IN (8,16)
	AND i.VoidDate IS NULL
	AND i.ChargeAmount > 0
	AND i.Estimate = 0
	AND i.Processed = 1
	AND ma.BillingCycleID = bc.BillingCycleID
	AND bc.AutoBill IN (0,1)
	AND i.PaidAmount < i.ChargeAmount
	AND i.InvoiceTypeID IN (1,2,3,4,5,9,50,90)
	AND (ma.TransHoldDate IS NULL OR ma.TransHoldDate < sysdate)
	AND (bc.TBillDays IS NULL OR COALESCE((SELECT DATEADD(dd,-(bc.TBillDays),MIN(StartDate)) FROM InvoiceItems ii WHERE i.InvoiceID = ii.InvoiceID AND ItemType = 3),DATEADD(dd,-1,sysdate)) < sysdate)
	AND ma.CustomerID =CustomerID_
GROUP BY ma.CustomerID;
ELSE
UPDATE ExternalTrans SET TransStateID = 9
	WHERE ExternalTransID IN (SELECT ExternalTransID FROM ExternalTrans et, CreditCards cc
		WHERE et.CustomerID = cc.CustomerID
		AND et.AutoBill = 1
		AND et.TransTypeID IN (16,32,64)
		AND et.TransStateID = 3
		AND et.ProcDate < cc.LastModifyDate
		UNION ALL
		SELECT ExternalTransID FROM ExternalTrans et, BankTrans bt
			WHERE et.CustomerID = bt.CustomerID
			AND et.AutoBill = 1
			AND et.TransTypeID IN (16,32,64)
			AND et.TransStateID = 3
			AND et.ProcDate < bt.LastModifyDate);
UPDATE ExternalTrans SET TransStateID = 0, LastRebatchTry = sysdate, RebatchTries = COALESCE(RebatchTries,0) + 1
	WHERE ExternalTransID IN (SELECT et.ExternalTransID 
		FROM ExternalTrans et, BatchProcessors bp
		WHERE et.BatchProcessorID = bp.BatchProcessorID
		AND et.LastModifyDate <= sysdate
		AND et.TransStateID = 3
		AND et.AutoBill = 1
		AND DATEADD(dd,bp.RebatchInterval,LastRebatchTry) <= sysdate
		AND (et.RebatchTries IS NULL OR et.RebatchTries < bp.RebatchTries)
		AND bp.RebatchTries IS NOT NULL 
		AND bp.RebatchTries > 0
		AND bp.RebatchInterval IS NOT NULL 
		AND bp.RebatchInterval > 0);
INSERT INTO etisum (CustomerID,Amount)
SELECT ma.CustomerID, CASE WHEN MIN(ma.PendingBalance) < SUM(i.ChargeAmount - i.PaidAmount) THEN MIN(ma.PendingBalance) ELSE SUM(i.ChargeAmount - i.PaidAmount) END - COALESCE((SELECT SUM(Amount) FROM ExternalTrans et WHERE et.CustomerID=ma.CustomerID AND (NOT(et.TransTypeID IN (16,32,64) AND et.TransStateID = 3 AND et.AutoBill = 0)) AND ((et.TransTypeID IN (16,32,64) AND et.TransStateID IN (0,1,2,3,7)) OR (et.TransTypeID = 16 AND et.TransStateID = 4)) ) ,0)
FROM MasterAccounts ma, Invoices i, BillingCycles bc
	WHERE ma.CustomerID = i.CustomerID
	AND ma.Active = 1
	AND ma.PaymentTypeID IN (8,16)
	AND i.VoidDate IS NULL
	AND i.ChargeAmount > 0
	AND i.Estimate = 0
	AND i.Processed = 1
	AND ma.BillingCycleID = bc.BillingCycleID
	AND bc.AutoBill IN (0,1)
	AND i.PaidAmount < i.ChargeAmount
	AND i.InvoiceTypeID IN (1,2,3,4,5,9,50,90)
	AND (ma.TransHoldDate IS NULL OR ma.TransHoldDate < sysdate)
	AND (bc.TBillDays IS NULL OR COALESCE((SELECT DATEADD(dd,-(bc.TBillDays),MIN(StartDate)) FROM InvoiceItems ii WHERE i.InvoiceID = ii.InvoiceID AND ItemType = 3),DATEADD(dd,-1,sysdate)) < sysdate)
GROUP BY ma.CustomerID;
END IF;

DELETE FROM etisum WHERE Amount <= 0;
MERGE INTO etisum mi
USING (SELECT ma.CustomerID, bp.BatchProcessorID
FROM MasterAccounts ma,etisum i, Groups g, BatchProcessors bp, CardTypes ct, Exports e, CreditCards cc
	WHERE ma.GroupID = g.GroupID
	AND bp.GroupID = g.GroupID
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND e.ExportType IN (1,2,5)
	AND cc.CardTypeID = ct.CardTypeID
	AND cc.CardLength IN (ct.Length1,ct.Length2)
	AND BITAND(bp.CardTypes,ct.CardTypeID) = ct.CardTypeID
	AND ma.Active = 1
	AND ma.PaymentTypeID = 8
	AND ma.CustomerID = i.CustomerID
	AND ma.CustomerID = cc.CustomerID
	AND i.BatchProcessorID IS NULL) i
ON (mi.CustomerID = i.CustomerID)
WHEN MATCHED THEN UPDATE SET mi.BatchProcessorID = i.BatchProcessorID;

MERGE INTO etisum mi
USING (SELECT ma.CustomerID, bp.BatchProcessorID
FROM MasterAccounts ma,etisum i, Groups g, BatchProcessors bp, CardTypes ct, Exports e, CreditCards cc
	WHERE ma.GroupID = g.GroupID
	AND (((g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL) AND bp.GroupID IS NULL) OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND e.ExportType IN (1,2,5)
	AND cc.CardTypeID = ct.CardTypeID
	AND cc.CardLength IN (ct.Length1,ct.Length2)
	AND BITAND(bp.CardTypes,ct.CardTypeID) = ct.CardTypeID
	AND ma.Active = 1
	AND ma.PaymentTypeID = 8
	AND ma.CustomerID = i.CustomerID
	AND ma.CustomerID = cc.CustomerID
	AND i.BatchProcessorID IS NULL) i
ON (mi.CustomerID = i.CustomerID)
WHEN MATCHED THEN UPDATE SET mi.BatchProcessorID = i.BatchProcessorID;

MERGE INTO etisum mi
USING (SELECT ma.CustomerID, bp.BatchProcessorID
FROM MasterAccounts ma,etisum i, Groups g, BatchProcessors bp, Exports e
	WHERE ma.GroupID = g.GroupID
	AND bp.GroupID = g.GroupID
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND ((ma.PaymentTypeID = 8 AND e.ExportType IN (1,2,5) AND BITAND(bp.CardTypes,256) = 256) OR (ma.PaymentTypeID = 16 AND e.ExportType IN (4,6)))
	AND ma.Active = 1
	AND ma.CustomerID = i.CustomerID
	AND i.BatchProcessorID IS NULL) i
ON (mi.CustomerID = i.CustomerID)
WHEN MATCHED THEN UPDATE SET mi.BatchProcessorID = i.BatchProcessorID;

MERGE INTO etisum mi
USING (SELECT ma.CustomerID, bp.BatchProcessorID
FROM MasterAccounts ma,etisum i, Groups g, BatchProcessors bp, Exports e
	WHERE ma.GroupID = g.GroupID
	AND (((g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL) AND bp.GroupID IS NULL) OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND ((ma.PaymentTypeID = 8 AND e.ExportType IN (1,2,5) AND BITAND(bp.CardTypes,256) = 256) OR (ma.PaymentTypeID = 16 AND e.ExportType IN (4,6)))
	AND ma.Active = 1
	AND ma.CustomerID = i.CustomerID
	AND i.BatchProcessorID IS NULL) i
ON (mi.CustomerID = i.CustomerID)
WHEN MATCHED THEN UPDATE SET mi.BatchProcessorID = i.BatchProcessorID;

DELETE FROM etisum WHERE BatchProcessorID IS NULL;
DELETE FROM etisum WHERE CustomerID IN (SELECT et.CustomerID
FROM etisum i, ExternalTrans et
	WHERE i.CustomerID = et.CustomerID
	AND et.TransStateID = 9
	AND et.LastModifyDate > DATEADD(hh,-3,sysdate)
	AND et.Amount = i.Amount);
INSERT INTO ExternalTrans (AutoBill,CustomerID,BatchProcessorID,BatchID,InvoiceID,Response,TransStateID,TransTypeID,ReqDate,Amount,LastModifyDate,LastModifyUser,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthZip,AuthSecurityCode,LastRebatchTry)
SELECT 1,ma.CustomerID, bp.BatchProcessorID, NULL, NULL, CASE WHEN DATEADD(mm,1,cc.ExpirationDate) < sysdate THEN 'Card expired' ELSE NULL END, CASE WHEN DATEADD(mm,1,cc.ExpirationDate) < sysdate THEN 3 WHEN pp.ConfirmTrans = 1 THEN 1 ELSE 0 END, 64, sysdate, i.Amount, sysdate, 'CC Auto Bill',cc.CardNumber,cc.ExpirationDate,cc.CardHolder,cc.BillToAddress1,cc.BillToZip,cc.SecurityCode,sysdate
FROM MasterAccounts ma,etisum i, CreditCards cc, BatchProcessors bp, Exports e, PayPeriods pp
	WHERE ma.CustomerID = i.CustomerID
	AND ma.CustomerID = cc.CustomerID
	AND ma.PayPeriodID = pp.PayPeriodID
	AND cc.CardNumber IS NOT NULL
	AND i.BatchProcessorID = bp.BatchProcessorID
	AND bp.ExportID = e.ExportID
	AND ma.Active = 1
	AND ma.PendingBalance >= i.Amount
	AND e.ExportType IN (1,2,5);
INSERT INTO ExternalTrans (AutoBill,CustomerID,BatchProcessorID,BatchID,InvoiceID,TransStateID,TransTypeID,ReqDate,Amount,LastModifyDate,LastModifyUser,AccountNumber,AuthName,BankName,BankNumber,BankPhone,BankTransType,SSN,DLNumber,DLState,BirthDate,LastRebatchTry)
SELECT 1,ma.CustomerID, bp.BatchProcessorID, NULL, NULL, CASE WHEN pp.ConfirmTrans = 1 THEN 1 ELSE 0 END, 64, sysdate, i.Amount, sysdate, 'ACH Auto Bill', bt.AccountNumber, bt.AuthName, bt.BankName, bt.ABANumber, bt.BankPhone, bt.TransType, bt.SSN, bt.DLNumber, bt.DLState, bt.BirthDate,sysdate
FROM MasterAccounts ma,etisum i, BankTrans bt, BatchProcessors bp, Exports e, PayPeriods pp
	WHERE ma.CustomerID = i.CustomerID
	AND ma.CustomerID = bt.CustomerID
	AND ma.PayPeriodID = pp.PayPeriodID
	AND i.BatchProcessorID = bp.BatchProcessorID
	AND bp.ExportID = e.ExportID
	AND ma.Active = 1
	AND ma.PendingBalance >= i.Amount
	AND bt.ABANumber IS NOT NULL
	AND bt.AccountNumber IS NOT NULL
	AND e.ExportType IN (4,6);
DELETE FROM etisum;
END;
/

CREATE OR REPLACE PROCEDURE FTSEnabled (crFTSEnabled1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crFTSEnabled1 FOR SELECT 0 AS Enabled
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE FTSIndex (crFTSIndex1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crFTSIndex1 FOR SELECT 0 AS Enabled
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE History (crHistory1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,backmonths_ IN INTEGER,showtype_ IN INTEGER) AS
BEGIN
DECLARE
sd_ DATE;
BEGIN
SELECT DATEADD(mm,-(COALESCE(backmonths_,120)),sysdate) INTO sd_ 


 FROM DUAL;
OPEN crHistory1 FOR SELECT i.CreateDate, 'Invoice' as Type, Amount, it.InvoiceType AS Description,  InvoiceID as ID,
 'invoice_detail.ews?CustomerID=' || CAST(CustomerID_ AS VARCHAR(16)) || '&InvoiceID=' || CAST(InvoiceID AS VARCHAR(16)) AS URL, CASE WHEN i.VoidDate IS NOT NULL THEN 'inactive' ELSE 'active' END AS bgcolor, i.LastModifyUser AS Operator
FROM Invoices i, InvoiceTypes it
WHERE BITAND(showtype_,2) = 2
	AND CustomerID =CustomerID_
	AND i.InvoiceTypeID = it.InvoiceTypeID
	AND i.CreateDate > sd_
UNION ALL
SELECT i.VoidDate AS CreateDate, 'Invoice' as Type, Amount,  'Invoice #' || CAST(i.InvoiceID AS VARCHAR(16)) || '  VOID' AS Description,
	 InvoiceID as ID, 'invoice_detail.ews?CustomerID=' || CAST(CustomerID_ AS VARCHAR(16)) || '&InvoiceID=' || CAST(InvoiceID AS VARCHAR(16)) as URL, 'inactive' AS bgcolor, i.LastModifyUser AS Operator
FROM Invoices i, InvoiceTypes it
WHERE BITAND(showtype_,2) = 2
	AND CustomerID =CustomerID_
	AND i.InvoiceTypeID = it.InvoiceTypeID
	AND i.VoidDate > sd_
	AND i.VoidDate IS NOT NULL
UNION ALL
Select s.StatementDate as CreateDate, 'Statement' as Type, EndBal as Amount,  
'' AS Description, StatementID as ID, 'statement_detail.ews?CustomerID=' || CAST(CustomerID_ AS VARCHAR(16)) || '&StatementID=' || CAST(StatementID AS VARCHAR(16)) as URL, 'active' AS bgcolor, NULL AS Operator
From Statements s
Where BITAND(showtype_,2) = 2
	and CustomerID =CustomerID_
	and s.StatementDate > sd_
UNION ALL
SELECT i.CreateDate, 'Incident', 0, COALESCE(CAST(i.Summary AS VARCHAR(128)),CAST(i.Description AS VARCHAR(128))), IncidentID,
'incident_detail.ews?CustomerID=' || CAST(CustomerID_ AS VARCHAR(16)) || '&IncidentID=' || CAST(i.IncidentID AS VARCHAR(16)) || '&AccountID=' || CAST(s.AccountID AS VARCHAR(16))  as URL,
COALESCE(is1.Style,CASE WHEN is1.StatOpen=1 AND is1.StatEscalate=1 THEN 'escalated' WHEN is1.StatOpen=1 AND is1.StatWait=0 AND i.DueDate < sysdate THEN 'pastdue' WHEN is1.StatOpen=1 THEN 'open' WHEN is1.StatArchive=1 THEN 'archived' WHEN is1.StatBlock=1 THEN 'blocking' WHEN is1.StatOpen=0 THEN 'closed' ELSE 'normal' END) AS bgcolor, COALESCE(o.Operator, i.LastModifyUser) AS Operator
From Incidents i JOIN SubAccounts s ON (i.AccountID = s.AccountID)
	JOIN IncidentStates is1 ON (i.IncidentStateID = is1.IncidentStateID)
	LEFT JOIN Operators o ON (i.CreateOperatorID = o.OperatorID)
	Where BITAND(showtype_,1) = 1
	and s.CustomerID =CustomerID_
	and i.CreateDate > sd_
UNION ALL
SELECT a.CreateDate, 'Action', 0, CAST(a.Description AS VARCHAR(128)), ActionID,
'incident_detail.ews?CustomerID=' || CAST(CustomerID_ AS VARCHAR(16)) || '&IncidentID=' || CAST(i.IncidentID AS VARCHAR(16)) || '&AccountID=' || CAST(s.AccountID AS VARCHAR(16))  AS URL,
'' AS bgcolor, COALESCE(o.Operator,a.LastModifyUser) AS Operator
From Actions a JOIN Incidents i ON (a.IncidentID = i.IncidentID)
	JOIN SubAccounts s ON (i.AccountID = s.AccountID)
	LEFT JOIN Operators o ON (a.CreateOperatorID = o.OperatorID)
	Where BITAND(showtype_,1) = 1
	and s.CustomerID =CustomerID_
	AND CAST(a.Description AS VARCHAR(1)) IS NOT NULL
	and a.CreateDate > sd_
UNION  ALL
Select LastModifyDate, 'Adjustment', Quantity * Amount AS Amount, 
Description || CASE WHEN Login IS NOT NULL THEN ' (' || Login || ')' ELSE '' END AS Description, ChargeID, 
CASE WHEN ItemID IS NOT NULL THEN 'none' ELSE 'mbr_adjustment_edit.ews?CustomerID=' || CAST(CustomerID_ AS VARCHAR(16)) || '&ChargeID=' || CAST(ChargeID AS VARCHAR(16)) END  AS URL, '' AS bgcolor, COALESCE(Operator,LastModifyUser) AS Operator
From Charges
Where BITAND(showtype_,2) = 2
	and CustomerID =CustomerID_
    AND ItemID IS NULL
    and LastModifyDate > sd_
UNION ALL
SELECT DISTINCT p.CreateDate, 'Payment', COALESCE(p.FinalAmount,p.Amount) AS Amount,
CASE WHEN p.PaymentTypeID = 4 THEN pt.PaymentType || '# ' || COALESCE(p.CheckNumber,'') || '  ' || COALESCE(p.PayInfo,'') ELSE pt.PaymentType || '  ' || COALESCE(PayInfo,'') END AS Description, p.PaymentID,
CASE WHEN p.PaymentTypeID IN (8,16) AND e.ExportID IS NOT NULL AND et.AccountNumber IS NOT NULL AND p.FinalAmount IS NULL THEN 'mbr_payment_credit.ews?CustomerID=' || CAST(CustomerID_ AS VARCHAR(16)) || '&PaymentID=' || CAST(p.PaymentID AS VARCHAR(16))
WHEN p.PaymentTypeID IN (2,4,64,128,256,512,1024,2048,4096,8192,16384,32768) AND p.FinalAmount IS NULL THEN 'mbr_payment_edit.ews?CustomerID=' || CAST(CustomerID_ AS VARCHAR(16)) || '&PaymentID=' || CAST(p.PaymentID AS VARCHAR(16))
ELSE 'javascript:newwin4(''print_receipt.ews?headertype=17&PaymentID=' || CAST(p.PaymentID AS VARCHAR(16)) || ''',720, w=screen.height*.8)' END AS URL, NULL AS bgcolor, p.LastModifyUser AS Operator
FROM Payments p JOIN PaymentTypes pt ON (p.PaymentTypeID = pt.PaymentTypeID)
	LEFT JOIN ExternalTrans et ON (p.PaymentID = et.PaymentID AND et.TransStateID = 4 AND et.ProcTransID IS NOT NULL AND et.ProcTransID = p.ProcTransID)
	LEFT JOIN BatchProcessors bp ON (et.BatchProcessorID = bp.BatchProcessorID)
	LEFT JOIN Exports e ON (bp.ExportID = e.ExportID AND BITAND(e.Features,8) = 8)
	WHERE BITAND(showtype_,2) = 2
	AND p.CustomerID =CustomerID_
	AND p.CreateDate > sd_
UNION ALL
Select ReqDate as CreateDate, 'ETrans (' || tt.TransType || ')', Amount, CASE WHEN et.TransStateID = 9 THEN 'VOID - ' ELSE '' END || et.Response AS Response, ExternalTransID, 
	CASE WHEN et.TransStateID IN (0, 2) THEN 
'Javascript:ask(''Void this Etrans?'',''mbr_etrans_void.ews?CustomerID=' || CAST(CustomerID_ AS VARCHAR(16)) || '&ExternalTransID=' || CAST(ExternalTransID AS VARCHAR(16)) || ''')' 
		ELSE 'none' END  as URL, 
CASE WHEN et.TransStateID = 4 THEN 'good' WHEN et.TransStateID = 3 THEN 'bad' WHEN et.TransStateID IN (7,8,9) THEN 'inactive' ELSE 'active' END AS bgcolor, et.LastModifyUser AS Operator
From ExternalTrans et, TransStates ts, TransTypes tt
Where BITAND(showtype_,4) = 4
	and CustomerID =CustomerID_
	AND et.TransStateID = ts.TransStateID
	AND et.TransTypeID = tt.TransTypeID
	and ReqDate > sd_
UNION ALL
SELECT nl.CreateDate, 'Emailed Notice', 0, COALESCE(n.Notice,'N/A'), nl.NoticeLogID, 'none' AS URL, '' AS bgcolor, NULL AS Operator
FROM NoticeLogs nl LEFT JOIN Notices n ON (nl.NoticeID = n.NoticeID)
WHERE BITAND(showtype_,8) = 8
	and nl.CustomerID =CustomerID_
	AND nl.AccountID IS NULL
	AND nl.CreateDate > sd_
UNION ALL
SELECT nl.CreateDate, 'Emailed Notice', 0, COALESCE(n.Notice,'N/A'), nl.NoticeLogID, 'none' AS URL, '' AS bgcolor, NULL AS Operator
FROM NoticeLogs nl JOIN SubAccounts sa ON (nl.AccountID = sa.AccountID) LEFT JOIN Notices n ON (nl.NoticeID = n.NoticeID)
WHERE BITAND(showtype_,8) = 8
	and nl.CustomerID IS NULL
	AND nl.CreateDate > sd_
	AND sa.CustomerID =CustomerID_
UNION ALL
SELECT ml.LogDate, lm.Description as Type, 0 as Amount, LogDescription as Description, 0 as ID, 'none' AS URL, '' AS bgcolor, NULL AS Operator
FROM MailLogs ml, LogMsgs lm
WHERE BITAND(showtype_,8) = 8
	and ml.LogMsgID = lm.LogMsgID
	AND ml.CustomerID =CustomerID_
	AND ml.LogDate > sd_
UNION ALL

SELECT l.LogDate, lm.Description as Type, 0 as Amount, LogMsg AS Description, 0 as ID, 'none' AS URL, '' AS bgcolor, l.Operator
FROM Logs l, LogMsgs lm
WHERE BITAND(showtype_,8) = 8
	and l.LogMsgID = lm.LogMsgID
	AND l.CustomerID =CustomerID_
	AND l.LogDate > sd_
UNION ALL
SELECT l.LogDate, lm.Description as Type, 0 as Amount, LogMsg AS Description, 0 as ID, 'none' AS URL, '' AS bgcolor, l.Operator
FROM AuditLogs l, LogMsgs lm
WHERE BITAND(showtype_,8) = 8
	and l.LogMsgID = lm.LogMsgID
	AND l.CustomerID =CustomerID_
	AND l.LogDate > sd_

ORDER BY 1 DESC;
END;
END;
/

CREATE OR REPLACE PROCEDURE IISExport (crIISExport1 IN OUT ieatypes.CursorType,esid_ IN INTEGER,filemode_ IN INTEGER) AS
BEGIN
DECLARE
incremental_ INTEGER;
port_ INTEGER;
ipaddress_ INTEGER;
hostname_ INTEGER;
description_ INTEGER;
homedir_ INTEGER;
BEGIN
SELECT CASE WHEN filemode_ = 1 THEN 1 WHEN filemode_ = 2 THEN 0 ELSE 1 END INTO incremental_ 


 FROM DUAL;
SELECT 1000,8,10,1001,2 INTO port_,hostname_,ipaddress_,description_,homedir_ 


 FROM DUAL;
OPEN crIISExport1 FOR SELECT sa.AccountID, CASE WHEN ma.Active = 1 AND sa.Active = 1 THEN 1 ELSE 0 END AS Active, 
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID =homedir_) AS Path,
at1.AccountType,
COALESCE((SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID =description_),ma.Company || ' (' || CAST(sa.AccountID AS VARCHAR(16)) || ')',sa.FirstName || ' ' || sa.LastName || ' (' || CAST(sa.AccountID AS VARCHAR(16)) || ')') AS Description,
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID =port_) AS Port,
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID =hostname_) AS Hostname,
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID =ipaddress_) AS IPAddress
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1, ExternalSystemAccountTypes esat, ExternalSystems es
WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID = es.ExternalSystemID
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND es.ExternalSystemID =esid_
	AND (es.LastSyncDate IS NULL OR ma.LastModifyDate > es.LastSyncDate OR sa.LastModifyDate > es.LastSyncDate)
	AND (SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID =homedir_) IS NOT NULL
	AND (SELECT COUNT(*) FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND sad.AccountDataTypeID IN (port_,ipaddress_ ,hostname_ ) AND sad.Data <> ' ') > 0;
END;
END;
/

CREATE OR REPLACE PROCEDURE IMailSetUser (esid_ IN INTEGER,username_ IN VARCHAR2,domain_ IN VARCHAR2,attribute_ IN VARCHAR2,value_ IN VARCHAR2) AS
BEGIN
DECLARE
DomainID_ INTEGER;
AccountID_ INTEGER;
DataTypeID_ INTEGER;
nid_ INTEGER;
oldpassword_ VARCHAR2(32);
BEGIN
SELECT MAX(DomainID) INTO DomainID_  FROM Domains WHERE MailDomain = domain_;
IF (DomainID_ IS NOT NULL) THEN
SELECT MAX(sa.AccountID) INTO AccountID_ 

FROM SubAccounts sa, MasterAccounts ma, AccountTypes at1, ExternalSystemAccountTypes esat
	WHERE sa.CustomerID = ma.CustomerID 
	AND sa.Password <> ' '
	AND sa.Password IS NOT NULL
	AND ma.Active = 1
	AND sa.Active = 1
	AND ((sa.Login =username_ AND sa.DomainID =DomainID_) 
		OR (username_ || '@' || domain_ = sa.Email))
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =esid_;
END IF;

IF (AccountID_ IS NOT NULL) THEN
IF (attribute_ = 'MaxSize') THEN
SELECT 3 INTO DataTypeID_ 

 FROM DUAL;
ELSIF (attribute_ = 'Password' AND value_ IS NOT NULL AND DATALENGTH(value_) > 3) THEN
SELECT Password INTO oldpassword_  FROM SubAccounts WHERE AccountID = AccountID_;
	UPDATE SubAccounts SET Password =value_ WHERE AccountID =AccountID_;
ELSIF (attribute_ IS NOT NULL) THEN
SELECT MAX(AccountDataTypeID) INTO DataTypeID_ 

	FROM AccountDataTypes adt 
		WHERE AccountDataTypeID BETWEEN 900 AND 999
		AND AccountDataType  =attribute_;
END IF;

IF (DataTypeID_ IS NOT NULL) THEN
	UPDATE SubAccountData SET Data =value_ WHERE AccountID =AccountID_ AND AccountDataTypeID =DataTypeID_;
IF (SQL%ROWCOUNT = 0) THEN
		INSERT INTO SubAccountData (AccountID,AccountDataTypeID,Data)
		VALUES(AccountID_,DataTypeID_ ,value_ );
END IF;
END IF;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE IMailUsers (crIMailUsers1 IN OUT ieatypes.CursorType,esid_ IN INTEGER,username_ IN VARCHAR2,domain_ IN VARCHAR2) AS
BEGIN
DECLARE
DomainID_ INTEGER;
AccountID_ INTEGER;
BEGIN
SELECT MAX(DomainID) INTO DomainID_  FROM Domains WHERE MailDomain = domain_;
IF (username_ IS NULL) THEN
OPEN crIMailUsers1 FOR SELECT sa.AccountID, 
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%___%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE username_ END AS Login,
sa.Password, sa.FirstName || ' ' || sa.LastName AS Name,
CASE WHEN sa.Email IS NULL OR sa.Email = ' ' THEN sa.Login || '@' || domain_ WHEN sa.Email <> ' ' THEN sa.Email ELSE NULL END AS MailAddress,
adt900.Data AS UserDir,
adt901.Data AS NumTries,
adt902.Data AS AttemptTime,
adt903.Data AS NumTimesSuspended,
adt904.Data AS LastLogin,
adt905.Data AS SuspendUserAccount,
adt906.Data AS ICalEnable,
adt907.Data AS SpellEnable,
adt908.Data AS NoOfSuggestions,
adt909.Data AS Depth,
adt910.Data AS Options,
adt911.Data AS SpellChecking,
adt912.Data AS PreviewSize,
adt913.Data AS ConfirmOnDelete,
adt914.Data AS DisplayCompletedTasks,
adt915.Data AS EntryGranularity,
adt916.Data AS StartTime,
adt917.Data AS EndTime,
adt918.Data AS MaxEventsToDisplay,
adt919.Data AS MaxTasksToDisplay,
adt920.Data AS MaxNotesToDisplay,
adt921.Data AS MaxDailyRecurCount,
adt922.Data AS MaxWeeklyRecurCount,
adt923.Data AS MaxMonthlyRecurCount,
adt924.Data AS MaxYearlyRecurCount,
adt925.Data AS HoursClock,
adt926.Data AS MaxNoOfSearchResultsPerPage,
adt927.Data AS MaxEventTitleLength,
adt928.Data AS MaxTaskTitleLength,
adt929.Data AS StartDay,
adt3.Data AS MaxSize,
adt931.Data AS MaxMessages,
COALESCE(adt932.Data,'128') AS Flags,
adt933.Data AS Type,
adt934.Data AS DefaultView,
adt935.Data AS DefCalName,
adt936.Data AS TimeZone

FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN SubAccountData adt900 ON (adt900.AccountID =AccountID_ AND adt900.AccountDataTypeID = 900)
	LEFT JOIN SubAccountData adt901 ON (adt901.AccountID = sa.AccountID AND adt901.AccountDataTypeID = 901)
	LEFT JOIN SubAccountData adt902 ON (adt902.AccountID = sa.AccountID AND adt902.AccountDataTypeID = 902)
	LEFT JOIN SubAccountData adt903 ON (adt903.AccountID = sa.AccountID AND adt903.AccountDataTypeID = 903)
	LEFT JOIN SubAccountData adt904 ON (adt904.AccountID = sa.AccountID AND adt904.AccountDataTypeID = 904)
	LEFT JOIN SubAccountData adt905 ON (adt905.AccountID = sa.AccountID AND adt905.AccountDataTypeID = 905)
	LEFT JOIN SubAccountData adt906 ON (adt906.AccountID = sa.AccountID AND adt906.AccountDataTypeID = 906)
	LEFT JOIN SubAccountData adt907 ON (adt907.AccountID = sa.AccountID AND adt907.AccountDataTypeID = 907)
	LEFT JOIN SubAccountData adt908 ON (adt908.AccountID = sa.AccountID AND adt908.AccountDataTypeID = 908)
	LEFT JOIN SubAccountData adt909 ON (adt909.AccountID = sa.AccountID AND adt909.AccountDataTypeID = 909)
	LEFT JOIN SubAccountData adt910 ON (adt910.AccountID = sa.AccountID AND adt910.AccountDataTypeID = 910)
	LEFT JOIN SubAccountData adt911 ON (adt911.AccountID = sa.AccountID AND adt911.AccountDataTypeID = 911)
	LEFT JOIN SubAccountData adt912 ON (adt912.AccountID = sa.AccountID AND adt912.AccountDataTypeID = 912)
	LEFT JOIN SubAccountData adt913 ON (adt913.AccountID = sa.AccountID AND adt913.AccountDataTypeID = 913)
	LEFT JOIN SubAccountData adt914 ON (adt914.AccountID = sa.AccountID AND adt914.AccountDataTypeID = 914)
	LEFT JOIN SubAccountData adt915 ON (adt915.AccountID = sa.AccountID AND adt915.AccountDataTypeID = 915)
	LEFT JOIN SubAccountData adt916 ON (adt916.AccountID = sa.AccountID AND adt916.AccountDataTypeID = 916)
	LEFT JOIN SubAccountData adt917 ON (adt917.AccountID = sa.AccountID AND adt917.AccountDataTypeID = 917)
	LEFT JOIN SubAccountData adt918 ON (adt918.AccountID = sa.AccountID AND adt918.AccountDataTypeID = 918)
	LEFT JOIN SubAccountData adt919 ON (adt919.AccountID = sa.AccountID AND adt919.AccountDataTypeID = 919)
	LEFT JOIN SubAccountData adt920 ON (adt920.AccountID = sa.AccountID AND adt920.AccountDataTypeID = 920)
	LEFT JOIN SubAccountData adt921 ON (adt921.AccountID = sa.AccountID AND adt921.AccountDataTypeID = 921)
	LEFT JOIN SubAccountData adt922 ON (adt922.AccountID = sa.AccountID AND adt922.AccountDataTypeID = 922)
	LEFT JOIN SubAccountData adt923 ON (adt923.AccountID = sa.AccountID AND adt923.AccountDataTypeID = 923)
	LEFT JOIN SubAccountData adt924 ON (adt924.AccountID = sa.AccountID AND adt924.AccountDataTypeID = 924)
	LEFT JOIN SubAccountData adt925 ON (adt925.AccountID = sa.AccountID AND adt925.AccountDataTypeID = 925)
	LEFT JOIN SubAccountData adt926 ON (adt926.AccountID = sa.AccountID AND adt926.AccountDataTypeID = 926)
	LEFT JOIN SubAccountData adt927 ON (adt927.AccountID = sa.AccountID AND adt927.AccountDataTypeID = 927)
	LEFT JOIN SubAccountData adt928 ON (adt928.AccountID = sa.AccountID AND adt928.AccountDataTypeID = 928)
	LEFT JOIN SubAccountData adt929 ON (adt929.AccountID = sa.AccountID AND adt929.AccountDataTypeID = 929)
	LEFT JOIN SubAccountData adt3 ON (adt3.AccountID = sa.AccountID AND adt3.AccountDataTypeID = 3)
	LEFT JOIN SubAccountData adt931 ON (adt931.AccountID = sa.AccountID AND adt931.AccountDataTypeID = 931)
	LEFT JOIN SubAccountData adt932 ON (adt932.AccountID = sa.AccountID AND adt932.AccountDataTypeID = 932)
	LEFT JOIN SubAccountData adt933 ON (adt933.AccountID = sa.AccountID AND adt933.AccountDataTypeID = 933)
	LEFT JOIN SubAccountData adt934 ON (adt934.AccountID = sa.AccountID AND adt934.AccountDataTypeID = 934)
	LEFT JOIN SubAccountData adt935 ON (adt935.AccountID = sa.AccountID AND adt935.AccountDataTypeID = 935)
	LEFT JOIN SubAccountData adt936 ON (adt936.AccountID = sa.AccountID AND adt936.AccountDataTypeID = 936)
	WHERE esat.ExternalSystemID =esid_
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND sa.Password <> ' '
	AND sa.Password IS NOT NULL
	AND ((sa.Login <> ' ' AND sa.DomainID =DomainID_) 
		OR (sa.Email LIKE '%_@' || domain_) )
	AND sa.Active = 1 
	AND ma.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND ma.StartDate < sysdate;
ELSE
SELECT MAX(sa.AccountID) INTO AccountID_ 

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =esid_)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND ((sa.Login =username_ AND sa.DomainID =DomainID_) 
		OR (username_ || '@' || domain_ = sa.Email)
		OR (username_ || '@' || domain_ IN (SELECT Alias FROM Aliases WHERE AccountID = sa.AccountID)));
OPEN crIMailUsers1 FOR SELECT sa.AccountID, 
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%___%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE username_ END AS Login,
sa.Password, sa.FirstName || ' ' || sa.LastName AS Name, 
CASE WHEN sa.Email IS NULL OR sa.Email = ' ' THEN sa.Login || '@' || domain_ WHEN sa.Email <> ' ' THEN sa.Email ELSE NULL END AS MailAddress,
adt900.Data AS UserDir,
adt901.Data AS NumTries,
adt902.Data AS AttemptTime,
adt903.Data AS NumTimesSuspended,
adt904.Data AS LastLogin,
adt905.Data AS SuspendUserAccount,
adt906.Data AS ICalEnable,
adt907.Data AS SpellEnable,
adt908.Data AS NoOfSuggestions,
adt909.Data AS Depth,
adt910.Data AS Options,
adt911.Data AS SpellChecking,
adt912.Data AS PreviewSize,
adt913.Data AS ConfirmOnDelete,
adt914.Data AS DisplayCompletedTasks,
adt915.Data AS EntryGranularity,
adt916.Data AS StartTime,
adt917.Data AS EndTime,
adt918.Data AS MaxEventsToDisplay,
adt919.Data AS MaxTasksToDisplay,
adt920.Data AS MaxNotesToDisplay,
adt921.Data AS MaxDailyRecurCount,
adt922.Data AS MaxWeeklyRecurCount,
adt923.Data AS MaxMonthlyRecurCount,
adt924.Data AS MaxYearlyRecurCount,
adt925.Data AS HoursClock,
adt926.Data AS MaxNoOfSearchResultsPerPage,
adt927.Data AS MaxEventTitleLength,
adt928.Data AS MaxTaskTitleLength,
adt929.Data AS StartDay,
adt3.Data AS MaxSize,
adt931.Data AS MaxMessages,
COALESCE(adt932.Data,'128') AS Flags,
adt933.Data AS Type,
adt934.Data AS DefaultView,
adt935.Data AS DefCalName,
adt936.Data AS TimeZone

FROM SubAccounts sa LEFT JOIN SubAccountData adt900 ON (adt900.AccountID =AccountID_ AND adt900.AccountDataTypeID = 900)
	LEFT JOIN SubAccountData adt901 ON (adt901.AccountID =AccountID_ AND adt901.AccountDataTypeID = 901)
	LEFT JOIN SubAccountData adt902 ON (adt902.AccountID =AccountID_ AND adt902.AccountDataTypeID = 902)
	LEFT JOIN SubAccountData adt903 ON (adt903.AccountID =AccountID_ AND adt903.AccountDataTypeID = 903)
	LEFT JOIN SubAccountData adt904 ON (adt904.AccountID =AccountID_ AND adt904.AccountDataTypeID = 904)
	LEFT JOIN SubAccountData adt905 ON (adt905.AccountID =AccountID_ AND adt905.AccountDataTypeID = 905)
	LEFT JOIN SubAccountData adt906 ON (adt906.AccountID =AccountID_ AND adt906.AccountDataTypeID = 906)
	LEFT JOIN SubAccountData adt907 ON (adt907.AccountID =AccountID_ AND adt907.AccountDataTypeID = 907)
	LEFT JOIN SubAccountData adt908 ON (adt908.AccountID =AccountID_ AND adt908.AccountDataTypeID = 908)
	LEFT JOIN SubAccountData adt909 ON (adt909.AccountID =AccountID_ AND adt909.AccountDataTypeID = 909)
	LEFT JOIN SubAccountData adt910 ON (adt910.AccountID =AccountID_ AND adt910.AccountDataTypeID = 910)
	LEFT JOIN SubAccountData adt911 ON (adt911.AccountID =AccountID_ AND adt911.AccountDataTypeID = 911)
	LEFT JOIN SubAccountData adt912 ON (adt912.AccountID =AccountID_ AND adt912.AccountDataTypeID = 912)
	LEFT JOIN SubAccountData adt913 ON (adt913.AccountID =AccountID_ AND adt913.AccountDataTypeID = 913)
	LEFT JOIN SubAccountData adt914 ON (adt914.AccountID =AccountID_ AND adt914.AccountDataTypeID = 914)
	LEFT JOIN SubAccountData adt915 ON (adt915.AccountID =AccountID_ AND adt915.AccountDataTypeID = 915)
	LEFT JOIN SubAccountData adt916 ON (adt916.AccountID =AccountID_ AND adt916.AccountDataTypeID = 916)
	LEFT JOIN SubAccountData adt917 ON (adt917.AccountID =AccountID_ AND adt917.AccountDataTypeID = 917)
	LEFT JOIN SubAccountData adt918 ON (adt918.AccountID =AccountID_ AND adt918.AccountDataTypeID = 918)
	LEFT JOIN SubAccountData adt919 ON (adt919.AccountID =AccountID_ AND adt919.AccountDataTypeID = 919)
	LEFT JOIN SubAccountData adt920 ON (adt920.AccountID =AccountID_ AND adt920.AccountDataTypeID = 920)
	LEFT JOIN SubAccountData adt921 ON (adt921.AccountID =AccountID_ AND adt921.AccountDataTypeID = 921)
	LEFT JOIN SubAccountData adt922 ON (adt922.AccountID =AccountID_ AND adt922.AccountDataTypeID = 922)
	LEFT JOIN SubAccountData adt923 ON (adt923.AccountID =AccountID_ AND adt923.AccountDataTypeID = 923)
	LEFT JOIN SubAccountData adt924 ON (adt924.AccountID =AccountID_ AND adt924.AccountDataTypeID = 924)
	LEFT JOIN SubAccountData adt925 ON (adt925.AccountID =AccountID_ AND adt925.AccountDataTypeID = 925)
	LEFT JOIN SubAccountData adt926 ON (adt926.AccountID =AccountID_ AND adt926.AccountDataTypeID = 926)
	LEFT JOIN SubAccountData adt927 ON (adt927.AccountID =AccountID_ AND adt927.AccountDataTypeID = 927)
	LEFT JOIN SubAccountData adt928 ON (adt928.AccountID =AccountID_ AND adt928.AccountDataTypeID = 928)
	LEFT JOIN SubAccountData adt929 ON (adt929.AccountID =AccountID_ AND adt929.AccountDataTypeID = 929)
	LEFT JOIN SubAccountData adt3 ON (adt3.AccountID =AccountID_ AND adt3.AccountDataTypeID = 3)
	LEFT JOIN SubAccountData adt931 ON (adt931.AccountID =AccountID_ AND adt931.AccountDataTypeID = 931)
	LEFT JOIN SubAccountData adt932 ON (adt932.AccountID =AccountID_ AND adt932.AccountDataTypeID = 932)
	LEFT JOIN SubAccountData adt933 ON (adt933.AccountID =AccountID_ AND adt933.AccountDataTypeID = 933)
	LEFT JOIN SubAccountData adt934 ON (adt934.AccountID =AccountID_ AND adt934.AccountDataTypeID = 934)
	LEFT JOIN SubAccountData adt935 ON (adt935.AccountID =AccountID_ AND adt935.AccountDataTypeID = 935)
	LEFT JOIN SubAccountData adt936 ON (adt936.AccountID =AccountID_ AND adt936.AccountDataTypeID = 936)
	WHERE sa.AccountID =AccountID_;
END IF;

END;
END;
/

CREATE OR REPLACE PROCEDURE IncidentActionList (crIncidentActionList1 IN OUT ieatypes.CursorType,GroupID_ IN INTEGER,IncidentID_ IN INTEGER) AS
BEGIN
OPEN crIncidentActionList1 FOR SELECT a.ActionID,a.CreateDate, COALESCE((SELECT Operator FROM Operators WHERE OperatorID=a.CreateOperatorID),
(SELECT FirstName || '  ' || LastName FROM SubAccounts WHERE AccountID=a.CreateAccountID),'N/A') AS Operator,
a.Description,a.LastModifyDate,a.LastModifyUser, is1.IncidentState, a.Duration
FROM Actions a, IncidentStates is1, Incidents i, SubAccounts sa, MasterAccounts ma
	WHERE a.IncidentStateID = is1.IncidentStateID
	AND a.IncidentID =IncidentID_
	AND (CAST(a.Description AS VARCHAR(1)) IS NOT NULL OR a.Duration <> 0)
	AND a.IncidentID = i.IncidentID
	AND i.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND ma.GroupID =GroupID_
	AND ma.Active IN (1,0);
END;
/

CREATE OR REPLACE PROCEDURE IncidentReassign (RoleID_ IN INTEGER,OperatorID_ IN INTEGER,NewOperatorID_ IN INTEGER,assigntype_ IN INTEGER) AS
BEGIN
IF (assigntype_ = 1) THEN
UPDATE Incidents SET AssignOperatorID =NewOperatorID_ 
	WHERE AssignRoleID =RoleID_ 
	AND AssignOperatorID =OperatorID_
	AND IncidentStateID IN (SELECT IncidentStateID FROM IncidentStates WHERE StatOpen = 1);
END IF;

IF (assigntype_ = 2) THEN
UPDATE Incidents SET AssignOperatorID =NewOperatorID_ WHERE AssignRoleID =RoleID_ AND AssignOperatorID =OperatorID_;
END IF;
END;
/

CREATE OR REPLACE PROCEDURE IncidentAssignList (crIncidentAssignList1 IN OUT ieatypes.CursorType,OperatorID_ IN INTEGER,viewopt_ IN INTEGER) AS
BEGIN

IF (viewopt_ = 1) THEN
OPEN crIncidentAssignList1 FOR SELECT DISTINCT o.OperatorID, o.Operator
FROM Operators o, OperatorRoles r
	WHERE o.OperatorID = r.OperatorID
	AND r.RoleID IN (SELECT RoleID FROM OperatorRoles WHERE OperatorID =OperatorID_)
	AND o.Active = 1
	AND o.OperatorID <> OperatorID_
ORDER BY 2 ASC;
END IF;

IF (viewopt_ = 2) THEN
OPEN crIncidentAssignList1 FOR SELECT DISTINCT o.OperatorID, o.Operator
FROM Operators o 
	WHERE o.OperatorID IN (SELECT OperatorID FROM OperatorRoles)
	AND o.Active = 1
	AND o.OperatorID <> OperatorID_
ORDER BY 2 ASC;
END IF;

END;
/

CREATE OR REPLACE PROCEDURE IncidentAssign (crIncidentAssign1 IN OUT ieatypes.CursorType,RoleID_ IN INTEGER,GroupID_ IN INTEGER,AccountID_ IN INTEGER) AS
BEGIN
DECLARE
iGroupID_ INTEGER;
AssignStrategyID_ INTEGER;
BEGIN
SELECT CASE WHEN GroupID_ IN (1,0) THEN NULL ELSE GroupID_ END INTO iGroupID_ 

 FROM DUAL;
SELECT COALESCE(AssignStrategyID,1) INTO AssignStrategyID_  FROM Roles WHERE RoleID = RoleID_;

IF (AssignStrategyID_ = 1) THEN
INSERT INTO inatmp (OperatorRoleID, Cnt)
SELECT OperatorRoleID, COUNT(*) AS Cnt
FROM OperatorRoles or1, Incidents i, IncidentStates is1
	WHERE or1.OperatorID = i.AssignOperatorID
	AND i.IncidentStateID = is1.IncidentStateID
	AND is1.StatOpen = 1
	AND is1.StatWait = 0
	AND is1.StatEscalate = 0
	AND or1.RoleID =RoleID_
	AND (or1.GroupID IS NULL OR or1.GroupID =iGroupID_)
GROUP BY OperatorRoleID
UNION ALL
SELECT OperatorRoleID, COUNT(*) AS Cnt
FROM OperatorRoles or1, Incidents i, IncidentStates is1
	WHERE or1.RoleID = i.AssignRoleID
	AND i.IncidentStateID = is1.IncidentStateID
	AND is1.StatOpen = 1
	AND is1.StatWait = 0
	AND is1.StatEscalate = 1
	AND or1.ShowEscalate = 1
	AND or1.RoleID =RoleID_
	AND (or1.GroupID IS NULL OR or1.GroupID =iGroupID_)
GROUP BY OperatorRoleID
UNION
SELECT OperatorRoleID, 0 AS Cnt
FROM OperatorRoles
	WHERE RoleID =RoleID_
	AND (GroupID IS NULL OR GroupID =iGroupID_);
END IF;

IF (AssignStrategyID_ = 2) THEN
INSERT INTO inatmp (OperatorRoleID, Cnt)
SELECT OperatorRoleID, COUNT(*) AS Cnt
FROM OperatorRoles or1, Incidents i, IncidentStates is1
	WHERE or1.OperatorID = i.AssignOperatorID
	AND i.IncidentStateID = is1.IncidentStateID
	AND i.CreateDate > DATEADD(dd,-20,sysdate)
	AND is1.StatEscalate = 0
	AND or1.RoleID =RoleID_
	AND (or1.GroupID IS NULL OR or1.GroupID =iGroupID_)
GROUP BY OperatorRoleID
UNION ALL
SELECT OperatorRoleID, COUNT(*) AS Cnt
FROM OperatorRoles or1, Incidents i, IncidentStates is1
	WHERE or1.RoleID = i.AssignRoleID
	AND i.IncidentStateID = is1.IncidentStateID
	AND i.CreateDate > DATEADD(dd,-20,sysdate)
	AND is1.StatEscalate = 1
	AND or1.ShowEscalate = 1
	AND or1.RoleID =RoleID_
	AND (or1.GroupID IS NULL OR or1.GroupID =iGroupID_)
GROUP BY OperatorRoleID
UNION
SELECT OperatorRoleID, 0 AS Cnt
FROM OperatorRoles
	WHERE RoleID =RoleID_
	AND (GroupID IS NULL OR GroupID =iGroupID_);
END IF;

OPEN crIncidentAssign1 FOR SELECT t.OperatorRoleID, MAX(or1.RoleID) AS RoleID, MAX(or1.OperatorID) AS OperatorID, MAX(or1.Tier) AS Tier, SUM(t.Cnt) / CAST (MAX(or1.TargetActive) AS NUMERIC) AS TargetRatio, SUM(t.Cnt) / CAST(MAX(or1.MaxActive) AS NUMERIC) AS MaxRatio
FROM inatmp t, OperatorRoles or1
	WHERE t.OperatorRoleID = or1.OperatorRoleID
	AND (or1.TargetActive IS NULL OR or1.TargetActive > 0)
	AND (or1.MaxActive IS NULL OR or1.MaxActive > 0)
GROUP BY t.OperatorRoleID
ORDER BY CASE WHEN SUM(t.Cnt) / CAST(MAX(or1.MaxActive) AS NUMERIC) > 1 THEN 1 ELSE 0 END ASC, 4 ASC, SUM(t.Cnt) / CAST(MAX(or1.TargetActive) AS NUMERIC) ASC;

DELETE FROM inatmp;
END;
END;
/

CREATE OR REPLACE PROCEDURE IncidentMBRList (crIncidentMBRList1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
OPEN crIncidentMBRList1 FOR SELECT i.AccountID, CASE WHEN ins.StatOpen = 1 THEN i.PriorityID ELSE -1000 END AS Pri, IncidentID, i.CreateDate AS IncidentDate, 
COALESCE((SELECT Operator FROM Operators WHERE OperatorID = i.CreateOperatorID),(SELECT Login FROM SubAccounts WHERE AccountID = i.CreateAccountID)) AS Operator, 
COALESCE(CAST(i.Summary AS VARCHAR(255)),CAST(i.Description AS VARCHAR(100))) AS Description,
COALESCE(Style,CASE WHEN ins.StatOpen=1 AND ins.StatEscalate=1 THEN 'escalated' WHEN ins.StatOpen=1 AND ins.StatWait=0 AND i.DueDate < sysdate THEN 'pastdue' WHEN ins.StatOpen=1 THEN 'open' WHEN ins.StatArchive=1 THEN 'archived' WHEN ins.StatBlock=1 THEN 'blocking' WHEN ins.StatOpen=0 THEN 'closed' ELSE 'normal' END) AS Style,
IncidentState as Status, 
IncidentType, 
(Select Count(ActionID) From Actions a Where a.IncidentID = i.IncidentID) as Actions, p.Priority, p.StringID AS PriorityStringID
FROM Incidents i, IncidentStates ins, IncidentTypes it, SubAccounts sa, Priorities p
	WHERE i.AccountID = sa.AccountID
	AND sa.CustomerID =CustomerID_
	AND i.IncidentStateID = ins.IncidentStateID
	AND i.IncidentTypeID = it.IncidentTypeID
	AND i.PriorityID = p.PriorityID
ORDER BY 2 DESC, 3 DESC;
END;
/

CREATE OR REPLACE PROCEDURE IncidentSAList (crIncidentSAList1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER) AS
BEGIN
OPEN crIncidentSAList1 FOR SELECT IncidentID, CASE WHEN ins.StatOpen = 1 THEN i.PriorityID ELSE -1000 END AS Pri, i.CreateDate AS IncidentDate, COALESCE((SELECT Operator FROM Operators WHERE OperatorID = i.CreateOperatorID),(SELECT Login FROM SubAccounts WHERE AccountID = i.CreateAccountID)) AS Operator,
COALESCE(CAST(i.Summary AS VARCHAR(255)),CAST(i.Description AS VARCHAR(100))) AS Description,
	COALESCE(Style,CASE WHEN ins.StatOpen=1 AND ins.StatEscalate=1 THEN 'escalated' WHEN ins.StatOpen=1 AND ins.StatWait=0 AND i.DueDate < sysdate THEN 'pastdue' WHEN ins.StatOpen=1 THEN 'open' WHEN ins.StatArchive=1 THEN 'archived' WHEN ins.StatBlock=1 THEN 'blocking' WHEN ins.StatOpen=0 THEN 'closed' ELSE 'normal' END) AS Style,
	IncidentState as Status, IncidentType, (Select Count(ActionID) From Actions a Where a.IncidentID = i.IncidentID) as Actions, p.Priority, p.StringID AS PriorityStringID, i.CustomerAccess
FROM Incidents i, IncidentStates ins, IncidentTypes it, Priorities p
WHERE AccountID =AccountID_
	and i.IncidentStateID = ins.IncidentStateID
	AND i.PriorityID = p.PriorityID
	AND i.IncidentTypeID = it.IncidentTypeID

ORDER BY 2 DESC, 3 DESC;
END;
/

CREATE OR REPLACE PROCEDURE IncidentShow (crIncidentShow1 IN OUT ieatypes.CursorType,GroupID_ IN INTEGER,IncidentID_ IN INTEGER) AS
BEGIN
OPEN crIncidentShow1 FOR SELECT i.IncidentID,i.AccountID,i.CreateDate,i.IncidentTypeID,i.IncidentStateID,it1.IncidentType,COALESCE(Duration,0) + COALESCE((SELECT SUM(Duration) FROM Actions WHERE IncidentID=i.IncidentID AND Duration IS NOT NULL),0) AS TotalDuration,
CASE WHEN it1.ShowDueDate = 1 AND is1.StatOpen = 1 THEN COALESCE(CASE WHEN it1.ShowCustDueDate = 1 THEN i.DueDate ELSE NULL END,DATEADD(dd,it1.OverDays,i.CreateDate)) ELSE NULL END AS DueDate,
COALESCE((SELECT Operator FROM Operators WHERE OperatorID=i.CreateOperatorID),
(SELECT FirstName || '  ' || LastName FROM SubAccounts WHERE AccountID=i.CreateAccountID),'N/A') AS Operator,i.Summary,i.Description,i.CustomerAccess,i.LastModifyDate,i.LastModifyUser,i.DueDate as CustDueDate,
AssignRoleID,AssignOperatorID,
COALESCE((SELECT Role FROM Roles WHERE RoleID=i.AssignRoleID),'N/A') AS AssignRole,
COALESCE((SELECT Operator FROM Operators WHERE OperatorID=i.AssignOperatorID),'N/A') AS AssignOperator,it1.ShowPriority,it1.ShowEmail,it1.ShowDuration,i.Duration,i.Email,it1.ShowSummary,i.PriorityID,it1.ShowCustomerAccess,it1.ShowCustDueDate
FROM Incidents i, IncidentTypes it1, IncidentStates is1, SubAccounts sa, MasterAccounts ma
	WHERE i.IncidentID =IncidentID_
	AND i.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND ma.GroupID =GroupID_
	AND ma.Active IN (1,0)
	AND i.IncidentTypeID = it1.IncidentTypeID
	AND i.IncidentStateID = is1.IncidentStateID;
END;
/

CREATE OR REPLACE PROCEDURE IncidentChangeTypeData (IncidentID_ IN INTEGER,newIncidentTypeID_ IN INTEGER) AS
BEGIN

INSERT INTO ictd (SrcIncidentDataTypeID,DstIncidentDataTypeID,DstData)
SELECT it1.IncidentDataTypeID, it2.IncidentDataTypeID, COALESCE(CAST(iv2.NumValue AS VARCHAR(10)),id1.Data)
FROM Incidents i JOIN IncidentDataTypes it1 ON (i.IncidentTypeID = it1.IncidentTypeID)
	JOIN IncidentDataTypes it2 ON (it1.IncidentDataType = it2.IncidentDataType AND it2.IncidentTypeID =newIncidentTypeID_)
	JOIN IncidentData id1 ON (i.IncidentID = id1.IncidentID AND it1.IncidentDataTypeID = id1.IncidentDataTypeID)
	LEFT JOIN IncidentValues iv1 ON (it1.IncidentDataTypeID = iv1.IncidentDataTypeID AND it1.DataTypeID = 2 AND id1.Data = CAST(iv1.NumValue AS VARCHAR(10)))
	LEFT JOIN IncidentValues iv2 ON (it2.IncidentDataTypeID = iv2.IncidentDataTypeID AND it2.DataTypeID = 2 AND iv1.ValueName = iv2.ValueName)
	WHERE i.IncidentID =IncidentID_
	AND id1.Data IS NOT NULL
	AND it1.IncidentDataTypeID <> it2.IncidentDataTypeID
	AND it1.DataTypeID = it2.DataTypeID
	AND (	(it1.DataTypeID IN (0,1) AND it2.DataTypeID IN (0,1))
	OR	(it1.DataTypeID = 3 AND CAST(it1.SQLQuery AS VARCHAR(255)) = CAST(it2.SQLQuery AS VARCHAR(255)))
	OR	(it1.DataTypeID = 2 AND iv2.NumValue IS NOT NULL));
DELETE FROM IncidentData 
	WHERE IncidentID =IncidentID_ 
	AND IncidentDataTypeID IN (SELECT DstIncidentDataTypeID FROM ictd);
MERGE INTO IncidentData mid
USING (SELECT id1.IncidentID, i.SrcIncidentDataTypeID, i.DstIncidentDataTypeID, i.DstData
FROM IncidentData id1,ictd i
	WHERE id1.IncidentID =IncidentID_
	AND id1.IncidentDataTypeID = i.SrcIncidentDataTypeID) id
ON (mid.IncidentID = id.IncidentID AND mid.IncidentDataTypeID = id.SrcIncidentDataTypeID)
WHEN MATCHED THEN UPDATE SET mid.IncidentDataTypeID = id.DstIncidentDataTypeID, mid.Data = id.DstData;


DELETE FROM ictd;
END;
/

CREATE OR REPLACE PROCEDURE InvoiceAdd (crInvoiceAdd1 IN OUT ieatypes.CursorType,BatchID_ IN INTEGER,CustomerID_ IN INTEGER,InvoiceTypeID_ IN INTEGER,Amount_ IN NUMERIC,ChargeAmount_ IN NUMERIC,LastModifyUser_ IN VARCHAR2,Tax_ IN NUMERIC) AS
BEGIN
INSERT INTO Invoices(BatchID,CustomerID,InvoiceTypeID,Amount,ChargeAmount,PaidAmount,LastModifyUser,Tax,Processed)
VALUES(BatchID_,CustomerID_ ,InvoiceTypeID_ ,Amount_ ,ChargeAmount_ ,0,LastModifyUser_ ,Tax_ ,1);
OPEN crInvoiceAdd1 FOR SELECT LAST.IDENT AS InvoiceID
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE InvoiceEmailList (crInvoiceEmailList1 IN OUT ieatypes.CursorType,GroupID_ IN INTEGER,OperatorGroupID_ IN INTEGER,MBRGlobal_ IN INTEGER) AS
BEGIN

OPEN crInvoiceEmailList1 FOR SELECT g.BillPhone, g.BillFax, ma.Company, ma.FirstName, ma.LastName, g.BillName, ma.CustomerID, i.InvoiceID, CASE WHEN sm.EmailTypeID = 16 THEN COALESCE(g.InvoiceTextReport,'einvoice.rpt') ELSE COALESCE(g.InvoiceReport,'invoice.rpt') END AS ReportFile,
'{Invoices.InvoiceID}=' || CAST(i.InvoiceID AS VARCHAR(16)) AS Formula
FROM MasterAccounts ma, SendMethods sm, Invoices i, Groups g
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.Active = 1
	AND ma.CustomerID = i.CustomerID
	AND i.EmailDate IS NULL
	AND i.Estimate = 0
	AND i.Processed = 1
	AND i.CreateDate > DATEADD(dd,-45,sysdate)
	AND sm.EmailTypeID IS NOT NULL
	AND g.AutoEmailInvoices IN (0,1)
	AND ma.GroupID = g.GroupID
	AND ((ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 1) OR ma.PaymentTypeID NOT IN (8,16))
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND ((OperatorGroupID_ IS NULL AND g.AutoEmailInvoices = 1) OR (OperatorGroupID_ IS NOT NULL AND (COALESCE(MBRGlobal_,1) = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=106 AND OperatorGroupID=OperatorGroupID_))));
END;
/

CREATE OR REPLACE PROCEDURE InvoiceEmailSent (CustomerID_ IN INTEGER,InvoiceID_ IN INTEGER) AS
BEGIN
UPDATE Invoices SET EmailDate=sysdate WHERE EmailDate IS NULL AND InvoiceID =InvoiceID_;
INSERT INTO MailLogs (LogDate, LogMsgID, CustomerID, TokenID) 
VALUES(sysdate, 1001,CustomerID_ ,InvoiceID_ );
END;
/

CREATE OR REPLACE PROCEDURE InvoiceGetItems (crInvoiceGetItems1 IN OUT ieatypes.CursorType,crInvoiceGetItems2 IN OUT ieatypes.CursorType,crInvoiceGetItems3 IN OUT ieatypes.CursorType,crInvoiceGetItems4 IN OUT ieatypes.CursorType,crInvoiceGetItems5 IN OUT ieatypes.CursorType,ForceNext_ IN INTEGER,CustomerID_ IN INTEGER) AS
BEGIN
DECLARE
inv_next_days_ INTEGER;
BEGIN
SELECT COALESCE(MAX(NumValue),0) INTO inv_next_days_  FROM Configs WHERE ConfigID = 37;
OPEN crInvoiceGetItems1 FOR SELECT CASE WHEN c.Amount < 0 THEN 1 ELSE 2 END AS ItemType, c.AccountID, c.AccountTypeID, c.PackageID, c.PackageTypeID, c.ChargeID, c.ChargeTypeID, c.Login, COALESCE(c.Description,ct.Description) AS Description, CASE WHEN c.Description IS NULL THEN ct.StringID ELSE NULL END AS StringID, c.Amount, c.Quantity, 
CASE WHEN c.Prorated = 1 THEN 3 ELSE NULL END AS QuantityType, c.TaxGroupID, c.TaxExemptions, c.StartDate, c.EndDate,
CASE WHEN c.Prorated = 0 THEN NULL WHEN ma.CancelDate IS NOT NULL AND ma.CancelDate < COALESCE((SELECT CancelDate FROM SubAccounts WHERE AccountID=c.AccountID),(SELECT CancelDate FROM Packages WHERE PackageID=c.PackageID),ma.CancelDate) THEN ma.CancelDate ELSE COALESCE((SELECT CancelDate FROM SubAccounts WHERE AccountID=c.AccountID),(SELECT CancelDate FROM Packages WHERE PackageID=c.PackageID),ma.CancelDate) END AS CancelDate
FROM MasterAccounts ma JOIN Charges c ON (ma.CustomerID = c.CustomerID)
	LEFT JOIN ChargeTypes ct ON (c.ChargeTypeID = ct.ChargeTypeID)
	WHERE ma.CustomerID =CustomerID_
	AND c.ItemID IS NULL
	AND ma.Active = 1;
OPEN crInvoiceGetItems2 FOR SELECT 3 AS ItemType, sa.AccountID, sa.AccountTypeID, COALESCE(sa.Login,sa.Email) AS Login, at1.Description, at1.StringID, CASE WHEN sa.DiffCost = 1 THEN sa.Cost ELSE (COALESCE(oat.CustomerCost,at1.Cost) / CASE WHEN pp.PeriodTypeID = 2 THEN 30 ELSE 1 END) END AS Amount, CASE WHEN at1.NextCount IS NOT NULL AND at1.NextID IS NOT NULL AND pp.PeriodTypeID = 1 AND sa.CycleMonths + pp.Period > at1.NextCount THEN pp.Period - ((sa.CycleMonths + pp.Period) - at1.NextCount) ELSE pp.Period END AS Quantity, pp.PeriodTypeID AS QuantityType, CASE WHEN sa.DiffCost = 1 THEN NULL ELSE d.AmountType END AS DAmountType, CASE WHEN sa.DiffCost = 1 OR at1.ApplyDiscount = 0 THEN NULL ELSE pp.AmountType END AS PAmountType, d.Amount AS DAmount, pp.Amount AS PAmount, at1.TaxGroupID, at1.TaxExemptions, sa.CycleMonths, sa.LastInvoiceID, DATEADD(dd,1,sa.BilledThru) AS StartDate, CASE WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate ELSE COALESCE(sa.CancelDate,ma.CancelDate) END AS CancelDate, at1.ChangeClose,
sa.BillStatus, CASE WHEN pp.PeriodTypeID = 1 THEN pp.Period ELSE NULL END AS Months, CASE WHEN sa.BillStatus = 1 THEN at1.ChangeOpen WHEN sa.BillStatus = 2 THEN at1.ChangeTo ELSE NULL END AS ChangeOpen, CASE WHEN bc.CycleType = 3 AND pp.PeriodTypeID = 1 AND pp.Period > 1 THEN (SELECT MAX(sa2.BilledThru) FROM SubAccounts sa2, PayPeriods pp2 WHERE sa2.PayPeriodID = pp2.PayPeriodID AND sa2.Active = 1 AND pp2.PeriodTypeID = 1 AND pp2.Period = pp.Period AND sa2.CustomerID =CustomerID_) END AS MaxBilled
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Discounts d ON (sa.DiscountID = d.DiscountID)
	LEFT JOIN OrgAccountTypes oat ON (g.OrganizationID = oat.OrganizationID AND sa.AccountTypeID = oat.AccountTypeID AND o.ResellerCustomerID IS NOT NULL)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sa.PackageID IS NULL
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru OR (DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 30 AND DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 1) OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= sysdate) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > sysdate)  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= sysdate) OR (sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > sysdate)  )))
		OR bc.AutoBill = 1)
	AND ma.CustomerID =CustomerID_
	AND ((COALESCE(ForceNext_,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,sysdate) >= sa.BilledThru) 
		OR (ForceNext_ = 1 AND DATEADD(dd,COALESCE(cgd.NumValue,inv_next_days_ ,90),sysdate) >= sa.BilledThru))
	AND (sa.CancelDate IS NULL OR sa.BilledThru < sa.CancelDate)
	AND (ma.CancelDate IS NULL OR sa.BilledThru < ma.CancelDate);
OPEN crInvoiceGetItems3 FOR SELECT 3 AS ItemType, sa.AccountID, sa.AccountTypeID AS origAccountTypeID, at1.AccountTypeID, COALESCE(sa.Login,sa.Email) AS Login, at1.Description, at1.StringID, CASE WHEN sa.DiffCost = 1 THEN sa.Cost ELSE (COALESCE(oat.CustomerCost,at1.Cost) / CASE WHEN pp.PeriodTypeID = 2 THEN 30 ELSE 1 END) END AS Amount, CASE WHEN sa.CycleMonths + pp.Period - atc.NextCount > pp.Period THEN pp.Period ELSE sa.CycleMonths + pp.Period - atc.NextCount END AS Quantity, pp.PeriodTypeID AS QuantityType, CASE WHEN sa.DiffCost = 1 THEN NULL ELSE d.AmountType END AS DAmountType, CASE WHEN sa.DiffCost = 1 OR at1.ApplyDiscount = 0 THEN NULL ELSE pp.AmountType END AS PAmountType, d.Amount AS DAmount, pp.Amount AS PAmount, at1.TaxGroupID, at1.TaxExemptions, -1 AS CycleMonths, sa.LastInvoiceID, CASE WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate ELSE COALESCE(sa.CancelDate,ma.CancelDate) END AS CancelDate, at1.ChangeClose
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN AccountTypes atc ON (sa.AccountTypeID = atc.AccountTypeID)
	JOIN AccountTypes at1 ON (atc.NextID = at1.AccountTypeID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN Discounts d ON (sa.DiscountID = d.DiscountID)
	LEFT JOIN OrgAccountTypes oat ON (g.OrganizationID = oat.OrganizationID AND sa.AccountTypeID = oat.AccountTypeID AND o.ResellerCustomerID IS NOT NULL)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND atc.NextCount IS NOT NULL
	AND atc.NextID IS NOT NULL
	AND pp.PeriodTypeID = 1
	AND sa.CycleMonths + pp.Period > atc.NextCount
	AND sa.PackageID IS NULL
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru OR (DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 30 AND DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 1) OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= sysdate) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > sysdate)  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= sysdate) OR (sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > sysdate)  )))
		OR bc.AutoBill = 1)
	AND ma.CustomerID =CustomerID_
	AND ((COALESCE(ForceNext_,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,sysdate) >= sa.BilledThru) 
		OR (ForceNext_ = 1 AND DATEADD(dd,COALESCE(cgd.NumValue,inv_next_days_ ,90),sysdate) >= sa.BilledThru))
	AND (sa.CancelDate IS NULL OR sa.BilledThru < sa.CancelDate)
	AND (ma.CancelDate IS NULL OR sa.BilledThru < ma.CancelDate);
OPEN crInvoiceGetItems4 FOR SELECT 3 AS ItemType, p.PackageID, p.PackageTypeID, COALESCE(pt.InvoiceDescription,pt.PackageType) AS Description, pt.StringID, CASE WHEN p.DiffCost = 1 THEN p.Cost ELSE (COALESCE(opt.CustomerCost,pt.Cost) / CASE WHEN pp.PeriodTypeID = 2 THEN 30 ELSE 1 END) END AS Amount, CASE WHEN pt.NextCount IS NOT NULL AND pt.NextID IS NOT NULL AND pp.PeriodTypeID = 1 AND p.CycleMonths + pp.Period > pt.NextCount THEN pp.Period - ((p.CycleMonths + pp.Period) - pt.NextCount) ELSE pp.Period END AS Quantity, pp.PeriodTypeID AS QuantityType, CASE WHEN p.DiffCost = 1 THEN NULL ELSE d.AmountType END AS DAmountType, CASE WHEN p.DiffCost = 1 OR pt.ApplyDiscount = 0 THEN NULL ELSE pp.AmountType END AS PAmountType, d.Amount AS DAmount, pp.Amount AS PAmount, pt.TaxGroupID, pt.TaxExemptions, p.CycleMonths, p.LastInvoiceID, DATEADD(dd,1,p.BilledThru) AS StartDate, CASE WHEN ma.CancelDate IS NOT NULL AND p.CancelDate IS NOT NULL AND ma.CancelDate < p.CancelDate THEN ma.CancelDate ELSE COALESCE(p.CancelDate,ma.CancelDate) END AS CancelDate, pt.ChangeClose,
p.BillStatus, CASE WHEN pp.PeriodTypeID = 1 THEN pp.Period ELSE NULL END AS Months, CASE WHEN p.BillStatus = 1 THEN pt.ChangeOpen WHEN p.BillStatus = 2 THEN pt.ChangeTo ELSE NULL END AS ChangeOpen, CASE WHEN bc.CycleType = 3 AND pp.PeriodTypeID = 1 AND pp.Period > 1 THEN (SELECT MAX(p2.BilledThru) FROM Packages p2, PayPeriods pp2 WHERE p2.PayPeriodID = pp2.PayPeriodID AND p2.Active = 1 AND pp2.PeriodTypeID = 1 AND pp2.Period = pp.Period AND p2.CustomerID =CustomerID_) END AS MaxBilled
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Packages p ON (ma.CustomerID = p.CustomerID)
	JOIN PayPeriods pp ON (p.PayPeriodID = pp.PayPeriodID)
	JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN Discounts d ON (p.DiscountID = d.DiscountID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN OrgPackageTypes opt ON (g.OrganizationID = opt.OrganizationID AND p.PackageTypeID = opt.PackageTypeID AND o.ResellerCustomerID IS NOT NULL)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	WHERE ma.Active = 1
	AND p.Active = 1
	AND EXISTS (SELECT * FROM SubAccounts sa WHERE sa.Active=1 AND (sa.CancelDate IS NULL OR sa.CancelDate > p.BilledThru) AND sa.PackageID=p.PackageID AND sa.CustomerID=ma.CustomerID)
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((p.ExpireDate IS NULL OR p.ExpireDate = p.BilledThru OR (DATEDIFF(dd,p.ExpireDate,p.BilledThru) <= 30 AND DATEDIFF(dd,p.ExpireDate,p.BilledThru) <= 1) OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= sysdate) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,p.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,p.ExpireDate) END > sysdate)  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= sysdate) OR (p.ExpireDate IS NULL OR p.ExpireDate = p.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,p.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,p.ExpireDate) END > sysdate)  )))
		OR bc.AutoBill = 1)
	AND ma.CustomerID =CustomerID_
	AND ((COALESCE(ForceNext_,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,sysdate) >= p.BilledThru)
		OR (ForceNext_ = 1 AND DATEADD(dd,COALESCE(cgd.NumValue,inv_next_days_ ,90),sysdate) >= p.BilledThru))
	AND (p.CancelDate IS NULL OR p.BilledThru < p.CancelDate)
	AND (ma.CancelDate IS NULL OR p.BilledThru < ma.CancelDate);
OPEN crInvoiceGetItems5 FOR SELECT 3 AS ItemType, p.PackageID, p.PackageTypeID AS origPackageTypeID, pt.PackageTypeID, COALESCE(pt.InvoiceDescription,pt.PackageType) AS Description, pt.StringID, CASE WHEN p.DiffCost = 1 THEN p.Cost ELSE (COALESCE(opt.CustomerCost,pt.Cost) / CASE WHEN pp.PeriodTypeID = 2 THEN 30 ELSE 1 END) END AS Amount, CASE WHEN p.CycleMonths + pp.Period - ptc.NextCount > pp.Period THEN pp.Period ELSE p.CycleMonths + pp.Period - ptc.NextCount END AS Quantity, pp.PeriodTypeID AS QuantityType, CASE WHEN p.DiffCost = 1 THEN NULL ELSE d.AmountType END AS DAmountType, CASE WHEN p.DiffCost = 1 OR pt.ApplyDiscount = 0 THEN NULL ELSE pp.AmountType END AS PAmountType, d.Amount AS DAmount, pp.Amount AS PAmount, pt.TaxGroupID, pt.TaxExemptions, -1 AS CycleMonths, p.LastInvoiceID, CASE WHEN ma.CancelDate IS NOT NULL AND p.CancelDate IS NOT NULL AND ma.CancelDate < p.CancelDate THEN ma.CancelDate ELSE COALESCE(p.CancelDate,ma.CancelDate) END AS CancelDate, pt.ChangeClose
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Packages p ON (ma.CustomerID = p.CustomerID)
	JOIN PackageTypes ptc ON (p.PackageTypeID = ptc.PackageTypeID)
	JOIN PackageTypes pt ON (ptc.NextID = pt.PackageTypeID)
	JOIN PayPeriods pp ON (p.PayPeriodID = pp.PayPeriodID)
	JOIN Discounts d ON (p.DiscountID = d.DiscountID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN OrgPackageTypes opt ON (g.OrganizationID = opt.OrganizationID AND p.PackageTypeID = opt.PackageTypeID AND o.ResellerCustomerID IS NOT NULL)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	WHERE ma.Active = 1
	AND p.Active = 1
	AND EXISTS (SELECT * FROM SubAccounts sa WHERE sa.Active=1 AND sa.PackageID=p.PackageID AND sa.CustomerID=ma.CustomerID)
	AND ptc.NextCount IS NOT NULL
	AND ptc.NextID IS NOT NULL
	AND pp.PeriodTypeID = 1
	AND p.CycleMonths + pp.Period > ptc.NextCount
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((p.ExpireDate IS NULL OR p.ExpireDate = p.BilledThru OR (DATEDIFF(dd,p.ExpireDate,p.BilledThru) <= 30 AND DATEDIFF(dd,p.ExpireDate,p.BilledThru) <= 1) OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= sysdate) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,p.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,p.ExpireDate) END > sysdate)  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= sysdate) OR (p.ExpireDate IS NULL OR p.ExpireDate = p.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,p.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,p.ExpireDate) END > sysdate)  )))
		OR bc.AutoBill = 1)
	AND ma.CustomerID =CustomerID_
	AND ((COALESCE(ForceNext_,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,sysdate) >= p.BilledThru) 
		OR (ForceNext_ = 1 AND DATEADD(dd,COALESCE(cgd.NumValue,inv_next_days_ ,90),sysdate) >= p.BilledThru))
	AND (p.CancelDate IS NULL OR p.BilledThru < p.CancelDate)
	AND (ma.CancelDate IS NULL OR p.BilledThru < ma.CancelDate);
END;
END;
/

CREATE OR REPLACE PROCEDURE InvoiceGetList (crInvoiceGetList1 IN OUT ieatypes.CursorType,ForceNext_ IN INTEGER,InvoiceID_ IN INTEGER,CustomerID_ IN INTEGER,GroupID_ IN INTEGER,OperatorGroupID_ IN INTEGER,LanguageID_ IN INTEGER) AS
BEGIN
DECLARE
inv_next_days_ INTEGER;
interim_lookahead_ INTEGER;
BEGIN


SELECT COALESCE(MAX(NumValue),0) INTO inv_next_days_  FROM Configs WHERE ConfigID = 37;
SELECT COALESCE(MAX(NumValue),45) INTO interim_lookahead_  FROM Configs WHERE ConfigID = 36;
IF (CustomerID_ IS NOT NULL) THEN
INSERT INTO iglc (CustomerID)
SELECT CustomerID FROM MasterAccounts WHERE Active = 1 AND CustomerID =CustomerID_;
ELSIF (GroupID_ IS NOT NULL) THEN
INSERT INTO iglc (CustomerID)
SELECT CustomerID FROM MasterAccounts WHERE Active = 1 AND GroupID =GroupID_;
ELSE
INSERT INTO iglc (CustomerID)
SELECT CustomerID FROM MasterAccounts WHERE Active = 1;
END IF;

OPEN crInvoiceGetList1 FOR SELECT CASE WHEN ma.PaymentTypeID = 8 THEN 2 WHEN ma.PaymentTypeID = 16 THEN 3 ELSE 1 END AS InvoiceTypeID, ma.FirstName, ma.LastName, ma.Company, ma.CustomerID, ma.CountryID, ma.StateID, ma.RegionID, ma.Zip, ma.City, CASE WHEN CustomerID_ IS NOT NULL AND LanguageID_ IS NOT NULL THEN LanguageID_ ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, bc.CycleType
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	LEFT JOIN Charges c ON (c.ItemID IS NULL AND ma.CustomerID = c.CustomerID AND c.Quantity > 0)
	WHERE ma.Active = 1
	AND ma.PaymentTypeID <> 64
	AND sa.Active = 1
	AND sa.PackageID IS NULL
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru OR (DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 30 AND DATEDIFF(dd,sa.ExpireDate,sa.BilledThru) <= 1) OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= sysdate) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > sysdate)  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= sysdate) OR (sa.ExpireDate IS NULL OR sa.ExpireDate = sa.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,sa.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,sa.ExpireDate) END > sysdate)  )))
		OR bc.AutoBill = 1)
	AND ma.CustomerID IN (SELECT CustomerID FROM iglc)
	AND ((c.ChargeID IS NOT NULL AND CustomerID_ IS NOT NULL)
		OR (COALESCE(ForceNext_,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,sysdate) >= sa.BilledThru) 
		OR (ForceNext_ = 1 AND DATEADD(dd,COALESCE(cgd.NumValue,inv_next_days_ ,90),sysdate) >= sa.BilledThru))
	AND (sa.CancelDate IS NULL OR sa.BilledThru < sa.CancelDate)
	AND (ma.CancelDate IS NULL OR sa.BilledThru < ma.CancelDate)
	AND InvoiceID_ IS NULL
	AND (OperatorGroupID_ IS NULL OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID =OperatorGroupID_ AND ObjectGroupID = 104 AND BITAND(AccessType,2) = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID =OperatorGroupID_ AND ObjectGroupID = 104 AND BITAND(AccessType,2) = 2))
UNION
SELECT CASE WHEN ma.PaymentTypeID = 8 THEN 2 WHEN ma.PaymentTypeID = 16 THEN 3 ELSE 1 END AS InvoiceTypeID, ma.FirstName, ma.LastName, ma.Company, ma.CustomerID, ma.CountryID, ma.StateID, ma.RegionID, ma.Zip, ma.City, CASE WHEN CustomerID_ IS NOT NULL AND LanguageID_ IS NOT NULL THEN LanguageID_ ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, bc.CycleType
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Packages p ON (ma.CustomerID = p.CustomerID)
	JOIN PayPeriods pp ON (p.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 37)
	LEFT JOIN Charges c ON (c.ItemID IS NULL AND ma.CustomerID = c.CustomerID AND c.Quantity > 0)
	WHERE ma.Active = 1
	AND ma.PaymentTypeID <> 64
	AND p.Active = 1
	AND EXISTS (SELECT * FROM SubAccounts sa WHERE sa.Active=1 AND (sa.CancelDate IS NULL OR sa.CancelDate > p.BilledThru) AND sa.PackageID=p.PackageID AND sa.CustomerID=ma.CustomerID)
	AND ((bc.AutoBill = 0 AND pp.PeriodTypeID = 1 AND ((p.ExpireDate IS NULL OR p.ExpireDate = p.BilledThru OR (DATEDIFF(dd,p.ExpireDate,p.BilledThru) <= 30 AND DATEDIFF(dd,p.ExpireDate,p.BilledThru) <= 1) OR (bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= sysdate) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * 30 * pp.Period) THEN DATEADD(dd,bc.RenewDays,p.ExpireDate) ELSE DATEADD(mm,bc.RenewPeriods * pp.Period,p.ExpireDate) END > sysdate)  ))
		OR (bc.AutoBill = 0 AND pp.PeriodTypeID = 2 AND ((bc.RenewDays = 0 AND bc.RenewPeriods = 0 AND DATEADD(dd,p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= sysdate) OR (p.ExpireDate IS NULL OR p.ExpireDate = p.BilledThru) OR (CASE WHEN bc.RenewDays > (bc.RenewPeriods * pp.Period) THEN DATEADD(dd,bc.RenewDays,p.ExpireDate) ELSE DATEADD(dd,bc.RenewPeriods * pp.Period,p.ExpireDate) END > sysdate)  )))
		OR bc.AutoBill = 1)
	AND ma.CustomerID IN (SELECT CustomerID FROM iglc)
	AND ((c.ChargeID IS NOT NULL AND CustomerID_ IS NOT NULL)
		OR (COALESCE(ForceNext_,0) = 0 AND DATEADD(dd,CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,sysdate) >= p.BilledThru) 
		OR (ForceNext_ = 1 AND DATEADD(dd,COALESCE(cgd.NumValue,inv_next_days_ ,90),sysdate) >= p.BilledThru))
	AND (p.CancelDate IS NULL OR p.BilledThru < p.CancelDate)
	AND (ma.CancelDate IS NULL OR p.BilledThru < ma.CancelDate)
	AND InvoiceID_ IS NULL
	AND (OperatorGroupID_ IS NULL OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID =OperatorGroupID_ AND ObjectGroupID = 104 AND BITAND(AccessType,2) = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID =OperatorGroupID_ AND ObjectGroupID = 104 AND BITAND(AccessType,2) = 2))
UNION
SELECT CASE WHEN ma.PaymentTypeID = 8 THEN 2 WHEN ma.PaymentTypeID = 16 THEN 3 ELSE 1 END AS InvoiceTypeID, ma.FirstName, ma.LastName, ma.Company, ma.CustomerID, ma.CountryID, ma.StateID, ma.RegionID, ma.Zip, ma.City, CASE WHEN CustomerID_ IS NOT NULL AND LanguageID_ IS NOT NULL THEN LanguageID_ ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, bc.CycleType
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Charges c ON (ma.CustomerID = c.CustomerID)
	WHERE ma.Active = 1
	AND ma.PaymentTypeID <> 64
	AND c.ItemID IS NULL
	AND c.AllowInterim = 1
	AND c.Quantity > 0
	AND bc.AutoBill IN (0,1)
	AND ma.CustomerID IN (SELECT CustomerID FROM iglc)
	AND c.ChargeID IS NOT NULL
	AND ((ma.CancelDate < sysdate) OR (NOT EXISTS (SELECT * FROM SubAccounts sa WHERE sa.CustomerID = ma.CustomerID AND sa.Active = 1 AND sa.PackageID IS NULL AND DATEADD(dd,interim_lookahead_ + CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,sysdate) > sa.BilledThru)
		AND NOT EXISTS (SELECT * FROM Packages p WHERE p.CustomerID = ma.CustomerID AND p.Active = 1 AND DATEADD(dd,interim_lookahead_ + CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END,sysdate) > p.BilledThru)))
	AND InvoiceID_ IS NULL
	AND (OperatorGroupID_ IS NULL OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID =OperatorGroupID_ AND ObjectGroupID = 104 AND BITAND(AccessType,2) = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID =OperatorGroupID_ AND ObjectGroupID = 104 AND BITAND(AccessType,2) = 2))
UNION
SELECT CASE WHEN ma.PaymentTypeID = 8 THEN 2 WHEN ma.PaymentTypeID = 16 THEN 3 ELSE 1 END AS InvoiceTypeID, ma.FirstName, ma.LastName, ma.Company, ma.CustomerID, ma.CountryID, ma.StateID, ma.RegionID, ma.Zip, ma.City, CASE WHEN CustomerID_ IS NOT NULL AND LanguageID_ IS NOT NULL THEN LanguageID_ ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, bc.CycleType
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Charges c ON (ma.CustomerID = c.CustomerID)
	WHERE ma.Active = 1
	AND c.ItemID IS NULL
	AND c.Quantity > 0
	AND c.AllowInterim = 1
	AND bc.AutoBill = 2
	AND ma.CustomerID IN (SELECT CustomerID FROM iglc)
	AND c.ChargeID IS NOT NULL
	AND InvoiceID_ IS NULL
	AND (OperatorGroupID_ IS NULL OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID =OperatorGroupID_ AND ObjectGroupID = 104 AND BITAND(AccessType,2) = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID =OperatorGroupID_ AND ObjectGroupID = 104 AND BITAND(AccessType,2) = 2))
UNION ALL
SELECT 91 AS InvoiceTypeID, ma.FirstName, ma.LastName, ma.Company, ma.CustomerID, ma.CountryID, ma.StateID, ma.RegionID, ma.Zip, ma.City, CASE WHEN LanguageID_ IS NOT NULL THEN LanguageID_ ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, bc.CycleType
FROM MasterAccounts ma, Invoices i, BillingCycles bc
	WHERE ma.CustomerID = i.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND i.InvoiceID =InvoiceID_
	AND InvoiceID_ IS NOT NULL
	AND i.Processed = 0
	AND i.InvoiceTypeID = 91
	AND i.Estimate = 0
UNION ALL
SELECT DISTINCT 50 AS InvoiceTypeID, ma.FirstName, ma.LastName, ma.Company, ma.CustomerID, ma.CountryID, ma.StateID, ma.RegionID, ma.Zip, ma.City, CASE WHEN CustomerID_ IS NOT NULL AND LanguageID_ IS NOT NULL THEN LanguageID_ ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, bc.CycleType
FROM MasterAccounts ma, BillingCycles bc, Organizations o, Groups g, MasterAccounts ma2, SubAccounts sa2, ResellerUsage ru
	WHERE ma.CustomerID = o.ResellerCustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND g.OrganizationID = o.OrganizationID
	AND g.GroupID = ma2.GroupID
	AND ma.Active = 1
	AND o.InvoiceFractional <> 2
	AND ma.CustomerID IN (SELECT CustomerID FROM iglc)
	AND ma2.CustomerID = sa2.CustomerID
	AND sa2.AccountID = ru.AccountID
	AND ((DATEPART(yy,sysdate) > ru.StartYear) 
		OR (DATEPART(yy,sysdate) = ru.StartYear AND (DATEPART(mm,sysdate)-1 > ru.StartMonth OR (DATEPART(mm,sysdate) > ru.StartMonth AND DATEPART(dd,sysdate) >= 1))))
	AND ru.Days > 0
	AND ru.ItemID IS NULL
	AND InvoiceID_ IS NULL
	AND (OperatorGroupID_ IS NULL OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID =OperatorGroupID_ AND ObjectGroupID = 104 AND BITAND(AccessType,2) = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID =OperatorGroupID_ AND ObjectGroupID = 104 AND BITAND(AccessType,2) = 2))
UNION
SELECT DISTINCT 50 AS InvoiceTypeID, ma.FirstName, ma.LastName, ma.Company, ma.CustomerID, ma.CountryID, ma.StateID, ma.RegionID, ma.Zip, ma.City, CASE WHEN CustomerID_ IS NOT NULL AND LanguageID_ IS NOT NULL THEN LanguageID_ ELSE ma.LanguageID END AS LanguageID, ma.TaxExemptions, bc.AutoBill,
CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END AS IEBillDays, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, bc.CycleType
FROM MasterAccounts ma, BillingCycles bc, Organizations o, Groups g, MasterAccounts ma2, Packages p2, ResellerPkgUsage ru
	WHERE ma.CustomerID = o.ResellerCustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND g.OrganizationID = o.OrganizationID
	AND g.GroupID = ma2.GroupID
	AND ma.Active = 1
	AND o.InvoiceFractional <> 2
	AND ma.CustomerID IN (SELECT CustomerID FROM iglc)
	AND ma2.CustomerID = p2.CustomerID
	AND p2.PackageID = ru.PackageID
	AND ((DATEPART(yy,sysdate) > ru.StartYear) 
		OR (DATEPART(yy,sysdate) = ru.StartYear AND (DATEPART(mm,sysdate)-1 > ru.StartMonth OR (DATEPART(mm,sysdate) > ru.StartMonth AND DATEPART(dd,sysdate) >= 1))))
	AND ru.Days > 0
	AND ru.ItemID IS NULL
	AND InvoiceID_ IS NULL
	AND (OperatorGroupID_ IS NULL OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID =OperatorGroupID_ AND ObjectGroupID = 104 AND BITAND(AccessType,2) = 2) OR 1 IN (SELECT GroupID FROM OperatorGroupAccess WHERE OperatorGroupID =OperatorGroupID_ AND ObjectGroupID = 104 AND BITAND(AccessType,2) = 2))
ORDER BY 5;
DELETE FROM iglc;
END;
END;
/

CREATE OR REPLACE PROCEDURE InvoiceGetPOSItems (crInvoiceGetPOSItems1 IN OUT ieatypes.CursorType,InvoiceID_ IN INTEGER) AS
BEGIN
OPEN crInvoiceGetPOSItems1 FOR SELECT ItemID, ItemType, Login, Days, Description, StartDate, EndDate, AccountID, PackageID, Amount, Quantity, TaxGroupID, ChargeTypeID
FROM InvoiceItems 
	WHERE InvoiceID=InvoiceID_;
END;
/

CREATE OR REPLACE PROCEDURE InvoiceGetResellerItems (crInvoiceGetResellerItems1 IN OUT ieatypes.CursorType,crInvoiceGetResellerItems2 IN OUT ieatypes.CursorType,crInvoiceGetResellerItems3 IN OUT ieatypes.CursorType,crInvoiceGetResellerItems4 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
OPEN crInvoiceGetResellerItems1 FOR SELECT 2 AS ItemType, sa2.AccountID, at2.AccountTypeID, COALESCE(sa2.Login,sa2.Email) AS Login, at2.AccountType AS Description, at2.StringID, COALESCE(oat.ResellerCost,at2.Cost) * CASE WHEN ru.Days >= 27.5 OR o.InvoiceFractional = 0 THEN 1 ELSE (CASE WHEN CAST(ru.Days AS INT) = ru.Days THEN ru.Days ELSE (CAST(ru.Days AS INT) + 1) END) / 30 END AS Amount, 1 AS Quantity, 0 AS QuantityType, at2.TaxGroupID, at2.TaxExemptions, CASE WHEN ru.Days >= 27.5 OR o.InvoiceFractional = 0 THEN 0 ELSE CASE WHEN CAST(ru.Days AS INT) = ru.Days THEN ru.Days ELSE (CAST(ru.Days AS INT) + 1) END END AS Days,DATEADD(mm,-(DATEPART(mm,sysdate)-ru.StartMonth),DATEADD(yy,-(DATEPART(yy,sysdate)-ru.StartYear),sysdate)) AS StartDate
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (o.ResellerCustomerID =CustomerID_)
	JOIN Groups g ON (o.OrganizationID = g.OrganizationID)
	JOIN MasterAccounts ma2 ON (g.GroupID = ma2.GroupID)
	JOIN SubAccounts sa2 ON (ma2.CustomerID = sa2.CustomerID)
	JOIN ResellerUsage ru ON (sa2.AccountID = ru.AccountID)
	JOIN AccountTypes at2 ON (ru.AccountTypeID = at2.AccountTypeID)
	LEFT JOIN OrgAccountTypes oat ON (o.OrganizationID = oat.OrganizationID AND at2.AccountTypeID = oat.AccountTypeID)
	WHERE ma.CustomerID =CustomerID_
	AND ma.Active = 1
	AND o.InvoiceFractional <> 2
	AND ((DATEPART(yy,sysdate) > ru.StartYear) 
		OR (DATEPART(yy,sysdate) = ru.StartYear AND (DATEPART(mm,sysdate)-1 > ru.StartMonth OR (DATEPART(mm,sysdate) > ru.StartMonth))))
	AND ru.Days > 0
	AND ru.ItemID IS NULL
	AND o.InvoiceDetailed = 1;
OPEN crInvoiceGetResellerItems2 FOR SELECT 2 AS ItemType, p2.PackageID, pt2.PackageTypeID, pt2.PackageType AS Description, pt2.StringID, COALESCE(opt.ResellerCost,pt2.Cost) * CASE WHEN ru.Days >= 27.5 OR o.InvoiceFractional = 0 THEN 1 ELSE (CASE WHEN CAST(ru.Days AS INT) = ru.Days THEN ru.Days ELSE (CAST(ru.Days AS INT) + 1) END) / 30 END AS Amount, 1 AS Quantity, 0 AS QuantityType, pt2.TaxGroupID, pt2.TaxExemptions, CASE WHEN ru.Days >= 27.5 OR o.InvoiceFractional = 0 THEN 0 ELSE CASE WHEN CAST(ru.Days AS INT) = ru.Days THEN ru.Days ELSE (CAST(ru.Days AS INT) + 1) END END AS Days,DATEADD(mm,-(DATEPART(mm,sysdate)-ru.StartMonth),DATEADD(yy,-(DATEPART(yy,sysdate)-ru.StartYear),sysdate)) AS StartDate
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (o.ResellerCustomerID =CustomerID_)
	JOIN Groups g ON (o.OrganizationID = g.OrganizationID)
	JOIN MasterAccounts ma2 ON (g.GroupID = ma2.GroupID)
	JOIN Packages p2 ON (ma2.CustomerID = p2.CustomerID)
	JOIN ResellerPkgUsage ru ON (p2.PackageID = ru.PackageID)
	JOIN PackageTypes pt2 ON (ru.PackageTypeID = pt2.PackageTypeID)
	LEFT JOIN OrgPackageTypes opt ON (o.OrganizationID = opt.OrganizationID AND pt2.PackageTypeID = opt.PackageTypeID)
	WHERE ma.CustomerID =CustomerID_
	AND ma.Active = 1
	AND o.InvoiceFractional <> 2
	AND ((DATEPART(yy,sysdate) > ru.StartYear) 
		OR (DATEPART(yy,sysdate) = ru.StartYear AND (DATEPART(mm,sysdate)-1 > ru.StartMonth OR (DATEPART(mm,sysdate) > ru.StartMonth))))
	AND ru.Days > 0
	AND ru.ItemID IS NULL
	AND o.InvoiceDetailed = 1;
OPEN crInvoiceGetResellerItems3 FOR SELECT 2 AS ItemType, ru.AccountTypeID, MIN(at2.AccountType) AS Description, MIN(at2.StringID) AS StringID, COUNT(*) AS RCount,ROUND(SUM(CASE WHEN (o.InvoiceFractional = 0 AND ru.Days > 0) OR ru.Days >= 27.5 THEN 30 ELSE ru.Days END) / 30,0) AS Quantity,MIN(COALESCE(oat.ResellerCost,at2.Cost)) AS Amount, 0 AS QuantityType, MIN(at2.TaxGroupID) AS TaxGroupID, MIN(at2.TaxExemptions) AS TaxExemptions,DATEADD(mm,-(DATEPART(mm,sysdate)-ru.StartMonth),DATEADD(yy,-(DATEPART(yy,sysdate)-ru.StartYear),sysdate)) AS StartDate
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (o.ResellerCustomerID =CustomerID_)
	JOIN Groups g ON (o.OrganizationID = g.OrganizationID)
	JOIN MasterAccounts ma2 ON (g.GroupID = ma2.GroupID)
	JOIN SubAccounts sa2 ON (ma2.CustomerID = sa2.CustomerID)
	JOIN ResellerUsage ru ON (sa2.AccountID = ru.AccountID)
	JOIN AccountTypes at2 ON (ru.AccountTypeID = at2.AccountTypeID)
	LEFT JOIN OrgAccountTypes oat ON (o.OrganizationID = oat.OrganizationID AND at2.AccountTypeID = oat.AccountTypeID)
	WHERE ma.CustomerID =CustomerID_
	AND ma.Active = 1
	AND o.InvoiceFractional <> 2
	AND ((DATEPART(yy,sysdate) > ru.StartYear) 
		OR (DATEPART(yy,sysdate) = ru.StartYear AND (DATEPART(mm,sysdate)-1 > ru.StartMonth OR (DATEPART(mm,sysdate) > ru.StartMonth))))
	AND ru.ItemID IS NULL
	AND o.InvoiceDetailed = 0
GROUP BY ru.StartYear,ru.StartMonth,ru.AccountTypeID;
OPEN crInvoiceGetResellerItems4 FOR SELECT 2 AS ItemType, ru.PackageTypeID, MIN(pt2.PackageType) AS Description, MIN(pt2.StringID) AS StringID, COUNT(*) AS RCount,ROUND(SUM(CASE WHEN (o.InvoiceFractional = 0 AND ru.Days > 0) OR ru.Days >= 27.5 THEN 30 ELSE ru.Days END) / 30,0) AS Quantity,MIN(COALESCE(opt.ResellerCost,pt2.Cost)) AS Amount, 0 AS QuantityType, MIN(pt2.TaxGroupID) AS TaxGroupID, MIN(pt2.TaxExemptions) AS TaxExemptions,DATEADD(mm,-(DATEPART(mm,sysdate)-ru.StartMonth),DATEADD(yy,-(DATEPART(yy,sysdate)-ru.StartYear),sysdate)) AS StartDate
FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (o.ResellerCustomerID =CustomerID_)
	JOIN Groups g ON (o.OrganizationID = g.OrganizationID)
	JOIN MasterAccounts ma2 ON (g.GroupID = ma2.GroupID)
	JOIN Packages p2 ON (ma2.CustomerID = p2.CustomerID)
	JOIN ResellerPkgUsage ru ON (p2.PackageID = ru.PackageID)
	JOIN PackageTypes pt2 ON (ru.PackageTypeID = pt2.PackageTypeID)
	LEFT JOIN OrgPackageTypes opt ON (o.OrganizationID = opt.OrganizationID AND pt2.PackageTypeID = opt.PackageTypeID)
	WHERE ma.CustomerID =CustomerID_
	AND ma.Active = 1
	AND o.InvoiceFractional <> 2
	AND ((DATEPART(yy,sysdate) > ru.StartYear) 
		OR (DATEPART(yy,sysdate) = ru.StartYear AND (DATEPART(mm,sysdate)-1 > ru.StartMonth OR (DATEPART(mm,sysdate) > ru.StartMonth))))
	AND ru.ItemID IS NULL
	AND o.InvoiceDetailed = 0
GROUP BY ru.StartYear,ru.StartMonth,ru.PackageTypeID;
END;
/

CREATE OR REPLACE PROCEDURE InvoiceItemAdd (crInvoiceItemAdd1 IN OUT ieatypes.CursorType,InvoiceID_ IN INTEGER,BillStatus_ IN INTEGER,ItemType_ IN INTEGER,Days_ IN INTEGER,Quantity_ IN INTEGER,Amount_ IN NUMERIC,Login_ IN VARCHAR2,Description_ IN VARCHAR2,StartDate_ IN DATE,EndDate_ IN DATE,AccountID_ IN INTEGER,AccountTypeID_ IN INTEGER,PackageID_ IN INTEGER,PackageTypeID_ IN INTEGER,ChargeID_ IN INTEGER,ChargeTypeID_ IN INTEGER,CycleMonths_ IN INTEGER,TaxID_ IN INTEGER,TaxGroupID_ IN INTEGER,ParentItemID_ IN INTEGER) AS
BEGIN
INSERT INTO InvoiceItems (InvoiceID,BillStatus,ItemType,Days,Quantity,Amount,Login,Description,StartDate,EndDate,AccountID,AccountTypeID,PackageID,PackageTypeID,ChargeID,ChargeTypeID,CycleMonths,TaxID,TaxGroupID,ParentItemID)
VALUES(InvoiceID_,BillStatus_ ,ItemType_ ,Days_ ,Quantity_ ,Amount_ ,Login_ ,Description_ ,StartDate_ ,EndDate_ ,AccountID_ ,AccountTypeID_ ,PackageID_ ,PackageTypeID_ ,ChargeID_ ,ChargeTypeID_ ,CycleMonths_ ,TaxID_ ,TaxGroupID_ ,ParentItemID_ );
OPEN crInvoiceItemAdd1 FOR SELECT LAST.IDENT AS ItemID
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE InvoiceItemPaid (ItemID_ IN INTEGER) AS
BEGIN
DECLARE
TimeChargeID_ INTEGER;
AutoBill_ INTEGER;
CustomerID_ INTEGER;
AccountID_ INTEGER;
PackageID_ INTEGER;
Quantity_ INTEGER;
Months_ INTEGER;
Days_ INTEGER;
Minutes_ INTEGER;
TimeLeft_ INTEGER;
DataLeft_ NUMBER(38);
PaidFlag_ INTEGER;
trackmode_ INTEGER;
BEGIN

SELECT MAX(bc.AutoBill),MAX(tc.TimeChargeID),MAX(sa.CustomerID),MAX(sa.AccountID),MAX(ii.Quantity),MAX(tc.Months * ii.Quantity),MAX(tc.Days * ii.Quantity),MAX(tc.Minutes * ii.Quantity),MAX(tc.TimeLeft * ii.Quantity),MAX(tc.DataLeft * ii.Quantity),MAX(ii.PaidFlag) INTO AutoBill_,TimeChargeID_,CustomerID_,AccountID_,Quantity_,Months_,Days_,Minutes_,TimeLeft_,DataLeft_,PaidFlag_ 

FROM InvoiceItems ii, Invoices i, TimeCharges tc, SubAccounts sa, MasterAccounts ma, BillingCycles bc
	WHERE i.InvoiceID = ii.InvoiceID
	AND tc.ChargeTypeID = ii.ChargeTypeID
	AND sa.AccountTypeID = tc.AccountTypeID
	AND ii.AccountID = sa.AccountID
	AND ii.ItemID =ItemID_
	AND sa.CustomerID = ma.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND ma.Active = 1
	AND sa.Active = 1;
IF (TimeChargeID_ IS NULL) THEN
SELECT MAX(bc.AutoBill),MAX(tc.TimeChargeID),MAX(p.CustomerID),MAX(p.PackageID),MAX(ii.Quantity),MAX(tc.Months * ii.Quantity),MAX(tc.Days * ii.Quantity),MAX(tc.Minutes * ii.Quantity),MAX(tc.TimeLeft * ii.Quantity),MAX(tc.DataLeft * ii.Quantity),MAX(ii.PaidFlag) INTO AutoBill_,TimeChargeID_,CustomerID_,PackageID_,Quantity_,Months_,Days_,Minutes_,TimeLeft_,DataLeft_,PaidFlag_ 

FROM InvoiceItems ii, Invoices i, TimeCharges tc, Packages p, MasterAccounts ma, BillingCycles bc
	WHERE i.InvoiceID = ii.InvoiceID
	AND tc.ChargeTypeID = ii.ChargeTypeID
	AND p.PackageTypeID = tc.PackageTypeID
	AND ii.PackageID = p.PackageID
	AND ii.ItemID =ItemID_
	AND p.CustomerID = ma.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND ma.Active = 1
	AND p.Active = 1;
END IF;

SELECT NumValue INTO trackmode_  FROM Configs WHERE ConfigID = 535;
SELECT COALESCE(MAX(cgd.NumValue),trackmode_ ) INTO trackmode_ 

FROM ConfigGroupData cgd, MasterAccounts ma
	WHERE ma.CustomerID =CustomerID_
	AND ma.GroupID = cgd.GroupID
	AND cgd.ConfigID = 535;
IF (TimeChargeID_ IS NOT NULL AND PaidFlag_ = 0 AND Quantity_ > 0 AND AccountID_ IS NOT NULL) THEN

IF (trackmode_ = 2 AND (TimeLeft_ > 0 OR DataLeft_ > 0)) THEN
	INSERT INTO SubAccountUsages (AccountID,ItemID,TimeLeft,DataLeft,StartTimeLeft,StartDataLeft,ExpireDate)
	SELECT AccountID_,ItemID_ ,TimeLeft_ ,DataLeft_ ,TimeLeft_ ,DataLeft_ , CASE WHEN Months_ IS NULL AND Days_ IS NULL AND Minutes_ IS NULL THEN DATEADD(yy,2,sysdate) ELSE DATEADD(mi,COALESCE(Minutes_,0),DATEADD(mm,COALESCE(Months_,0),DATEADD(dd,COALESCE(Days_,0),sysdate))) END
	FROM SubAccounts
		WHERE AccountID =AccountID_;
END IF;

UPDATE SubAccounts SET 
	BilledThru = CASE WHEN AutoBill_ = 2 THEN DATEADD(mi,COALESCE(Minutes_,0),DATEADD(mm,COALESCE(Months_,0),DATEADD(dd,COALESCE(Days_,0),CASE WHEN Months_ IS NULL AND Days_ IS NULL AND Minutes_ IS NULL THEN BilledThru WHEN COALESCE(ExpireDate,BilledThru) < sysdate THEN sysdate ELSE COALESCE(ExpireDate,BilledThru) END))) ELSE BilledThru END,
	ExpireDate = CASE WHEN AutoBill_ = 2 THEN DATEADD(mi,COALESCE(Minutes_,0),DATEADD(mm,COALESCE(Months_,0),DATEADD(dd,COALESCE(Days_,0),CASE WHEN Months_ IS NULL AND Days_ IS NULL AND Minutes_ IS NULL THEN ExpireDate WHEN ExpireDate < sysdate THEN sysdate ELSE ExpireDate END))) ELSE ExpireDate END,
	TimeLeft = CASE WHEN TimeLeft_ IS NULL OR TimeLeft IS NULL OR trackmode_ = 2 THEN TimeLeft WHEN AutoBill_ = 2 AND ExpireDate < sysdate THEN TimeLeft_ WHEN TimeLeft >= 0 THEN TimeLeft + TimeLeft_ ELSE TimeLeft_ END,
	DataLeft = CASE WHEN DataLeft_ IS NULL OR DataLeft IS NULL OR trackmode_ = 2 THEN DataLeft WHEN AutoBill_ = 2 AND ExpireDate < sysdate THEN DataLeft_ WHEN DataLeft >= 0 THEN DataLeft + DataLeft_ ELSE DataLeft_ END
	WHERE AccountID=AccountID_;
UPDATE InvoiceItems SET PaidFlag = 1 WHERE ItemID =ItemID_;
END IF;

IF (TimeChargeID_ IS NOT NULL AND PaidFlag_ = 0 AND Quantity_ > 0 AND PackageID_ IS NOT NULL) THEN

IF (trackmode_ = 2 AND (TimeLeft_ > 0 OR DataLeft_ > 0)) THEN
	INSERT INTO SubAccountUsages (AccountID,ItemID,TimeLeft,DataLeft,StartTimeLeft,StartDataLeft,ExpireDate)
	SELECT AccountID,ItemID_ ,TimeLeft_ ,DataLeft_ ,TimeLeft_ ,DataLeft_ , CASE WHEN Months_ IS NULL AND Days_ IS NULL AND Minutes_ IS NULL THEN DATEADD(yy,2,sysdate) ELSE DATEADD(mi,COALESCE(Minutes_,0),DATEADD(mm,COALESCE(Months_,0),DATEADD(dd,COALESCE(Days_,0),sysdate))) END
	FROM SubAccounts
		WHERE PackageID =PackageID_
		AND Active = 1;
END IF;

UPDATE Packages SET 
	BilledThru = CASE WHEN AutoBill_ = 2 THEN DATEADD(mi,COALESCE(Minutes_,0),DATEADD(mm,COALESCE(Months_,0),DATEADD(dd,COALESCE(Days_,0),CASE WHEN Months_ IS NULL AND Days_ IS NULL AND Minutes_ IS NULL THEN BilledThru WHEN COALESCE(ExpireDate,BilledThru) < sysdate THEN sysdate ELSE COALESCE(ExpireDate,BilledThru) END))) ELSE BilledThru END,
	ExpireDate = CASE WHEN AutoBill_ = 2 THEN DATEADD(mi,COALESCE(Minutes_,0),DATEADD(mm,COALESCE(Months_,0),DATEADD(dd,COALESCE(Days_,0),CASE WHEN Months_ IS NULL AND Days_ IS NULL AND Minutes_ IS NULL THEN ExpireDate WHEN ExpireDate < sysdate THEN sysdate ELSE ExpireDate END))) ELSE ExpireDate END
	WHERE PackageID=PackageID_;
UPDATE SubAccounts SET 
	BilledThru = CASE WHEN AutoBill_ = 2 THEN DATEADD(mi,COALESCE(Minutes_,0),DATEADD(mm,COALESCE(Months_,0),DATEADD(dd,COALESCE(Days_,0),CASE WHEN Months_ IS NULL AND Days_ IS NULL AND Minutes_ IS NULL THEN BilledThru WHEN COALESCE(ExpireDate,BilledThru) < sysdate THEN sysdate ELSE COALESCE(ExpireDate,BilledThru) END))) ELSE BilledThru END,
	ExpireDate = CASE WHEN AutoBill_ = 2 THEN DATEADD(mi,COALESCE(Minutes_,0),DATEADD(mm,COALESCE(Months_,0),DATEADD(dd,COALESCE(Days_,0),CASE WHEN Months_ IS NULL AND Days_ IS NULL AND Minutes_ IS NULL THEN ExpireDate WHEN ExpireDate < sysdate THEN sysdate ELSE ExpireDate END))) ELSE ExpireDate END,
	TimeLeft = CASE WHEN TimeLeft_ IS NULL OR TimeLeft IS NULL OR trackmode_ = 2 THEN TimeLeft WHEN AutoBill_ = 2 AND ExpireDate < sysdate THEN TimeLeft_ WHEN TimeLeft >= 0 THEN TimeLeft + TimeLeft_ ELSE TimeLeft_ END,
	DataLeft = CASE WHEN DataLeft_ IS NULL OR DataLeft IS NULL OR trackmode_ = 2 THEN DataLeft WHEN AutoBill_ = 2 AND ExpireDate < sysdate THEN DataLeft_ WHEN DataLeft >= 0 THEN DataLeft + DataLeft_ ELSE DataLeft_ END
	WHERE PackageID=PackageID_
	AND Active=1;
UPDATE InvoiceItems SET PaidFlag = 1 WHERE ItemID =ItemID_;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE InvoiceVoidCheck (crInvoiceVoidCheck1 IN OUT ieatypes.CursorType,InvoiceID_ IN INTEGER) AS
BEGIN
DECLARE
CheckOrder_ INTEGER;
BEGIN
SELECT NumValue INTO CheckOrder_  FROM Configs WHERE ConfigID = 644;
OPEN crInvoiceVoidCheck1 FOR SELECT CASE WHEN MIN(COALESCE(cgd.NumValue,CheckOrder_ ,1)) = 1 THEN MIN(i2.InvoiceID) ELSE NULL END AS InvoiceID
FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN Invoices i2 ON (i2.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii2 ON (i2.InvoiceID = ii2.InvoiceID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 644)
	WHERE i.InvoiceID =InvoiceID_
	AND ii.ItemType = 3
	AND ii.Canceled = 0
	AND ii2.Canceled = 0
	AND ii2.ItemType = 3
	AND (ii.AccountID = ii2.AccountID OR ii.PackageID = ii2.PackageID)
	AND i2.VoidDate IS NULL
	AND ii2.StartDate >= ii.StartDate
	AND ii2.InvoiceID <> InvoiceID_
GROUP BY ma.GroupID;
END;
END;
/

CREATE OR REPLACE PROCEDURE InvoiceVoidDupeCharges (InvoiceID_ IN INTEGER) AS
BEGIN
INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,AccountID,PackageID,Login,AccountTypeID,PackageTypeID,Prorated,Amount,Quantity,TaxGroupID,ChargeTypeID,ItemID,Operator,LastModifyDate,LastModifyUser,PrevChargeID)
SELECT c.CustomerID,c.Description,c.StartDate,c.EndDate,c.AccountID,c.PackageID,c.Login,c.AccountTypeID,c.PackageTypeID,c.Prorated,c.Amount,c.Quantity,c.TaxGroupID,c.ChargeTypeID,NULL AS ItemID,c.Operator,c.LastModifyDate,c.LastModifyUser,c.ChargeID
FROM Charges c, InvoiceItems ii
	WHERE c.ItemID = ii.ItemID
	AND ii.InvoiceID =InvoiceID_;

MERGE INTO VoiceCalls mvc
USING (SELECT vc.VoiceCallID, c.ChargeID
FROM VoiceCalls vc, Invoices i, Charges c
	WHERE i.InvoiceID =InvoiceID_
	AND i.CustomerID = c.CustomerID
	AND c.ItemID IS NULL
	AND c.PrevChargeID IS NOT NULL
	AND vc.ChargeID = c.PrevChargeID) vc
ON (mvc.VoiceCallID = vc.VoiceCallID)
WHEN MATCHED THEN UPDATE SET mvc.ChargeID = vc.ChargeID;


UPDATE ResellerUsage SET ItemID = NULL WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID =InvoiceID_);
UPDATE ResellerPkgUsage SET ItemID = NULL WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID =InvoiceID_);
END;
/

CREATE OR REPLACE PROCEDURE InvoiceVoidSAUpdate (crInvoiceVoidSAUpdate1 IN OUT ieatypes.CursorType,InvoiceID_ IN INTEGER) AS
BEGIN
DECLARE
counter_ INTEGER;
BEGIN


SELECT 1 INTO counter_ 


 FROM DUAL;
UPDATE Charges SET DistFlag = 1 WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE Amount < 0 AND Quantity > 0 AND InvoiceID =InvoiceID_);
UPDATE SubAccounts SET TimeLeft = TimeLeft - COALESCE((SELECT SUM(sau.StartTimeLeft - CASE WHEN sau.TimeLeft < 0 THEN 0 ELSE sau.TimeLeft END)
	FROM SubAccountUsages sau, InvoiceItems ii 
		WHERE sau.ItemID = ii.ItemID
		AND sau.StartTimeLeft IS NOT NULL
		AND sau.AccountID = SubAccounts.AccountID
		AND ii.InvoiceID =InvoiceID_),0),
	DataLeft = DataLeft - COALESCE((SELECT SUM(sau.StartDataLeft - CASE WHEN sau.DataLeft < 0 THEN 0 ELSE sau.DataLeft END)
	FROM SubAccountUsages sau, InvoiceItems ii 
		WHERE sau.ItemID = ii.ItemID
		AND sau.StartDataLeft IS NOT NULL
		AND sau.AccountID = SubAccounts.AccountID
		AND ii.InvoiceID =InvoiceID_),0)

	WHERE Active = 1
	AND (TimeLeft IS NOT NULL OR DataLeft IS NOT NULL)
	AND AccountID IN (SELECT DISTINCT AccountID FROM InvoiceItems WHERE InvoiceID =InvoiceID_);
DELETE FROM SubAccountUsages WHERE ItemID IN (SELECT ItemID FROM InvoiceItems WHERE InvoiceID =InvoiceID_);
WHILE(counter_ > 0) LOOP

INSERT INTO ivsau (PackageID, AutoBill, ExpireDate, BilledThru, PackageTypeID, CycleMonths, BillStatus)
SELECT p.PackageID, bc.AutoBill,
CASE WHEN bc.AutoBill = 1 THEN NULL WHEN ii.ItemType = 2 AND ExpireDate > ii.StartDate THEN DATEADD(dd,-1,ii.StartDate) WHEN ii.ItemType = 3 AND DATEADD(dd,1,ii.StartDate) > sysdate AND ExpireDate > ii.StartDate THEN DATEADD(dd,CASE WHEN ii.StartDate > sysdate THEN -1 ELSE 0 END,ii.StartDate) ELSE ExpireDate END AS ExpireDate,
DATEADD(dd,-1,ii.StartDate) AS BilledThru,
COALESCE((SELECT pt2.PackageTypeID FROM PackageTypes pt2 WHERE pt2.PackageTypeID=ii.PackageTypeID AND NextCount IS NOT NULL AND NextID IS NOT NULL),p.PackageTypeID) AS PackageTypeID,
COALESCE(ii.CycleMonths, p.CycleMonths) AS CycleMonths, ii.BillStatus
FROM Packages p, MasterAccounts ma, Invoices i, InvoiceItems ii, BillingCycles bc
	WHERE ma.CustomerID = p.CustomerID
	AND ma.CustomerID = i.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND i.InvoiceID = ii.InvoiceID
	AND i.VoidDate IS NOT NULL
	AND p.BilledThru = ii.EndDate
	AND ii.AccountID IS NULL
	AND ii.ItemType IN (2,3)
	AND ii.PackageID = p.PackageID
	AND ma.Active = 1
	AND p.Active = 1
	AND i.InvoiceID =InvoiceID_;
SELECT COUNT(*)  INTO counter_ 

FROM ivsau;
IF (counter_ > 0) THEN

MERGE INTO Packages mp
USING (SELECT PackageID, ExpireDate, BilledThru, PackageTypeID, CycleMonths, BillStatus FROM ivsau) p
ON (mp.PackageID = p.PackageID)
WHEN MATCHED THEN UPDATE SET mp.ExpireDate = p.ExpireDate, mp.BilledThru = p.BilledThru, mp.PackageTypeID = p.PackageTypeID, mp.CycleMonths = p.CycleMonths, mp.BillStatus = p.BillStatus;


MERGE INTO SubAccounts msa
USING (SELECT PackageID, AutoBill, ExpireDate, BilledThru FROM ivsau WHERE AutoBill <> 2) sa
ON (msa.PackageID = sa.PackageID AND msa.Active = 1)
WHEN MATCHED THEN UPDATE SET msa.ExpireDate = sa.ExpireDate, msa.BilledThru = sa.BilledThru;


DELETE FROM ivsau;
END IF;

MERGE INTO SubAccounts msa
USING (SELECT sa.AccountID, CASE WHEN bc.AutoBill = 1 THEN NULL WHEN ii.ItemType = 2 AND ExpireDate > ii.StartDate THEN DATEADD(dd,-1,ii.StartDate) WHEN ii.ItemType = 3 AND DATEADD(dd,1,ii.StartDate) > sysdate AND ExpireDate > ii.StartDate THEN DATEADD(dd,CASE WHEN ii.StartDate > sysdate THEN -1 ELSE 0 END,ii.StartDate) ELSE ExpireDate END AS ExpireDate,
	DATEADD(dd,-1,ii.StartDate) AS BilledThru,
	COALESCE((SELECT at2.AccountTypeID FROM AccountTypes at2 WHERE at2.AccountTypeID=ii.AccountTypeID AND NextCount IS NOT NULL AND NextID IS NOT NULL),sa.AccountTypeID) AS AccountTypeID, 
	COALESCE(ii.CycleMonths, sa.CycleMonths) AS CycleMonths, 
	ii.BillStatus
FROM SubAccounts sa, MasterAccounts ma, Invoices i, InvoiceItems ii, BillingCycles bc
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND i.CustomerID = ma.CustomerID
	AND i.VoidDate IS NOT NULL
	AND i.InvoiceID = ii.InvoiceID
	AND sa.BilledThru = ii.EndDate
	AND sa.AccountID = ii.AccountID
	AND ii.ItemType IN (2,3)
	AND ii.StartDate <= ii.EndDate
	AND ma.Active = 1
	AND sa.Active = 1
	AND i.InvoiceID =InvoiceID_) sa
ON (msa.AccountID = sa.AccountID)
WHEN MATCHED THEN UPDATE SET msa.ExpireDate = sa.Expiredate, msa.BilledThru = sa.BilledThru, msa.AccountTypeID = sa.AccountTypeID, msa.CycleMonths = sa.CycleMonths, msa.BillStatus = sa.BillStatus;

counter_ := counter_ + SQL%ROWCOUNT;


END LOOP;

OPEN crInvoiceVoidSAUpdate1 FOR SELECT CustomerID,InvoiceTypeID 
FROM Invoices 
	WHERE InvoiceID =InvoiceID_;
DELETE FROM ivsau;
END;
END;
/

CREATE OR REPLACE PROCEDURE LDAPrfc822mailbox (crLDAPrfc822mailbox1 IN OUT ieatypes.CursorType,accountid_ IN INTEGER) AS
BEGIN

OPEN crLDAPrfc822mailbox1 FOR SELECT CASE WHEN sa.Email LIKE '%___%' THEN sa.Email ELSE sa.Login || '@' || d.MailDomain END AS mail
FROM SubAccounts sa, Domains d
	WHERE sa.DomainID = d.DomainID
	AND sa.AccountID =accountid_
UNION
SELECT Alias as mail FROM Aliases WHERE AccountID =accountid_ AND Alias LIKE '%___%';
END;
/

CREATE OR REPLACE PROCEDURE LDAPmailAlternateAddress (crLDAPmailAlternateAddress1 IN OUT ieatypes.CursorType,accountid_ IN INTEGER) AS
BEGIN

OPEN crLDAPmailAlternateAddress1 FOR SELECT Alias as mail 
FROM Aliases 
	WHERE AccountID =accountid_;
END;
/

CREATE OR REPLACE PROCEDURE LDAPmailForwardingAddress (crLDAPmailForwardingAddress1 IN OUT ieatypes.CursorType,accountid_ IN INTEGER) AS
BEGIN

OPEN crLDAPmailForwardingAddress1 FOR SELECT Forward 
FROM Forwards 
	WHERE AccountID =accountid_;
END;
/

CREATE OR REPLACE PROCEDURE LDAPSetLastModifyDate (type_ IN VARCHAR2,id_ IN VARCHAR2) AS
BEGIN
IF (type_ = 'read') THEN
UPDATE LDAPServers SET LastModifyDate = sysdate, LastSyncRead = sysdate, Calls = Calls + 1 WHERE LDAPServer =id_;
IF (SQL%ROWCOUNT = 0) THEN
	INSERT INTO LDAPServers (LDAPServer,LastSyncWrite,LastModifyDate,LastSyncRead,Calls) VALUES(id_,DATEADD(yy,-20,sysdate),sysdate,sysdate,1);
END IF;
END IF;

IF (type_ = 'write') THEN
UPDATE LDAPServers SET LastModifyDate = sysdate, LastSyncWrite = COALESCE(LastSyncRead,sysdate), Calls = Calls + 1 WHERE LDAPServer =id_;
IF (SQL%ROWCOUNT = 0) THEN
	INSERT INTO LDAPServers (LDAPServer,LastModifyDate,LastSyncWrite,Calls) VALUES(id_,sysdate,sysdate,1);
END IF;
END IF;

IF (type_ = 'reset') THEN
UPDATE LDAPServers SET LastSyncWrite = DATEADD(yy,-20,sysdate) WHERE LDAPServer =id_;
END IF;

END;
/

CREATE OR REPLACE PROCEDURE ListDomainUsers (crListDomainUsers1 IN OUT ieatypes.CursorType,domain_ IN VARCHAR2,esid_ IN INTEGER) AS
BEGIN
DECLARE
DomainID_ INTEGER;
BEGIN
SELECT MAX(DomainID) INTO DomainID_  FROM Domains WHERE MailDomain = domain_;
IF (DomainID_ IS NOT NULL) THEN
OPEN crListDomainUsers1 FOR SELECT COALESCE(sa.Login,SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1)) AS Username
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1, ExternalSystemAccountTypes esat
WHERE ma.CustomerID = sa.CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND ((sa.Login IS NOT NULL AND sa.DomainID =DomainID_) OR (sa.Login IS NULL AND sa.Email LIKE '%_@' || domain_) )
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =esid_;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE ListMailUsers (crListMailUsers1 IN OUT ieatypes.CursorType,esid_ IN INTEGER) AS
BEGIN
OPEN crListMailUsers1 FOR SELECT Login, Login AS Shell, sa.Email, d.MailDomain, Password, sad.Data as HomeDir 
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystemAccountTypes esat ON (at1.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID)
	WHERE esat.ExternalSystemID =esid_
	AND sad.AccountDataTypeID = 2
	AND ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND ma.StartDate < sysdate

UNION ALL

SELECT Login, Login AS Shell, a.Alias AS Email, d.MailDomain, Password, sad.Data AS HomeDir
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN Aliases a ON (sa.AccountID = a.AccountID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystemAccountTypes esat ON (at1.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID)
	WHERE esat.ExternalSystemID =esid_
	AND sad.AccountDataTypeID = 2
	AND ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND ma.StartDate < sysdate;
END;
/

CREATE OR REPLACE PROCEDURE MapGetAttributes (crMapGetAttributes1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crMapGetAttributes1 FOR SELECT MapAttribute, RadAttributeID,RadVendorID,RadMapTypeID
FROM RadMapAttributes;
END;
/

CREATE OR REPLACE PROCEDURE MapGetValues (crMapGetValues1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crMapGetValues1 FOR SELECT MapAttribute,MapValue,RadValue,RadMapTypeID
FROM RadMapValues
ORDER BY MapAttribute,RadMapTypeID;
END;
/

CREATE OR REPLACE PROCEDURE MBRAddresses (crMBRAddresses1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
OPEN crMBRAddresses1 FOR SELECT c.Country, s.State, a.Email, a.AddressID, at2.AddressType, Address1, Address2, City, Zip, FirstName, LastName, Phone
FROM Addresses a JOIN AddressTypes at2 ON (a.AddressTypeID=at2.AddressTypeID)
	LEFT JOIN Countries c ON (a.CountryID=c.CountryID)
	LEFT JOIN States s ON (a.StateID=s.StateID)
	WHERE a.CustomerID=CustomerID_
ORDER BY at2.SortOrder;

END;
/

CREATE OR REPLACE PROCEDURE MBRAging (crMBRAging1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
OPEN crMBRAging1 FOR SELECT ma.CustomerID, End0Bal AS Balance0,
	CASE WHEN End30Bal > 0 THEN End30Bal ELSE 0 END AS Balance30,
	CASE WHEN End60Bal > 0 THEN End60Bal ELSE 0 END AS Balance60,
	CASE WHEN End90Bal > 0 THEN End90Bal ELSE 0 END AS Balance90,
	CASE WHEN End120Bal > 0 THEN End120Bal ELSE 0 END AS Balance120,
	ma.Over30Count, ma.Over60Count, ma.Over90Count, ma.Over120Count, s.StatementDate AS AgedDate
FROM MasterAccounts ma, Statements s
	WHERE ma.LastStatementID = s.StatementID
	AND ma.CustomerID =CustomerID_;
END;
/

CREATE OR REPLACE PROCEDURE MBRCCLoad (crMBRCCLoad1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
OPEN crMBRCCLoad1 FOR SELECT cc.CardNumber, DatePart(yy, cc.ExpirationDate) as ExpireYear, 
CASE WHEN DatePart(mm, cc.ExpirationDate) < 10 THEN '0' || CAST(DATEPART(mm,cc.ExpirationDate) AS VARCHAR(5)) ELSE CAST(DATEPART(mm,cc.ExpirationDate) AS VARCHAR(5)) END as ExpireMonth, 
cc.CardHolder, cc.BillToAddress1, cc.BillToAddress2, cc.BillToCity AS City, cc.BillToStateID AS StateID, COALESCE(cc.BillToCountryID,ma.CountryID) AS CountryID, cc.BillToZip, cc.SecurityCode, cc.Bank, cc.BankPhone
FROM MasterAccounts ma, CreditCards cc
	WHERE ma.CustomerID = cc.CustomerID
	AND ma.CustomerID=CustomerID_
UNION ALL
SELECT NULL, NULL, NULL, ma.FirstName || ' ' || ma.LastName, ma.Address1, ma.Address2, ma.City, ma.StateID, COALESCE(ma.CountryID,g.BillCountryID), ma.Zip, NULL, NULL, NULL 
FROM MasterAccounts ma, Groups g
	WHERE ma.CustomerID=CustomerID_
	AND ma.GroupID = g.GroupID;
END;
/

CREATE OR REPLACE PROCEDURE MBRCloseVoidList (crMBRCloseVoidList1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,CancelDate_ IN DATE) AS
BEGIN

OPEN crMBRCloseVoidList1 FOR SELECT i.InvoiceID
FROM MasterAccounts ma, SubAccounts sa, Invoices i, AccountTypes at1, InvoiceItems ii, PayPeriods pp
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND ma.CustomerID =CustomerID_
	AND ma.CustomerID = i.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND i.VoidDate IS NULL
	AND ii.Canceled = 0
	AND ii.Amount > 0
	AND ii.StartDate <> ii.EndDate
	AND i.InvoiceTypeID IN (1,2,3,4,5)
	AND ii.AccountID = sa.AccountID
	AND ii.AccountTypeID = at1.AccountTypeID
	AND sa.PayPeriodID = pp.PayPeriodID
	AND ((at1.ChangeClose = 1 AND ii.EndDate > CancelDate_) 
		OR (pp.PeriodTypeID = 1 AND at1.ChangeClose = 2 AND DATEADD(mm,-1,ii.EndDate) > CancelDate_) 
		OR (pp.PeriodTypeID = 2 AND at1.ChangeClose = 2 AND ii.EndDate > CancelDate_) 
		OR (pp.PeriodTypeID IN (1,2) AND ii.StartDate > CancelDate_) )
UNION
SELECT i.InvoiceID
FROM MasterAccounts ma, Packages p, Invoices i, PackageTypes pt, InvoiceItems ii, PayPeriods pp
	WHERE ma.CustomerID = p.CustomerID
	AND ma.Active = 1
	AND p.Active = 1
	AND ma.CustomerID =CustomerID_
	AND ma.CustomerID = i.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND i.VoidDate IS NULL
	AND ii.Canceled = 0
	AND ii.Amount > 0
	AND ii.StartDate <> ii.EndDate
	AND i.InvoiceTypeID IN (1,2,3,4,5)
	AND ii.PackageID = p.PackageID
	AND ii.PackageTypeID = pt.PackageTypeID
	AND p.PayPeriodID = pp.PayPeriodID
	AND ((pt.ChangeClose = 1 AND ii.EndDate > CancelDate_) 
		OR (pp.PeriodTypeID = 1 AND pt.ChangeClose = 2 AND DATEADD(mm,-1,ii.EndDate) > CancelDate_) 
		OR (pp.PeriodTypeID = 2 AND pt.ChangeClose = 2 AND ii.EndDate > CancelDate_) 
		OR (pp.PeriodTypeID IN (1,2) AND ii.StartDate > CancelDate_) )

ORDER BY 1 DESC;
END;
/

CREATE OR REPLACE PROCEDURE MBRCurrentBalance (CustomerID_ IN INTEGER) AS
BEGIN
IF (CustomerID_ IS NULL) THEN
UPDATE MasterAccounts SET PendingBalance = MasterAccounts.Balance + COALESCE((SELECT SUM(Amount) FROM Invoices WHERE Processed = 1 AND CustomerID = MasterAccounts.CustomerID AND StatementID IS NULL AND VoidDate IS NULL),0) + 
COALESCE((SELECT -(SUM(Amount)) FROM Invoices WHERE Processed = 1 AND CustomerID = MasterAccounts.CustomerID AND StatementID IS NOT NULL AND VoidDate IS NOT NULL AND VoidStatementID IS NULL),0) +
COALESCE((SELECT SUM(ROUND(Amount * Quantity,2)) FROM Charges WHERE CustomerID = MasterAccounts.CustomerID AND ItemID IS NULL),0) +
COALESCE((SELECT -(SUM(COALESCE(FinalAmount,Amount))) FROM Payments WHERE CustomerID = MasterAccounts.CustomerID AND StatementID IS NULL),0) +
COALESCE((SELECT -(SUM(FinalAmount-Amount)) FROM Payments WHERE CustomerID = MasterAccounts.CustomerID AND StatementID IS NOT NULL AND FinalStatementID IS NULL AND FinalAmount IS NOT NULL),0)
	WHERE Active = 1;
END IF;

IF (CustomerID_ IS NOT NULL) THEN
UPDATE MasterAccounts SET PendingBalance = MasterAccounts.Balance + COALESCE((SELECT SUM(Amount) FROM Invoices WHERE Processed = 1 AND CustomerID = MasterAccounts.CustomerID AND StatementID IS NULL AND VoidDate IS NULL),0) + 
COALESCE((SELECT -(SUM(Amount)) FROM Invoices WHERE Processed = 1 AND CustomerID = MasterAccounts.CustomerID AND StatementID IS NOT NULL AND VoidDate IS NOT NULL AND VoidStatementID IS NULL),0) +
COALESCE((SELECT SUM(ROUND(Amount * Quantity,2)) FROM Charges WHERE CustomerID = MasterAccounts.CustomerID AND ItemID IS NULL),0) +
COALESCE((SELECT -(SUM(COALESCE(FinalAmount,Amount))) FROM Payments WHERE CustomerID = MasterAccounts.CustomerID AND StatementID IS NULL),0) +
COALESCE((SELECT -(SUM(FinalAmount-Amount)) FROM Payments WHERE CustomerID = MasterAccounts.CustomerID AND StatementID IS NOT NULL AND FinalStatementID IS NULL AND FinalAmount IS NOT NULL),0)
	WHERE CustomerID =CustomerID_
	AND Active IN (1,0);
END IF;
END;
/

CREATE OR REPLACE PROCEDURE MBRCustom (crMBRCustom1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
OPEN crMBRCustom1 FOR SELECT adt.AccountDataType, COALESCE(adv.ValueData,mad.Data) AS Data
FROM MasterAccountData mad JOIN AccountDataTypes adt ON (mad.AccountDataTypeID=adt.AccountDataTypeID)
	LEFT JOIN AccountDataValues adv ON (mad.AccountDataTypeID=adv.AccountDataTypeID AND mad.Data=adv.KeyData)
	WHERE mad.Data IS NOT NULL
	AND mad.CustomerID=CustomerID_
	AND adt.AllowMBR = 1;
END;
/

CREATE OR REPLACE PROCEDURE MBRDefaultEmail (crMBRDefaultEmail1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
DECLARE
Email_ VARCHAR2(64);
BEGIN

SELECT MAX(Email) INTO Email_  FROM SubAccounts WHERE CustomerID=CustomerID_ AND Active=1 AND Email IS NOT NULL AND SendBill=1 AND Email LIKE '%@%';
IF (Email_ IS NULL) THEN
SELECT MAX(Email) INTO Email_  FROM MasterAccounts WHERE CustomerID=CustomerID_;
END IF;

IF (Email_ IS NULL) THEN
SELECT sa.Login || '@' || d.MailDomain INTO Email_ 

FROM SubAccounts sa, Domains d 
	WHERE sa.CustomerID =CustomerID_
	AND sa.DomainID = d.DomainID
	AND sa.Active = 1
	AND sa.SendBill = 1
	AND sa.Email IS NULL
	AND sa.Login IS NOT NULL;
END IF;

OPEN crMBRDefaultEmail1 FOR SELECT Email_ AS Email, sm.EmailTypeID, g.EmailSubject
FROM MasterAccounts ma, SendMethods sm, Groups g
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.CustomerID =CustomerID_
	AND ma.GroupID = g.GroupID;
END;
END;
/

CREATE OR REPLACE PROCEDURE MBRDetail (crMBRDetail1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
OPEN crMBRDetail1 FOR SELECT ma.CustomerID, FirstName, LastName, Company, Address1, Address2, City, COALESCE(s.Abbreviation,s.State) AS State, Zip, sp.SalesPerson,
LastReceived, PayInfo, PhoneHome, PhoneFax, PhoneWork, rb.ReferredBy, Operator,
ma.StartDate, CancelDate AS EndDate,cr.CancelReason, cr.StringID AS CancelReasonStringID, pt.PaymentType, Region, GroupName, 
ma.Active, ma.PayPeriodID, pp.PayPeriod,
CASE WHEN ma.Active = 0 THEN 0 WHEN ma.CancelDate IS NOT NULL THEN 2 ELSE 1 END AS MBRStatus, ma.Status,
Comments, bc.Description, ma.TaxExemptions, 
CreateDate, ma.Email,
ma.PendingBalance AS CurrentBalance, 
ma.PendingBalance + COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS RealtimeBalance,
COALESCE(OverDue, 0) AS OverDue, COALESCE(LastStatementID,0) As LastStatementID, LastModifyUser, LastModifyDate, st.EndBal,ma.OverLimit

FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN PaymentTypes pt ON (ma.PaymentTypeID = pt.PaymentTypeID)
	JOIN PayPeriods pp ON (ma.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN Regions r ON (ma.RegionID = r.RegionID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	LEFT JOIN ReferredBys rb ON (ma.ReferredByID = rb.ReferredByID)
	LEFT JOIN SalesPersons sp ON (ma.SalesPersonID = sp.SalesPersonID)
	LEFT JOIN CancelReasons cr ON (ma.CancelReasonID = cr.CancelReasonID)
	LEFT JOIN Statements st ON (ma.LastStatementID = st.StatementID)
WHERE ma.CustomerID =CustomerID_;
END;
/

CREATE OR REPLACE PROCEDURE MBRGetCustomFields (crMBRGetCustomFields1 IN OUT ieatypes.CursorType,GroupID_ IN INTEGER) AS
BEGIN
OPEN crMBRGetCustomFields1 FOR SELECT COALESCE(madt.Required,0) AS Required, adt.RegExp, adt.StringID, adt.AccountDataType,adt.AccountDataTypeID,adt.DataTypeID
FROM MasterAccountDataTypes madt, AccountDataTypes adt
	WHERE adt.AccountDataTypeID=madt.AccountDataTypeID
	AND adt.AllowMBR=1
	AND (madt.GroupID IS NULL OR madt.GroupID =GroupID_ OR madt.ServiceGroupID IN (SELECT ServiceGroupID FROM ServiceGroupItems WHERE GroupID =GroupID_))
ORDER BY madt.SortOrder, adt.AccountDataType;
END;
/

CREATE OR REPLACE PROCEDURE MBRGroupID (crMBRGroupID1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
OPEN crMBRGroupID1 FOR SELECT ma.Active, CASE WHEN ma.CancelDate IS NULL AND ma.Active = 1 THEN 1 ELSE 0 END AS IsOpen, 
ma.PaymentTypeID, ma.CustomerID, ma.GroupID, g.OrganizationID, ma.FirstName, ma.LastName, ma.Company, ma.PendingBalance AS Balance
FROM MasterAccounts ma, Groups g
	WHERE ma.CustomerID =CustomerID_
	AND ma.GroupID = g.GroupID
	AND ma.Active IN (1,0);
END;
/

CREATE OR REPLACE PROCEDURE MBROpenChkMax (crMBROpenChkMax1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
DECLARE
MaxAccounts_ INTEGER;
GroupID_ INTEGER;
BEGIN

SELECT o.MaxAccounts,ma.GroupID INTO MaxAccounts_,GroupID_ 

FROM MasterAccounts ma, Groups g, Organizations o
	WHERE ma.GroupID = g.GroupID
	AND g.OrganizationID = o.OrganizationID
	AND ma.CustomerID =CustomerID_;
IF (MaxAccounts_ IS NOT NULL) THEN
OPEN crMBROpenChkMax1 FOR SELECT MaxAccounts_ - COUNT(*) AS CountLeft 
FROM MasterAccounts 
	WHERE Active=1 
	AND GroupID=GroupID_;
ELSE
OPEN crMBROpenChkMax1 FOR SELECT NULL AS CountLeft
 FROM DUAL;
END IF;

END;
END;
/

CREATE OR REPLACE PROCEDURE MBROpenList (crMBROpenList1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
OPEN crMBROpenList1 FOR SELECT NULL AS PackageID, sa.AccountID, ma.GroupID, CASE WHEN at1.ChargeTypeID IS NULL THEN 0 ELSE 1 END AS AllowSetupCharge, CASE WHEN pp.SetupCharge = 1 THEN 1 ELSE 0 END AS DefaultSetupCharge
FROM MasterAccounts ma, SubAccounts sa, PayPeriods pp, AccountTypes at1
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.PayPeriodID = pp.PayPeriodID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND ma.CustomerID =CustomerID_
	AND sa.Active = 1
	AND PackageID IS NULL
UNION ALL
SELECT p.PackageID, NULL AS AccountID, ma.GroupID, CASE WHEN pt.ChargeTypeID IS NULL THEN 0 ELSE 1 END AS AllowSetupCharge, CASE WHEN pp.SetupCharge = 1 THEN 1 ELSE 0 END AS DefaultSetupCharge
FROM MasterAccounts ma, Packages p, PayPeriods pp, PackageTypes pt
	WHERE ma.CustomerID = p.CustomerID
	AND ma.CustomerID =CustomerID_
	AND p.PackageTypeID = pt.PackageTypeID
	AND p.PayPeriodID = pp.PayPeriodID
	AND p.Active = 1;
END;
/

CREATE OR REPLACE PROCEDURE MenuList (crMenuList1 IN OUT ieatypes.CursorType,menu_ IN VARCHAR2,ogid_ IN INTEGER,gid_ IN INTEGER) AS
BEGIN

OPEN crMenuList1 FOR SELECT mt.MetaTableID, mc.MetaColumnID, mi.FileName, mi."Access", mi.Condition, mi.FeatureID, mi.Label, mi.Description, mi.DescStringID, mi.HelpStringID, mi.AccessKey, mi.Link, mi.Attribute, m.Class
FROM Menus m JOIN MenuSets ms ON (m.MenuID = ms.MenuID)
	JOIN MenuItems mi ON (ms.MenuItemID = mi.MenuItemID)
	LEFT JOIN MetaTables mt ON (mi.TableName = mt.TableName)
	LEFT JOIN MetaColumns mc ON (mt.MetaTableID = mc.MetaTableID AND mi.ColumnName = mc.ColumnName)
	WHERE m.Menu =menu_
	AND (ms.GroupID IS NULL OR ms.GroupID =gid_)
ORDER BY ms.SortOrder ASC;
END;
/

CREATE OR REPLACE PROCEDURE MenuListAT (crMenuListAT1 IN OUT ieatypes.CursorType,menu_ IN VARCHAR2,AccountTypeID_ IN INTEGER,gid_ IN INTEGER) AS
BEGIN
OPEN crMenuListAT1 FOR SELECT ms.SortOrder, mt.MetaTableID, mc.MetaColumnID, mi.FileName, mi."Access", mi.Condition, mi.FeatureID, mi.Label, mi.Description, mi.DescStringID, mi.HelpStringID, mi.AccessKey, mi.Link, mi.Attribute, m.Class
FROM Menus m JOIN MenuSets ms ON (m.MenuID = ms.MenuID)
	JOIN MenuItems mi ON (ms.MenuItemID = mi.MenuItemID)
	LEFT JOIN MetaTables mt ON (mi.TableName = mt.TableName)
	LEFT JOIN MetaColumns mc ON (mt.MetaTableID = mc.MetaTableID AND mi.ColumnName = mc.ColumnName)
	WHERE m.Menu =menu_
	AND (ms.GroupID IS NULL OR ms.GroupID =gid_)
UNION ALL
SELECT 0, NULL, NULL, act.CustEdit, 'read', NULL, NULL, 'svctemplate', act.CustEditLabel, act.CustEditStringID, NULL, NULL, act.CustEdit, NULL, m.Class
FROM AccountTypes at1, AccountTemplates act, Menus m
	WHERE at1.AccountTemplateID = act.AccountTemplateID
	AND at1.AccountTypeID =AccountTypeID_
	AND act.CustEdit IS NOT NULL
	AND m.Menu =menu_
	AND menu_ = 'custsaset'
UNION ALL
SELECT 0, NULL, NULL, act.SADetail, 'read', NULL, NULL, 'svctemplate', act.AccountTemplate, NULL, NULL, NULL, act.SADetail, NULL, m.Class
FROM AccountTypes at1, AccountTemplates act, Menus m
	WHERE at1.AccountTemplateID = act.AccountTemplateID
	AND at1.AccountTypeID =AccountTypeID_
	AND act.SADetail IS NOT NULL
	AND m.Menu =menu_
	AND menu_ = 'sadetail'
ORDER BY 1 ASC;
END;
/

CREATE OR REPLACE PROCEDURE MetaFormCheck (crMetaFormCheck1 IN OUT ieatypes.CursorType,TableName_ IN VARCHAR2) AS
BEGIN

OPEN crMetaFormCheck1 FOR SELECT mt.MetaTableID, mc.MetaColumnID, mc.ColumnName, mc.Description, CASE WHEN mc.IsKey = 0 AND mc.Quoted = 0 AND mc.Nullable = 0 THEN 1 ELSE mc.Required END AS Required, mc.MinSize, mc.MaxSize, mc.MetaRuleID, mc.Quoted, mc.StringID, mc.RegExp
FROM MetaTables mt, MetaColumns mc
	WHERE mt.MetaTableID = mc.MetaTableID
	AND mt.TableName =TableName_;
END;
/

CREATE OR REPLACE PROCEDURE MetaGetGroupID (crMetaGetGroupID1 IN OUT ieatypes.CursorType,metatableid_ IN INTEGER,data_ IN INTEGER) AS
BEGIN
OPEN crMetaGetGroupID1 FOR SELECT 'N/A'
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE MetaGetTable (crMetaGetTable1 IN OUT ieatypes.CursorType,metatableid_ IN INTEGER) AS
BEGIN
OPEN crMetaGetTable1 FOR SELECT MetaColumnID,ColumnName,Quoted,DepTable,DepColumn,MetaRuleID,Required,Nullable,MinSize,MaxSize,IsKey,Description,RegExp,CheckQuery
FROM MetaColumns
	WHERE MetaTableID =metatableid_;
END;
/

CREATE OR REPLACE PROCEDURE MetaGetTableInfo (crMetaGetTableInfo1 IN OUT ieatypes.CursorType,table_ IN VARCHAR2) AS
BEGIN
OPEN crMetaGetTableInfo1 FOR SELECT mt.MetaTableID, mt.GroupTable, mc2.ColumnName AS GroupColumn
FROM MetaTables mt LEFT JOIN MetaTables mt2 ON (mt.GroupTable = mt2.TableName)
	LEFT JOIN MetaColumns mc2 ON (mt2.MetaTableID = mc2.MetaTableID AND mc2.IsKey = 1)
	WHERE mt.TableName =table_;
END;
/

CREATE OR REPLACE PROCEDURE NoticeMailList (crNoticeMailList1 IN OUT ieatypes.CursorType,OperatorID_ IN INTEGER,CustomerID_ IN INTEGER,AccountID_ IN INTEGER,CheckSendBill_ IN INTEGER) AS
BEGIN

OPEN crNoticeMailList1 FOR SELECT o.LanguageID, o.PrintTypeID AS EmailTypeID, COALESCE(g.EmailAccounts,g2.EmailAccounts) AS EmailAccounts, COALESCE(g.EmailSubject,g2.EmailSubject) AS EmailSubject, o.Operator AS FirstName, NULL AS LastName, NULL AS Login, o.Email, NULL AS MailDomain
FROM Operators o LEFT JOIN MasterAccounts ma ON (ma.CustomerID =CustomerID_)
	LEFT JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Groups g2 ON (g2.GroupID = 1)
	WHERE o.Active = 1
	AND o.Email IS NOT NULL
	AND o.OperatorID =OperatorID_

UNION ALL

SELECT ma.LanguageID, COALESCE(sm.EmailTypeID,1) AS EmailTypeID, g.EmailAccounts, g.EmailSubject, sa.FirstName, sa.LastName, sa.Login, sa.Email, d.MailDomain 
FROM SendMethods sm, SubAccounts sa, Domains d, Groups g, MasterAccounts ma
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.CustomerID = sa.CustomerID
	AND ma.GroupID = g.GroupID
	AND sa.DomainID = d.DomainID
	AND sa.Active = 1
	AND sa.AccountID =AccountID_

UNION ALL

SELECT ma.LanguageID, COALESCE(sm.EmailTypeID,1) AS EmailTypeID, g.EmailAccounts, g.EmailSubject, sa.FirstName, sa.LastName, sa.Login, sa.Email, d.MailDomain 
FROM SendMethods sm, SubAccounts sa, Domains d, Groups g, MasterAccounts ma
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.CustomerID = sa.CustomerID
	AND ma.GroupID = g.GroupID
	AND sa.DomainID = d.DomainID
	AND ma.CustomerID =CustomerID_
	AND sa.Active = 1
	AND (CheckSendBill_ = 0 OR sa.SendBill = 1)

UNION ALL

SELECT ma.LanguageID, COALESCE(sm.EmailTypeID,1) AS EmailTypeID, g.EmailAccounts, g.EmailSubject, ma.FirstName, ma.LastName, NULL AS Login, ma.Email, NULL AS MailDomain
FROM MasterAccounts ma, SendMethods sm, Groups g
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.GroupID = g.GroupID
	AND ma.CustomerID =CustomerID_
	AND ma.Email IS NOT NULL
	AND ma.Email LIKE '%@%';
END;
/

CREATE OR REPLACE PROCEDURE NoticeOrgList (crNoticeOrgList1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crNoticeOrgList1 FOR SELECT NULL AS Value, 'All' AS Description 
FROM DUAL
UNION ALL
SELECT OrganizationID AS Value,Organization AS Description 
FROM Organizations ;
END;
/

CREATE OR REPLACE PROCEDURE NoticeGroupList (crNoticeGroupList1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crNoticeGroupList1 FOR SELECT NULL AS Value, 'All' AS Description 
FROM DUAL
UNION ALL
SELECT GroupID AS Value,GroupName AS Description 
FROM Groups 
	WHERE GroupID <> 1 
	AND Active=1 
	AND SortOrder >= 0;
END;
/

CREATE OR REPLACE PROCEDURE NoticeIncidentTypeList (crNoticeIncidentTypeList1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crNoticeIncidentTypeList1 FOR SELECT NULL AS Value, 'All' AS Description, -1 AS SortOrder
FROM DUAL
UNION ALL
SELECT IncidentTypeID AS Value, IncidentType AS Description, SortOrder
FROM IncidentTypes 
	WHERE SortOrder >= 0
ORDER BY 3,2;
END;
/

CREATE OR REPLACE PROCEDURE NoticeAccountTypeList (crNoticeAccountTypeList1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crNoticeAccountTypeList1 FOR SELECT NULL AS Value, 'All' AS Description, -1 AS SortOrder
FROM DUAL
UNION ALL
SELECT AccountTypeID AS Value,AccountType AS Description, SortOrder
FROM AccountTypes 
	WHERE SortOrder >= 0
ORDER BY 3, 2;
END;
/

CREATE OR REPLACE PROCEDURE PackageList (crPackageList1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN

OPEN crPackageList1 FOR SELECT PackageID, pt.PackageType, CASE WHEN p.Active=1 AND p.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0) + p.Extension+1,p.ExpireDate) < sysdate 
	THEN 'expired' WHEN p.Active=1 THEN 'active' ELSE 'inactive' END AS bginfo,
CASE DiffCost WHEN 1 then p.Cost ELSE pt.Cost END as Cost, 
CASE WHEN bc.AutoBill = 2 THEN NULL ELSE PayPeriod END AS PayPeriod, BilledThru, ExpireDate, COALESCE(ma.OverDue,0) + p.Extension AS ExpirePlus
FROM MasterAccounts ma, Packages p, PackageTypes pt, PayPeriods pp, BillingCycles bc
WHERE ma.CustomerID=CustomerID_
	AND ma.CustomerID=p.CustomerID
	AND ma.BillingCycleID=bc.BillingCycleID
	and p.PackageTypeID=pt.PackageTypeID
	and p.PayPeriodID=pp.PayPeriodID
	AND p.Active IN (1,0)
Order By pt.SortOrder, pt.PackageType;
END;
/

CREATE OR REPLACE PROCEDURE PayBatchProcGet (crPayBatchProcGet1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,AccountNumber_ IN VARCHAR2,PaymentTypeID_ IN INTEGER) AS
BEGIN
DECLARE
BatchProcessorID_ INTEGER;
AllowAuthOnly_ INTEGER;
Realtime_ INTEGER;
BEGIN

IF (PaymentTypeID_ = 8) THEN
SELECT MAX(bp.BatchProcessorID),MAX(CASE WHEN BITAND(e.Features,2) = 2 THEN 1 ELSE 0 END),CASE WHEN MAX(e.ExportType) IN (5,6,7) THEN 1 ELSE 0 END INTO BatchProcessorID_,AllowAuthOnly_,Realtime_ 

FROM MasterAccounts ma, Groups g, BatchProcessors bp, CardTypes ct, CardTypePrefixes ctp, Exports e
	WHERE ma.GroupID = g.GroupID
	AND bp.GroupID = g.GroupID
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND e.ExportType IN (1,2,5)
	AND ctp.Prefix = SUBSTRING(AccountNumber_,1,DATALENGTH(ctp.Prefix))
	AND ct.CardTypeID = ctp.CardTypeID
	AND DATALENGTH(AccountNumber_) IN (ct.Length1,ct.Length2)
	AND BITAND(bp.CardTypes,ct.CardTypeID) = ct.CardTypeID
	AND ma.Active = 1
	AND ma.CustomerID =CustomerID_;
IF (BatchProcessorID_ IS NULL) THEN
SELECT MAX(bp.BatchProcessorID),MAX(CASE WHEN BITAND(e.Features,2) = 2 THEN 1 ELSE 0 END),CASE WHEN MAX(e.ExportType) IN (5,6,7) THEN 1 ELSE 0 END INTO BatchProcessorID_,AllowAuthOnly_,Realtime_ 

FROM MasterAccounts ma, Groups g, BatchProcessors bp, CardTypes ct, CardTypePrefixes ctp, Exports e
	WHERE ma.GroupID = g.GroupID
	AND (((g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL) AND bp.GroupID IS NULL) OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND e.ExportType IN (1,2,5)
	AND ctp.Prefix = SUBSTRING(AccountNumber_,1,DATALENGTH(ctp.Prefix))
	AND ct.CardTypeID = ctp.CardTypeID
	AND DATALENGTH(AccountNumber_) IN (ct.Length1,ct.Length2)
	AND BITAND(bp.CardTypes,ct.CardTypeID) = ct.CardTypeID
	AND ma.Active = 1
	AND ma.CustomerID =CustomerID_;
END IF;
END IF;

IF (BatchProcessorID_ IS NULL) THEN
SELECT MAX(bp.BatchProcessorID),MAX(CASE WHEN BITAND(e.Features,2) = 2 THEN 1 ELSE 0 END),CASE WHEN MAX(e.ExportType) IN (5,6,7) THEN 1 ELSE 0 END INTO BatchProcessorID_,AllowAuthOnly_,Realtime_ 

FROM MasterAccounts ma, Groups g, BatchProcessors bp, Exports e
	WHERE ma.GroupID = g.GroupID
	AND (((g.OrganizationID = bp.OrganizationID OR bp.OrganizationID IS NULL) AND bp.GroupID IS NULL) OR bp.GroupID = g.GroupID)
	AND bp.ExportID = e.ExportID
	AND bp.Active = 1
	AND ((PaymentTypeID_ = 8 AND e.ExportType IN (1,2,5) AND BITAND(bp.CardTypes,256) = 256) OR (PaymentTypeID_ = 16 AND e.ExportType IN (4,6)))
	AND ma.Active = 1
	AND ma.CustomerID =CustomerID_;
END IF;

OPEN crPayBatchProcGet1 FOR SELECT BatchProcessorID_ AS BatchProcessorID,AllowAuthOnly_ AS AllowAuthOnly,Realtime_ AS Realtime
 FROM DUAL;
END;
END;
/

CREATE OR REPLACE PROCEDURE PayCheckAdd (crPayCheckAdd1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,PaymentTypeID_ IN INTEGER,BatchID_ IN INTEGER,Amount_ IN NUMERIC,CheckNumber_ IN VARCHAR2,PayInfo_ IN VARCHAR2,LastModifyUser_ IN VARCHAR2) AS
BEGIN
UPDATE MasterAccounts SET OverDue = 0 WHERE CustomerID =CustomerID_ AND OverDue > 0;
INSERT INTO Payments (CustomerID,PaymentTypeID,BatchID,Amount,CheckNumber,PayInfo,LastModifyUser,DistFlag,LastModifyDate,CreateDate) 
VALUES(CustomerID_,PaymentTypeID_ ,BatchID_ ,Amount_ ,CheckNumber_ ,PayInfo_ ,LastModifyUser_ ,1,sysdate,sysdate);
OPEN crPayCheckAdd1 FOR SELECT LAST.IDENT AS PaymentID
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE PayGetTrans (crPayGetTrans1 IN OUT ieatypes.CursorType,ExternalTransID_ IN INTEGER) AS
BEGIN
OPEN crPayGetTrans1 FOR SELECT et.CustomerID, et.InvoiceID, et.TransStateID, et.TransTypeID, et.Amount AS TransAmount, et.PaymentID, et.ProcTransID, p.Amount AS PayAmount, p.FinalAmount AS FinalAmount, p.StatementID, p.FinalStatementID
FROM ExternalTrans et LEFT JOIN Payments p ON (et.PaymentID = p.PaymentID)
	WHERE et.ExternalTransID =ExternalTransID_;
END;
/

CREATE OR REPLACE PROCEDURE PayAutoCheck (crPayAutoCheck1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN

OPEN crPayAutoCheck1 FOR SELECT CASE WHEN PendingBalance < 0 THEN -(PendingBalance) ELSE 0 END AS Amount
FROM MasterAccounts ma, BillingCycles bc
	WHERE ma.BillingCycleID = bc.BillingCycleID
	AND ma.CustomerID =CustomerID_
	AND ma.PaymentTypeID IN (8,16)
	AND bc.AutoBill IN (0,1);
END;
/

CREATE OR REPLACE PROCEDURE PaymentChange (crPaymentChange1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,PaymentID_ IN INTEGER,NewAmount_ IN NUMERIC,PayInfo_ IN VARCHAR2,Operator_ IN VARCHAR2) AS
BEGIN
DECLARE
status_ INTEGER;
BEGIN
UPDATE Payments SET DistFlag=1, FinalAmount=ROUND(NewAmount_,2), FinalCreateDate=sysdate, LastModifyDate=sysdate, PayInfo=PayInfo_, LastModifyUser=Operator_
	WHERE PaymentID =PaymentID_ 
	AND CustomerID =CustomerID_
	AND FinalAmount IS NULL
	AND PaymentTypeID IN (2,4,8,16,64,128,256,512,1024,2048,4096,8192,16384,32768)
	AND NewAmount_ IS NOT NULL
	AND Amount <> ROUND(NewAmount_,2);
status_ := SQL%ROWCOUNT;
OPEN crPaymentChange1 FOR SELECT status_ AS Status
 FROM DUAL;
END;
END;
/

CREATE OR REPLACE PROCEDURE PaymentCredit (crPaymentCredit1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,PaymentID_ IN INTEGER,Amount_ IN NUMERIC,Operator_ IN VARCHAR2) AS
BEGIN
DECLARE
Realtime_ INTEGER;
Status_ INTEGER;
BEGIN

SELECT MAX(ext.IsRealtime) INTO Realtime_ 

FROM ExternalTrans et, BatchProcessors bp, Exports e, ExportTypes ext
	WHERE et.PaymentID=PaymentID_
	AND et.CustomerID=CustomerID_
	AND et.Amount >=Amount_
	AND et.ProcTransID IS NOT NULL
	AND et.TransStateID = 4
	AND et.BatchProcessorID = bp.BatchProcessorID
	AND bp.ExportID = e.ExportID
	AND e.ExportType = ext.ExportTypeID
	AND et.TransTypeID IN (32,64);
INSERT INTO ExternalTrans (CustomerID,InvoiceID,BatchProcessorID,TransStateID,TransTypeID,ReqDate,Amount,PaymentID,LastModifyDate,LastModifyUser,AccountNumber,AccountExpire,AuthName,AuthAddress,AuthStateID,AuthZip,AuthSecurityCode,ProcTransID,BankName,BankNumber,BankPhone,BankTransType,SSN,DLNumber,DLState,BirthDate,AutoBill,LastRebatchTry,ApproveCode)
SELECT et.CustomerID,et.InvoiceID,et.BatchProcessorID,0 AS TransStateID,256 AS TransTypeID,sysdate AS ReqDate,Amount_ AS Amount,et.PaymentID,sysdate AS LastModifyDate,Operator_ AS LastModifyUser,et.AccountNumber,et.AccountExpire,et.AuthName,et.AuthAddress,et.AuthStateID,et.AuthZip,et.AuthSecurityCode,et.ProcTransID,et.BankName,et.BankNumber,et.BankPhone,et.BankTransType,et.SSN,et.DLNumber,et.DLState,et.BirthDate,0,sysdate AS LastRebatchTry,et.ApproveCode
FROM ExternalTrans et, Payments p
	WHERE et.PaymentID = p.PaymentID
	AND et.PaymentID=PaymentID_
	AND et.CustomerID=CustomerID_
	AND et.Amount >=Amount_
	AND p.FinalAmount IS NULL
	AND et.ProcTransID IS NOT NULL
	AND et.TransStateID = 4
	AND et.TransTypeID IN (32,64)
	AND NOT EXISTS (SELECT * FROM ExternalTrans et2 WHERE et2.TransStateID IN (0,1,2,7) AND et2.ExternalTransID <> et.ExternalTransID AND et2.PaymentID=PaymentID_);
Status_ := SQL%ROWCOUNT;
OPEN crPaymentCredit1 FOR SELECT Status_ AS Status,Realtime_ AS Realtime
 FROM DUAL;
END;
END;
/

CREATE OR REPLACE PROCEDURE PayPrepaidAdd (crPayPrepaidAdd1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,BatchID_ IN INTEGER,Amount_ IN NUMERIC,CardAccountID_ IN INTEGER,PayInfo_ IN VARCHAR2,LastModifyUser_ IN VARCHAR2) AS
BEGIN
UPDATE MasterAccounts SET OverDue = 0 WHERE CustomerID =CustomerID_ AND OverDue > 0;
INSERT INTO Payments (CustomerID,PaymentTypeID,BatchID,Amount,ProcTransID,PayInfo,LastModifyUser,DistFlag,LastModifyDate,CreateDate) 
VALUES(CustomerID_,32,BatchID_ ,Amount_ ,CAST(CardAccountID_ AS VARCHAR(40)),PayInfo_ ,LastModifyUser_ ,1,sysdate,sysdate);
OPEN crPayPrepaidAdd1 FOR SELECT LAST.IDENT AS PaymentID
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE PayPrepaidGet (crPayPrepaidGet1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,Login_ IN VARCHAR2,Password_ IN VARCHAR2) AS
BEGIN
OPEN crPayPrepaidGet1 FOR SELECT ca.CardAccountID, CASE WHEN ca.Active = 1 AND cb.Active = 1 THEN 1 ELSE 0 END AS Active, 
CASE WHEN ca.InactiveExpireDate < sysdate THEN 1 ELSE 0 END AS Expired,
CASE WHEN ca.UsedForDirect = 1 OR (ca.AllowCredit = 0 AND ca.CreditAmount <= 0) THEN 1 ELSE 0 END AS Consumed,
CASE WHEN (SELECT o.OrganizationID FROM Organizations o, Groups g, MasterAccounts ma WHERE o.OrganizationID = g.OrganizationID AND ma.GroupID = g.GroupID AND ma.CustomerID =CustomerID_) = ca.OrganizationID THEN 1 ELSE 0 END AS OrgMatch,
CASE WHEN ca.AllowCredit = 1 AND ca.CreditAmount IS NOT NULL THEN 1 ELSE 0 END AS AllowCredit, CreditAmount
FROM CardAccounts ca, CardBatches cb
	WHERE ca.CardBatchID = cb.CardBatchID
	AND ca.Login =Login_
	AND ca.Password =Password_;
END;
/

CREATE OR REPLACE PROCEDURE PayTransAdd (crPayTransAdd1 IN OUT ieatypes.CursorType,ExternalTransID_ IN INTEGER,BatchID_ IN INTEGER,LastModifyUser_ IN VARCHAR2) AS
BEGIN
UPDATE MasterAccounts SET OverDue = 0 WHERE OverDue > 0 AND CustomerID IN (SELECT CustomerID FROM ExternalTrans WHERE ExternalTransID =ExternalTransID_);
INSERT INTO Payments (CustomerID,Amount,CreateDate,BatchID,PaymentTypeID,PayInfo,ProcTransID,DistFlag,LastModifyDate,LastModifyUser)
SELECT et.CustomerID,et.Amount,sysdate,BatchID_ ,CASE WHEN ext.IsBatch = 1 AND ext.IsCC = 1 THEN 8 WHEN ext.IsBatch = 1 AND ext.IsCC = 0 THEN 16 ELSE 64 END AS PaymentTypeID, CASE WHEN et.AutoBill = 1 AND ext.IsBatch = 1 AND ext.IsCC = 1 THEN 'CC Auto' WHEN et.AutoBill = 1 AND ext.IsBatch = 1 AND ext.IsCC = 0 THEN 'ACH Auto' ELSE NULL END,et.ProcTransID,1,sysdate,LastModifyUser_ 
FROM ExternalTrans et, BatchProcessors bp, Exports e, ExportTypes ext
	WHERE et.BatchProcessorID = bp.BatchProcessorID
	AND bp.ExportID = e.ExportID
	AND e.ExportType = ext.ExportTypeID
	AND et.ExternalTransID =ExternalTransID_
	AND et.TransTypeID IN (32,64);
OPEN crPayTransAdd1 FOR SELECT LAST.IDENT AS PaymentID
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE PayBalSettle (CustomerID_ IN INTEGER) AS
BEGIN
DECLARE
PaidAmount_ NUMERIC(18,4);
InvAmount_ NUMERIC(18,4);
FinalAmount_ NUMERIC(18,4);
InvoiceID_ INTEGER;
ChargeID_ INTEGER;
ItemID_ INTEGER;
StatementID_ INTEGER;
CurBal_ NUMERIC(18,4);
NC_ NUMERIC(18,4);
BEGIN

SELECT SUM(CASE WHEN FinalStatementID IS NOT NULL THEN FinalAmount ELSE Amount END)  INTO PaidAmount_ 

FROM Payments 
	WHERE StatementID IS NOT NULL 
	AND CustomerID =CustomerID_;
SELECT SUM(CASE WHEN VoidDate IS NOT NULL AND VoidStatementID IS NOT NULL THEN 0 ELSE Amount END) INTO InvAmount_ 

FROM Invoices
	WHERE CustomerID =CustomerID_ 
	AND StatementID IS NOT NULL;
SELECT COALESCE(PaidAmount_,0),COALESCE(InvAmount_,0) INTO PaidAmount_,InvAmount_ 


 FROM DUAL;
SELECT ROUND(Balance - (InvAmount_ - PaidAmount_) ,2),Balance,ROUND(InvAmount_ - PaidAmount_,2) INTO FinalAmount_,CurBal_,NC_ 

FROM MasterAccounts 
	WHERE CustomerID =CustomerID_;
SELECT CASE WHEN COUNT(*) > 0 THEN 0 ELSE FinalAmount_ END INTO FinalAmount_ 

FROM Invoices i, InvoiceItems ii
	WHERE i.InvoiceID=ii.InvoiceID
	AND i.CustomerID=CustomerID_
	AND i.VoidDate IS NULL
GROUP BY i.InvoiceID
HAVING MIN(ROUND(i.Amount,2)) <> SUM(ROUND(ii.Amount * ii.Quantity,2));
IF (FinalAmount_ <> 0) THEN
INSERT INTO Invoices (CustomerID,InvoiceTypeID,Amount,ChargeAmount,PaidAmount,CreateDate,LastModifyDate,LastModifyUser,SentDate,Tax,Comments,Estimate,Processed,PrintDate,EmailDate)
VALUES(CustomerID_,4,FinalAmount_ ,CASE WHEN FinalAmount_ > 0 THEN FinalAmount_ ELSE 0 END, CASE WHEN FinalAmount_ < 0 THEN -(FinalAmount_) ELSE 0 END,DATEADD(yy,-10,sysdate),sysdate,'GBE',DATEADD(yy,-10,sysdate),0,'GBE Balance sync',0,1,DATEADD(yy,-10,sysdate),DATEADD(yy,-10,sysdate));
SELECT LAST.IDENT INTO InvoiceID_ 


 FROM DUAL;
IF (FinalAmount_ < 0) THEN
	INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,DistFlag,Amount,Quantity,LastModifyDate,LastModifyUser)
	VALUES(CustomerID_,'GBE balance sync',DATEADD(yy,-10,sysdate),DATEADD(yy,-10,sysdate),1,FinalAmount_ ,1,sysdate,'GBE');
SELECT LAST.IDENT INTO ChargeID_ 

 FROM DUAL;
END IF;

INSERT INTO InvoiceItems (InvoiceID,ItemType,Days,Description,StartDate,EndDate,Amount,Quantity,ChargeID)
VALUES(InvoiceID_,CASE WHEN FinalAmount_ < 0 THEN 1 ELSE 2 END,0,'GBE balance sync',DATEADD(yy,-10,sysdate),DATEADD(yy,-10,sysdate),FinalAmount_ ,1,ChargeID_ );
SELECT LAST.IDENT INTO ItemID_ 


 FROM DUAL;
IF (ChargeID_ IS NOT NULL) THEN
UPDATE Charges SET ItemID =ItemID_ WHERE ChargeID =ChargeID_;
END IF;

INSERT INTO Statements (CustomerID,StatementDate,SentDate,PrevBal,NewCharges,NewCredits,EndBal,PrintDate,EmailDate)
VALUES(CustomerID_,DATEADD(yy,-10,sysdate),DATEADD(yy,-10,sysdate),NC_ ,CASE WHEN FinalAmount_ < 0 THEN 0 ELSE FinalAmount_ END, CASE WHEN FinalAmount_ > 0 THEN 0 ELSE -(FinalAmount_) END,CurBal_ , DATEADD(yy,-10,sysdate), DATEADD(yy,-10,sysdate));
SELECT LAST.IDENT INTO StatementID_ 

 FROM DUAL;
UPDATE Invoices SET StatementID =StatementID_ WHERE InvoiceID =InvoiceID_;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE PhoneLocation (crPhoneLocation1 IN OUT ieatypes.CursorType,phone_ IN VARCHAR2,OperatorID_ IN INTEGER) AS
BEGIN

OPEN crPhoneLocation1 FOR SELECT c.Country, s.State, lp.City, Lat, "Long", lp.Telco
FROM LocPhones lp, Countries c, States s, Operators o
WHERE c.CountryID = s.CountryID
	AND lp.StateID = s.StateID
	AND c.TelLocPrefixLen IS NOT NULL
	AND lp.Prefix = SUBSTRING(phone_,1,c.TelLocPrefixLen)
	AND o.OperatorID =OperatorID_
	AND (o.CountryID = c.CountryID OR 
			(o.CountryID IN (92,124,316,630,840) AND c.CountryID IN (92,124,316,630,840)));
END;
/

CREATE OR REPLACE PROCEDURE PhoneSearch (crPhoneSearch1 IN OUT ieatypes.CursorType,crPhoneSearch2 IN OUT ieatypes.CursorType,OperatorGroupID_ IN INTEGER,MBRGlobal_ IN INTEGER,phone_ IN VARCHAR2) AS
BEGIN
OPEN crPhoneSearch1 FOR SELECT CustomerID FROM MasterAccounts WHERE PhoneHome =phone_
UNION
SELECT CustomerID FROM MasterAccounts WHERE PhoneWork =phone_
UNION
SELECT CustomerID FROM MasterAccounts WHERE PhoneFax =phone_
UNION
SELECT CustomerID FROM SubAccounts WHERE PhoneHome =phone_
UNION
SELECT CustomerID FROM SubAccounts WHERE PhoneWork =phone_
UNION 
SELECT CustomerID FROM Addresses WHERE Phone =phone_
UNION
SELECT CustomerID FROM Addresses WHERE Fax =phone_;
OPEN crPhoneSearch2 FOR SELECT ma.CustomerID, ma.FirstName, ma.LastName, ma.Company, r.Region, g.GroupName, ma.Address1, ma.Address2, ma.City, c.Country, s.State, ma.Zip, ma.Active
FROM MasterAccounts ma JOIN phostmp t ON (t.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Regions r ON (ma.RegionID = r.RegionID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	LEFT JOIN Countries c ON (ma.CountryID = c.CountryID)
	WHERE (MBRGlobal_ = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=101 AND OperatorGroupID=OperatorGroupID_))
	AND ma.Active IN (0,1)
ORDER BY ma.Active DESC, ma.CustomerID DESC;
DELETE FROM phostmp;
END;
/

CREATE OR REPLACE PROCEDURE PKGSAUpdate (PackageID_ IN INTEGER,OldPackageTypeID_ IN INTEGER) AS
BEGIN
DECLARE
AutoBill_ INTEGER;
ExpireDate_ DATE;
BilledThru_ DATE;
Extension_ INTEGER;
OldAccountTypeID_ INTEGER;
NewAccountTypeID_ INTEGER;
BEGIN

SELECT MAX(PrimaryAccountTypeID)  INTO OldAccountTypeID_ 

FROM PackageTypes 
	WHERE PackageTypeID =OldPackageTypeID_;
SELECT bc.AutoBill,p.ExpireDate,p.BilledThru,p.Extension,pt.PrimaryAccountTypeID INTO AutoBill_,ExpireDate_,BilledThru_,Extension_,NewAccountTypeID_ 

FROM Packages p, MasterAccounts ma, BillingCycles bc, PackageTypes pt
	WHERE p.CustomerID = ma.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND p.PackageTypeID = pt.PackageTypeID
	AND p.PackageID =PackageID_;
IF (AutoBill_ <> 2) THEN
UPDATE SubAccounts SET ExpireDate =ExpireDate_, BilledThru =BilledThru_, Extension = COALESCE(Extension_,0), AccountTypeID = CASE WHEN AccountTypeID =OldAccountTypeID_ THEN COALESCE(NewAccountTypeID_,AccountTypeID) ELSE AccountTypeID END
	WHERE PackageID =PackageID_
	AND Active = 1;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE PKGFindCustomerID (crPKGFindCustomerID1 IN OUT ieatypes.CursorType,PackageID_ IN INTEGER) AS
BEGIN
OPEN crPKGFindCustomerID1 FOR SELECT CASE WHEN pt.ChargeTypeID IS NULL THEN 0 ELSE 1 END AS SetupCharge,
CASE WHEN ma.Active = 1 AND p.Active = 1 THEN 1 ELSE 0 END AS Status,
CASE WHEN p.CancelDate IS NULL AND p.Active = 1 THEN 1 ELSE 0 END AS Active, ma.GroupID,p.CustomerID, p.PackageTypeID, p.DiscountID, pt.PackageType
FROM Packages p, MasterAccounts ma, PackageTypes pt
	WHERE p.PackageID =PackageID_
	AND p.CustomerID = ma.CustomerID
	AND p.PackageTypeID = pt.PackageTypeID
	AND ma.Active IN (1,0)
	AND p.Active IN (1,0);
END;
/

CREATE OR REPLACE PROCEDURE PKGSAList (crPKGSAList1 IN OUT ieatypes.CursorType,PackageID_ IN INTEGER) AS
BEGIN


INSERT INTO psltmp (AccountTypeID,Cnt)
SELECT sa.AccountTypeID, COUNT(*)
FROM SubAccounts sa
	WHERE sa.PackageID=PackageID_
	AND sa.Active = 1
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
GROUP BY sa.AccountTypeID;
OPEN crPKGSAList1 FOR SELECT 0 AS SortOrder, sa.AccountID,sa.Login,sa.FirstName,sa.LastName,at1.AccountType,sa.Email, CASE WHEN sa.Active=1 AND sa.CancelDate IS NOT NULL THEN 'canceled' WHEN sa.Active = 1 THEN 'active' ELSE 'inactive' END AS bginfo, sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > sysdate AND sau.TimeLeft > 0),0) AS TimeLeft, (sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > sysdate AND sau.DataLeft > 0),0)) / 1000000.0 AS DataLeft, 0 AS MinQty, 0 AS MaxQty, 0 AS AddQty, sa.AccountTypeID
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1, PayPeriods pp
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND sa.PayPeriodID = pp.PayPeriodID
	AND sa.PackageID =PackageID_

UNION ALL

SELECT 1 AS SortOrder, NULL AS AccountID, NULL AS Login, NULL AS FirstName, NULL AS LastName, at1.AccountType, NULL AS Email, 
CASE WHEN COALESCE(t.Cnt,0) < MinQty THEN 'toofew' ELSE 'add' END AS bginfo, NULL AS TimeLeft,NULL AS DataLeft, MinQty, MaxQty, MaxQty - COALESCE(t.Cnt,0) AS AddQty, pat.AccountTypeID
FROM PackageAccountTypes pat JOIN AccountTypes at1 ON (pat.AccountTypeID = at1.AccountTypeID)
	JOIN Packages p ON (pat.PackageTypeID = p.PackageTypeID)
	LEFT JOIN psltmp t ON (pat.AccountTypeID = t.AccountTypeID)
	WHERE p.PackageID =PackageID_
	AND (t.Cnt IS NULL OR pat.MaxQty > t.Cnt)

ORDER BY 1, 3, 5;
DELETE FROM psltmp;
END;
/

CREATE OR REPLACE PROCEDURE PrintAddBatch (crPrintAddBatch1 IN OUT ieatypes.CursorType,type_ IN VARCHAR2,GroupID_ IN INTEGER,Operator_ IN VARCHAR2) AS
BEGIN
DECLARE
BatchID_ INTEGER;
ItemCount_ INTEGER;
ItemTotal_ NUMERIC(18,4);
printzero_ NUMERIC(18,4);
batchmax_ INTEGER;
BEGIN

IF (type_ = 'invoice' AND GroupID_ IS NOT NULL) THEN
INSERT INTO Batches (BatchTypeID, BatchStateID, GroupID, Operator, StartDate, LastModifyDate, LastModifyUser, ItemCount,ItemTotal)
VALUES(4,8,GroupID_ ,Operator_ ,sysdate,sysdate,Operator_ ,0,0);
SELECT 0,LAST.IDENT INTO printzero_,BatchID_ 

 FROM DUAL;
SELECT COALESCE((SELECT cgd.NumValue FROM ConfigGroupData cgd WHERE cgd.ConfigID = 507 AND cgd.GroupID =GroupID_),c.NumValue) INTO printzero_  FROM Configs c WHERE c.ConfigID = 507;
SELECT COALESCE(NumValue,0) INTO batchmax_  FROM Configs WHERE ConfigID = 622;
MERGE INTO Invoices mi
USING (SELECT i.InvoiceID, CASE WHEN printzero_ = 0 AND i.Amount <= 0 THEN NULL ELSE BatchID_ END AS PrintBatchID, CASE WHEN printzero_ = 0 AND i.Amount <= 0 THEN sysdate ELSE NULL END AS PrintDate
FROM MasterAccounts ma, SendMethods sm, Invoices i, Groups g
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.Active = 1
	AND ma.CustomerID = i.CustomerID
	AND i.VoidDate IS NULL
	AND i.CreateDate > DATEADD(dd,-45,sysdate)
	AND sm.PrintTypeID IS NOT NULL
	AND ((ma.PaymentTypeID IN (8,16) AND sm.PrintAutoTrans = 1) OR ma.PaymentTypeID NOT IN (8,16))
	AND i.PrintBatchID IS NULL
	AND i.PrintDate IS NULL
	AND ma.GroupID = g.GroupID
	AND ma.GroupID =GroupID_
	AND (batchmax_ = 0 OR ROWNUM <=batchmax_)
	AND (printzero_ = 1 OR (printzero_ = 0 AND i.Amount > 0))) i
ON (mi.InvoiceID = i.InvoiceID)
WHEN MATCHED THEN UPDATE SET mi.PrintBatchID = i.PrintBatchID, mi.PrintDate = i.PrintDate;


SELECT COUNT(*),SUM(Amount) INTO ItemCount_,ItemTotal_ 

FROM Invoices 
	WHERE PrintBatchID =BatchID_;
IF (ItemCount_ = 0) THEN
	DELETE FROM Batches WHERE BatchID =BatchID_;
SELECT NULL INTO BatchID_ 

 FROM DUAL;
ELSE
	UPDATE Batches SET BatchStateID = 1, EndDate = sysdate, ItemCount =ItemCount_, ItemTotal =ItemTotal_ WHERE BatchID =BatchID_;
END IF;
END IF;

IF (type_ = 'statement' AND GroupID_ IS NOT NULL) THEN
INSERT INTO Batches (BatchTypeID, BatchStateID, GroupID, Operator, StartDate, LastModifyDate, LastModifyUser, ItemCount,ItemTotal)
VALUES(5,8,GroupID_ ,Operator_ ,sysdate,sysdate,Operator_ ,0,0);
SELECT 0,LAST.IDENT INTO printzero_,BatchID_ 

 FROM DUAL;
SELECT COALESCE((SELECT MAX(cgd.NumValue) FROM ConfigGroupData cgd WHERE cgd.ConfigID = 38 AND cgd.GroupID =GroupID_),c.NumValue) INTO printzero_  FROM Configs c WHERE c.ConfigID = 38;
SELECT COALESCE(NumValue,0) INTO batchmax_  FROM Configs WHERE ConfigID = 627;
MERGE INTO Statements ms
USING (SELECT s.StatementID, CASE WHEN printzero_ = 0 AND s.EndBal <= 0 THEN NULL ELSE BatchID_ END AS PrintBatchID, CASE WHEN printzero_ = 0 AND s.EndBal <= 0 THEN sysdate ELSE NULL END AS PrintDate
FROM MasterAccounts ma, SendMethods sm, Statements s, Groups g
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.Active = 1
	AND ma.CustomerID = s.CustomerID
	AND ma.LastStatementID = s.StatementID
	AND sm.PrintTypeID IS NOT NULL
	AND ((ma.PaymentTypeID IN (8,16) AND sm.PrintAutoTrans = 1) OR ma.PaymentTypeID NOT IN (8,16))
	AND s.PrintBatchID IS NULL
	AND s.PrintDate IS NULL
	AND ma.GroupID = g.GroupID
	AND ma.GroupID =GroupID_
	AND (batchmax_ = 0 OR ROWNUM <=batchmax_)
	AND (printzero_ = 1 OR (printzero_ = 0 AND s.EndBal > 0))) s
ON (ms.StatementID = s.StatementID)
WHEN MATCHED THEN UPDATE SET ms.PrintBatchID = s.PrintBatchID, ms.PrintDate = s.PrintDate;


SELECT COUNT(*),SUM(EndBal) INTO ItemCount_,ItemTotal_ 

FROM Statements
	WHERE PrintBatchID =BatchID_;
IF (ItemCount_ = 0) THEN
	DELETE FROM Batches WHERE BatchID =BatchID_;
SELECT NULL INTO BatchID_ 

 FROM DUAL;
ELSE
	UPDATE Batches SET BatchStateID = 1, EndDate = sysdate, ItemCount =ItemCount_, ItemTotal =ItemTotal_ WHERE BatchID =BatchID_;
END IF;
END IF;

OPEN crPrintAddBatch1 FOR SELECT BatchID_ AS BatchID
 FROM DUAL;
END;
END;
/

CREATE OR REPLACE PROCEDURE PrintMarkSent (BatchID_ IN INTEGER,Operator_ IN VARCHAR2) AS
BEGIN
DECLARE
BatchTypeID_ INTEGER;
BEGIN
SELECT BatchTypeID INTO BatchTypeID_  FROM Batches WHERE BatchID = BatchID_;
IF (BatchTypeID_ = 4) THEN
UPDATE Batches SET BatchStateID = 3, LastModifyDate = sysdate, LastModifyUser =Operator_ WHERE BatchID =BatchID_;
INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,Amount,Quantity,TaxGroupID,ChargeTypeID,Operator,LastModifyDate,LastModifyUser,AllowInterim)
SELECT i.CustomerID, ct.Description, sysdate, sysdate, ct.Amount, 1, ct.TaxGroupID, ct.ChargeTypeID, 'GBE', sysdate, 'GBE',0
FROM Invoices i, MasterAccounts ma, SendMethods sm, ChargeTypes ct, Batches b
	WHERE i.PrintBatchID =BatchID_
	AND i.PrintDate IS NULL
	AND i.CreateDate > DATEADD(dd,-10,sysdate)
	AND i.CustomerID = ma.CustomerID
	AND ma.SendMethodID = sm.SendMethodID
	AND sm.ChargeTypeID = ct.ChargeTypeID
	AND i.PrintBatchID = b.BatchID
	AND b.Rebatch IS NULL;
UPDATE Invoices SET PrintDate = sysdate
	WHERE PrintBatchID =BatchID_
	AND PrintDate IS NULL;
END IF;

IF (BatchTypeID_ = 5) THEN
UPDATE Batches SET BatchStateID = 3, LastModifyDate = sysdate, LastModifyUser =Operator_ WHERE BatchID =BatchID_;
INSERT INTO Charges (CustomerID,Description,StartDate,EndDate,Amount,Quantity,TaxGroupID,ChargeTypeID,Operator,LastModifyDate,LastModifyUser,AllowInterim)
SELECT s.CustomerID, ct.Description, sysdate, sysdate, ct.Amount, 1, ct.TaxGroupID, ct.ChargeTypeID, 'GBE', sysdate, 'GBE',0
FROM Statements s, MasterAccounts ma, SendMethods sm, ChargeTypes ct, Batches b
	WHERE s.PrintBatchID =BatchID_
	AND s.PrintDate IS NULL
	AND s.CustomerID = ma.CustomerID
	AND ma.SendMethodID = sm.SendMethodID
	AND sm.ChargeTypeID = ct.ChargeTypeID
	AND s.PrintBatchID = b.BatchID
	AND b.Rebatch IS NULL;
UPDATE Statements SET PrintDate = sysdate
	WHERE PrintBatchID =BatchID_
	AND PrintDate IS NULL;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE PrintNoMarkSent (BatchID_ IN INTEGER,Operator_ IN VARCHAR2) AS
BEGIN
DECLARE
BatchTypeID_ INTEGER;
BEGIN
SELECT BatchTypeID INTO BatchTypeID_  FROM Batches WHERE BatchID = BatchID_;
IF (BatchTypeID_ = 4) THEN
UPDATE Batches SET BatchStateID = 1, LastModifyDate = sysdate, LastModifyUser =Operator_, Rebatch = 1 WHERE BatchID =BatchID_;
UPDATE Invoices SET PrintDate = NULL
	WHERE PrintBatchID =BatchID_
	AND PrintDate IS NOT NULL;
END IF;

IF (BatchTypeID_ = 5) THEN
UPDATE Batches SET BatchStateID = 1, LastModifyDate = sysdate, LastModifyUser =Operator_, Rebatch = 1 WHERE BatchID =BatchID_;
UPDATE Statements SET PrintDate = NULL
	WHERE PrintBatchID =BatchID_
	AND PrintDate IS NOT NULL;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE RadAtCache (crRadAtCache1 IN OUT ieatypes.CursorType,accounttype_ IN VARCHAR2) AS
BEGIN
OPEN crRadAtCache1 FOR SELECT at1.AccountType, ra.RadAttributeID, Name, Data, Value, ra.RadAttributeType, rc.RadVendorID, rc.RadCheck, rc.Tag, at1.AccountTypeID, at1.RateClassID
FROM RadATConfigs rc, RadAttributes ra, AccountTypes at1
	WHERE ra.RadAttributeID = rc.RadAttributeID
	AND rc.AccountTypeID = at1.AccountTypeID
	AND (ra.RadVendorID = rc.RadVendorID OR rc.RadVendorID IS NULL)
	AND (accounttype_ IS NULL OR at1.AccountType =accounttype_)
ORDER BY AccountType, rc.RadATConfigID;
END;
/

CREATE OR REPLACE PROCEDURE RadConcurrencySync AS
BEGIN
INSERT INTO rcssync (RadConcurrencyID,Connections)
SELECT RadConcurrencyID, COUNT(*) AS Connections 
FROM ServerPorts sp, MasterAccounts ma, SubAccounts sa, RadConcurrency rc
	WHERE sp.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND rc.GroupID = ma.GroupID
	AND (rc.AccountTypeID IS NULL OR sa.AccountTypeID = rc.AccountTypeID)
	AND sp.AcctStatusType IN (1,3)
GROUP BY rc.RadConcurrencyID;
UPDATE RadConcurrency SET Connections = 0;
MERGE INTO RadConcurrency mrc
USING (SELECT RadConcurrencyID, Connections FROM rcssync) rc
ON (mrc.RadConcurrencyID = rc.RadConcurrencyID)
WHEN MATCHED THEN UPDATE SET mrc.Connections = rc.Connections;


DELETE FROM rcssync;
END;
/

CREATE OR REPLACE PROCEDURE RadCheckOnline (crRadCheckOnline1 IN OUT ieatypes.CursorType,Username_ IN VARCHAR2,accountid_ IN INTEGER) AS
BEGIN
DECLARE
GroupID_ INTEGER;
LoginLimit_ INTEGER;
Connections_ INTEGER;
ConnectionsMax_ INTEGER;
LastSyncDate_ DATE;
AccountTypeID_ INTEGER;
RadConcurrencyID_ INTEGER;
BEGIN


SELECT sa.AccountTypeID,sa.LoginLimit,ma.GroupID INTO AccountTypeID_,LoginLimit_,GroupID_  FROM MasterAccounts ma, SubAccounts sa WHERE ma.CustomerID = sa.CustomerID AND sa.AccountID = accountid_;
SELECT MAX(RadConcurrencyID),MAX(LastSyncDate),MAX(Connections),MAX(ConnectionsMax) INTO RadConcurrencyID_,LastSyncDate_,Connections_,ConnectionsMax_ 

FROM RadConcurrency
	WHERE GroupID =GroupID_
	AND (AccountTypeID IS NULL OR AccountTypeID =AccountTypeID_);
IF (RadConcurrencyID_ IS NOT NULL) THEN
IF (DATEDIFF(ss,LastSyncDate_ ,sysdate) > 1800) THEN
		RadConcurrencySync;
SELECT MAX(RadConcurrencyID),MAX(LastSyncDate),MAX(Connections),MAX(ConnectionsMax) INTO RadConcurrencyID_,LastSyncDate_,Connections_,ConnectionsMax_ 

		FROM RadConcurrency
			WHERE GroupID =GroupID_
			AND (AccountTypeID IS NULL OR AccountTypeID =AccountTypeID_);
END IF;

IF (Connections_ >=ConnectionsMax_) THEN
OPEN crRadCheckOnline1 FOR 		SELECT Connections_,ConnectionsMax_ 
 FROM DUAL;
ELSE
OPEN crRadCheckOnline1 FOR 		SELECT COUNT(*) 
		FROM ServerPorts 
			WHERE AccountID =accountid_ 
			AND AcctStatusType = 1;
END IF;
ELSE
OPEN crRadCheckOnline1 FOR 	SELECT COUNT(*) 
	FROM ServerPorts 
		WHERE AccountID =accountid_ 
		AND AcctStatusType = 1;
END IF;

END;
END;
/

CREATE OR REPLACE PROCEDURE RadPoolSync AS
BEGIN
UPDATE RadIPAddresses SET State = 0 
	WHERE ((State = 1 AND LastUsed < DATEADD(mi,-20,sysdate)) OR (State = 2))
	AND NOT EXISTS (SELECT * FROM ServerPorts sp WHERE sp.AcctStatusType = 1 AND sp.NASIdentifier = RadIPAddresses.NASIdentifier AND sp.Port = RadIPAddresses.NASPort);
END;
/

CREATE OR REPLACE PROCEDURE RadCheckOnlineCallerID (crRadCheckOnlineCallerID1 IN OUT ieatypes.CursorType,Username_ IN VARCHAR2,accountid_ IN INTEGER,CallerID_ IN VARCHAR2) AS
BEGIN
DECLARE
GroupID_ INTEGER;
LoginLimit_ INTEGER;
Connections_ INTEGER;
ConnectionsMax_ INTEGER;
LastSyncDate_ DATE;
AccountTypeID_ INTEGER;
RadConcurrencyID_ INTEGER;
BEGIN

IF (CallerID_ IS NOT NULL) THEN
	UPDATE ServerPorts SET AcctStatusType = 2 WHERE CallerID =CallerID_ AND AccountID =accountid_;
END IF;

SELECT sa.AccountTypeID,sa.LoginLimit,ma.GroupID INTO AccountTypeID_,LoginLimit_,GroupID_  FROM MasterAccounts ma, SubAccounts sa WHERE ma.CustomerID = sa.CustomerID AND sa.AccountID = accountid_;
SELECT MAX(RadConcurrencyID),MAX(LastSyncDate),MAX(Connections),MAX(ConnectionsMax) INTO RadConcurrencyID_,LastSyncDate_,Connections_,ConnectionsMax_ 

FROM RadConcurrency
	WHERE GroupID =GroupID_
	AND (AccountTypeID IS NULL OR AccountTypeID =AccountTypeID_);
IF (RadConcurrencyID_ IS NOT NULL) THEN
IF (DATEDIFF(ss,LastSyncDate_ ,sysdate) > 1800) THEN
		RadConcurrencySync;
SELECT MAX(RadConcurrencyID),MAX(LastSyncDate),MAX(Connections),MAX(ConnectionsMax) INTO RadConcurrencyID_,LastSyncDate_,Connections_,ConnectionsMax_ 

		FROM RadConcurrency
			WHERE GroupID =GroupID_
			AND (AccountTypeID IS NULL OR AccountTypeID =AccountTypeID_);
END IF;

IF (Connections_ >=ConnectionsMax_) THEN
OPEN crRadCheckOnlineCallerID1 FOR 		SELECT Connections_,ConnectionsMax_ 
 FROM DUAL;
ELSE
OPEN crRadCheckOnlineCallerID1 FOR 		SELECT COUNT(*) 
		FROM ServerPorts 
			WHERE AccountID =accountid_ 
			AND AcctStatusType = 1;
END IF;
ELSE
OPEN crRadCheckOnlineCallerID1 FOR 	SELECT COUNT(*) 
	FROM ServerPorts 
		WHERE AccountID =accountid_ 
		AND AcctStatusType = 1;
END IF;

END;
END;
/

CREATE OR REPLACE PROCEDURE RadCheckOnlineSNMP (crRadCheckOnlineSNMP1 IN OUT ieatypes.CursorType,Username_ IN VARCHAR2,accountid_ IN INTEGER) AS
BEGIN
OPEN crRadCheckOnlineSNMP1 FOR SELECT s.IPAddress, st.SNMPType, s.Community, sp.SNMPUser, sp.AcctSessionID
FROM Servers s, ServerPorts sp, ServerTypes st
	WHERE accountid_ = sp.AccountID 
	AND sp.AcctStatusType = 1
	AND s.ServerType = st.ServerType
	AND s.ServerID = sp.ServerID
	AND sp.SNMPUser IS NOT NULL
	AND s.Community IS NOT NULL;
END;
/

CREATE OR REPLACE PROCEDURE RadCheckTrigger (crRadCheckTrigger1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER) AS
BEGIN
OPEN crRadCheckTrigger1 FOR SELECT FileName, Parameters, Directory, TriggerType 
FROM RadTriggers 
	WHERE AccountID=AccountID_;
END;
/

CREATE OR REPLACE PROCEDURE RadClearNAS (NASIdentifier_ IN VARCHAR2) AS
BEGIN
UPDATE ServerPorts SET AcctStatusType = 2 WHERE NASIdentifier =NASIdentifier_ AND AcctStatusType = 1;
UPDATE RadIPAddresses SET State = 0 WHERE NASIdentifier =NASIdentifier_ AND State <> 0;
END;
/

CREATE OR REPLACE PROCEDURE RadDNISCache (crRadDNISCache1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crRadDNISCache1 FOR SELECT at1.AccountType, dn.DNISNumber
FROM AccountTypes at1, DNISNumbers dn
	WHERE at1.DNISGroupID = dn.DNISGroupID
UNION ALL
SELECT AccountType, NULL
FROM AccountTypes 
	WHERE DNISGroupID IS NULL;
END;
/

CREATE OR REPLACE PROCEDURE RadGetCacheUsers (crRadGetCacheUsers1 IN OUT ieatypes.CursorType,ldate_ IN DATE,flag_ IN SMALLINT) AS
BEGIN
IF (flag_ = 1) THEN

OPEN crRadGetCacheUsers1 FOR SELECT sa.AccountID, sa.Login, CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN sysdate ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Login <> ' '
	AND sa.Login IS NOT NULL
	AND sa.LastModifyDate > ldate_
UNION
SELECT sa.AccountID, sa.Login, CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN sysdate ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Login <> ' '
	AND sa.Login IS NOT NULL
	AND ma.LastModifyDate > ldate_
UNION
SELECT sa.AccountID, sa.Login, CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN sysdate ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Login <> ' '
	AND sa.Login IS NOT NULL
	AND p.LastModifyDate > ldate_
UNION


SELECT sa.AccountID, COALESCE(CASE WHEN sa.Email = ' ' THEN NULL ELSE sa.Email END,sa.Login || '@' || d.MailDomain), CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN sysdate ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE ((sa.Login IS NOT NULL AND sa.Login <> ' ' ) OR (sa.Email IS NOT NULL AND sa.Email <> ' '))
	AND sa.LastModifyDate > ldate_
UNION
SELECT sa.AccountID, COALESCE(CASE WHEN sa.Email = ' ' THEN NULL ELSE sa.Email END,sa.Login || '@' || d.MailDomain), CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN sysdate ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE ((sa.Login IS NOT NULL AND sa.Login <> ' ' ) OR (sa.Email IS NOT NULL AND sa.Email <> ' '))
	AND ma.LastModifyDate > ldate_
UNION
SELECT sa.AccountID, COALESCE(CASE WHEN sa.Email = ' ' THEN NULL ELSE sa.Email END,sa.Login || '@' || d.MailDomain), CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN sysdate ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE ((sa.Login IS NOT NULL AND sa.Login <> ' ' ) OR (sa.Email IS NOT NULL AND sa.Email <> ' '))
	AND p.LastModifyDate > ldate_;
ELSIF (flag_ = 2) THEN
OPEN crRadGetCacheUsers1 FOR SELECT sa.AccountID, sa.Login, CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN sysdate ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Login <> ' '
	AND sa.Login IS NOT NULL
UNION ALL
SELECT sa.AccountID, COALESCE(CASE WHEN sa.Email = ' ' THEN NULL ELSE sa.Email END,sa.Login || '@' || d.MailDomain), CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN sysdate ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE ((sa.Login IS NOT NULL AND sa.Login <> ' ' ) OR (sa.Email IS NOT NULL AND sa.Email <> ' '));
END IF;
END;
/

CREATE OR REPLACE PROCEDURE RadGetConfigs (crRadGetConfigs1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER) AS
BEGIN
OPEN crRadGetConfigs1 FOR Select ra.RadAttributeID, Name, Data, Value, ra.RadAttributeType, rc.RadVendorID, rc.RadCheck, rc.Tag
From RadConfigs rc, RadAttributes ra
Where ra.RadAttributeID=rc.RadAttributeID
	AND ra.RadVendorID = rc.RadVendorID
	AND rc.AccountID=AccountID_
ORDER BY rc.RadConfigID;
END;
/

CREATE OR REPLACE PROCEDURE RadGetFilterGroups (crRadGetFilterGroups1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crRadGetFilterGroups1 FOR SELECT RadFilterGroupID, RadSourceTypeID, RadDestTypeID, DestRadFilterGroupID, DestData
FROM RadFilterGroups
	WHERE Active = 1 OR RadSourceTypeID = 1
ORDER BY SortOrder DESC,RadFilterGroup DESC;
END;
/

CREATE OR REPLACE PROCEDURE RadGetFilters (crRadGetFilters1 IN OUT ieatypes.CursorType,RadFilterGroupID_ IN INTEGER) AS
BEGIN
OPEN crRadGetFilters1 FOR SELECT RadFilterTypeID, RadVendorID, RadAttributeID, RadSearchTypeID, RadMergeTypeID, Location, Data
FROM RadFilters
	WHERE RadFilterGroupID =RadFilterGroupID_
ORDER BY RadFilterID DESC;
END;
/

CREATE OR REPLACE PROCEDURE RadGetPoolConfigs (crRadGetPoolConfigs1 IN OUT ieatypes.CursorType,AccountTypeID_ IN INTEGER,ServerID_ IN INTEGER,NASIdentifier_ IN VARCHAR2,NASPort_ IN VARCHAR2,accountid_ IN INTEGER,callerid_ IN VARCHAR2,dnis_ IN VARCHAR2) AS
BEGIN
DECLARE
AssignType_ INTEGER;
ip_ VARCHAR2(16);
BEGIN
UPDATE RadIPAddresses SET State = 0
	WHERE NASIdentifier =NASIdentifier_
	AND NASPort =NASPort_
	AND (State = 2
		OR (State = 1 AND LastUsed < DATEADD(mi,-2,sysdate)));
SELECT MIN(IPAddress) INTO ip_  FROM RadIPAddresses WHERE AccountID=accountid_;

BEGIN
IF (ip_ IS NULL) THEN
SELECT ria.IPAddress,riat.AssignType INTO ip_,AssignType_ 

FROM ServerGroups sg, RadIPGroups rig, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
	WHERE s.ServerGroupID = sg.ServerGroupID
	AND riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID = rig.RadIPGroupID
	AND ria.RadIPGroupID = rig.RadIPGroupID
	AND riat.AccountTypeID =AccountTypeID_
	AND s.ServerID =ServerID_
	AND ria.State = 0
	AND ria.AccountID IS NULL
	AND ROWNUM = 1
ORDER BY riat.Priority, ria.LastUsed ASC;
END IF;
EXCEPTION WHEN NO_DATA_FOUND THEN NULL;END;

BEGIN
IF (ip_ IS NULL) THEN
SELECT ria.IPAddress,riat.AssignType INTO ip_,AssignType_ 

From ServerGroups sg, RadIPGroups rig, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
Where s.ServerGroupID = sg.ServerGroupID
	AND riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID = rig.RadIPGroupID
	AND ria.RadIPGroupID = rig.RadIPGroupID
	AND riat.AccountTypeID IS NULL
	AND s.ServerID =ServerID_
	AND ria.State = 0
	AND ria.AccountID IS NULL
	AND ROWNUM = 1
ORDER BY riat.Priority, ria.LastUsed ASC;
END IF;
EXCEPTION WHEN NO_DATA_FOUND THEN NULL;END;

BEGIN
IF (ip_ IS NULL) THEN
SELECT ria.IPAddress,riat.AssignType INTO ip_,AssignType_ 

From ServerGroups sg, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
Where s.ServerGroupID = sg.ServerGroupID
	AND riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID IS NULL
	and riat.AccountTypeID =AccountTypeID_
	and s.ServerID =ServerID_
	and ria.State = 0
	AND ria.AccountID IS NULL
	AND ROWNUM = 1
ORDER BY riat.Priority, ria.LastUsed ASC;
END IF;
EXCEPTION WHEN NO_DATA_FOUND THEN NULL;END;

BEGIN
IF (ip_ IS NULL) THEN
SELECT ria.IPAddress,riat.AssignType INTO ip_,AssignType_ 

From ServerGroups sg, RadIPAddresses ria, RadIPAccountTypes riat, Servers s
Where s.ServerGroupID = sg.ServerGroupID
	AND riat.ServerGroupID = sg.ServerGroupID
	AND riat.RadIPGroupID IS NULL
	AND riat.AccountTypeID IS NULL
	and s.ServerID =ServerID_
	and ria.State = 0
	AND ria.AccountID IS NULL
	AND ROWNUM = 1
ORDER BY riat.Priority, ria.LastUsed ASC;
END IF;
EXCEPTION WHEN NO_DATA_FOUND THEN NULL;END;

IF (ip_ IS NOT NULL) THEN
	Update RadIPAddresses
		Set LastUsed = sysdate, State = 1, NASIdentifier =NASIdentifier_, NASPort =NASPort_, AccountID = CASE WHEN AccountID IS NULL AND AssignType_ = 1 THEN accountid_ ELSE AccountID END
		Where IPAddress =ip_;
END IF;

OPEN crRadGetPoolConfigs1 FOR SELECT 8 AS AttributeID,0 AS VendorID, 0 AS Value,ip_ AS Data 
FROM DUAL 
	WHERE ip_ IS NOT NULL;
END;
END;
/

CREATE OR REPLACE PROCEDURE RadGetProxyAttributes (crRadGetProxyAttributes1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crRadGetProxyAttributes1 FOR SELECT apg.RadProxyAttributeGroupID,apg.RadRoamServerID,ap.String,ap.SearchType,ap.RadAttributeID, ap.RadVendorID
FROM RadProxyAttributeGroups apg, RadProxyAttributes ap
	WHERE apg.RadProxyAttributeGroupID = ap.RadProxyAttributeGroupID
ORDER BY apg.Priority ASC, apg.RadProxyAttributeGroupID;
END;
/

CREATE OR REPLACE PROCEDURE RadGetRejects (crRadGetRejects1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crRadGetRejects1 FOR SELECT ra.RadAttributeID, Name, Data, Value, ra.RadAttributeType, rr.RadVendorID
FROM RadAttributes ra, RadRejects rr
	WHERE ra.RadAttributeID=rr.RadAttributeID
	AND ra.RadVendorID = rr.RadVendorID
ORDER BY Data,Value;
END;
/

CREATE OR REPLACE PROCEDURE RadGetUser (crRadGetUser1 IN OUT ieatypes.CursorType,user_ IN VARCHAR2) AS
BEGIN
DECLARE
CustomerID_ INTEGER;
AccountID_ INTEGER;
CardAccountID_ INTEGER;
userp_ VARCHAR2(64);
domainp_ VARCHAR2(64);
chkcard_ INTEGER;
BEGIN
SELECT CASE WHEN user_ LIKE '%@%' THEN SUBSTRING(user_,1,CHARINDEX('@',user_ )-1) END INTO userp_ 

 FROM DUAL;
SELECT CASE WHEN user_ LIKE '%@%' THEN SUBSTRING(user_,CHARINDEX('@',user_ )+1,DATALENGTH(user_)) END INTO domainp_ 


 FROM DUAL;
SELECT MAX(CardAccountID) INTO CardAccountID_ 

FROM CardAccounts
	WHERE Login = COALESCE(userp_,user_ )
	AND Active = 1
	AND AllowDirect = 1
	AND UsedForCredit = 0
	AND UsedForDirect = 0
	AND (InactiveExpireDate IS NULL OR InactiveExpireDate > sysdate);
IF (CardAccountID_ IS NOT NULL) THEN
SELECT COUNT(*) INTO chkcard_  FROM CardAccounts ca, CardBatches cb WHERE ca.CardBatchID = cb.CardBatchID AND cb.Active = 1 AND ca.CardAccountID = CardAccountID_;
IF (chkcard_ = 1) THEN
		UPDATE CardAccounts SET AllowDirect = 0, UsedForDirect = 1 WHERE CardAccountID =CardAccountID_ AND UsedForDirect = 0;
IF (SQL%ROWCOUNT = 1) THEN
			INSERT INTO MasterAccounts (FirstName, LastName, CountryID, SalesPersonID, CreateDate, StartDate, Active, PayPeriodID, PaymentTypeID, Comments, GroupID, SendMethodID, BillingCycleID, BillDay, Balance, PendingBalance,PayInfo, LastModifyDate, LastModifyUser)
			SELECT ' ' AS FirstName, ' ' AS LastName, g.BillCountryID,  cb.SalesPersonID, sysdate, sysdate, 1, cb.PayPeriodID, 1, 'prepaid auto', cb.GroupID, cb.SendMethodID, cb.BillingCycleID, DATEPART(dd,sysdate),0, -(COALESCE(cb.DirectAmount,0)), 'prepaid auto', sysdate, 'prepaid auto'
			FROM CardAccounts ca, CardBatches cb, Groups g
				WHERE ca.CardBatchID = cb.CardBatchID
				AND cb.GroupID = g.GroupID
				AND ca.CardAccountID =CardAccountID_;
SELECT LAST.IDENT INTO CustomerID_ 


 FROM DUAL;
			INSERT INTO Payments (CustomerID, Amount, CreateDate, BatchID, PaymentTypeID, PayInfo, DistFlag, LastModifyDate, LastModifyUser)
			SELECT CustomerID, -(PendingBalance),sysdate,NULL,32,'prepaid direct credit',0,sysdate,'prepaid auto'
			FROM MasterAccounts
				WHERE CustomerID =CustomerID_
				AND PendingBalance < 0;
			INSERT INTO SubAccounts (CustomerID, Login, AccountTypeID, PayPeriodID, DiscountID, Comments, Password, CreateDate, StartDate, BilledThru, ExpireDate, Extension, Active, SalesPersonID, Operator, LastModifyDate, LastModifyUser, TimeLeft, DataLeft, SendBill, RemoteAccess, LoginLimit, DomainID)
			SELECT CustomerID_, ca.Login, cb.AccountTypeID, cb.PayPeriodID, cb.DiscountID, 'prepaid auto', ca.Password, sysdate, sysdate, DATEADD(mi,COALESCE(cb.ActiveExpireMins,0),DATEADD(dd,COALESCE(cb.ActiveExpireDays,0),sysdate)), DATEADD(mi,COALESCE(cb.ActiveExpireMins,0),DATEADD(dd,COALESCE(cb.ActiveExpireDays,0),sysdate)), 0, 1, cb.SalesPersonID, 'prepaid auto', sysdate, 'prepaid auto', cb.TimeLeft, cb.DataLeft, 1, 2, at1.LoginLimit, cb.DomainID
			FROM CardAccounts ca, CardBatches cb, Groups g, AccountTypes at1
				WHERE ca.CardBatchID = cb.CardBatchID
				AND cb.GroupID = g.GroupID
				AND cb.AccountTypeID = at1.AccountTypeID
				AND ca.CardAccountID =CardAccountID_;
SELECT LAST.IDENT INTO AccountID_ 


 FROM DUAL;
			UPDATE CardAccounts SET DirectCustomerID =CustomerID_, DirectAccountID =AccountID_, AllowDirect = 0, UsedForDirect = 1, AllowCredit = 0, FirstUseDate = sysdate WHERE CardAccountID =CardAccountID_;
END IF;
END IF;
END IF;

OPEN crRadGetUser1 FOR SELECT sa.AccountID, sa.Login, CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND TimeLeft > 0),0)) * 60 END AS TimeLeft, 
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN sysdate ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft,
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Login =user_
UNION ALL
SELECT sa.AccountID, sa.Email, CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN sysdate ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance + COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Email =user_
UNION ALL
SELECT sa.AccountID, sa.Login || '@' || d.MailDomain, CASE WHEN p.Active < 0 OR sa.Active < 0 OR ma.Active < 0 THEN NULL ELSE sa.Password END AS Password, NULL, at1.AccountType, sa.LoginLimit, 
CASE WHEN sa.TimeLeft IS NULL THEN NULL ELSE (sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND TimeLeft > 0),0)) * 60 END AS TimeLeft,
CASE WHEN COALESCE(ma.CancelDate,sa.CancelDate) IS NULL THEN NULL WHEN ma.CancelDate = sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate < sa.CancelDate THEN ma.CancelDate WHEN ma.CancelDate IS NOT NULL AND sa.CancelDate IS NOT NULL AND ma.CancelDate > sa.CancelDate THEN sa.CancelDate WHEN ma.CancelDate IS NULL THEN sa.CancelDate WHEN sa.CancelDate IS NULL THEN ma.CancelDate END AS MasterExpire,
CASE WHEN sa.ExpireDate IS NULL THEN NULL ELSE DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) END AS SubExpire,
CASE WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 ELSE 0 END AS OverLimit,
CASE WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN NULL WHEN ma.StartDate IS NULL THEN sysdate ELSE ma.StartDate END AS StartDate,
CASE WHEN at1.RadFailAccountTypeID IS NOT NULL THEN (SELECT at2.AccountType FROM AccountTypes at2 WHERE at2.AccountTypeID = at1.RadFailAccountTypeID) ELSE NULL END AS BadAccountType,
at1.RadFailReason AS BadAck, ma.GroupID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(TotalCost) FROM RateHistory WHERE ChargeID IS NULL AND CustomerID = ma.CustomerID),0) AS AmountLeft, 
CASE WHEN sa.DataLeft IS NULL THEN NULL ELSE sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sau.AccountID=sa.AccountID AND ExpireDate > sysdate AND DataLeft > 0),0) END AS DataLeft
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Email IS NULL 
	AND sa.Login =userp_ 
	AND d.MailDomain =domainp_ 
	AND userp_ IS NOT NULL
	AND domainp_ IS NOT NULL;
END;
END;
/

CREATE OR REPLACE PROCEDURE RadOnlineGetSNMP (crRadOnlineGetSNMP1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crRadOnlineGetSNMP1 FOR SELECT s.IPAddress, st.SNMPType AS ServerType, s.Community, sp.SNMPUser, sp.AcctSessionID, sp.Username, sp.ServerID,sp.Port
FROM Servers s, ServerPorts sp, ServerTypes st
	WHERE s.ServerID = sp.ServerID
	AND s.ServerType = st.ServerType
	AND AcctStatusType=1
	AND DATALENGTH(sp.SNMPUser) > 5
	AND DATALENGTH(s.Community) > 1
	AND Username IS NOT NULL
ORDER BY sp.Port;
END;
/

CREATE OR REPLACE PROCEDURE RadOnlineUpdateSNMP (crRadOnlineUpdateSNMP1 IN OUT ieatypes.CursorType,serverid_ IN INTEGER,port_ IN INTEGER,username_ IN VARCHAR2) AS
BEGIN
DECLARE
status_ INTEGER;
BEGIN
UPDATE ServerPorts SET AcctStatusType = 0
	WHERE AcctStatusType = 1 
	AND ServerID =serverid_
	AND Port =port_
	AND Username =username_;
status_ := SQL%ROWCOUNT;
OPEN crRadOnlineUpdateSNMP1 FOR SELECT CASE WHEN status_ = 0 THEN 'Not Updated' ELSE 'Updated' END AS Status
 FROM DUAL;
END;
END;
/

CREATE OR REPLACE PROCEDURE RadProxyCallCount (crRadProxyCallCount1 IN OUT ieatypes.CursorType) AS
BEGIN
DECLARE
StartDate_ DATE;
BEGIN
SELECT DATEADD(mm,-1,DATEADD(dd,-(DATEPART(dd,DATEADD(dd,-1,sysdate))),DATEADD(ss,-((DATEPART(hh,sysdate)*3600)+(DATEPART(mi,sysdate)*60) + DATEPART(ss,sysdate)),sysdate))) INTO StartDate_ 


 FROM DUAL;

INSERT INTO rpcctmp (Realm, Username, InBytes, OutBytes, SessionTime, SessionCount)
SELECT SUBSTRING(c.Username,CHARINDEX('@',c.Username) + 1,DATALENGTH(c.Username)) AS Realm, c.Username, SUM(c.AcctInputOctets) AS InBytes, SUM(c.AcctOutputOctets) AS OutBytes, SUM(c.AcctSessionTime) AS SessionTime, COUNT(*) AS SessionCount
FROM Calls c
	WHERE c.CallDate BETWEEN StartDate_ AND DATEADD(mm,1,StartDate_ )
	AND c.AcctStatusType = 2
	AND c.AccountID IS NULL
	AND c.Username LIKE '%@%'
GROUP BY c.Username;
OPEN crRadProxyCallCount1 FOR SELECT StartDate_ AS StartDate, COUNT(*) AS Data, COUNT(*) AS SessionMaxData, t.Realm, SUM(t.InBytes) + SUM(t.OutBytes) AS AllBytes, SUM(t.InBytes) AS InBytes, SUM(t.OutBytes) AS OutBytes, SUM(t.SessionTime) AS SessionMaxTime, SUM(t.SessionTime) AS SessionTime, SUM(t.SessionCount) AS SessionCount
FROM rpcctmp t
	WHERE NOT EXISTS (SELECT * FROM RadProxyRateProcs rprp WHERE rprp.Realm = t.Realm AND rprp.ProxyType = 1 AND rprp.ProcDate =StartDate_)
GROUP BY t.Realm;
DELETE FROM rpcctmp;
END;
END;
/

CREATE OR REPLACE PROCEDURE RadProxyCallCountUP (ProxyType_ IN SMALLINT,Realm_ IN VARCHAR2,InBytes_ IN NUMBER,OutBytes_ IN NUMBER,UserCount_ IN INTEGER,SessionTime_ IN INTEGER,SessionCount_ IN INTEGER) AS
BEGIN
DECLARE
StartDate_ DATE;
BEGIN
SELECT DATEADD(mm,-1,DATEADD(dd,-(DATEPART(dd,DATEADD(dd,-1,sysdate))),DATEADD(ss,-((DATEPART(hh,sysdate)*3600)+(DATEPART(mi,sysdate)*60) + DATEPART(ss,sysdate)),sysdate))) INTO StartDate_ 


 FROM DUAL;
INSERT INTO RadProxyRateProcs (Realm, ProxyType, ProcDate, InBytes, OutBytes, UserCount, SessionTime, SessionCount)
VALUES(Realm_,ProxyType_ ,StartDate_ ,InBytes_ ,OutBytes_ ,UserCount_ ,SessionTime_ ,SessionCount_ );
END;
END;
/

CREATE OR REPLACE PROCEDURE RadRoamCache (crRadRoamCache1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crRadRoamCache1 FOR SELECT Domain AS Label, Server, IPAddress, Secret, AuthPort, AcctPort,
Priority, Timeout, Retries, StripDomain, TreatAsLocal, at1.AccountType, rrs.RateTarget, rrs.RateMax
From RadRoamServers rrs JOIN RadRoamDomains rrd ON (rrd.RadRoamServerID = rrs.RadRoamServerID)
	LEFT JOIN AccountTypes at1 ON (rrd.AccountTypeID = at1.AccountTypeID)
UNION
SELECT rrd2.Domain AS Label, Server, IPAddress, Secret, AuthPort, AcctPort, 
rrd.Priority, Timeout, Retries, StripDomain, TreatAsLocal,at1.AccountType, rrs.RateTarget, rrs.RateMax
FROM RadRoamDomains rrd, RadRoamServers rrs, RadRoamDomains rrd2, AccountTypes at1
	WHERE rrd.RadRoamServerID = rrs.RadRoamServerID
	AND rrd.Domain = 'DEFAULT'
	AND rrd.AccountTypeID = at1.AccountTypeID
UNION
SELECT CAST(RadRoamServerID AS VARCHAR(10)) AS Label, Server, IPAddress, Secret, AuthPort, AcctPort, 
0, Timeout, Retries, StripDomain, TreatAsLocal, NULL, RateTarget, RateMax
FROM RadRoamServers
ORDER BY Label,Priority;
END;
/

CREATE OR REPLACE PROCEDURE RadServerAccessCache (crRadServerAccessCache1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crRadServerAccessCache1 FOR SELECT MaxSessionLength, StartTime, StopTime, s.IPAddress, sa.Port, at1.AccountType
FROM Servers s JOIN ServerAccess sa ON (s.ServerID = sa.ServerID)
	LEFT JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
UNION
SELECT MaxSessionLength, StartTime, StopTime, s.Server, sa.Port, at1.AccountType
FROM Servers s JOIN ServerAccess sa ON (s.ServerID = sa.ServerID)
	LEFT JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
UNION
SELECT NULL, NULL, NULL, s.IPAddress, NULL, NULL
FROM Servers s
WHERE s.CheckAccess = 0
UNION
SELECT NULL, NULL, NULL, s.Server, NULL, NULL
FROM Servers s
WHERE s.CheckAccess = 0;
END;
/

CREATE OR REPLACE PROCEDURE RateCallsResellerClassifier (crRateCallsResellerClassifie1 IN OUT ieatypes.CursorType) AS
BEGIN
INSERT INTO rcrctmp2 (GroupID)
SELECT g.GroupID
FROM Groups g, Organizations o
	WHERE g.OrganizationID = o.OrganizationID
	AND o.ResellerCustomerID IS NULL;
INSERT INTO rcrctmp (GroupID, CustomerID)
SELECT g.GroupID, o.ResellerCustomerID
FROM Groups g, Organizations o
	WHERE g.OrganizationID = o.OrganizationID
	AND o.ResellerCustomerID IS NOT NULL;
OPEN crRateCallsResellerClassifie1 FOR SELECT 'GroupID' AS Attribute, GroupID AS GroupingID, 1 AS MatchTypeID, CAST(GroupID AS VARCHAR(16)) AS Data, NULL AS Cost, NULL AS Priority FROM rcrctmp
UNION ALL
SELECT 'CustomerID' AS Attribute, GroupID AS GroupingID, 256 AS MatchTypeID, CAST(CustomerID AS VARCHAR(16)) AS Data, NULL AS Cost, NULL AS Priority FROM rcrctmp
UNION ALL
SELECT 'GroupID' AS Attribute, GroupID AS GroupingID, 1 AS MatchTypeID, CAST(GroupID AS VARCHAR(16)) AS Data, NULL AS Cost, NULL AS Priority FROM rcrctmp2
UNION ALL
SELECT 'RateClassID' AS Attribute, GroupID AS GroupingID, 256 AS MatchTypeID, '0' AS Data, NULL AS Cost, NULL AS Priority FROM rcrctmp2;
END;
/

CREATE OR REPLACE PROCEDURE RateCallsUP (crRateCallsUP1 IN OUT ieatypes.CursorType,hostip_ IN VARCHAR2,Preferred_ IN INTEGER,CallID_ IN NUMBER,Message_ IN VARCHAR2) AS
BEGIN
DECLARE
IsLeader_ INTEGER;
Leader_ VARCHAR2(64);
LastUpdate_ DATE;
LastMessage_ VARCHAR2(255);
Advisor_ VARCHAR2(64);
LastAdviceDate_ DATE;
status_ INTEGER;
Lead_ INTEGER;
BEGIN
SELECT MAX(Leader),MAX(LastUpdate),MAX(LastMessage),MAX(Advisor),MAX(LastAdviceDate) INTO Leader_,LastUpdate_,LastMessage_,Advisor_,LastAdviceDate_  FROM RateStatusCalls;
IF (hostip_ =Leader_) THEN
IF (Advisor_ <> hostip_ AND DATEDIFF(ss,LastAdviceDate_ ,sysdate) < 90 AND Preferred_ = 0 AND CallID_ IS NOT NULL) THEN
	UPDATE RateStatusCalls SET LastCallID =CallID_, LastMessage = COALESCE(Message_,LastMessage), Leader = Advisor, LastUpdate = sysdate WHERE Leader =hostip_;
SELECT 0 INTO Lead_ 


 FROM DUAL;
ELSE
	UPDATE RateStatusCalls SET LastUpdate = sysdate, LastCallID = COALESCE(CallID_,LastCallID), LastMessage = COALESCE(Message_,LastMessage) WHERE Leader =hostip_;
IF (SQL%ROWCOUNT = 0) THEN
IF (Preferred_ = 1) THEN
			UPDATE RateStatusCalls SET Advisor =hostip_, LastAdviceDate = DATEADD(mi,1,sysdate);
END IF;
SELECT 0 INTO Lead_ 


 FROM DUAL;
ELSE
SELECT 1 INTO Lead_ 

 FROM DUAL;
END IF;
END IF;

ELSE
IF (DATEDIFF(ss,LastUpdate_ ,sysdate) > 90) THEN
	UPDATE RateStatusCalls SET Leader =hostip_, LastUpdate = sysdate, LastCallID = COALESCE(CallID_,LastCallID), LastMessage = NULL WHERE DATEDIFF(ss,LastUpdate,sysdate) > 90 OR Leader =hostip_;
	status_ := SQL%ROWCOUNT;
SELECT CASE WHEN status_ = 1 THEN 1 ELSE 0 END INTO Lead_ 

 FROM DUAL;
ELSE
SELECT 0 INTO Lead_ 

 FROM DUAL;
END IF;
END IF;

OPEN crRateCallsUP1 FOR SELECT Lead_ AS Lead
 FROM DUAL;
END;
END;
/

CREATE OR REPLACE PROCEDURE RateChargesGet (crRateChargesGet1 IN OUT ieatypes.CursorType) AS
BEGIN
DECLARE
delay_ INTEGER;
interim_ INTEGER;
thismonth_ DATE;
BEGIN
SELECT CASE WHEN NumValue <= 0 THEN 1 WHEN NumValue > 15 THEN 15 ELSE NumValue END INTO delay_  FROM Configs WHERE ConfigID = 646;
SELECT CASE WHEN NumValue = 1 THEN 1 ELSE 0 END INTO interim_  FROM Configs WHERE ConfigID = 647;
SELECT DATEADD(dd,-(DATEPART(dd,DATEADD(dd,-1,sysdate))),DATEADD(ss,-((DATEPART(hh,sysdate)*3600)+(DATEPART(mi,sysdate)*60) + DATEPART(ss,sysdate)),sysdate)) INTO thismonth_ 


 FROM DUAL;
INSERT INTO rcgv (AccountID,MaxCallDate,Cost,Cnt,RateID,Interim)
SELECT sa.AccountID, MAX(vc.CallDate) AS MaxCallDate, SUM(vc.Cost) AS Cost, COUNT(*) AS Cnt, (SELECT MIN(RateID) FROM Rates WHERE RateClassID=at1.RateClassID AND RateSourceID=4) AS RateID, COALESCE(MAX(cgdi.NumValue),interim_ ) AS Interim
FROM VoiceCalls vc JOIN SubAccounts sa ON (vc.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (bc.BillingCycleID = ma.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN ConfigGroupData cgdi ON (cgdi.GroupID = ma.GroupID AND cgdi.ConfigID = 647)
	LEFT JOIN ConfigGroupData cgdd ON (cgdd.GroupID = ma.GroupID AND cgdd.ConfigID = 646)
	WHERE ma.Active = 1
	AND sa.Active IN (1,0)
	AND vc.ProcDate IS NOT NULL
	AND vc.ChargeID IS NULL
	AND (COALESCE(cgdi.NumValue,interim_ ) = 1 
		OR DATEADD(dd,1,ma.CancelDate) < sysdate
		OR DATEADD(dd,1,sa.CancelDate) < sysdate
		OR vc.CallDate < DATEADD(dd,CASE
	WHEN bc.CycleType IN (1,2) AND (bc.BillDay IS NULL OR bc.BillDay = 1) THEN 0
	WHEN bc.CycleType IN (0,3) AND (ma.BillDay <= 1 OR ma.BillDay >= 28) THEN 0
	WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) - 1
	WHEN bc.CycleType IN (0,3) THEN ma.BillDay - 1 END + 
	CASE WHEN COALESCE(cgdd.NumValue,delay_ ) <= 1 OR COALESCE(cgdi.NumValue,interim_ ) = 1 THEN 0 ELSE -(delay_) END,thismonth_ ))
GROUP BY sa.AccountID, at1.RateClassID;
OPEN crRateChargesGet1 FOR SELECT rr.RateRule AS RRDescription, rr.StringID AS RRStringID, ct.TaxGroupID, ct.TaxExemptions, ct.Description AS CTDescription, ct.StringID AS CTStringID, 
ct.ChargeTypeID, rh.TotalCost, ma.CustomerID, rh.AccountID, rh.StartDate, rh.CustomerID AS RHCustomerID, rh.RateRuleID, rh.RateID, ma.LanguageID, r.MinCharge, COALESCE(sa.Login,sa.Email) AS Login, 0 AS RBType, NULL AS RecordCount
FROM RateHistory rh LEFT JOIN Rates r ON (rh.RateID = r.RateID)
	LEFT JOIN ChargeTypes ct ON (r.ChargeTypeID = ct.ChargeTypeID)
	JOIN SubAccounts sa ON (rh.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	LEFT JOIN RateRules rr ON (rh.RateRuleID = rr.RateRuleID)
	LEFT JOIN ConfigGroupData cgdd ON (ma.GroupID = cgdd.GroupID AND cgdd.ConfigID = 647)
	LEFT JOIN ConfigGroupData cgdc ON (ma.GroupID = cgdc.GroupID AND cgdc.ConfigID = 648)
	WHERE rh.CustomerID = 0
	AND ma.Active = 1
	AND rh.ChargeID IS NULL
	AND (COALESCE(cgdc.NumValue,interim_ ,0) = 1 
		OR DATEADD(dd,1,ma.CancelDate) < sysdate
		OR DATEADD(dd,1,sa.CancelDate) < sysdate
		OR rh.StartDate < DATEADD(dd,-(COALESCE(cgdd.NumValue,delay_ ,1)),DATEADD(mm,-1,sysdate)))

UNION ALL

SELECT rr.RateRule AS RRDescription, rr.StringID AS RRStringID, ct.TaxGroupID, ct.TaxExemptions, ct.Description AS CTDescription, ct.StringID AS CTStringID, 
ct.ChargeTypeID, rh.TotalCost, ma.CustomerID, rh.AccountID, rh.StartDate, rh.CustomerID AS RHCustomerID, rh.RateRuleID, rh.RateID, ma.LanguageID, r.MinCharge, COALESCE(sa.Login,sa.Email) AS Login, 0 AS RBType, NULL AS RecordCount
FROM RateHistory rh LEFT JOIN Rates r ON (rh.RateID = r.RateID) 
	LEFT JOIN ChargeTypes ct ON (r.ChargeTypeID = ct.ChargeTypeID)
	JOIN MasterAccounts ma ON (rh.CustomerID = ma.CustomerID)
	LEFT JOIN SubAccounts sa ON (sa.AccountID = rh.AccountID)
	LEFT JOIN RateRules rr ON (rh.RateRuleID = rr.RateRuleID)
	LEFT JOIN ConfigGroupData cgdd ON (ma.GroupID = cgdd.GroupID AND cgdd.ConfigID = 647)
	LEFT JOIN ConfigGroupData cgdc ON (ma.GroupID = cgdc.GroupID AND cgdc.ConfigID = 648)
	WHERE rh.CustomerID <> 0
	AND ma.Active = 1
	AND rh.ChargeID IS NULL
	AND (COALESCE(cgdc.NumValue,interim_ ,0) = 1 
		OR DATEADD(dd,1,ma.CancelDate) < sysdate
		OR DATEADD(dd,1,sa.CancelDate) < sysdate
		OR rh.StartDate < DATEADD(dd,-(COALESCE(cgdd.NumValue,delay_ ,1)),DATEADD(mm,-1,sysdate)))

UNION ALL

SELECT NULL AS RRDescription, NULL AS RRStringID, ct.TaxGroupID, ct.TaxExemptions, ct.Description AS CTDescription, ct.StringID AS CTStringID, 
ct.ChargeTypeID, CASE WHEN r.MaxCharge < rcgv.Cost THEN r.MaxCharge ELSE rcgv.Cost END AS TotalCost, ma.CustomerID, sa.AccountID, rcgv.MaxCallDate AS StartDate, ma.CustomerID AS RHCustomerID, NULL AS RateRuleID,
rcgv.RateID, ma.LanguageID, CASE WHEN rcgv.Interim = 1 THEN NULL ELSE r.MinCharge END AS MinCharge, COALESCE(sa.Login,sa.Email) AS Login,
2 AS RBType,rcgv.Cnt AS RecordCount
FROM rcgv rcgv, SubAccounts sa, MasterAccounts ma, Rates r, ChargeTypes ct
	WHERE rcgv.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND rcgv.RateID = r.RateID
	AND r.ChargeTypeID = ct.ChargeTypeID
ORDER BY 9,11,10,14;
DELETE FROM rcgv;
END;
END;
/

CREATE OR REPLACE PROCEDURE RateGetCalls (crRateGetCalls1 IN OUT ieatypes.CursorType) AS
BEGIN
DECLARE
LastCallID_ NUMBER(38);
BEGIN
SELECT MAX(LastCallID) INTO LastCallID_  FROM RateStatusCalls;
OPEN crRateGetCalls1 FOR SELECT ma.GroupID, at1.RateClassID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, c.CallID, c.Username, c.NASIdentifier, c.NASPort, DATEADD(ss,-(c.AcctSessionTime),c.CallDate) AS StartDate, c.AcctSessionTime AS Duration, c.FramedAddress, COALESCE(c.AcctOutputOctets,0) + COALESCE(c.AcctInputOctets,0) AS Data, c.AcctTerminateCause, c.NASPortType, c.NASPortDNIS, c.CallerID, c.ConnectInfo, c.AccountID
FROM Calls c, MasterAccounts ma, SubAccounts sa, AccountTypes at1, BillingCycles bc
	WHERE c.CallID > LastCallID_
	AND c.AccountID = sa.AccountID
	AND ma.CustomerID = sa.CustomerID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND c.AcctStatusType = 2
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.RateClassID IS NOT NULL;
END;
END;
/

CREATE OR REPLACE PROCEDURE RateGetVoiceCalls (crRateGetVoiceCalls1 IN OUT ieatypes.CursorType) AS
BEGIN

OPEN crRateGetVoiceCalls1 FOR SELECT ma.BillDay, ma.GroupID, at1.RateClassID, vc.VoiceCallID,vc.Login,sa.AccountID,vc.CallDate AS StartDate, vc.Duration, vc.SessionRef, vc.CalledNumber, vc.CallingPort, vc.CalledPort, vc.Bytes AS Data, vc.CallType, vc.AcctTerminateCause, vc.Location
FROM VoiceCalls vc, SubAccounts sa, MasterAccounts ma, AccountTypes at1
	WHERE vc.Login = sa.Login
	AND ma.CustomerID = sa.CustomerID
	AND ma.Active = 1
	AND sa.Active IN (1,0)
	AND sa.AccountTypeID = at1.AccountTypeID
	AND vc.ChargeID IS NULL
	AND vc.ProcDate IS NULL
	AND at1.RateClassID IS NOT NULL;
END;
/

CREATE OR REPLACE PROCEDURE RateVoiceCallsUP (AccountID_ IN INTEGER,VoiceCallID_ IN NUMBER,Matched_ IN INTEGER,Cost_ IN NUMERIC) AS
BEGIN
UPDATE VoiceCalls SET AccountID = COALESCE(AccountID,AccountID_ ), Cost = CAST(Cost_ AS NUMERIC(18,4)), ProcDate = CASE WHEN Matched_ = 1 THEN sysdate ELSE NULL END, ErrorCode = CASE WHEN Matched_ = 0 THEN 1 ELSE NULL END 
WHERE VoiceCallID =VoiceCallID_
AND ProcDate IS NULL
AND ChargeID IS NULL;
END;
/

CREATE OR REPLACE PROCEDURE RateVoiceCallsClear AS
BEGIN
UPDATE VoiceCalls SET ProcDate = NULL, ErrorCode = NULL WHERE ProcDate IS NOT NULL AND ChargeID IS NULL;
END;
/

CREATE OR REPLACE PROCEDURE RateVoiceCallsLoc AS
BEGIN
MERGE INTO VoiceCalls mvc
USING (SELECT vc.VoiceCallID, lp.City, s.StateID, s.CountryID
FROM VoiceCalls vc, LocPhones lp, States s
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND DATALENGTH(vc.CalledNumber) = 10
	AND SUBSTRING(vc.CalledNumber,1,6) = lp.Prefix
	AND lp.StateID = s.StateID) vc
ON (mvc.VoiceCallID = vc.VoiceCallID)
WHEN MATCHED THEN UPDATE SET mvc.Location = vc.City, mvc.StateID = vc.StateID, mvc.CountryID = vc.CountryID;


MERGE INTO VoiceCalls mvc
USING (SELECT vc.VoiceCallID, lp.City, s.StateID, s.CountryID
FROM VoiceCalls vc, LocPhones lp, States s
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND DATALENGTH(vc.CalledNumber) = 11
	AND SUBSTRING(vc.CalledNumber,1,7) = '1' || lp.Prefix
	AND lp.StateID = s.StateID) vc
ON (mvc.VoiceCallID = vc.VoiceCallID)
WHEN MATCHED THEN UPDATE SET mvc.Location = vc.City, mvc.StateID = vc.StateID, mvc.CountryID = vc.CountryID;


MERGE INTO VoiceCalls mvc
USING (SELECT vc.VoiceCallID, c.CountryID
FROM VoiceCalls vc, Countries c
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND (vc.CalledNumber LIKE '+%' OR vc.CalledNumber LIKE '0%')
	AND c.TelPrefix NOT IN ('1','7')
	AND DATALENGTH(vc.CalledNumber) > 8
	AND SUBSTRING(vc.CalledNumber,2,DATALENGTH(c.TelPrefix)) = c.TelPrefix) vc
ON (mvc.VoiceCallID = vc.VoiceCallID)
WHEN MATCHED THEN UPDATE SET mvc.CountryID = vc.CountryID;


MERGE INTO VoiceCalls mvc
USING (SELECT vc.VoiceCallID, c.CountryID
FROM VoiceCalls vc, Countries c
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND c.TelPrefix NOT IN ('1','7')
	AND DATALENGTH(vc.CalledNumber) > 8
	AND SUBSTRING(vc.CalledNumber,1,DATALENGTH(c.TelPrefix)) = c.TelPrefix) vc
ON (mvc.VoiceCallID = vc.VoiceCallID)
WHEN MATCHED THEN UPDATE SET mvc.CountryID = vc.CountryID;


MERGE INTO VoiceCalls mvc
USING (SELECT vc.VoiceCallID, c.CountryID
FROM VoiceCalls vc, Countries c
	WHERE vc.CountryID IS NULL
	AND vc.StateID IS NULL
	AND vc.Location IS NULL
	AND vc.CalledNumber LIKE '011%'
	AND c.TelPrefix NOT IN ('1','7')
	AND DATALENGTH(vc.CalledNumber) > 8
	AND SUBSTRING(vc.CalledNumber,4,DATALENGTH(c.TelPrefix)) = c.TelPrefix) vc
ON (mvc.VoiceCallID = vc.VoiceCallID)
WHEN MATCHED THEN UPDATE SET mvc.CountryID = vc.CountryID;

END;
/

CREATE OR REPLACE PROCEDURE RateHistAll (crRateHistAll1 IN OUT ieatypes.CursorType,RateSourceID_ IN INTEGER) AS
BEGIN
OPEN crRateHistAll1 FOR SELECT rh.StartDate, rh.AccountID,  CASE WHEN sa.CustomerID = rh.CustomerID THEN NULL ELSE rh.CustomerID END AS CustomerID, rh.RateRuleID, rh.RateID, rh.TotalTime, rh.TotalCount, rh.TotalCost, rh.TotalData
FROM Rates r, RateHistory rh, SubAccounts sa
	WHERE rh.StartDate > DATEADD(dd,-45,sysdate)
	AND r.RateID = rh.RateID
	AND rh.AccountID = sa.AccountID
	AND r.RateSourceID =RateSourceID_;
END;
/

CREATE OR REPLACE PROCEDURE RateHistoryUnapplied (crRateHistoryUnapplied1 IN OUT ieatypes.CursorType) AS
BEGIN

OPEN crRateHistoryUnapplied1 FOR SELECT MIN(r.Description) AS Rate, DATEDIFF(mm,StartDate,sysdate) AS Months, COUNT(*) AS Records, SUM (TotalTime) AS TotalTime, SUM(TotalCost) AS TotalCost, SUM(TotalCount) AS TotalCount, SUM(TotalData) AS TotalData
FROM RateHistory rh, Rates r
	WHERE rh.ChargeID IS NULL
	AND rh.StartDate >= DATEADD(mm,-12,sysdate)
	AND r.RateID = rh.RateID
GROUP BY DATEDIFF(mm,StartDate,sysdate), r.RateID
ORDER BY 2,1;

END;
/

CREATE OR REPLACE PROCEDURE RateHistUser (crRateHistUser1 IN OUT ieatypes.CursorType,RateSourceID_ IN INTEGER,AccountID_ IN INTEGER,StartDate_ IN DATE) AS
BEGIN
OPEN crRateHistUser1 FOR SELECT rh.StartDate, rh.AccountID, CASE WHEN sa.CustomerID = rh.CustomerID THEN NULL ELSE rh.CustomerID END AS CustomerID, rh.RateRuleID, rh.RateID, rh.TotalTime, rh.TotalCount, rh.TotalData, rh.TotalCost
FROM Rates r, RateHistory rh, SubAccounts sa
	WHERE rh.StartDate >=StartDate_
	AND r.RateID = rh.RateID
	AND rh.AccountID = sa.AccountID
	AND rh.AccountID =AccountID_
	AND r.RateSourceID =RateSourceID_;
END;
/

CREATE OR REPLACE PROCEDURE RateNetflowResellerClassifier (crRateNetflowResellerClassif1 IN OUT ieatypes.CursorType,Direction_ IN INTEGER) AS
BEGIN



INSERT INTO rnrctmp (AccountID, CustomerID, RateClassID, BillDay, IPAddress, CollectIP)
SELECT sa.AccountID, o.ResellerCustomerID, at1.RateClassID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, sad11.Data AS IPAddress, sad12.Data AS CollectIP
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN SubAccountData sad11 ON (sa.AccountID = sad11.AccountID AND sad11.AccountDataTypeID=11)
	LEFT JOIN SubAccountData sad12 ON (sa.AccountID = sad12.AccountID AND sad12.AccountDataTypeID=12)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sad11.Data IS NOT NULL
	AND at1.RateClassID IS NOT NULL
	AND o.ResellerCustomerID IS NOT NULL
	AND DATALENGTH(sad11.Data) > 2;
OPEN crRateNetflowResellerClassif1 FOR SELECT 'DstIP' AS Attribute, AccountID AS GroupingID, 8 AS MatchTypeID, IPAddress AS Data, NULL AS Cost, NULL AS Priority FROM rnrctmp WHERE Direction_ IN (1,3)
UNION ALL
SELECT 'Direction' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, 'in' AS Data, NULL AS Cost, NULL AS Priority FROM rnrctmp WHERE Direction_ IN (1,3)
UNION ALL
SELECT 'AccountID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rnrctmp WHERE Direction_ IN (1,3)
UNION ALL
SELECT 'BillDay' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(BillDay AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rnrctmp WHERE Direction_ IN (1,3)
UNION ALL
SELECT 'RateClassID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rnrctmp WHERE Direction_ IN (1,3)
UNION ALL
SELECT 'CollectIP' AS Attribute, AccountID AS GroupingID, 8 AS MatchTypeID, CollectIP AS Data, NULL AS Cost, NULL AS Priority FROM rnrctmp WHERE Direction_ IN (1,3) AND CollectIP IS NOT NULL
UNION ALL
SELECT 'AccountID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(CustomerID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rnrctmp WHERE Direction_ IN (1,3)
UNION ALL
SELECT 'SrcIP' AS Attribute, 1000000000 + AccountID AS GroupingID, 8 AS MatchTypeID, IPAddress AS Data, NULL AS Cost, NULL AS Priority FROM rnrctmp WHERE Direction_ IN (2,3)
UNION ALL
SELECT 'Direction' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, 'out' AS Data, NULL AS Cost, NULL AS Priority FROM rnrctmp WHERE Direction_ IN (2,3)
UNION ALL
SELECT 'AccountID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rnrctmp WHERE Direction_ IN (2,3)
UNION ALL
SELECT 'BillDay' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(BillDay AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rnrctmp WHERE Direction_ IN (2,3)
UNION ALL
SELECT 'RateClassID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rnrctmp WHERE Direction_ IN (2,3)
UNION ALL
SELECT 'CollectIP' AS Attribute, 1000000000 + AccountID AS GroupingID, 8 AS MatchTypeID, CollectIP AS Data, NULL AS Cost, NULL AS Priority FROM rnrctmp WHERE Direction_ IN (2,3) AND CollectIP IS NOT NULL
UNION ALL
SELECT 'CustomerID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(CustomerID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rnrctmp WHERE Direction_ IN (2,3);

DELETE FROM rnrctmp;
END;
/

CREATE OR REPLACE PROCEDURE RateNetflowUserClassifier (crRateNetflowUserClassifier1 IN OUT ieatypes.CursorType,Direction_ IN INTEGER) AS
BEGIN



INSERT INTO rnuctmp (AccountID, RateClassID, BillDay, IPAddress, CollectIP)
SELECT sa.AccountID, at1.RateClassID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, sad11.Data AS IPAddress, sad12.Data AS CollectIP
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN SubAccountData sad11 ON (sa.AccountID = sad11.AccountID AND sad11.AccountDataTypeID=11)
	LEFT JOIN SubAccountData sad12 ON (sa.AccountID = sad12.AccountID AND sad12.AccountDataTypeID=12)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sad11.Data IS NOT NULL
	AND at1.RateClassID IS NOT NULL
	AND DATALENGTH(sad11.Data) > 2;
OPEN crRateNetflowUserClassifier1 FOR SELECT 'DstIP' AS Attribute, AccountID AS GroupingID, 8 AS MatchTypeID, IPAddress AS Data, NULL AS Cost, NULL AS Priority FROM rnuctmp WHERE Direction_ IN (1,3)
UNION ALL
SELECT 'Direction' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, 'in' AS Data, NULL AS Cost, NULL AS Priority FROM rnuctmp WHERE Direction_ IN (1,3)
UNION ALL
SELECT 'AccountID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rnuctmp WHERE Direction_ IN (1,3)
UNION ALL
SELECT 'BillDay' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(BillDay AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rnuctmp WHERE Direction_ IN (1,3)
UNION ALL
SELECT 'RateClassID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rnuctmp WHERE Direction_ IN (1,3)
UNION ALL
SELECT 'CollectIP' AS Attribute, AccountID AS GroupingID, 8 AS MatchTypeID, CollectIP AS Data, NULL AS Cost, NULL AS Priority FROM rnuctmp WHERE Direction_ IN (1,3) AND CollectIP IS NOT NULL
UNION ALL
SELECT 'SrcIP' AS Attribute, 1000000000 + AccountID AS GroupingID, 8 AS MatchTypeID, IPAddress AS Data, NULL AS Cost, NULL AS Priority FROM rnuctmp WHERE Direction_ IN (2,3)
UNION ALL
SELECT 'Direction' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, 'out' AS Data, NULL AS Cost, NULL AS Priority FROM rnuctmp WHERE Direction_ IN (2,3)
UNION ALL
SELECT 'AccountID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rnuctmp WHERE Direction_ IN (2,3)
UNION ALL
SELECT 'BillDay' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(BillDay AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rnuctmp WHERE Direction_ IN (2,3)
UNION ALL
SELECT 'RateClassID' AS Attribute, 1000000000 + AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rnuctmp WHERE Direction_ IN (2,3)
UNION ALL
SELECT 'CollectIP' AS Attribute, 1000000000 + AccountID AS GroupingID, 8 AS MatchTypeID, CollectIP AS Data, NULL AS Cost, NULL AS Priority FROM rnuctmp WHERE Direction_ IN (2,3) AND CollectIP IS NOT NULL;

DELETE FROM rnuctmp;
END;
/

CREATE OR REPLACE PROCEDURE RateProxyUserClassifier (crRateProxyUserClassifier1 IN OUT ieatypes.CursorType) AS
BEGIN

INSERT INTO rpuctmp (AccountID, RateClassID, Data)
SELECT sa.AccountID, at1.RateClassID, sad.Data
FROM SubAccountData sad JOIN SubAccounts sa ON (sad.AccountID = sa.AccountID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	WHERE ma.Active = 1
	AND sa.Active IN (1,0)
	AND sad.AccountDataTypeID = 14
	AND at1.RateClassID IS NOT NULL;
OPEN crRateProxyUserClassifier1 FOR SELECT 'BillDay' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(1 AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rpuctmp
UNION ALL
SELECT 'RateClassID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(RateClassID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rpuctmp
UNION ALL
SELECT 'AccountID' AS Attribute, AccountID AS GroupingID, 256 AS MatchTypeID, CAST(AccountID AS VARCHAR(10)) AS Data, NULL AS Cost, NULL AS Priority FROM rpuctmp
UNION ALL
SELECT 'Realm' AS Attribute, AccountID AS GroupingID, 1 AS MatchTypeID, Data, NULL AS Cost, NULL AS Priority FROM rpuctmp;
DELETE FROM rpuctmp;
END;
/

CREATE OR REPLACE PROCEDURE RateStdRules (crRateStdRules1 IN OUT ieatypes.CursorType,RateRuleID_ IN INTEGER) AS
BEGIN
OPEN crRateStdRules1 FOR SELECT rsi.Attribute, rsi.RateStdGroupID AS GroupingID, rsi.RateMatchTypeID AS MatchTypeID, rsi.Data, rsg.Cost, rsg.Priority
FROM RateStdGroups rsg, RateStdItems rsi
	WHERE rsg.RateStdGroupID = rsi.RateStdGroupID
	AND rsg.RateRuleID =RateRuleID_
UNION ALL
SELECT 'Default' AS Attribute, 0 AS GroupingID, 128 AS MatchTypeID, NULL AS Data, DefaultCost, NULL AS Priority
FROM RateRules WHERE RateRuleID =RateRuleID_;
END;
/

CREATE OR REPLACE PROCEDURE RateUP (CustomerID_ IN INTEGER,AccountID_ IN INTEGER,RateID_ IN INTEGER,RateRuleID_ IN INTEGER,TotalCount_ IN NUMERIC,TotalData_ IN NUMBER,TotalTime_ IN INTEGER,TotalCost_ IN NUMERIC,StartDate_ IN DATE) AS
BEGIN
DECLARE
MaxStartDate_ DATE;
custid_ INTEGER;
BEGIN
SELECT CustomerID INTO custid_  FROM SubAccounts WHERE AccountID=AccountID_;
IF (custid_ IS NOT NULL) THEN
UPDATE RateHistory SET TotalCount = TotalCount + TotalCount_, TotalData = TotalData + TotalData_, TotalTime = TotalTime + TotalTime_, TotalCost = TotalCost + TotalCost_
	WHERE StartDate BETWEEN StartDate_ AND DATEADD(hh,1,StartDate_ )
	AND AccountID =AccountID_
	AND CustomerID = CASE WHEN CustomerID_ <= 0 THEN custid_ ELSE CustomerID_ END
	AND RateID =RateID_
	AND RateRuleID =RateRuleID_
	AND ChargeID IS NULL;
IF (SQL%ROWCOUNT < 1) THEN
SELECT MAX(StartDate)  INTO MaxStartDate_ 

	FROM RateHistory 
		WHERE StartDate BETWEEN StartDate_ AND DATEADD(hh,1,StartDate_ )
		AND AccountID =AccountID_
		AND CustomerID = CASE WHEN CustomerID_ <= 0 THEN custid_ ELSE CustomerID_ END
		AND RateID =RateID_
		AND RateRuleID =RateRuleID_
	;
	INSERT INTO RateHistory (StartDate,AccountID,CustomerID,RateRuleID,RateID,TotalTime,ChargeID,TotalCount,TotalData,TotalCost)
	VALUES(CASE WHEN MaxStartDate_ IS NULL THEN StartDate_ ELSE DATEADD(mi,1,MaxStartDate_ ) END,AccountID_ , CASE WHEN CustomerID_ <= 0 THEN custid_ ELSE CustomerID_ END,RateRuleID_ ,RateID_ ,TotalTime_ , NULL,TotalCount_ ,TotalData_ ,TotalCost_ );
END IF;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE RateClassDataLeft (crRateClassDataLeft1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER) AS
BEGIN

OPEN crRateClassDataLeft1 FOR SELECT	MIN(sa.DataLeft) - (COALESCE(SUM(sp.AcctInputOctets),0) + COALESCE(SUM(sp.AcctOutputOctets),0)) AS DataLeft,
	MIN(sa.TimeLeft) - COALESCE(SUM(DATEDIFF(mi,sp.CallDate,DATEADD(ss,sp.AcctSessionTime,sysdate))),0) AS TimeLeft

FROM SubAccounts sa LEFT JOIN ServerPorts sp ON (sp.AcctStatusType = 1 AND sp.AccountID =AccountID_)
	WHERE sa.AccountID =AccountID_;
END;
/

CREATE OR REPLACE PROCEDURE ReportChurn (crReportChurn1 IN OUT ieatypes.CursorType,sd_ IN DATE,ed_ IN DATE,OrganizationID_ IN INTEGER,GroupID_ IN INTEGER) AS
BEGIN
DECLARE
counter_ INTEGER;
starting_ DATE;
ending_ DATE;
monthcount_ INTEGER;
isd_ DATE;
ied_ DATE;
BEGIN

SELECT 1,COALESCE(sd_,DATEADD(mm,-12,sysdate)),COALESCE(ed_,sysdate) INTO counter_,isd_,ied_ 

 FROM DUAL;
SELECT DATEADD(ss,-((DATEPART(hh,ied_ )*3600)+(DATEPART(mi,ied_ )*60) + DATEPART(ss,ied_ )),DATEADD(dd,-DATEPART(dd,ied_ ) + 1,ied_ )) INTO starting_ 

 FROM DUAL;
SELECT DATEDIFF(mm,isd_ ,ied_ ) INTO monthcount_ 


 FROM DUAL;

WHILE(counter_ <=monthcount_) LOOP

SELECT starting_ INTO ending_ 

 FROM DUAL;
SELECT DATEADD(mm,-1,starting_ ),counter_ + 1 INTO starting_,counter_ 


 FROM DUAL;
INSERT INTO rcsadiff (CustomerID, AccountID, PackageID, SA, SAPrev, InvoicedAmount)
SELECT ma.CustomerID, sa.AccountID, p.PackageID,
MAX(CASE WHEN starting_ BETWEEN ii.StartDate AND ii.EndDate AND ii.Amount > 0 AND ii.Quantity > 0 THEN 1 ELSE 0 END) AS SA,
MAX(CASE WHEN DATEADD(mm,-1,starting_ ) BETWEEN ii.StartDate AND ii.EndDate AND ii.Amount > 0 AND ii.Quantity > 0 THEN 1 ELSE 0 END) AS SAPrev,
SUM(CASE WHEN i.CreateDate BETWEEN starting_ AND ending_ THEN ROUND(ii.Amount * ii.Quantity,2) ELSE 0 END) AS InvoicedAmount

FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID)
	LEFT JOIN Packages p ON (ii.PackageID = p.PackageID)
	WHERE i.VoidDate IS NULL
	AND ii.ItemType = 3
	AND (GroupID_ IS NULL OR GroupID_ = ma.GroupID)
	AND (OrganizationID_ IS NULL OR OrganizationID_ = g.OrganizationID)
	AND ii.StartDate <> ii.EndDate
	AND i.CreateDate > DATEADD(yy,-3,starting_ )
GROUP BY ma.CustomerID, sa.AccountID, p.PackageID;
INSERT INTO rcmbrdiff (CustomerID, MBRTotal, MBRNew, MBRLost, SATotal, SANew, SALost, InvoicedAmount)
SELECT CustomerID,
MAX(SA) AS MBRTotal,
CASE WHEN MAX(SAPrev) = 0 AND MAX(SA) = 1 THEN 1 ELSE 0 END AS MBRNew,
CASE WHEN MAX(SAPrev) = 1 AND MAX(SA) = 0 THEN 1 ELSE 0 END AS MBRLost,
SUM(SA) AS SATotal,
SUM(CASE WHEN SAPrev = 0 AND SA = 1 THEN 1 ELSE 0 END) AS SANew,
SUM(CASE WHEN SAPrev = 1 AND SA = 0 THEN 1 ELSE 0 END) AS SALost,
SUM(InvoicedAmount) AS InvoicedAmount
FROM rcsadiff
GROUP BY CustomerID;
INSERT INTO rcdiff (StartDate, MBRTotal, MBRNew, MBRLost, SATotal, SANew, SALost, InvoicedAmount)
SELECT starting_, SUM(MBRTotal), SUM(MBRNew), SUM(MBRLost), SUM(SATotal), SUM(SANew), SUM(SALost), SUM(InvoicedAmount)
FROM rcmbrdiff;
DELETE FROM rcsadiff;
DELETE FROM rcmbrdiff;
END LOOP;

OPEN crReportChurn1 FOR SELECT DATEPART(yy,d1.StartDate) AS CYear, DATEPART(mm,d1.StartDate) AS CMonth, d1.StartDate, 
d1.MBRNew AS MAdd, d1.MBRLost AS MLost, d1.MBRTotal AS MCount,
d1.SANew AS SAdd, d1.SALost AS SLost, d1.SATotal AS SCount,
d1.InvoicedAmount AS InvAmt,

COALESCE((SELECT SUM(pi1.Amount) 
	FROM PaymentItems pi1, InvoiceItems ii, Invoices i, MasterAccounts ma, Groups g
	WHERE pi1.ActiveDate BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND (pi1.InactiveDate IS NULL OR pi1.InactiveDate NOT BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate))
	AND pi1.ItemID = ii.ItemID
	AND ii.ItemType = 3
	AND ii.StartDate <> ii.EndDate
	AND ii.InvoiceID = i.InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND (GroupID_ IS NULL OR GroupID_ = ma.GroupID)
	AND (OrganizationID_ IS NULL OR OrganizationID_ = g.OrganizationID)
	),0) + 
COALESCE((SELECT -(SUM(pi1.Amount)) 
	FROM PaymentItems pi1, InvoiceItems ii, Invoices i, MasterAccounts ma, Groups g
	WHERE pi1.ActiveDate NOT BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND pi1.InactiveDate BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND pi1.InactiveDate IS NOT NULL
	AND pi1.ItemID = ii.ItemID
	AND ii.ItemType = 3
	AND ii.StartDate <> ii.EndDate
	AND ii.InvoiceID = i.InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND (GroupID_ IS NULL OR GroupID_ = ma.GroupID)
	AND (OrganizationID_ IS NULL OR OrganizationID_ = g.OrganizationID)
	),0) AS PayAmt

FROM rcdiff d1
ORDER BY 1,2;
DELETE FROM rcmbrdiff;
DELETE FROM rcsadiff;
DELETE FROM rcdiff;
END;
END;
/

CREATE OR REPLACE PROCEDURE ReportChurnService (crReportChurnService1 IN OUT ieatypes.CursorType,sd_ IN DATE,ed_ IN DATE,OrganizationID_ IN INTEGER,GroupID_ IN INTEGER) AS
BEGIN
DECLARE
counter_ INTEGER;
starting_ DATE;
ending_ DATE;
monthcount_ INTEGER;
isd_ DATE;
ied_ DATE;
BEGIN

SELECT 1,COALESCE(sd_,DATEADD(mm,-12,sysdate)),COALESCE(ed_,sysdate) INTO counter_,isd_,ied_ 

 FROM DUAL;
SELECT DATEADD(ss,-((DATEPART(hh,ied_ )*3600)+(DATEPART(mi,ied_ )*60) + DATEPART(ss,ied_ )),DATEADD(dd,-DATEPART(dd,ied_ ) + 1,ied_ )) INTO starting_ 

 FROM DUAL;
SELECT DATEDIFF(mm,isd_ ,ied_ ) INTO monthcount_ 


 FROM DUAL;

WHILE(counter_ <=monthcount_) LOOP

SELECT starting_ INTO ending_ 

 FROM DUAL;
SELECT DATEADD(mm,-1,starting_ ),counter_ + 1 INTO starting_,counter_ 


 FROM DUAL;
INSERT INTO rcatsadiff (CustomerID, AccountID, PackageID, AccountTypeID, PackageTypeID, SA, SAPrev, InvoicedAmount)
SELECT ma.CustomerID, sa.AccountID, p.PackageID, ii.AccountTypeID, ii.PackageTypeID,
MAX(CASE WHEN starting_ BETWEEN ii.StartDate AND ii.EndDate AND ii.Amount > 0 AND ii.Quantity > 0 THEN 1 ELSE 0 END) AS SA,
MAX(CASE WHEN DATEADD(mm,-1,starting_ ) BETWEEN ii.StartDate AND ii.EndDate AND ii.Amount > 0 AND ii.Quantity > 0 THEN 1 ELSE 0 END) AS SAPrev,
SUM(CASE WHEN i.CreateDate BETWEEN starting_ AND ending_ THEN ROUND(ii.Amount * ii.Quantity,2) ELSE 0 END) AS InvoicedAmount

FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID)
	LEFT JOIN Packages p ON (ii.PackageID = p.PackageID)
	WHERE i.VoidDate IS NULL
	AND ii.ItemType = 3
	AND (ii.AccountID IS NOT NULL OR ii.PackageID IS NOT NULL)
	AND (GroupID_ IS NULL OR GroupID_ = ma.GroupID)
	AND (OrganizationID_ IS NULL OR OrganizationID_ = g.OrganizationID)
	AND ii.StartDate <> ii.EndDate
	AND i.CreateDate > DATEADD(yy,-3,starting_ )
GROUP BY ma.CustomerID, sa.AccountID, p.PackageID, ii.AccountTypeID, ii.PackageTypeID;
INSERT INTO rcatmbrdiff (CustomerID, AccountTypeID, PackageTypeID, MBRTotal, MBRNew, MBRLost, SATotal, SANew, SALost, InvoicedAmount)
SELECT CustomerID, AccountTypeID, PackageTypeID,
MAX(SA) AS MBRTotal,
CASE WHEN MAX(SAPrev) = 0 AND MAX(SA) = 1 THEN 1 ELSE 0 END AS MBRNew,
CASE WHEN MAX(SAPrev) = 1 AND MAX(SA) = 0 THEN 1 ELSE 0 END AS MBRLost,
SUM(SA) AS SATotal,
SUM(CASE WHEN SAPrev = 0 AND SA = 1 THEN 1 ELSE 0 END) AS SANew,
SUM(CASE WHEN SAPrev = 1 AND SA = 0 THEN 1 ELSE 0 END) AS SALost,
SUM(InvoicedAmount) AS InvoicedAmount
FROM rcatsadiff
GROUP BY CustomerID, AccountTypeID, PackageTypeID;
INSERT INTO rcatdiff (StartDate, AccountTypeID, PackageTypeID, MBRTotal, MBRNew, MBRLost, SATotal, SANew, SALost, InvoicedAmount)
SELECT starting_, AccountTypeID, PackageTypeID, SUM(MBRTotal), SUM(MBRNew), SUM(MBRLost), SUM(SATotal), SUM(SANew), SUM(SALost), SUM(InvoicedAmount)
FROM rcatmbrdiff
GROUP BY AccountTypeID, PackageTypeID;
DELETE FROM rcatsadiff;
DELETE FROM rcatmbrdiff;
END LOOP;


OPEN crReportChurnService1 FOR SELECT DATEPART(yy,d1.StartDate) AS CYear, DATEPART(mm,d1.StartDate) AS CMonth, d1.AccountTypeID, d1.PackageTypeID, CAST(COALESCE(d1.AccountTypeID,0) AS VARCHAR(32)) || 'z' || CAST(COALESCE(d1.PackageTypeID,0) AS VARCHAR(32)) AS groupref, COALESCE(at1.AccountType,pt.PackageType) AS groupdescr, COALESCE(at1.StringID,pt.StringID) AS groupstringid, at1.AccountType, at1.StringID AS ATStringID, pt.PackageType, pt.StringID AS PTStringID, d1.StartDate, 
d1.MBRNew AS MAdd, d1.MBRLost AS MLost, d1.MBRTotal AS MCount,
d1.SANew AS SAdd, d1.SALost AS SLost, d1.SATotal AS SCount,
d1.InvoicedAmount AS InvAmt,

COALESCE((SELECT SUM(pi1.Amount) 
	FROM PaymentItems pi1, InvoiceItems ii, Invoices i, MasterAccounts ma, Groups g
	WHERE pi1.ActiveDate BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND (pi1.InactiveDate IS NULL OR pi1.InactiveDate NOT BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate))
	AND pi1.ItemID = ii.ItemID
	AND ii.ItemType = 3
	AND d1.AccountTypeID = ii.AccountTypeID
	AND ii.StartDate <> ii.EndDate
	AND ii.InvoiceID = i.InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND (GroupID_ IS NULL OR GroupID_ = ma.GroupID)
	AND (OrganizationID_ IS NULL OR OrganizationID_ = g.OrganizationID)
	),0) +

COALESCE((SELECT SUM(pi1.Amount) 
	FROM PaymentItems pi1, InvoiceItems ii, Invoices i, MasterAccounts ma, Groups g
	WHERE pi1.ActiveDate BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND (pi1.InactiveDate IS NULL OR pi1.InactiveDate NOT BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate))
	AND pi1.ItemID = ii.ItemID
	AND ii.ItemType = 3
	AND d1.PackageTypeID = ii.PackageTypeID
	AND ii.StartDate <> ii.EndDate
	AND ii.InvoiceID = i.InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND (GroupID_ IS NULL OR GroupID_ = ma.GroupID)
	AND (OrganizationID_ IS NULL OR OrganizationID_ = g.OrganizationID)
	),0) +
 
COALESCE((SELECT -(SUM(pi1.Amount)) 
	FROM PaymentItems pi1, InvoiceItems ii, Invoices i, MasterAccounts ma, Groups g
	WHERE pi1.ActiveDate NOT BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND pi1.InactiveDate BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND pi1.InactiveDate IS NOT NULL
	AND pi1.ItemID = ii.ItemID
	AND ii.ItemType = 3
	AND d1.AccountTypeID = ii.AccountTypeID
	AND ii.StartDate <> ii.EndDate
	AND ii.InvoiceID = i.InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND (GroupID_ IS NULL OR GroupID_ = ma.GroupID)
	AND (OrganizationID_ IS NULL OR OrganizationID_ = g.OrganizationID)
	),0) +
 
COALESCE((SELECT -(SUM(pi1.Amount)) 
	FROM PaymentItems pi1, InvoiceItems ii, Invoices i, MasterAccounts ma, Groups g
	WHERE pi1.ActiveDate NOT BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND pi1.InactiveDate BETWEEN d1.StartDate AND DATEADD(mm,1,d1.StartDate)
	AND pi1.InactiveDate IS NOT NULL
	AND pi1.ItemID = ii.ItemID
	AND ii.ItemType = 3
	AND d1.PackageTypeID = ii.PackageTypeID
	AND ii.StartDate <> ii.EndDate
	AND ii.InvoiceID = i.InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND (GroupID_ IS NULL OR GroupID_ = ma.GroupID)
	AND (OrganizationID_ IS NULL OR OrganizationID_ = g.OrganizationID)
	),0) AS PayAmt

FROM rcatdiff d1
	LEFT JOIN AccountTypes at1 ON (d1.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN PackageTypes pt ON (d1.PackageTypeID = pt.PackageTypeID)
ORDER BY 3,4,1,2;
DELETE FROM rcatmbrdiff;
DELETE FROM rcatsadiff;
DELETE FROM rcatdiff;
END;
END;
/

CREATE OR REPLACE PROCEDURE ReportChurnServiceDetail (crReportChurnServiceDetail1 IN OUT ieatypes.CursorType,sd_ IN DATE,ed_ IN DATE,OrganizationID_ IN INTEGER,GroupID_ IN INTEGER,AccountTypeID_ IN INTEGER,PackageTypeID_ IN INTEGER) AS
BEGIN
DECLARE
counter_ INTEGER;
starting_ DATE;
ending_ DATE;
monthcount_ INTEGER;
isd_ DATE;
ied_ DATE;
BEGIN

SELECT 1,COALESCE(sd_,DATEADD(mm,-12,sysdate)),COALESCE(ed_,sysdate) INTO counter_,isd_,ied_ 

 FROM DUAL;
SELECT DATEADD(ss,-((DATEPART(hh,ied_ )*3600)+(DATEPART(mi,ied_ )*60) + DATEPART(ss,ied_ )),DATEADD(dd,-DATEPART(dd,ied_ ) + 1,ied_ )) INTO starting_ 

 FROM DUAL;
SELECT DATEDIFF(mm,isd_ ,ied_ ) INTO monthcount_ 


 FROM DUAL;
WHILE(counter_ <=monthcount_) LOOP

SELECT starting_ INTO ending_ 

 FROM DUAL;
SELECT DATEADD(mm,-1,starting_ ),counter_ + 1 INTO starting_,counter_ 


 FROM DUAL;
INSERT INTO rcatdsadiff (CustomerID, AccountID, PackageID, AccountTypeID, PackageTypeID, SA, SAPrev, InvoicedAmount)
SELECT ma.CustomerID, sa.AccountID, p.PackageID, ii.AccountTypeID, ii.PackageTypeID,
MAX(CASE WHEN starting_ BETWEEN ii.StartDate AND ii.EndDate AND ii.Amount > 0 AND ii.Quantity > 0 THEN 1 ELSE 0 END) AS SA,
MAX(CASE WHEN DATEADD(mm,-1,starting_ ) BETWEEN ii.StartDate AND ii.EndDate AND ii.Amount > 0 AND ii.Quantity > 0 THEN 1 ELSE 0 END) AS SAPrev,
SUM(CASE WHEN i.CreateDate BETWEEN starting_ AND ending_ THEN ROUND(ii.Amount * ii.Quantity,2) ELSE 0 END) AS InvoicedAmount

FROM MasterAccounts ma JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN SubAccounts sa ON (ii.AccountID = sa.AccountID)
	LEFT JOIN Packages p ON (ii.PackageID = p.PackageID)
	WHERE i.VoidDate IS NULL
	AND ii.ItemType = 3
	AND (ii.AccountID IS NOT NULL OR ii.PackageID IS NOT NULL)
	AND (GroupID_ IS NULL OR GroupID_ = ma.GroupID)
	AND (OrganizationID_ IS NULL OR OrganizationID_ = g.OrganizationID)
	AND ii.StartDate <> ii.EndDate
	AND i.CreateDate > DATEADD(yy,-3,starting_ )
	AND (AccountTypeID_ IS NULL OR AccountTypeID_ = ii.AccountTypeID)
	AND (PackageTypeID_ IS NULL OR PackageTypeID_ = ii.PackageTypeID)
GROUP BY ma.CustomerID, sa.AccountID, p.PackageID, ii.AccountTypeID, ii.PackageTypeID;
INSERT INTO rcatdmbrdiff (CustomerID, AccountTypeID, PackageTypeID, MBRNew, MBRLost)
SELECT CustomerID, AccountTypeID, PackageTypeID,
CASE WHEN MAX(SAPrev) = 0 AND MAX(SA) = 1 THEN 1 ELSE 0 END AS MBRNew,
CASE WHEN MAX(SAPrev) = 1 AND MAX(SA) = 0 THEN 1 ELSE 0 END AS MBRLost
FROM rcatdsadiff
GROUP BY CustomerID, AccountTypeID, PackageTypeID;
INSERT INTO rcatddiff (StartDate, CustomerID, AccountID, PackageID, AccountTypeID, PackageTypeID, MBRNew, MBRLost, SANew, SALost, InvoicedAmount)
SELECT starting_, rsa.CustomerID, rsa.AccountID, rsa.PackageID, rsa.AccountTypeID, rsa.PackageTypeID, 
MAX(rma.MBRNew), MAX(rma.MBRLost), 

MAX(CASE WHEN rsa.SAPrev = 0 AND rsa.SA = 1 THEN 1 ELSE 0 END) AS SANew, 
MAX(CASE WHEN rsa.SAPrev = 1 AND rsa.SA = 0 THEN 1 ELSE 0 END) AS SALost,
SUM(rsa.InvoicedAmount) AS InvoicedAmount

FROM rcatdsadiff rsa,rcatdmbrdiff rma
	WHERE rsa.CustomerID = rma.CustomerID

GROUP BY rsa.CustomerID, rsa.AccountID, rsa.PackageID, rsa.AccountTypeID, rsa.PackageTypeID;
DELETE FROM rcatdsadiff;
DELETE FROM rcatdmbrdiff;
END LOOP;

OPEN crReportChurnServiceDetail1 FOR SELECT DATEPART(yy,d1.StartDate) AS CYear, DATEPART(mm,d1.StartDate) AS CMonth, d1.AccountTypeID, d1.PackageTypeID, CAST(COALESCE(d1.AccountTypeID,0) AS VARCHAR(32)) || 'z' || CAST(COALESCE(d1.PackageTypeID,0) AS VARCHAR(32)) AS groupref, COALESCE(at1.AccountType,pt.PackageType) AS groupdescr, COALESCE(at1.StringID,pt.StringID) AS groupstringid, at1.AccountType, at1.StringID AS ATStringID, pt.PackageType, pt.StringID AS PTStringID, d1.StartDate, 
d1.MBRNew AS MAdd, d1.MBRLost AS MLost,
d1.SANew AS SAdd, d1.SALost AS SLost,
d1.InvoicedAmount AS InvAmt, d1.CustomerID, d1.AccountID, d1.PackageID, COALESCE(dsa.FirstName,dma.FirstName) AS FirstName, COALESCE(dsa.LastName,dma.LastName) AS LastName, dma.Company, dsa.Login

FROM rcatddiff d1 JOIN MasterAccounts dma ON (d1.CustomerID = dma.CustomerID)
	LEFT JOIN SubAccounts dsa ON (d1.AccountID = dsa.AccountID)
	LEFT JOIN AccountTypes at1 ON (d1.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN PackageTypes pt ON (d1.PackageTypeID = pt.PackageTypeID)
	WHERE (d1.SANew > 0 OR d1.SALost > 0)
ORDER BY 3,4,1,2,15,16,18,19;
DELETE FROM rcatdmbrdiff;
DELETE FROM rcatdsadiff;
DELETE FROM rcatddiff;
END;
END;
/

CREATE OR REPLACE PROCEDURE ReportCommission (crReportCommission1 IN OUT ieatypes.CursorType,OrganizationID_ IN INTEGER,GroupID_ IN INTEGER,SalesPersonID_ IN INTEGER,StartDate_ IN DATE,EndDate_ IN DATE) AS
BEGIN


INSERT INTO rcpayp (SalesPersonID, AccountTypeID, PackageTypeID, ChargeTypeID, PaidAmount, PaidPoints)
SELECT sp.SalesPersonID, ci.AccountTypeID,ci.PackageTypeID,ci.ChargeTypeID, SUM(pi1.Amount) AS PaidAmount, 
SUM(ROUND(CASE WHEN cg.CommissionType = 1 THEN CASE WHEN ii.Days > 0 THEN ii.Days / 30.0 * pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue ELSE pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue * ii.Quantity END
WHEN cg.CommissionType = 2 THEN pi1.Amount * (ci.CommissionValue/100.0) ELSE 0 END,2)) AS PaidPoints

FROM MasterAccounts ma
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID)
	JOIN SalesPersons sp ON ( (ii.AccountID IS NULL AND ii.PackageID IS NULL AND ma.SalesPersonID = sp.SalesPersonID) 
		OR (ii.AccountID IS NOT NULL AND ii.PackageID IS NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM SubAccounts sa WHERE sa.AccountID = ii.AccountID)) 
		OR (ii.PackageID IS NOT NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM Packages p WHERE p.PackageID = ii.PackageID)) )
	JOIN CommissionGroups cg ON (sp.CommissionGroupID = cg.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = ci.CommissionGroupID)

	WHERE pi1.Amount > 0
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ((ci.AccountTypeID = ii.AccountTypeID AND ci.AccountTypeID IS NOT NULL) OR (ci.PackageTypeID = ii.PackageTypeID AND ci.PackageTypeID IS NOT NULL) OR (ci.ChargeTypeID = ii.ChargeTypeID AND ci.ChargeTypeID IS NOT NULL))
	AND pi1.ActiveDate BETWEEN StartDate_ AND EndDate_
	AND (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (SalesPersonID_ IS NULL OR sp.SalesPersonID =SalesPersonID_)
GROUP BY sp.SalesPersonID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID;
INSERT INTO rcpaym (SalesPersonID, AccountTypeID, PackageTypeID, ChargeTypeID, PaidAmount, PaidPoints)
SELECT sp.SalesPersonID, ci.AccountTypeID,ci.PackageTypeID,ci.ChargeTypeID, -(SUM(pi1.Amount)) AS PaidAmount,
-(SUM(ROUND(CASE WHEN cg.CommissionType = 1 THEN CASE WHEN ii.Days > 0 THEN ii.Days / 30.0 * pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue ELSE pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue * ii.Quantity END
WHEN cg.CommissionType = 2 THEN pi1.Amount * (ci.CommissionValue/100.0) ELSE 0 END,2))) AS PaidPoints

FROM MasterAccounts ma
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID)
	JOIN SalesPersons sp ON ( (ii.AccountID IS NULL AND ii.PackageID IS NULL AND ma.SalesPersonID = sp.SalesPersonID) 
		OR (ii.AccountID IS NOT NULL AND ii.PackageID IS NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM SubAccounts sa WHERE sa.AccountID = ii.AccountID)) 
		OR (ii.PackageID IS NOT NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM Packages p WHERE p.PackageID = ii.PackageID)) )
	JOIN CommissionGroups cg ON (sp.CommissionGroupID = cg.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = ci.CommissionGroupID)

	WHERE pi1.Amount > 0
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ((ci.AccountTypeID = ii.AccountTypeID AND ci.AccountTypeID IS NOT NULL) OR (ci.PackageTypeID = ii.PackageTypeID AND ci.PackageTypeID IS NOT NULL) OR (ci.ChargeTypeID = ii.ChargeTypeID AND ci.ChargeTypeID IS NOT NULL))
	AND pi1.InactiveDate BETWEEN StartDate_ AND EndDate_
	AND (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (SalesPersonID_ IS NULL OR sp.SalesPersonID =SalesPersonID_)
GROUP BY sp.SalesPersonID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID;
INSERT INTO rcinv (SalesPersonID, AccountTypeID, PackageTypeID, ChargeTypeID, ItemCount, InvoicedAmount, InvoicedPoints)
SELECT sp.SalesPersonID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID, COUNT(*) AS ItemCount,
SUM(ROUND(ii.Amount * ii.Quantity,2)) AS InvoicedAmount, 
COALESCE(MIN(sp.CommissionValue),1.0000) * SUM(CASE WHEN cg.CommissionType = 1 AND ii.Days <> 0 THEN (ci.CommissionValue * ii.Quantity) / 30
	WHEN cg.CommissionType = 1 AND ii.Days = 0 THEN ci.CommissionValue * ii.Quantity
	WHEN cg.CommissionType = 2 THEN (ROUND(ii.Amount * ii.Quantity,2)) * (ci.CommissionValue/100) END) AS InvoicedPoints

FROM MasterAccounts ma
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID AND i.VoidDate IS NULL)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN SalesPersons sp ON ( (ii.AccountID IS NULL AND ii.PackageID IS NULL AND ma.SalesPersonID = sp.SalesPersonID) 
		OR (ii.AccountID IS NOT NULL AND ii.PackageID IS NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM SubAccounts sa WHERE sa.AccountID = ii.AccountID)) 
		OR (ii.PackageID IS NOT NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM Packages p WHERE p.PackageID = ii.PackageID)) )
	JOIN CommissionGroups cg ON (sp.CommissionGroupID = cg.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = ci.CommissionGroupID)

	WHERE ii.Amount > 0
	AND ii.Quantity > 0
	AND i.Estimate = 0
	AND ((ci.AccountTypeID = ii.AccountTypeID AND ci.AccountTypeID IS NOT NULL) OR (ci.PackageTypeID = ii.PackageTypeID AND ci.PackageTypeID IS NOT NULL) OR (ci.ChargeTypeID = ii.ChargeTypeID AND ci.ChargeTypeID IS NOT NULL))
	AND (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (SalesPersonID_ IS NULL OR sp.SalesPersonID =SalesPersonID_)
	AND (StartDate_ IS NULL OR i.CreateDate >=StartDate_)
	AND (EndDate_ IS NULL OR i.CreateDate <=EndDate_)
GROUP BY sp.SalesPersonID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID;
INSERT INTO rcommtmp (Type, SalesPerson, Item, StringID, ItemCount, InvoicedAmount, InvoicedPoints, PaidAmount, PaidPoints)
SELECT DISTINCT CASE WHEN ci.AccountTypeID IS NOT NULL THEN 1 WHEN ci.PackageTypeID IS NOT NULL THEN 2 WHEN ci.ChargeTypeID IS NOT NULL THEN 3 END AS Type,
sp.SalesPerson, COALESCE(at1.AccountType,pt1.PackageType,ct.Description) AS Item, COALESCE(at1.StringID,pt1.StringID,ct.StringID) AS StringID,
COALESCE(ri.ItemCount,0) AS ItemCount, COALESCE(ri.InvoicedAmount,0) AS InvoicedAmount, COALESCE(ri.InvoicedPoints,0) AS InvoicedPoints,
COALESCE(rp.PaidAmount,0) + COALESCE(rm.PaidAmount,0) AS PaidAmount, 
COALESCE(rp.PaidPoints,0) + COALESCE(rm.PaidPoints,0) AS PaidPoints

FROM SalesPersons sp JOIN CommissionGroups cg ON (cg.CommissionGroupID = sp.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = sp.CommissionGroupID)
	LEFT JOIN rcpayp rp ON (rp.SalesPersonID = sp.SalesPersonID AND (ci.AccountTypeID = rp.AccountTypeID OR ci.PackageTypeID = rp.PackageTypeID OR ci.ChargeTypeID = rp.ChargeTypeID))
	LEFT JOIN rcpaym rm ON (rm.SalesPersonID = sp.SalesPersonID AND (ci.AccountTypeID = rm.AccountTypeID OR ci.PackageTypeID = rm.PackageTypeID OR ci.ChargeTypeID = rm.ChargeTypeID))
	LEFT JOIN rcinv ri ON (ri.SalesPersonID = sp.SalesPersonID AND (ci.AccountTypeID = ri.AccountTypeID OR ci.PackageTypeID = ri.PackageTypeID OR ci.ChargeTypeID = ri.ChargeTypeID))
	LEFT JOIN AccountTypes at1 ON (ci.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN PackageTypes pt1 ON (ci.PackageTypeID = pt1.PackageTypeID)
	LEFT JOIN ChargeTypes ct ON (ci.ChargeTypeID = ct.ChargeTypeID)
	WHERE (SalesPersonID_ IS NULL OR sp.SalesPersonID =SalesPersonID_)
	AND (rp.SalesPersonID IS NOT NULL OR rm.SalesPersonID IS NOT NULL OR ri.SalesPersonID IS NOT NULL);
INSERT INTO rcommtmp (Type,SalesPerson,ItemCount,InvoicedAmount,InvoicedPoints,PaidAmount,PaidPoints)
SELECT 4, SalesPerson, SUM(ItemCount), SUM(InvoicedAmount), SUM(InvoicedPoints), SUM(PaidAmount), SUM(PaidPoints)
FROM rcommtmp 
GROUP BY SalesPerson;
OPEN crReportCommission1 FOR SELECT * 
FROM rcommtmp
ORDER BY SalesPerson, Type, Item;
DELETE FROM rcommtmp;
DELETE FROM rcpayp;
DELETE FROM rcpaym;
DELETE FROM rcinv;
END;
/

CREATE OR REPLACE PROCEDURE ReportCommissionDetail (crReportCommissionDetail1 IN OUT ieatypes.CursorType,OrganizationID_ IN INTEGER,GroupID_ IN INTEGER,SalesPersonID_ IN INTEGER,StartDate_ IN DATE,EndDate_ IN DATE) AS
BEGIN


INSERT INTO rcdpayp (SalesPersonID, CustomerID,AccountTypeID, PackageTypeID, ChargeTypeID, PaidAmount, PaidPoints)
SELECT sp.SalesPersonID, ma.CustomerID, ci.AccountTypeID,ci.PackageTypeID,ci.ChargeTypeID, SUM(pi1.Amount) AS PaidAmount, 
SUM(ROUND(CASE WHEN cg.CommissionType = 1 THEN CASE WHEN ii.Days > 0 THEN ii.Days / 30.0 * pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue ELSE pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue * ii.Quantity END
WHEN cg.CommissionType = 2 THEN pi1.Amount * (ci.CommissionValue/100.0) ELSE 0 END,2)) AS PaidPoints

FROM MasterAccounts ma
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID)
	JOIN SalesPersons sp ON ( (ii.AccountID IS NULL AND ii.PackageID IS NULL AND ma.SalesPersonID = sp.SalesPersonID) 
		OR (ii.AccountID IS NOT NULL AND ii.PackageID IS NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM SubAccounts sa WHERE sa.AccountID = ii.AccountID)) 
		OR (ii.PackageID IS NOT NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM Packages p WHERE p.PackageID = ii.PackageID)) )
	JOIN CommissionGroups cg ON (sp.CommissionGroupID = cg.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = ci.CommissionGroupID)

	WHERE pi1.Amount > 0
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ((ci.AccountTypeID = ii.AccountTypeID AND ci.AccountTypeID IS NOT NULL) OR (ci.PackageTypeID = ii.PackageTypeID AND ci.PackageTypeID IS NOT NULL) OR (ci.ChargeTypeID = ii.ChargeTypeID AND ci.ChargeTypeID IS NOT NULL))
	AND pi1.ActiveDate BETWEEN StartDate_ AND EndDate_
	AND (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (SalesPersonID_ IS NULL OR sp.SalesPersonID =SalesPersonID_)
GROUP BY sp.SalesPersonID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID, ma.CustomerID;
INSERT INTO rcdpaym (SalesPersonID, CustomerID, AccountTypeID, PackageTypeID, ChargeTypeID, PaidAmount, PaidPoints)
SELECT sp.SalesPersonID, ma.CustomerID, ci.AccountTypeID,ci.PackageTypeID,ci.ChargeTypeID, -(SUM(pi1.Amount)) AS PaidAmount,
-(SUM(ROUND(CASE WHEN cg.CommissionType = 1 THEN CASE WHEN ii.Days > 0 THEN ii.Days / 30.0 * pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue ELSE pi1.Amount / ROUND(ii.Amount * ii.Quantity,2) * ci.CommissionValue * ii.Quantity END
WHEN cg.CommissionType = 2 THEN pi1.Amount * (ci.CommissionValue/100.0) ELSE 0 END,2))) AS PaidPoints

FROM MasterAccounts ma
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID)
	JOIN SalesPersons sp ON ( (ii.AccountID IS NULL AND ii.PackageID IS NULL AND ma.SalesPersonID = sp.SalesPersonID) 
		OR (ii.AccountID IS NOT NULL AND ii.PackageID IS NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM SubAccounts sa WHERE sa.AccountID = ii.AccountID)) 
		OR (ii.PackageID IS NOT NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM Packages p WHERE p.PackageID = ii.PackageID)) )
	JOIN CommissionGroups cg ON (sp.CommissionGroupID = cg.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = ci.CommissionGroupID)

	WHERE pi1.Amount > 0
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ((ci.AccountTypeID = ii.AccountTypeID AND ci.AccountTypeID IS NOT NULL) OR (ci.PackageTypeID = ii.PackageTypeID AND ci.PackageTypeID IS NOT NULL) OR (ci.ChargeTypeID = ii.ChargeTypeID AND ci.ChargeTypeID IS NOT NULL))
	AND pi1.InactiveDate BETWEEN StartDate_ AND EndDate_
	AND (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (SalesPersonID_ IS NULL OR sp.SalesPersonID =SalesPersonID_)
GROUP BY sp.SalesPersonID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID, ma.CustomerID;
INSERT INTO rcdinv (SalesPersonID, CustomerID, AccountTypeID, PackageTypeID, ChargeTypeID, ItemCount, InvoicedAmount, InvoicedPoints)
SELECT sp.SalesPersonID, ma.CustomerID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID, COUNT(*) AS ItemCount,
SUM(ROUND(ii.Amount * ii.Quantity,2)) AS InvoicedAmount, 
COALESCE(MIN(sp.CommissionValue),1.0000) * SUM(CASE WHEN cg.CommissionType = 1 AND ii.Days <> 0 THEN (ci.CommissionValue * ii.Quantity) / 30
	WHEN cg.CommissionType = 1 AND ii.Days = 0 THEN ci.CommissionValue * ii.Quantity
	WHEN cg.CommissionType = 2 THEN (ROUND(ii.Amount * ii.Quantity,2)) * (ci.CommissionValue/100) END) AS InvoicedPoints

FROM MasterAccounts ma
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID AND i.VoidDate IS NULL)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN SalesPersons sp ON ( (ii.AccountID IS NULL AND ii.PackageID IS NULL AND ma.SalesPersonID = sp.SalesPersonID) 
		OR (ii.AccountID IS NOT NULL AND ii.PackageID IS NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM SubAccounts sa WHERE sa.AccountID = ii.AccountID)) 
		OR (ii.PackageID IS NOT NULL AND sp.SalesPersonID IN (SELECT SalesPersonID FROM Packages p WHERE p.PackageID = ii.PackageID)) )
	JOIN CommissionGroups cg ON (sp.CommissionGroupID = cg.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = ci.CommissionGroupID)

	WHERE ii.Amount > 0
	AND ii.Quantity > 0
	AND i.Estimate = 0
	AND ((ci.AccountTypeID = ii.AccountTypeID AND ci.AccountTypeID IS NOT NULL) OR (ci.PackageTypeID = ii.PackageTypeID AND ci.PackageTypeID IS NOT NULL) OR (ci.ChargeTypeID = ii.ChargeTypeID AND ci.ChargeTypeID IS NOT NULL))
	AND (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (SalesPersonID_ IS NULL OR sp.SalesPersonID =SalesPersonID_)
	AND (StartDate_ IS NULL OR i.CreateDate >=StartDate_)
	AND (EndDate_ IS NULL OR i.CreateDate <=EndDate_)
GROUP BY sp.SalesPersonID, ci.AccountTypeID, ci.PackageTypeID, ci.ChargeTypeID, ma.CustomerID;
INSERT INTO rcdommtmp (Type, CustomerID, SalesPerson, Item, StringID, ItemCount, InvoicedAmount, InvoicedPoints, PaidAmount, PaidPoints)
SELECT DISTINCT CASE WHEN ci.AccountTypeID IS NOT NULL THEN 1 WHEN ci.PackageTypeID IS NOT NULL THEN 2 WHEN ci.ChargeTypeID IS NOT NULL THEN 3 END AS Type,
rp.CustomerID, sp.SalesPerson, COALESCE(at1.AccountType,pt1.PackageType,ct.Description) AS Item, COALESCE(at1.StringID,pt1.StringID,ct.StringID) AS StringID,
0 AS ItemCount, 0 AS InvoicedAmount, 0 AS InvoicedPoints, rp.PaidAmount, rp.PaidPoints
FROM SalesPersons sp JOIN CommissionGroups cg ON (cg.CommissionGroupID = sp.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = sp.CommissionGroupID)
	JOIN rcdpayp rp ON (rp.SalesPersonID = sp.SalesPersonID AND (ci.AccountTypeID = rp.AccountTypeID OR ci.PackageTypeID = rp.PackageTypeID OR ci.ChargeTypeID = rp.ChargeTypeID))
	LEFT JOIN AccountTypes at1 ON (ci.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN PackageTypes pt1 ON (ci.PackageTypeID = pt1.PackageTypeID)
	LEFT JOIN ChargeTypes ct ON (ci.ChargeTypeID = ct.ChargeTypeID)
	WHERE (SalesPersonID_ IS NULL OR sp.SalesPersonID =SalesPersonID_)
	AND rp.SalesPersonID IS NOT NULL

UNION ALL

SELECT DISTINCT CASE WHEN ci.AccountTypeID IS NOT NULL THEN 1 WHEN ci.PackageTypeID IS NOT NULL THEN 2 WHEN ci.ChargeTypeID IS NOT NULL THEN 3 END AS Type,
rm.CustomerID, sp.SalesPerson, COALESCE(at1.AccountType,pt1.PackageType,ct.Description) AS Item, COALESCE(at1.StringID,pt1.StringID,ct.StringID) AS StringID,
0 AS ItemCount, 0 AS InvoicedAmount, 0 AS InvoicedPoints, rm.PaidAmount, rm.PaidPoints
FROM SalesPersons sp JOIN CommissionGroups cg ON (cg.CommissionGroupID = sp.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = sp.CommissionGroupID)
	JOIN rcdpaym rm ON (rm.SalesPersonID = sp.SalesPersonID AND (ci.AccountTypeID = rm.AccountTypeID OR ci.PackageTypeID = rm.PackageTypeID OR ci.ChargeTypeID = rm.ChargeTypeID))
	LEFT JOIN AccountTypes at1 ON (ci.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN PackageTypes pt1 ON (ci.PackageTypeID = pt1.PackageTypeID)
	LEFT JOIN ChargeTypes ct ON (ci.ChargeTypeID = ct.ChargeTypeID)
	WHERE (SalesPersonID_ IS NULL OR sp.SalesPersonID =SalesPersonID_)
	AND rm.SalesPersonID IS NOT NULL

UNION ALL

SELECT DISTINCT CASE WHEN ci.AccountTypeID IS NOT NULL THEN 1 WHEN ci.PackageTypeID IS NOT NULL THEN 2 WHEN ci.ChargeTypeID IS NOT NULL THEN 3 END AS Type,
ri.CustomerID, sp.SalesPerson, COALESCE(at1.AccountType,pt1.PackageType,ct.Description) AS Item, COALESCE(at1.StringID,pt1.StringID,ct.StringID) AS StringID,
ri.ItemCount, ri.InvoicedAmount, ri.InvoicedPoints AS InvoicedPoints, 0 AS PaidAmount, 0 AS PaidPoints
FROM SalesPersons sp JOIN CommissionGroups cg ON (cg.CommissionGroupID = sp.CommissionGroupID)
	JOIN CommissionItems ci ON (cg.CommissionGroupID = sp.CommissionGroupID)
	JOIN rcdinv ri ON (ri.SalesPersonID = sp.SalesPersonID AND (ci.AccountTypeID = ri.AccountTypeID OR ci.PackageTypeID = ri.PackageTypeID OR ci.ChargeTypeID = ri.ChargeTypeID))
	LEFT JOIN AccountTypes at1 ON (ci.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN PackageTypes pt1 ON (ci.PackageTypeID = pt1.PackageTypeID)
	LEFT JOIN ChargeTypes ct ON (ci.ChargeTypeID = ct.ChargeTypeID)
	WHERE (SalesPersonID_ IS NULL OR sp.SalesPersonID =SalesPersonID_)
	AND ri.SalesPersonID IS NOT NULL;
OPEN crReportCommissionDetail1 FOR SELECT MIN(ma.FirstName) AS FirstName, MIN(ma.LastName) AS LastName, tmp.CustomerID, MIN(ma.Company) AS Company, tmp.Type, MIN(tmp.SalesPerson) AS SalesPerson, tmp.Item, MIN(tmp.StringID) AS StringID, SUM(tmp.ItemCount) AS ItemCount, SUM(tmp.InvoicedAmount) AS InvoicedAmount, SUM(tmp.InvoicedPoints) AS InvoicedPoints, SUM(tmp.PaidAmount) AS PaidAmount, SUM(tmp.PaidPoints) AS PaidPoints
FROM rcdommtmp tmp JOIN MasterAccounts ma ON (tmp.CustomerID = ma.CustomerID)
GROUP BY tmp.CustomerID, tmp.Type, tmp.Item

UNION ALL

SELECT NULL AS FirstName, NULL AS LastName, NULL AS CustomerID, NULL AS Company, 4 AS Type, SalesPerson, NULL AS Item, NULL AS StringID, SUM(ItemCount) AS ItemCount, SUM(InvoicedAmount) AS InvoicedAmount, SUM(InvoicedPoints) AS INvoicedPoints, SUM(PaidAmount) AS PaidAmount, SUM(PaidPoints) AS PaidPoints
FROM rcdommtmp
GROUP BY SalesPerson

ORDER BY 6, 5, 3, 7;
DELETE FROM rcdommtmp;
DELETE FROM rcdpayp;
DELETE FROM rcdpaym;
DELETE FROM rcdinv;
END;
/

CREATE OR REPLACE PROCEDURE ReportForecast (crReportForecast1 IN OUT ieatypes.CursorType,OrganizationID_ IN INTEGER,GroupID_ IN INTEGER,month_ IN DATE) AS
BEGIN
DECLARE
imonth_ DATE;
BEGIN

SELECT CASE WHEN month_ IS NULL THEN sysdate ELSE month_ END INTO imonth_ 

 FROM DUAL;
SELECT DATEADD(ss,-((DATEPART(hh,imonth_ )*3600)+(DATEPART(mi,imonth_ )*60) + DATEPART(ss,imonth_ )),DATEADD(dd,-DATEPART(dd,imonth_ ) + 1,imonth_ )) INTO imonth_ 


 FROM DUAL;

INSERT INTO fcast (Type,Description,StringID,Services,Cost)
SELECT 0 AS Type, MIN(at1.AccountType) AS Description, MIN(at1.StringID) AS StringID, COUNT(*) AS Services, 
SUM(CASE WHEN sa.DiffCost = 1 THEN sa.Cost * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END) ELSE (COALESCE(oat.CustomerCost,at1.Cost) * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END)) * CASE WHEN d.AmountType = 0 THEN (100 - d.Amount) / 100 ELSE 1 END + CASE WHEN d.AmountType = 1 THEN -(d.Amount) ELSE 0 END END) AS Cost

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Discounts d ON (sa.DiscountID = d.DiscountID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN OrgAccountTypes oat ON (g.OrganizationID = oat.OrganizationID AND at1.AccountTypeID = oat.AccountTypeID AND o.ResellerCustomerID IS NOT NULL)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sa.PackageID IS NULL
	AND (ma.CancelDate IS NULL OR ma.CancelDate > imonth_) 
	AND (sa.CancelDate IS NULL OR sa.CancelDate > imonth_) 
	AND (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (bc.AutoBill = 1 OR (bc.AutoBill = 0 AND DATEDIFF(mm,sa.ExpireDate,sysdate) <= 1))
AND MOD(DATEDIFF(mm,  DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),sa.BilledThru)  ,imonth_ ) ,pp.Period)= 0
GROUP BY at1.AccountTypeID

UNION ALL

SELECT 1 AS Type, MIN(pt.PackageType) AS Description, MIN(pt.StringID) AS StringID, COUNT(*) AS Services, 
SUM(CASE WHEN p.DiffCost = 1 THEN p.Cost * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END) ELSE (COALESCE(opt.CustomerCost,pt.Cost) * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END)) * CASE WHEN d.AmountType = 0 THEN (100 - d.Amount) / 100 ELSE 1 END + CASE WHEN d.AmountType = 1 THEN -(d.Amount) ELSE 0 END END) AS Cost

FROM MasterAccounts ma JOIN Packages p ON (ma.CustomerID = p.CustomerID)
	JOIN PayPeriods pp ON (p.PayPeriodID = pp.PayPeriodID)
	JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN Discounts d ON (p.DiscountID = d.DiscountID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN OrgPackageTypes opt ON (g.OrganizationID = opt.OrganizationID AND p.PackageTypeID = opt.PackageTypeID AND o.ResellerCustomerID IS NOT NULL)
	WHERE ma.Active = 1
	AND p.Active = 1
	AND EXISTS (SELECT * FROM SubAccounts sa WHERE sa.PackageID = p.PackageID AND sa.CustomerID = ma.CustomerID AND sa.Active = 1 AND (sa.CancelDate IS NULL OR sa.CancelDate > imonth_) )
	AND (ma.CancelDate IS NULL OR ma.CancelDate > imonth_) 
	AND (p.CancelDate IS NULL OR p.CancelDate > imonth_) 
	AND (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (bc.AutoBill = 1 OR (bc.AutoBill = 0 AND DATEDIFF(mm,p.ExpireDate,sysdate) <= 1))
AND MOD(DATEDIFF(mm,  DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),p.BilledThru)  ,imonth_ ) ,pp.Period)= 0
GROUP BY pt.PackageTypeID;
OPEN crReportForecast1 FOR SELECT Type,Description,StringID,Services,Cost 
FROM fcast
UNION ALL
SELECT 2,NULL,NULL,SUM(Services),SUM(Cost) 
FROM fcast;
DELETE FROM fcast;
END;
END;
/

CREATE OR REPLACE PROCEDURE ReportForecastDaily (crReportForecastDaily1 IN OUT ieatypes.CursorType,OrganizationID_ IN INTEGER,GroupID_ IN INTEGER,month_ IN DATE) AS
BEGIN
DECLARE
imonth_ DATE;
BEGIN

SELECT CASE WHEN month_ IS NULL THEN sysdate ELSE month_ END INTO imonth_ 

 FROM DUAL;
SELECT DATEADD(ss,-((DATEPART(hh,imonth_ )*3600)+(DATEPART(mi,imonth_ )*60) + DATEPART(ss,imonth_ )),DATEADD(dd,-DATEPART(dd,imonth_ ) + 1,imonth_ )) INTO imonth_ 


 FROM DUAL;

INSERT INTO fcastd (Day,Type,Description,StringID,Services,Cost)
SELECT DATEPART(dd,DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),sa.BilledThru)), 0 AS Type, MIN(at1.AccountType) AS Description, MIN(at1.StringID) AS StringID, COUNT(*) AS Services, 
SUM(CASE WHEN sa.DiffCost = 1 THEN sa.Cost * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END) ELSE (COALESCE(oat.CustomerCost,at1.Cost) * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END)) * CASE WHEN d.AmountType = 0 THEN (100 - d.Amount) / 100 ELSE 1 END + CASE WHEN d.AmountType = 1 THEN -(d.Amount) ELSE 0 END END) AS Cost

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Discounts d ON (sa.DiscountID = d.DiscountID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN OrgAccountTypes oat ON (g.OrganizationID = oat.OrganizationID AND at1.AccountTypeID = oat.AccountTypeID AND o.ResellerCustomerID IS NOT NULL)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND sa.PackageID IS NULL
	AND (ma.CancelDate IS NULL OR ma.CancelDate > imonth_) 
	AND (sa.CancelDate IS NULL OR sa.CancelDate > imonth_) 
	AND (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (bc.AutoBill = 1 OR (bc.AutoBill = 0 AND DATEDIFF(mm,sa.ExpireDate,sysdate) <= 1))
AND MOD(DATEDIFF(mm,  DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),sa.BilledThru)  ,imonth_ ) ,pp.Period)= 0
GROUP BY DATEPART(dd,DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),sa.BilledThru)), at1.AccountTypeID

UNION ALL

SELECT DATEPART(dd,DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),p.BilledThru)), 1 AS Type, MIN(pt.PackageType) AS Description, MIN(pt.StringID) AS StringID, COUNT(*) AS Services, 
SUM(CASE WHEN p.DiffCost = 1 THEN p.Cost * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END) ELSE (COALESCE(opt.CustomerCost,pt.Cost) * (CASE WHEN pp.PeriodTypeID = 2 THEN 1 ELSE pp.Period END)) * CASE WHEN d.AmountType = 0 THEN (100 - d.Amount) / 100 ELSE 1 END + CASE WHEN d.AmountType = 1 THEN -(d.Amount) ELSE 0 END END) AS Cost

FROM MasterAccounts ma JOIN Packages p ON (ma.CustomerID = p.CustomerID)
	JOIN PayPeriods pp ON (p.PayPeriodID = pp.PayPeriodID)
	JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	JOIN Discounts d ON (p.DiscountID = d.DiscountID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	LEFT JOIN OrgPackageTypes opt ON (g.OrganizationID = opt.OrganizationID AND p.PackageTypeID = opt.PackageTypeID AND o.ResellerCustomerID IS NOT NULL)
	WHERE ma.Active = 1
	AND p.Active = 1
	AND EXISTS (SELECT * FROM SubAccounts sa WHERE sa.PackageID = p.PackageID AND sa.CustomerID = ma.CustomerID AND sa.Active = 1 AND (sa.CancelDate IS NULL OR sa.CancelDate > imonth_) )
	AND (ma.CancelDate IS NULL OR ma.CancelDate > imonth_) 
	AND (p.CancelDate IS NULL OR p.CancelDate > imonth_) 
	AND (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (bc.AutoBill = 1 OR (bc.AutoBill = 0 AND DATEDIFF(mm,p.ExpireDate,sysdate) <= 1))
AND MOD(DATEDIFF(mm,  DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),p.BilledThru)  ,imonth_ ) ,pp.Period)= 0
GROUP BY DATEPART(dd,DATEADD(dd,-(CASE WHEN ma.PaymentTypeID IN (8,16) THEN bc.EBillDays ELSE bc.IBillDays END),p.BilledThru)), pt.PackageTypeID;
OPEN crReportForecastDaily1 FOR SELECT Day AS Sorter,Day,Type,Description,StringID,Services,Cost 
FROM fcastd
UNION ALL
SELECT 99,NULL,2,NULL,NULL,SUM(Services),SUM(Cost) 
FROM fcastd
ORDER BY 1;
DELETE FROM fcastd;
END;
END;
/

CREATE OR REPLACE PROCEDURE ReportGLPayment (crReportGLPayment1 IN OUT ieatypes.CursorType,OrganizationID_ IN INTEGER,GroupID_ IN INTEGER,StartDate_ IN DATE,EndDate_ IN DATE) AS
BEGIN


INSERT INTO rglpplus (Type, ID, GLCode, Description, Amount, Cnt)
SELECT 0 AS Type, at1.AccountTypeID, MIN(gl.GLCode), MIN(at1.AccountType), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID AND at1.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (at1.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND pi1.PaymentID IS NOT NULL
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR pi1.ActiveDate >=StartDate_)
	AND (EndDate_ IS NULL OR pi1.ActiveDate < EndDate_) 
	AND (StartDate_ IS NULL OR EndDate_ IS NULL OR pi1.InactiveDate IS NULL OR pi1.InactiveDate < StartDate_ OR pi1.InactiveDate > EndDate_) 
GROUP BY at1.AccountTypeID

UNION ALL

SELECT 1 AS Type, pt.PackageTypeID, MIN(gl.GLCode), MIN(pt.PackageType), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN PackageTypes pt ON (ii.PackageTypeID = pt.PackageTypeID AND pt.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (pt.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND pi1.PaymentID IS NOT NULL
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR pi1.ActiveDate >=StartDate_)
	AND (EndDate_ IS NULL OR pi1.ActiveDate < EndDate_) 
	AND (StartDate_ IS NULL OR EndDate_ IS NULL OR pi1.InactiveDate IS NULL OR pi1.InactiveDate < StartDate_ OR pi1.InactiveDate > EndDate_) 
GROUP BY pt.PackageTypeID

UNION ALL

SELECT 2 AS Type, ct.ChargeTypeID, MIN(gl.GLCode), MIN(ct.Description), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID AND ct.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (ct.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND pi1.PaymentID IS NOT NULL
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR pi1.ActiveDate >=StartDate_)
	AND (EndDate_ IS NULL OR pi1.ActiveDate < EndDate_) 
	AND (StartDate_ IS NULL OR EndDate_ IS NULL OR pi1.InactiveDate IS NULL OR pi1.InactiveDate < StartDate_ OR pi1.InactiveDate > EndDate_) 
GROUP BY ct.ChargeTypeID

UNION ALL

SELECT 3 AS Type, t.TaxID, MIN(gl.GLCode), MIN(t.Description), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN Taxes t ON (ii.TaxID = t.TaxID AND t.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (t.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND pi1.PaymentID IS NOT NULL
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR pi1.ActiveDate >=StartDate_)
	AND (EndDate_ IS NULL OR pi1.ActiveDate < EndDate_) 
	AND (StartDate_ IS NULL OR EndDate_ IS NULL OR pi1.InactiveDate IS NULL OR pi1.InactiveDate < StartDate_ OR pi1.InactiveDate > EndDate_) 
GROUP BY t.TaxID;
INSERT INTO rglpminus (Type, ID, GLCode, Description, Amount, Cnt)
SELECT 0 AS Type, at1.AccountTypeID, MIN(gl.GLCode), MIN(at1.AccountType), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID AND at1.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (at1.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR pi1.InactiveDate >=StartDate_)
	AND (EndDate_ IS NULL OR pi1.InactiveDate < EndDate_) 
	AND (StartDate_ IS NULL OR EndDate_ IS NULL OR pi1.ActiveDate < StartDate_ OR pi1.ActiveDate > EndDate_) 
GROUP BY at1.AccountTypeID

UNION ALL

SELECT 1 AS Type, pt.PackageTypeID, MIN(gl.GLCode), MIN(pt.PackageType), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN PackageTypes pt ON (ii.PackageTypeID = pt.PackageTypeID AND pt.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (pt.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND pi1.PaymentID IS NOT NULL
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR pi1.InactiveDate >=StartDate_)
	AND (EndDate_ IS NULL OR pi1.InactiveDate < EndDate_) 
	AND (StartDate_ IS NULL OR EndDate_ IS NULL OR pi1.ActiveDate < StartDate_ OR pi1.ActiveDate > EndDate_) 
GROUP BY pt.PackageTypeID

UNION ALL

SELECT 2 AS Type, ct.ChargeTypeID, MIN(gl.GLCode), MIN(ct.Description), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID AND ct.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (ct.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND pi1.PaymentID IS NOT NULL
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR pi1.InactiveDate >=StartDate_)
	AND (EndDate_ IS NULL OR pi1.InactiveDate < EndDate_) 
	AND (StartDate_ IS NULL OR EndDate_ IS NULL OR pi1.ActiveDate < StartDate_ OR pi1.ActiveDate > EndDate_) 
GROUP BY ct.ChargeTypeID

UNION ALL

SELECT 3 AS Type, t.TaxID, MIN(gl.GLCode), MIN(t.Description), SUM(pi1.Amount), COUNT(*)
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN Taxes t ON (ii.TaxID = t.TaxID AND t.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (t.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND pi1.PaymentID IS NOT NULL
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR pi1.InactiveDate >=StartDate_)
	AND (EndDate_ IS NULL OR pi1.InactiveDate < EndDate_) 
	AND (StartDate_ IS NULL OR EndDate_ IS NULL OR pi1.ActiveDate < StartDate_ OR pi1.ActiveDate > EndDate_) 
GROUP BY t.TaxID;
OPEN crReportGLPayment1 FOR SELECT 0 AS Type, p.GLCode, p.Description, p.Amount AS Amount, COALESCE(m.Amount,0) AS VoidAmount, p.Amount - COALESCE(m.Amount,0) AS FinalAmount, COALESCE(p.Cnt,0) AS NewCount, COALESCE(m.Cnt,0) AS VoidCount, COALESCE(p.Cnt,0) - COALESCE(m.Cnt,0) AS AdjCount
FROM rglpplus p LEFT JOIN rglpminus m ON (p.Type = m.Type AND p.ID = m.ID)

UNION ALL

SELECT 0 AS Type, m.GLCode, m.Description, 0 AS Amount, m.Amount AS VoidAmount, -(m.Amount) AS FinalAmount, 0 AS NewCount, COALESCE(m.Cnt,0) AS VoidCount, 0 - COALESCE(m.Cnt,0) AS AdjCount
FROM rglpminus m WHERE NOT EXISTS (SELECT * FROM rglpplus p WHERE p.Type = m.Type AND p.ID = m.ID)

UNION ALL

SELECT 1 AS Type, p.GLCode, NULL AS Description, SUM(p.Amount), COALESCE((SELECT SUM(Amount) FROM rglpminus m WHERE m.GLCode = p.GLCode),0) , SUM(p.Amount) - COALESCE((SELECT SUM(Amount) FROM rglpminus m WHERE m.GLCode = p.GLCode),0), SUM(p.Cnt) AS NewCount, 0 AS VoidCount, SUM(p.Cnt) - 0 AS AdjCount
FROM rglpplus p
GROUP BY p.GLCode

UNION ALL

SELECT 1 AS Type, m.GLCode, NULL AS Description, 0 AS Amount, SUM(m.Amount), -(SUM(m.Amount)), 0 AS NewCount, SUM(m.Cnt) AS VoidCount, 0 - SUM(m.Cnt) AS AdjCount
FROM rglpminus m WHERE m.GLCode NOT IN (SELECT p.GLCode FROM rglpplus p)
GROUP BY m.GLCode

ORDER BY 2,1,3;
DELETE FROM rglpplus;
DELETE FROM rglpminus;
END;
/

CREATE OR REPLACE PROCEDURE ReportGLInvoiced (crReportGLInvoiced1 IN OUT ieatypes.CursorType,OrganizationID_ IN INTEGER,GroupID_ IN INTEGER,StartDate_ IN DATE,EndDate_ IN DATE) AS
BEGIN


INSERT INTO irglpplus (Type, ID, GLCode, Description, Amount, Cnt)
SELECT 0 AS Type, at1.AccountTypeID, MIN(gl.GLCode), MIN(at1.AccountType), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID AND at1.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (at1.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR i.CreateDate >=StartDate_)
	AND (EndDate_ IS NULL OR i.CreateDate < EndDate_) 
	AND i.Processed = 1
GROUP BY at1.AccountTypeID

UNION ALL

SELECT 1 AS Type, pt.PackageTypeID, MIN(gl.GLCode), MIN(pt.PackageType), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN PackageTypes pt ON (ii.PackageTypeID = pt.PackageTypeID AND pt.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (pt.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR i.CreateDate >=StartDate_)
	AND (EndDate_ IS NULL OR i.CreateDate < EndDate_) 
	AND i.Processed = 1
GROUP BY pt.PackageTypeID

UNION ALL

SELECT 2 AS Type, ct.ChargeTypeID, MIN(gl.GLCode), MIN(ct.Description), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID AND ct.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (ct.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR i.CreateDate >=StartDate_)
	AND (EndDate_ IS NULL OR i.CreateDate < EndDate_) 
	AND i.Processed = 1
GROUP BY ct.ChargeTypeID

UNION ALL

SELECT 3 AS Type, t.TaxID, MIN(gl.GLCode), MIN(t.Description), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN Taxes t ON (ii.TaxID = t.TaxID AND t.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (t.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR i.CreateDate >=StartDate_)
	AND (EndDate_ IS NULL OR i.CreateDate < EndDate_) 
	AND i.Processed = 1
GROUP BY t.TaxID;
INSERT INTO irglpminus (Type, ID, GLCode, Description, Amount, Cnt)
SELECT 0 AS Type, at1.AccountTypeID, MIN(gl.GLCode), MIN(at1.AccountType), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID AND at1.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (at1.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR i.VoidDate >=StartDate_)
	AND (EndDate_ IS NULL OR i.VoidDate < EndDate_) 
	AND i.Processed = 1
GROUP BY at1.AccountTypeID

UNION ALL

SELECT 1 AS Type, pt.PackageTypeID, MIN(gl.GLCode), MIN(pt.PackageType), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN PackageTypes pt ON (ii.PackageTypeID = pt.PackageTypeID AND pt.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (pt.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR i.VoidDate >=StartDate_)
	AND (EndDate_ IS NULL OR i.VoidDate < EndDate_) 
	AND i.Processed = 1
GROUP BY pt.PackageTypeID

UNION ALL

SELECT 2 AS Type, ct.ChargeTypeID, MIN(gl.GLCode), MIN(ct.Description), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID AND ct.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (ct.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR i.VoidDate >=StartDate_)
	AND (EndDate_ IS NULL OR i.VoidDate < EndDate_) 
	AND i.Processed = 1
GROUP BY ct.ChargeTypeID

UNION ALL

SELECT 3 AS Type, t.TaxID, MIN(gl.GLCode), MIN(t.Description), ROUND(SUM(ii.Amount * ii.Quantity),2), COUNT(*)
FROM InvoiceItems ii JOIN Taxes t ON (ii.TaxID = t.TaxID AND t.GLCodeID IS NOT NULL)
	JOIN GLCodes gl ON (t.GLCodeID = gl.GLCodeID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (StartDate_ IS NULL OR i.VoidDate >=StartDate_)
	AND (EndDate_ IS NULL OR i.VoidDate < EndDate_) 
	AND i.Processed = 1
GROUP BY t.TaxID;
OPEN crReportGLInvoiced1 FOR SELECT 0 AS Type, p.GLCode, p.Description, p.Amount AS Amount, COALESCE(m.Amount,0) AS VoidAmount, p.Amount - COALESCE(m.Amount,0) AS FinalAmount, COALESCE(p.Cnt,0) AS NewCount, COALESCE(m.Cnt,0) AS VoidCount, COALESCE(p.Cnt,0) - COALESCE(m.Cnt,0) AS AdjCount
FROM irglpplus p LEFT JOIN irglpminus m ON (p.Type = m.Type AND p.ID = m.ID)

UNION ALL

SELECT 0 AS Type, m.GLCode, m.Description, 0 AS Amount, m.Amount AS VoidAmount, -(m.Amount) AS FinalAmount, 0 AS NewCount, COALESCE(m.Cnt,0) AS VoidCount, 0 - COALESCE(m.Cnt,0) AS AdjCount
FROM irglpminus m WHERE NOT EXISTS (SELECT * FROM irglpplus p WHERE p.Type = m.Type AND p.ID = m.ID)

UNION ALL

SELECT 1 AS Type, p.GLCode, NULL AS Description, SUM(p.Amount), COALESCE((SELECT SUM(Amount) FROM irglpminus m WHERE m.GLCode = p.GLCode),0) , SUM(p.Amount) - COALESCE((SELECT SUM(Amount) FROM irglpminus m WHERE m.GLCode = p.GLCode),0), SUM(p.Cnt) AS NewCount, 0 AS VoidCount, SUM(p.Cnt) - 0 AS AdjCount
FROM irglpplus p
GROUP BY p.GLCode

UNION ALL

SELECT 1 AS Type, m.GLCode, NULL AS Description, 0 AS Amount, SUM(m.Amount), -(SUM(m.Amount)), 0 AS NewCount, SUM(m.Cnt) AS VoidCount, 0 - SUM(m.Cnt) AS AdjCount
FROM irglpminus m WHERE m.GLCode NOT IN (SELECT p.GLCode FROM irglpplus p)
GROUP BY m.GLCode

ORDER BY 2,1,3;
DELETE FROM irglpplus;
DELETE FROM irglpminus;
END;
/

CREATE OR REPLACE PROCEDURE ReportDefRevGL (crReportDefRevGL1 IN OUT ieatypes.CursorType,OrganizationID_ IN INTEGER,GroupID_ IN INTEGER,defstart_ IN DATE) AS
BEGIN
DECLARE
defdate_ DATE;
BEGIN

SELECT CASE WHEN defstart_ IS NULL OR defstart_ > sysdate THEN sysdate ELSE defstart_ END INTO defdate_ 


 FROM DUAL;
INSERT INTO defrrptgl (DefRatio,InvAmount,PaidBefore,PaidAfter,GLCodeID)
SELECT CAST(DATEDIFF(dd,CASE WHEN defdate_ < ii.StartDate THEN ii.StartDate ELSE defdate_ END,ii.EndDate) AS FLOAT) /
CAST(DATEDIFF(dd,ii.StartDate,ii.EndDate) AS FLOAT) AS DefRatio,
ii.Amount * ii.Quantity AS InvAmount,
COALESCE((SELECT SUM(pi1.Amount) FROM PaymentItems pi1 WHERE (pi1.InactiveDate IS NULL OR pi1.InactiveDate > defdate_)  AND pi1.ActiveDate < defdate_ AND pi1.ItemID = ii.ItemID),0) AS PaidBefore,
COALESCE((SELECT SUM(pi1.Amount) FROM PaymentItems pi1 WHERE pi1.InactiveDate IS NULL AND pi1.ActiveDate > defdate_ AND pi1.ItemID = ii.ItemID),0) AS PaidAfter,
COALESCE(t.GLCodeID,at1.GLCodeID,pt1.GLCodeID,ct.GLCodeID) AS GLCodeID

FROM MasterAccounts ma JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	LEFT JOIN Taxes t ON (ii.TaxID = t.TaxID)
	LEFT JOIN AccountTypes at1 ON (ii.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN PackageTypes pt1 ON (ii.PackageTypeID = pt1.PackageTypeID)
	LEFT JOIN ChargeTypes ct ON (ii.ChargeTypeID = ct.ChargeTypeID)

	WHERE (i.VoidDate IS NULL OR i.VoidDate > defdate_) 
	AND ii.ItemType = 3
	AND ii.EndDate > defdate_
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND i.CreateDate < defdate_
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND bc.AutoBill IN (1,0);
OPEN crReportDefRevGL1 FOR SELECT 1 AS SortOrder, def.GLCodeID, MIN(gl.GLCode) AS GLCode,
CAST(SUM(ROUND((def.InvAmount * def.DefRatio),2)) AS NUMERIC(18,2)) AS DefInvoiced,
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) AS NUMERIC(18,2)) AS DefPaid,
CAST(SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS FuturePaidAmount, 
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) + SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS TotalPaidAmount
FROM defrrptgl def LEFT JOIN GLCodes gl ON (def.GLCodeID = gl.GLCodeID)
GROUP BY def.GLCodeID

UNION ALL

SELECT 2 AS SortOrder, NULL, NULL,
CAST(SUM(ROUND((def.InvAmount * def.DefRatio),2)) AS NUMERIC(18,2)) AS DefInvoiced,
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) AS NUMERIC(18,2)) AS DefPaid,
CAST(SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS FuturePaidAmount, 
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) + SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS TotalPaidAmount
FROM defrrptgl def
ORDER BY 1 ASC,2,3;
DELETE FROM defrrptgl;
END;
END;
/

CREATE OR REPLACE PROCEDURE ReportDefRevDetail (crReportDefRevDetail1 IN OUT ieatypes.CursorType,OrganizationID_ IN INTEGER,GroupID_ IN INTEGER,defstart_ IN DATE) AS
BEGIN
DECLARE
defdate_ DATE;
BEGIN

SELECT CASE WHEN defstart_ IS NULL OR defstart_ > sysdate THEN sysdate ELSE defstart_ END INTO defdate_ 


 FROM DUAL;
INSERT INTO defrrpt (CustomerID,InvoiceID,Active,DefDays,DefRatio,InvAmount,PaidBefore,PaidAfter,AccountTypeID,PackageTypeID,AccountID,PackageID)
SELECT ma.CustomerID, i.InvoiceID, ma.Active,
DATEDIFF(dd,CASE WHEN defdate_ < ii.StartDate THEN ii.StartDate ELSE defdate_ END,ii.EndDate) AS DefDays,
CAST(DATEDIFF(dd,CASE WHEN defdate_ < ii.StartDate THEN ii.StartDate ELSE defdate_ END,ii.EndDate) AS FLOAT) /
CAST(DATEDIFF(dd,ii.StartDate,ii.EndDate) AS FLOAT) AS DefRatio,
ii.Amount * ii.Quantity AS InvAmount,
COALESCE((SELECT SUM(pi1.Amount) FROM PaymentItems pi1 WHERE (pi1.InactiveDate IS NULL OR pi1.InactiveDate > defdate_)  AND pi1.ActiveDate < defdate_ AND pi1.ItemID = ii.ItemID),0) AS PaidBefore,
COALESCE((SELECT SUM(pi1.Amount) FROM PaymentItems pi1 WHERE pi1.InactiveDate IS NULL AND pi1.ActiveDate > defdate_ AND pi1.ItemID = ii.ItemID),0) AS PaidAfter,
ii.AccountTypeID, ii.PackageTypeID, ii.AccountID, ii.PackageID

FROM MasterAccounts ma, Groups g, BillingCycles bc, Invoices i, InvoiceItems ii
	WHERE ma.GroupID = g.GroupID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND ma.CustomerID = i.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND (i.VoidDate IS NULL OR i.VoidDate > defdate_) 
	AND ii.ItemType = 3
	AND ii.EndDate > defdate_
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND i.CreateDate < defdate_
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
	AND bc.AutoBill IN (1,0);
OPEN crReportDefRevDetail1 FOR SELECT 1 AS SortOrder, ma.CustomerID, def.InvoiceID, MIN(ma.Active) AS Active, MIN(ma.FirstName) AS FirstName, MIN(ma.LastName) AS LastName, MIN(ma.Company) AS Company, 
CAST(SUM(ROUND((def.InvAmount * def.DefRatio),2)) AS NUMERIC(18,2)) AS DefInvoiced,
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) AS NUMERIC(18,2)) AS DefPaid,
CAST(SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS FuturePaidAmount, 
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) + SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS TotalPaidAmount

FROM defrrpt def, MasterAccounts ma 
	WHERE def.CustomerID = ma.CustomerID
GROUP BY ma.CustomerID, def.InvoiceID

UNION ALL

SELECT 2 AS SortOrder, NULL, NULL, NULL, NULL, NULL, NULL,
CAST(SUM(ROUND((def.InvAmount * def.DefRatio),2)) AS NUMERIC(18,2)) AS DefInvoiced,
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) AS NUMERIC(18,2)) AS DefPaid,
CAST(SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS FuturePaidAmount, 
CAST(SUM(ROUND(CASE WHEN ((1.0-def.DefRatio) * def.InvAmount) > def.PaidBefore THEN 0 ELSE def.PaidBefore - ((1.0-def.DefRatio) * def.InvAmount) END,2)) + SUM(ROUND(def.PaidAfter,2)) AS NUMERIC(18,2)) AS TotalPaidAmount
FROM defrrpt def

ORDER BY 1 ASC,2,3;
DELETE FROM defrrpt;
END;
END;
/

CREATE OR REPLACE PROCEDURE ReportTaxPayments (crReportTaxPayments1 IN OUT ieatypes.CursorType,OrganizationID_ IN INTEGER,StartDate_ IN DATE,EndDate_ IN DATE) AS
BEGIN


INSERT INTO rtpplusta (TaxID,ItemCount,TaxableAmount)
SELECT ii.TaxID, COUNT(*), SUM(ROUND(iis.Amount * iis.Quantity,2))
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN TaxGroupTaxes tgt ON (ii.TaxID = tgt.TaxID)
	JOIN InvoiceItems iis ON (i.InvoiceID = iis.InvoiceID AND iis.ItemType <> 254 AND iis.Amount > 0 AND iis.Quantity > 0 AND iis.TaxGroupID = tgt.TaxGroupID)
	WHERE ii.ItemType = 254
	AND pi1.ActiveDate BETWEEN StartDate_ AND EndDate_
	AND g.OrganizationID =OrganizationID_
GROUP BY ii.TaxID;
INSERT INTO rtpplus (TaxID,ItemCount,Amount,InvAmount,TaxableAmount)
SELECT ii.TaxID, MIN(ta.ItemCount), SUM(pi1.Amount) AS Amount, SUM(i.Amount * (pi1.Amount / ROUND(ii.Amount * ii.Quantity,2))) , MIN(ta.TaxableAmount) * (SUM(pi1.Amount) / SUM(ROUND(ii.Amount * ii.Quantity,2)))
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN rtpplusta ta ON (ii.TaxID = ta.TaxID)
	WHERE ii.ItemType = 254
	AND pi1.ActiveDate BETWEEN StartDate_ AND EndDate_
	AND g.OrganizationID =OrganizationID_
GROUP BY ii.TaxID;
INSERT INTO rtpminusta (TaxID,TaxableAmount)
SELECT ii.TaxID, SUM(ROUND(iis.Amount * iis.Quantity,2))
FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN TaxGroupTaxes tgt ON (ii.TaxID = tgt.TaxID)
	JOIN InvoiceItems iis ON (i.InvoiceID = iis.InvoiceID AND iis.ItemType <> 254 AND iis.Amount > 0 AND iis.Quantity > 0 AND iis.TaxGroupID = tgt.TaxGroupID)
	WHERE ii.ItemType = 254
	AND pi1.InactiveDate BETWEEN StartDate_ AND EndDate_
	AND g.OrganizationID =OrganizationID_
GROUP BY ii.TaxID;
INSERT INTO rtpminus (TaxID,Amount,InvAmount,TaxableAmount)
SELECT ii.TaxID, SUM(pi1.Amount) AS Amount,SUM(i.Amount * (pi1.Amount / ROUND(ii.Amount * ii.Quantity,2))), MIN(ta.TaxableAmount) * (SUM(pi1.Amount) / SUM(ROUND(ii.Amount * ii.Quantity,2)))

FROM PaymentItems pi1 JOIN InvoiceItems ii ON (pi1.ItemID = ii.ItemID)
	JOIN Invoices i ON (ii.InvoiceID = i.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN rtpminusta ta ON (ii.TaxID = ta.TaxID)
	WHERE ii.ItemType = 254
	AND pi1.InactiveDate BETWEEN StartDate_ AND EndDate_
	AND g.OrganizationID =OrganizationID_
GROUP BY ii.TaxID;
OPEN crReportTaxPayments1 FOR SELECT t.Description, t.StringID, 
COALESCE(p.Amount,0) AS NewPayments, COALESCE(m.Amount,0) AS VoidedPayments, COALESCE(p.Amount,0) - COALESCE(m.Amount,0) AS AdjustedTotal, 
COALESCE(p.ItemCount,0) AS NewItemCount, COALESCE(p.InvAmount,0) AS NewInvoiced, COALESCE(m.InvAmount,0) AS VoidedInvoiced, COALESCE(p.InvAmount,0) - COALESCE(m.InvAmount,0) AS AdjustedInvoiced,
COALESCE(p.TaxableAmount,0) AS NewTaxable, COALESCE(m.TaxableAmount,0) AS VoidedTaxable, COALESCE(p.TaxableAmount,0) - COALESCE(m.TaxableAmount,0) AS AdjustedTaxable
FROM Taxes t LEFT JOIN rtpplus p ON (t.TaxID = p.TaxID)
	LEFT JOIN rtpminus m ON (t.TaxID = m.TaxID)
	WHERE (p.TaxID IS NOT NULL OR m.TaxID IS NOT NULL);
DELETE FROM rtpplus;
DELETE FROM rtpminus;
DELETE FROM rtpplusta;
DELETE FROM rtpminusta;
END;
/

CREATE OR REPLACE PROCEDURE ResellerUsageUpdate AS
BEGIN
DECLARE
StartYear_ INTEGER;
StartMonth_ INTEGER;
BEGIN
SELECT DATEPART(yy,sysdate),DATEPART(mm,sysdate) INTO StartYear_,StartMonth_ 


 FROM DUAL;
MERGE INTO ResellerUsage mru 
USING (SELECT ru.StartYear, ru.StartMonth, ru.AccountID, ru.AccountTypeID, 
sysdate AS LastUpdate, Days + 
CASE WHEN g.Active = 1 AND ma.Active = 1 AND sa.Active = 1 AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate) AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate) AND (sa.ExpireDate IS NULL OR DATEADD(dd,1+sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= sysdate)
THEN CAST(DATEDIFF(ss,ru.LastUpdate,sysdate) AS FLOAT)/86400 ELSE 0 END AS Days
FROM ResellerUsage ru JOIN SubAccounts sa ON (ru.AccountID = sa.AccountID AND ru.AccountTypeID = sa.AccountTypeID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations org ON (g.OrganizationID = org.OrganizationID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE ru.StartYear =StartYear_
	AND ru.StartMonth =StartMonth_
	AND org.ResellerCustomerID IS NOT NULL
	AND sa.PackageID IS NULL) ru
ON (mru.StartYear = ru.StartYear AND mru.StartMonth = ru.StartMonth AND mru.AccountID = ru.AccountID AND mru.AccountTypeID = ru.AccountTypeID)
WHEN MATCHED THEN UPDATE SET mru.LastUpdate = ru.LastUpdate, mru.Days = ru.Days;


MERGE INTO ResellerPkgUsage mru
USING (SELECT ru.StartYear, ru.StartMonth, ru.PackageID, ru.PackageTypeID, 
sysdate AS LastUpdate, Days + 
CASE WHEN g.Active = 1 AND ma.Active = 1 AND p.Active = 1 AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate) AND (p.CancelDate IS NULL OR p.CancelDate > sysdate) AND (p.ExpireDate IS NULL OR DATEADD(dd,1+p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= sysdate)
THEN CAST(DATEDIFF(ss,ru.LastUpdate,sysdate) AS FLOAT)/86400 ELSE 0 END AS Days
FROM ResellerPkgUsage ru JOIN Packages p ON (ru.PackageID = p.PackageID AND ru.PackageTypeID = p.PackageTypeID)
	JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations org ON (g.OrganizationID = org.OrganizationID)
	WHERE ru.StartYear =StartYear_
	AND ru.StartMonth =StartMonth_
	AND org.ResellerCustomerID IS NOT NULL) ru
ON (mru.StartYear = ru.StartYear AND mru.StartMonth = ru.StartMonth AND mru.PackageID = ru.PackageID AND mru.PackageTypeID = ru.PackageTypeID)
WHEN MATCHED THEN UPDATE SET mru.LastUpdate = ru.LastUpdate, mru.Days = ru.Days;


INSERT INTO ResellerUsage (StartYear,StartMonth,AccountID,AccountTypeID,Days,LastUpdate)
SELECT StartYear_,StartMonth_ , sa.AccountID, sa.AccountTypeID, 
CASE WHEN g.Active = 1 AND ma.Active = 1 AND sa.Active = 1 AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate) AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate) AND (sa.ExpireDate IS NULL OR DATEADD(dd,1+sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) >= sysdate)
THEN CAST(DATEDIFF(ss,DATEADD(dd,-DATEPART(dd,sysdate) + 1,DATEADD(ss,-((DATEPART(hh,sysdate)*3600)+(DATEPART(mi,sysdate)*60) + DATEPART(ss,sysdate)),sysdate)),sysdate) AS FLOAT)/86400 ELSE 0 END,sysdate
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations org ON (org.OrganizationID = g.OrganizationID)
	LEFT JOIN ResellerUsage ru ON (ru.StartYear =StartYear_ AND ru.StartMonth =StartMonth_ AND ru.AccountID = sa.AccountID AND ru.AccountTypeID = sa.AccountTypeID)
	WHERE ru.AccountID IS NULL
	AND org.ResellerCustomerID IS NOT NULL
	AND sa.PackageID IS NULL
	AND sa.Active >= 0
	AND ma.Active >= 0;
INSERT INTO ResellerPkgUsage (StartYear,StartMonth,PackageID,PackageTypeID,Days,LastUpdate)
SELECT StartYear_,StartMonth_ , p.PackageID, p.PackageTypeID, 
CASE WHEN g.Active = 1 AND ma.Active = 1 AND p.Active = 1 AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate) AND (p.CancelDate IS NULL OR p.CancelDate > sysdate) AND (p.ExpireDate IS NULL OR DATEADD(dd,1+p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) >= sysdate)
THEN CAST(DATEDIFF(ss,DATEADD(dd,-DATEPART(dd,sysdate) + 1,DATEADD(ss,-((DATEPART(hh,sysdate)*3600)+(DATEPART(mi,sysdate)*60) + DATEPART(ss,sysdate)),sysdate)),sysdate) AS FLOAT)/86400 ELSE 0 END,sysdate
FROM Packages p JOIN MasterAccounts ma ON (ma.CustomerID = p.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations org ON (org.OrganizationID = g.OrganizationID)
	LEFT JOIN ResellerPkgUsage ru ON (ru.StartYear =StartYear_ AND ru.StartMonth =StartMonth_ AND ru.PackageID = p.PackageID AND ru.PackageTypeID = p.PackageTypeID)
	WHERE ru.PackageID IS NULL
	AND org.ResellerCustomerID IS NOT NULL
	AND p.Active >= 0
	AND ma.Active >= 0;
END;
END;
/

CREATE OR REPLACE PROCEDURE RU_AT (crRU_AT1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crRU_AT1 FOR SELECT AccountType, rc.AccountTypeID, ra.RadAttributeID, ra.RadAttributeType, rc.Data, rc.Value, rc.RadCheck, ra.Name
FROM RadATConfigs rc, RadAttributes ra, AccountTypes at1
	WHERE rc.RadAttributeID = ra.RadAttributeID
	AND rc.RadVendorID = ra.RadVendorID
	AND rc.AccountTypeID = at1.AccountTypeID 
ORDER BY rc.AccountTypeID, rc.RadCheck DESC;
END;
/

CREATE OR REPLACE PROCEDURE RU_RATC (crRU_RATC1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crRU_RATC1 FOR SELECT sa.Login, sa.Password, att.AccountType, DATEADD(dd,(Extension+COALESCE(ma.OverDue,0)+1), ExpireDate) AS SubExpire
FROM MasterAccounts ma, SubAccounts sa, AccountTypes att
	WHERE ma.CustomerID = sa.CustomerID
 	AND (DateAdd(dd,(Extension+COALESCE(ma.OverDue,0)+1),ExpireDate) >= sysdate or ExpireDate is NULL)
 	AND sa.Login is not NULL 
	AND sa.Password is not NULL
        AND ma.Active = 1 
	AND sa.Active = 1
	AND sa.AccountTypeID = att.AccountTypeID
	AND NOT EXISTS (SELECT * FROM RadConfigs rc WHERE sa.AccountID = rc.AccountID)
	AND EXISTS (Select * From RadATConfigs rat where sa.AccountTypeID = rat.AccountTypeID);
END;
/

CREATE OR REPLACE PROCEDURE RU_RC (crRU_RC1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crRU_RC1 FOR SELECT sa.Login, sa.Password, ra.Name, ra.RadAttributeType, rc.Data, rc.Value, rc.RadCheck,
DateAdd(dd, (Extension+COALESCE(ma.OverDue,0)+1), ExpireDate)
    From MasterAccounts ma, SubAccounts sa, RadConfigs rc, RadAttributes ra
    Where ma.CustomerID = sa.CustomerID
AND rc.AccountID = sa.AccountID
AND ra.RadAttributeID = rc.RadAttributeID
 	AND sa.Login is not null and sa.Password is not null
 	AND (DateAdd(dd, (Extension+COALESCE(ma.OverDue,0)+1), ExpireDate) >= sysdate or ExpireDate is NULL)
        AND ma.Active = 1 AND sa.Active = 1
   Order BY sa.Login, rc.RadCheck DESC;
END;
/

CREATE OR REPLACE PROCEDURE SACallSearch (crSACallSearch1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,AccountID_ IN INTEGER,StartDate_ IN DATE,EndDate_ IN DATE) AS
BEGIN

INSERT INTO sacstmp (Calls,CallStart,Mins,InMB,OutMB,Username,Server,NASPort,ConnectInfo,CallerID,NASPortDNIS,NASIdentifier,AcctTerminateCause)
SELECT 1,DATEADD(ss,-(COALESCE(c.AcctSessionTime,0)),c.CallDate) AS CallStart, (c.AcctSessionTime/60)+1 AS Mins,
CAST(c.AcctInputOctets AS NUMERIC(18,4))/1000000 AS InMB,
CAST(c.AcctOutputOctets AS NUMERIC(18,4))/1000000 AS OutMB,
c.Username, s.Server, c.NASPort, c.ConnectInfo, c.CallerID, c.NASPortDNIS, c.NASIdentifier, c.AcctTerminateCause
FROM Calls c JOIN SubAccounts sa ON (c.AccountID = sa.AccountID)
	LEFT JOIN Servers s ON (c.ServerID = s.ServerID)
	WHERE sa.CustomerID =CustomerID_
	AND sa.AccountID =AccountID_
	AND c.CallDate BETWEEN StartDate_ AND EndDate_
	AND c.AcctStatusType = 2
ORDER BY 2;
INSERT INTO sacstmp (Calls,CallStart,Mins,OutMB,Username,ConnectInfo,CallerID,NASPortDNIS,AcctTerminateCause,Cost,State,Country,Location)
SELECT 1,CallDate,vc.Duration/60.0,Bytes/1000000.0 AS OutMB,vc.Login,vc.CallType,vc.Login,vc.CalledNumber,AcctTerminateCause,vc.Cost,COALESCE(s.Abbreviation,s.State), c.Country, vc.Location
FROM VoiceCalls vc JOIN SubAccounts sa ON (vc.AccountID = sa.AccountID)
	LEFT JOIN States s ON (vc.StateID = s.StateID)
	LEFT JOIN Countries c ON (vc.CountryID = c.CountryID)
	WHERE sa.CustomerID =CustomerID_
	AND sa.AccountID =AccountID_
	AND vc.CallDate BETWEEN StartDate_ AND EndDate_
	AND vc.ProcDate IS NOT NULL
ORDER BY 2;
OPEN crSACallSearch1 FOR SELECT Calls,CallStart,Mins,InMB,OutMB,Cost,Username,Server,NASPort,ConnectInfo,CallerID,NASPortDNIS,NASIdentifier,AcctTerminateCause,State,Country,Location,0 AS Summary FROM sacstmp
UNION ALL
SELECT COUNT(*),NULL,SUM(Mins), SUM(InMB), SUM(OutMB), SUM(Cost), NULL, NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1 FROM sacstmp;
DELETE FROM sacstmp;
END;
/

CREATE OR REPLACE PROCEDURE SACustomData (crSACustomData1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER) AS
BEGIN
OPEN crSACustomData1 FOR SELECT DISTINCT adt.AccountDataType, COALESCE(adv.ValueData,sad.Data) AS Data, COALESCE(sadt.SortOrder,sadt2.SortOrder,0) AS SortOrder
FROM SubAccounts sa JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID)
	JOIN AccountDataTypes adt ON (sad.AccountDataTypeID = adt.AccountDataTypeID)
	LEFT JOIN AccountDataValues adv ON (sad.AccountDataTypeID = adv.AccountDataTypeID AND sad.Data = adv.KeyData)
	LEFT JOIN SubAccountDataTypes sadt ON (sa.AccountTypeID = sadt.AccountTypeID AND sad.AccountDataTypeID = sadt.AccountDataTypeID)
	LEFT JOIN SubAccountDataTypes sadt2 ON (sadt2.AccountTypeID IS NULL AND sad.AccountDataTypeID = sadt2.AccountDataTypeID)
	WHERE sad.Data IS NOT NULL
	AND sad.AccountID =AccountID_
	AND adt.AllowSA = 1
ORDER BY 3,1;
END;
/

CREATE OR REPLACE PROCEDURE SchedStatus (crSchedStatus1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crSchedStatus1 FOR SELECT s.ScheduleID, ss.Server, ss.ScheduleServerID, s.Description, s.LastStatus, s.LastStart, DATEDIFF(ss,s.LastStart,sysdate) AS Seconds
FROM Schedules s, ScheduleServers ss
	WHERE Status = 1
	AND (s.ScheduleServerID = ss.ScheduleServerID OR s.LockServerID = ss.ScheduleServerID)
ORDER BY ss.Server;
END;
/

CREATE OR REPLACE PROCEDURE SchedStatusUP (LastStatus_ IN VARCHAR2,LastUpdate_ IN DATE,LastStart_ IN DATE,Status_ IN SMALLINT,ScheduleID_ IN INTEGER) AS
BEGIN
UPDATE Schedules SET LastStatus =LastStatus_, LastUpdate =LastUpdate_, LastStart =LastStart_, Status =Status_
	WHERE Active = 1
	AND ScheduleID =ScheduleID_;
END;
/

CREATE OR REPLACE PROCEDURE PKGDetail (crPKGDetail1 IN OUT ieatypes.CursorType,PackageID_ IN INTEGER) AS
BEGIN
OPEN crPKGDetail1 FOR SELECT p.CustomerID, CASE WHEN p.DiffCost = 1 THEN p.Cost ELSE pt.Cost END AS Cost,
CASE WHEN p.DiffCost = 1 THEN 'Yes' ELSE 'No' END AS StaticCost,
pt.PackageType,di.Discount,p.CreateDate,p.StartDate, p.Comments,p.ExpireDate, p.CancelDate,
p.BilledThru, PayPeriod, p.LastModifyUser, p.LastModifyDate, cr.CancelReason, cr.StringID AS CancelReasonStringID,
CASE WHEN ma.Active = 0 THEN 4 WHEN p.Active = 0 THEN 5 WHEN p.CancelDate IS NOT NULL THEN 2 WHEN DATEADD(dd,p.Extension+COALESCE(ma.OverDue,0),p.ExpireDate) < sysdate THEN 3 ELSE 1 END AS Status

FROM Packages p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	JOIN PackageTypes pt ON (pt.PackageTypeID = p.PackageTypeID)
	JOIN Discounts di ON (p.DiscountID = di.DiscountID)
	JOIN PayPeriods pp ON (p.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN CancelReasons cr ON (p.CancelReasonID = cr.CancelReasonID)
	WHERE p.PackageID =PackageID_;
END;
/

CREATE OR REPLACE PROCEDURE SADetail (crSADetail1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER) AS
BEGIN
OPEN crSADetail1 FOR SELECT sa.CustomerID, sa.FirstName, sa.LastName, sa.Login,sa.Password,sa.Email,sa.MaidenName,sa.PhoneHome,sa.PhoneWork,
CASE WHEN sa.DiffCost = 1 THEN sa.Cost ELSE at1.Cost END AS Cost,
CASE WHEN sa.DiffCost = 1 THEN 1 ELSE 0 END AS StaticCost,
sa.SendBill, sa.Preferred, sa.RemoteAccess,
CASE WHEN ma.Active = 0 THEN 4 WHEN p.Active = 0 THEN 5 WHEN sa.Active = 0 THEN 0 WHEN sa.CancelDate IS NOT NULL THEN 2 WHEN DATEADD(dd,sa.Extension+COALESCE(ma.OverDue,0),sa.ExpireDate) < sysdate THEN 3 ELSE 1 END AS Status,
at1.AccountType,at1.AccountTypeID,COALESCE(di.Discount,'None') AS Discount,sa.CreateDate,sa.StartDate,
sa.Comments,sa.TimeLeft + COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > sysdate AND sau.TimeLeft > 0),0) AS TimeLeft,(sa.DataLeft + COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sa.AccountID=sau.AccountID AND sau.ExpireDate > sysdate AND sau.DataLeft > 0),0)) / 1000000.0 AS DataLeft, sa.LoginLimit,sa.ExpireDate,
sa.BilledThru, PayPeriod, sa.LastModifyUser, 
sa.LastModifyDate, cr.CancelReason, cr.StringID AS CancelReasonStringID, sa.CancelDate, pt.PackageType, es.Message, es.ErrorCount,
CASE WHEN es.ExternalSystemID IS NOT NULL THEN (SELECT Name FROM ExternalSystems WHERE ExternalSystemID = es.ExternalSystemID) ELSE NULL END AS ESName, d.MailDomain, ria.IPAddress AS StaticIP, sa.Operator
FROM SubAccounts sa JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Discounts di ON (sa.DiscountID = di.DiscountID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN RadIPAddresses ria ON (sa.AccountID = ria.AccountID)
	LEFT JOIN CancelReasons cr ON (sa.CancelReasonID = cr.CancelReasonID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	LEFT JOIN ExternalSyncs es ON (sa.AccountID = es.AccountID AND es.ErrorCount > 0)
	WHERE sa.AccountID =AccountID_;
END;
/

CREATE OR REPLACE PROCEDURE SAFormTemplate (crSAFormTemplate1 IN OUT ieatypes.CursorType,AccountTypeID_ IN INTEGER) AS
BEGIN
OPEN crSAFormTemplate1 FOR SELECT act.LoginLabel, act.LoginStringID, act.SAEdit, act.SANew, act.SASave, act.CustNew, act.CustSave
FROM AccountTypes at1, AccountTemplates act
	WHERE at1.AccountTemplateID = act.AccountTemplateID
	AND at1.AccountTypeID =AccountTypeID_;
END;
/

CREATE OR REPLACE PROCEDURE SignupFormTemplate (crSignupFormTemplate1 IN OUT ieatypes.CursorType,PackageTypeID_ IN INTEGER) AS
BEGIN

OPEN crSignupFormTemplate1 FOR SELECT act.SignupPage, act.SignupForm, act.SignupValidate, act.SignupSave, act.SignupBillSave, act.LoginLabel, act.LoginStringID
FROM AccountTypes at1, PackageTypes pt, AccountTemplates act
	WHERE pt.PrimaryAccountTypeID = at1.AccountTypeID
	AND at1.AccountTemplateID = act.AccountTemplateID
	AND pt.CustomerSignup = 1
	AND pt.PackageTypeID =PackageTypeID_;
END;
/

CREATE OR REPLACE PROCEDURE SAEmail (crSAEmail1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER) AS
BEGIN
OPEN crSAEmail1 FOR SELECT 0 AS Type, AliasID AS ID, AccountID, Alias AS Email
FROM Aliases 
	WHERE AccountID =AccountID_
UNION ALL
SELECT 1 AS Type, ForwardID AS ID, AccountID, Forward AS Email
FROM Forwards 
	WHERE AccountID =AccountID_
Order By Email, Type;
END;
/

CREATE OR REPLACE PROCEDURE SAFindCustomerID (crSAFindCustomerID1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER) AS
BEGIN
OPEN crSAFindCustomerID1 FOR SELECT CASE WHEN at1.ChargeTypeID IS NULL THEN 0 ELSE 1 END AS SetupCharge,CASE WHEN ma.Active = 1 AND sa.Active = 1 THEN 1 ELSE 0 END AS Status,CASE WHEN sa.CancelDate IS NULL AND sa.Active = 1 THEN 1 ELSE 0 END AS Active,ma.GroupID,g.OrganizationID,sa.CustomerID,sa.FirstName,sa.LastName,COALESCE(sa.Login,sa.Email) as Login, Password, at1.AccountTypeID, ma.BillDay
FROM SubAccounts sa,MasterAccounts ma, AccountTypes at1, Groups g
	WHERE sa.AccountID=AccountID_
	AND sa.CustomerID=ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND sa.AccountTypeID=at1.AccountTypeID
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0);
END;
/

CREATE OR REPLACE PROCEDURE SAGetCustomFields (crSAGetCustomFields1 IN OUT ieatypes.CursorType,AccountTypeID_ IN INTEGER) AS
BEGIN
OPEN crSAGetCustomFields1 FOR SELECT COALESCE(MIN(sadt.Required),0) AS Required, MIN(adt.RegExp) AS RegExp, MIN(adt.StringID) AS StringID, MIN(adt.AccountDataType) AS AccountDataType,adt.AccountDataTypeID,MIN(sadt.SortOrder) AS SortOrder,MIN(adt.DataTypeID) AS DataTypeID
FROM AccountDataTypes adt, SubAccountDataTypes sadt
	WHERE adt.AccountDataTypeID=sadt.AccountDataTypeID
	AND adt.AllowSA=1
	AND (sadt.AccountTypeID IS NULL OR sadt.AccountTypeID=AccountTypeID_)
GROUP BY adt.AccountDataTypeID
UNION ALL
SELECT COALESCE(MIN(esdt.Required),0) AS Required, MIN(adt.RegExp) AS RegExp, MIN(adt.StringID) AS StringID, MIN(adt.AccountDataType) AS AccountDataType,adt.AccountDataTypeID,MIN(esdt.SortOrder) AS SortOrder,MIN(adt.DataTypeID) AS DataTypeID
FROM AccountDataTypes adt, ExternalSystemAccountTypes esat, ExternalSystems es, ExternalSystemDataTypes esdt
	WHERE esat.AccountTypeID=AccountTypeID_
	AND esat.ExternalSystemID=es.ExternalSystemID
	AND esdt.AccountDataTypeID=adt.AccountDataTypeID
	AND es.ExternalSystemTypeID=esdt.ExternalSystemTypeID
	AND adt.AccountDataTypeID NOT IN (SELECT AccountDataTypeID FROM SubAccountDataTypes WHERE AccountTypeID=AccountTypeID_ OR AccountTypeID IS NULL)
GROUP BY adt.AccountDataTypeID
ORDER BY 6,4;
END;
/

CREATE OR REPLACE PROCEDURE SAList (crSAList1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
OPEN crSAList1 FOR SELECT sa.PackageID, pt.PackageType, AccountID,Login,sa.FirstName,sa.LastName,AccountType,sa.Email, 

CASE WHEN sa.PackageID IS NULL THEN
CASE WHEN sa.Active=1 AND sa.CancelDate IS NOT NULL THEN 'canceled' WHEN sa.Active=1 AND sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0) + sa.Extension+1,sa.ExpireDate) < sysdate THEN 'expired'
WHEN sa.Active=1 THEN 'active' ELSE 'inactive' END  
ELSE
CASE WHEN sa.Active=1 AND p.Active=1 AND (sa.CancelDate IS NOT NULL OR p.CancelDate IS NOT NULL) THEN 'canceled' WHEN sa.Active=1 AND p.Active=1 AND sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0) + COALESCE(p.Extension,sa.Extension)+1,sa.ExpireDate) < sysdate THEN 'expired'
WHEN sa.Active=1 AND p.Active=1 THEN 'active' ELSE 'inactive' END  
END AS bginfo,
CASE WHEN p.DiffCost = 1 THEN p.Cost WHEN p.DiffCost = 0 THEN pt.Cost WHEN sa.DiffCost = 1 THEN sa.Cost ELSE COALESCE(oat1.CustomerCost,at1.Cost) END AS Cost,
CASE WHEN bc.AutoBill = 2 THEN NULL ELSE COALESCE(pp2.PayPeriod,pp.PayPeriod) END AS PayPeriod, 
CASE WHEN sa.Active = 0 AND p.BilledThru IS NOT NULL THEN p.BilledThru ELSE sa.BilledThru END AS BilledThru,
CASE WHEN sa.Active = 0 AND p.ExpireDate IS NOT NULL THEN p.ExpireDate ELSE sa.ExpireDate END AS ExpireDate,
COALESCE(ma.OverDue,0) + COALESCE(p.Extension,sa.Extension) AS ExpirePlus

FROM MasterAccounts ma JOIN SubAccounts sa ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN OrgAccountTypes oat1 ON (at1.AccountTypeID = oat1.AccountTypeID AND o.OrganizationID = oat1.OrganizationID AND o.ResellerCustomerID IS NOT NULL)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN PackageTypes pt ON (p.PackageTypeID = pt.PackageTypeID)
	LEFT JOIN PayPeriods pp2 ON (p.PayPeriodID = pp2.PayPeriodID)
	WHERE ma.CustomerID=CustomerID_
	AND sa.Active >= 0
	AND (p.Active IS NULL OR p.Active >= 0)
ORDER BY COALESCE(sa.PackageID,0) ASC, Login, sa.LastName;
END;
/

CREATE OR REPLACE PROCEDURE SAOpen (crSAOpen1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER,PackageID_ IN INTEGER,StartDate_ IN DATE) AS
BEGIN
DECLARE
GroupID_ INTEGER;
Extension_ INTEGER;
FreePeriod_ INTEGER;
Breakout_ INTEGER;
CustomerID_ INTEGER;
PID_ INTEGER;
AccountTypeID_ INTEGER;
BEGIN

SELECT NumValue INTO FreePeriod_  FROM Configs WHERE ConfigID = 8;
SELECT NumValue INTO Extension_  FROM Configs WHERE ConfigID = 5;
IF (AccountID_ IS NOT NULL) THEN
SELECT 0,CustomerID,PackageID,AccountTypeID INTO Breakout_,CustomerID_,PID_,AccountTypeID_  FROM SubAccounts WHERE AccountID = AccountID_;
IF (PID_ IS NOT NULL) THEN
SELECT CASE WHEN MAX(p.Active) <= 0 THEN 1 WHEN COALESCE(MAX(pat.MaxQty),0) >= COUNT(*) THEN 0 ELSE 1 END INTO Breakout_ 

	FROM SubAccounts sa JOIN Packages p ON (sa.PackageID = p.PackageID)
		 LEFT JOIN PackageAccountTypes pat ON (p.PackageTypeID = pat.PackageTypeID AND sa.AccountTypeID = pat.AccountTypeID)
		WHERE sa.CustomerID =CustomerID_
		AND sa.AccountTypeID =AccountTypeID_
		AND sa.Active = 1
		AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate) 
		AND sa.PackageID =PID_;
END IF;

MERGE INTO SubAccounts msa
USING (SELECT sa.AccountID, 1 AS Active,
CASE WHEN Breakout_ = 1 OR p.PackageID IS NULL THEN 1 ELSE 0 END AS BillStatus, NULL AS CancelDate, NULL AS CancelReasonID,
CASE WHEN Breakout_ = 1 THEN NULL ELSE p.PackageID END AS PackageID,
CASE WHEN Breakout_ = 1 OR p.PackageID IS NULL THEN StartDate_ ELSE COALESCE(p.StartDate,sa.StartDate) END AS StartDate, 
CASE WHEN Breakout_ = 0 AND p.PackageID IS NOT NULL THEN COALESCE(p.BilledThru,sa.BilledThru) ELSE DATEADD(dd,COALESCE(cg.NumValue,FreePeriod_ ,0) - 1,StartDate_ ) END AS BilledThru,
CASE WHEN Breakout_ = 0 AND p.PackageID IS NOT NULL THEN p.ExpireDate WHEN bc.AutoBill = 1 THEN NULL ELSE DATEADD(dd,COALESCE(cg.NumValue,FreePeriod_ ,0) - 1,StartDate_ ) END AS ExpireDate,
at1.LoginLimit, at1.TimeLeft, at1.DataLeft, 
CASE WHEN bc.AutoBill = 2 THEN 0 ELSE COALESCE(bc.Extension,cg5.NumValue,Extension_ ,sa.Extension) END AS Extension
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN ConfigGroupData cg ON (g.GroupID = cg.GroupID AND cg.ConfigID = 8)
	LEFT JOIN ConfigGroupData cg5 ON (g.GroupID = cg5.GroupID AND cg5.ConfigID = 5)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.AccountID =AccountID_) sa
ON (msa.AccountID = sa.AccountID)
WHEN MATCHED THEN UPDATE SET msa.Active = sa.Active, msa.BillStatus = sa.BillStatus, msa.CancelDate = sa.CancelDate, msa.CancelReasonID = sa.CancelReasonID, msa.PackageID = sa.PackageID, msa.StartDate = sa.StartDate, msa.BilledThru = sa.BilledThru, msa.ExpireDate = sa.ExpireDate, msa.LoginLimit = sa.LoginLimit, msa.TimeLeft = sa.TimeLeft, msa.DataLeft = sa.DataLeft, msa.Extension = sa.Extension, msa.LastModifyDate = sysdate;


END IF;

IF (PackageID_ IS NOT NULL) THEN
MERGE INTO Packages mp
USING (SELECT p.PackageID, 1 AS Active, 1 AS BillStatus, NULL AS CancelDate, NULL AS CancelReasonID,StartDate_ AS StartDate, 
DATEADD(dd,COALESCE(cg.NumValue,FreePeriod_ ,0) - 1,StartDate_ ) AS BilledThru, 
CASE WHEN bc.AutoBill = 1 THEN NULL ELSE DATEADD(dd,COALESCE(cg.NumValue,FreePeriod_ ,0) - 1,StartDate_ ) END AS ExpireDate
FROM Packages p JOIN MasterAccounts ma ON (p.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cg ON (g.GroupID = cg.GroupID AND cg.ConfigID = 8)
	WHERE p.PackageID =PackageID_) p
ON (mp.PackageID = p.PackageID)
WHEN MATCHED THEN UPDATE SET mp.Active = p.Active, mp.BillStatus = p.BillStatus, mp.CancelDate = p.CancelDate, mp.CancelReasonID = p.CancelReasonID, mp.StartDate = p.StartDate, mp.BilledThru = p.BilledThru, mp.ExpireDate = p.ExpireDate, mp.LastModifyDate = sysdate;


MERGE INTO SubAccounts msa
USING (SELECT sa.AccountID, 0 AS BillStatus, COALESCE(p.Startdate,sa.StartDate) AS StartDate, COALESCE(p.BilledThru,sa.BilledThru) AS BilledThru, p.ExpireDate, at1.LoginLimit, at1.TimeLeft, at1.DataLeft,
CASE WHEN bc.AutoBill = 2 THEN 0 ELSE COALESCE(bc.Extension,cg5.NumValue,Extension_ ,sa.Extension) END AS Extension
FROM SubAccounts sa JOIN Packages p ON (sa.PackageID = p.PackageID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN ConfigGroupData cg5 ON (g.GroupID = cg5.GroupID AND cg5.ConfigID = 5)
	WHERE sa.CustomerID = p.CustomerID
	AND p.PackageID =PackageID_
	AND sa.Active = 1) sa
ON (msa.AccountID = sa.AccountID)
WHEN MATCHED THEN UPDATE SET msa.BillStatus = sa.BillStatus, msa.StartDate = sa.StartDate, msa.BilledThru = sa.BilledThru, msa.ExpireDate = sa.ExpireDate, msa.LoginLimit = sa.LoginLimit, msa.TimeLeft = sa.TimeLeft, msa.DataLeft = sa.DataLeft, msa.Extension = sa.Extension, msa.LastModifyDate = sysdate;


END IF;
OPEN crSAOpen1 FOR SELECT CASE WHEN PackageID_ IS NOT NULL THEN 1 WHEN AccountID_ IS NOT NULL AND PID_ IS NULL THEN 1 WHEN AccountID_ IS NOT NULL AND PID_ IS NOT NULL AND Breakout_ = 1 THEN 1 ELSE 0 END AS SetupInd
 FROM DUAL;
END;
END;
/

CREATE OR REPLACE PROCEDURE SAPackageCloseList (crSAPackageCloseList1 IN OUT ieatypes.CursorType,PackageID_ IN INTEGER,CancelDate_ IN DATE) AS
BEGIN
OPEN crSAPackageCloseList1 FOR SELECT ii.ItemID, ii.Amount, ii.Quantity, ii.StartDate, ii.EndDate, ii.Days, pt.ChangeClose, pt.ChangeFrom, pt.PackageTypeID, p.BilledThru, ma.CustomerID, ma.LanguageID
FROM MasterAccounts ma, Packages p, Invoices i, InvoiceItems ii, PackageTypes pt
	WHERE ma.CustomerID = p.CustomerID
	AND p.PackageID =PackageID_
	AND p.PackageTypeID = pt.PackageTypeID
	AND ma.Active = 1
	AND p.Active = 1
	AND ma.CustomerID = i.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND ii.PackageID =PackageID_
	AND ii.StartDate <> ii.EndDate
	AND ii.EndDate > CancelDate_
	AND i.VoidDate IS NULL
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ii.ItemType = 3
	AND ii.Canceled = 0
ORDER BY ii.StartDate;
END;
/

CREATE OR REPLACE PROCEDURE SAPackageUpdate (CustomerID_ IN INTEGER) AS
BEGIN
MERGE INTO Subaccounts msa
USING (SELECT sa.AccountID, p.BilledThru, p.ExpireDate
FROM MasterAccounts ma, SubAccounts sa, Packages p
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.CustomerID = p.CustomerID
	AND sa.PackageID = p.PackageID
	AND ma.Active = 1
	AND sa.Active = 1
	AND p.Active = 1
	AND ma.CustomerID =CustomerID_) sa
ON (msa.AccountID = sa.AccountID)
WHEN MATCHED THEN UPDATE SET msa.BilledThru = sa.BilledThru, msa.ExpireDate = sa.ExpireDate;


END;
/

CREATE OR REPLACE PROCEDURE SARadius (crSARadius1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER) AS
BEGIN
OPEN crSARadius1 FOR SELECT rc.RadConfigID, ra.Name, rc.Data, CASE WHEN ra.RadAttributeType <> 0 THEN COALESCE(rv.Name,CAST(rc.Value AS VARCHAR(10))) ELSE '' END AS Data2,
rc.Value, rc.RadAttributeID, rvend.Name AS VendorName,ra.RadVendorID, 
CASE WHEN rc.RadCheck=1 Then 'Check' ELSE 'Reply' END AS RadCheckStr, RadCheck, rc.Tag
FROM RadConfigs rc
LEFT JOIN RadValues rv ON (rv.Value = rc.Value AND rv.RadVendorID = rc.RadVendorID AND rv.RadAttributeID = rc.RadAttributeID)
JOIN RadAttributes ra ON (rc.RadAttributeID = ra.RadAttributeID AND rc.RadVendorID = ra.RadVendorID)
JOIN RadVendors rvend ON (rvend.RadVendorID = rc.RadVendorID)
	WHERE rc.AccountID=AccountID_
ORDER BY ra.RadVendorID, ra.RadAttributeID;
END;
/

CREATE OR REPLACE PROCEDURE SAServiceCloseList (crSAServiceCloseList1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER,CancelDate_ IN DATE) AS
BEGIN
OPEN crSAServiceCloseList1 FOR SELECT ii.ItemID, ii.Amount, ii.Quantity, ii.StartDate, ii.EndDate, ii.Days, at1.ChangeClose, at1.ChangeFrom, at1.AccountTypeID, sa.BilledThru, ma.CustomerID, ma.LanguageID
FROM MasterAccounts ma, SubAccounts sa, Invoices i, InvoiceItems ii, AccountTypes at1
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountID =AccountID_
	AND sa.AccountTypeID = at1.AccountTypeID
	AND ma.Active = 1
	AND sa.Active = 1
	AND ma.CustomerID = i.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND ii.AccountID =AccountID_
	AND ii.StartDate <> ii.EndDate
	AND ii.EndDate > DATEADD(dd,CASE WHEN DATEPART(hh,CancelDate_ ) = 0 AND DATEPART(mi,CancelDate_ ) = 0 AND DATEPART(ss,CancelDate_ ) = 0 THEN 0 ELSE -1 END,CancelDate_ )
	AND i.VoidDate IS NULL
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND ii.ItemType = 3
	AND ii.Canceled = 0
ORDER BY ii.StartDate;
END;
/

CREATE OR REPLACE PROCEDURE SAUsage (crSAUsage1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER) AS
BEGIN
OPEN crSAUsage1 FOR SELECT SUM(CASE WHEN TimeLeft > 0 THEN TimeLeft ELSE 0 END) AS TimeLeft, SUM(CASE WHEN DataLeft > 0 THEN DataLeft ELSE 0 END) AS DataLeft
FROM SubAccountUsages
	WHERE AccountID =AccountID_
	AND ExpireDate > sysdate
	AND (TimeLeft > 0 OR DataLeft > 0);
END;
/

CREATE OR REPLACE PROCEDURE ScheduleGetOnetime (crScheduleGetOnetime1 IN OUT ieatypes.CursorType,ServerID_ IN INTEGER) AS
BEGIN
OPEN crScheduleGetOnetime1 FOR SELECT ScheduleID,TaskName,Parameter,TargetSecs,MaxSecs,Status,LastStart,LastUpdate,Interval,StartDate,1 AS MaxConcurrent,Aligned
FROM Schedules
	WHERE ((ScheduleServerID IS NULL AND LockServerID =ServerID_) OR ScheduleServerID =ServerID_)
	AND ((Status = 0) OR (Status = 1 AND (LockServerID =ServerID_ OR ScheduleServerID =ServerID_)))
	AND Interval = 0
	AND Active = 1;
END;
/

CREATE OR REPLACE PROCEDURE ScheduleGetRecurring (crScheduleGetRecurring1 IN OUT ieatypes.CursorType,ServerID_ IN INTEGER) AS
BEGIN
OPEN crScheduleGetRecurring1 FOR SELECT ScheduleID,TaskName,Parameter,TargetSecs,MaxSecs,Status,LastStart,LastUpdate,Interval,StartDate,MaxConcurrent,Aligned
FROM Schedules
	WHERE ((ScheduleServerID IS NULL AND LockServerID =ServerID_) OR ScheduleServerID =ServerID_)
	AND Interval > 0
	AND Active = 1;
END;
/

CREATE OR REPLACE PROCEDURE ScheduleLocks (crScheduleLocks1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crScheduleLocks1 FOR SELECT ScheduleID,TaskName
FROM Schedules
	WHERE ScheduleServerID IS NULL 
	AND LockServerID IS NULL
	AND Active = 1;
END;
/

CREATE OR REPLACE PROCEDURE ScheduleLog (ScheduleServerID_ IN INTEGER,ScheduleID_ IN INTEGER,Status_ IN SMALLINT,Description_ IN VARCHAR2,StartDate_ IN DATE,EndDate_ IN DATE) AS
BEGIN
INSERT INTO ScheduleLogs (ScheduleServerID,ScheduleID,Status,Description,StartDate,EndDate)
VALUES(ScheduleServerID_,ScheduleID_ ,Status_ ,Description_ ,StartDate_ ,EndDate_ );
UPDATE Schedules SET LastUpdate =EndDate_,  Status =Status_, LastStatus =Description_
	WHERE ScheduleID =ScheduleID_
	AND (LastUpdate <=EndDate_ OR LastUpdate IS NULL);
END;
/

CREATE OR REPLACE PROCEDURE ScheduleSetLock (ServerID_ IN INTEGER,ScheduleID_ IN INTEGER) AS
BEGIN
UPDATE Schedules SET LockServerID =ServerID_ 
	WHERE ScheduleServerID IS NULL 
	AND LockServerID IS NULL 
	AND ScheduleID =ScheduleID_;
END;
/

CREATE OR REPLACE PROCEDURE ScheduleStaleLocks AS
BEGIN
UPDATE Schedules SET LockServerID = NULL
	WHERE ScheduleServerID IS NULL
	AND LockServerID IS NOT NULL
	AND ((Interval = 0 AND Status = 0 AND DATEADD(hh,1,StartDate) < sysdate) 
		OR (Status = 1 AND DATEADD(hh,1,LastUpdate) < sysdate) 
		OR (Interval > 0 AND Status <> 1 AND LastUpdate < DATEADD(hh,-1,DATEADD(ss,-(Interval),sysdate)))
	);
UPDATE Schedules SET LockServerID = NULL WHERE ScheduleServerID IS NOT NULL AND LockServerID IS NOT NULL;
END;
/

CREATE OR REPLACE PROCEDURE ScheduleStatusClear (servername_ IN VARCHAR2) AS
BEGIN
UPDATE Schedules SET Status = 0
WHERE ScheduleID IN (SELECT s.ScheduleID 
FROM Schedules s, ScheduleServers ss 
	WHERE Status = 1 
	AND (s.ScheduleServerID = ss.ScheduleServerID OR s.LockServerID = ss.ScheduleServerID) 
	AND ss.Server =servername_);
END;
/

CREATE OR REPLACE PROCEDURE SecurityGetAllowedHosts (crSecurityGetAllowedHosts1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crSecurityGetAllowedHosts1 FOR SELECT OperatorGroupID,IPAddress
FROM AllowedHosts;
END;
/

CREATE OR REPLACE PROCEDURE SecurityGetGroupAccess (crSecurityGetGroupAccess1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crSecurityGetGroupAccess1 FOR SELECT OperatorGroupID,GroupID,ObjectGroupID,AccessType
FROM OperatorGroupAccess;
END;
/

CREATE OR REPLACE PROCEDURE SecurityGetObjectGroups (crSecurityGetObjectGroups1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crSecurityGetObjectGroups1 FOR SELECT DISTINCT ObjectGroupID,ObjectTypeID,Data,NULL AS Value
FROM Objects
	WHERE ObjectTypeID = 1
UNION ALL
SELECT DISTINCT ObjectGroupID,ObjectTypeID, mt.TableName, o.Value
FROM Objects o, MetaTables mt
	WHERE o.ObjectTypeID = 2
	AND mt.MetaTableID = o.Value
UNION ALL
SELECT DISTINCT ObjectGroupID,ObjectTypeID, mt.TableName || '.' || mc.ColumnName, o.Value
FROM Objects o, MetaTables mt, MetaColumns mc
	WHERE o.ObjectTypeID = 3
	AND mc.MetaColumnID = o.Value
	AND mc.MetaTableID = mt.MetaTableID;
END;
/

CREATE OR REPLACE PROCEDURE SetMetaColumnRule (tabname_ IN VARCHAR2,colname_ IN VARCHAR2,ruleid_ IN INTEGER) AS
BEGIN
UPDATE MetaColumns SET MetaRuleID=ruleid_
WHERE MetaColumnID IN (SELECT mc.MetaColumnID
FROM MetaColumns mc, MetaTables mt
	WHERE mc.MetaTableID = mt.MetaTableID 
	AND mt.TableName =tabname_ 
	AND mc.ColumnName =colname_);
END;
/

CREATE OR REPLACE PROCEDURE SetMetaTableKey (tabname_ IN VARCHAR2,colname_ IN VARCHAR2,req_ IN INTEGER) AS
BEGIN
UPDATE MetaColumns SET IsKey=1, Required=req_, Nullable=0 
WHERE MetaColumnID IN (SELECT mc.MetaColumnID
FROM MetaColumns mc, MetaTables mt
	WHERE mc.MetaTableID = mt.MetaTableID 
	AND mt.TableName =tabname_ 
	AND mc.ColumnName =colname_);
END;
/

CREATE OR REPLACE PROCEDURE ShowBillingSend (crShowBillingSend1 IN OUT ieatypes.CursorType,OperatorGroupID_ IN INTEGER) AS
BEGIN
DECLARE
batchglobal_ INTEGER;
zerostmt_ INTEGER;
zeroinv_ INTEGER;
BEGIN
IF (OperatorGroupID_ = 1) THEN
SELECT 1 INTO batchglobal_ 

 FROM DUAL;
ELSE
SELECT COUNT(*)  INTO batchglobal_ 

FROM OperatorGroupAccess 
	WHERE ObjectGroupID = 106 
	AND OperatorGroupID =OperatorGroupID_ 
	AND GroupID = 1;
END IF;

SELECT NumValue INTO zerostmt_  FROM Configs WHERE ConfigID = 38;
SELECT NumValue INTO zeroinv_  FROM Configs WHERE ConfigID = 507;

INSERT INTO sbstmp (GroupID, Type, PrintCount, PrintAmount, EmailCount, EmailAmount,AutoSend)
SELECT ma.GroupID, 20 AS Type,
SUM(CASE WHEN g.PrintStatements = 2 THEN 0 WHEN (ma.PaymentTypeID IN (8,16) AND sm.PrintAutoTrans = 0) OR s.PrintBatchID IS NOT NULL OR (COALESCE(cgd.NumValue,zerostmt_ ) = 0 AND s.EndBal <= 0) OR sm.PrintTypeID IS NULL OR s.PrintDate IS NOT NULL THEN 0 ELSE 1 END) AS PrintCount,
SUM(CASE WHEN g.PrintStatements = 2 THEN 0 WHEN (ma.PaymentTypeID IN (8,16) AND sm.PrintAutoTrans = 0) OR s.PrintBatchID IS NOT NULL OR (COALESCE(cgd.NumValue,zerostmt_ ) = 0 AND s.EndBal <= 0) OR sm.PrintTypeID IS NULL OR s.PrintDate IS NOT NULL THEN 0 ELSE s.EndBal END) AS PrintAmount,
SUM(CASE WHEN g.AutoEmailStatements = 3 OR (ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 0) OR (COALESCE(cgd.NumValue,zerostmt_ ) = 0 AND s.EndBal <= 0) OR sm.EmailTypeID IS NULL OR s.EmailDate IS NOT NULL THEN 0 ELSE 1 END) AS EmailCount,
SUM(CASE WHEN g.AutoEmailStatements = 3 OR (ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 0) OR (COALESCE(cgd.NumValue,zerostmt_ ) = 0 AND s.EndBal <= 0) OR sm.EmailTypeID IS NULL OR s.EmailDate IS NOT NULL THEN 0 ELSE s.EndBal END) AS EmailAmount,
MAX(CASE WHEN g.AutoEmailStatements = 1 THEN 1 ELSE 0 END) AS AutoSend
FROM MasterAccounts ma JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Statements s ON (ma.LastStatementID = s.StatementID AND ma.CustomerID = s.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 38)
	WHERE ma.Active = 1
	AND (s.EmailDate IS NULL OR (s.PrintDate IS NULL AND g.PrintStatements IS NULL))
	AND (batchglobal_ = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 106 AND OperatorGroupID =OperatorGroupID_))
GROUP BY ma.GroupID
UNION ALL
SELECT ma.GroupID, 10 AS Type,
SUM(CASE WHEN g.PrintInvoices = 2 THEN 0 WHEN (ma.PaymentTypeID IN (8,16) AND sm.PrintAutoTrans = 0) OR i.PrintBatchID IS NOT NULL OR (COALESCE(cgd.NumValue,zeroinv_ ) = 0 AND i.Amount <= 0) OR sm.PrintTypeID IS NULL OR i.PrintDate IS NOT NULL THEN 0 ELSE 1 END) AS PrintCount,
SUM(CASE WHEN g.PrintInvoices = 2 THEN 0 WHEN (ma.PaymentTypeID IN (8,16) AND sm.PrintAutoTrans = 0) OR i.PrintBatchID IS NOT NULL OR (COALESCE(cgd.NumValue,zeroinv_ ) = 0 AND i.Amount <= 0) OR sm.PrintTypeID IS NULL OR i.PrintDate IS NOT NULL THEN 0 ELSE i.Amount END) AS PrintAmount,
SUM(CASE WHEN g.AutoEmailInvoices = 3 OR (ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 0) OR (COALESCE(cgd.NumValue,zeroinv_ ) = 0 AND i.Amount <= 0) OR sm.EmailTypeID IS NULL OR i.EmailDate IS NOT NULL THEN 0 ELSE 1 END) AS EmailCount,
SUM(CASE WHEN g.AutoEmailInvoices = 3 OR (ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 0) OR (COALESCE(cgd.NumValue,zeroinv_ ) = 0 AND i.Amount <= 0) OR sm.EmailTypeID IS NULL OR i.EmailDate IS NOT NULL THEN 0 ELSE i.Amount END) AS EmailAmount,
MAX(CASE WHEN g.AutoEmailInvoices = 1 THEN 1 ELSE 0 END) AS AutoSend
FROM MasterAccounts ma JOIN SendMethods sm ON (ma.SendMethodID = sm.SendMethodID)
	JOIN Invoices i ON (ma.CustomerID = i.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 507)
	WHERE ma.Active = 1
	AND i.CreateDate > DATEADD(dd,-45,sysdate)
	AND i.VoidDate IS NULL
	AND (i.EmailDate IS NULL OR (i.PrintDate IS NULL AND g.PrintInvoices IS NULL))
	AND (batchglobal_ = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID = 106 AND OperatorGroupID =OperatorGroupID_))
GROUP BY ma.GroupID;
INSERT INTO sbstmp (GroupID,Type,PrintCount,EmailCount,PrintAmount,EmailAmount)
SELECT NULL AS GroupID, Type, SUM(PrintCount) AS PrintCount, SUM(EmailCount) AS EmailCount, SUM(PrintAmount) AS PrintAmount, SUM(EmailAmount) AS EmailAmount
FROM sbstmp GROUP BY Type;
OPEN crShowBillingSend1 FOR SELECT DISTINCT NULL AS GroupID, NULL AS Organization, NULL AS GroupName, 'billing_type' AS Class, 1 AS SendType, 20 AS Type, NULL AS Cnt, NULL AS Amt 
FROM sbstmp t
	WHERE PrintCount > 0 
	AND Type = 20
UNION ALL
SELECT g.GroupID, o.Organization, g.GroupName, NULL AS Class, 1 AS SendType, Type, PrintCount AS Cnt, PrintAmount AS Amt
FROM sbstmp t, Groups g, Organizations o
	WHERE t.GroupID = g.GroupID
	AND g.OrganizationID = o.OrganizationID
	AND t.PrintCount > 0
	AND t.Type = 20
UNION ALL
SELECT DISTINCT NULL AS GroupID, NULL AS Organization, NULL AS GroupName, 'billing_type' AS Class, 2 AS SendType, 20 AS Type, NULL AS Cnt, NULL AS Amt 
FROM sbstmp 
	WHERE EmailCount > 0 
	AND Type = 20
UNION ALL
SELECT g.GroupID, o.Organization, g.GroupName, CASE WHEN g.GroupID IS NULL THEN 'billing_all' WHEN t.AutoSend = 1 THEN 'inactive' ELSE NULL END AS Class, 2 AS SendType, Type, EmailCount AS Cnt, EmailAmount AS Amt
FROM sbstmp t LEFT JOIN Groups g ON (t.GroupID = g.GroupID)
	LEFT JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	WHERE t.EmailCount > 0
	AND t.Type = 20
UNION ALL
SELECT DISTINCT NULL AS GroupID, NULL AS Organization, NULL AS GroupName, 'billing_type' AS Class, 1 AS SendType, 10 AS Type, NULL AS Cnt, NULL AS Amt 
FROM sbstmp 
	WHERE PrintCount > 0 
	AND Type = 10
UNION ALL
SELECT g.GroupID, o.Organization, g.GroupName, NULL AS Class, 1 AS SendType, Type, PrintCount AS Cnt, PrintAmount AS Amt
FROM sbstmp t, Groups g, Organizations o
	WHERE t.GroupID = g.GroupID
	AND g.OrganizationID = o.OrganizationID
	AND t.PrintCount > 0
	AND t.Type = 10
UNION ALL
SELECT DISTINCT NULL AS GroupID, NULL AS Organization, NULL AS GroupName, 'billing_type' AS Class, 2 AS SendType, 10 AS Type, NULL AS Cnt, NULL AS Amt 
FROM sbstmp 
	WHERE EmailCount > 0 
	AND Type = 10
UNION ALL
SELECT g.GroupID, o.Organization, g.GroupName, CASE WHEN g.GroupID IS NULL THEN 'billing_all' WHEN t.AutoSend = 1 THEN 'inactive' ELSE NULL END AS Class, 2 AS SendType, Type, EmailCount AS Cnt, EmailAmount AS Amt
FROM sbstmp t LEFT JOIN Groups g ON (t.GroupID = g.GroupID)
	LEFT JOIN Organizations o ON (g.OrganizationID = o.OrganizationID)
	WHERE t.EmailCount > 0
	AND t.Type = 10;
DELETE FROM sbstmp;
END;
END;
/

CREATE OR REPLACE PROCEDURE ShowDuplicateLogins (crShowDuplicateLogins1 IN OUT ieatypes.CursorType,sdate_ IN DATE,edate_ IN DATE) AS
BEGIN
OPEN crShowDuplicateLogins1 FOR Select rl.LogDate, rl.Username, rl.NASIdentifier as FNASID, rl.NASPort as FPort,
	c.NASIdentifier as ONASIdentifier, c.NASPort as OPort, c.AcctSessionID as ASID,
	DATEADD(ss, 0-c.AcctSessionTime, c.CallDate) as OnlineStart, CallDate as OnlineEnd,
	AcctSessionTime/60 as Mins, rl.CallerID as FCallerID, c.CallerID as OCallerID
From RadLogs rl, Calls c
Where rl.Username = c.Username
	and c.AcctStatusType = 2
	and c.CallDate >= rl.LogDate
	and DateAdd(ss, 0-c.AcctSessionTime, c.CallDate) <= rl.LogDate
	and rl.RadLogMsgID = 14 
	and rl.LogDate between sdate_ and edate_
	and c.CallDate between DateAdd(dd, -1,sdate_ ) and DateAdd(dd, 1,edate_ )
UNION
Select rl.LogDate, rl.Username, rl.NASIdentifier as FNASID, rl.NASPort as FPort,
	c.NASIdentifier as ONASIdentifier, c.Port as OPort, c.AcctSessionID as ASID,
	c.CallDate as OnlineStart, CallDate as OnlineEnd,
	DateDiff(ss,CallDate, sysdate) as Mins, rl.CallerID as FCallerID, c.CallerID as OCallerID
From RadLogs rl, ServerPorts c
Where rl.Username = c.Username
	and c.AcctStatusType = 1
	and c.CallDate <= rl.LogDate
	and rl.RadLogMsgID = 14 
	and rl.LogDate between sdate_ and edate_
	and c.CallDate between DateAdd(dd, -1,sdate_ ) and DateAdd(dd, 1,edate_ )
ORDER BY 1, 7;
END;
/

CREATE OR REPLACE PROCEDURE SPIDQuery (crSPIDQuery1 IN OUT ieatypes.CursorType,spid_ IN INTEGER) AS
BEGIN
OPEN crSPIDQuery1 FOR SELECT 'N/A'
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE StatementAdd (crStatementAdd1 IN OUT ieatypes.CursorType,BatchID_ IN INTEGER,CustomerID_ IN INTEGER,PrevBal_ IN NUMERIC,NewCharges_ IN NUMERIC,NewCredits_ IN NUMERIC,EndBal_ IN NUMERIC) AS
BEGIN
INSERT INTO Statements (BatchID,CustomerID,StatementDate,PrevBal,NewCharges,NewCredits,EndBal,End0Bal,End30Bal,End60Bal,End90Bal,End120Bal)
VALUES(BatchID_,CustomerID_ ,sysdate,PrevBal_ ,NewCharges_ ,NewCredits_ ,EndBal_ ,0,0,0,0,0);
OPEN crStatementAdd1 FOR SELECT LAST.IDENT AS StatementID
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE StatementEmailList (crStatementEmailList1 IN OUT ieatypes.CursorType,GroupID_ IN INTEGER,OperatorGroupID_ IN INTEGER,MBRGlobal_ IN INTEGER) AS
BEGIN

OPEN crStatementEmailList1 FOR SELECT g.BillPhone, g.BillFax, ma.Company, ma.FirstName, ma.LastName, g.BillName, ma.CustomerID, s.StatementID, CASE WHEN sm.EmailTypeID = 16 THEN COALESCE(g.StatementTextReport,'estatement.rpt') ELSE COALESCE(g.StatementReport,'statement.rpt') END AS ReportFile,
'{Statements.StatementID}=' || CAST(s.StatementID AS VARCHAR(16)) AS Formula
FROM MasterAccounts ma, SendMethods sm, Statements s, Groups g
	WHERE ma.SendMethodID = sm.SendMethodID
	AND ma.Active = 1
	AND ma.LastStatementID = s.StatementID
	AND s.EmailDate IS NULL
	AND sm.EmailTypeID IS NOT NULL
	AND g.AutoEmailStatements IN (0,1)
	AND ma.GroupID = g.GroupID
	AND ((ma.PaymentTypeID IN (8,16) AND sm.EmailAutoTrans = 1) OR ma.PaymentTypeID NOT IN (8,16))
	AND (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND ((OperatorGroupID_ IS NULL AND g.AutoEmailStatements = 1) OR (OperatorGroupID_ IS NOT NULL AND (COALESCE(MBRGlobal_,1) = 1 OR ma.GroupID IN (SELECT GroupID FROM OperatorGroupAccess WHERE ObjectGroupID=106 AND OperatorGroupID=OperatorGroupID_))));
END;
/

CREATE OR REPLACE PROCEDURE StatementEmailSent (CustomerID_ IN INTEGER,StatementID_ IN INTEGER) AS
BEGIN
UPDATE Statements SET EmailDate=sysdate WHERE EmailDate IS NULL AND StatementID =StatementID_;
INSERT INTO MailLogs (LogDate, LogMsgID, CustomerID, TokenID) 
VALUES(sysdate, 1002,CustomerID_ ,StatementID_ );
END;
/

CREATE OR REPLACE PROCEDURE StatementItems (crStatementItems1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
OPEN crStatementItems1 FOR SELECT 1 AS ItemType, i.InvoiceID AS ItemID, ii.Amount * Quantity AS Amount, ii.Login AS Info, ii.Description, ii.StartDate, ii.EndDate
FROM Invoices i, InvoiceTypes it, InvoiceItems ii
	WHERE i.CustomerID =CustomerID_
	AND i.InvoiceID = ii.InvoiceID
	AND i.InvoiceTypeID = it.InvoiceTypeID
	AND i.VoidDate IS NULL
	AND i.StatementID IS NULL
 UNION ALL
SELECT 0 AS ItemType, p.PaymentID AS ItemID, p.Amount, p.PayInfo AS Info, pt.PaymentType || '  Payment ' || p.CheckNumber AS Description, p.CreateDate AS StartDate, NULL AS EndDate
FROM Payments p, PaymentTypes pt
	WHERE p.PaymentTypeID = pt.PaymentTypeID
	AND p.CustomerID =CustomerID_
	AND p.StatementID IS NULL
ORDER BY 1, 6;
END;
/

CREATE OR REPLACE PROCEDURE StatementPreview (crStatementPreview1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN

OPEN crStatementPreview1 FOR SELECT 0 AS SortOrder, pt.PaymentType AS Type, pt.StringID AS TypeStringID, PaymentID AS ID, CASE WHEN p.FinalAmount = 0 THEN 1 ELSE 0 END AS Void,
CASE WHEN FinalAmount IS NOT NULL AND StatementID IS NOT NULL THEN p.FinalAmount - p.Amount WHEN FinalAmount IS NOT NULL THEN FinalAmount ELSE Amount END AS Credit, NULL AS Charge,
CASE WHEN p.FinalAmount IS NOT NULL THEN p.FinalCreateDate ELSE p.CreateDate END AS CreateDate, NULL AS StartDate, NULL AS EndDate,
p.CheckNumber, p.PayInfo, NULL AS Login, NULL AS Description
FROM Payments p, PaymentTypes pt
	WHERE p.CustomerID =CustomerID_
	AND p.PaymentTypeID = pt.PaymentTypeID
	AND (StatementID IS NULL OR FinalAmount IS NOT NULL AND FinalStatementID IS NULL)

UNION ALL

SELECT 1 AS SortOrder, iit.InvoiceItemType AS Type, iit.StringID AS TypeStringID, i.InvoiceID AS ID, CASE WHEN i.VoidDate IS NOT NULL THEN 1 ELSE 0 END AS Void,
CASE WHEN ii.ItemType = 1 THEN ROUND(ii.Amount * ii.Quantity,2) WHEN ii.Amount * ii.Quantity < 0 THEN -(ROUND(ii.Amount * ii.Quantity,2)) ELSE NULL END AS Credit,
CASE WHEN ii.ItemType <> 1 AND ii.Amount * ii.Quantity >= 0 THEN ROUND(ii.Amount * ii.Quantity,2) ELSE NULL END AS Charge,
NULL AS CreateDate, ii.StartDate, ii.EndDate, NULL AS CheckNumber, NULL AS PayInfo, ii.Login, ii.Description

FROM Invoices i, InvoiceItems ii, InvoiceItemTypes iit
	WHERE i.InvoiceID = ii.InvoiceID
	AND i.Processed = 1
	AND i.Estimate = 0
	AND ii.ItemType = iit.InvoiceItemTypeID
	AND (i.StatementID IS NULL OR i.VoidDate IS NOT NULL AND i.VoidStatementID IS NULL)
	AND i.CustomerID =CustomerID_
ORDER BY 1, 4, 2;
END;
/

CREATE OR REPLACE PROCEDURE StringsGet (crStringsGet1 IN OUT ieatypes.CursorType,appname_ IN VARCHAR2,ver_ IN INTEGER) AS
BEGIN
OPEN crStringsGet1 FOR SELECT s.StringID, CASE s.LanguageID WHEN 1 THEN NULL ELSE s.LanguageID END as LanguageID, a.AppName, s.Data, NULL AS URL, l.BaseURL
FROM Applications a, Strings s, Languages l
WHERE a.ApplicationID = s.ApplicationID
	AND s.LanguageID = l.LanguageID
	AND (a.ApplicationID = 1 OR a.AppName =appname_);
END;
/

CREATE OR REPLACE PROCEDURE SysLog (crc_ IN SMALLINT,severity_ IN SMALLINT,facility_ IN SMALLINT,srcip_ IN VARCHAR2,date_ IN DATE,msg_ IN VARCHAR2) AS
BEGIN
INSERT INTO SysLogs (LogDate,Severity,Facility,IPAddress,Data)
VALUES(date_,severity_ ,facility_ ,srcip_ ,msg_ );
END;
/

CREATE OR REPLACE PROCEDURE SysLogGetFilter (crSysLogGetFilter1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crSysLogGetFilter1 FOR SELECT IPAddress,Severity,SubString 
FROM SysLogFilters;
END;
/

CREATE OR REPLACE PROCEDURE TaskES (crTaskES1 IN OUT ieatypes.CursorType,esid_ IN INTEGER) AS
BEGIN
OPEN crTaskES1 FOR SELECT et.ExportID, e.FormatDefault AS Type, COALESCE(et.LogFile,e.DefaultProcessorURL) AS LogFile, et.FileMode, et.Name, et.Login, et.Password
FROM ExternalSystems et, Exports e 
	WHERE et.ExportID = e.ExportID
	AND et.ExternalSystemID =esid_;
END;
/

CREATE OR REPLACE PROCEDURE TaskESUpdate (esid_ IN INTEGER,date_ IN DATE) AS
BEGIN
UPDATE ExternalSystems SET LastSyncDate =date_ 
	WHERE ExternalSystemID =esid_;
END;
/

CREATE OR REPLACE PROCEDURE TaxesGet (crTaxesGet1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crTaxesGet1 FOR SELECT t.TaxTypeID, tgt.TaxGroupID, t.TaxID, t.TaxExemptions, tgt.StateID, tgt.CountryID, tgt.RegionID, tgt.City, tgt.Zip, t.Description, t.StringID, t.Tax, t.AmountType, t.CumulativeType, t.FloorLimit, t.CeilingLimit, t.TaxPiggyBackID, t.TaxPigOrder, t.TaxCredits
FROM TaxGroupTaxes tgt, Taxes t
	WHERE tgt.TaxID = t.TaxID
ORDER BY tgt.TaxGroupID, t.TaxTypeID, CASE WHEN tgt.StateID IS NOT NULL THEN 1 ELSE 0 END + CASE WHEN tgt.RegionID IS NOT NULL THEN 1 ELSE 0 END + CASE WHEN tgt.City IS NOT NULL AND tgt.Zip IS NOT NULL THEN 3 WHEN tgt.City IS NOT NULL THEN 1 WHEN tgt.Zip IS NOT NULL THEN 2 ELSE 0 END ASC, t.TaxPiggyBackID DESC, t.TaxPigOrder DESC;
END;
/

CREATE OR REPLACE PROCEDURE ThemeGet (crThemeGet1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crThemeGet1 FOR SELECT t.Theme, ThemeMatchTypeID, Data, Score
FROM ThemeFilters tf, Themes t
	WHERE t.ThemeID = tf.ThemeID
UNION ALL
SELECT t.Theme, 6 AS ThemeMatchTypeID, CAST(g.GroupID AS VARCHAR(32)) AS Data, 1000100 AS Score
FROM Groups g, Themes t
	WHERE g.ThemeID = t.ThemeID
UNION ALL
SELECT t.Theme, 5 AS ThemeMatchTypeID, CAST(o.OperatorID AS VARCHAR(32)) AS Data, 1000000 AS Score
FROM Operators o, Themes t
	WHERE o.ThemeID = t.ThemeID;
END;
/

CREATE OR REPLACE PROCEDURE ThemeDetail (crThemeDetail1 IN OUT ieatypes.CursorType,ThemeID_ IN INTEGER) AS
BEGIN
OPEN crThemeDetail1 FOR SELECT tf.ThemeFilter,tmt.ThemeMatchType,tf.Data,tf.Score
FROM ThemeFilters tf, ThemeMatchTypes tmt
	WHERE tf.ThemeMatchTypeID = tmt.ThemeMatchTypeID
	AND tf.ThemeID =ThemeID_
UNION ALL
SELECT 'Billing Groups','Group Match',GroupName, 1000100 AS Score
FROM Groups
	WHERE ThemeID =ThemeID_
UNION ALL
SELECT 'Operators','Operator Match',Operator, 1000000 AS Score
FROM Operators
	WHERE ThemeID =ThemeID_;
END;
/

CREATE OR REPLACE PROCEDURE TrimCalls AS
BEGIN
DECLARE
stoponly_ INTEGER;
calls_ INTEGER;
MaxCallID_ NUMBER(38);
stopdate_ DATE;
callsdate_ DATE;
BEGIN
SELECT NumValue INTO calls_  FROM Configs WHERE ConfigID = 205;
SELECT NumValue INTO stoponly_  FROM Configs WHERE ConfigID = 206;
SELECT DATEADD(dd,-(stoponly_),sysdate),DATEADD(dd,-(calls_),sysdate) INTO stopdate_,callsdate_ 


 FROM DUAL;

INSERT INTO trimaxelist (CallID)
SELECT CallID FROM Calls WHERE AcctStatusType IN (1,3) AND CallDate < stopdate_ AND stoponly_ > 0 AND stoponly_ IS NOT NULL
UNION
SELECT CallID FROM Calls WHERE CallDate < callsdate_ AND calls_ > 0 AND calls_ IS NOT NULL;
DELETE FROM Calls WHERE CallID IN (SELECT CallID FROM trimaxelist);
DELETE FROM Calls WHERE CallDate BETWEEN DATEADD(dd,-4,sysdate) AND DATEADD(hh,-2,sysdate) AND AcctStatusType NOT IN (1,2);

IF (calls_ > 60) THEN
DELETE FROM VoiceCalls WHERE CallDate < callsdate_;
END IF;

DELETE FROM trimaxelist;
END;
END;
/

CREATE OR REPLACE PROCEDURE TrimLogs AS
BEGIN
DECLARE
radlogs_ INTEGER;
auditlogs_ INTEGER;
syslogs_ INTEGER;
logs_ INTEGER;
schedlogs_ INTEGER;
serverports_ INTEGER;
ftplogs_ INTEGER;
transdays_ INTEGER;
inactdays_ INTEGER;
BEGIN
SELECT NumValue INTO radlogs_  FROM Configs WHERE ConfigID = 200;
SELECT NumValue INTO schedlogs_  FROM Configs WHERE ConfigID = 201;
SELECT NumValue INTO auditlogs_  FROM Configs WHERE ConfigID = 202;
SELECT NumValue INTO syslogs_  FROM Configs WHERE ConfigID = 203;
SELECT NumValue INTO logs_  FROM Configs WHERE ConfigID = 204;
SELECT NumValue INTO serverports_  FROM Configs WHERE ConfigID = 207;
SELECT NumValue INTO ftplogs_  FROM Configs WHERE ConfigID = 208;
SELECT NumValue INTO transdays_  FROM Configs WHERE ConfigID = 209;
SELECT NumValue INTO inactdays_  FROM Configs WHERE ConfigID = 210;
IF (radlogs_ IS NOT NULL AND radlogs_ <> 0) THEN
	DELETE FROM RadLogs WHERE LogDate < DATEADD(dd,-(radlogs_),sysdate);
END IF;
IF (auditlogs_ IS NOT NULL AND auditlogs_ <> 0) THEN
	DELETE FROM AuditLogs WHERE LogDate < DATEADD(dd,-(auditlogs_),sysdate) ;
END IF;
IF (syslogs_ IS NOT NULL AND syslogs_ <> 0) THEN
	DELETE FROM SysLogs WHERE LogDate < DATEADD(dd,-(syslogs_),sysdate) ;
END IF;
IF (logs_ IS NOT NULL AND logs_ <> 0) THEN
	DELETE FROM Logs WHERE LogDate < DATEADD(dd,-(logs_),sysdate) ;
END IF;
IF (schedlogs_ IS NOT NULL AND schedlogs_ <> 0) THEN
	DELETE FROM ScheduleLogs WHERE EndDate < DATEADD(dd,-(schedlogs_),sysdate);
	DELETE FROM ScheduleLogs WHERE ScheduleID IN (SELECT ScheduleID FROM Schedules WHERE Interval = 0 AND (StartDate IS NULL OR StartDate < DATEADD(dd,-(schedlogs_),sysdate)) AND LastModifyDate < DATEADD(dd,-(schedlogs_),sysdate));
	DELETE FROM Schedules WHERE Interval = 0 AND (StartDate IS NULL OR StartDate < DATEADD(dd,-(schedlogs_),sysdate)) AND LastModifyDate < DATEADD(dd,-(schedlogs_),sysdate);
END IF;
IF (serverports_ IS NOT NULL AND serverports_ <> 0) THEN
	DELETE FROM ServerPorts
		WHERE CallDate < DATEADD(dd,-(serverports_),sysdate)
		AND (SNMPUser IS NULL OR DATALENGTH(SNMPUser) <= 10 OR CallDate < DATEADD(dd,-365,sysdate))
		AND AcctStatusType = 2
		AND (Port IS NULL OR Port NOT IN (SELECT sa.Port FROM ServerAccess sa WHERE ServerPorts.Port = sa.Port AND sa.ServerID = ServerPorts.ServerID));
END IF;
IF (ftplogs_ IS NOT NULL AND ftplogs_ <> 0) THEN
	DELETE FROM FileTransfers WHERE TransferDate < DATEADD(dd,-(ftplogs_),sysdate);
END IF;

DELETE FROM OperatorCookies WHERE LastUsed < DATEADD(dd,-3,sysdate);
UPDATE RadIPAddresses SET AccountID = NULL, State = 0 WHERE AccountID IN (SELECT sa.AccountID
FROM MasterAccounts ma, SubAccounts sa, RadIPAddresses ria
	WHERE ma.CustomerID = sa.CustomerID
	AND ria.AccountID = sa.AccountID
	AND (ma.Active IN (0,-1) OR sa.Active IN (0,-1) OR ma.CancelDate < DATEADD(dd,-1,sysdate) OR sa.CancelDate < DATEADD(dd,-1,sysdate)));
MERGE INTO SubAccounts msa
USING (SELECT sa.AccountID, g.DomainID
FROM SubAccounts sa, MasterAccounts ma, Groups g, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND ma.GroupID = g.GroupID
	AND sa.DomainID = d.DomainID
	AND ma.Active = -1
	AND d.CustomerID IS NOT NULL) sa
ON (msa.AccountID = sa.AccountID)
WHEN MATCHED THEN UPDATE SET msa.DomainID = sa.DomainID;


IF (transdays_ > 0) THEN
UPDATE ExternalTrans SET AccountNumber = NULL, SSN = NULL, DLNumber = NULL, AuthSecurityCode = NULL
	WHERE TransStateID IN (3,8,9)
	AND COALESCE(ProcDate,ReqDate) < DATEADD(dd,-transdays_,sysdate)
	AND (AccountNumber IS NOT NULL OR SSN IS NOT NULL OR DLNumber IS NOT NULL OR AuthSecurityCode IS NOT NULL);
UPDATE ExternalTrans SET AccountNumber = NULL, SSN = NULL, DLNumber = NULL, AuthSecurityCode = NULL
	WHERE TransStateID = 4
	AND COALESCE(ProcDate,ReqDate) < DATEADD(dd,-CASE WHEN transdays_ < 180 THEN 180 ELSE transdays_ END,sysdate)
	AND (AccountNumber IS NOT NULL OR SSN IS NOT NULL OR DLNumber IS NOT NULL OR AuthSecurityCode IS NOT NULL);
END IF;

IF (inactdays_ > 0) THEN
MERGE INTO ExternalTrans met
USING (SELECT et.ExternalTransID
FROM ExternalTrans et, MasterAccounts ma
	WHERE ma.CustomerID = et.CustomerID
	AND (et.AccountNumber IS NOT NULL OR et.SSN IS NOT NULL OR et.DLNumber IS NOT NULL OR et.AuthSecurityCode IS NOT NULL)
	AND ma.Active IN (0,-1)
	AND ma.LastModifyDate < DATEADD(dd,-inactdays_,sysdate)) et
ON (met.ExternalTransID = et.ExternalTransID)
WHEN MATCHED THEN UPDATE SET met.AccountNumber = NULL, met.SSN = NULL, met.DLNumber = NULL, met.AuthSecurityCode = NULL;


MERGE INTO SubAccounts msa
USING (SELECT sa.AccountID
FROM SubAccounts sa, MasterAccounts ma
	WHERE ma.CustomerID = sa.CustomerID
	AND (sa.Active IN (0,-1) OR ma.Active IN (0,-1))
	AND sa.Password IS NOT NULL
	AND ma.LastModifyDate < DATEADD(dd,-inactdays_,sysdate)
	AND sa.LastModifyDate < DATEADD(dd,-inactdays_,sysdate)) sa
ON (msa.AccountID = sa.AccountID)
WHEN MATCHED THEN UPDATE SET msa.Password = NULL;


DELETE FROM CreditCards WHERE CustomerID IN (SELECT CustomerID FROM MasterAccounts ma
	WHERE ma.Active IN (0,-1)
	AND ma.LastModifyDate < DATEADD(dd,-inactdays_,sysdate));
DELETE FROM BankTrans WHERE CustomerID IN (SELECT CustomerID FROM MasterAccounts ma
	WHERE ma.Active IN (0,-1)
	AND ma.LastModifyDate < DATEADD(dd,-inactdays_,sysdate));
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE Update_TimeLeft (accountid_ IN INTEGER,customerid_ IN INTEGER) AS
BEGIN
DECLARE
option_ INTEGER;
counter_ INTEGER;
BEGIN

SELECT NumValue INTO option_  FROM Configs WHERE ConfigID = 504;
SELECT COALESCE(option_,1) INTO option_ 


 FROM DUAL;

IF (accountid_ IS NULL AND customerid_ IS NULL) THEN

INSERT INTO utsa (AccountID, TimeLeft, DataLeft)
SELECT sa.AccountID, CASE WHEN sa.TimeLeft < 0 THEN sa.TimeLeft END, CASE WHEN sa.DataLeft < 0 THEN sa.DataLeft END
FROM MasterAccounts ma, SubAccounts sa
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.Active = 1
	AND sa.Active = 1
	AND (sa.TimeLeft < 0 OR sa.DataLeft < 0)
UNION ALL
SELECT sau.AccountID, CASE WHEN sau.TimeLeft < 0 THEN sau.TimeLeft ELSE 0 END, CASE WHEN sau.DataLeft < 0 THEN sau.DataLeft ELSE 0 END
FROM SubAccountUsages sau
	WHERE (TimeLeft < 0 OR DataLeft < 0);
UPDATE SubAccounts SET TimeLeft = CASE WHEN TimeLeft < 0 THEN 0 ELSE TimeLeft END, DataLeft = CASE WHEN DataLeft < 0 THEN 0 ELSE DataLeft END
	WHERE Active = 1
	AND (TimeLeft < 0 OR DataLeft < 0);
counter_ := SQL%ROWCOUNT;

WHILE (counter_ > 0) LOOP

UPDATE SubAccountUsages SET TimeLeft = CASE WHEN TimeLeft < 0 THEN 0 ELSE TimeLeft END, DataLeft = CASE WHEN DataLeft < 0 THEN 0 ELSE DataLeft END
	WHERE (TimeLeft < 0 OR DataLeft < 0);
UPDATE SubAccountUsages SET TimeLeft = TimeLeft + (SELECT SUM(ut.TimeLeft) FROM utsa ut WHERE ut.AccountID=SubAccountUsages.AccountID)
	WHERE SubAccountUsageID IN (SELECT MIN(sau2.SubAccountUsageID) FROM utsa ut, SubAccountUsages sau2
		WHERE ut.AccountID=sau2.AccountID
		AND sau2.TimeLeft > 0
		AND sau2.ExpireDate > DATEADD(mi,-COALESCE(sau2.TimeLeft+1440,1440),sysdate)
		GROUP BY ut.AccountID);
counter_ := SQL%ROWCOUNT;

UPDATE SubAccountUsages SET DataLeft = DataLeft + (SELECT SUM(ut.DataLeft) FROM utsa ut WHERE ut.AccountID=SubAccountUsages.AccountID)
	WHERE SubAccountUsageID IN (SELECT MIN(sau2.SubAccountUsageID) FROM utsa ut, SubAccountUsages sau2
		WHERE ut.AccountID=sau2.AccountID
		AND sau2.DataLeft > 0
		AND sau2.ExpireDate > DATEADD(dd,-1,sysdate)
		GROUP BY ut.AccountID);
counter_ := counter_ + SQL%ROWCOUNT;

IF (counter_ > 0) THEN
DELETE FROM utsa;
INSERT INTO utsa (AccountID, TimeLeft, DataLeft)
SELECT AccountID, CASE WHEN TimeLeft < 0 THEN TimeLeft ELSE 0 END, CASE WHEN DataLeft < 0 THEN DataLeft ELSE 0 END
FROM SubAccountUsages
	WHERE (TimeLeft < 0 OR DataLeft < 0);
END IF;

END LOOP;

DELETE FROM SubAccountUsages 
	WHERE ExpireDate < DATEADD(dd,-5,sysdate) 
	OR (TimeLeft <= 0 AND DataLeft <= 0)
	OR (TimeLeft IS NULL AND DataLeft IS NULL);
MERGE INTO SubAccounts msa
USING (SELECT sa.AccountID, CASE WHEN sa.DataLeft > at1.DataLeft THEN sa.DataLeft ELSE at1.DataLeft END AS DataLeft, sysdate AS LastDataLeftDate
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Discounts d ON (sa.DiscountID = d.DiscountID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 504)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND bc.AutoBill <> 2
	AND COALESCE(cgd.NumValue,option_ ) <> 0
	AND (at1.DataLeftRenewal = 2 OR ((COALESCE(sa.LastDataLeftDate,sa.LastTimeLeftDate) < DATEADD(mm,-1,sysdate) OR ((DATEPART(dd,sysdate) = ma.BillDay) OR ((DATEPART(mm,sysdate) <> DATEPART(mm,DATEADD(dd,1,sysdate))) AND DATEPART(dd,sysdate) <= ma.BillDay)))))
	AND sa.DataLeft IS NOT NULL
	AND at1.DataLeft IS NOT NULL
	AND COALESCE(sa.LastDataLeftDate,sa.LastTimeLeftDate) <= DATEADD(hh,-22,sysdate)
	AND (at1.DataLeftRenewal IS NULL OR at1.DataLeftRenewal IN (1,2))
	AND (COALESCE(cgd.NumValue,option_ ) = 1 OR (COALESCE(cgd.NumValue,option_ ) = 2 AND (sa.ExpireDate > sysdate OR ((sa.DiffCost=1 AND sa.Cost <= 0) OR (d.AmountType = 0 AND (at1.Cost*d.Amount) <= 0) OR (d.AmountType = 1 AND at1.Cost <= d.Amount)) )))) sa
ON (msa.AccountID = sa.AccountID)
WHEN MATCHED THEN UPDATE SET msa.DataLeft = sa.DataLeft, msa.LastDataLeftDate = sa.LastDataLeftDate;


MERGE INTO SubAccounts msa
USING (SELECT sa.AccountID, CASE WHEN sa.TimeLeft > at1.TimeLeft THEN sa.TimeLeft ELSE at1.TimeLeft END AS TimeLeft, sysdate AS LastTimeLeftDate
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Discounts d ON (sa.DiscountID = d.DiscountID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 504)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND bc.AutoBill <> 2
	AND COALESCE(cgd.NumValue,option_ ) <> 0
	AND (at1.TimeLeftRenewal = 2 OR ((sa.LastTimeLeftDate < DATEADD(mm,-1,sysdate) OR ((DATEPART(dd,sysdate) = ma.BillDay) OR ((DATEPART(mm,sysdate) <> DATEPART(mm,DATEADD(dd,1,sysdate))) AND DATEPART(dd,sysdate) <= ma.BillDay)))))
	AND sa.TimeLeft IS NOT NULL
	AND at1.TimeLeft IS NOT NULL
	AND sa.LastTimeLeftDate <= DATEADD(hh,-22,sysdate)
	AND (at1.TimeLeftRenewal IS NULL OR at1.TimeLeftRenewal IN (1,2))
	AND (COALESCE(cgd.NumValue,option_ ) = 1 OR (COALESCE(cgd.NumValue,option_ ) = 2 AND (sa.ExpireDate > sysdate OR ((sa.DiffCost=1 AND sa.Cost <= 0) OR (d.AmountType = 0 AND (at1.Cost*d.Amount) <= 0) OR (d.AmountType = 1 AND at1.Cost <= d.Amount)) )))) sa
ON (msa.AccountID = sa.AccountID)
WHEN MATCHED THEN UPDATE SET msa.TimeLeft = sa.TimeLeft, msa.LastTimeLeftDate = sa.LastTimeLeftDate;


END IF;

DELETE FROM utsa;
END;
END;
/

CREATE OR REPLACE PROCEDURE UpdateServerHistory AS
BEGIN
INSERT INTO ServerHistory (ServerID, HistoryDate, Calls)
SELECT ServerID, sysdate, COUNT(*) 
FROM ServerPorts 
	WHERE AcctStatusType=1 
GROUP BY ServerID;
END;
/

CREATE OR REPLACE PROCEDURE UpdateStatementAging (sid_ IN INTEGER,custid_ IN INTEGER) AS
BEGIN
DECLARE
Age0_ NUMERIC(18,4);
Age30_ NUMERIC(18,4);
Age60_ NUMERIC(18,4);
Age90_ NUMERIC(18,4);
Age120_ NUMERIC(18,4);
MinAmount_ NUMERIC(18,4);
MaxAmount_ NUMERIC(18,4);
Amount_ NUMERIC(18,4);
Percentage_ NUMERIC(18,4);
ChargeTypeID_ INTEGER;
Description_ VARCHAR2(64);
StatementDate_ DATE;
TaxGroupID_ INTEGER;
TaxExemptions_ INTEGER;
DueDate_ DATE;
BEGIN

SELECT SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-30,sysdate) AND sysdate THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END),SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-60,sysdate) AND DATEADD(dd,-30,sysdate) THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END),SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-90,sysdate) AND DATEADD(dd,-60,sysdate) THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END),SUM(CASE WHEN i.CreateDate BETWEEN DATEADD(dd,-120,sysdate) AND DATEADD(dd,-90,sysdate) THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END),SUM(CASE WHEN i.CreateDate < DATEADD(dd,-120,sysdate)THEN (ROUND(ii.Amount * ii.Quantity,2)) - ii.PaidAmount ELSE 0 END) INTO Age0_,Age30_,Age60_,Age90_,Age120_ 

FROM Invoices i, InvoiceItems ii, MasterAccounts ma
WHERE i.InvoiceID = ii.InvoiceID
	AND i.CustomerID = ma.CustomerID
	AND i.CustomerID =custid_
	AND ii.Amount > 0
	AND i.Processed = 1
	AND i.Estimate = 0
	AND i.VoidDate IS NULL
GROUP BY ma.CustomerID;
SELECT MIN(ii.StartDate) INTO DueDate_ 

FROM Invoices i, InvoiceItems ii
	WHERE i.InvoiceID = ii.InvoiceID
	AND i.CustomerID =custid_
	AND i.VoidDate IS NULL
	AND i.Processed = 1
	AND i.Estimate = 0
	AND ii.ItemType = 3
	AND i.CreateDate > DATEADD(yy,-1,sysdate)
	AND ii.PaidAmount < (ROUND(ii.Amount * ii.Quantity,2));
UPDATE Statements SET DueDate = COALESCE(DueDate,DueDate_ ), End0Bal = COALESCE(Age0_,0), End30Bal = COALESCE(Age30_,0), End60Bal = COALESCE(Age60_,0), End90Bal = COALESCE(Age90_,0), End120Bal = COALESCE(Age120_,0)
WHERE StatementID =sid_;
SELECT MAX(CASE WHEN lf.MinDays <= 30 THEN s.End30Bal ELSE 0 END + CASE WHEN lf.MinDays <= 60 THEN s.End60Bal ELSE 0 END + CASE WHEN lf.MinDays <= 90 THEN s.End90Bal ELSE 0 END + CASE WHEN lf.MinDays <= 120 THEN s.End120Bal ELSE 0 END),MAX(lf.Percentage),MAX(lf.ChargeTypeID),COALESCE(MAX(st.Data),MAX(ct.Description),'Late Fee'),MAX(lf.MinAmount),MAX(lf.MaxAmount),MAX(s.StatementDate),MAX(ct.TaxGroupID),MAX(ct.TaxExemptions) INTO Amount_,Percentage_,ChargeTypeID_,Description_,MinAmount_,MaxAmount_,StatementDate_,TaxGroupID_,TaxExemptions_ 

FROM MasterAccounts ma JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN LateFees lf ON (bc.LateFeeID = lf.LateFeeID)
	JOIN ChargeTypes ct ON (lf.ChargeTypeID = ct.ChargeTypeID)
	JOIN Statements s ON (s.StatementID =sid_ AND ma.CustomerID = s.CustomerID)
	LEFT JOIN Strings st ON (ma.LanguageID = st.LanguageID AND st.StringID = ct.StringID)
	WHERE ma.CustomerID =custid_
	AND (ma.LastLateFee IS NULL OR DATEADD(dd,28,ma.LastLateFee) <= s.StatementDate)
	AND ma.PendingBalance > 0;
IF ((MinAmount_ IS NULL OR MinAmount_ > 0) AND (MaxAmount_ IS NULL OR MaxAmount_ > 0) AND NOT (MinAmount_ IS NOT NULL AND MaxAmount_ IS NOT NULL AND MinAmount_ > MaxAmount_)  AND Amount_ > 0 AND Percentage_ > 0 AND Percentage_ < 100 AND StatementDate_ IS NOT NULL AND ChargeTypeID_ IS NOT NULL) THEN
SELECT Amount_ * (Percentage_ / 100) INTO Amount_ 

 FROM DUAL;
INSERT INTO Charges (CustomerID, Description, StartDate, EndDate, DistFlag, AllowInterim, Amount, Quantity, TaxGroupID, TaxExemptions, ChargeTypeID, LastModifyDate, LastModifyUser)
VALUES(custid_,Description_ ,StatementDate_ ,StatementDate_ , 1, 0, CASE WHEN MinAmount_ IS NOT NULL AND Amount_ < MinAmount_ THEN MinAmount_ WHEN MaxAmount_ IS NOT NULL AND Amount_ > MaxAmount_ THEN MaxAmount_ ELSE Amount_ END, 1,TaxGroupID_ ,TaxExemptions_ ,ChargeTypeID_ , sysdate, 'Emerald Auto Bill');
UPDATE MasterAccounts SET LastLateFee =StatementDate_ WHERE CustomerID =custid_;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE UserExport (crUserExport1 IN OUT ieatypes.CursorType,esid_ IN INTEGER,filemode_ IN INTEGER) AS
BEGIN
DECLARE
incremental_ INTEGER;
BEGIN
SELECT CASE WHEN filemode_ = 1 THEN 1 WHEN filemode_ = 2 THEN 0 ELSE 1 END INTO incremental_ 


 FROM DUAL;
OPEN crUserExport1 FOR SELECT sa.AccountID AS ID,
CASE WHEN ma.Active = 0 OR sa.Active = 0 OR ma.CancelDate < sysdate THEN 'inactive'  WHEN COALESCE(ma.OverLimit,0) > 0 AND ma.OverLimit < ma.Balance THEN 'expired' WHEN DATEADD(dd,(sa.Extension + COALESCE(ma.OverDue,0) + 1),sa.ExpireDate) < sysdate THEN 'expired' WHEN incremental_ <> 0 AND sa.CreateDate > es.LastSyncDate THEN 'active-new' WHEN incremental_ = 0 THEN 'active' ELSE 'active-update' END AS Status,
sa.Login, sa.Email, sa.Password, sa.FirstName, sa.LastName, es.MailHost, 
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = 2) AS HomeDir,
(SELECT Data FROM SubAccountData sad WHERE sad.AccountID = sa.AccountID AND AccountDataTypeID = 4) AS HomeDirLimit,
COALESCE(DATEDIFF(dd,to_date('1970-01-01','YYYY-MM-DD'),DATEADD(dd,(sa.Extension + COALESCE(ma.OverDue,0) + 1),sa.ExpireDate)),0) AS ExpireDay
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1, ExternalSystems es, ExternalSystemAccountTypes esat
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND esat.ExternalSystemID = es.ExternalSystemID
	AND at1.AccountTypeID = esat.AccountTypeID
	AND es.ExternalSystemID =esid_
	AND ma.Active IN (1,0)
	AND (incremental_ = 0 OR (
		(ma.LastModifyDate > es.LastSyncDate OR sa.LastModifyDate > es.LastSyncDate)));
END;
END;
/

CREATE OR REPLACE PROCEDURE VerifyFTPUser (crVerifyFTPUser1 IN OUT ieatypes.CursorType,username_ IN VARCHAR2) AS
BEGIN
DECLARE
globallimit_ INTEGER;
BEGIN
SELECT NumValue INTO globallimit_  FROM Configs WHERE ConfigID = 61;
OPEN crVerifyFTPUser1 FOR SELECT sa.AccountID, sa.Login, sa.Login AS Shell, sa.Password, sadh.Data AS HomeDir, COALESCE(CAST(sadl.Data AS INT),cgd.NumValue,globallimit_ ) AS HomeDirLimit
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN SubAccountData sadh ON (sa.AccountID = sadh.AccountID AND sadh.AccountDataTypeID = 2)
	LEFT JOIN SubAccountData sadl ON (sa.AccountID = sadl.AccountID AND sadl.AccountDataTypeID = 4)
	LEFT JOIN ConfigGroupData cgd ON (ma.GroupID = cgd.GroupID AND cgd.ConfigID = 61)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND ma.StartDate < sysdate
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND ((ma.OverLimit > 0 AND ma.OverLimit > ma.PendingBalance) OR ma.OverLimit = 0)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + COALESCE(ma.OverDue,0), sa.ExpireDate) > sysdate)
	AND sa.Login =username_;
END;
END;
/

CREATE OR REPLACE PROCEDURE VerifyMailUser (crVerifyMailUser1 IN OUT ieatypes.CursorType,username_ IN VARCHAR2,domain_ IN VARCHAR2,esid_ IN INTEGER) AS
BEGIN

DECLARE
cnt_ INTEGER;
BEGIN

INSERT INTO vmuAccountIDs (AccountID)
SELECT AccountID FROM SubAccounts WHERE Email =username_ || '@' || domain_
UNION
SELECT AccountID FROM SubAccounts sa, Domains d WHERE sa.Login =username_ AND sa.DomainID = d.DomainID AND d.MailDomain =domain_;
DELETE FROM vmuAccountIDs WHERE AccountID IN (SELECT sa.AccountID
FROM vmuAccountIDs ai, SubAccounts sa, MasterAccounts ma
	WHERE ai.AccountID = sa.AccountID
	AND sa.CustomerID = ma.CustomerID
	AND (sa.Active <> 1 OR ma.Active <> 1 OR ma.CancelDate < DATEADD(dd,-1,sysdate) OR sa.CancelDate < DATEADD(dd,-1,sysdate)));
SELECT COUNT(AccountID)  INTO cnt_ 

FROM vmuAccountIDs;
IF (cnt_ = 0) THEN
INSERT INTO vmuAccountIDs (AccountID)
SELECT AccountID FROM Aliases WHERE Alias =username_ || '@' || domain_;
END IF;

OPEN crVerifyMailUser1 FOR SELECT sa.Login, sa.Login AS Shell,sa.Email,domain_ AS MailDomain,
CASE WHEN ma.OverLimit > 0 AND ma.OverLimit < ma.PendingBalance THEN NULL
WHEN DATEADD(dd,sa.Extension + COALESCE(ma.OverDue,0) + 1,sa.ExpireDate) < sysdate THEN NULL
ELSE sa.Password END AS Password,  sad.Data AS HomeDir
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID) 
	JOIN vmuAccountIDs ai ON (sa.AccountID = ai.AccountID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 2)
	WHERE esat.ExternalSystemID =esid_
	AND ma.StartDate < sysdate
ORDER BY sa.Email DESC;
DELETE FROM vmuAccountIDs;
END;
END;
/

CREATE OR REPLACE PROCEDURE VerifyNewsUser (crVerifyNewsUser1 IN OUT ieatypes.CursorType,username_ IN VARCHAR2) AS
BEGIN
OPEN crVerifyNewsUser1 FOR SELECT Login, Login AS Shell, sa.Password, at1.AccountType
FROM MasterAccounts ma, SubAccounts sa, AccountTypes at1
WHERE ma.CustomerID = sa.CustomerID
		AND sa.AccountTypeID = at1.AccountTypeID
		AND ma.Active=1 AND sa.Active=1
		AND (ma.CancelDate IS NULL OR ma.CancelDate >= sysdate)
		AND ( (ma.OverLimit > 0 AND ma.OverLimit > (ma.Balance + ma.PendingBalance)) 
			OR (DATEADD(dd,(sa.Extension+COALESCE(ma.OverDue,0)+1),ExpireDate) < sysdate)
			OR ((ma.OverLimit IS NULL OR ma.OverLimit = 0) AND ExpireDate IS NULL))
		AND ma.StartDate < sysdate
		AND Login=username_;
END;
/

CREATE OR REPLACE PROCEDURE WebCheckOperator (crWebCheckOperator1 IN OUT ieatypes.CursorType,user_ IN VARCHAR2) AS
BEGIN
DECLARE
DateFormatID_ INTEGER;
DateSeparator_ CHAR(1);
PrintTypeID_ INTEGER;
BEGIN
SELECT NumValue INTO DateFormatID_  FROM Configs WHERE ConfigID = 390;
SELECT CAST(Data AS CHAR(1)) INTO DateSeparator_  FROM Configs WHERE ConfigID = 391;
SELECT NumValue INTO PrintTypeID_  FROM Configs WHERE ConfigID = 18;
OPEN crWebCheckOperator1 FOR SELECT op.OperatorGroupID, op.OperatorID, op.Operator, op.Password, op.Email, og.OperatorGroup, op.LanguageID, COALESCE(op.DateFormatID,DateFormatID_ ) AS DateFormatID, COALESCE(op.DateSeperator,DateSeparator_ ) AS DateSeparator, 0 AS CustomerID, 0 AS AccountID, 0 AS GroupID, t.Theme, COALESCE(op.PrintTypeID,PrintTypeID_ ) as PrintTypeID, op.MeasureUnitID
FROM Operators op LEFT JOIN OperatorGroups og ON (op.OperatorGroupID = og.OperatorGroupID)
	LEFT JOIN Themes t ON (op.ThemeID = t.ThemeID)
	WHERE op.Operator =user_
	AND op.Active = 1
UNION ALL
SELECT op.OperatorGroupID, op.OperatorID, op.Operator, op.Password, op.Email, og.OperatorGroup, op.LanguageID, COALESCE(op.DateFormatID,DateFormatID_ ) AS DateFormatID, COALESCE(op.DateSeperator,DateSeparator_ ) AS DateSeparator, 0 AS CustomerID, 0 AS AccountID, 0 AS GroupID, t.Theme, COALESCE(op.PrintTypeID,PrintTypeID_ ) as PrintTypeID, op.MeasureUnitID
FROM Operators op LEFT JOIN OperatorGroups og ON (op.OperatorGroupID = og.OperatorGroupID)
	LEFT JOIN Themes t ON (op.ThemeID = t.ThemeID)
	WHERE op.Email =user_
	AND op.Active = 1
	AND user_ LIKE '%@%'
UNION ALL
SELECT og.OperatorGroupID, 0 as OperatorID, sa.Login, sa.Password, sa.Email, og.OperatorGroup, NULL AS LanguageID,DateFormatID_ AS DateFormatID,DateSeparator_ AS DateSeparator, sa.CustomerID, sa.AccountID, ma.GroupID, NULL AS Theme,PrintTypeID_ AS PrintTypeID, CASE WHEN ma.CountryID = 840 THEN 1 ELSE 2 END AS MeasureUnitID
FROM MasterAccounts ma, SubAccounts sa, OperatorGroups og
	WHERE og.OperatorGroup = 'CustomerAccess'
	AND sa.CustomerID = ma.CustomerID
	AND ma.Active = 1 AND sa.Active = 1
	AND sa.Login =user_ 
	AND sa.Login IS NOT NULL
	AND sa.Password IS NOT NULL 
	AND sa.Password <> ' '
	AND sa.RemoteAccess > 0
UNION ALL
SELECT og.OperatorGroupID, 0 as OperatorID, sa.Email, sa.Password, sa.Email, og.OperatorGroup, NULL AS LanguageID,DateFormatID_ AS DateFormatID,DateSeparator_ AS DateSeparator, sa.CustomerID, sa.AccountID, ma.GroupID, NULL AS Theme,PrintTypeID_ AS PrintTypeID, CASE WHEN ma.CountryID = 840 THEN 1 ELSE 2 END AS MeasureUnitID
FROM MasterAccounts ma, SubAccounts sa, OperatorGroups og
	WHERE og.OperatorGroup = 'CustomerAccess'
	AND sa.CustomerID = ma.CustomerID
	AND ma.Active = 1 AND sa.Active = 1
	AND sa.Email =user_ 
	AND sa.Email IS NOT NULL
	AND sa.Password IS NOT NULL 
	AND sa.Password <> ' '
	AND sa.RemoteAccess > 0
ORDER BY CustomerID ASC;
END;
END;
/

CREATE OR REPLACE PROCEDURE WebCheckOperatorCookie (crWebCheckOperatorCookie1 IN OUT ieatypes.CursorType,Cookie_ IN VARCHAR2) AS
BEGIN
DECLARE
DateFormatID_ INTEGER;
DateSeparator_ CHAR(1);
PrintTypeID_ INTEGER;
BEGIN
SELECT NumValue INTO DateFormatID_  FROM Configs WHERE ConfigID = 390;
SELECT CAST(Data AS CHAR(1)) INTO DateSeparator_  FROM Configs WHERE ConfigID = 391;
SELECT NumValue INTO PrintTypeID_  FROM Configs WHERE ConfigID = 18;
DELETE FROM OperatorCookies WHERE LastUsed < DATEADD(dd,-7,sysdate);
OPEN crWebCheckOperatorCookie1 FOR SELECT oc.LastUsed, op.OperatorGroupID, op.OperatorID, op.Operator, op.Password, op.Email, og.OperatorGroup, op.LanguageID, COALESCE(op.DateFormatID,DateFormatID_ ) AS DateFormatID, COALESCE(op.DateSeperator,DateSeparator_ ) AS DateSeparator, 0 AS CustomerID, 0 AS AccountID, 0 AS GroupID, t.Theme, COALESCE(op.PrintTypeID,PrintTypeID_ ) as PrintTypeID, op.MeasureUnitID
FROM Operators op LEFT JOIN OperatorGroups og ON (op.OperatorGroupID = og.OperatorGroupID)
	LEFT JOIN Themes t ON (op.ThemeID = t.ThemeID)
	JOIN OperatorCookies oc ON (op.OperatorID = oc.OperatorID)
	WHERE oc.Cookie =Cookie_
	AND op.Active = 1

UNION ALL

SELECT oc.LastUsed, og.OperatorGroupID, 0 AS OperatorID, sa.Login, sa.Password, sa.Email, og.OperatorGroup, NULL AS LanguageID,DateFormatID_ AS DateFormatID,DateSeparator_ AS DateSeparator, sa.CustomerID, sa.AccountID, ma.GroupID, NULL AS Theme,PrintTypeID_ AS PrintTypeID, CASE WHEN ma.CountryID = 840 THEN 1 ELSE 2 END AS MeasureUnitID
FROM MasterAccounts ma, SubAccounts sa, OperatorGroups og, OperatorCookies oc
	WHERE og.OperatorGroup = 'CustomerAccess'
	AND sa.CustomerID = ma.CustomerID
	AND ma.Active = 1 
	AND sa.Active = 1
	AND oc.AccountID = sa.AccountID
	AND oc.Cookie =Cookie_
	AND sa.Password IS NOT NULL 
	AND sa.Password <> ' '
	AND sa.RemoteAccess > 0;
END;
END;
/

CREATE OR REPLACE PROCEDURE WebDeleteOperatorCookie (Cookie_ IN VARCHAR2) AS
BEGIN
DELETE FROM OperatorCookies WHERE Cookie =Cookie_;
END;
/

CREATE OR REPLACE PROCEDURE WebAddOperatorCookie (Operator_ IN VARCHAR2,Cookie_ IN VARCHAR2,OperatorID_ IN INTEGER,AccountID_ IN INTEGER) AS
BEGIN

INSERT INTO OperatorCookies (Operator,Cookie,OperatorID,AccountID)
VALUES (Operator_,Cookie_ ,OperatorID_ ,AccountID_ );
END;
/

CREATE OR REPLACE PROCEDURE WebUpdateOperatorCookie (Operator_ IN VARCHAR2,Cookie_ IN VARCHAR2,OperatorID_ IN INTEGER,AccountID_ IN INTEGER) AS
BEGIN
UPDATE OperatorCookies SET LastUsed=sysdate, OperatorID =OperatorID_, AccountID =AccountID_, Operator =Operator_ WHERE Cookie =Cookie_;
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO OperatorCookies (Operator,Cookie,OperatorID,AccountID)
VALUES (Operator_,Cookie_ ,OperatorID_ ,AccountID_ );
END IF;
END;
/

CREATE OR REPLACE PROCEDURE SesCheckLimit (crSesCheckLimit1 IN OUT ieatypes.CursorType) AS
BEGIN

DECLARE
loginlimit_ INTEGER;
timeleft_ INTEGER;
dataleft_ INTEGER;
BEGIN
SELECT NumValue INTO loginlimit_  FROM Configs WHERE ConfigID = 634;
SELECT NumValue INTO timeleft_  FROM Configs WHERE ConfigID = 635;
SELECT NumValue INTO dataleft_  FROM Configs WHERE ConfigID = 650;
OPEN crSesCheckLimit1 FOR SELECT sp.AccountID, NULL AS Username, 1 AS VType, COUNT(*) AS Active, MIN(sa.LoginLimit) AS Limit
FROM ServerPorts sp JOIN SubAccounts sa ON (sp.AccountID = sa.AccountID)
	JOIN Servers s ON (sp.NASIdentifier = s.IPAddress)
	WHERE sp.AcctStatusType = 1
	AND loginlimit_ = 1
	AND sa.LoginLimit IS NOT NULL
	AND s.DisconnectPort IS NOT NULL
	AND sp.AccountID IS NOT NULL
	AND (s.Concurrency IS NULL OR s.Concurrency = 1)
GROUP BY sp.AccountID
HAVING COUNT(*) > MIN(sa.LoginLimit)
UNION ALL
SELECT sp.AccountID, NULL AS Username, 2 AS VType, SUM(DATEDIFF(ss,sp.CallDate,sysdate)) AS Active, MIN(sa.TimeLeft)  +  COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sp.AccountID=sau.AccountID AND sau.ExpireDate > sysdate AND sau.TimeLeft > 0),0) AS Limit
FROM ServerPorts sp, SubAccounts sa, Servers s
	WHERE sp.AccountID = sa.AccountID
	AND sp.AcctStatusType = 1
	AND timeleft_ = 1
	AND sa.TimeLeft IS NOT NULL
	AND sp.NASIdentifier = s.IPAddress
	AND s.DisconnectPort IS NOT NULL
	AND sp.AccountID IS NOT NULL
GROUP BY sp.AccountID
HAVING SUM(DATEDIFF(ss,sp.CallDate,sysdate)) > ((MIN(sa.TimeLeft)  +  COALESCE((SELECT SUM(sau.TimeLeft) FROM SubAccountUsages sau WHERE sp.AccountID=sau.AccountID AND sau.ExpireDate > sysdate AND sau.TimeLeft > 0),0)) * 60)
UNION ALL
SELECT sp.AccountID, NULL AS Username, 4 AS VType, NULL AS Active, NULL AS Limit
FROM ServerPorts sp, SubAccounts sa, Servers s
	WHERE sp.AccountID = sa.AccountID
	AND sp.AcctStatusType = 1
	AND dataleft_ = 1
	AND sp.AcctOutputOctets IS NOT NULL
	AND sp.AcctOutputOctets > 0
	AND sa.DataLeft IS NOT NULL
	AND sp.NASIdentifier = s.IPAddress
	AND s.DisconnectPort IS NOT NULL
	AND sp.AccountID IS NOT NULL
GROUP BY sp.AccountID
HAVING SUM(sp.AcctOutputOctets) > (MIN(sa.DataLeft)  +  COALESCE((SELECT SUM(sau.DataLeft) FROM SubAccountUsages sau WHERE sp.AccountID=sau.AccountID AND sau.ExpireDate > sysdate AND sau.DataLeft > 0),0))
UNION ALL
SELECT DISTINCT sp.AccountID, NULL AS Username, 3 AS VType, NULL AS Active, NULL AS Limit
FROM ServerPorts sp JOIN SubAccounts sa ON (sp.AccountID = sa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Servers s ON (sp.NASIdentifier = s.IPAddress)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	WHERE sp.AcctStatusType = 1
	AND s.DisconnectPort IS NOT NULL
	AND sp.AccountID IS NOT NULL
	AND (ma.Active IN (-1,0) OR sa.Active IN (-1,0) OR g.Active = 0 OR (sa.ExpireDate IS NOT NULL AND DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) < sysdate));
END;
END;
/

CREATE OR REPLACE PROCEDURE SesGetLimit (crSesGetLimit1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER,Username_ IN VARCHAR2) AS
BEGIN

IF (AccountID_ IS NOT NULL) THEN
OPEN crSesGetLimit1 FOR SELECT s.IPAddress, s.Secret, s.DisconnectPort, sp.AcctSessionID,
CASE WHEN s.DisconnectType = NULL OR BITAND(8,s.DisconnectType) = 8 THEN sp.Username ELSE NULL END AS Username, 
CASE WHEN s.DisconnectType = NULL OR BITAND(2,s.DisconnectType) = 2 THEN sp.NASIdentifier ELSE NULL END AS NASIdentifier,
CASE WHEN s.DisconnectType = NULL OR BITAND(1,s.DisconnectType) = 1 THEN sp.Port ELSE NULL END AS Port,
CASE WHEN s.DisconnectType = NULL OR BITAND(4,s.DisconnectType) = 4 THEN sp.CallerID ELSE NULL END AS CallerID,
CASE WHEN s.DisconnectType = NULL OR BITAND(16,s.DisconnectType) = 16 THEN sp.NASPortDNIS ELSE NULL END AS NASPortDNIS,
CASE WHEN s.DisconnectType = NULL OR BITAND(32,s.DisconnectType) = 32 THEN sp.FramedAddress ELSE NULL END AS FramedAddress
FROM ServerPorts sp, Servers s
	WHERE sp.AcctStatusType = 1
	AND sp.NASIdentifier = s.IPAddress
	AND s.DisconnectPort IS NOT NULL
	AND sp.AccountID =AccountID_
ORDER BY DATEADD(ss,-COALESCE(sp.AcctSessionTime,0),sp.CallDate) ASC;
ELSE
OPEN crSesGetLimit1 FOR SELECT s.IPAddress, s.Secret, s.DisconnectPort, sp.AcctSessionID, 
CASE WHEN s.DisconnectType = NULL OR BITAND(8,s.DisconnectType) = 8 THEN sp.Username ELSE NULL END AS Username, 
CASE WHEN s.DisconnectType = NULL OR BITAND(2,s.DisconnectType) = 2 THEN sp.NASIdentifier ELSE NULL END AS NASIdentifier,
CASE WHEN s.DisconnectType = NULL OR BITAND(1,s.DisconnectType) = 1 THEN sp.Port ELSE NULL END AS Port,
CASE WHEN s.DisconnectType = NULL OR BITAND(4,s.DisconnectType) = 4 THEN sp.CallerID ELSE NULL END AS CallerID,
CASE WHEN s.DisconnectType = NULL OR BITAND(16,s.DisconnectType) = 16 THEN sp.NASPortDNIS ELSE NULL END AS NASPortDNIS,
CASE WHEN s.DisconnectType = NULL OR BITAND(32,s.DisconnectType) = 32 THEN sp.FramedAddress ELSE NULL END AS FramedAddress
FROM ServerPorts sp, Servers s
	WHERE sp.AcctStatusType = 1
	AND sp.NASIdentifier = s.IPAddress
	AND s.DisconnectPort IS NOT NULL
	AND sp.Username =Username_
ORDER BY DATEADD(ss,-COALESCE(sp.AcctSessionTime,0),sp.CallDate) ASC;
END IF;
END;
/

CREATE OR REPLACE PROCEDURE SesRadVendors (crSesRadVendors1 IN OUT ieatypes.CursorType) AS
BEGIN

OPEN crSesRadVendors1 FOR SELECT Name, RadVendorID AS VendorID
FROM RadVendors
ORDER BY RadVendorID;
END;
/

CREATE OR REPLACE PROCEDURE SesRadAttributes (crSesRadAttributes1 IN OUT ieatypes.CursorType) AS
BEGIN

OPEN crSesRadAttributes1 FOR SELECT Name, RadVendorID AS VendorID, RadAttributeID AS AttributeID, RadAttributeType AS Type
FROM RadAttributes 
ORDER BY RadVendorID, RadAttributeID;
END;
/

CREATE OR REPLACE PROCEDURE SesCheckRate (crSesCheckRate1 IN OUT ieatypes.CursorType) AS
BEGIN
DECLARE
rate_ INTEGER;
BEGIN
SELECT NumValue INTO rate_  FROM Configs WHERE ConfigID = 636;
OPEN crSesCheckRate1 FOR SELECT ma.GroupID, sa.AccountID, sa.CustomerID, CASE WHEN bc.CycleType IN (1,2) THEN COALESCE(bc.BillDay,1) ELSE ma.BillDay END AS BillDay, at1.RateClassID, sp.Username, 
sp.NASIdentifier, sp.Port, DATEDIFF(ss,sp.CallDate,sysdate) AS Duration, COALESCE(sp.AcctOutputOctets,0) + COALESCE(sp.AcctInputOctets,0) + 1 AS Data, sp.FramedAddress, sp.NASPortDNIS, sp.CallerID, sp.CallDate,
ma.OverLimit - ma.PendingBalance - COALESCE((SELECT SUM(rh.TotalCost) FROM RateHistory rh WHERE rh.ChargeID IS NULL AND rh.CustomerID = sa.CustomerID),0) AS AmountLeft
FROM ServerPorts sp, Servers s, SubAccounts sa, MasterAccounts ma, AccountTypes at1, BillingCycles bc
	WHERE sp.AccountID = sa.AccountID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND sp.NASIdentifier = s.IPAddress
	AND sa.CustomerID = ma.CustomerID
	AND s.DisconnectPort IS NOT NULL
	AND sp.AcctStatusType = 1
	AND rate_ = 1
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.RateClassID IS NOT NULL
ORDER BY sa.CustomerID, sa.AccountID;
END;
END;
/

CREATE OR REPLACE PROCEDURE SesGetRate (crSesGetRate1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER) AS
BEGIN
OPEN crSesGetRate1 FOR SELECT s.IPAddress, s.Secret, s.DisconnectPort, sp.AcctSessionID, 
CASE WHEN s.DisconnectType = NULL OR BITAND(8,s.DisconnectType) = 8 THEN sp.Username ELSE NULL END AS Username, 
CASE WHEN s.DisconnectType = NULL OR BITAND(2,s.DisconnectType) = 2 THEN sp.NASIdentifier ELSE NULL END AS NASIdentifier,
CASE WHEN s.DisconnectType = NULL OR BITAND(1,s.DisconnectType) = 1 THEN sp.Port ELSE NULL END AS Port,
CASE WHEN s.DisconnectType = NULL OR BITAND(4,s.DisconnectType) = 4 THEN sp.CallerID ELSE NULL END AS CallerID,
CASE WHEN s.DisconnectType = NULL OR BITAND(16,s.DisconnectType) = 16 THEN sp.NASPortDNIS ELSE NULL END AS NASPortDNIS,
CASE WHEN s.DisconnectType = NULL OR BITAND(32,s.DisconnectType) = 32 THEN sp.FramedAddress ELSE NULL END AS FramedAddress
FROM ServerPorts sp, Servers s, SubAccounts sa, AccountTypes at1
	WHERE sp.AccountID = sa.AccountID
	AND sp.NASIdentifier = s.IPAddress
	AND s.DisconnectPort IS NOT NULL
	AND sp.AcctStatusType = 1
	AND sa.AccountTypeID = at1.AccountTypeID
	AND at1.RateClassID IS NOT NULL
	AND sa.AccountID =AccountID_;
END;
/

CREATE OR REPLACE PROCEDURE SesConfig (crSesConfig1 IN OUT ieatypes.CursorType) AS
BEGIN
DECLARE
limit_ INTEGER;
rate_ INTEGER;
intlimit_ INTEGER;
intrate_ INTEGER;
preload_ INTEGER;
debug_ INTEGER;
BEGIN
SELECT CASE WHEN SUM(NumValue) > 0 THEN 1 ELSE 0 END INTO limit_  FROM Configs WHERE ConfigID IN (634,635);
SELECT NumValue INTO rate_  FROM Configs WHERE ConfigID = 636;
SELECT NumValue INTO intlimit_  FROM Configs WHERE ConfigID = 637;
SELECT NumValue INTO intrate_  FROM Configs WHERE ConfigID = 638;
SELECT NumValue INTO preload_  FROM Configs WHERE ConfigID = 639;
SELECT NumValue  INTO debug_ 

FROM Configs WHERE ConfigID = 633;
OPEN crSesConfig1 FOR SELECT limit_ AS LimitEnabled, COALESCE(rate_,0) AS RateEnabled, COALESCE(intlimit_,60) AS LimitInterval, COALESCE(intrate_,240) AS RateInterval, COALESCE(preload_,1) AS RatePreload, COALESCE(debug_,0) AS DebugFlag

 FROM DUAL;
END;
END;
/

CREATE OR REPLACE PROCEDURE SesOnlineReset (NASIdentifier_ IN VARCHAR2,NASPort_ IN VARCHAR2) AS
BEGIN
UPDATE ServerPorts SET AcctStatusType = 2 
	WHERE NASIdentifier =NASIdentifier_ 
	AND Port =NASPort_
	AND AcctStatusType = 1;
END;
/

CREATE OR REPLACE PROCEDURE StatementDeleteLast (CustomerID_ IN INTEGER) AS
BEGIN
DECLARE
StatementID_ INTEGER;
BEGIN
SELECT LastStatementID INTO StatementID_  FROM MasterAccounts WHERE CustomerID = CustomerID_;
IF (StatementID_ IS NOT NULL) THEN
UPDATE ExternalTrans SET StatementID = NULL WHERE StatementID =StatementID_;
UPDATE MasterAccounts SET Balance = (SELECT PrevBal FROM Statements WHERE StatementID =StatementID_), LastStatementID = (SELECT MAX(s2.StatementID) FROM Statements s2 WHERE s2.CustomerID =CustomerID_ AND s2.StatementID <> StatementID_) 
WHERE CustomerID =CustomerID_;
UPDATE ExternalTrans SET StatementID = NULL WHERE StatementID =StatementID_;
UPDATE Invoices SET StatementID = NULL WHERE StatementID =StatementID_;
UPDATE Invoices SET VoidStatementID = NULL WHERE VoidStatementID =StatementID_;
UPDATE Payments SET StatementID = NULL WHERE StatementID =StatementID_;
UPDATE Payments SET FinalStatementID = NULL WHERE FinalStatementID =StatementID_;
DELETE FROM Statements WHERE StatementID =StatementID_;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE ExternalSyncUpdate (ExternalSyncID_ IN INTEGER,TransTypeID_ IN INTEGER,Data_ IN VARCHAR2,Retcode_ IN INTEGER) AS
BEGIN

IF (Retcode_ = 0) THEN

IF (TransTypeID_ = 1024) THEN
MERGE INTO ExternalSyncs mes
USING (SELECT es.ExternalSyncID, es.AccountID, 0 AS ErrorCount, NULL AS Message, COALESCE(sa.Login,sa.Email) AS Login, sa.Password, NULL AS Aux1, NULL AS Aux2, NULL AS Aux3,
sysdate AS CreateDate, sysdate AS LastModifyDate, sysdate AS LastUpdate, 1 AS Active, 1 AS Created,Data_ AS ProcTransID
FROM SubAccounts sa, ExternalSyncs es
	WHERE sa.AccountID = es.AccountID
	AND es.ExternalSyncID =ExternalSyncID_) es
ON (mes.ExternalSyncID = es.ExternalSyncID AND mes.AccountID = es.AccountID)
WHEN MATCHED THEN UPDATE SET mes.ErrorCount = es.ErrorCount, mes.Message = es.Message, mes.Login = es.Login, mes.Password = es.Password, mes.Aux1 = es.Aux1, mes.Aux2 = es.Aux2, mes.Aux3 = es.Aux3, mes.CreateDate = es.CreateDate, mes.LastModifyDate = es.LastModifyDate, mes.LastUpdate = es.LastUpdate, mes.Active = es.Active, mes.Created = es.Created, mes.ProcTransID = es.ProcTransID;

END IF;

IF (TransTypeID_ = 2048) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, LastUpdate = sysdate
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 4096) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Active = 0, Created = 0
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 8192) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Login =Data_
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 65536) THEN
MERGE INTO ExternalSyncs mes
USING (SELECT es.ExternalSyncID, 0 AS ErrorCount, NULL AS Message, sysdate AS LastModifyDate, sa.Password
FROM ExternalSyncs es, SubAccounts sa
	WHERE es.AccountID = sa.AccountID
	AND es.ExternalSyncID =ExternalSyncID_) es
ON (mes.ExternalSyncID = es.ExternalSyncID)
WHEN MATCHED THEN UPDATE SET mes.ErrorCount = es.ErrorCount, mes.Message = es.Message, mes.LastModifyDate = es.LastModifyDate, mes.Password = es.Password;

END IF;

IF (TransTypeID_ = 131072) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Active = 1
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 262144) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Active = 0
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 524288) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Aux1 = CAST(Data_ AS VARCHAR(128))
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 1048576) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Aux2 = CAST(Data_ AS VARCHAR(128))
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 2097152) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Aux3 = CAST(Data_ AS VARCHAR(128))
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 4194304) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Aux4 = CAST(Data_ AS VARCHAR(128))
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 8388608) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Aux5 = CAST(Data_ AS VARCHAR(128))
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 16777216) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Aux6 = CAST(Data_ AS VARCHAR(128))
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 33554432) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Aux7 = CAST(Data_ AS VARCHAR(128))
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 67108864) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Aux8 = CAST(Data_ AS VARCHAR(768))
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

ELSE
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message =Data_, LastModifyDate = sysdate WHERE ExternalSyncID =ExternalSyncID_;
END IF;
END;
/

CREATE OR REPLACE PROCEDURE ExternalSyncDelete (ExternalSyncID_ IN INTEGER,TransTypeID_ IN INTEGER,Data_ IN VARCHAR2,Retcode_ IN INTEGER) AS
BEGIN

IF (Retcode_ = 0) THEN
DELETE FROM ExternalSyncs WHERE ExternalSyncID =ExternalSyncID_;
ELSE
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message =Data_, LastModifyDate = sysdate WHERE ExternalSyncID =ExternalSyncID_;
END IF;
END;
/

CREATE OR REPLACE PROCEDURE ESEveryoneDomainUP (ExternalSyncID_ IN INTEGER,TransTypeID_ IN INTEGER,Data_ IN VARCHAR2,Retcode_ IN INTEGER) AS
BEGIN
DECLARE
DomainID_ INTEGER;
MailDomain_ VARCHAR2(128);
BEGIN

IF (Retcode_ = 0) THEN
SELECT d.DomainID,d.MailDomain INTO DomainID_,MailDomain_ 

FROM ExternalSyncs esy, Domains d 
	WHERE d.MailDomain = esy.Aux3
	AND esy.ExternalSyncID =ExternalSyncID_;
UPDATE Domains SET ExternalRef =Data_ WHERE DomainID =DomainID_;
DELETE FROM ExternalSyncs WHERE Aux3 =MailDomain_ AND ExternalSyncID =ExternalSyncID_;
ELSE
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message =Data_, LastModifyDate = sysdate WHERE ExternalSyncID =ExternalSyncID_;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE ESEveryoneNet (crESEveryoneNet1 IN OUT ieatypes.CursorType,ESID_ IN INTEGER,Stage_ IN INTEGER) AS
BEGIN
DECLARE
ClientID_ VARCHAR2(64);
ClientPass_ VARCHAR2(64);
OfferID_ VARCHAR2(64);
ESExternalRef_ VARCHAR2(64);
BEGIN
SELECT Login,Password,Aux1,Aux2 INTO ClientID_,ClientPass_,OfferID_,ESExternalRef_  FROM ExternalSystems WHERE ExternalSystemID = ESID_;
IF (Stage_ = 1) THEN

INSERT INTO ExternalSyncs (ExternalSystemID,Aux3,Aux6)
SELECT DISTINCT ESID_, d.MailDomain, ' '
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.DomainID = d.DomainID
	AND ESExternalRef_ IS NULL
	AND d.ExternalRef IS NULL
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 5
	AND sa.Login IS NOT NULL
	AND NOT EXISTS (SELECT * FROM ExternalSyncs esy2 WHERE esy2.ExternalSystemID =ESID_ AND esy2.Aux3 = d.MailDomain);

OPEN crESEveryoneNet1 FOR SELECT DISTINCT esy.ExternalSyncID, 2097152 AS TransTypeID, NULL AS OrigData, NULL AS Login, NULL Pass,ClientID_ AS clientID,ClientPass_ AS password, NULL AS FirstName, NULL AS LastName, NULL AS ExternalRef,OfferID_ AS OfferID, d.MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID IS NULL
	AND esy.Aux3 = d.MailDomain
	AND esy.ExternalSystemID =ESID_
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.DomainID = d.DomainID
	AND ESExternalRef_ IS NULL
	AND d.ExternalRef IS NULL
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 5
	AND sa.Login IS NOT NULL;
END IF;

IF (Stage_ = 2) THEN
INSERT INTO ExternalSyncs (ExternalSystemID, AccountID,Aux1,Aux2)
SELECT ESID_, sa.AccountID, COALESCE(sa.FirstName,'') || COALESCE(sa.LastName,''), COALESCE(esat.ExternalRef,OfferID_ )
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esy.AccountID IS NULL;

OPEN crESEveryoneNet1 FOR SELECT esy.ExternalSyncID, 1024 AS TransTypeID, NULL AS OrigData, sa.Login, sa.Password AS Pass,ClientID_ AS clientID,ClientPass_ AS password, NULL AS FirstName, NULL AS LastName, COALESCE(d.ExternalRef,ESExternalRef_ ) AS ExternalRef, COALESCE(esat.ExternalRef,OfferID_ ) AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.DomainID = d.DomainID
	AND (ESExternalRef_ IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 5
	AND sa.Login IS NOT NULL
	AND NOT EXISTS (SELECT * FROM Forwards f WHERE f.AccountID = sa.AccountID)

UNION ALL

SELECT esy.ExternalSyncID, 131072 AS TransTypeID, NULL, esy.Login, NULL,ClientID_ ,ClientPass_ , NULL, NULL, COALESCE(d.ExternalRef,ESExternalRef_ ) AS ExternalRef,OfferID_ AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND sa.DomainID = d.DomainID
	AND (ESExternalRef_ IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 1
	AND esy.Active = 0
	AND DATALENGTH(sa.Password) > 5

UNION ALL

SELECT esy.ExternalSyncID, 262144 AS TransTypeID, NULL, esy.Login, NULL,ClientID_ ,ClientPass_ , NULL, NULL, COALESCE(d.ExternalRef,ESExternalRef_ ) AS ExternalRef,OfferID_ AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND sa.DomainID = d.DomainID
	AND (ESExternalRef_ IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND (ma.Active = 0 OR sa.Active = 0 OR ma.CancelDate < sysdate OR sa.CancelDate < sysdate OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) < sysdate)
	AND esy.Created = 1
	AND esy.Active = 1

UNION ALL

SELECT esy.ExternalSyncID, 4096 AS TransTypeID, NULL, esy.Login, NULL,ClientID_ ,ClientPass_ , NULL, NULL, COALESCE(d.ExternalRef,ESExternalRef_ ) AS ExternalRef,OfferID_ AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND sa.DomainID = d.DomainID
	AND (ESExternalRef_ IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
	AND (ma.Active = -1 OR sa.Active = -1 OR sa.BilledThru < DATEADD(dd,-30,sysdate))

UNION ALL

SELECT esy.ExternalSyncID, 65536 AS TransTypeID, NULL, esy.Login, sa.Password,ClientID_ ,ClientPass_ , NULL, NULL, COALESCE(d.ExternalRef,ESExternalRef_ ) AS ExternalRef,OfferID_ AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND sa.DomainID = d.DomainID
	AND (ESExternalRef_ IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Active = 1
	AND sa.Password <> esy.Password
	AND DATALENGTH(sa.Password) > 5

UNION ALL

SELECT esy.ExternalSyncID, 524288 AS TransTypeID, NULL, esy.Login, NULL,ClientID_ ,ClientPass_ , sa.FirstName, sa.LastName, COALESCE(d.ExternalRef,ESExternalRef_ ) AS ExternalRef,OfferID_ AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND sa.DomainID = d.DomainID
	AND (ESExternalRef_ IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Active = 1
	AND (COALESCE(sa.FirstName,'') || COALESCE(sa.LastName,'') <> esy.Aux1 OR esy.Aux1 IS NULL)
	AND DATALENGTH(sa.Password) > 5

UNION ALL

SELECT esy.ExternalSyncID, 1048576 AS TransTypeID, NULL, esy.Login, NULL,ClientID_ ,ClientPass_ , sa.FirstName, sa.LastName, COALESCE(d.ExternalRef,ESExternalRef_ ) AS ExternalRef, COALESCE(esat.ExternalRef,OfferID_ ) AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND sa.DomainID = d.DomainID
	AND (ESExternalRef_ IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Active = 1
	AND (COALESCE(esat.ExternalRef,OfferID_ ) <> esy.Aux2 OR esy.Aux2 IS NULL)
	AND DATALENGTH(sa.Password) > 5

UNION ALL

SELECT esy.ExternalSyncID, 4194304 AS TransTypeID, NULL AS OrigData, sa.Login, sa.Password AS Pass,ClientID_ AS clientID,ClientPass_ AS password, NULL AS FirstName, NULL AS LastName, COALESCE(d.ExternalRef,ESExternalRef_ ) AS ExternalRef, COALESCE(esat.ExternalRef,OfferID_ ) AS OfferID, NULL AS MailDomain, (SELECT MIN(f1.Forward) FROM Forwards f1 WHERE f1.AccountID = sa.AccountID AND f1.Forward LIKE '%[a-z0-9]@[a-z0-9]%') AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.DomainID = d.DomainID
	AND (ESExternalRef_ IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 0
	AND sa.Login IS NOT NULL
	AND EXISTS (SELECT * FROM Forwards f WHERE f.AccountID = sa.AccountID AND f.Forward LIKE '%[a-z0-9]@[a-z0-9]%')
	AND (esy.Aux4 IS NULL OR esy.Aux4 <> (SELECT MIN(f2.Forward) FROM Forwards f2 WHERE f2.AccountID = sa.AccountID AND f2.Forward LIKE '%[a-z0-9]@[a-z0-9]%'))

UNION ALL

SELECT esy.ExternalSyncID, 8388608 AS TransTypeID, NULL, esy.Login, NULL,ClientID_ ,ClientPass_ , NULL AS FirstName, NULL AS LastName, COALESCE(d.ExternalRef,ESExternalRef_ ) AS ExternalRef, COALESCE(esat.ExternalRef,OfferID_ ) AS OfferID, NULL AS MailDomain, NULL AS Forward, NULL AS ForwardOption
FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND sa.DomainID = d.DomainID
	AND (ESExternalRef_ IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND esy.Created = 0
	AND (esy.Aux5 IS NOT NULL AND esy.Aux5 <> ' ')
	AND NOT EXISTS (SELECT * FROM Forwards f WHERE f.AccountID = sa.AccountID AND f.Forward LIKE '%[a-z0-9]@[a-z0-9]%')

UNION ALL

SELECT esy.ExternalSyncID, 16777216 AS TransTypeID, NULL, esy.Login, NULL,ClientID_ ,ClientPass_ , NULL AS FirstName, NULL AS LastName, COALESCE(d.ExternalRef,ESExternalRef_ ) AS ExternalRef, COALESCE(esat.ExternalRef,OfferID_ ) AS OfferID, NULL AS MailDomain,
(SELECT MIN('"' || f1.Forward || '"') FROM Forwards f1 WHERE f1.AccountID = sa.AccountID AND f1.Forward LIKE '%[a-z0-9]@[a-z0-9]%') AS Forward, CASE WHEN (SELECT COUNT(*) FROM Forwards f3 WHERE f3.AccountID = sa.AccountID AND f3.Forward LIKE '%[a-z0-9]@[a-z0-9]%') > 0 THEN 1 ELSE 0 END AS ForwardOption

FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND sa.DomainID = d.DomainID
	AND (ESExternalRef_ IS NOT NULL OR d.ExternalRef IS NOT NULL)
	AND esy.Created = 1
	AND esy.Active = 1
	AND (esy.Aux6 IS NULL OR esy.Aux6 <> (SELECT MIN(f4.Forward) FROM Forwards f4 WHERE f4.AccountID = sa.AccountID AND f4.Forward LIKE '%[a-z0-9]@[a-z0-9]%'));
END IF;

END;
END;
/

CREATE OR REPLACE PROCEDURE ESSmarterMail (crESSmarterMail1 IN OUT ieatypes.CursorType,ESID_ IN INTEGER) AS
BEGIN
DECLARE
authlogin_ VARCHAR2(64);
authpassword_ VARCHAR2(64);
BEGIN
SELECT Login,Password INTO authlogin_,authpassword_  FROM ExternalSystems WHERE ExternalSystemID = ESID_;
INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT ESID_, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esy.AccountID IS NULL;

OPEN crESSmarterMail1 FOR SELECT esy.ExternalSyncID, 1024 AS TransTypeID,authlogin_ AS authlogin,authpassword_ AS authpassword,
sa.Login, sa.Password, sa.FirstName, sa.LastName, d.MailDomain AS Domain

FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND ma.Active = 1
	AND sa.Active = 1
	AND sa.DomainID = d.DomainID
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 1
	AND sa.Login IS NOT NULL

UNION ALL

SELECT esy.ExternalSyncID, 131072 AS TransTypeID,authlogin_ AS authlogin,authpassword_ AS authpassword,
sa.Login, sa.Password, sa.FirstName, sa.LastName, d.MailDomain AS Domain

FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND sa.DomainID = d.DomainID
	AND ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 1
	AND esy.Active = 0
	AND DATALENGTH(sa.Password) > 1

UNION ALL

SELECT esy.ExternalSyncID, 262144 AS TransTypeID,authlogin_ AS authlogin,authpassword_ AS authpassword,
sa.Login, sa.Password, sa.FirstName, sa.LastName, d.MailDomain AS Domain

FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND sa.DomainID = d.DomainID
	AND (ma.Active = 0 OR sa.Active = 0 OR ma.CancelDate < sysdate OR sa.CancelDate < sysdate OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) < sysdate)
	AND esy.Created = 1
	AND esy.Active = 1

UNION ALL

SELECT esy.ExternalSyncID, 4096 AS TransTypeID,authlogin_ AS authlogin,authpassword_ AS authpassword,
sa.Login, sa.Password, sa.FirstName, sa.LastName, d.MailDomain AS Domain

FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND sa.DomainID = d.DomainID
	AND (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1

UNION ALL

SELECT esy.ExternalSyncID, 65536 AS TransTypeID,authlogin_ AS authlogin,authpassword_ AS authpassword,
sa.Login, sa.Password, sa.FirstName, sa.LastName, d.MailDomain AS Domain

FROM SubAccounts sa, MasterAccounts ma, ExternalSystemAccountTypes esat, ExternalSyncs esy, Domains d
	WHERE sa.CustomerID = ma.CustomerID
	AND sa.AccountTypeID = esat.AccountTypeID
	AND esat.ExternalSystemID =ESID_
	AND esy.AccountID = sa.AccountID
	AND esy.ExternalSystemID =ESID_
	AND sa.DomainID = d.DomainID
	AND ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND sa.Password <> esy.Password
	AND DATALENGTH(sa.Password) > 1;
END;
END;
/

CREATE OR REPLACE PROCEDURE ESEnom (crESEnom1 IN OUT ieatypes.CursorType,ESID_ IN INTEGER,Stage_ IN INTEGER) AS
BEGIN
DECLARE
Login_ VARCHAR2(64);
Password_ VARCHAR2(64);
OptionID_ VARCHAR2(15);
AddressTypeID_ INTEGER;
HostRecord_ SMALLINT;
BEGIN

SELECT MIN(es.Login),MIN(es.Password),COALESCE(MIN(es.Aux1),'1054'),CASE WHEN MIN(es.Aux2) LIKE '%1%' THEN 1 ELSE 0 END,MIN(at1.AddressTypeID) INTO Login_,Password_,OptionID_,HostRecord_,AddressTypeID_ 

FROM ExternalSystems es LEFT JOIN AddressTypes at1 ON (es.Aux3 = at1.AddressType)
	WHERE es.ExternalSystemID =ESID_;
IF (Stage_ = 1) THEN
INSERT INTO Domains (Domain,MailDomain,Description,CustomerID)
SELECT sa.Login,sa.Login,sa.Login,sa.CustomerID
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN Domains d ON (sa.Login = d.MailDomain)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND g.Active = 1
	AND sa.Login LIKE '%[a-z0-9].[a-z]%'
	AND d.DomainID IS NULL
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate);
INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT ESID_, sa.AccountID
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.Login = d.MailDomain AND ma.CustomerID = d.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND g.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND esy.AccountID IS NULL;
END IF;


IF (Stage_ = 1) THEN
OPEN crESEnom1 FOR SELECT esy.ExternalSyncID, 2048 AS TransTypeID,Login_ AS "uid",Password_ AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
ma.Company AS RegistrantOrganizationName,
CASE WHEN a.AddressID IS NULL THEN ma.FirstName ELSE a.FirstName END AS RegistrantFirstName,
CASE WHEN a.AddressID IS NULL THEN ma.LastName ELSE a.LastName END AS RegistrantLastName,
CASE WHEN a.AddressID IS NULL THEN ma.Address1 ELSE a.Address1 END AS RegistrantAddress1,
CASE WHEN a.AddressID IS NULL THEN ma.Address2 ELSE a.Address2 END AS RegistrantAddress2,
CASE WHEN a.AddressID IS NULL THEN ma.City ELSE a.City END AS RegistrantCity,
CASE WHEN a.AddressID IS NULL THEN COALESCE(s.Abbreviation,s.State) ELSE COALESCE(ads.Abbreviation,ads.State) END AS RegistrantStateProvince,
CASE WHEN a.AddressID IS NULL THEN ma.Zip ELSE a.Zip END AS RegistrantPostalCode,
CASE WHEN a.AddressID IS NULL THEN c.Country ELSE adc.Country END AS RegistrantCountry,
CASE WHEN a.AddressID IS NULL THEN 'dns@' || sa.Login ELSE a.Email END AS RegistrantEmailAddress,
CASE WHEN a.AddressID IS NULL THEN ma.PhoneWork ELSE a.Phone END AS RegistrantPhone,
CASE WHEN a.AddressID IS NULL THEN ma.PhoneFax ELSE a.Fax END AS RegistrantFax,
CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END AS NumYears,
NULL AS NewOptionID

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID =ESID_)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN Countries c ON (ma.CountryID = c.CountryID)
	LEFT JOIN States s ON (ma.StateID = s.StateID AND ma.CountryID = s.CountryID)
	LEFT JOIN Addresses a ON (ma.CustomerID = a.CustomerID AND a.AddressTypeID =AddressTypeID_)
	LEFT JOIN Countries adc ON (a.CountryID = adc.CountryID)
	LEFT JOIN States ads ON (a.StateID = ads.StateID AND a.CountryID = ads.CountryID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND g.Active IN (1,0)
	AND (esy.Created = 1 OR ma.Active = 1)
	AND (esy.Created = 1 OR sa.Active = 1)
	AND (esy.Created = 1 OR g.Active = 1)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (esy.Created = 0 OR esy.LastUpdate < ma.LastModifyDate);
END IF;

IF (Stage_ = 2) THEN
OPEN crESEnom1 FOR SELECT esy.ExternalSyncID, 1024 AS TransTypeID,Login_ AS "uid",Password_ AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
ma.Company AS RegistrantOrganizationName,
CASE WHEN a.AddressID IS NULL THEN ma.FirstName ELSE a.FirstName END AS RegistrantFirstName,
CASE WHEN a.AddressID IS NULL THEN ma.LastName ELSE a.LastName END AS RegistrantLastName,
CASE WHEN a.AddressID IS NULL THEN ma.Address1 ELSE a.Address1 END AS RegistrantAddress1,
CASE WHEN a.AddressID IS NULL THEN ma.Address2 ELSE a.Address2 END AS RegistrantAddress2,
CASE WHEN a.AddressID IS NULL THEN ma.City ELSE a.City END AS RegistrantCity,
CASE WHEN a.AddressID IS NULL THEN COALESCE(s.Abbreviation,s.State) ELSE COALESCE(ads.Abbreviation,ads.State) END AS RegistrantStateProvince,
CASE WHEN a.AddressID IS NULL THEN ma.Zip ELSE a.Zip END AS RegistrantPostalCode,
CASE WHEN a.AddressID IS NULL THEN c.Country ELSE adc.Country END AS RegistrantCountry,
CASE WHEN a.AddressID IS NULL THEN 'dns@' || sa.Login ELSE a.Email END AS RegistrantEmailAddress,
CASE WHEN a.AddressID IS NULL THEN ma.PhoneWork ELSE a.Phone END AS RegistrantPhone,
CASE WHEN a.AddressID IS NULL THEN ma.PhoneFax ELSE a.Fax END AS RegistrantFax,
CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END AS NumYears,
NULL AS NewOptionID

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID =ESID_)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	LEFT JOIN Countries c ON (ma.CountryID = c.CountryID)
	LEFT JOIN States s ON (ma.StateID = s.StateID AND ma.CountryID = s.CountryID)
	LEFT JOIN Addresses a ON (ma.CustomerID = a.CustomerID AND a.AddressTypeID =AddressTypeID_)
	LEFT JOIN Countries adc ON (a.CountryID = adc.CountryID)
	LEFT JOIN States ads ON (a.StateID = ads.StateID AND a.CountryID = ads.CountryID)
	WHERE ma.Active = 1 
	AND sa.Active = 1 
	AND g.Active = 1 
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND esy.Created = 0;
END IF;

IF (Stage_ = 3) THEN
OPEN crESEnom1 FOR SELECT esy.ExternalSyncID, 524288 AS TransTypeID,Login_ AS "uid",Password_ AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
NULL AS RegistrantOrganizationName,
NULL AS RegistrantFirstName,
NULL AS RegistrantLastName,
NULL AS RegistrantAddress1,
NULL AS RegistrantAddress2,
NULL AS RegistrantCity,
NULL AS RegistrantStateProvince,
NULL AS RegistrantPostalCode,
NULL AS RegistrantCountry,
NULL AS RegistrantEmailAddress,
NULL AS RegistrantPhone,
NULL AS RegistrantFax,
NULL AS NumYears,
OptionID_ AS NewOptionID
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID =ESID_)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND g.Active IN (1,0)
	AND esy.Created = 1
	AND (esy.Aux1 IS NULL OR esy.Aux1 <> OptionID_) ;
END IF;

IF (Stage_ = 4) THEN
OPEN crESEnom1 FOR SELECT esy.ExternalSyncID, 1048576 AS TransTypeID,Login_ AS "uid",Password_ AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
NULL AS RegistrantOrganizationName,
NULL AS RegistrantFirstName,
NULL AS RegistrantLastName,
NULL AS RegistrantAddress1,
NULL AS RegistrantAddress2,
NULL AS RegistrantCity,
NULL AS RegistrantStateProvince,
NULL AS RegistrantPostalCode,
NULL AS RegistrantCountry,
NULL AS RegistrantEmailAddress,
NULL AS RegistrantPhone,
NULL AS RegistrantFax,
NULL AS NumYears,
OptionID_ AS NewOptionID

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID =ESID_)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND g.Active IN (1,0)
	AND esy.Created = 1
	AND HostRecord_ = 1
	AND (esy.Aux2 IS NULL OR esy.Aux1 <> OptionID_) 

UNION ALL

SELECT esy.ExternalSyncID, 2097152 AS TransTypeID,Login_ AS "uid",Password_ AS PW, SUBSTRING(d.MailDomain,1,CHARINDEX('.',d.MailDomain)-1) AS SLD, SUBSTRING(d.MailDomain,CHARINDEX('.',d.MailDomain)+1,100) AS TLD,
NULL AS RegistrantOrganizationName,
NULL AS RegistrantFirstName,
NULL AS RegistrantLastName,
NULL AS RegistrantAddress1,
NULL AS RegistrantAddress2,
NULL AS RegistrantCity,
NULL AS RegistrantStateProvince,
NULL AS RegistrantPostalCode,
NULL AS RegistrantCountry,
NULL AS RegistrantEmailAddress,
NULL AS RegistrantPhone,
NULL AS RegistrantFax,
CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END AS NumYears,
NULL AS NewOptionID

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID =ESID_)
	JOIN Domains d ON (ma.CustomerID = d.CustomerID AND sa.Login = d.MailDomain)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN PayPeriods pp ON (sa.PayPeriodID = pp.PayPeriodID)
	WHERE ma.Active = 1
	AND sa.Active = 1 
	AND g.Active = 1
	AND esy.Created = 1
	AND d.ExpireDate < DATEADD(dd,15,sysdate)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate);
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE ESEnomUP (ExternalSyncID_ IN INTEGER,TransTypeID_ IN INTEGER,Data_ IN VARCHAR2,Retcode_ IN INTEGER) AS
BEGIN
DECLARE
numyears_ INTEGER;
DomainID_ INTEGER;
BEGIN

IF (Retcode_ = 0) THEN

IF (TransTypeID_ = 1024) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, LastUpdate = sysdate, Created = 1, Active = 1, Aux1 = NULL, Aux2 = NULL, Aux3 = NULL, CreateDate = sysdate, ProcTransID =Data_
	WHERE ExternalSyncID =ExternalSyncID_;
SELECT CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END,d.DomainID INTO numyears_,DomainID_ 

FROM SubAccounts sa, ExternalSyncs esy, PayPeriods pp, Domains d
	WHERE sa.AccountID = esy.AccountID
	AND esy.ExternalSyncID =ExternalSyncID_
	AND sa.PayPeriodID = pp.PayPeriodID
	AND sa.CustomerID = d.CustomerID
	AND sa.Login = d.MailDomain;
UPDATE Domains SET ExpireDate = DATEADD(yy,numyears_ ,sysdate) WHERE DomainID =DomainID_;
END IF;

IF (TransTypeID_ = 2048) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, LastUpdate = sysdate, Created = 1
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 2097152) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Aux3 =Data_
	WHERE ExternalSyncID =ExternalSyncID_;
SELECT CASE WHEN pp.PeriodTypeID = 1 AND pp.Period > 12 THEN pp.Period / 12 ELSE 1 END,d.DomainID INTO numyears_,DomainID_ 

FROM SubAccounts sa, ExternalSyncs esy, PayPeriods pp, Domains d
	WHERE sa.AccountID = esy.AccountID
	AND esy.ExternalSyncID =ExternalSyncID_
	AND sa.PayPeriodID = pp.PayPeriodID
	AND sa.CustomerID = d.CustomerID
	AND sa.Login = d.MailDomain;
UPDATE Domains SET ExpireDate = DATEADD(yy,numyears_ ,ExpireDate) WHERE DomainID =DomainID_;
END IF;

ELSE
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message =Data_, LastModifyDate = sysdate WHERE ExternalSyncID =ExternalSyncID_;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE CardUnusedReset (crCardUnusedReset1 IN OUT ieatypes.CursorType,reset_ IN INTEGER,agemax_ IN INTEGER) AS
BEGIN
OPEN crCardUnusedReset1 FOR SELECT 'Oracle Not Supported' AS ErrorMsg
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE CardAccountRecharge (crCardAccountRecharge1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER,CardLogin_ IN VARCHAR2,CardPassword_ IN VARCHAR2) AS
BEGIN
DECLARE
CustomerID_ INTEGER;
RC_ SMALLINT;
OrganizationID_ INTEGER;
AccountTypeID_ INTEGER;
CardAccountID_ INTEGER;
TimeLeft_ INTEGER;
DataLeft_ NUMBER(38);
ActiveExpireDays_ INTEGER;
ActiveExpireMins_ INTEGER;
DirectAmount_ NUMERIC(18,4);
AutoBill_ INTEGER;
PaymentID_ INTEGER;
trackmode_ INTEGER;
BEGIN

SELECT MAX(CardAccountID),COALESCE(MAX(cb.TimeLeft),0),COALESCE(MAX(cb.DataLeft),0),COALESCE(MAX(cb.DirectAmount),0),COALESCE(MAX(cb.ActiveExpireDays),0),COALESCE(MAX(cb.ActiveExpireMins),0) INTO CardAccountID_,TimeLeft_,DataLeft_,DirectAmount_,ActiveExpireDays_,ActiveExpireMins_ 

FROM CardAccounts ca, CardBatches cb
	WHERE ca.CardBatchID = cb.CardBatchID
	AND ca.Login =CardLogin_ 
	AND ca.Password =CardPassword_;
SELECT MAX(ma.CustomerID),MAX(sa.AccountTypeID),MAX(g.OrganizationID),MAX(bc.AutoBill) INTO CustomerID_,AccountTypeID_,OrganizationID_,AutoBill_ 

FROM MasterAccounts ma, SubAccounts sa, Groups g, BillingCycles bc
	WHERE ma.CustomerID = sa.CustomerID
	AND ma.GroupID = g.GroupID
	AND ma.BillingCycleID = bc.BillingCycleID
	AND ma.Active = 1 
	AND sa.Active = 1
	AND g.Active = 1
	AND sa.AccountID =AccountID_
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate);
SELECT NumValue INTO trackmode_  FROM Configs WHERE ConfigID = 535;
SELECT COALESCE(MAX(cgd.NumValue),trackmode_ ) INTO trackmode_ 

FROM ConfigGroupData cgd, MasterAccounts ma
	WHERE ma.CustomerID =CustomerID_
	AND ma.GroupID = cgd.GroupID
	AND cgd.ConfigID = 535;
IF (CardAccountID_ IS NOT NULL AND CustomerID_ IS NOT NULL) THEN
UPDATE CardAccounts SET UsedForDirect = 1, FirstUseDate = sysdate, DirectCustomerID =CustomerID_, DirectAccountID =AccountID_
	WHERE Active = 1
	AND UsedForCredit = 0
	AND AllowDirect = 1
	AND UsedForDirect = 0
	AND OrganizationID =OrganizationID_
	AND CardAccountID =CardAccountID_
	AND (InactiveExpireDate IS NULL OR InactiveExpireDate > sysdate)
	AND CardBatchID IN (SELECT cb.CardBatchID FROM CardBatches cb WHERE cb.Active = 1 AND cb.AccountTypeID =AccountTypeID_);
IF (SQL%ROWCOUNT = 1) THEN

IF (trackmode_ = 2 AND (TimeLeft_ > 0 OR DataLeft_ > 0)) THEN
	INSERT INTO SubAccountUsages (AccountID,TimeLeft,DataLeft,StartTimeLeft,StartDataLeft,ExpireDate)
	SELECT AccountID_,TimeLeft_ ,DataLeft_ ,TimeLeft_ ,DataLeft_ ,DATEADD(mi,ActiveExpireMins_ ,DATEADD(dd,CASE WHEN ActiveExpireDays_ = 0 AND ActiveExpireMins_ = 0 THEN 720 ELSE ActiveExpireDays_ END,sysdate))
	FROM SubAccounts 
		WHERE AccountID =AccountID_;
END IF;

	UPDATE SubAccounts SET	TimeLeft = CASE WHEN TimeLeft IS NULL OR TimeLeft_ = 0 OR trackmode_ = 2 THEN TimeLeft WHEN TimeLeft <= 0 THEN TimeLeft_ ELSE TimeLeft + TimeLeft_ END,
				DataLeft = CASE WHEN DataLeft IS NULL OR DataLeft_ = 0 OR trackmode_ = 2 THEN DataLeft WHEN DataLeft <= 0 THEN DataLeft_ ELSE DataLeft + DataLeft_ END,
				ExpireDate = CASE WHEN PackageID IS NOT NULL OR ExpireDate IS NULL OR (ActiveExpireDays_ = 0 AND ActiveExpireMins_ = 0) THEN ExpireDate WHEN AutoBill_ = 2 AND ExpireDate < sysdate THEN DATEADD(mi,ActiveExpireMins_ ,DATEADD(dd,ActiveExpireDays_ ,sysdate)) ELSE DATEADD(mi,ActiveExpireMins_ ,DATEADD(dd,ActiveExpireDays_ ,ExpireDate)) END,
				BilledThru = CASE WHEN PackageID IS NOT NULL OR BilledThru IS NULL OR (ActiveExpireDays_ = 0 AND ActiveExpireMins_ = 0) THEN BilledThru WHEN AutoBill_ = 2 AND BilledThru < sysdate THEN DATEADD(mi,ActiveExpireMins_ ,DATEADD(dd,ActiveExpireDays_ ,sysdate)) ELSE DATEADD(mi,ActiveExpireMins_ ,DATEADD(dd,ActiveExpireDays_ ,BilledThru)) END
	WHERE AccountID =AccountID_;
IF (DirectAmount_ > 0) THEN
		INSERT INTO Payments (CustomerID, Amount, CreateDate, BatchID, PaymentTypeID, PayInfo, DistFlag, LastModifyDate, LastModifyUser)
		VALUES(CustomerID_,DirectAmount_ ,sysdate,NULL,32,'prepaid recharge credit',1,sysdate,'prepaid auto');
SELECT LAST.IDENT INTO PaymentID_ 

 FROM DUAL;
END IF;

SELECT 0 INTO RC_ 


 FROM DUAL;
ELSE
SELECT -3 INTO RC_ 

 FROM DUAL;
END IF;

ELSE
SELECT CASE WHEN CustomerID_ IS NULL THEN -1 ELSE -2 END INTO RC_ 

 FROM DUAL;
END IF;

OPEN crCardAccountRecharge1 FOR SELECT RC_ AS Status,CustomerID_ AS CustomerID,PaymentID_ AS PaymentID
 FROM DUAL;
END;
END;
/

CREATE OR REPLACE PROCEDURE BackupDevInfo (crBackupDevInfo1 IN OUT ieatypes.CursorType,devname_ IN VARCHAR2) AS
BEGIN
OPEN crBackupDevInfo1 FOR SELECT 'Use Oracle Backup Tools' AS BackupDescription,'N/A' AS ServerName, 'N/A' AS DatabaseName, NULL AS BackupSize, NULL AS BackupFinishDate
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE BackupDB (crBackupDB1 IN OUT ieatypes.CursorType,devname_ IN VARCHAR2,description_ IN VARCHAR2) AS
BEGIN
OPEN crBackupDB1 FOR SELECT 'Use Oracle Backup Tools'
 FROM DUAL;
END;
/

CREATE OR REPLACE PROCEDURE RateVRules (crRateVRules1 IN OUT ieatypes.CursorType,RateRuleID_ IN INTEGER) AS
BEGIN


INSERT INTO rvrtmp (RuleCounter,RateVCondGroupID,DNIS,Attribute,RateMatchTypeID,IntervalCost,InitialCost,StaticCost)
SELECT ROWNUM AS RuleCounter, vdgi.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, CASE WHEN vdi.IntervalOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.IntervalCost AS IntervalCost, NULL AS InitialCost, NULL AS StaticCost
FROM RateVRates vr, RateVDNISGroupItems vdgi, RateVDNIS vd, RateVDNISItems vdi
	WHERE vr.RateVDNISGroupID = vdgi.RateVDNISGroupID
	AND vdgi.RateVDNISID = vd.RateVDNISID
	AND vd.RateVDNISID = vdi.RateVDNISID
	AND vdi.StaticCost IS NULL
	AND vdi.IntervalCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID =RateRuleID_

UNION
SELECT ROWNUM + 20000000 AS RuleCounter, vdgi.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, NULL AS IntervalCost, CASE WHEN vdi.InitialOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.InitialCost AS InitialCost, NULL AS StaticCost
FROM RateVRates vr, RateVDNISGroupItems vdgi, RateVDNIS vd, RateVDNISItems vdi
	WHERE vr.RateVDNISGroupID = vdgi.RateVDNISGroupID
	AND vdgi.RateVDNISID = vd.RateVDNISID
	AND vd.RateVDNISID = vdi.RateVDNISID
	AND vdi.StaticCost IS NULL
	AND vdi.InitialCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID =RateRuleID_

UNION
SELECT ROWNUM + 40000000 AS RuleCounter, vdgi.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, NULL AS IntervalCost, NULL AS InitialCost, CASE WHEN vdi.StaticOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.StaticCost AS StaticCost
FROM RateVRates vr, RateVDNISGroupItems vdgi, RateVDNIS vd, RateVDNISItems vdi
	WHERE vr.RateVDNISGroupID = vdgi.RateVDNISGroupID
	AND vdgi.RateVDNISID = vd.RateVDNISID
	AND vd.RateVDNISID = vdi.RateVDNISID
	AND vdi.StaticCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID =RateRuleID_

UNION
SELECT ROWNUM + 60000000 AS RuleCounter, vr.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, CASE WHEN vdi.IntervalOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.IntervalCost AS IntervalCost, NULL AS InitialCost, NULL AS StaticCost
FROM RateVRates vr, RateVDNIS vd, RateVDNISItems vdi
	WHERE vr.RateVDNISID = vd.RateVDNISID
	AND vd.RateVDNISID = vdi.RateVDNISID
	AND vdi.StaticCost IS NULL
	AND vdi.IntervalCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID =RateRuleID_

UNION
SELECT ROWNUM + 80000000 AS RuleCounter, vr.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, NULL AS IntervalCost, CASE WHEN vdi.InitialOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.InitialCost AS InitialCost, NULL AS StaticCost
FROM RateVRates vr, RateVDNIS vd, RateVDNISItems vdi
	WHERE vr.RateVDNISID = vd.RateVDNISID
	AND vd.RateVDNISID = vdi.RateVDNISID
	AND vdi.StaticCost IS NULL
	AND vdi.InitialCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID =RateRuleID_

UNION
SELECT ROWNUM + 100000000 AS RuleCounter, vr.RateVCondGroupID, vdi.DNIS, vd.Attribute, vdi.RateMatchTypeID, NULL AS IntervalCost, NULL AS InitialCost, CASE WHEN vdi.StaticOption = 0 OR vr.Multiplier IS NULL THEN 1 ELSE vr.Multiplier END * vdi.StaticCost AS StaticCost
FROM RateVRates vr, RateVDNIS vd, RateVDNISItems vdi
	WHERE vr.RateVDNISID = vd.RateVDNISID
	AND vd.RateVDNISID = vdi.RateVDNISID
	AND vdi.StaticCost IS NOT NULL
	AND vr.Active = 1
	AND vr.RateRuleID =RateRuleID_;

OPEN crRateVRules1 FOR SELECT vci.Attribute, t.RuleCounter AS GroupingID, vci.RateMatchTypeID AS MatchTypeID, vci.Data, t.IntervalCost AS Cost, vcg.Priority
FROM rvrtmp t, RateVCondGroups vcg, RateVCondItems vci
	WHERE t.RateVCondGroupID = vcg.RateVCondGroupID
	AND vcg.RateVCondGroupID = vci.RateVCondGroupID

UNION ALL
SELECT 'Default' AS Attribute, 0 AS GroupingID, 128 AS MatchTypeID, NULL AS Data, DefaultCost AS Cost, NULL AS Priority
FROM RateRules
	WHERE RateRuleID =RateRuleID_

UNION ALL
SELECT Attribute, RuleCounter AS GroupingID, RateMatchTypeID AS MatchTypeID, DNIS AS Data, COALESCE(IntervalCost,(SELECT DefaultCost FROM RateRules WHERE RateRuleID=RateRuleID_)) AS Cost, NULL AS Priority
FROM rvrtmp
	WHERE IntervalCost IS NOT NULL OR StaticCost IS NOT NULL OR InitialCost IS NOT NULL

UNION ALL
SELECT 'InitialCost' AS Attribute, RuleCounter AS GroupingID, 256 AS MatchTypeID, CAST(InitialCost AS VARCHAR(32)) AS Data, IntervalCost AS Cost, NULL AS Priority
FROM rvrtmp t
	WHERE InitialCost IS NOT NULL

UNION ALL
SELECT 'StaticCost' AS Attribute, RuleCounter AS GroupingID, 256 AS MatchTypeID, CAST(StaticCost AS VARCHAR(32)) AS Data, IntervalCost AS Cost, NULL AS Priority
FROM rvrtmp
	WHERE StaticCost IS NOT NULL
ORDER BY 2,1;
DELETE FROM rvrtmp;
END;
/

CREATE OR REPLACE PROCEDURE ShowCustomerNextBillDay (crShowCustomerNextBillDay1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER) AS
BEGIN
DECLARE
bd_ INTEGER;
BEGIN

SELECT Case When ma.PaymentTypeID in (8,16) then EBillDays else IBillDays END INTO bd_ 

From BillingCycles bc, MasterAccounts ma
Where bc.BillingCycleID = ma.BillingCycleID 
	and ma.CustomerID =CustomerID_;
OPEN crShowCustomerNextBillDay1 FOR Select DATEADD(dd, 0-bd_, (select Min(ExpireDate) From SubAccounts Where CustomerID =CustomerID_ and Active = 1)) as BillDay
 FROM DUAL;
END;
END;
/

CREATE OR REPLACE PROCEDURE CheckInvoices (crCheckInvoices1 IN OUT ieatypes.CursorType,fixinvoices_ IN INTEGER) AS
BEGIN

INSERT INTO chkitmp (InvoiceID,CustomerID,Name,CreateDate,InvoiceAmount,CalcInvoiceAmount,Condition)
SELECT i.InvoiceID, MIN(ma.CustomerID) AS CustomerID, MIN(ma.FirstName || ' ' || ma.LastName) AS Name, 
MIN(i.CreateDate) AS CreateDate, MIN(ROUND(i.Amount,2)) AS InvoiceAmount, COALESCE(SUM(ROUND(ii.Amount * ii.Quantity,2)),0) AS CalcInvoiceAmount,
CASE	WHEN SUM(CASE WHEN ii.Description LIKE '%Days' THEN ROUND(ii.Amount,2) ELSE ROUND(ii.Amount * ii.Quantity,2) END) = MIN(i.Amount) THEN 1
	WHEN SUM(ROUND(ii.Amount,2)) = MIN(i.Amount) THEN 2
	WHEN SUM(CASE WHEN c.ChargeID IS NOT NULL THEN ROUND(c.Amount * c.Quantity,2) ELSE ROUND(ii.Amount * ii.Quantity,2) END) = MIN(i.Amount) THEN 3
ELSE NULL END AS Condition
FROM Invoices i LEFT JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	JOIN MasterAccounts ma ON (i.CustomerID = ma.CustomerID)
	LEFT JOIN Charges c ON (ii.ChargeID = c.ChargeID)
	WHERE i.VoidDate IS NULL
GROUP BY i.InvoiceID
HAVING MIN(ROUND(i.Amount,2)) <> SUM(COALESCE(ROUND(ii.Amount * ii.Quantity,2),0));
IF (fixinvoices_ IN (1,2,3)) THEN
UPDATE InvoiceItems SET Quantity = 1
	WHERE Description LIKE '%Days'
	AND InvoiceID IN (SELECT InvoiceID FROM chkitmp WHERE Condition = 1);
UPDATE InvoiceItems SET Quantity = 1
	WHERE InvoiceID IN (SELECT InvoiceID FROM chkitmp WHERE Condition = 2);

MERGE INTO InvoiceItems mii
USING (SELECT ii.ItemID, c.Amount, c.Quantity
FROM InvoiceItems ii, Charges c,chkitmp t
	WHERE ii.InvoiceID = t.InvoiceID
	AND ii.ChargeID = c.ChargeID
	AND t.Condition = 3) ii
ON (mii.ItemID = ii.ItemID)
WHEN MATCHED THEN UPDATE SET mii.Amount = ii.Amount, mii.Quantity = ii.Quantity;


IF (fixinvoices_ = 2) THEN

	MERGE INTO InvoiceItems mii
	USING (SELECT ii.itemID, ii.Amount + ((t.InvoiceAmount - t.CalcInvoiceAmount) / ii.Quantity) AS Amount
	FROM InvoiceItems ii,chkitmp t
		WHERE ii.InvoiceID = t.InvoiceID
		AND ii.ItemID = (SELECT MIN(ItemID) FROM InvoiceItems ii2 WHERE ii2.InvoiceID = t.InvoiceID AND ii2.Quantity > 0)
		AND t.Condition IS NULL) ii
	ON (mii.ItemID = ii.ItemID)
	WHEN MATCHED THEN UPDATE SET mii.Amount = ii.Amount;

END IF;

IF (fixinvoices_ = 3) THEN
	INSERT INTO InvoiceItems (InvoiceID,ItemType,Description,StartDate,EndDate,Amount,Quantity,PaidAmount)
	SELECT t.InvoiceID, CASE WHEN t.InvoiceAmount - t.CalcInvoiceAmount < 0 THEN 1 ELSE 2 END,'Conversion Adjustment',t.CreateDate,t.CreateDate,t.InvoiceAmount - t.CalcInvoiceAmount,1,0
	FROM chkitmp t
		WHERE t.InvoiceAmount <> t.CalcInvoiceAmount;
END IF;

ELSE
OPEN crCheckInvoices1 FOR SELECT t.InvoiceID, t.CustomerID, t.Name, t.CreateDate, t.InvoiceAmount, t.CalcInvoiceAmount, 
CASE WHEN t.Condition = 1 THEN 'E2.5 Prorate Qty Error' 
WHEN t.Condition = 2 THEN 'General Qty Error' 
WHEN t.Condition = 3 THEN 'Use Charge Amount'
ELSE 'N/A' END AS Comments
FROM chkitmp t;
END IF;

DELETE FROM chkitmp;
END;
/

CREATE OR REPLACE PROCEDURE RadGetRejectAttributes (crRadGetRejectAttributes1 IN OUT ieatypes.CursorType) AS
BEGIN
OPEN crRadGetRejectAttributes1 FOR SELECT RadLogMsgID,ServerID,RadVendorID,RadAttributeID,Data
FROM RadRejectAttributes;
END;
/

CREATE OR REPLACE PROCEDURE ESHelm (crESHelm1 IN OUT ieatypes.CursorType,ESID_ IN INTEGER,Stage_ IN INTEGER) AS
BEGIN

IF (Stage_ = 1) THEN
INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT ESID_, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esat.ExternalRef IS NOT NULL
	AND esy.AccountID IS NULL
	AND sa.Login IS NOT NULL
	AND DATALENGTH(sa.Password) > 2
	AND es.Aux1 IS NOT NULL
	AND sad.Data = '1';

OPEN crESHelm1 FOR SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
1024 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ma.Company AS CompanyName,
sa.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
sa.Email AS AdminEmailAddress,
sa.FirstName, sa.LastName,
ma.Address1, ma.Address2, 
CASE WHEN COALESCE(s.Abbreviation,s.State) IS NOT NULL THEN COALESCE(ma.City,' ') || ', ' || COALESCE(s.Abbreviation,s.State) ELSE ma.City END AS Town,
ma.Zip AS PostCode,
c.Abbr2 AS CountryCode,
NULL AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
NULL AS PackageID,
NULL AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	LEFT JOIN Countries c ON (ma.CountryID = c.CountryID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL
	AND esat.ExternalRef IS NOT NULL
	AND sad.Data = '1';
END IF;

IF (Stage_ = 2) THEN
OPEN crESHelm1 FOR SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
524288 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ma.Company AS CompanyName,
sa.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
sa.Email AS AdminEmailAddress,
sa.FirstName, sa.LastName,
ma.Address1, ma.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
CASE WHEN sad.Data = 1 THEN esy.ProcTransID ELSE (SELECT MIN(es2.ProcTransID)
		FROM ExternalSyncs es2, SubAccounts sa2, SubAccountData sad2 
			WHERE es2.AccountID=sa2.AccountID
			AND sa2.CustomerID=ma.CustomerID
			AND sa2.Active=1
			AND es2.ExternalSystemID =ESID_
			AND (sa2.CancelDate IS NULL OR sa2.CancelDate > sysdate)
			AND es2.ProcTransID IS NOT NULL
			AND sa2.AccountID=sad2.AccountID 
			AND sad2.AccountDataTypeID=23) END AS UserAccountID,
esat.ExternalRef AS PlanID,
sa.Login || ' (' || at1.AccountType || ')' AS PackageName,
NULL AS PackageID,
NULL AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 1
	AND esy.Aux1 IS NULL
	AND ((sad.Data = '1' AND esy.ProcTransID IS NOT NULL) OR (sad.Data = '2' AND EXISTS (SELECT * 
		FROM ExternalSyncs es2, SubAccounts sa2, SubAccountData sad2 
			WHERE es2.AccountID=sa2.AccountID
			AND sa2.CustomerID=ma.CustomerID
			AND es2.ExternalSystemID =ESID_
			AND sa2.Active=1
			AND (sa2.CancelDate IS NULL OR sa2.CancelDate > sysdate)
			AND es2.ProcTransID IS NOT NULL
			AND sa2.AccountID=sad2.AccountID 
			AND sad2.AccountDataTypeID=23)))
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL
	AND esat.ExternalRef IS NOT NULL;
END IF;

IF (Stage_ = 3) THEN
OPEN crESHelm1 FOR SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
1048576 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ma.Company AS CompanyName,
sa.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
sa.Email AS AdminEmailAddress,
sa.FirstName, sa.LastName,
ma.Address1, ma.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
CASE WHEN sad.Data = 1 THEN esy.ProcTransID ELSE (SELECT MIN(es2.ProcTransID)
		FROM ExternalSyncs es2, SubAccounts sa2, SubAccountData sad2 
			WHERE es2.AccountID=sa2.AccountID
			AND sa2.CustomerID=ma.CustomerID
			AND sa2.Active=1
			AND es2.ExternalSystemID =ESID_
			AND (sa2.CancelDate IS NULL OR sa2.CancelDate > sysdate)
			AND es2.ProcTransID IS NOT NULL
			AND sa2.AccountID=sad2.AccountID 
			AND sad2.AccountDataTypeID=23) END AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
esy.Aux1 AS PackageID,
sa.Login AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 1
	AND esy.Aux1 IS NOT NULL
	AND esy.Aux2 IS NULL
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL
	AND esat.ExternalRef IS NOT NULL
	AND ((sad.Data = '1' AND esy.ProcTransID IS NOT NULL) OR (sad.Data IN ('2','3') AND EXISTS (SELECT * 
		FROM ExternalSyncs es2, SubAccounts sa2, SubAccountData sad2 
			WHERE es2.AccountID=sa2.AccountID
			AND sa2.CustomerID=ma.CustomerID
			AND es2.ExternalSystemID =ESID_
			AND sa2.Active=1
			AND (sa2.CancelDate IS NULL OR sa2.CancelDate > sysdate)
			AND es2.ProcTransID IS NOT NULL
			AND sa2.AccountID=sad2.AccountID 
			AND sad2.AccountDataTypeID=23)));
END IF;

IF (Stage_ = 4) THEN
OPEN crESHelm1 FOR SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
262144 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ma.Company AS CompanyName,
sa.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
sa.Email AS AdminEmailAddress,
sa.FirstName, sa.LastName,
ma.Address1, ma.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
esy.ProcTransID AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
esy.Aux1 AS PackageID,
sa.Login AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((ma.CancelDate <= sysdate) OR (sa.CancelDate <= sysdate) OR (DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) <= sysdate) )
	AND esy.Created = 1
	AND esy.Active = 1
	AND esat.ExternalRef IS NOT NULL
	AND sad.Data = '1'
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
131072 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ma.Company AS CompanyName,
sa.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
sa.Email AS AdminEmailAddress,
sa.FirstName, sa.LastName,
ma.Address1, ma.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
esy.ProcTransID AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
esy.Aux1 AS PackageID,
sa.Login AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 1
	AND esy.Active = 0
	AND esat.ExternalRef IS NOT NULL
	AND sad.Data = '1'
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT es.Login AS Username, 
es.Password, 
es.Aux1 AS AccountName,
esy.ExternalSyncID, 
4096 AS TransTypeID, 
es.Aux2 AS AccountRoleId, 
sa.Login AS NewAccountName,
ma.Company AS CompanyName,
sa.Email AS AccountEmailAddress,
sa.Login AS AdminLoginName,
sa.Password AS AdminLoginPassword,
sa.Email AS AdminEmailAddress,
sa.FirstName, sa.LastName,
ma.Address1, ma.Address2, 
NULL AS Town,
NULL AS PostCode,
NULL AS CountryCode,
esy.ProcTransID AS UserAccountID,
esat.ExternalRef AS PlanID,
NULL AS PackageName,
esy.Aux1 AS PackageID,
sa.Login AS DomainName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 23)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE (ma.Active IN (0,-1) OR sa.Active IN (0,-1))
	AND esy.Created = 1
	AND esat.ExternalRef IS NOT NULL
	AND sad.Data = '1'
	AND esy.ProcTransID IS NOT NULL;
END IF;

END;
/

CREATE OR REPLACE PROCEDURE ESCPanel (crESCPanel1 IN OUT ieatypes.CursorType,ESID_ IN INTEGER,Stage_ IN INTEGER) AS
BEGIN

IF (Stage_ = 1) THEN
INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT ESID_, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esy.AccountID IS NULL
	AND sa.Login IS NOT NULL
	AND DATALENGTH(sa.Password) > 2;

OPEN crESCPanel1 FOR SELECT 1024 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, 
sa.Login, COALESCE(esat.ExternalRef,at1.AccountType) AS cplan, sa.Password AS SAPassword, sa.Email, CASE WHEN sad.Data IS NOT NULL AND sad.Data LIKE '%.%' THEN 'y' ELSE 'n' END AS ip, sad.Data AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL;
END IF;

IF (Stage_ = 2) THEN

OPEN crESCPanel1 FOR SELECT 524288 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl,
sa.Login, COALESCE(esat.ExternalRef,at1.AccountType) AS cplan,
NULL AS SAPassword, NULL AS Email, NULL AS ip, NULL AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 1
	AND esy.Aux1 <> COALESCE(esat.ExternalRef,at1.AccountType)
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL;
OPEN crESCPanel1 FOR SELECT 65536 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, sa.Login, sa.Password AS SAPassword,
NULL AS cplan, NULL AS Email, NULL AS ip, NULL AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 1
	AND esy.Password <> sa.Password
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL;
OPEN crESCPanel1 FOR SELECT 262144 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, sa.Login, 
CASE WHEN ma.CancelDate < sysdate OR sa.CancelDate < sysdate THEN 'Account canceled' ELSE 'Account Expired' END AS reason,
NULL AS cplan, NULL AS SAPassword, NULL AS Email, NULL AS ip, NULL AS customip

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)

	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((ma.CancelDate <= sysdate) OR (sa.CancelDate <= sysdate) OR (DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) <= sysdate) )
	AND esy.Created = 1
	AND esy.Active = 1
	AND esy.ProcTransID IS NOT NULL;
OPEN crESCPanel1 FOR SELECT 131072 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, sa.Login,
NULL AS cplan, NULL AS SAPassword, NULL AS Email, NULL AS ip, NULL AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 1
	AND esy.Active = 0
	AND esy.ProcTransID IS NOT NULL;
OPEN crESCPanel1 FOR SELECT 4096 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, sa.Login,
NULL AS cplan, NULL AS SAPassword, NULL AS Email, NULL AS ip, NULL AS customip, NULL AS reason

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE (ma.Active IN (0,-1) OR sa.Active IN (0,-1))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL;
END IF;

END;
/

CREATE OR REPLACE PROCEDURE ESDirectAdmin (crESDirectAdmin1 IN OUT ieatypes.CursorType,ESID_ IN INTEGER,Stage_ IN INTEGER) AS
BEGIN

IF (Stage_ = 1) THEN
INSERT INTO ExternalSyncs (ExternalSystemID, AccountID)
SELECT ESID_, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs esy ON (sa.AccountID = esy.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND esy.AccountID IS NULL
	AND sa.Login IS NOT NULL
	AND DATALENGTH(sa.Password) > 2;

OPEN crESDirectAdmin1 FOR SELECT 1024 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, 
sa.Login, sad2.Data AS domain, COALESCE(esat.ExternalRef,at1.AccountType) AS package, sa.Password, sa.Email, sad.Data AS ip
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	LEFT JOIN SubAccountData sad2 ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 25)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 0
	AND DATALENGTH(sa.Password) > 4
	AND sad2.Data IS NOT NULL
	AND sa.Login IS NOT NULL;
END IF;

IF (Stage_ = 2) THEN

OPEN crESDirectAdmin1 FOR SELECT 65536 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl,
sa.Login, sa.Password
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 24)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 1
	AND esy.Password <> sa.Password
	AND DATALENGTH(sa.Password) > 4
	AND sa.Login IS NOT NULL;
OPEN crESDirectAdmin1 FOR SELECT 262144 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, 
sa.Login, CASE WHEN ma.CancelDate < sysdate OR sa.CancelDate < sysdate THEN 'Account canceled' ELSE 'Account Expired' END AS reason
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)

	WHERE ma.Active = 1
	AND sa.Active = 1
	AND ((ma.CancelDate <= sysdate) OR (sa.CancelDate <= sysdate) OR (DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) <= sysdate) )
	AND esy.Created = 1
	AND esy.Active = 1
	AND esy.ProcTransID IS NOT NULL;
OPEN crESDirectAdmin1 FOR SELECT 131072 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl, 
sa.Login

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 1
	AND esy.Active = 0
	AND esy.ProcTransID IS NOT NULL;
OPEN crESDirectAdmin1 FOR SELECT 4096 AS TransTypeID, esy.ExternalSyncID, es.LogFile AS baseurl,
sa.Login

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE (ma.Active IN (0,-1) OR sa.Active IN (0,-1))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL;
END IF;

END;
/

CREATE OR REPLACE PROCEDURE MBRCloseAutoList (crMBRCloseAutoList1 IN OUT ieatypes.CursorType) AS
BEGIN
DECLARE
Days_ INTEGER;
CancelReasonID_ INTEGER;
BEGIN

SELECT NumValue INTO Days_  FROM Configs WHERE ConfigID = 376;
SELECT NumValue INTO CancelReasonID_  FROM Configs WHERE ConfigID = 375;
OPEN crMBRCloseAutoList1 FOR SELECT ma.CustomerID, COALESCE(MAX(cgdc.NumValue),CancelReasonID_ ) AS CancelReasonID, MAX(COALESCE(p.ExpireDate,sa.ExpireDate)) AS CancelDate
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	LEFT JOIN ConfigGroupData cgdd ON (ma.GroupID = cgdd.GroupID AND cgdd.ConfigID = 376)
	LEFT JOIN ConfigGroupData cgdc ON (ma.GroupID = cgdc.GroupID AND cgdc.ConfigID = 375)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE bc.AutoBill = 0
	AND ma.Active = 1
	AND sa.Active = 1
	AND ma.CancelDate IS NULL
	AND sa.CancelDate IS NULL
	AND (p.PackageID IS NULL OR (p.Active = 1 AND p.CancelDate IS NULL))
	AND sa.ExpireDate IS NOT NULL
	AND COALESCE(cgdc.NumValue,CancelReasonID_ ) IS NOT NULL
	AND COALESCE(cgdd.NumValue,Days_ ) > 0
	AND DATEADD(dd,-COALESCE(cgdd.NumValue,Days_ ),sysdate) > DATEADD(dd,1 + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate)
	AND DATEADD(dd,-COALESCE(cgdd.NumValue,Days_ ),sysdate) > sa.BilledThru
	AND NOT EXISTS (SELECT * FROM SubAccounts sa2 
			WHERE sa2.CustomerID = ma.CustomerID 
			AND sa2.Active = 1
			AND sa2.PackageID IS NULL
			AND ((sa2.ExpireDate IS NULL) OR (DATEADD(dd,-COALESCE(cgdd.NumValue,Days_ ),sysdate) < sa2.BilledThru) OR (DATEADD(dd,-COALESCE(cgdd.NumValue,Days_ ),sysdate) < DATEADD(dd,1 + sa2.Extension + COALESCE(ma.OverDue,0),sa2.ExpireDate))))

	AND NOT EXISTS (SELECT * FROM Packages p2 
			WHERE p2.CustomerID = ma.CustomerID 
			AND p2.Active = 1
			AND ((p2.ExpireDate IS NULL) OR (DATEADD(dd,-COALESCE(cgdd.NumValue,Days_ ),sysdate) < p2.BilledThru) OR (DATEADD(dd,-COALESCE(cgdd.NumValue,Days_ ),sysdate) < DATEADD(dd,1 + p2.Extension + COALESCE(ma.OverDue,0),p2.ExpireDate))))
GROUP BY ma.CustomerID;
END;
END;
/

CREATE OR REPLACE PROCEDURE DomainGlobalUse (crDomainGlobalUse1 IN OUT ieatypes.CursorType,DomainID_ IN INTEGER) AS
BEGIN
DECLARE
CBTCount_ INTEGER;
GroupCount_ INTEGER;
SignupServerCount_ INTEGER;
BEGIN

SELECT COUNT(*) INTO CBTCount_  FROM CardBatchTypes WHERE DomainID = DomainID_;
SELECT COUNT(*) INTO GroupCount_  FROM Groups WHERE DomainID = DomainID_;
SELECT COUNT(*) INTO SignupServerCount_  FROM SignupServers WHERE DomainID = DomainID_;
OPEN crDomainGlobalUse1 FOR SELECT CASE WHEN CBTCount_ > 0 OR GroupCount_ > 0 OR SignupServerCount_ > 0 THEN 1 ELSE 0 END AS GlobalUse

 FROM DUAL;
END;
END;
/

CREATE OR REPLACE PROCEDURE DomainCustAllowed (crDomainCustAllowed1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,AccountTypeID_ IN INTEGER,DomainID_ IN INTEGER) AS
BEGIN
DECLARE
GroupID_ INTEGER;
AllowDomain_ INTEGER;
Allowed_ INTEGER;
BEGIN

SELECT ma.GroupID,pat.AllowCustSetDomain INTO GroupID_,AllowDomain_ 

FROM PackageAccountTypes pat, Packages p, PackageTypes pt, MasterAccounts ma
	WHERE pat.AccountTypeID=AccountTypeID_
	AND pat.PackageTypeID=p.PackageTypeID
	AND p.PackageTypeID=pt.PackageTypeID
	AND p.Active=1
	AND p.CustomerID=CustomerID_
	AND pt.CustomerAccess=1
	AND pat.AllowCustSetDomain = 1
	AND pat.CustomerMax > 0
	AND p.CustomerID = ma.CustomerID;
IF (AllowDomain_ = 1) THEN
SELECT COUNT(*)  INTO Allowed_ 

FROM Domains 
	WHERE DomainID =DomainID_ 
	AND CustomerAccess = 1 
	AND ((GroupID IS NULL AND 1 IN (SELECT GlobalDomains FROM Groups WHERE GroupID =GroupID_))
		OR GroupID =GroupID_
		OR ServiceGroupID IN (SELECT ServiceGroupID FROM ServiceGroupItems WHERE GroupID =GroupID_));
END IF;

OPEN crDomainCustAllowed1 FOR SELECT CASE WHEN Allowed_ > 0 THEN 1 ELSE 0 END AS Allowed
 FROM DUAL;
END;
END;
/

CREATE OR REPLACE PROCEDURE CustSAInfo (crCustSAInfo1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER) AS
BEGIN

OPEN crCustSAInfo1 FOR SELECT ma.PaymentTypeID, ma.CancelDate, bc.AutoBill, 
CASE WHEN sa.RemoteAccess = 2 THEN 1 ELSE 0 END AS SendBill,
CASE WHEN sa.RemoteAccess > 0 THEN 1 ELSE 0 END AS RemoteAccess,
CASE WHEN ma.PendingBalance <= 0 THEN 1 ELSE 0 END AS HaveCredit
FROM SubAccounts sa, MasterAccounts ma, BillingCycles bc 
	WHERE sa.AccountID=AccountID_
	AND ma.CustomerID=sa.CustomerID 
	AND ma.BillingCycleID=bc.BillingCycleID;
END;
/

CREATE OR REPLACE PROCEDURE ESGenericWS (crESGenericWS1 IN OUT ieatypes.CursorType,ESID_ IN INTEGER) AS
BEGIN
DECLARE
APILogin_ VARCHAR2(64);
APIPassword_ VARCHAR2(64);
APIRef_ VARCHAR2(64);
BEGIN
SELECT Login,Password,Aux1 INTO APILogin_,APIPassword_,APIRef_  FROM ExternalSystems WHERE ExternalSystemID = ESID_;
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT ESID_, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND sa.AccountTypeID = esat.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID =ESID_ AND es.AccountID = sa.AccountID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Password) > 2
	AND sa.Login IS NOT NULL
	AND es.ExternalSyncID IS NULL;

OPEN crESGenericWS1 FOR SELECT es.ExternalSyncID, 2048 AS TransTypeID,APILogin_ AS APILogin,APIPassword_ AS APIPassword,APIRef_ AS APIRef, ma.CustomerID, sa.AccountID,
d.MailDomain AS Domain, CASE WHEN d.MailDomain = es.Aux1 THEN 0 ELSE 1 END AS chDomain,
sa.Login, CASE WHEN sa.Login = es.Login THEN 0 ELSE 1 END AS chLogin,
sa.Password, CASE WHEN sa.Password = es.Password THEN 0 ELSE 1 END AS chPassword,
sa.FirstName, CASE WHEN sa.FirstName = es.Aux2 THEN 0 ELSE 1 END AS chFirstName,
sa.LastName, CASE WHEN sa.LastName = es.Aux3 THEN 0 ELSE 1 END AS chLastName,
at1.AccountType AS ServiceType, CASE WHEN es.Aux4 = at1.AccountType THEN 0 ELSE 1 END AS chServiceType,
esat.ExternalRef, CASE WHEN COALESCE(es.Aux5,' ') = COALESCE(esat.ExternalRef,' ') THEN 0 ELSE 1 END AS chExternalRef,
(SELECT MIN(Alias) FROM Aliases WHERE AccountID = sa.AccountID) AS Alias,
CASE WHEN COALESCE(es.Aux6,' ') = COALESCE((SELECT MIN(Alias) FROM Aliases WHERE AccountID = sa.AccountID),' ') THEN 0 ELSE 1 END AS chAlias,
(SELECT MIN(Forward) FROM Forwards WHERE AccountID = sa.AccountID) AS Forward,
CASE WHEN COALESCE(es.Aux7,' ') = COALESCE((SELECT MIN(Forward) FROM Forwards WHERE AccountID = sa.AccountID),' ') THEN 0 ELSE 1 END AS chForward,
CASE WHEN es.Created = 0 THEN 'add' WHEN sa.Active <> 1 OR sa.Active <> 1 THEN 'delete' ELSE 'update' END AS Action,
CASE WHEN ma.Active = 1 
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Password) > 2
	THEN 1 ELSE 0 END AS Active, 

CASE WHEN CASE WHEN ma.Active = 1 
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Password) > 2
	THEN 1 ELSE 0 END = es.Active THEN 0 ELSE 1 END AS chActive

FROM MasterAccounts ma, SubAccounts sa, ExternalSyncs es, AccountTypes at1, ExternalSystemAccountTypes esat, Domains d
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountID = es.AccountID
	AND sa.DomainID = d.DomainID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND esat.ExternalSystemID = es.ExternalSystemID
	AND esat.AccountTypeID = at1.AccountTypeID
	AND es.ExternalSystemID =ESID_
	AND (sa.Active IN (0,-1) 
		OR ma.Active IN (0,-1)
		OR d.MailDomain <> es.Aux1
		OR sa.Login <> es.Login
		OR sa.Password <> es.Password
		OR COALESCE(sa.FirstName,' ') <> COALESCE(es.Aux2,' ')
		OR COALESCE(sa.LastName,' ') <> COALESCE(es.Aux3,' ')
		OR at1.AccountType <> es.Aux4
		OR COALESCE(esat.ExternalRef,' ')  <> COALESCE(es.Aux5,' ')
		OR CASE WHEN ma.Active = 1 
			AND sa.Active = 1
			AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
			AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
			AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
			AND DATALENGTH(sa.Password) > 2
		THEN 1 ELSE 0 END <> es.Active

		OR COALESCE((SELECT MIN(Alias) FROM Aliases WHERE AccountID=sa.AccountID),'') <> COALESCE(es.Aux6,'')
		OR COALESCE((SELECT MIN(Forward) FROM Forwards WHERE AccountID=sa.AccountID),'') <> COALESCE(es.Aux7,'')
	);
END;
END;
/

CREATE OR REPLACE PROCEDURE ESGenericWSUP (ExternalSyncID_ IN INTEGER,TransTypeID_ IN INTEGER,Data_ IN VARCHAR2,Retcode_ IN INTEGER) AS
BEGIN

IF (Retcode_ = 0) THEN
MERGE INTO ExternalSyncs mes USING (SELECT es.ExternalSyncID, sa.Login, sa.Password, sysdate AS LastUpdate, sysdate AS LastModifyDate, 0 AS ErrorCount, NULL AS Message,
d.MailDomain AS Aux1, sa.FirstName AS Aux2, sa.LastName AS Aux3, at1.AccountType AS Aux4, esat.ExternalRef AS Aux5, 
(SELECT MIN(Alias) FROM Aliases WHERE AccountID = sa.AccountID) AS Aux6,
(SELECT MIN(Forward) FROM Forwards WHERE AccountID = sa.AccountID) AS Aux7,
CASE WHEN ma.Active = 1 AND sa.Active = 1 THEN 1 ELSE 0 END AS Created,
CASE WHEN ma.Active = 1 
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Password) > 2
	THEN 1 ELSE 0 END AS Active

FROM MasterAccounts ma, SubAccounts sa, ExternalSyncs es, AccountTypes at1, ExternalSystemAccountTypes esat, Domains d
	WHERE ma.CustomerID = sa.CustomerID
	AND sa.AccountID = es.AccountID
	AND sa.DomainID = d.DomainID
	AND sa.AccountTypeID = at1.AccountTypeID
	AND esat.ExternalSystemID = es.ExternalSystemID
	AND esat.AccountTypeID = at1.AccountTypeID
	AND es.ExternalSyncID =ExternalSyncID_) qes
ON (mes.ExternalSyncID = qes.ExternalSyncID)
WHEN MATCHED THEN UPDATE SET mes.Login = qes.Login, mes.Password = qes.Password, mes.LastUpdate = qes.LastUpdate, mes.LastModifyDate = qes.LastModifyDate, mes.ErrorCount = qes.ErrorCount, mes.Message = qes.Message, mes.Aux1 = qes.Aux1, mes.Aux2 = qes.Aux2, mes.Aux3 = qes.Aux3, mes.Aux4 = qes.Aux4, mes.Aux5 = qes.Aux5, mes.Aux6 = qes.Aux6, mes.Aux7 = qes.Aux7, mes.Created = qes.Created, mes.Active = qes.Active;


DELETE FROM ExternalSyncs WHERE ExternalSyncID =ExternalSyncID_ AND Created = 0;
ELSE
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message =Data_, LastModifyDate = sysdate WHERE ExternalSyncID =ExternalSyncID_;
END IF;
END;
/

CREATE OR REPLACE PROCEDURE MBROpenChkStartDate (crMBROpenChkStartDate1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,startdate_ IN DATE) AS
BEGIN
OPEN crMBROpenChkStartDate1 FOR SELECT DISTINCT i.InvoiceID, i.Amount, i.CreateDate
FROM Invoices i, InvoiceItems ii, SubAccounts sa
	WHERE i.InvoiceID = ii.InvoiceID
	AND ii.AccountID = sa.AccountID
	AND sa.Active = 1
	AND ii.Canceled = 0
	AND i.VoidDate IS NULL
	AND ii.StartDate <> ii.EndDate
	AND ii.Amount <> 0
	AND ii.ItemType = 3
	AND ii.EndDate > startdate_
	AND i.CustomerID =CustomerID_
ORDER BY i.InvoiceID DESC;
END;
/

CREATE OR REPLACE PROCEDURE SAOpenChkStartDate (crSAOpenChkStartDate1 IN OUT ieatypes.CursorType,AccountID_ IN INTEGER,startdate_ IN DATE) AS
BEGIN
OPEN crSAOpenChkStartDate1 FOR SELECT i.InvoiceID, i.Amount, i.CreateDate
FROM SubAccounts sa, Invoices i, InvoiceItems ii
	WHERE sa.CustomerID = i.CustomerID
	AND i.InvoiceID = ii.InvoiceID
	AND sa.AccountID = ii.AccountID
	AND i.VoidDate IS NULL
	AND ii.Canceled = 0
	AND ii.StartDate <> ii.EndDate
	AND ii.Amount <> 0
	AND ii.ItemType = 3
	AND sa.AccountID =AccountID_
	AND ii.EndDate > startdate_
ORDER BY i.InvoiceID DESC;
END;
/

CREATE OR REPLACE PROCEDURE SARateHistory (crSARateHistory1 IN OUT ieatypes.CursorType,CustomerID_ IN INTEGER,AccountID_ IN INTEGER) AS
BEGIN
OPEN crSARateHistory1 FOR SELECT  r.Description AS Rate, rr.RateRule, rs.RateSource, rh.StartDate, DATEADD(mm,1,rh.StartDate) AS EndDate,
rh.TotalCount, (CAST(rh.TotalTime AS NUMERIC(18,4))/3600) as TotalHours, CAST(rh.TotalData AS NUMERIC(18,4))/1000000 AS TotalMB, rh.TotalCost, rh.ChargeID
FROM RateHistory rh JOIN Rates r ON (rh.RateID=r.RateID)
	JOIN RateSources rs ON (r.RateSourceID=rs.RateSourceID)
	JOIN RateRules rr ON (rh.RateRuleID=rr.RateRuleID)
	WHERE rh.AccountID =AccountID_
	AND rh.CustomerID =CustomerID_
ORDER BY rh.StartDate DESC;
END;
/

CREATE OR REPLACE PROCEDURE InvoicePOSCredit (InvoiceID_ IN INTEGER) AS
BEGIN
INSERT INTO Charges (CustomerID,AccountID,PackageID,ChargeTypeID,AccountTypeID,PackageTypeID,ItemID,Login,Description,StartDate,EndDate,DistFlag,Amount,Quantity,LastModifyDate,LastModifyUser)
SELECT i.CustomerID, ii.AccountID, ii.PackageID, ii.ChargeTypeID, ii.AccountTypeID, ii.PackageTypeID, ii.ItemID, ii.Login, ii.Description, ii.StartDate, ii.EndDate, 1, ii.Amount, ii.Quantity, i.LastModifyDate, i.LastModifyUser
FROM Invoices i, InvoiceItems ii
	WHERE i.InvoiceID = ii.InvoiceID
	AND i.InvoiceID =InvoiceID_
	AND ii.Quantity > 0
	AND ii.Amount <= -0.01;
END;
/

CREATE OR REPLACE PROCEDURE ESDiino (crESDiino1 IN OUT ieatypes.CursorType,ESID_ IN INTEGER,Stage_ IN INTEGER) AS
BEGIN

IF (Stage_ = 1) THEN
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT ESID_, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID =ESID_ AND es.AccountID = sa.AccountID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Password) > 5
	AND DATALENGTH(sa.Login) > 5
	AND es.ExternalSyncID IS NULL;

OPEN crESDiino1 FOR SELECT 1024 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, COALESCE(esat.ExternalRef,es.Aux1) AS feature_set_id,
sa.Login AS Username, sa.Password, sa.FirstName, sa.LastName, 
CASE WHEN sa.SendBill = 1 THEN COALESCE(sa.Email,sa.Login || '@' || d.MailDomain) ELSE COALESCE(sa.Email,ma.Email) END AS Email,
c.Abbr2 AS country, NULL AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN Countries c ON (ma.CountryID = c.CountryID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Password) > 5
	AND DATALENGTH(sa.Login) > 5
	AND esy.Created = 0;
END IF;

IF (Stage_ = 2) THEN

OPEN crESDiino1 FOR SELECT 2048 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, COALESCE(esat.ExternalRef,es.Aux1) AS feature_set_id,
NULL AS username, sa.Password, sa.FirstName, sa.LastName, 
CASE WHEN sa.SendBill = 1 THEN COALESCE(sa.Email,sa.Login || '@' || d.MailDomain) ELSE COALESCE(sa.Email,ma.Email) END AS Email,
c.Abbr2 AS country, esy.ProcTransID AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Countries c ON (ma.CountryID = c.CountryID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND DATALENGTH(sa.Password) > 5
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND esy.LastUpdate < sa.LastModifyDate 

UNION ALL

SELECT 131072 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, NULL AS feature_set_id,
NULL AS username, NULL AS Password, NULL AS FirstName, NULL AS LastName, NULL AS Email, NULL AS Country, esy.ProcTransID AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 1
	AND esy.Active = 0
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 262144 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, NULL AS feature_set_id,
NULL AS username, NULL AS Password, NULL AS FirstName, NULL AS LastName, NULL AS Email, NULL AS Country, esy.ProcTransID AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) < sysdate
	AND esy.Created = 1
	AND esy.Active = 1	
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 4096 AS TransTypeID, esy.ExternalSyncID, es.LogFile, es.Login AS partner_id, es.Password AS shared_secret, NULL AS feature_set_id,
NULL AS username, NULL AS Password, NULL AS FirstName, NULL AS LastName, NULL AS Email, NULL AS Country, esy.ProcTransID AS user_id

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL;
END IF;
END;
/

CREATE OR REPLACE PROCEDURE ESEFolderUpdate (ExternalSyncID_ IN INTEGER,TransTypeID_ IN INTEGER,Data_ IN VARCHAR2,Retcode_ IN INTEGER) AS
BEGIN
DECLARE
Login_ VARCHAR2(64);
Aux1_ VARCHAR2(255);
Password_ VARCHAR2(128);
BEGIN

IF (Retcode_ = 0) THEN
SELECT COALESCE(sa.Login,sa.Email),sa.Password,COALESCE(esat.ExternalRef,'') || COALESCE(esat.Description,'') INTO Login_,Password_,Aux1_ 

FROM SubAccounts sa, ExternalSyncs es, ExternalSystemAccountTypes esat
	WHERE sa.AccountID = es.AccountID
	AND es.ExternalSyncID =ExternalSyncID_
	AND es.ExternalSystemID = esat.ExternalSystemID
	AND sa.AccountTypeID = esat.AccountTypeID;
IF (TransTypeID_ = 1024) THEN
UPDATE	ExternalSyncs SET ErrorCount = 0, Message = NULL, Login =Login_, Password =Password_, Aux1 =Aux1_, Aux2 = NULL, Aux3 = NULL, 
	CreateDate = sysdate, LastModifyDate = sysdate, LastUpdate = sysdate, Active = 1, Created = 1, ProcTransID =Data_
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 524288) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Aux1 =Aux1_
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

IF (TransTypeID_ = 1048576) THEN
UPDATE ExternalSyncs SET ErrorCount = 0, Message = NULL, LastModifyDate = sysdate, Aux2 = CASE WHEN Aux2 IS NULL THEN Data_ WHEN CAST(Aux2 AS NUMERIC) < CAST(Data_ AS NUMERIC) THEN Data_ ELSE Aux2 END
	WHERE ExternalSyncID =ExternalSyncID_;
END IF;

ELSE
UPDATE ExternalSyncs SET ErrorCount = ErrorCount + 1, Message =Data_, LastModifyDate = sysdate WHERE ExternalSyncID =ExternalSyncID_;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE ESEFolder (crESEFolder1 IN OUT ieatypes.CursorType,ESID_ IN INTEGER,Stage_ IN INTEGER) AS
BEGIN

IF (Stage_ = 1) THEN
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT ESID_, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID =ESID_ AND es.AccountID = sa.AccountID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND es.ExternalSyncID IS NULL;

OPEN crESEFolder1 FOR SELECT 1024 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
CASE WHEN esat.ExternalRef LIKE '%[0-9]:[0-9]%' THEN SUBSTRING(esat.ExternalRef,1,CHARINDEX(':',esat.ExternalRef)-1) ELSE esat.ExternalRef END AS ServiceplanID,
CASE WHEN esat.ExternalRef LIKE '%[0-9]:[0-9]%' THEN SUBSTRING(esat.ExternalRef,CHARINDEX(':',esat.ExternalRef)+1,20) ELSE NULL END AS expiredays,
esat.Description AS Hardquota,
esy.ProcTransID AS accountno,
sa.Login AS Username,
sa.Password,
ma.Company AS ct_company,
sa.FirstName AS ct_firstname,
sa.Lastname AS ct_lastname,
COALESCE(sa.PhoneHome,ma.PhoneHome) AS ct_phone,
ma.Address1 AS ct_address1,
ma.Address2 AS ct_address2,
ma.City as ct_city,
s.Abbreviation AS ct_state,
ma.Zip AS ct_zip,
c.Abbr2 AS ct_country,
CASE WHEN sa.SendBill = 1 THEN COALESCE(sa.Email,sa.Login || '@' || d.MailDomain) ELSE COALESCE(sa.Email,ma.Email) END AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN Countries c ON (ma.CountryID = c.CountryID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND esy.Created = 0;
END IF;

IF (Stage_ = 2) THEN

OPEN crESEFolder1 FOR SELECT 2048 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
esat.Description AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
ma.Company AS ct_company,
sa.FirstName AS ct_firstname,
sa.Lastname AS ct_lastname,
COALESCE(sa.PhoneHome,ma.PhoneHome) AS ct_phone,
ma.Address1 AS ct_address1,
ma.Address2 AS ct_address2,
ma.City as ct_city,
s.Abbreviation AS ct_state,
ma.Zip AS ct_zip,
c.Abbr2 AS ct_country,
CASE WHEN sa.SendBill = 1 THEN COALESCE(sa.Email,sa.Login || '@' || d.MailDomain) ELSE COALESCE(sa.Email,ma.Email) END AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Countries c ON (ma.CountryID = c.CountryID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND esy.LastUpdate < ma.LastModifyDate 

UNION ALL

SELECT 131072 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 1
	AND esy.Active = 0
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 262144 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) < sysdate
	AND esy.Created = 1
	AND esy.Active = 1	
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 4096 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 65536 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
sa.Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Password <> sa.Password
	AND DATALENGTH(sa.Password) > 1

UNION ALL

SELECT 524288 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
CASE WHEN esat.ExternalRef LIKE '%[0-9]:[0-9]%' THEN SUBSTRING(esat.ExternalRef,1,CHARINDEX(':',esat.ExternalRef)-1) ELSE esat.ExternalRef END AS ServiceplanID,
NULL AS expiredays,
esat.Description AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND (esy.Aux1 IS NULL OR esy.Aux1 <> COALESCE(esat.ExternalRef,'') || COALESCE(esat.Description,''))

UNION ALL
SELECT 1048576 AS TransTypeID,
esy.ExternalSyncID,
es.LogFile,
es.Aux1 AS EFSDEV,
es.Login AS auth_username,
es.Password AS auth_password,
NULL AS ServiceplanID,
NULL AS expiredays,
NULL AS Hardquota,
esy.ProcTransID AS accountno,
NULL AS Username,
NULL AS Password,
NULL AS ct_company,
NULL AS ct_firstname,
NULL AS ct_lastname,
NULL AS ct_phone,
NULL AS ct_address1,
NULL AS ct_address2,
NULL AS ct_city,
NULL AS ct_state,
NULL AS ct_zip,
NULL AS ct_country,
NULL AS ct_email

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND es.Aux2 IS NOT NULL
	AND esy.LastModifyDate < DATEADD(mi,-(CAST(es.Aux2 AS INTEGER)),sysdate);
END IF;
END;
/

CREATE OR REPLACE PROCEDURE ESGMail (crESGMail1 IN OUT ieatypes.CursorType,ESID_ IN INTEGER,Stage_ IN INTEGER) AS
BEGIN
DECLARE
cnt_ INTEGER;
BEGIN

IF (Stage_ = 1) THEN
SELECT COUNT(*) INTO cnt_  FROM ExternalSyncs WHERE ExternalSystemID = ESID_ AND AccountID IS NULL;
IF (cnt_ = 0) THEN
	INSERT INTO ExternalSyncs (ExternalSystemID) VALUES(ESID_);
END IF;

OPEN crESGMail1 FOR SELECT 67108864 AS TransTypeID,
esy.ExternalSyncID,
NULL AS Auth,
'ini' AS ExportFilter,
es.Login AS APILogin,
es.Password AS APIPassword,
NULL AS Login,
NULL AS NewLogin,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName
FROM ExternalSystems es, ExternalSyncs esy
	WHERE es.ExternalSystemID = esy.ExternalSystemID
	AND es.ExternalSystemID =ESID_
	AND esy.AccountID IS NULL
	AND esy.aux1 IS NULL
	AND (esy.Aux8 IS NULL OR esy.LastModifyDate < DATEADD(hh,-2,sysdate));
END IF;

IF (Stage_ = 2) THEN
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT ESID_, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID =ESID_ AND es.AccountID = sa.AccountID AND es.Aux1 IS NULL)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Password) > 5
	AND DATALENGTH(sa.Login) > 1
	AND es.ExternalSyncID IS NULL;
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID,Aux1)
SELECT DISTINCT ESID_, sa.AccountID, CAST(a.AliasID AS VARCHAR(16))
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Aliases a ON (sa.AccountID = a.AccountID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID =ESID_ AND a.AccountID = es.AccountID AND a.AliasID = CAST(es.Aux1 AS INTEGER))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Password) > 5
	AND DATALENGTH(sa.Login) > 1
	AND DATALENGTH(a.Alias) > 1
	AND es.ExternalSyncID IS NULL;

OPEN crESGMail1 FOR SELECT 1024 AS TransTypeID,
esy.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
sa.Login AS Login,
NULL AS NewLogin,
d.MailDomain AS Domain,
sa.Password AS Password,
sa.FirstName AS FirstName,
sa.LastName AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,sysdate))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Password) > 5
	AND DATALENGTH(sa.Login) > 1
	AND esy.Created = 0;
END IF;

IF (Stage_ = 3) THEN

OPEN crESGMail1 FOR SELECT 2097152 AS TransTypeID,
esa.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esa.Aux2 AS Login,
NULL AS NewLogin,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs esa ON (esa.AccountID = sa.AccountID AND esa.ExternalSystemID =ESID_ AND esa.Aux1 IS NOT NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,sysdate))
	LEFT JOIN Aliases a ON (sa.AccountID = a.AccountID AND CAST(esa.Aux1 AS INTEGER) = a.AliasID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND DATALENGTH(esa.Aux2) > 1
	AND esa.Aux2 IS NOT NULL
	AND A.AliasID IS NULL

UNION ALL

SELECT 1048576 AS TransTypeID,
esa.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esy.Login AS Login,
a.Alias AS NewLogin,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs esa ON (esa.AccountID = sa.AccountID AND esa.ExternalSystemID =ESID_ AND esa.Aux1 IS NOT NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,sysdate))
	JOIN Aliases a ON (sa.AccountID = a.AccountID AND CAST(esa.Aux1 AS INTEGER) = a.AliasID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND DATALENGTH(a.Alias) > 1
	AND esa.Aux2 IS NULL

UNION ALL

SELECT 2048 AS TransTypeID,
esy.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esy.Login AS Login,
NULL AS NewLogin,
d.MailDomain AS Domain,
sa.Password AS Password,
sa.FirstName AS FirstName,
sa.LastName AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,sysdate))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND (esy.LastUpdate < sa.LastModifyDate OR esy.LastUpdate < ma.LastModifyDate)

UNION ALL

SELECT 131072 AS TransTypeID,
esy.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esy.Login AS Login,
NULL AS NewLogin,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,sysdate))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 1
	AND esy.Active = 0
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 262144 AS TransTypeID,
esy.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esy.Login AS Login,
NULL AS NewLogin,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,sysdate))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) < sysdate
	AND esy.Created = 1
	AND esy.Active = 1	
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 65536 AS TransTypeID,
esy.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esy.Login AS Login,
NULL AS NewLogin,
d.MailDomain AS Domain,
sa.Password AS Password,
NULL AS FirstName,
NULL AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,sysdate))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Password <> sa.Password
	AND DATALENGTH(sa.Password) > 5;
END IF;

IF (Stage_ = 4) THEN
OPEN crESGMail1 FOR SELECT 4096 AS TransTypeID,
esy.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esy.Login AS Login,
NULL AS NewLogin,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,sysdate))
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 8192 AS TransTypeID,
esy.ExternalSyncID,
auth.Aux8 AS Auth,
NULL AS APILogin,
NULL AS APIPassword,
esy.Login AS Login,
sa.Login AS NewLogin,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(hh,-2,sysdate))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Login <> sa.Login;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE ESAptilo (crESAptilo1 IN OUT ieatypes.CursorType,ESID_ IN INTEGER,Stage_ IN INTEGER) AS
BEGIN

IF (Stage_ = 1) THEN
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT ESID_, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND sa.AccountTypeID = esat.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID =ESID_ AND es.AccountID = sa.AccountID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Login) > 1
	AND es.ExternalSyncID IS NULL;

OPEN crESAptilo1 FOR SELECT 1024 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
sa.Login || '@' || d.MailDomain AS Username,
sa.FirstName AS FirstName,
sa.LastName AS LastName,
CAST(DATEPART(yy,sa.StartDate) AS VARCHAR(16)) || '-' || RIGHT('00' || CAST(DATEPART(mm,sa.StartDate) AS VARCHAR(2)),2) || '-' || RIGHT('00' || CAST(DATEPART(dd,sa.StartDate) AS VARCHAR(2)),2) AS BeginDate,
CAST(DATEPART(yy,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(16)) || '-' || RIGHT('00' || CAST(DATEPART(mm,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(2)),2) || '-' || RIGHT('00' || CAST(DATEPART(dd,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(2)),2) AS EndDate,
CAST(DATEPART(yy,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(16)) || '-' || RIGHT('00' || CAST(DATEPART(mm,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) || '-' || RIGHT('00' || CAST(DATEPART(dd,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) AS PurgeAfter,
esat.ExternalRef AS Accessprofile,
esat.Description AS Serviceprofiles,
COALESCE(ma.Email,sa.Email) AS Email,
COALESCE(sa.PhoneHome,sa.PhoneWork) AS Phonenumber,
CASE WHEN at1.DataLeft IS NOT NULL THEN 'BytesLeft=' || CAST(at1.DataLeft AS VARCHAR(16)) END accountinfo,
CASE WHEN sa.LoginLimit IS NULL THEN 0 WHEN sa.LoginLimit = 0 THEN 1 ELSE sa.LoginLimit END AS Concurrentlogins,
CASE WHEN at1.DataLeft IS NULL THEN 'normal' ELSE 'bytereducer' END AS Accounttype,
NULL AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Login) > 1
	AND esy.Created = 0;
END IF;

IF (Stage_ = 2) THEN

OPEN crESAptilo1 FOR SELECT 2048 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
esy.ProcTransID AS Username,
sa.FirstName AS FirstName,
sa.LastName AS LastName,
CAST(DATEPART(yy,sa.StartDate) AS VARCHAR(16)) || '-' || RIGHT('00' || CAST(DATEPART(mm,sa.StartDate) AS VARCHAR(2)),2) || '-' || RIGHT('00' || CAST(DATEPART(dd,sa.StartDate) AS VARCHAR(2)),2) AS BeginDate,
CAST(DATEPART(yy,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(16)) || '-' || RIGHT('00' || CAST(DATEPART(mm,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(2)),2) || '-' || RIGHT('00' || CAST(DATEPART(dd,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(2)),2) AS EndDate,
CAST(DATEPART(yy,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(16)) || '-' || RIGHT('00' || CAST(DATEPART(mm,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) || '-' || RIGHT('00' || CAST(DATEPART(dd,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) AS PurgeAfter,
esat.ExternalRef AS Accessprofile,
esat.Description AS Serviceprofiles,
COALESCE(ma.Email,sa.Email) AS Email,
COALESCE(sa.PhoneHome,sa.PhoneWork) AS Phonenumber,
NULL AS accountinfo,
CASE WHEN sa.LoginLimit IS NULL THEN 0 WHEN sa.LoginLimit = 0 THEN 1 ELSE sa.LoginLimit END AS Concurrentlogins,
CASE WHEN at1.DataLeft IS NULL THEN 'timereducer' ELSE 'bytereducer' END AS Accounttype,
NULL AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL
	AND esy.LastUpdate < sa.LastModifyDate 

UNION ALL

SELECT 4096 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
esy.ProcTransID AS Username,
NULL AS FirstName,
NULL AS LastName,
NULL AS BeginDate,
NULL AS EndDate,
NULL AS PurgeAfter,
NULL AS Accessprofile,
NULL AS Serviceprofiles,
NULL AS Email,
NULL AS Phonenumber,
NULL AS accountinfo,
NULL AS Concurrentlogins,
NULL AS Accounttype,
NULL AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1
	AND esy.ProcTransID IS NOT NULL

UNION ALL

SELECT 524288 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
esy.ProcTransID AS Username,
NULL AS FirstName,
NULL AS LastName,
NULL AS BeginDate,
NULL AS EndDate,
NULL AS PurgeAfter,
NULL AS Accessprofile,
NULL AS Serviceprofiles,
NULL AS Email,
NULL AS Phonenumber,
CASE WHEN at1.DataLeft IS NOT NULL THEN 'BytesLeft=' || CAST(at1.DataLeft AS VARCHAR(16)) END AS accountinfo,
NULL AS Concurrentlogins,
NULL AS Accounttype,
CAST(sa.LastDataLeftDate AS VARCHAR(32)) AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND at1.DataLeft IS NOT NULL
	AND (esy.Aux1 IS NULL OR esy.Aux1 <> CAST(sa.LastDataLeftDate AS VARCHAR(32)))

UNION ALL

SELECT 1048576 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin,
es.Password AS APIPassword,
esy.ProcTransID AS Username,
NULL AS FirstName,
NULL AS LastName,
CAST(DATEPART(yy,sa.StartDate) AS VARCHAR(16)) || '-' || RIGHT('00' || CAST(DATEPART(mm,sa.StartDate) AS VARCHAR(2)),2) || '-' || RIGHT('00' || CAST(DATEPART(dd,sa.StartDate) AS VARCHAR(2)),2) AS BeginDate,
CAST(DATEPART(yy,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(16)) || '-' || RIGHT('00' || CAST(DATEPART(mm,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(2)),2) || '-' || RIGHT('00' || CAST(DATEPART(dd,DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate)) AS VARCHAR(2)),2) AS EndDate,
CAST(DATEPART(yy,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(16)) || '-' || RIGHT('00' || CAST(DATEPART(mm,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) || '-' || RIGHT('00' || CAST(DATEPART(dd,DATEADD(yy,1,sa.BilledThru)) AS VARCHAR(2)),2) AS PurgeAfter,
NULL AS Accessprofile,
NULL AS Serviceprofiles,
NULL AS Email,
NULL AS Phonenumber,
NULL AS accountinfo,
NULL AS Concurrentlogins,
NULL AS Accounttype,
CAST(DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) AS VARCHAR(32)) AS Data

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN AccountTypes at1 ON (sa.AccountTypeID = at1.AccountTypeID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID AND esat.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND (esy.Aux2 IS NULL OR esy.Aux2 <> CAST(DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) AS VARCHAR(32)));
END IF;
END;
/

CREATE OR REPLACE PROCEDURE ESZimbra (crESZimbra1 IN OUT ieatypes.CursorType,ESID_ IN INTEGER,Stage_ IN INTEGER) AS
BEGIN
DECLARE
cnt_ INTEGER;
BEGIN

IF (Stage_ = 1) THEN
SELECT COUNT(*) INTO cnt_  FROM ExternalSyncs WHERE ExternalSystemID = ESID_ AND AccountID IS NULL;
IF (cnt_ = 0) THEN
	INSERT INTO ExternalSyncs (ExternalSystemID) VALUES(ESID_);
END IF;

OPEN crESZimbra1 FOR SELECT 67108864 AS TransTypeID,
esy.ExternalSyncID,
es.Login AS APILogin, 
es.Password AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
NULL AS ProcTransID,
NULL AS AuthToken,
NULL AS COSID

FROM ExternalSystems es, ExternalSyncs esy
	WHERE es.ExternalSystemID = esy.ExternalSystemID
	AND es.ExternalSystemID =ESID_
	AND esy.AccountID IS NULL
	AND esy.aux1 IS NULL
	AND (esy.Aux8 IS NULL OR esy.LastModifyDate < DATEADD(mi,-30,sysdate));
END IF;

IF (Stage_ = 2) THEN
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID)
SELECT DISTINCT ESID_, sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID =ESID_ AND es.AccountID = sa.AccountID AND es.Aux1 IS NULL)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND es.ExternalSyncID IS NULL;
INSERT INTO ExternalSyncs (ExternalSystemID,AccountID,Aux1)
SELECT DISTINCT ESID_, sa.AccountID, a.Alias
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Aliases a ON (sa.AccountID = a.AccountID)
	LEFT JOIN ExternalSyncs es ON (es.ExternalSystemID =ESID_ AND a.AccountID = es.AccountID AND a.Alias = es.Aux1)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND DATALENGTH(a.Alias) > 1
	AND es.ExternalSyncID IS NULL;

OPEN crESZimbra1 FOR SELECT 1024 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
sa.Login AS Login,
d.MailDomain AS Domain,
sa.Password AS Password,
sa.FirstName AS FirstName,
sa.LastName AS LastName,
ma.Address1 AS Address1,
ma.City AS City,
s.State AS State,
ma.Zip AS Zip,
COALESCE(ma.PhoneHome,ma.PhoneWork) AS Phone,
ma.Company AS Company,
(SELECT MIN(f.Forward) FROM Forwards f WHERE f.AccountID = sa.AccountID AND DATALENGTH(f.Forward) > 1) AS MailForward,
NULL AS MailAlias,
NULL AS ProcTransID,
auth.Aux8 AS AuthToken,
COALESCE(esat.ExternalRef,es.Aux1) AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,sysdate))
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND DATALENGTH(sa.Password) > 1
	AND DATALENGTH(sa.Login) > 1
	AND esy.Created = 0;
END IF;

IF (Stage_ = 3) THEN

OPEN crESZimbra1 FOR SELECT 2048 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
sa.FirstName AS FirstName,
sa.LastName AS LastName,
ma.Address1 AS Address1,
ma.City AS City,
s.State AS State,
ma.Zip AS Zip,
COALESCE(ma.PhoneHome,ma.PhoneWork) AS Phone,
ma.Company AS Company,
(SELECT MIN(f.Forward) FROM Forwards f WHERE f.AccountID = sa.AccountID AND DATALENGTH(f.Forward) > 1) AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
COALESCE(esat.ExternalRef,es.Aux1) AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,sysdate))
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND (esy.LastUpdate < sa.LastModifyDate OR esy.LastUpdate < ma.LastModifyDate)

UNION ALL

SELECT 131072 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,sysdate))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND (ma.CancelDate IS NULL OR ma.CancelDate > sysdate)
	AND (sa.CancelDate IS NULL OR sa.CancelDate > sysdate)
	AND (sa.ExpireDate IS NULL OR DATEADD(dd,sa.Extension + 1 + COALESCE(ma.OverDue,0),sa.ExpireDate) > sysdate)
	AND esy.Created = 1
	AND esy.Active = 0

UNION ALL

SELECT 262144 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,sysdate))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND DATEADD(dd,CASE WHEN COALESCE(sa.CancelDate,ma.CancelDate) < sysdate THEN 1 ELSE sa.Extension + 1 + COALESCE(ma.OverDue,0) END,sa.ExpireDate) < sysdate
	AND esy.Created = 1
	AND esy.Active = 1	

UNION ALL

SELECT 8192 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
sa.Login AS Login,
d.MailDomain AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,sysdate))
	WHERE esy.Created = 1
	AND esy.Login <> sa.Login

UNION ALL

SELECT 65536 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
sa.Password AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,sysdate))
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esy.Password <> sa.Password
	AND DATALENGTH(sa.Password) > 1

UNION ALL

SELECT 1048576 AS TransTypeID,
esa.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
a.Alias AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs esa ON (esa.AccountID = sa.AccountID AND esa.ExternalSystemID =ESID_ AND esa.Aux1 IS NOT NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,sysdate))
	JOIN Aliases a ON (sa.AccountID = a.AccountID AND esa.Aux1 = a.Alias)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND DATALENGTH(a.Alias) > 1
	AND esa.Aux2 IS NULL

UNION ALL

SELECT 2097152 AS TransTypeID,
esa.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
esa.Aux1 AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs esa ON (esa.AccountID = sa.AccountID AND esa.ExternalSystemID =ESID_ AND esa.Aux1 IS NOT NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,sysdate))
	LEFT JOIN Aliases a ON (sa.AccountID = a.AccountID AND esa.Aux1 = a.Alias)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND esy.Created = 1
	AND esa.Aux2 IS NOT NULL
	AND A.AliasID IS NULL

UNION ALL

SELECT 4096 AS TransTypeID,
esy.ExternalSyncID,
NULL AS APILogin, 
NULL AS APIPassword,
NULL AS Login,
NULL AS Domain,
NULL AS Password,
NULL AS FirstName,
NULL AS LastName,
NULL AS Address1,
NULL AS City,
NULL AS State,
NULL AS Zip,
NULL AS Phone,
NULL AS Company,
NULL AS MailForward,
NULL AS MailAlias,
esy.ProcTransID AS ProcTransID,
auth.Aux8 AS AuthToken,
NULL AS COSID

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (esat.ExternalSystemID =ESID_ AND esat.AccountTypeID = sa.AccountTypeID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystems es ON (es.ExternalSystemID =ESID_)
	JOIN ExternalSyncs esy ON (esy.AccountID = sa.AccountID AND esy.ExternalSystemID =ESID_ AND esy.Aux1 IS NULL)
	JOIN ExternalSyncs auth ON (auth.ExternalSystemID =ESID_ AND auth.AccountID IS NULL AND auth.Aux8 IS NOT NULL AND auth.LastModifyDate > DATEADD(mi,-45,sysdate))
	WHERE (ma.Active IN (-1,0) OR sa.Active IN (-1,0))
	AND esy.Created = 1;
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE CallsMissing (crCallsMissing1 IN OUT ieatypes.CursorType,numdays_ IN INTEGER) AS
BEGIN
OPEN crCallsMissing1 FOR SELECT c.NASIdentifier,
SUM(CASE WHEN c.AcctStatusType = 1 AND c2.AcctStatusType IS NULL THEN 1 ELSE 0 END) AS MissingStopCount, 
SUM(CASE WHEN c.AcctStatusType = 2 AND c2.AcctStatusType IS NULL THEN 1 ELSE 0 END) AS MissingStartCount
FROM Calls c LEFT JOIN Calls c2 ON (c.CallID <> c2.CallID AND c.NASIdentifier = c2.NASIdentifier AND c.AcctSessionID = c2.AcctSessionID AND c.NASPort = c2.NASPort AND c.Username = c2.Username)
	WHERE c.CallDate > DATEADD(dd,-numdays_,sysdate)
GROUP BY c.NASIdentifier
ORDER BY 2 DESC, 3 DESC;
END;
/

CREATE OR REPLACE PROCEDURE CallsMissingDetail (crCallsMissingDetail1 IN OUT ieatypes.CursorType,numdays_ IN INTEGER) AS
BEGIN
OPEN crCallsMissingDetail1 FOR SELECT DISTINCT c.CallDate,c.CallID,c.AccountID,c.UserName,
CASE WHEN c.AcctStatusType = 1 THEN 'Stop' ELSE 'Start' END AS Missing, CASE WHEN sp.AcctSessionID IS NULL THEN 'No' ELSE 'Yes' END AS Online, c.NASIdentifier,c.AcctSessionID,
CAST(c.AcctOutputOctets / 1000000.0 AS NUMERIC(18,2)) AS DownloadMB,
CAST(c.AcctInputOctets / 1000000.0 AS NUMERIC(18,2)) AS UploadMB,
CAST(c.AcctSessionTime / 60.0 AS NUMERIC(18,2)) AS SessionMins,c.AcctDelayTime
FROM Calls c LEFT JOIN Calls c2 ON (c.CallID <> c2.CallID AND c.NASIdentifier = c2.NASIdentifier AND c.AcctSessionID = c2.AcctSessionID AND c.NASPort = c2.NASPort AND c.Username = c2.Username)
	LEFT JOIN ServerPorts sp ON (c.AcctSessionID = sp.AcctSessionID AND sp.NASIdentifier = c.NASIdentifier AND c.NASPort = sp.Port AND c.Username = sp.Username)
	WHERE c.CallDate > DATEADD(dd,-numdays_,sysdate)
	AND c.AcctStatusType IN (1,2)
	AND ((c.AcctStatusType = 1 AND c2.AcctStatusType IS NULL)
		OR (c.AcctStatusType = 2 AND c2.AcctStatusType IS NULL))
ORDER BY 7,6,1,3,5;
END;
/

CREATE OR REPLACE PROCEDURE CallsMissingDetail (crCallsMissingDetail1 IN OUT ieatypes.CursorType,numdays_ IN INTEGER) AS
BEGIN
OPEN crCallsMissingDetail1 FOR SELECT DISTINCT c.CallDate,c.CallID,c.AccountID,c.UserName,
CASE WHEN c.AcctStatusType = 1 THEN 'Stop' ELSE 'Start' END AS Missing, CASE WHEN sp.AcctSessionID IS NULL THEN 'No' ELSE 'Yes' END AS Online, c.NASIdentifier,c.AcctSessionID,
CAST(c.AcctOutputOctets / 1000000.0 AS NUMERIC(18,2)) AS DownloadMB,
CAST(c.AcctInputOctets / 1000000.0 AS NUMERIC(18,2)) AS UploadMB,
CAST(c.AcctSessionTime / 60.0 AS NUMERIC(18,2)) AS SessionMins,c.AcctDelayTime
FROM Calls c LEFT JOIN Calls c2 ON (c.CallID <> c2.CallID AND c.NASIdentifier = c2.NASIdentifier AND c.AcctSessionID = c2.AcctSessionID AND c.NASPort = c2.NASPort AND c.Username = c2.Username)
	LEFT JOIN ServerPorts sp ON (c.AcctSessionID = sp.AcctSessionID AND sp.NASIdentifier = c.NASIdentifier AND c.NASPort = sp.Port AND c.Username = sp.Username)
	WHERE c.CallDate > DATEADD(dd,-numdays_,sysdate)
	AND c.AcctStatusType IN (1,2)
	AND ((c.AcctStatusType = 1 AND c2.AcctStatusType IS NULL)
		OR (c.AcctStatusType = 2 AND c2.AcctStatusType IS NULL))
ORDER BY 7,6,1,3,5;
END;

CREATE PROCEDURE dbo.AssignStaticIP(IPAddress_ VARCHAR(64),AccountID_ INT) AS 
IF (IPAddress_ IS NOT NULL AND AccountID_ IS NOT NULL) THEN
UPDATE RadIPAddresses SET State = 2, AccountID =AccountID_ WHERE State = 0 AND IPAddress =IPAddress_;
IF (SQL%ROWCOUNT = 0) THEN
OPEN crCallsMissingDetail1 FOR 	SELECT 'IP Address ' || IPAddress_ || ' not in pool or already assigned/unavailable' AS Status
 FROM DUAL;
ELSE
	UPDATE RadIPAddresses SET State = 0, AccountID = NULL WHERE State = 2 AND AccountID =AccountID_ AND IPAddress <> IPAddress_;
OPEN crCallsMissingDetail1 FOR 	SELECT 'IP Address ' || IPAddress_ || ' successfully assigned' AS Status
 FROM DUAL;
END IF;
ELSE
OPEN crCallsMissingDetail1 FOR SELECT 'IP and AccountID required' AS Status
 FROM DUAL;
END IF;
END;
/

CREATE OR REPLACE PROCEDURE RateVDNISClear (RateVDNISID_ IN INTEGER) AS
BEGIN
DELETE FROM RateVDNISItems WHERE RateVDNISID =RateVDNISID_;
END;
/

CREATE OR REPLACE PROCEDURE RateVDNISImport (RateVDNISID_ IN INTEGER,prefix_ IN VARCHAR2,rate_ IN NUMERIC,label_ IN VARCHAR2,location_ IN VARCHAR2,country_ IN VARCHAR2,state_ IN VARCHAR2) AS
BEGIN
DECLARE
CountryID_ INTEGER;
StateID_ INTEGER;
BEGIN

IF (country_ IS NOT NULL) THEN
SELECT MIN(CountryID) INTO CountryID_  FROM Countries WHERE Country = country_ OR Abbr2 = country_ OR Abbr3 = country_;
END IF;

IF (state_ IS NOT NULL) THEN
SELECT MIN(StateID) INTO StateID_  FROM States WHERE (CountryID_ IS NULL OR CountryID_ = CountryID) AND (State = state_ OR Abbreviation = state_);
END IF;

IF (prefix_ IS NOT NULL AND rate_ IS NOT NULL) THEN
INSERT INTO RateVDNISItems (RateVDNISID,RateVDNISItem,DNIS,Location,RateMatchTypeID,IntervalCost,IntervalOption,CountryID,StateID,SortOrder)
VALUES(RateVDNISID_,COALESCE(label_,prefix_ ),prefix_ ,location_ ,2,rate_ ,1,CountryID_ ,StateID_ ,0);
END IF;
END;
END;
/

CREATE OR REPLACE PROCEDURE NSFullNegSync (crNSFullNegSync1 IN OUT ieatypes.CursorType,id_ IN VARCHAR2) AS
BEGIN
OPEN crNSFullNegSync1 FOR SELECT sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Active = 1
	AND ma.Active = 1
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND (sa.Login <> ' ' OR sa.Email <> ' ')
	AND sa.Password <> ' '
	AND es.Name =id_;
END;
/

CREATE OR REPLACE PROCEDURE NSGetPartial (crNSGetPartial1 IN OUT ieatypes.CursorType,id_ IN VARCHAR2) AS
BEGIN
LDAPSetLastModifyDate('read',id_ );
OPEN crNSGetPartial1 FOR SELECT DISTINCT
sa.AccountID AS x500uniqueIdentifier,
sa.AccountID AS accountid, sa.FirstName || ' ' || sa.LastName AS cn,
CASE WHEN sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1)
END AS "uid",
'mailbox' AS mailDeliveryOption,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
es.MailHost AS mailHost,
sad.Data AS mailQuota,
sa.LastName AS sn,
sa.FirstName AS givenname,
sa.Password AS userpassword,
CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 'inactive' WHEN ma.OverLimit > 0 THEN 'active' WHEN sa.ExpireDate IS NULL AND ma.CancelDate < sysdate THEN 'inactive' WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0) + sa.Extension+1,sa.ExpireDate) < sysdate THEN 'inactive' ELSE 'active' END AS inetuserstatus,
CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 'inactive' WHEN ma.OverLimit > 0 THEN 'active' WHEN sa.ExpireDate IS NULL AND ma.CancelDate < sysdate THEN 'inactive' WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0) + sa.Extension+1,sa.ExpireDate) < sysdate THEN 'inactive' ELSE 'active' END AS mailuserstatus,
CASE WHEN sa.Email IS NULL OR sa.Email = ' ' THEN sa.Login || '@' || d.MailDomain WHEN sa.Email <> ' ' THEN sa.Email ELSE NULL END AS rfc822mailbox,
CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailAlternateAddress

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 3)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	JOIN LDAPServers ls ON (ls.LDAPServer =id_)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND sa.Active = 1
	AND ma.Active = 1
	AND sa.Password <> ' '
	AND (sa.Email <> ' ' OR sa.Login <> ' ')
	AND es.Name =id_;
END;
/

CREATE OR REPLACE PROCEDURE CGPROPartialNegSync (crCGPROPartialNegSync1 IN OUT ieatypes.CursorType,id_ IN VARCHAR2) AS
BEGIN
OPEN crCGPROPartialNegSync1 FOR SELECT CASE 
	WHEN sa.Email LIKE '%___%' THEN 'uid=' || SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) || ',cn=' || RIGHT(sa.Email,DATALENGTH(sa.Email) - CHARINDEX('@',sa.Email)) 
	WHEN sa.Login <> ' ' THEN 'uid=' || sa.Login || ',cn=' || d.MailDomain END AS pk
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE (sa.Active IN (-1,0) OR ma.Active IN (-1,0) OR p.Active IN (-1,0))
	AND (sa.Login <> ' ' OR sa.Email LIKE '%___%')
	AND sa.Password <> ' '
	AND es.Name =id_;
END;
/

CREATE OR REPLACE PROCEDURE CGPROGetPartial (crCGPROGetPartial1 IN OUT ieatypes.CursorType,id_ IN VARCHAR2) AS
BEGIN
LDAPSetLastModifyDate('read',id_ );
OPEN crCGPROGetPartial1 FOR SELECT DISTINCT
CASE
	WHEN sa.Email LIKE '%___%' THEN 'uid=' || SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) || ',cn=' || RIGHT(sa.Email,DATALENGTH(sa.Email) - CHARINDEX('@',sa.Email)) 
	WHEN sa.Login <> ' ' THEN 'uid=' || sa.Login || ',cn=' || d.MailDomain END AS pk,
CASE WHEN sa.Email LIKE '%___%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) WHEN sa.Login <> ' ' THEN sa.Login END AS "uid",
sa.FirstName || ' ' || sa.LastName AS cn,
sa.LastName AS sn,
sa.AccountID,
CASE WHEN (ma.OverLimit > 0 AND ma.OverLimit > ma.PendingBalance) THEN '{crypt}abcdefghijklm'
WHEN (ma.CancelDate < sysdate OR sa.CancelDate < sysdate) THEN '{crypt}abcdefghijklm'
WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0) + sa.Extension+1,sa.ExpireDate) < sysdate THEN '{crypt}abcdefghijklm'
ELSE sa.Password 
END AS userpassword,
CASE WHEN al.Alias IS NULL THEN 
	CASE WHEN sa.Email LIKE '%___%' THEN sa.Email ELSE sa.Login || '@' || d.MailDomain
	END ELSE NULL END AS mail,
es.MailHost AS hostserver,
'clear' AS passwordEncryption
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	JOIN LDAPServers ls ON (ls.LDAPServer =id_)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND sa.Active = 1
	AND ma.Active = 1
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND sa.Password <> ' '
	AND (sa.Email LIKE '%___%' OR sa.Login <> ' ')
	AND es.Name =id_;
END;
/

CREATE OR REPLACE PROCEDURE GeneralGetPartial (crGeneralGetPartial1 IN OUT ieatypes.CursorType,id_ IN VARCHAR2) AS
BEGIN
LDAPSetLastModifyDate('read',id_ );

OPEN crGeneralGetPartial1 FOR SELECT DISTINCT sa.AccountID,
COALESCE(sa.LastName,'N/A') AS sn,
COALESCE(sa.FirstName,' ') || ' ' || COALESCE(sa.LastName,' ') AS cn,
CASE WHEN sa.Email IS NOT NULL AND sa.Email <> ' ' THEN sa.Email ELSE sa.Login END AS "uid",
sa.Password AS userPassword,
g.GroupName AS ou,
CASE WHEN sa.Email IS NULL OR sa.Email = ' ' THEN sa.Login || '@' || d.MailDomain ELSE sa.Email END AS mail,
sa.PhoneHome AS telephoneNumber,
COALESCE(s.Abbreviation,s.State) AS st,
ma.Zip AS postalCode,
sa.AccountID AS uniqueIdentifier,
sa.LastModifyUser AS LastModifiedBy,
sa.LastModifyDate AS LastModifyDate,
ma.Address1 AS streetAddress,
ma.PhoneFax AS facsimileTelephoneNumber,
COALESCE(ma.Company,'N/A') AS o,
CASE 	WHEN p.Active = 0 OR sa.Active = 0 OR ma.Active = 0 THEN 'Inactive' 
	WHEN ma.CancelDate IS NOT NULL AND ma.CancelDate < sysdate THEN 'Canceled'
	WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.PendingBalance THEN 'Over Credit Limit'
	WHEN DATEADD(dd,COALESCE(ma.OverDue,0) + sa.Extension+1,sa.ExpireDate) < sysdate THEN 'Expired'
	ELSE 'Active'
END AS organizationalStatus,
CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS otherMailbox

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	JOIN LDAPServers ls ON (ls.LDAPServer =id_)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND es.Name =id_;
END;
/

CREATE OR REPLACE PROCEDURE GeneralFullNegSync (crGeneralFullNegSync1 IN OUT ieatypes.CursorType,id_ IN VARCHAR2) AS
BEGIN
OPEN crGeneralFullNegSync1 FOR SELECT sa.AccountID AS uniqueIdentifier
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE es.Name =id_
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0);
END;
/

CREATE OR REPLACE PROCEDURE MDGetPartial (crMDGetPartial1 IN OUT ieatypes.CursorType,id_ IN VARCHAR2) AS
BEGIN
LDAPSetLastModifyDate('read',id_ );
OPEN crMDGetPartial1 FOR SELECT DISTINCT
sa.AccountID AS x121Address,
sa.AccountID AS accountid,
sa.FirstName || ' ' || sa.LastName AS cn,
sa.FirstName || ' ' || sa.LastName AS mdFullName,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mdForwardAddress,
'N' AS mdKeepForwardedMail,
CASE WHEN fw.Forward IS NULL THEN 'N' ELSE 'Y' END AS mdIsForwarding,
es.MailHost AS mailHost,
sa.Password AS mdPassword,

CASE WHEN p.Active = 0 OR sa.Active = 0 OR ma.Active = 0 THEN 'N' ELSE
	CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.PendingBalance THEN 'N'
	WHEN (ma.CancelDate < sysdate OR sa.CancelDate < sysdate) THEN 'N'
	WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0) + sa.Extension+1,sa.ExpireDate) < sysdate THEN 'N'
	ELSE 'Y' END
END AS mdAllowAccess,

CASE WHEN sa.Email LIKE '%@%' THEN
sa.Email ELSE CASE WHEN sa.Email <> ' ' THEN sa.Email ELSE sa.Login END || '@' || d.MailDomain
END AS mail,
es.LogFile || '/' || CAST(sa.AccountID AS VARCHAR(10)) || '/' AS mdMailDir, 
ma.Address1 AS mdHomeAddress,
ma.City AS mdHomeCity,
s.State AS mdHomeState,
ma.Zip AS mdHomeZipcode,
c.Country AS mdHomeCountry,
ma.PhoneHome AS mdHomePhone,
ma.PhoneFax AS mdHomeFax,
ma.Company AS mdBusCompany,
ma.PhoneWork AS mdBusPhone

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	LEFT JOIN Countries c ON (ma.CountryID = c.CountryID)
	JOIN LDAPServers ls ON (ls.LDAPServer =id_)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND sa.Password <> ' '
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND (sa.Email <> ' ' OR sa.Login <> ' ')
	AND es.Name =id_;
END;
/

CREATE OR REPLACE PROCEDURE MDFullNegSync (crMDFullNegSync1 IN OUT ieatypes.CursorType,id_ IN VARCHAR2) AS
BEGIN
OPEN crMDFullNegSync1 FOR SELECT CASE WHEN sa.Email LIKE '%@%' THEN sa.Email ELSE CASE WHEN sa.Email <> ' ' THEN sa.Email ELSE sa.Login END || '@' || d.MailDomain END
FROM SubAccounts sa JOIN MasterAccounts ma ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE (sa.Login <> ' ' OR sa.Email <> ' ')
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND sa.Password <> ' '
	AND es.Name =id_;
END;
/

CREATE OR REPLACE PROCEDURE PosixGetPartial (crPosixGetPartial1 IN OUT ieatypes.CursorType,id_ IN VARCHAR2) AS
BEGIN
DECLARE
lmdate_ DATE;
BEGIN
LDAPSetLastModifyDate('read',id_ );
SELECT LastSyncWrite INTO lmdate_ 

FROM LDAPServers
	WHERE LDAPServer =id_;

OPEN crPosixGetPartial1 FOR SELECT DISTINCT sa.AccountID as accountid, pau.PosixAccountUserID+65535 AS uidnumber,
CASE	WHEN ma.Active = 0 OR sa.Active = 0 OR p.Active = 0 THEN 1
	WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.PendingBalance THEN 1
	WHEN ma.CancelDate < sysdate THEN 1
	WHEN ma.OverLimit > 0 THEN NULL
	ELSE DATEDIFF(dd,to_date('1970-01-01','YYYY-MM-DD'),DATEADD(dd,COALESCE(ma.OverDue,0) + sa.Extension+1,sa.ExpireDate)) END AS shadowexpire,
CASE WHEN al.Alias IS NOT NULL THEN NULL ELSE COALESCE(sa.Email,sa.Login || '@' || d.MailDomain) END AS rfc822mailbox,
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
COALESCE(sa.FirstName,' ') || ' ' || COALESCE(sa.LastName,' ') AS cn,
COALESCE(sa.LastName,'N/A') as sn,
COALESCE(sa.FirstName,'N/A') as gn,
CASE WHEN sa.Login IS NOT NULL OR sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE NULL END AS "uid",
CASE WHEN pau.userPassword <> ' ' THEN pau.UserPassword ELSE sa.Password END AS userpassword,
COALESCE(Pau.loginShell,pas.loginShell) AS loginshell,
COALESCE(pau.gidNumber,pas.gidNumber) AS gidNumber,
CASE WHEN pau.homeDirectory <> ' ' THEN pau.homeDirectory ELSE pas.homeDirectory || '/' || CASE WHEN sa.Login IS NOT NULL OR sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) ELSE NULL END END AS homedirectory,
d.MailDomain AS dc

FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	JOIN PosixAccountUsers pau ON (sa.AccountID = pau.AccountID)
	JOIN PosixAccountServers pas ON (pau.PosixAccountServerID = pas.PosixAccountServerID AND sa.AccountTypeID = pas.AccountTypeID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE sa.Password <> ' '
	AND (sa.LastModifyDate > lmdate_ OR ma.LastModifyDate > lmdate_) 
	AND sa.Active IN (1,0)
	AND ma.Active IN (1,0)
	AND pas.LDAPServer =id_;
END;
END;
/

CREATE OR REPLACE PROCEDURE PosixFullNegSync (crPosixFullNegSync1 IN OUT ieatypes.CursorType,id_ IN VARCHAR2) AS
BEGIN
OPEN crPosixFullNegSync1 FOR SELECT pau.PosixAccountUserID AS uidNumber
FROM PosixAccountUsers pau JOIN PosixAccountServers pas ON (pau.PosixAccountServerID = pas.PosixAccountServerID)
	WHERE pas.LDAPServer =id_;
END;
/

CREATE OR REPLACE PROCEDURE QmailGetPartial (crQmailGetPartial1 IN OUT ieatypes.CursorType,id_ IN VARCHAR2) AS
BEGIN
LDAPSetLastModifyDate('read',id_ );
OPEN crQmailGetPartial1 FOR SELECT DISTINCT
sa.AccountID AS x121Address,
sa.AccountID AS accountid, sa.FirstName || ' ' || sa.LastName AS cn,
CASE WHEN sa.Login <> ' ' THEN sa.Login WHEN sa.Email LIKE '%@%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1)
END AS "uid",
CASE WHEN fw.Forward IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailForwardingAddress,
es.MailHost AS mailHost,
sad.Data AS mailQuota,
sa.LastName AS sn,
sa.FirstName AS givenname,
sa.Password AS userpassword,

CASE WHEN p.Active = 0 OR sa.Active = 0 OR ma.Active = 0 THEN 'disabled' ELSE
	CASE WHEN ma.OverLimit > 0 AND ma.OverLimit > ma.Balance THEN 'nopop'
	WHEN ma.OverLimit > 0 THEN 'active'
	WHEN sa.ExpireDate IS NULL AND ma.CancelDate < sysdate THEN 'nopop'
	WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,COALESCE(ma.OverDue,0) + sa.Extension+1,sa.ExpireDate) < sysdate THEN 'nopop'
	ELSE 'active' END END AS accountStatus,
CASE WHEN sa.Email LIKE '%@%' THEN
sa.Email ELSE CASE WHEN sa.Email <> ' ' THEN sa.Email ELSE sa.Login END || '@' || d.MailDomain
END AS mail,
CASE WHEN al.Alias IS NULL THEN 'LDAPNOATTRIBUTE' ELSE NULL END AS mailAlternateAddress, './' || CAST(sa.AccountID AS VARCHAR(10)) || '/' AS mailMessageStore,
CASE WHEN fw.Forward IS NULL THEN 'noforward' ELSE 'nolocal' END AS deliveryMode

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Forwards fw ON (sa.AccountID = fw.AccountID)
	LEFT JOIN Aliases al ON (sa.AccountID = al.AccountID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	LEFT JOIN SubAccountData sad ON (sa.AccountID = sad.AccountID AND sad.AccountDataTypeID = 3)
	JOIN LDAPServers ls ON (ls.LDAPServer =id_)
	WHERE (sa.LastModifyDate > ls.LastSyncWrite OR ma.LastModifydate > ls.LastSyncWrite)
	AND sa.Password <> ' '
	AND (sa.Email <> ' ' OR sa.Login <> ' ')
	AND es.Name =id_
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0);
END;
/

CREATE OR REPLACE PROCEDURE QmailFullNegSync (crQmailFullNegSync1 IN OUT ieatypes.CursorType,id_ IN VARCHAR2) AS
BEGIN
OPEN crQmailFullNegSync1 FOR SELECT sa.AccountID
FROM SubAccounts sa JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	WHERE (sa.Login <> ' ' OR sa.Email <> ' ')
	AND sa.Password <> ' '
	AND ma.Active IN (1,0)
	AND sa.Active IN (1,0)
	AND es.Name =id_;
END;
/

CREATE OR REPLACE PROCEDURE ReportAgingSnapshot (crReportAgingSnapshot1 IN OUT ieatypes.CursorType,snapdate_ IN DATE,OrganizationID_ IN INTEGER,GroupID_ IN INTEGER) AS
BEGIN

INSERT INTO rad (CustomerID, Days, Amount)
SELECT MIN(i.CustomerID), DATEDIFF(dd,MIN(i.CreateDate),snapdate_ ), ROUND(MIN(ii.Amount) * MIN(ii.Quantity),2) - SUM(pi1.Amount)
FROM Invoices i JOIN InvoiceItems ii ON (i.InvoiceID = ii.InvoiceID)
	LEFT JOIN PaymentItems pi1 ON (ii.ItemID = pi1.ItemID AND pi1.ActiveDate <=snapdate_ AND (pi1.InactiveDate IS NULL OR pi1.InactiveDate > snapdate_) )
	WHERE (i.VoidDate IS NULL OR i.VoidDate > snapdate_) 
	AND i.CreateDate <=snapdate_
	AND ii.Amount > 0
	AND ii.Quantity > 0
	AND i.Processed = 1
	AND i.Estimate = 0
GROUP BY ii.ItemID
HAVING SUM(pi1.Amount) < ROUND(MIN(ii.Amount) * MIN(ii.Quantity),2);
OPEN crReportAgingSnapshot1 FOR SELECT ma.CustomerID, MIN(ma.FirstName) AS FirstName, MIN(ma.LastName) AS LastName, MIN(ma.Company) AS Company, MIN(ma.PhoneWork) AS PhoneWork, MIN(ma.PhoneHome) AS PhoneHome,
SUM(CASE WHEN Days < 30 THEN Amount ELSE 0 END) AS Age0, 
SUM(CASE WHEN Days BETWEEN 30 AND 59 THEN Amount ELSE 0 END) AS Age30, 
SUM(CASE WHEN Days BETWEEN 60 AND 89 THEN Amount ELSE 0 END) AS Age60, 
SUM(CASE WHEN Days BETWEEN 90 AND 119 THEN Amount ELSE 0 END) AS Age90, 
SUM(CASE WHEN Days >= 120 THEN Amount ELSE 0 END) AS Age120
FROM MasterAccounts ma JOIN rad r ON (ma.CustomerID = r.CustomerID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	WHERE (GroupID_ IS NULL OR ma.GroupID =GroupID_)
	AND (OrganizationID_ IS NULL OR g.OrganizationID =OrganizationID_)
GROUP BY ma.CustomerID
ORDER BY SUM(r.Amount) DESC;
DELETE FROM rad;
END;
/

CREATE OR REPLACE PROCEDURE OnlineServerPorts (crOnlineServerPorts1 IN OUT ieatypes.CursorType) AS
BEGIN

OPEN crOnlineServerPorts1 FOR SELECT DISTINCT sp.NASIdentifier, s.Server
FROM ServerPorts sp JOIN Servers s ON (sp.ServerID = s.ServerID)
	WHERE sp.AcctStatusType IN (1,3);
END;
