CREATE OR REPLACE PROCEDURE CT_LocPhones (City_ IN VARCHAR2,CountryID_ IN INTEGER,Lat_ IN NUMERIC,Long_ IN NUMERIC,Prefix_ IN VARCHAR2,State_ IN VARCHAR2,Telco_ IN VARCHAR2) AS
BEGIN
UPDATE LocPhones SET City =City_,
	Lat =Lat_,
	"Long" =Long_,
	Telco =Telco_
	WHERE Prefix =Prefix_
	AND StateID IN (SELECT StateID FROM States WHERE CountryID =CountryID_ AND State =State_);
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO LocPhones (City,StateID,Lat,"Long",Prefix,Telco)
SELECT City_, StateID,Lat_ ,Long_ ,Prefix_ ,Telco_ 
FROM States
	WHERE CountryID =CountryID_
	AND State =State_;
END IF;
END;
/

CREATE OR REPLACE PROCEDURE CT_LocZipCodes (City_ IN VARCHAR2,CountryID_ IN INTEGER,County_ IN VARCHAR2,Lat_ IN NUMERIC,Long_ IN NUMERIC,State_ IN VARCHAR2,ZipCode_ IN VARCHAR2) AS
BEGIN
UPDATE LocZipCodes SET City =City_,
	County =County_,
	Lat =Lat_,
	"Long" =Long_
	WHERE ZipCode =ZipCode_
	AND StateID IN (SELECT StateID FROM States WHERE CountryID =CountryID_ AND State =State_);
IF (SQL%ROWCOUNT = 0) THEN
INSERT INTO LocZipCodes (City,StateID,County,Lat,"Long",ZipCode)
SELECT City_, StateID,County_ ,Lat_ ,Long_ ,ZipCode_ 
FROM States
	WHERE CountryID =CountryID_
	AND State =State_;
END IF;
END;
