CREATE PROCEDURE dbo.CT_LocPhones (@City VARCHAR(255),@CountryID INT,@Lat NUMERIC(18,4),@Long NUMERIC(18,4),@Prefix VARCHAR(255),@State VARCHAR(255),@Telco VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE LocPhones SET City = @City,
	Lat = @Lat,
	Long = @Long,
	Telco = @Telco
	WHERE Prefix = @Prefix
	AND StateID IN (SELECT StateID FROM States WHERE CountryID = @CountryID AND State = @State)
IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO LocPhones (City,StateID,Lat,Long,Prefix,Telco)
SELECT @City, StateID, @Lat, @Long, @Prefix, @Telco
FROM States
	WHERE CountryID = @CountryID
	AND State = @State
END
GO

CREATE PROCEDURE dbo.CT_LocZipCodes (@City VARCHAR(255),@CountryID INT,@County VARCHAR(255),@Lat NUMERIC(18,4),@Long NUMERIC(18,4),@State VARCHAR(255),@ZipCode VARCHAR(255)) AS
SET NOCOUNT ON
UPDATE LocZipCodes SET City = @City,
	County = @County,
	Lat = @Lat,
	Long = @Long
	WHERE ZipCode = @ZipCode
	AND StateID IN (SELECT StateID FROM States WHERE CountryID = @CountryID AND State = @State)
IF (@@ROWCOUNT = 0)
BEGIN
INSERT INTO LocZipCodes (City,StateID,County,Lat,Long,ZipCode)
SELECT @City, StateID, @County, @Lat, @Long, @ZipCode
FROM States
	WHERE CountryID = @CountryID
	AND State = @State
END
GO

