IF (SELECT COUNT(*) FROM Schedules WHERE Parameter = '{CALL MailsiteSync(''partial'')}' AND TaskName = 'query') = 0
	INSERT INTO Schedules (Parameter,LastStart,Status,Description,Interval,MaxConcurrent,StartDate,Operator,LockServerID,ScheduleServerID,TaskName,MaxSecs,Aligned,TargetSecs,Server,LastUpdate,LastStatus,LastModifyDate,LastModifyUser,Active) VALUES('{CALL IceWarpSync(''partial'')}',NULL,0,'Mailsite 7.x Mail Sync (partial)',300,1,'20040101','admin',NULL,NULL,'query',NULL,1,NULL,NULL,NULL,NULL,'20040101','admin',1)
GO

IF (SELECT COUNT(*) FROM Schedules WHERE Parameter = '{CALL MailsiteSync(''full'')}' AND TaskName = 'query') = 0
	INSERT INTO Schedules (Parameter,LastStart,Status,Description,Interval,MaxConcurrent,StartDate,Operator,LockServerID,ScheduleServerID,TaskName,MaxSecs,Aligned,TargetSecs,Server,LastUpdate,LastStatus,LastModifyDate,LastModifyUser,Active) VALUES('{CALL IceWarpSync(''daily'')}',NULL,0,'Mailsite 7.x Mail Sync (daily)',86400,1,'20040101','admin',NULL,NULL,'query',NULL,1,NULL,NULL,NULL,NULL,'20040101','admin',1)
GO

CREATE PROCEDURE dbo.MailsiteSync (@synctype VARCHAR(32)) AS 
-- Sync types
-- 'full' resynchronizes all data
-- 'daily' daily maintenance to delete unreferenced data
-- 'partial' does incremental synchronization
-- Sync Domains

SET NOCOUNT ON
DECLARE @starting DATETIME, @lastsync DATETIME
SELECT @lastsync = COALESCE(MAX(LastSyncDate),DATEADD(yy,-20,getdate())) FROM ExternalSystems WHERE ExternalSystemTypeID = -4 AND LastSyncDate IS NOT NULL
SELECT @starting = getdate()

CREATE TABLE #domains (Expired INT, Active INT, DomainId INT, MailboxId INT, Pri INT, MailName VARCHAR(64))

IF @synctype = 'full'
	SELECT @lastsync = DATEADD(yy,-20,getdate())

IF @synctype IN ('full','daily')
BEGIN
	DELETE FROM mailsite..DomainNames WHERE DomainId NOT IN (SELECT DomainID FROM Domains)
	DELETE FROM mailsite..DomainProperties WHERE DomainId NOT IN (SELECT DomainID FROM Domains)
	UPDATE mailsite..DomainNames SET DomainName = d.MailDomain
	FROM mailsite..DomainNames dn, Domains d
		WHERE dn.DomainId = d.DomainID
		AND dn.DomainName <> d.MailDomain
END

SET IDENTITY_INSERT mailsite..DomainProperties ON
INSERT INTO mailsite..DomainProperties (DomainId)
SELECT DomainID
FROM Domains
	WHERE DomainID NOT IN (SELECT DomainId FROM mailsite..DomainNames)
SET IDENTITY_INSERT mailsite..DomainProperties OFF

INSERT INTO mailsite..DomainNames (DomainId,DomainName,PrincipalName)
SELECT DomainID,MailDomain,1
FROM Domains
	WHERE DomainID NOT IN (SELECT DomainId FROM mailsite..DomainNames)

-- Sync Aliases
IF @synctype IN ('full','daily')
BEGIN
DELETE FROM mailsite..MailNames WHERE MailboxId NOT IN 
(SELECT AccountID 
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE es.ExternalSystemTypeID = -4
	AND ma.Active = 1
	AND (p.PackageID IS NULL OR p.Active = 1)
	AND sa.Active = 1)
END

INSERT INTO #domains (Expired, Active, DomainId, MailboxId, Pri, MailName)

SELECT 
CASE	WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 
	WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN 1
	WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) < getdate() THEN 1
	WHEN ma.CancelDate < getdate() THEN 1
	WHEN sa.CancelDate < getdate() THEN 1
	ELSE 0 
END AS Expired,CASE WHEN ma.Active = 1 AND sa.Active = 1 AND (p.PackageID IS NULL OR p.Active = 1) THEN 1 ELSE 0 END AS Active,
(SELECT DomainId FROM mailsite..DomainNames dn WHERE dn.DomainName = CASE WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,CHARINDEX('@',sa.Email)+1,DATALENGTH(sa.Email)) ELSE d.MailDomain END) AS DomainId,
sa.AccountID,1 AS Pri, CASE WHEN sa.Email LIKE '%_@_%' THEN SUBSTRING(sa.Email,1,CHARINDEX('@',sa.Email)-1) WHEN sa.Login <> '' THEN sa.Login END
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	WHERE es.ExternalSystemTypeID = -4
	AND (@synctype = 'full' OR (sa.LastModifyDate >= @lastsync OR ma.LastModifyDate >= @lastsync))
	AND (sa.Login IS NOT NULL OR sa.Email IS NOT NULL)

UNION ALL

SELECT 
CASE	WHEN ma.OverLimit > 0 AND ma.PendingBalance > ma.OverLimit THEN 1 
	WHEN g.Active <= 0 OR p.Active <= 0 OR sa.Active <= 0 OR ma.Active <= 0 THEN 1
	WHEN sa.ExpireDate IS NOT NULL AND DATEADD(dd,CASE WHEN bc.AutoBill IN (1,0) THEN 1 ELSE 0 END + sa.Extension + COALESCE(ma.OverDue,0),sa.ExpireDate) < getdate() THEN 1
	WHEN ma.CancelDate < getdate() THEN 1
	WHEN sa.CancelDate < getdate() THEN 1
	ELSE 0 
END AS Expired,CASE WHEN ma.Active = 1 AND sa.Active = 1 AND (p.PackageID IS NULL OR p.Active = 1) THEN 1 ELSE 0 END AS Active,
(SELECT DomainId FROM mailsite..DomainNames dn WHERE dn.DomainName = CASE WHEN al.Alias LIKE '%_@_%' THEN SUBSTRING(al.Alias,CHARINDEX('@',al.Alias)+1,DATALENGTH(al.Alias)) ELSE d.MailDomain END),
sa.AccountID,0 AS Pri, CASE WHEN al.Alias LIKE '%_@_%' THEN SUBSTRING(al.Alias,1,CHARINDEX('@',al.Alias)-1) ELSE al.Alias END
FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN Domains d ON (sa.DomainID = d.DomainID)
	JOIN Groups g ON (ma.GroupID = g.GroupID)
	JOIN BillingCycles bc ON (ma.BillingCycleID = bc.BillingCycleID)
	JOIN ExternalSystemAccountTypes esat ON (sa.AccountTypeID = esat.AccountTypeID)
	JOIN ExternalSystems es ON (esat.ExternalSystemID = es.ExternalSystemID)
	LEFT JOIN Packages p ON (sa.PackageID = p.PackageID)
	JOIN Aliases al ON (sa.AccountID = al.AccountID)
	WHERE es.ExternalSystemTypeID = -4
	AND (@synctype = 'full' OR (sa.LastModifyDate >= @lastsync OR ma.LastModifyDate >= @lastsync))
	AND al.Alias <> ''

DELETE FROM #domains WHERE DomainId IS NULL

SET IDENTITY_INSERT mailsite..MailboxProperties ON
INSERT INTO mailsite..MailboxProperties (MailboxId,City,Country,FullName,Organization,PostCode,State,GivenName,Surname,Telephone,Facsimile,Password,ForwardTo,Street,ServiceExpress,ServiceImap,ServicePop,ServiceWconsole,ServiceLdap,ServiceMailma,ServiceSmtp)

SELECT 
sa.AccountID,ma.City, c.Abbr2 AS Country, sa.FirstName + ' ' + sa.LastName AS FullName, ma.Company AS Organization, ma.Zip AS PostCode, s.State, 
sa.FirstName AS GivenName, sa.LastName AS Surname, sa.PhoneHome AS Telephone, ma.PhoneFax AS Facsimile, sa.Password,
(SELECT MIN(Forward) FROM Forwards f WHERE f.Forward LIKE '%_@_%' AND f.AccountID = sa.AccountID),
ma.Address1 AS Street,
CASE WHEN d.Expired = 1 THEN 0 ELSE 1 END AS ServiceExpress,
CASE WHEN d.Expired = 1 THEN 0 ELSE 1 END AS ServiceImap,
CASE WHEN d.Expired = 1 THEN 0 ELSE 1 END AS ServicePop,
CASE WHEN d.Expired = 1 THEN 0 ELSE 1 END AS ServiceWconsole,
0 AS ServiceLdap,
1 AS ServiceMailma,
1 AS ServiceSmtp

FROM MasterAccounts ma JOIN SubAccounts sa ON (ma.CustomerID = sa.CustomerID)
	JOIN #domains d ON (sa.AccountID = d.MailboxId)
	LEFT JOIN Countries c ON (ma.CountryID = c.CountryID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND d.Pri = 1
	AND sa.AccountID NOT IN (SELECT MailboxId FROM mailsite..MailboxProperties)

SET IDENTITY_INSERT mailsite..MailboxProperties OFF

UPDATE mailsite..MailboxProperties SET City = ma.City,
Country = c.Abbr2,
FullName = sa.FirstName + ' ' + sa.LastName,
Organization = ma.Company,
PostCode = ma.Zip,
State = s.State,
Street = ma.Address1,
GivenName = sa.FirstName,
Surname = sa.LastName,
Telephone = sa.PhoneHome,
Facsimile = ma.PhoneFax,
Password = sa.Password,
ForwardTo = (SELECT MIN(Forward) FROM Forwards f WHERE f.Forward LIKE '%_@_%' AND f.AccountID = sa.AccountID),
ServiceExpress = CASE WHEN d.Expired = 1 THEN 0 ELSE 1 END,
ServiceImap = CASE WHEN d.Expired = 1 THEN 0 ELSE 1 END,
ServicePop = CASE WHEN d.Expired = 1 THEN 0 ELSE 1 END,
ServiceWconsole = CASE WHEN d.Expired = 1 THEN 0 ELSE 1 END

FROM mailsite..MailboxProperties mp JOIN #domains d ON (mp.MailboxId = d.MailboxId)
	JOIN SubAccounts sa ON (d.MailboxId = sa.AccountID)
	JOIN MasterAccounts ma ON (sa.CustomerID = ma.CustomerID)
	LEFT JOIN Countries c ON (ma.CountryID = c.CountryID)
	LEFT JOIN States s ON (ma.StateID = s.StateID)
	WHERE ma.Active = 1
	AND sa.Active = 1
	AND d.Pri = 1

DELETE FROM mailsite..MailNames 
FROM mailsite..MailNames mn, #domains d
	WHERE mn.MailboxId = d.MailboxId
	AND ((mn.MailName NOT IN (SELECT d2.MailName FROM #domains d2 WHERE d2.MailboxId = mn.MailboxId))
		OR (d.Active = 0))

INSERT INTO mailsite..MailNames (MailName,DomainId,MailboxId,PrincipalName)
SELECT MailName,DomainId,MailboxId,Pri
FROM #domains d 
	WHERE NOT EXISTS (SELECT * FROM mailsite..MailNames mn WHERE d.DomainId = mn.DomainId AND d.MailboxId = mn.MailboxId AND d.MailName = mn.MailName)
	AND d.Active = 1

UPDATE ExternalSystems SET LastSyncDate = @starting WHERE ExternalSystemTypeID = -4

DROP TABLE #domains
GO

