#!/usr/bin/perl

$emerwebini = '/usr/local/emerald/emerweb.ini';
$scheduleini = '/usr/local/emerald/schedule.ini';

&fix_emerweb;
if (-e $scheduleini)
	{
	&fix_schedule;
	}

sub fix_schedule
{
open(DATA,$scheduleini) || die "Can't open $scheduleini for read $!";
@data = <DATA>;
close(DATA);

foreach(@data)
	{
	s/\r|\n//g;
	if (/^LogFile=/i)
		{
		$have_logfile = 1;
		}
	if (/^TaskDir=/i)
		{
		$have_taskdir = 1;
		}
	if (/^TaskLibs=/i)
		{
		$_ = "";
		}
	}

if (!$have_logfile)
	{
	push(@data,'LogFile=/usr/local/emerald/log/emerclock_YYMM.log');
	}
if (!$have_taskdir)
	{
	push(@data,'TaskDir=/usr/local/emerald');
	}

push(@data,'TaskLibs=gbe.so');

open(DATA,">$scheduleini") || die "Can't open $emerwebini for write $!";
foreach(@data)
	{
	if ($_ ne "")
		{
		print DATA "$_\n";
		}
	}
close(DATA);
}

sub fix_emerweb
{
open(DATA,$emerwebini) || die "Can't open $emerwebini for read $!";
@data = <DATA>;
close(DATA);

foreach(@data)
	{
	s/\r|\n//g;
	s/^SQLDir=.*//gi;
	s/^PackageDirectory=.*//gi;
	s/^ServerRoot=.*//gi;
	if (/^dll=/i)
		{
		$have_dll = 1;
		}
	if (/^execdlls=/i)
		{
		$have_exec = 1;
		}
	if (/^serverroot=/i)
		{
		$have_sroot = 1;
		}
	}

push(@data,'SQLDir=/usr/local/emerald/sql');
push(@data,'PackageDirectory=/usr/local/emerald/web/package');
if (!$have_dll)
	{
	push(@data,'dll=/usr/local/emerald/web/emerweb.so');
	}
if (!$have_exec)
	{
	push(@data,'ExecDlls=/usr/local/emerald/gbe.so');
	}
if (!$have_sroot)
	{
	push(@data,'ServerRoot=/usr/local/emerald/web');
	}

open(DATA,">$emerwebini") || die "Can't open $emerwebini for write $!";
foreach(@data)
	{
	if ($_ ne "")
		{
		print DATA "$_\n";
		}
	}
close(DATA);
}

